/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ReplicaStatusRequest;
import org.apache.kafka.common.requests.ReplicaStatusResponse;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00192Aa\u0001\u0003\u0001\u0013!)a\u0002\u0001C\u0001\u001f!)\u0011\u0003\u0001C\u0001%\tA\"+\u001a9mS\u000e\f7\u000b^1ukN\u0014V-];fgR$Vm\u001d;\u000b\u0005\u00151\u0011AB:feZ,'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-aQ\"\u0001\u0003\n\u00055!!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0001\u0002CA\u0006\u0001\u0003%#Xm\u001d;SKBd\u0017nY1Ti\u0006$Xo\u001d*fcV,7\u000f\u001e#ve&tw\rU1si&$\u0018n\u001c8SK\u000e|g/\u001a:z\u0003\u001a$XM]+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u000b\u0002'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t!QK\\5uQ\t\u0011!\u0004\u0005\u0002\u001cI5\tAD\u0003\u0002\u001e=\u0005\u0019\u0011\r]5\u000b\u0005}\u0001\u0013a\u00026va&$XM\u001d\u0006\u0003C\t\nQA[;oSRT\u0011aI\u0001\u0004_J<\u0017BA\u0013\u001d\u0005\u0011!Vm\u001d;")
public class ReplicaStatusRequestTest
extends BaseRequestTest {
    @Test
    public void testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "test-topic";
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), new Properties());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        scala.collection.immutable.Set replicas = this.zkClient().getReplicasForPartition(topicPartition).toSet();
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ReplicaStatusRequestTest.$anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$2)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        Partition partition = ((KafkaServer)this.servers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusRequestTest.$anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(leader, x$4))).get()).replicaManager().getPartitionOrException(topicPartition);
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), topic, 10, -1);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusRequestTest.$anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(leader, x$5))).get()).replicaManager().getPartitionOrException(topicPartition), LeaderRecoveryState.RECOVERED);
        this.sendReplicaStatusRequestAndValidateResponse$1(leader, Errors.NONE, topicPartition, topic, partition);
        this.sendReplicaStatusRequestAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, topicPartition, topic, partition);
        this.sendReplicaStatusRequestAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, topicPartition, topic, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusRequestTest.$anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$8(leader, x$6))).get()).replicaManager().getPartitionOrException(topicPartition), LeaderRecoveryState.RECOVERING);
        this.sendReplicaStatusRequestAndValidateResponse$1(leader, Errors.NOT_LEADER_OR_FOLLOWER, topicPartition, topic, partition);
        this.sendReplicaStatusRequestAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, topicPartition, topic, partition);
        this.sendReplicaStatusRequestAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, topicPartition, topic, partition);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusRequestTest.$anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$9(leader, x$7))).get()).replicaManager().getPartitionOrException(topicPartition), LeaderRecoveryState.RECOVERED);
        this.sendReplicaStatusRequestAndValidateResponse$1(leader, Errors.NONE, topicPartition, topic, partition);
        this.sendReplicaStatusRequestAndValidateResponse$1(follower, Errors.NOT_LEADER_OR_FOLLOWER, topicPartition, topic, partition);
        this.sendReplicaStatusRequestAndValidateResponse$1(nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, topicPartition, topic, partition);
    }

    public static final /* synthetic */ int $anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(int leader$1, KafkaServer x$4) {
        return x$4.config().brokerId() == leader$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(Partition partition$1, ReplicaStatusResponseData.ReplicaStatusReplicaResponse replica) {
        if (replica.isLeader()) {
            Assertions.assertEquals((long)partition$1.logStartOffset(), (long)replica.logStartOffset(), (String)"Unexpected log start offset at leader");
            Assertions.assertEquals((long)((AbstractLog)partition$1.log().get()).logEndOffset(), (long)replica.logEndOffset(), (String)"Unexpected log end offset at leader");
        }
    }

    private final void sendReplicaStatusRequestAndValidateResponse$1(int brokerId, Errors error, TopicPartition topicPartition$1, String topic$1, Partition partition$1) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.REPLICA_STATUS.oldestVersion()), (int)ApiKeys.REPLICA_STATUS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ver -> {
            ReplicaStatusRequest request = new ReplicaStatusRequest.Builder(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$1}))).asJava(), false).build((short)ver);
            ReplicaStatusResponse replicaStatusResponse = (ReplicaStatusResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ReplicaStatusResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            Assertions.assertEquals((int)1, (int)replicaStatusResponse.data().topics().size(), (String)"Unexpected number of topics in response");
            Assertions.assertEquals((Object)topic$1, (Object)((ReplicaStatusResponseData.ReplicaStatusTopicResponse)replicaStatusResponse.data().topics().get(0)).name(), (String)"Unexpected topic in response");
            Assertions.assertEquals((int)1, (int)((ReplicaStatusResponseData.ReplicaStatusTopicResponse)replicaStatusResponse.data().topics().get(0)).partitions().size(), (String)"Unexpected number of partitions in response");
            Assertions.assertEquals((int)0, (int)((ReplicaStatusResponseData.ReplicaStatusPartitionResponse)((ReplicaStatusResponseData.ReplicaStatusTopicResponse)replicaStatusResponse.data().topics().get(0)).partitions().get(0)).partitionIndex(), (String)"Unexpected partition index");
            Assertions.assertEquals((short)error.code(), (short)((ReplicaStatusResponseData.ReplicaStatusPartitionResponse)((ReplicaStatusResponseData.ReplicaStatusTopicResponse)replicaStatusResponse.data().topics().get(0)).partitions().get(0)).errorCode(), (String)"Unexpected error code for partition");
            if (error.equals(Errors.NONE)) {
                Assertions.assertEquals((int)2, (int)((ReplicaStatusResponseData.ReplicaStatusPartitionResponse)((ReplicaStatusResponseData.ReplicaStatusTopicResponse)replicaStatusResponse.data().topics().get(0)).partitions().get(0)).replicas().size(), (String)"Unexpected number of replicas");
                CollectionConverters$.MODULE$.ListHasAsScala(((ReplicaStatusResponseData.ReplicaStatusPartitionResponse)((ReplicaStatusResponseData.ReplicaStatusTopicResponse)replicaStatusResponse.data().topics().get(0)).partitions().get(0)).replicas()).asScala().foreach((Function1 & Serializable)replica -> {
                    ReplicaStatusRequestTest.$anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(partition$1, replica);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            Assertions.assertNull((Object)((ReplicaStatusResponseData.ReplicaStatusPartitionResponse)((ReplicaStatusResponseData.ReplicaStatusTopicResponse)replicaStatusResponse.data().topics().get(0)).partitions().get(0)).replicas(), (String)"Unexpected number of replicas");
        });
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(int leader$1, KafkaServer x$5) {
        return x$5.config().brokerId() == leader$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$8(int leader$1, KafkaServer x$6) {
        return x$6.config().brokerId() == leader$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatusRequestDuringPartitionRecoveryAfterUncleanLeaderElection$9(int leader$1, KafkaServer x$7) {
        return x$7.config().brokerId() == leader$1;
    }
}

