/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.cluster.Partition;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.RequestHandlerHelper$;
import kafka.server.link.ClusterLinkFactory;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator$;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.common.errors.InvalidBrokerRemovalException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsRequestData;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AlterBrokerReplicaExclusionsRequest;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0011\u0019!\u0005\u0001)A\u0005}!9Q\t\u0001b\u0001\n\u00031\u0005BB)\u0001A\u0003%q\tC\u0004S\u0001\t\u0007I\u0011A*\t\ru\u0003\u0001\u0015!\u0003U\u0011\u001dq\u0006A1A\u0005\u0002}CaA\u001a\u0001!\u0002\u0013\u0001\u0007bB4\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007U\u0002\u0001\u000b\u0011B5\t\u000f-\u0004!\u0019!C\u0001Y\"1A\u000f\u0001Q\u0001\n5Dq!\u001e\u0001C\u0002\u0013\u0005a\u000f\u0003\u0004~\u0001\u0001\u0006Ia\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0001w\u0011\u0019y\b\u0001)A\u0005o\"A\u0011\u0011\u0001\u0001C\u0002\u0013\u0005a\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011B<\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005\u001d\u0001bBA\u001a\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003o\u0001A\u0011AA\u0004\u0011\u001d\tY\u0004\u0001C\u0001\u0003\u000fAq!a\u0010\u0001\t\u0003\t9\u0001C\u0004\u0002D\u0001!\t!a\u0002\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002\b!9\u00111\n\u0001\u0005\n\u00055\u0003bBAD\u0001\u0011%\u0011\u0011\u0012\u0002\u0019%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0011\u0016d\u0007/\u001a:UKN$(B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002C\u0005\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN]\u000b\u0002gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006OJ|W\u000f\u001d\u0006\u0003q\r\n1bY8pe\u0012Lg.\u0019;pe&\u0011!(\u000e\u0002\u0011\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\f\u0011c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:!\u00039!\bP\\\"p_J$\u0017N\\1u_J,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003^\n1\u0002\u001e:b]N\f7\r^5p]&\u00111\t\u0011\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u0006yA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014\b%\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014X#A$\u0011\u0005!seBA%M\u001b\u0005Q%BA&\"\u0003\u0011a\u0017N\\6\n\u00055S\u0015AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefL!a\u0014)\u0003\u00171Kgn['b]\u0006<WM\u001d\u0006\u0003\u001b*\u000b1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\n1\u0005^5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;pe>\u0003H/F\u0001U!\rASkV\u0005\u0003-&\u0012aa\u00149uS>t\u0007C\u0001-\\\u001b\u0005I&B\u0001.$\u0003\u0011!\u0018.\u001a:\n\u0005qK&\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\fA\u0005^5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;pe>\u0003H\u000fI\u0001(E\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0007>|'\u000fZ5oCR|'/F\u0001a!\t\tG-D\u0001c\u0015\t\u0019\u0017,A\u000bcC\u000e\\W\u000f]8cU\u0016\u001cG\u000f\\5gK\u000eL8\r\\3\n\u0005\u0015\u0014'a\n\"bG.,\bo\u00142kK\u000e$H*\u001b4fGf\u001cG.Z'b]\u0006<WM]\"p_J$\u0017N\\1u_J\f\u0001FY1dWV\u0004xJ\u00196fGRd\u0015NZ3ds\u000edW-T1oC\u001e,'oQ8pe\u0012Lg.\u0019;pe\u0002\n!FY1dWV\u0004xJ\u00196fGRd\u0015NZ3ds\u000edW-T1oC\u001e,'oQ8pe\u0012Lg.\u0019;pe>\u0003H/F\u0001j!\rAS\u000bY\u0001,E\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0007>|'\u000fZ5oCR|'o\u00149uA\u0005\u0019\u0012/^8uC\u000e{wN\u001d3j]\u0006$xN](qiV\tQ\u000eE\u0002)+:\u0004\"a\u001c:\u000e\u0003AT!!]\u001c\u0002\u000bE,x\u000e^1\n\u0005M\u0004(\u0001E)v_R\f7i\\8sI&t\u0017\r^8s\u0003Q\tXo\u001c;b\u0007>|'\u000fZ5oCR|'o\u00149uA\u0005Y\u0001/\u0019:uSRLwN\\02+\u00059\bC\u0001=|\u001b\u0005I(B\u0001>$\u0003\u001d\u0019G.^:uKJL!\u0001`=\u0003\u0013A\u000b'\u000f^5uS>t\u0017\u0001\u00049beRLG/[8o?F\u0002\u0013a\u00039beRLG/[8o?J\nA\u0002]1si&$\u0018n\u001c8`e\u0001\n1\u0002]1si&$\u0018n\u001c8`g\u0005a\u0001/\u0019:uSRLwN\\04A\u0005)1/\u001a;vaR\u0011\u0011\u0011\u0002\t\u0004Q\u0005-\u0011bAA\u0007S\t!QK\\5uQ\r1\u0012\u0011\u0003\t\u0005\u0003'\t)#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\r\t\u0007/\u001b\u0006\u0005\u00037\ti\"A\u0004kkBLG/\u001a:\u000b\t\u0005}\u0011\u0011E\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003G\t1a\u001c:h\u0013\u0011\t9#!\u0006\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A!uKN$()Y2lkB|%M[3di2Kg-Z2zG2,W*\u00198bO\u0016\u00148\u000b^1siN<\u0006.\u001a8Ce>\\WM]!tgVlWm\u001d'fC\u0012,'o\u001d5ja\"\u001aq#!\f\u0011\t\u0005M\u0011qF\u0005\u0005\u0003c\t)B\u0001\u0003UKN$\u0018A\u0010;fgR\u0014\u0015mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u001cFo\u001c9t/\",gN\u0011:pW\u0016\u0014()Z2p[\u0016\u001chi\u001c7m_^,'\u000fK\u0002\u0019\u0003[\t\u0011\b^3tiZ\u000bG.\u001b3bi\u0016\fE\u000e^3s\u000bb\u001cG.^:j_:\u0014V-];fgR$\u0006N]8xg&3\u0017J\u001c<bY&$'I]8lKJLEm\u001d\u0015\u00043\u00055\u0012!\u0010;fgR4\u0016\r\\5eCR,\u0017\t\u001c;fe\u0016C8\r\\;tS>t'+Z9vKN$H\u000b\u001b:poNLe-\u00138wC2LG-\u0012=dYV\u001c\u0018n\u001c8UsB,\u0007f\u0001\u000e\u0002.\u00051D/Z:u-\u0006d\u0017\u000eZ1uK\u0006cG/\u001a:Fq\u000edWo]5p]J+\u0017/^3tiRC'o\\<t\u0013\u001aLeN^1mS\u0012\u0014V-Y:p]\"\u001a1$!\f\u0002WQ,7\u000f\u001e,bY&$\u0017\r^3SK6|g/\u00197SKF,Xm\u001d;UQJ|wo]%g\u001d>\u0014%o\\6feND3\u0001HA\u0017\u0003a\"Xm\u001d;WC2LG-\u0019;f%\u0016lwN^1m%\u0016\fX/Z:u)\"\u0014xn^:JMVs'/\u001a9sKN,g\u000e^1cY\u0016\u0014%o\\6feND3!HA\u0017\u0003A\nG\u000e^3s\u0005J|7.\u001a:SKBd\u0017nY1Fq\u000edWo]5p]N\u0014V-];fgR<\u0016\u000e\u001e5Ce>\\WM]%egR!\u0011qJA3!\u0011\t\t&!\u0019\u000e\u0005\u0005M#\u0002BA+\u0003/\n\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u00033\nY&\u0001\u0004d_6lwN\u001c\u0006\u0004I\u0005u#\u0002BA0\u0003C\ta!\u00199bG\",\u0017\u0002BA2\u0003'\u00121%\u00117uKJ\u0014%o\\6feJ+\u0007\u000f\\5dC\u0016C8\r\\;tS>t7OU3rk\u0016\u001cH\u000fC\u0004\u0002hy\u0001\r!!\u001b\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001c\bCBA6\u0003w\n\tI\u0004\u0003\u0002n\u0005]d\u0002BA8\u0003kj!!!\u001d\u000b\u0007\u0005MT%\u0001\u0004=e>|GOP\u0005\u0002U%\u0019\u0011\u0011P\u0015\u0002\u000fA\f7m[1hK&!\u0011QPA@\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005e\u0014\u0006E\u0002)\u0003\u0007K1!!\"*\u0005\rIe\u000e^\u0001$C2$XM\u001d\"s_.,'OU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0011\ty%a#\t\u000f\u00055u\u00041\u0001\u0002\u0010\u0006YQ\r_2mkNLwN\\(q!\u0019\tY'a\u001f\u0002\u0012B!\u00111SAM\u001b\t\t)J\u0003\u0003\u0002Z\u0005]%b\u0001\u0012\u0002\\%!\u00111TAK\u0005]\tE\u000e^3s%\u0016\u0004H.[2b\u000bb\u001cG.^:j_:|\u0005\u000f")
public class RequestHandlerHelperTest {
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private final ClusterLinkFactory.LinkManager clusterLinkManager = (ClusterLinkFactory.LinkManager)Mockito.mock(ClusterLinkFactory.LinkManager.class);
    private final Option<TierDeletedPartitionsCoordinator> tierDeletedPartitionsCoordinatorOpt = new Some(Mockito.mock(TierDeletedPartitionsCoordinator.class));
    private final BackupObjectLifecycleManagerCoordinator backupObjectLifecycleManagerCoordinator = (BackupObjectLifecycleManagerCoordinator)Mockito.mock(BackupObjectLifecycleManagerCoordinator.class);
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt = new Some((Object)this.backupObjectLifecycleManagerCoordinator());
    private final Option<QuotaCoordinator> quotaCoordinatorOpt = new Some(Mockito.mock(QuotaCoordinator.class));
    private final Partition partition_1 = (Partition)Mockito.mock(Partition.class);
    private final Partition partition_2 = (Partition)Mockito.mock(Partition.class);
    private final Partition partition_3 = (Partition)Mockito.mock(Partition.class);

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public Option<TierDeletedPartitionsCoordinator> tierDeletedPartitionsCoordinatorOpt() {
        return this.tierDeletedPartitionsCoordinatorOpt;
    }

    public BackupObjectLifecycleManagerCoordinator backupObjectLifecycleManagerCoordinator() {
        return this.backupObjectLifecycleManagerCoordinator;
    }

    public Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt() {
        return this.backupObjectLifecycleManagerCoordinatorOpt;
    }

    public Option<QuotaCoordinator> quotaCoordinatorOpt() {
        return this.quotaCoordinatorOpt;
    }

    public Partition partition_1() {
        return this.partition_1;
    }

    public Partition partition_2() {
        return this.partition_2;
    }

    public Partition partition_3() {
        return this.partition_3;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.partition_1().topic()).thenReturn((Object)"_confluent-tier-state");
        Mockito.when((Object)this.partition_2().topic()).thenReturn((Object)"_confluent-tier-state");
        Mockito.when((Object)this.partition_3().topic()).thenReturn((Object)"blah");
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_1().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_2().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 1)));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.partition_3().partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 2)));
    }

    @Test
    public void testBackupObjectLifecycleManagerStartsWhenBrokerAssumesLeadership() {
        List updatedLeaders = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{this.partition_1()}));
        List updatedFollowers = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{this.partition_2(), this.partition_3()}));
        RequestHandlerHelper$.MODULE$.onLeadershipChange(this.groupCoordinator(), this.txnCoordinator(), this.clusterLinkManager(), this.tierDeletedPartitionsCoordinatorOpt(), this.backupObjectLifecycleManagerCoordinatorOpt(), this.quotaCoordinatorOpt(), (Iterable)updatedLeaders, (Iterable)updatedFollowers);
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onElection(this.partition_1().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onResignation(this.partition_2().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)0))).onResignation(this.partition_3().partitionId());
    }

    @Test
    public void testBackupObjectLifecycleManagerStopsWhenBrokerBecomesFollower() {
        List updatedLeaders = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{this.partition_2(), this.partition_3()}));
        List updatedFollowers = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{this.partition_1()}));
        RequestHandlerHelper$.MODULE$.onLeadershipChange(this.groupCoordinator(), this.txnCoordinator(), this.clusterLinkManager(), this.tierDeletedPartitionsCoordinatorOpt(), this.backupObjectLifecycleManagerCoordinatorOpt(), this.quotaCoordinatorOpt(), (Iterable)updatedLeaders, (Iterable)updatedFollowers);
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onElection(this.partition_2().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)0))).onElection(this.partition_3().partitionId());
        ((BackupObjectLifecycleManagerCoordinator)Mockito.verify((Object)this.backupObjectLifecycleManagerCoordinator(), (VerificationMode)Mockito.times((int)1))).onResignation(this.partition_1().partitionId());
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidBrokerIds() {
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> {
            AlterBrokerReplicaExclusionsRequest emptyReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)package$.MODULE$.List().empty());
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(emptyReq);
        });
        Assertions.assertThrows(UnrepresentableBrokerIdException.class, () -> {
            AlterBrokerReplicaExclusionsRequest unrepresentableBrokersReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, -100}))));
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(unrepresentableBrokersReq);
        });
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> {
            AlterBrokerReplicaExclusionsRequest duplicateBrokersReq = this.alterBrokerReplicaExclusionsRequestWithBrokerIds((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 1}))));
            RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(duplicateBrokersReq);
        });
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidExclusionType() {
        ListBuffer exclusionOps = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        exclusionOps.$plus$eq((Object)new AlterReplicaExclusionOp(1, "reason", ExclusionOp.OpType.SET));
        AlterBrokerReplicaExclusionsRequest validRequest = this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)exclusionOps.toList());
        RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(validRequest);
        exclusionOps.$plus$eq((Object)new AlterReplicaExclusionOp(1, "reason", ExclusionOp.OpType.UNKNOWN));
        AlterBrokerReplicaExclusionsRequest invalidRequest = this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)exclusionOps.toList());
        Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(invalidRequest));
    }

    @Test
    public void testValidateAlterExclusionRequestThrowsIfInvalidReason() {
        String chars130Reason = "TestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTestTe";
        ((IterableOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".", chars130Reason, "\\"}))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)invalidReason -> {
            AlterReplicaExclusionOp op = new AlterReplicaExclusionOp(1, invalidReason, ExclusionOp.OpType.SET);
            return (InvalidBrokerReplicaExclusionException)Assertions.assertThrows(InvalidBrokerReplicaExclusionException.class, () -> RequestHandlerHelper$.MODULE$.validateAlterBrokerReplicaExclusionRequest(this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterReplicaExclusionOp[]{op}))))));
        });
    }

    @Test
    public void testValidateRemovalRequestThrowsIfNoBrokers() {
        RemoveBrokersRequest request = new RemoveBrokersRequest.Builder(Collections.emptySet(), true).build((short)1);
        Assertions.assertThrows(InvalidBrokerRemovalException.class, () -> RequestHandlerHelper$.MODULE$.validateRemoveBrokersRequest(request));
    }

    @Test
    public void testValidateRemovalRequestThrowsIfUnrepresentableBrokers() {
        RemoveBrokersRequestData.BrokerId brokerId = new RemoveBrokersRequestData.BrokerId().setBrokerId(-1);
        RemoveBrokersRequest request = new RemoveBrokersRequest.Builder(Collections.singleton(brokerId), true).build((short)1);
        Assertions.assertThrows(UnrepresentableBrokerIdException.class, () -> RequestHandlerHelper$.MODULE$.validateRemoveBrokersRequest(request));
    }

    private AlterBrokerReplicaExclusionsRequest alterBrokerReplicaExclusionsRequestWithBrokerIds(List<Object> brokerIds) {
        return this.alterBrokerReplicaExclusionsRequest((List<AlterReplicaExclusionOp>)brokerIds.map((Function1 & Serializable)x$1 -> RequestHandlerHelperTest.$anonfun$alterBrokerReplicaExclusionsRequestWithBrokerIds$1(BoxesRunTime.unboxToInt((Object)x$1))));
    }

    private AlterBrokerReplicaExclusionsRequest alterBrokerReplicaExclusionsRequest(List<AlterReplicaExclusionOp> exclusionOp2) {
        AlterBrokerReplicaExclusionsRequestData requestData = new AlterBrokerReplicaExclusionsRequestData();
        java.util.List exclusions = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)exclusionOp2.map((Function1 & Serializable)exclusionOp -> new AlterBrokerReplicaExclusionsRequestData.BrokerExclusion().setBrokerId(exclusionOp.brokerId()).setExclusionOperationCode(exclusionOp.opType().id()).setReason(exclusionOp.reason()))).asJava();
        return new AlterBrokerReplicaExclusionsRequest(requestData.setBrokersToExclude(exclusions), ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS.latestVersion());
    }

    public static final /* synthetic */ AlterReplicaExclusionOp $anonfun$alterBrokerReplicaExclusionsRequestWithBrokerIds$1(int x$1) {
        return new AlterReplicaExclusionOp(x$1, "reason", ExclusionOp.OpType.SET);
    }
}

