/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\tUc\u0001\u0002\u0012$\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u0004>\u0001\u0001\u0006I!\u000e\u0005\b}\u0001\u0011\r\u0011\"\u00015\u0011\u0019y\u0004\u0001)A\u0005k!9\u0001\t\u0001b\u0001\n\u0003\t\u0005B\u0002'\u0001A\u0003%!\tC\u0004N\u0001\t\u0007I\u0011A!\t\r9\u0003\u0001\u0015!\u0003C\u0011\u001dy\u0005A1A\u0005\u0002ACaa\u0016\u0001!\u0002\u0013\t\u0006b\u0002-\u0001\u0001\u0004%\t!\u0017\u0005\bC\u0002\u0001\r\u0011\"\u0001c\u0011\u0019A\u0007\u0001)Q\u00055\")\u0011\u000e\u0001C!U\")q\u000e\u0001C!a\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!a!\u0001\t\u0003\t)\tC\u0004\u0002\u0010\u0002!I!!%\t\u0011\u0005-\u0007\u0001)C\u0005\u0003\u001bDq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002d\u0002!\t!!:\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9!1\u0004\u0001\u0005\u0002\tu\u0001b\u0002B\u0014\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005oAqAa\u0010\u0001\t\u0013\t\t\u000fC\u0004\u0003B\u0001!I!!9\t\u000f\t\r\u0003\u0001\"\u0003\u0003F\t\u00112+\u001a:wKJ\u001c\u0006.\u001e;e_^tG+Z:u\u0015\t!S%\u0001\u0004tKJ4XM\u001d\u0006\u0002M\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001*!\tQS&D\u0001,\u0015\taS%A\u0006j]R,wM]1uS>t\u0017B\u0001\u0018,\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u00012!\t\u0011\u0004!D\u0001$\u0003\u0011Awn\u001d;\u0016\u0003U\u0002\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\t1\fgn\u001a\u0006\u0002u\u0005!!.\u0019<b\u0013\tatG\u0001\u0004TiJLgnZ\u0001\u0006Q>\u001cH\u000fI\u0001\u0006i>\u0004\u0018nY\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u000bM,g\u000e^\u0019\u0016\u0003\t\u00032a\u0011&6\u001b\u0005!%BA#G\u0003%IW.\\;uC\ndWM\u0003\u0002H\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013#\u0003\t1K7\u000f^\u0001\u0007g\u0016tG/\r\u0011\u0002\u000bM,g\u000e\u001e\u001a\u0002\rM,g\u000e\u001e\u001a!\u0003a\u0001(o\u001c9t)>\u001c\u0005.\u00198hKV\u0003xN\u001c*fgR\f'\u000f^\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011A+O\u0001\u0005kRLG.\u0003\u0002W'\nQ\u0001K]8qKJ$\u0018.Z:\u00023A\u0014x\u000e]:U_\u000eC\u0017M\\4f+B|gNU3ti\u0006\u0014H\u000fI\u0001\faJLwN]\"p]\u001aLw-F\u0001[!\rYFLX\u0007\u0002\u0011&\u0011Q\f\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Iz\u0016B\u00011$\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001fA\u0014\u0018n\u001c:D_:4\u0017nZ0%KF$\"a\u00194\u0011\u0005m#\u0017BA3I\u0005\u0011)f.\u001b;\t\u000f\u001dl\u0011\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002\u0019A\u0014\u0018n\u001c:D_:4\u0017n\u001a\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\u001b\t\u0004Y6tV\"\u0001$\n\u000594%aA*fc\u0006)1/\u001a;VaR\u00111-\u001d\u0005\u0006eB\u0001\ra]\u0001\ti\u0016\u001cH/\u00138g_B\u0011A/`\u0007\u0002k*\u0011ao^\u0001\u0004CBL'B\u0001=z\u0003\u001dQW\u000f]5uKJT!A_>\u0002\u000b),h.\u001b;\u000b\u0003q\f1a\u001c:h\u0013\tqXO\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0001\u0012\u0011\u0001\t\u0004i\u0006\r\u0011bAA\u0003k\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002#Q,7\u000f^\"mK\u0006t7\u000b[;uI><h\u000eF\u0002d\u0003\u0017Aq!!\u0004\u0012\u0001\u0004\ty!\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005m\u0001cAA\u000b\u00116\u0011\u0011q\u0003\u0006\u0004\u000339\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u001e!\u000ba\u0001\u0015:fI\u00164\u0017b\u0001\u001f\u0002\")\u0019\u0011Q\u0004%)\u000fE\t)#!\u000e\u00028A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005=r/\u0001\u0004qCJ\fWn]\u0005\u0005\u0003g\tICA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003s\ti$\t\u0002\u0002<\u0005\u0011!p[\u0011\u0003\u0003\u007f\tQa\u001b:bMRDs!EA\"\u0003\u0017\ni\u0005\u0005\u0003\u0002F\u0005\u001dSBAA\u0017\u0013\u0011\tI%!\f\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA(\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001$i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\3e'R\f'\u000f^;q)\r\u0019\u0017Q\u000b\u0005\b\u0003\u001b\u0011\u0002\u0019AA\bQ\u001d\u0011\u0012QEA\u001b\u00033bC!!\u000f\u0002>!:!#a\u0011\u0002L\u00055\u0013a\r;fgR\u001cE.Z1o'\",H\u000fZ8x]\u00063G/\u001a:GC&dW\rZ*uCJ$X\u000f\u001d#vKR{7i\u001c:skB$Hj\\4t)\r\u0019\u0017\u0011\r\u0005\b\u0003\u001b\u0019\u0002\u0019AA\bQ\u001d\u0019\u0012QEA\u001b\u0003KbC!!\u000f\u0002>!:1#a\u0011\u0002L\u00055\u0013A\t;fgR\u001cE.Z1o'\",H\u000fZ8x]^KG\u000f\u001b.l+:\fg/Y5mC\ndW\rF\u0002d\u0003[Bq!!\u0004\u0015\u0001\u0004\ty\u0001K\u0004\u0015\u0003c\n9(!\u001f\u0011\u0007Q\f\u0019(C\u0002\u0002vU\u0014\u0001\u0002R5tC\ndW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003w\n\u0001bS'F)\u0006k3\u0007\u000f\u0015\b)\u0005\u0015\u0012QGA@Y\t\tI\u0004K\u0004\u0015\u0003\u0007\nY%!\u0014\u0002_Q,7\u000f^\"mK\u0006t7\u000b[;uI><hnV5uQ.\u0013\u0016M\u001a;D_:$(o\u001c7mKJ,f.\u0019<bS2\f'\r\\3\u0015\u0007\r\f9\tC\u0004\u0002\u000eU\u0001\r!a\u0004)\u000fU\t)#!\u000e\u0002\f2\u0012\u0011Q\b\u0015\b+\u0005\r\u00131JA'\u0003\u00152XM]5gs\u000ecW-\u00198TQV$Hm\\<o\u0003\u001a$XM\u001d$bS2,Gm\u0015;beR,\b/\u0006\u0003\u0002\u0014\u0006-F\u0003BAK\u0003\u0013$2aYAL\u0011\u001d\tIJ\u0006a\u0002\u00037\u000b\u0011#\u001a=dKB$\u0018n\u001c8DY\u0006\u001c8\u000fV1h!\u0019\ti*a)\u0002(6\u0011\u0011q\u0014\u0006\u0004\u0003CC\u0015a\u0002:fM2,7\r^\u0005\u0005\u0003K\u000byJ\u0001\u0005DY\u0006\u001c8\u000fV1h!\u0011\tI+a+\r\u0001\u00119\u0011Q\u0016\fC\u0002\u0005=&!A#\u0012\t\u0005E\u0016q\u0017\t\u00047\u0006M\u0016bAA[\u0011\n9aj\u001c;iS:<\u0007\u0003BA]\u0003\u0007tA!a/\u0002@:!\u0011QCA_\u0013\u0005I\u0015bAAa\u0011\u00069\u0001/Y2lC\u001e,\u0017\u0002BAc\u0003\u000f\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005\u0005\u0007\nC\u0004\u0002\u000eY\u0001\r!a\u0004\u0002-%\u001chj\u001c8EC\u0016lwN\\&bM.\fG\u000b\u001b:fC\u0012$B!a4\u0002VB\u00191,!5\n\u0007\u0005M\u0007JA\u0004C_>dW-\u00198\t\u000f\u0005]w\u00031\u0001\u0002Z\u0006\tA\u000fE\u00027\u00037L1!!88\u0005\u0019!\u0006N]3bI\u0006ab/\u001a:jMftuN\u001c#bK6|g\u000e\u00165sK\u0006$7o\u0015;biV\u001cH#A2\u0002/Q,7\u000f^\"p]N,7-\u001e;jm\u0016\u001c\u0006.\u001e;e_^tGcA2\u0002h\"9\u0011QB\rA\u0002\u0005=\u0001fB\r\u0002&\u0005U\u00121\u001e\u0017\u0005\u0003s\ti\u0004K\u0004\u001a\u0003\u0007\nY%!\u0014\u0002#Q,7\u000f\u001e\"fO&t7\u000b[;uI><h\u000eF\u0003d\u0003g\f)\u0010C\u0004\u0002\u000ei\u0001\r!a\u0004\t\u000f\u0005](\u00041\u0001\u0002z\u0006ya.^7IiR\u0004(+Z9vKN$8\u000fE\u0002\\\u0003wL1!!@I\u0005\rIe\u000e\u001e\u0015\b5\t\u0005\u0011q\u000fB\u0004!\u0011\t9Ca\u0001\n\t\t\u0015\u0011\u0011\u0006\u0002\n\u0007N48k\\;sG\u0016d\u0003B!\u0003\u0003\u000e\tE!QC\u0011\u0003\u0005\u0017\tAA_6-c\u0005\u0012!qB\u0001\u0005u.d#'\t\u0002\u0003\u0014\u000591N]1gi2\n\u0014E\u0001B\f\u0003\u001dY'/\u00194uYIBsAGA\"\u0003\u0017\ni%A\u000euKN$()Z4j]NCW\u000f\u001e3po:<&o\u001c8h\u000bB|7\r\u001b\u000b\u0004G\n}\u0001bBA\u00077\u0001\u0007\u0011q\u0002\u0015\b7\u0005\u0015\u0012Q\u0007B\u0012Y\u0011\tI$!\u0010)\u000fm\t\u0019%a\u0013\u0002N\u0005\u0001C/Z:u\u0007>tGO]8mY\u0016\u00148\u000b[;uI><h\u000eR;sS:<7+\u001a8eQ\ra\"1\u0006\t\u0004i\n5\u0012b\u0001B\u0018k\n!A+Z:u\u0003\u0019\u0019wN\u001c4jOV\ta,\u0001\u0004ce>\\WM]\u000b\u0003\u0005s\u00012A\rB\u001e\u0013\r\u0011id\t\u0002\f\u0017\u000647.\u0019\"s_.,'/\u0001\btQV$Hm\\<o\u0005J|7.\u001a:\u0002\u001bI,7\u000f^1si\n\u0013xn[3s\u00039\u0011Xm\u0019:fCR,'I]8lKJ$2a\u0019B$\u0011\u001d\u0011I%\ta\u0001\u0003\u001f\fqa\u001d;beR,\b\u000fK\u0004\u0001\u0005\u001b\n9Ha\u0015\u0011\u0007Q\u0014y%C\u0002\u0003RU\u0014q\u0001V5nK>,HOH\u0001=\u0001")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
    private final List<String> sent2 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"more", "messages"}));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get(KafkaConfig$.MODULE$.LogDirsProp());
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirsProp(), logDirsValue);
            }
            return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirProp(), originals.get(KafkaConfig$.MODULE$.LogDirProp()));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).head(), this.propsToChangeUponRestart(), true)));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdown(String quorum) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sent1().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, 15000L);
        producer.elem = this.createProducer$1();
        KafkaConsumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), 15000L);
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable)x$2 -> (String)x$2.value()));
        this.sent2().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), 15000L);
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable)x$4 -> (String)x$4.value()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartup(String quorum) {
        String string = quorum;
        String string2 = "zk";
        if (string != null && string.equals(string2)) {
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
            this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
            return;
        }
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "1000");
        this.killBroker(0);
        this.shutdownKRaftController();
        this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(CancellationException.class));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartupDueToCorruptLogs(String quorum) {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1 & Serializable)dirName -> {
            ServerShutdownTest.$anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(this, dirName);
            return BoxedUnit.UNIT;
        });
        this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(KafkaStorageException.class));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    @Disabled(value="KMETA-38")
    public void testCleanShutdownWithZkUnavailable(String quorum) {
        this.shutdownZooKeeper();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testCleanShutdownWithKRaftControllerUnavailable(String quorum) {
        this.shutdownKRaftController();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(String quorum, ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)exceptionClassTag.runtimeClass().isInstance(e), (String)new StringBuilder(21).append("Unexpected exception ").append(e).toString());
                String string = quorum;
                String string2 = "zk";
                Assertions.assertEquals((Object)(string != null && string.equals(string2) ? BrokerState.NOT_RUNNING : BrokerState.SHUTTING_DOWN), (Object)this.broker().brokerState());
            }
        }
        finally {
            this.killBroker(0);
        }
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()), (Function1 & Serializable)x$5 -> (Thread)x$5, ClassTag$.MODULE$.apply(Thread.class))), (Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutiveShutdown(String quorum) {
        this.killBroker(0);
        this.broker().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @CsvSource(value={"zk,1", "zk,2", "kraft,1", "kraft,2"})
    public void testBeginShutdown(String quorum, int numHttpRequests) {
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ServerShutdownTest.$anonfun$testBeginShutdown$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var10_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_4 = null;
        Object var9_8 = null;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numHttpRequests).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            this.broker().beginShutdown(this.broker().brokerEpoch());
            Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)this.broker().brokerState(), (String)"broker should only be in shutting down state");
        });
        this.broker().shutdown();
        this.broker().awaitShutdown();
        String string = quorum;
        String string3 = "zk";
        Assertions.assertEquals((Object)(string != null && string.equals(string3) ? BrokerState.NOT_RUNNING : BrokerState.SHUTTING_DOWN), (Object)this.broker().brokerState(), (String)"expected broker to be fully shut down");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBeginShutdownWrongEpoch(String quorum) {
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ServerShutdownTest.$anonfun$testBeginShutdownWrongEpoch$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var10_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var4_3 = null;
        Object var9_7 = null;
        long wrongBrokerEpoch = this.broker().brokerEpoch() - 1L;
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.broker().beginShutdown(wrongBrokerEpoch), () -> "expected a begin shutdown requests at a different epoch to result in an exception");
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)this.broker().brokerState(), (String)"broker shutdown should not have started");
    }

    @Test
    public void testControllerShutdownDuringSend() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrBatch batch = new LeaderAndIsrBatch(1).setControllerId(controllerId).setControllerEpoch(1).setBrokerEpoch(0L).addPartitionState(new TopicPartition("topic", 0), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState()).addLiveLeaders(((IterableOnceOps)brokerAndEpochs.keys().map((Function1 & Serializable)x$7 -> x$7.node(listenerName))).toSet()).addTopicId(this.topic(), Uuid.randomUuid());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            Function2 x$3 = qual$1.sendControlMetadataBatch$default$3();
            qual$1.sendControlMetadataBatch(1, (ControlMetadataBatch)batch, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.killBroker(0);
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = Integer.MAX_VALUE;
        int n3 = 30000;
        int n4 = 0;
        int n5 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n6 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        return TestUtils$.MODULE$.createProducer(x$1, n, l, l2, n2, n3, n4, n5, x$11, n6, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, bl);
    }

    private final KafkaConsumer createConsumer$1() {
        None$ none$;
        None$ none$2;
        String string;
        None$ none$3;
        String string2;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String string3 = string2 = "group";
        string2 = null;
        String x$5 = string3;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        String string4 = string = "earliest";
        string = null;
        String x$7 = string4;
        boolean bl = true;
        boolean bl2 = false;
        int n = 500;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$11 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$12 = none$6;
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, (Option<String>)x$6, x$7, bl, bl2, n, SecurityProtocol.PLAINTEXT, (Option<File>)x$11, (Option<Properties>)x$12, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles()), (Function1 & Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testBeginShutdown$1(ServerShutdownTest $this) {
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.broker().brokerState(), (String)"broker should be started");
    }

    public static final /* synthetic */ void $anonfun$testBeginShutdownWrongEpoch$1(ServerShutdownTest $this) {
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.broker().brokerState(), (String)"broker should be started");
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }
}

