/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.StorageProbe;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000512A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)\u0001\u0006\u0001C\u0001/!)!\u0006\u0001C\u0001/\t\u00012\u000b^8sC\u001e,\u0007K]8cKR+7\u000f\u001e\u0006\u0003\u000f!\taa]3sm\u0016\u0014(\"A\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0002CA\u000b\u0001\u001b\u00051\u0011\u0001\b;fgR\u001cFo\u001c:bO\u0016\u0004&o\u001c2f'&tw\r\\3M_\u001e$\u0017N\u001d\u000b\u00021A\u0011Q\"G\u0005\u000359\u0011A!\u00168ji\"\u0012!\u0001\b\t\u0003;\u0019j\u0011A\b\u0006\u0003?\u0001\n1!\u00199j\u0015\t\t#%A\u0004kkBLG/\u001a:\u000b\u0005\r\"\u0013!\u00026v]&$(\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(=\t!A+Z:u\u0003}!Xm\u001d;Ti>\u0014\u0018mZ3Qe>\u0014W-T;mi&\u0004H.\u001a'pO\u0012L'o\u001d\u0015\u0003\u0007q\tq\u0003^3ti\u0012K7/\u00192mKN#xN]1hKB\u0013xNY3)\u0005\u0011a\u0002")
public class StorageProbeTest {
    @Test
    public void testStorageProbeSingleLogdir() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(500000000L, 1600592000000L, 1600592000000L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(0)), (Object)BoxesRunTime.boxToInteger((int)500000000))})), (Object)storageProbe.probe(), (String)"mock time should have calculated storage latency as 1ms for each logdir");
        config.logDirs().foreach((Function1 & Serializable)dir -> {
            StorageProbeTest.$anonfun$testStorageProbeSingleLogdir$1(dir);
            return BoxedUnit.UNIT;
        });
        storageProbe.shutdown();
    }

    @Test
    public void testStorageProbeMultipleLogdirs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = true;
        boolean bl2 = true;
        int n = TestUtils$.MODULE$.RandomPort();
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n4 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$8;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", bl, bl2, n, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, bl3, bl4, n2, bl5, n3, bl6, n4, (Option<String>)x$17, 2, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(100000000L, 1600592000000L, 1600592000000L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(0)), (Object)BoxesRunTime.boxToInteger((int)100000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(1)), (Object)BoxesRunTime.boxToInteger((int)100000000))})), (Object)storageProbe.probe(), (String)"mock time should have calculated storage latency for each logdir");
        Assertions.assertEquals((Object)"0,1600692000000", (Object)Utils.readFileAsString((String)Paths.get((String)config.logDirs().apply(0), "storage.probe").toFile().getAbsolutePath()), (String)"time of the first write should have been recorded");
        Assertions.assertEquals((Object)"0,1601092000000", (Object)Utils.readFileAsString((String)Paths.get((String)config.logDirs().apply(1), "storage.probe").toFile().getAbsolutePath()), (String)"time of the last write should have been recorded later than the first");
        storageProbe.shutdown();
    }

    @Test
    public void testDisableStorageProbe() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "-1");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(1L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)storageProbe.probe(), (String)"Storage probe should not return any results");
        Assertions.assertFalse((boolean)Paths.get((String)config.logDirs().head(), "storage.probe").toFile().exists());
        storageProbe.shutdown();
    }

    public static final /* synthetic */ void $anonfun$testStorageProbeSingleLogdir$1(String dir) {
        Assertions.assertEquals((Object)"0,1601092000000", (Object)Utils.readFileAsString((String)Paths.get(dir, "storage.probe").toFile().getAbsolutePath()), (String)"time of the last write should have been recorded");
    }
}

