/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.server.Defaults$;
import kafka.server.VerifyGroupSubscriptionPrefixTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001ds!B\b\u0011\u0011\u0003)b!B\f\u0011\u0011\u0003A\u0002\"B\u0010\u0002\t\u0003\u0001\u0003bB\u0011\u0002\u0005\u0004%\tA\t\u0005\u0007W\u0005\u0001\u000b\u0011B\u0012\u0007\t]\u0001\u0002\u0001\f\u0005\u0006?\u0015!\ta\r\u0005\u0006k\u0015!\tF\u000e\u0005\u0006u\u0015!\te\u000f\u0005\u0006\u001b\u0016!\tA\u0014\u0005\u00067\u0016!\tA\u0014\u0005\u0006;\u0016!\tA\u0014\u0005\u0006?\u0016!I\u0001\u0019\u0005\u0006y\u0016!I! \u0005\n\u0003_)\u0011\u0013!C\u0005\u0003c\t\u0011EV3sS\u001aLxI]8vaN+(m]2sSB$\u0018n\u001c8Qe\u00164\u0017\u000e\u001f+fgRT!!\u0005\n\u0002\rM,'O^3s\u0015\u0005\u0019\u0012!B6bM.\f7\u0001\u0001\t\u0003-\u0005i\u0011\u0001\u0005\u0002\"-\u0016\u0014\u0018NZ=He>,\boU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u0004&/\u001a4jqR+7\u000f^\n\u0003\u0003e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0016\u0003\u0019\u0001(/\u001a4jqV\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\rM#(/\u001b8h\u0003\u001d\u0001(/\u001a4jq\u0002\u001a\"!B\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005A\u0012\u0012aA1qS&\u0011!g\f\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tgR\tA\u0007\u0005\u0002\u0017\u000b\u0005Y!M]8lKJ\u001cu.\u001e8u+\u00059\u0004C\u0001\u000e9\u0013\tI4DA\u0002J]R\fQ\"\\8eS\u001aL8i\u001c8gS\u001e\u001cHC\u0001\u001f@!\tQR(\u0003\u0002?7\t!QK\\5u\u0011\u0015\u0001\u0005\u00021\u0001B\u0003\u0015\u0001(o\u001c9t!\r\u0011UiR\u0007\u0002\u0007*\u0011AiG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001$D\u0005\r\u0019V-\u001d\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u001e\nA!\u001e;jY&\u0011A*\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u000b;fgR\u001cVoY2fgN4W\u000f\u001c7z\t\u0016dW\r^3PM\u001a\u001cX\r^:XSRD\u0007K]3gSb,7\u000fF\u0001=Q\tI\u0001\u000b\u0005\u0002R36\t!K\u0003\u00021'*\u0011A+V\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1v+A\u0003kk:LGOC\u0001Y\u0003\ry'oZ\u0005\u00035J\u0013A\u0001V3ti\u0006aC/Z:u'V\u001c7-Z:tMVdG.\u001f#fY\u0016$Xm\u00144gg\u0016$8oV5uQ>,H\u000f\u0015:fM&DXm\u001d\u0015\u0003\u0015A\u000bq\u0004^3tiVs7/^2dKN\u001ch-\u001e7ms\u0012+G.\u001a;f\u001f\u001a47/\u001a;tQ\tY\u0001+A\tuKN$H)\u001a7fi\u0016|eMZ:fiN$B!\u00197yuB\u0011!M[\u0007\u0002G*\u0011A-Z\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003M\u001e\fqa\u00197jK:$8O\u0003\u0002\u0014Q*\u0011\u0011nV\u0001\u0007CB\f7\r[3\n\u0005-\u001c'\u0001\t#fY\u0016$XmQ8ogVlWM]$s_V\u0004xJ\u001a4tKR\u001c(+Z:vYRDQ!\u001c\u0007A\u00029\fQa\u001a:pkB\u0004\"a\u001c<\u000f\u0005A$\bCA9\u001c\u001b\u0005\u0011(BA:\u0015\u0003\u0019a$o\\8u}%\u0011QoG\u0001\u0007!J,G-\u001a4\n\u0005):(BA;\u001c\u0011\u0015IH\u00021\u0001o\u0003=\u0019XOY:de&\u0014W\r\u001a+pa&\u001c\u0007\"B>\r\u0001\u0004q\u0017!E;ogV\u00147o\u0019:jE\u0016$Gk\u001c9jG\u0006\u0001\u0012m]:feR4U\u000f^;sK:+H\u000e\u001c\u000b\u0005yy\f)\u0003\u0003\u0004\u0000\u001b\u0001\u0007\u0011\u0011A\u0001\u0007MV$XO]31\t\u0005\r\u00111\u0003\t\u0007\u0003\u000b\tY!a\u0004\u000e\u0005\u0005\u001d!bAA\u0005O\u000611m\\7n_:LA!!\u0004\u0002\b\tY1*\u00194lC\u001a+H/\u001e:f!\u0011\t\t\"a\u0005\r\u0001\u0011Y\u0011Q\u0003@\u0002\u0002\u0003\u0005)\u0011AA\f\u0005\ryF%M\t\u0005\u00033\ty\u0002E\u0002\u001b\u00037I1!!\b\u001c\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AGA\u0011\u0013\r\t\u0019c\u0007\u0002\u0004\u0003:L\b\"CA\u0014\u001bA\u0005\t\u0019AA\u0015\u0003\u001diWm]:bO\u0016\u0004BAGA\u0016]&\u0019\u0011QF\u000e\u0003\r=\u0003H/[8o\u0003i\t7o]3si\u001a+H/\u001e:f\u001dVdG\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019D\u000b\u0003\u0002*\u0005U2FAA\u001c!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u00053$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0012\u0002<\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class VerifyGroupSubscriptionPrefixTest
extends IntegrationTestHarness {
    public static String prefix() {
        return VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix();
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> p.put("confluent.verify.group.subscription.prefix", "true"));
    }

    @Test
    public void testSuccessfullyDeleteOffsetsWithPrefixes() {
        String group = new StringBuilder(5).append(VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix()).append("group").toString();
        String subscribedTopic = new StringBuilder(16).append(VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix()).append("subscribed-topic").toString();
        String unsubscribedTopic = new StringBuilder(20).append(VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix()).append("not-subscribed-topic").toString();
        DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.testDeleteOffsets(group, subscribedTopic, unsubscribedTopic);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(new TopicPartition(subscribedTopic, 0)), GroupSubscribedToTopicException.class, (Option<String>)None$.MODULE$);
        this.assertFutureNull(offsetDeleteResult.partitionResult(new TopicPartition(unsubscribedTopic, 0)), (Option<String>)None$.MODULE$);
    }

    @Test
    public void testSuccessfullyDeleteOffsetsWithoutPrefixes() {
        String group = "group";
        String subscribedTopic = "subscribed-topic";
        String unsubscribedTopic = "not-subscribed-topic";
        DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.testDeleteOffsets(group, subscribedTopic, unsubscribedTopic);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(new TopicPartition(subscribedTopic, 0)), GroupSubscribedToTopicException.class, (Option<String>)None$.MODULE$);
        this.assertFutureNull(offsetDeleteResult.partitionResult(new TopicPartition(unsubscribedTopic, 0)), (Option<String>)None$.MODULE$);
    }

    @Test
    public void testUnsuccessfullyDeleteOffsets() {
        String group = new StringBuilder(5).append(VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix()).append("group").toString();
        String subscribedTopic = "subscribed-topic";
        String unsubscribedTopic = "not-subscribed-topic";
        DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.testDeleteOffsets(group, subscribedTopic, unsubscribedTopic);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(new TopicPartition(subscribedTopic, 0)), GroupSubscribedToTopicException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(new TopicPartition(unsubscribedTopic, 0)), GroupSubscribedToTopicException.class, (Option<String>)None$.MODULE$);
    }

    private DeleteConsumerGroupOffsetsResult testDeleteOffsets(String group, String subscribedTopic, String unsubscribedTopic) {
        this.createTopic(subscribedTopic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(unsubscribedTopic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(subscribedTopic, Predef$.MODULE$.int2Integer(0), null, null)).get();
        producer.send(new ProducerRecord(unsubscribedTopic, Predef$.MODULE$.int2Integer(0), null, null)).get();
        Properties newConsumerConfig = new Properties(this.consumerConfig());
        newConsumerConfig.setProperty("group.id", group);
        newConsumerConfig.setProperty("max.poll.interval.ms", Integer.toString(Integer.MAX_VALUE));
        newConsumerConfig.setProperty("session.timeout.ms", Integer.toString(Defaults$.MODULE$.GroupMaxSessionTimeoutMs()));
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, newConsumerConfig, x$4);
        TestUtils$.MODULE$.subscribeAndWaitForRecords(subscribedTopic, consumer, 15000L);
        consumer.commitSync();
        return this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()).deleteConsumerGroupOffsets(group, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(subscribedTopic, 0), new TopicPartition(unsubscribedTopic, 0)}))).asJava());
    }

    private void assertFutureNull(KafkaFuture<?> future, Option<String> message) {
        if (message instanceof Some) {
            String msg = (String)((Some)message).value();
            Assertions.assertNull((Object)future.get(), (String)msg);
            return;
        }
        if (None$.MODULE$.equals(message)) {
            Assertions.assertNull((Object)future.get());
            return;
        }
        throw new MatchError(message);
    }

    private Option<String> assertFutureNull$default$2() {
        return None$.MODULE$;
    }
}

