/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigType$;
import kafka.server.metadata.ZkConfigRepository;
import kafka.server.metadata.ZkConfigRepository$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005%2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)q\u0005\u0001C\u0001-\t1\"l[\"p]\u001aLwMU3q_NLGo\u001c:z)\u0016\u001cHO\u0003\u0002\u0007\u000f\u000511/\u001a:wKJT\u0011\u0001C\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0002\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\u0015\ta\u0003^3tij[7i\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\u000b\u0002/A\u0011A\u0002G\u0005\u000335\u0011A!\u00168ji\"\u0012!a\u0007\t\u00039\u0015j\u0011!\b\u0006\u0003=}\t1!\u00199j\u0015\t\u0001\u0013%A\u0004kkBLG/\u001a:\u000b\u0005\t\u001a\u0013!\u00026v]&$(\"\u0001\u0013\u0002\u0007=\u0014x-\u0003\u0002';\t!A+Z:u\u0003Q!Xm\u001d;V]N,\b\u000f]8si\u0016$G+\u001f9fg\"\u00121a\u0007")
public class ZkConfigRepositoryTest {
    @Test
    public void testZkConfigRepository() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ZkConfigRepository zkConfigRepository = ZkConfigRepository$.MODULE$.apply(zkClient);
        int brokerId = 1;
        String topic = "topic";
        Properties brokerProps = new Properties();
        brokerProps.put("a", "b");
        Properties topicProps = new Properties();
        topicProps.put("c", "d");
        Mockito.when((Object)zkClient.getEntityConfigs(ConfigType$.MODULE$.Broker(), Integer.toString(brokerId))).thenReturn((Object)brokerProps);
        Mockito.when((Object)zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), topic)).thenReturn((Object)topicProps);
        Assertions.assertEquals((Object)brokerProps, (Object)zkConfigRepository.brokerConfig(brokerId));
        Assertions.assertEquals((Object)topicProps, (Object)zkConfigRepository.topicConfig(topic));
    }

    @Test
    public void testUnsupportedTypes() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ZkConfigRepository zkConfigRepository = ZkConfigRepository$.MODULE$.apply(zkClient);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ConfigResource.Type.values()), (Function1 & Serializable)value -> {
            ConfigResource.Type type = value;
            ConfigResource.Type type2 = ConfigResource.Type.BROKER;
            if (type == null ? type2 != null : !type.equals(type2)) {
                ConfigResource.Type type3 = value;
                ConfigResource.Type type4 = ConfigResource.Type.TOPIC;
                if (type3 == null ? type4 != null : !type3.equals(type4)) {
                    ConfigResource.Type type5 = value;
                    ConfigResource.Type type6 = ConfigResource.Type.CLUSTER_LINK;
                    if (type5 == null ? type6 != null : !type5.equals(type6)) {
                        return Assertions.assertThrows(IllegalArgumentException.class, () -> zkConfigRepository.config(new ConfigResource(value, value.toString())));
                    }
                }
            }
            return BoxedUnit.UNIT;
        });
    }
}

