/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkAutoMirroring;
import kafka.server.link.ClusterLinkAutoMirroring$;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.LinkMode;
import kafka.server.link.SourceCluster$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkDisabledException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rEf\u0001B/_\u0001\u0015DQ\u0001\u001c\u0001\u0005\u00025Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004\u0000\u0001\u0001\u0006IA\u001d\u0005\t\u0003\u0003\u0001!\u0019!C\u0005c\"9\u00111\u0001\u0001!\u0002\u0013\u0011\b\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0011!\ty\u0001\u0001Q\u0001\n\u0005%\u0001\"CA\t\u0001\t\u0007I\u0011BA\n\u0011!\tY\u0002\u0001Q\u0001\n\u0005U\u0001\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\t9\u0004\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\ti\u0005\u0001Q\u0001\n\u0005u\u0002\"CA(\u0001\t\u0007I\u0011BA)\u0011!\ty\u0006\u0001Q\u0001\n\u0005M\u0003\"CA1\u0001\t\u0007I\u0011BA2\u0011!\t\t\b\u0001Q\u0001\n\u0005\u0015\u0004\"CA:\u0001\t\u0007I\u0011BA;\u0011!\ti\b\u0001Q\u0001\n\u0005]\u0004\"CA@\u0001\t\u0007I\u0011BAA\u0011!\tI\t\u0001Q\u0001\n\u0005\r\u0005\"CAF\u0001\t\u0007I\u0011BAG\u0011!\t9\u000b\u0001Q\u0001\n\u0005=\u0005\"CAU\u0001\t\u0007I\u0011BAG\u0011!\tY\u000b\u0001Q\u0001\n\u0005=\u0005bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003\u001b\u0004A\u0011AAX\u0011\u001d\t9\u000e\u0001C\u0005\u0003_Cq!!7\u0001\t\u0013\tY\u000eC\u0005\u0002h\u0002\t\n\u0011\"\u0003\u0002j\"9\u0011q \u0001\u0005\n\t\u0005\u0001\"\u0003B\u0003\u0001E\u0005I\u0011BAu\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013AqAa\u0007\u0001\t\u0013\u0011i\u0002C\u0004\u00030\u0001!IA!\r\t\u0013\t-\u0003!%A\u0005\n\t5\u0003b\u0002B)\u0001\u0011%!1\u000b\u0005\n\u0005?\u0002\u0011\u0013!C\u0005\u0005\u001bBqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0005\u0003t\u0001\t\n\u0011\"\u0003\u0003N!9!Q\u000f\u0001\u0005\n\t]\u0004b\u0002B;\u0001\u0011%!q\u0010\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011Y\t\u0001C\u0005\u0005\u001bCqAa#\u0001\t\u0013\u0011\t\u000bC\u0004\u0003.\u0002!IAa,\t\u0013\te\u0006!%A\u0005\n\t5\u0003\"\u0003B^\u0001E\u0005I\u0011\u0002B'\u0011\u001d\u0011i\f\u0001C\u0001\u0003_CqAa2\u0001\t\u0003\ty\u000bC\u0004\u0003L\u0002!\t!a,\t\u000f\t=\u0007\u0001\"\u0001\u00020\"9!1\u001b\u0001\u0005\u0002\u0005=\u0006b\u0002Bl\u0001\u0011\u0005\u0011q\u0016\u0005\b\u00057\u0004A\u0011AAX\u0011\u001d\u0011y\u000e\u0001C\u0001\u0003_CqAa9\u0001\t\u0003\ty\u000bC\u0004\u0003h\u0002!\t!a,\t\u000f\t-\b\u0001\"\u0001\u00020\"9!q\u001e\u0001\u0005\u0002\u0005=\u0006b\u0002Bz\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0005o\u0004A\u0011AAX\u0011\u001d\u0011Y\u0010\u0001C\u0001\u0003_CqAa@\u0001\t\u0003\ty\u000bC\u0004\u0004\u0004\u0001!\t!a,\t\u000f\r\u001d\u0001\u0001\"\u0001\u00020\"911\u0002\u0001\u0005\u0002\u0005=\u0006bBB\b\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0007'\u0001A\u0011AAX\u0011\u001d\u00199\u0002\u0001C\u0001\u0003_Cqaa\u0007\u0001\t\u0003\ty\u000bC\u0004\u0004 \u0001!\t!a,\t\u000f\r\r\u0002\u0001\"\u0003\u0004&!911\u0006\u0001\u0005\u0002\u0005=\u0006bBB\u0018\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0007g\u0001A\u0011AAX\u0011\u001d\u00199\u0004\u0001C\u0001\u0003_Cqaa\u000f\u0001\t\u0003\ty\u000bC\u0004\u0004@\u0001!\t!a,\t\u000f\r\r\u0003\u0001\"\u0001\u00020\u001a11q\t\u0001\u0001\u0007\u0013B!b!\u0015R\u0005\u0003\u0005\u000b\u0011BB*\u0011\u0019a\u0017\u000b\"\u0001\u0004Z!I!QG)A\u0002\u0013\u00051\u0011\r\u0005\n\u0007O\n\u0006\u0019!C\u0001\u0007SB\u0001ba\u001cRA\u0003&11\r\u0005\n\u0007c\n\u0006\u0019!C\u0001\u0007gB\u0011b!\u001eR\u0001\u0004%\taa\u001e\t\u0011\rm\u0014\u000b)Q\u0005\u0003CDqa! R\t\u0003\u001ay\bC\u0004\u0004\u001cF#\te!(\t\u000f\r%\u0016\u000b\"\u0001\u0004,\na2\t\\;ti\u0016\u0014H*\u001b8l\u0003V$x.T5se>\u0014\u0018N\\4UKN$(BA0a\u0003\u0011a\u0017N\\6\u000b\u0005\u0005\u0014\u0017AB:feZ,'OC\u0001d\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0003%\fQa]2bY\u0006L!a\u001b5\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u000e\u0005\u0002p\u00015\ta,A\u0006t_V\u00148-Z!e[&tW#\u0001:\u0011\u0005MlX\"\u0001;\u000b\u0005U4\u0018!B1e[&t'BA<y\u0003\u001d\u0019G.[3oiNT!aY=\u000b\u0005i\\\u0018AB1qC\u000eDWMC\u0001}\u0003\ry'oZ\u0005\u0003}R\u0014abQ8oM2,XM\u001c;BI6Lg.\u0001\u0007t_V\u00148-Z!e[&t\u0007%A\u0005eKN$\u0018\tZ7j]\u0006QA-Z:u\u0003\u0012l\u0017N\u001c\u0011\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ,\"!!\u0003\u0011\u0007=\fY!C\u0002\u0002\u000ey\u0013!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s+\t\t)\u0002E\u0002p\u0003/I1!!\u0007_\u0005a\u0019E.^:uKJd\u0015N\\6DY&,g\u000e^'b]\u0006<WM]\u0001\u000fG2LWM\u001c;NC:\fw-\u001a:!\u0003AIgn\u00197vI\u0016\fE\u000e\u001c$jYR,'/\u0006\u0002\u0002\"A!\u00111EA\u0019\u001d\u0011\t)#!\f\u0011\u0007\u0005\u001d\u0002.\u0004\u0002\u0002*)\u0019\u00111\u00063\u0002\rq\u0012xn\u001c;?\u0013\r\ty\u0003[\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0012Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=\u0002.A\tj]\u000edW\u000fZ3BY24\u0015\u000e\u001c;fe\u0002\na\u0001\\5oW&#WCAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nA!\u001e;jY*\u0011\u0011qI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0005\u0005#\u0001B+V\u0013\u0012\u000bq\u0001\\5oW&#\u0007%A\u0007t_V\u00148-\u001a+pa&\u001c\u0017\nZ\u000b\u0003\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033B\u0018AB2p[6|g.\u0003\u0003\u0002^\u0005]#\u0001B+vS\u0012\fab]8ve\u000e,Gk\u001c9jG&#\u0007%\u0001\u0005mS:\\G)\u0019;b+\t\t)\u0007\u0005\u0003\u0002h\u00055TBAA5\u0015\r\tYGY\u0001\u0003u.LA!a\u001c\u0002j\ty1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u00059Q.\u001a;sS\u000e\u001cXCAA<!\ry\u0017\u0011P\u0005\u0004\u0003wr&AE\"mkN$XM\u001d'j].lU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\ng\u000eDW\rZ;mKJ,\"!a!\u0011\u0007=\f))C\u0002\u0002\bz\u0013Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005!Bo\u001c9jG\u0016C\u0018n\u001d;t\u000bb\u001cW\r\u001d;j_:,\"!a$\u0011\u000b\u001d\f\t*!&\n\u0007\u0005M\u0005N\u0001\u0004PaRLwN\u001c\t\u0005\u0003/\u000b\tK\u0004\u0003\u0002\u001a\u0006ue\u0002BA\u0014\u00037K\u0011![\u0005\u0004\u0003?C\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003G\u000b)KA\u0005UQJ|w/\u00192mK*\u0019\u0011q\u00145\u0002+Q|\u0007/[2Fq&\u001cHo]#yG\u0016\u0004H/[8oA\u00051\u0012-\u001e;i_JL'0\u0019;j_:,\u0005pY3qi&|g.A\fbkRDwN]5{CRLwN\\#yG\u0016\u0004H/[8oA\u0005)1/\u001a;VaR\u0011\u0011\u0011\u0017\t\u0004O\u0006M\u0016bAA[Q\n!QK\\5uQ\rQ\u0012\u0011\u0018\t\u0005\u0003w\u000bI-\u0004\u0002\u0002>*!\u0011qXAa\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u0007\f)-A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u001d70A\u0003kk:LG/\u0003\u0003\u0002L\u0006u&A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u001c\u0003#\u0004B!a/\u0002T&!\u0011Q[A_\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0005sKN,G/T8dW\u0006I1/\u001a;va6{7m\u001b\u000b\u0005\u0003c\u000bi\u000eC\u0005\u0002`v\u0001\n\u00111\u0001\u0002b\u0006A3o[5q\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe2Kgn[3e)>\u0004\u0018nY:B]\u0012\u0014V\r\u001d7bsB\u0019q-a9\n\u0007\u0005\u0015\bNA\u0004C_>dW-\u00198\u0002'M,G/\u001e9N_\u000e\\G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-(\u0006BAq\u0003[\\#!a<\u0011\t\u0005E\u00181`\u0007\u0003\u0003gTA!!>\u0002x\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003sD\u0017AC1o]>$\u0018\r^5p]&!\u0011Q`Az\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bm\u0016\u0014\u0018NZ=N_\u000e\\G\u0003BAY\u0005\u0007A\u0011\"a8 !\u0003\u0005\r!!9\u0002)Y,'/\u001b4z\u001b>\u001c7\u000e\n3fM\u0006,H\u000e\u001e\u00132\u0003Ui\u0017N\u001d:peR{\u0007/[2t\u0003:$g+\u001a:jMf$BAa\u0003\u0003\u0012A\u0019qN!\u0004\n\u0007\t=aL\u0001\rDYV\u001cH/\u001a:MS:\\\u0017)\u001e;p\u001b&\u0014(o\u001c:j]\u001eDqAa\u0005\"\u0001\u0004\u0011)\"A\tdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u00042a\u001cB\f\u0013\r\u0011IB\u0018\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017\u0001E7pG.\u001c%/Z1uKR{\u0007/[2t)\u0011\u0011yB!\n\u0011\u0007M\u0014\t#C\u0002\u0003$Q\u0014!c\u0011:fCR,Gk\u001c9jGN\u0014Vm];mi\"9!q\u0005\u0012A\u0002\t%\u0012A\u0003;pa&\u001c7\u000fV8FqBA\u00111\u0005B\u0016\u0003C\ty)\u0003\u0003\u0003.\u0005U\"aA'ba\u0006QRn\\2l\u0007J,\u0017\r^3U_BL7m]*b[\u0016\u0014Vm];miR1!q\u0004B\u001a\u0005\u000fBqA!\u000e$\u0001\u0004\u00119$\u0001\u0004u_BL7m\u001d\t\u0007\u0005s\u0011\u0019%!\t\u000e\u0005\tm\"\u0002\u0002B\u001f\u0005\u007f\tq!\\;uC\ndWMC\u0002\u0003B!\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ea\u000f\u0003\u0007M+G\u000fC\u0005\u0003J\r\u0002\n\u00111\u0001\u0002\u0010\u0006\u0011Q\r_\u0001%[>\u001c7n\u0011:fCR,Gk\u001c9jGN\u001c\u0016-\\3SKN,H\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\n\u0016\u0005\u0003\u001f\u000bi/\u0001\rn_\u000e\\gj\\%oi\u0016\u0014h.\u00197MSN$Hk\u001c9jGN$bA!\u0016\u0003\\\tu\u0003cA:\u0003X%\u0019!\u0011\f;\u0003!1K7\u000f\u001e+pa&\u001c7OU3tk2$\bb\u0002B\u001bK\u0001\u0007!q\u0007\u0005\n\u0005\u0013*\u0003\u0013!a\u0001\u0003\u001f\u000b!%\\8dW:{\u0017J\u001c;fe:\fG\u000eT5tiR{\u0007/[2tI\u0011,g-Y;mi\u0012\u0012\u0014AD7pG.d\u0015n\u001d;U_BL7m\u001d\u000b\u0007\u0005+\u0012)G!\u001d\t\u000f\t\u001dt\u00051\u0001\u0003j\u0005ya.Y7fgR{G*[:uS:<7\u000f\u0005\u0005\u0002$\t-\u0012\u0011\u0005B6!\r\u0019(QN\u0005\u0004\u0005_\"(\u0001\u0004+pa&\u001cG*[:uS:<\u0007\"\u0003B%OA\u0005\t\u0019AAH\u0003aiwnY6MSN$Hk\u001c9jGN$C-\u001a4bk2$HEM\u0001\u0010[>\u001c7\u000eT5ti6K'O]8sgR\u0011!\u0011\u0010\t\u0004g\nm\u0014b\u0001B?i\n\tB*[:u\u001b&\u0014(o\u001c:t%\u0016\u001cX\u000f\u001c;\u0015\t\te$\u0011\u0011\u0005\b\u0005kQ\u0003\u0019\u0001B\u001c\u0003\u0019\u0019wN\u001c4jOR!!Q\u0003BD\u0011\u001d\u0011Ii\u000ba\u0001\u0003C\t1\u0002^8qS\u000e4\u0015\u000e\u001c;fe\u0006\u0001B/Z:u\u001b&\u0014(o\u001c:U_BL7m\u001d\u000b\r\u0003c\u0013yIa%\u0003\u0018\nm%q\u0014\u0005\b\u0005#c\u0003\u0019\u0001B\u001c\u00031\u0019x.\u001e:dKR{\u0007/[2t\u0011\u001d\u0011)\n\fa\u0001\u0005o\t!c]8ve\u000e,W*\u001b:s_J$v\u000e]5dg\"9!\u0011\u0014\u0017A\u0002\t]\u0012A\u00033fgR$v\u000e]5dg\"9!Q\u0014\u0017A\u0002\t]\u0012aD3ya\u0016\u001cG/\u001a3NSJ\u0014xN]:\t\u000f\t\rE\u00061\u0001\u0003\u0016QQ\u0011\u0011\u0017BR\u0005K\u00139K!+\t\u000f\tEU\u00061\u0001\u00038!9!\u0011T\u0017A\u0002\t]\u0002b\u0002BO[\u0001\u0007!q\u0007\u0005\b\u0005Wk\u0003\u0019AA\u0011\u0003\u00191\u0017\u000e\u001c;fe\u0006IB/Z:u\u001b&\u0014(o\u001c:U_BL7m]#yG\u0016\u0004H/[8o)\u0019\t\tL!-\u00036\"I!1\u0017\u0018\u0011\u0002\u0003\u0007\u0011qR\u0001\u0016GJ,\u0017\r^3U_BL7m]#yG\u0016\u0004H/[8o\u0011%\u00119L\fI\u0001\u0002\u0004\ty)A\nmSN$Hk\u001c9jGN,\u0005pY3qi&|g.A\u0012uKN$X*\u001b:s_J$v\u000e]5dg\u0016C8-\u001a9uS>tG\u0005Z3gCVdG\u000fJ\u0019\u0002GQ,7\u000f^'jeJ|'\u000fV8qS\u000e\u001cX\t_2faRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0011B/Z:u\u001b&\u0014(o\u001c:P]\u0016$v\u000e]5dQ\r\t$\u0011\u0019\t\u0005\u0003w\u0013\u0019-\u0003\u0003\u0003F\u0006u&\u0001\u0002+fgR\fq\u0004^3ti:{7I]3bi\u0016$v\u000e]5dg&3Gk\u001c9jG\u0016C\u0018n\u001d;tQ\r\u0011$\u0011Y\u0001\u001bi\u0016\u001cHo\u0011:fCR,Gk\u001c9jGN<\u0016\u000e\u001e5Qe\u00164\u0017\u000e\u001f\u0015\u0004g\t\u0005\u0017!\t;fgRtun\u0011:fCR,Gk\u001c9jGNLe\rV8qS\u000eL5/T5se>\u0014\bf\u0001\u001b\u0003B\u0006qA/Z:u\u0013:LG/[1mSj,\u0007fA\u001b\u0003B\u0006yB/Z:u\u001b&\u0014(o\u001c:P]\u0016$v\u000e]5d\rJ|W.Q6DYV\u001cH/\u001a:)\u0007Y\u0012\t-\u0001\ruKN$\u0018J\\2mk\u0012,G*\u001b;fe\u0006dg)\u001b7uKJD3a\u000eBa\u0003e!Xm\u001d;J]\u000edW\u000fZ3Qe\u00164\u0017\u000e_3e\r&dG/\u001a:)\u0007a\u0012\t-\u0001\ruKN$X\t_2mk\u0012,G*\u001b;fe\u0006dg)\u001b7uKJD3!\u000fBa\u0003e!Xm\u001d;Fq\u000edW\u000fZ3Qe\u00164\u0017\u000e_3e\r&dG/\u001a:)\u0007i\u0012\t-\u0001\nuKN$()\u0019;dQ6K'O]8sS:<\u0007fA\u001e\u0003B\u0006YB/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001c\u0018)\u001e;i\u000bb\u001cW\r\u001d;j_:D3\u0001\u0010Ba\u0003u!Xm\u001d;De\u0016\fG/\u001a+pa&\u001c7/Q;uQ\u0016C8-\u001a9uS>t\u0007fA\u001f\u0003B\u0006yB/Z:u\u0007J,\u0017\r^3U_BL7m]#ySN$8/\u0012=dKB$\u0018n\u001c8)\u0007y\u0012\t-A\u000euKN$H)Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cX\t_2faRLwN\u001c\u0015\u0004\u007f\t\u0005\u0017\u0001\b;fgR\u0014V-\\5se>\u0014H)\u001a7fi\u0016$G)Z:u)>\u0004\u0018n\u0019\u0015\u0004\u0001\n\u0005\u0017\u0001\u0007;fgRl\u0015N\u001d:pe:+woU8ve\u000e,Gk\u001c9jG\"\u001a\u0011I!1\u0002)Q,7\u000f^!eI&s7\r\\;eK\u001aKG\u000e^3sQ\r\u0011%\u0011Y\u0001\u0018i\u0016\u001cH\u000fR3mKR,W\t_2mk\u0012,g)\u001b7uKJD3a\u0011Ba\u0003]!Xm\u001d;EK2,G/Z%oG2,H-\u001a$jYR,'\u000fK\u0002E\u0005\u0003\fq\u0006^3ti:{G)\u001e9mS\u000e\fG/Z\"sK\u0006$X\rV8qS\u000e\u001c8)\u00197m\r>\u0014X\t_5ti&tw\rV8qS\u000eD3!\u0012Ba\u0003I\"Xm\u001d;U_BL7mQ1o\u0005\u0016\u001c%/Z1uK\u0012\fe\r^3s\u0007>tg\r\\5di&tw\rV8qS\u000e$U\r\\3uS>t\u0007f\u0001$\u0003B\u00061C/Z:u\u001d>\u001c%/Z1uKR{\u0007/[2t\u0007\u0006dGNR8s\u0013:$XM\u001d8bYR{\u0007/[2)\u0007\u001d\u0013\t-A\u0014uKN$hj\\\"sK\u0006$X\rV8qS\u000e\u001c8)\u00197m\r>\u00148i\u001c8gYV,g\u000e\u001e+pa&\u001c\u0007f\u0001%\u0003B\u0006\u0001d/\u001a:jMftun\u0011:fCR,Gk\u001c9jGN4uN]%oi\u0016\u0014h.\u00197Pe\u000e{gN\u001a7vK:$Hk\u001c9jGN$B!!-\u0004(!91\u0011F%A\u0002\t-\u0014\u0001\u0004;pa&\u001cG*[:uS:<\u0017A\b;fgR\u001cuN\u001c4mS\u000e$\u0018N\\4EKN$8)Y2iKZ\u000bG.^3tQ\rQ%\u0011Y\u0001*i\u0016\u001cHOT8De\u0016\fG/\u001a+pa&\u001cw+\u001b;i\u0013:\f7\r^5wK6K'O]8s)>\u0004\u0018nY:)\u0007-\u0013\t-\u0001\u0014uKN$X*\u001e7uSBdWm\u0016:ji\u0016\u00148/T3sO\u0016$v\u000e]5dgR{7I]3bi\u0016D3\u0001\u0014Ba\u0003M\"Xm\u001d;T_V\u00148-Z\"mkN$XM]\"b]\u000e{g\u000e^1j]6K'O]8s)>\u0004\u0018nY:SKR,(O\\:GC2\u001cX\rK\u0002N\u0005\u0003\f\u0001\n^3tiN{WO]2f\u00072,8\u000f^3s\u0007\u0006t7i\u001c8uC&tW*\u001b:s_J$v\u000e]5dgJ+G/\u001e:ogR\u0013X/\u001a#vKR{wK]8oO\u0016\u0013(o\u001c:NKN\u001c\u0018mZ3)\u00079\u0013\t-A uKN$8k\\;sG\u0016\u001cE.^:uKJ\u001c\u0015M\\\"p]R\f\u0017N\\'jeJ|'\u000fV8qS\u000e\u001c()Y:jG\u000ecWo\u001d;feJ+G/\u001e:og\u001a\u000bGn]3)\u0007=\u0013\t-A\buKN$h)\u001b7uKJ$v\u000e]5dQ\r\u0001&\u0011\u0019\u0002\u0010)\u0016\u001cH/\u00113nS:\u001cE.[3oiN\u0019\u0011ka\u0013\u0011\u0007M\u001ci%C\u0002\u0004PQ\u0014q\"T8dW\u0006#W.\u001b8DY&,g\u000e^\u0001\u0005]>$W\r\u0005\u0003\u0002V\rU\u0013\u0002BB,\u0003/\u0012AAT8eKR!11LB0!\r\u0019i&U\u0007\u0002\u0001!91\u0011K*A\u0002\rMSCAB2!\u0019\t\u0019c!\u001a\u0002\"%!!QIA\u001b\u0003)!x\u000e]5dg~#S-\u001d\u000b\u0005\u0003c\u001bY\u0007C\u0005\u0004nU\u000b\t\u00111\u0001\u0004d\u0005\u0019\u0001\u0010J\u0019\u0002\u000fQ|\u0007/[2tA\u0005aA-\u001a7fi\u0016\u001c\u0015\r\u001c7fIV\u0011\u0011\u0011]\u0001\u0011I\u0016dW\r^3DC2dW\rZ0%KF$B!!-\u0004z!I1Q\u000e-\u0002\u0002\u0003\u0007\u0011\u0011]\u0001\u000eI\u0016dW\r^3DC2dW\r\u001a\u0011\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\r\t}1\u0011QBI\u0011\u001d\u0019\u0019I\u0017a\u0001\u0007\u000b\u000b\u0011B\\3x)>\u0004\u0018nY:\u0011\r\u0005}2qQBF\u0013\u0011\u0019I)!\u0011\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002t\u0007\u001bK1aa$u\u0005!qUm\u001e+pa&\u001c\u0007bBBJ5\u0002\u00071QS\u0001\b_B$\u0018n\u001c8t!\r\u00198qS\u0005\u0004\u00073#(aE\"sK\u0006$X\rV8qS\u000e\u001cx\n\u001d;j_:\u001c\u0018\u0001\u00043fY\u0016$X\rV8qS\u000e\u001cH\u0003BBP\u0007K\u00032a]BQ\u0013\r\u0019\u0019\u000b\u001e\u0002\u0013\t\u0016dW\r^3U_BL7m\u001d*fgVdG\u000fC\u0004\u00036m\u0003\raa*\u0011\r\u0005}2qQA\u0011\u0003E\tG\r\u001a+pa&\u001cw*\u001e;PM\n\u000bg\u000e\u001a\u000b\u0005\u0003c\u001bi\u000bC\u0004\u00040r\u0003\r!!\t\u0002\u000bQ|\u0007/[2")
public class ClusterLinkAutoMirroringTest {
    private final ConfluentAdmin sourceAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ConfluentAdmin destAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)Mockito.mock(ClusterLinkClientManager.class);
    private final String includeAllFilter;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkData linkData = new ClusterLinkData("testLink", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final Option<Throwable> topicExistsException = new Some((Object)new TopicExistsException(""));
    private final Option<Throwable> authorizationException = new Some((Object)new AuthorizationException(""));

    private ConfluentAdmin sourceAdmin() {
        return this.sourceAdmin;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private String includeAllFilter() {
        return this.includeAllFilter;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private Option<Throwable> topicExistsException() {
        return this.topicExistsException;
    }

    private Option<Throwable> authorizationException() {
        return this.authorizationException;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    private void resetMock() {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.sourceAdmin()});
        Mockito.reset((Object[])new ConfluentAdmin[]{this.destAdmin()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ClusterLinkClientManager[]{this.clientManager()});
    }

    private void setupMock(boolean skipMetadataManagerLinkedTopicsAndReplay) {
        this.resetMock();
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.sourceAdmin());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true)))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (!skipMetadataManagerLinkedTopicsAndReplay) {
            Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)Predef$.MODULE$.Map().empty());
        }
    }

    private boolean setupMock$default$1() {
        return false;
    }

    private void verifyMock(boolean skipMetadataManagerLinkedTopicsAndReplay) {
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).scheduler();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).getAdmin();
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.atLeastOnce())).isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        if (!skipMetadataManagerLinkedTopicsAndReplay) {
            ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.atLeastOnce())).mirrorTopicsForLink(ArgumentMatchers.anyString());
        }
    }

    private boolean verifyMock$default$1() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkAutoMirroring mirrorTopicsAndVerify(ClusterLinkConfig clusterLinkConfig) {
        void var2_2;
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)clusterLinkConfig);
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock(false);
        return var2_2;
    }

    private CreateTopicsResult mockCreateTopics(scala.collection.immutable.Map<String, Option<Throwable>> topicsToEx) {
        HashMap futures = new HashMap();
        KafkaFutureImpl allFuture = new KafkaFutureImpl();
        IntRef numExceptions = IntRef.create((int)0);
        topicsToEx.foreach((Function1 & Serializable)x0$1 -> {
            KafkaFutureImpl future;
            String topicName;
            if (x0$1 != null) {
                topicName = (String)x0$1._1();
                Option ex = (Option)x0$1._2();
                future = new KafkaFutureImpl();
                if (ex instanceof Some) {
                    Throwable e = (Throwable)((Some)ex).value();
                    future.completeExceptionally(e);
                    ++numExceptions$1.elem;
                } else {
                    future.complete((Object)new CreateTopicsResult.TopicMetadataAndConfig(Uuid.randomUuid(), 1, 1, new Config(Collections.emptyList())));
                }
            } else {
                throw new MatchError(null);
            }
            KafkaFuture kafkaFuture = (KafkaFuture)futures.put(topicName, future);
            return kafkaFuture;
        });
        if (numExceptions.elem > 0) {
            allFuture.completeExceptionally((Throwable)((Option)((Tuple2)topicsToEx.head())._2()).get());
        } else {
            allFuture.complete(null);
        }
        CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
        Mockito.when((Object)result.values()).thenReturn(futures);
        Mockito.when((Object)result.all()).thenReturn((Object)allFuture);
        return result;
    }

    private CreateTopicsResult mockCreateTopicsSameResult(Set<String> topics, Option<Throwable> ex) {
        return this.mockCreateTopics((scala.collection.immutable.Map<String, Option<Throwable>>)((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)ex))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Option<Throwable> mockCreateTopicsSameResult$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListTopicsResult mockNoInternalListTopics(Set<String> topics, Option<Throwable> ex) {
        scala.collection.immutable.Map namesToListings = ((IterableOnceOps)topics.map((Function1 & Serializable)topicName -> new Tuple2(topicName, (Object)new TopicListing(topicName, Uuid.ZERO_UUID, false)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return this.mockListTopics((scala.collection.immutable.Map<String, TopicListing>)namesToListings, ex);
    }

    private Option<Throwable> mockNoInternalListTopics$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListTopicsResult mockListTopics(scala.collection.immutable.Map<String, TopicListing> namesToListings, Option<Throwable> ex) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (ex instanceof Some) {
            Throwable e = (Throwable)((Some)ex).value();
            future.completeExceptionally(e);
        } else {
            future.complete((Object)CollectionConverters$.MODULE$.MapHasAsJava(namesToListings).asJava());
        }
        ListTopicsResult result = (ListTopicsResult)Mockito.mock(ListTopicsResult.class);
        Mockito.when((Object)result.namesToListings()).thenReturn((Object)future);
        KafkaFutureImpl namesFuture = new KafkaFutureImpl();
        namesFuture.complete(CollectionConverters$.MODULE$.MapHasAsJava(namesToListings).asJava().keySet());
        Mockito.when((Object)result.names()).thenReturn((Object)namesFuture);
        return result;
    }

    private Option<Throwable> mockListTopics$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListMirrorsResult mockListMirrors() {
        return this.mockListMirrors((Set<String>)((Set)Set$.MODULE$.empty()));
    }

    /*
     * WARNING - void declaration
     */
    private ListMirrorsResult mockListMirrors(Set<String> topics) {
        void var3_3;
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)CollectionConverters$.MODULE$.MutableSetHasAsJava(topics).asJava());
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        return var3_3;
    }

    private ClusterLinkConfig config(String topicFilter) {
        return ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilter)}))).asJava(), true);
    }

    private void testMirrorTopics(Set<String> sourceTopics, Set<String> sourceMirrorTopics, Set<String> destTopics, Set<String> expectedMirrors, ClusterLinkConfig config) {
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopics.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics(sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors(sourceMirrorTopics);
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(100).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(config);
        Assertions.assertEquals(expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
        }
    }

    private void testMirrorTopics(Set<String> sourceTopics, Set<String> destTopics, Set<String> expectedMirrors, String filter) {
        this.testMirrorTopics(sourceTopics, (Set<String>)((Set)Set$.MODULE$.empty()), destTopics, expectedMirrors, this.config(filter));
    }

    private void testMirrorTopicsException(Option<Throwable> createTopicsException, Option<Throwable> listTopicsException) {
        this.setupMock(false);
        Set sampleSet = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set emptySet = (Set)Set$.MODULE$.empty();
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sampleSet, listTopicsException);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult mockCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sampleSet, createTopicsException);
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockCreateTopicsResult);
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(this.config(this.includeAllFilter()));
        Assertions.assertEquals((Object)emptySet, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).listTopics();
    }

    private Option<Throwable> testMirrorTopicsException$default$1() {
        return Option$.MODULE$.empty();
    }

    private Option<Throwable> testMirrorTopicsException$default$2() {
        return Option$.MODULE$.empty();
    }

    @Test
    public void testMirrorOneTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, this.includeAllFilter());
    }

    @Test
    public void testNoCreateTopicsIfTopicExists() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, this.includeAllFilter());
    }

    @Test
    public void testCreateTopicsWithPrefix() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set sourceMirrorTopics = (Set)Set$.MODULE$.empty();
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), true);
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)sourceMirrorTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, clConfig);
    }

    @Test
    public void testNoCreateTopicsIfTopicIsMirror() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set sourceMirrorTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), true);
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)sourceMirrorTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, clConfig);
    }

    @Test
    public void testInitialize() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), true);
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult listMirrorsResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)listMirrorsResult.result()).thenReturn((Object)future);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(100).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)clConfig);
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        Assertions.assertFalse((boolean)clusterLinkAutoMirroring.getInitialized());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)clusterLinkAutoMirroring.getInitialized());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)clusterLinkAutoMirroring.getInitialized());
        this.verifyMock(true);
        ((ListMirrorsResult)Mockito.verify((Object)listMirrorsResult)).result();
        ((ConfluentAdmin)Mockito.verify((Object)this.sourceAdmin())).listMirrors((ListMirrorsOptions)ArgumentMatchers.any());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
        }
    }

    @Test
    public void testMirrorOneTopicFromAkCluster() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), true);
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopics.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult listMirrorsResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)listMirrorsResult.result()).thenReturn((Object)future);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(100).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(clConfig);
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ((ListMirrorsResult)Mockito.verify((Object)listMirrorsResult)).result();
        ((ConfluentAdmin)Mockito.verify((Object)this.sourceAdmin())).listMirrors((ListMirrorsOptions)ArgumentMatchers.any());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
        }
    }

    @Test
    public void testIncludeLiteralFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"include-topic\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testIncludePrefixedFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testExcludeLiteralFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude-topic\",\"filterType\":\"EXCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testExcludePrefixedFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude\",\"filterType\":\"EXCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testBatchMirroring() {
        Set sourceTopics = (Set)Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> sourceTopics.add((Object)new StringBuilder(6).append("topic-").append(i).toString()));
        Set destTopics = (Set)Set$.MODULE$.empty();
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)sourceTopics, this.includeAllFilter());
    }

    @Test
    public void testListTopicsAuthException() {
        Option option;
        Option<Throwable> x$1 = this.authorizationException();
        Option option2 = option = Option$.MODULE$.empty();
        option = null;
        Option x$2 = option2;
        this.testMirrorTopicsException((Option<Throwable>)x$2, x$1);
    }

    @Test
    public void testCreateTopicsAuthException() {
        this.testMirrorTopicsException(this.authorizationException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testCreateTopicsExistsException() {
        this.testMirrorTopicsException(this.topicExistsException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testDestListTopicsException() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.setupMock(false);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, this.authorizationException());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin())).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testRemirrorDeletedDestTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
    }

    @Test
    public void testMirrorNewSourceTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic", "test-topic-2"}));
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ConcurrentHashMap<String, ClusterLinkTopicState.Mirror> linkedTopicsNew = new ConcurrentHashMap<String, ClusterLinkTopicState.Mirror>();
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("test-topic", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds());
        linkedTopicsNew.put("test-topic", testActiveTopicState);
        this.setupMock(true);
        ListTopicsResult mockSourceTopicsList = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult mockSourceTopicsNewList = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)mockSourceTopicsList).thenReturn((Object)mockSourceTopicsNewList);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopicsNew).asScala());
        CreateTopicsResult mockSourceCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult mockTestTopics2Result = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockSourceCreateTopicsResult).thenReturn((Object)mockTestTopics2Result);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(true);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicsForLink(ArgumentMatchers.anyString());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testAddIncludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic", "new-topic"}));
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ConcurrentHashMap<String, ClusterLinkTopicState.Mirror> linkedTopicsNew = new ConcurrentHashMap<String, ClusterLinkTopicState.Mirror>();
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("old-topic", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds());
        linkedTopicsNew.put("old-topic", testActiveTopicState);
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"old\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"old\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"},{\"name\":\"new\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopicsNew).asScala());
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult newCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"new-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult).thenReturn((Object)newCreateTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne)).thenReturn((Object)this.config(filterTwo));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"new-topic"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(true);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicsForLink(ArgumentMatchers.anyString());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testDeleteExcludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude\",\"filterType\":\"EXCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        CreateTopicsResult mockIncludeTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult mockExcludeTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exclude-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockIncludeTopicsResult).thenReturn((Object)mockExcludeTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne)).thenReturn((Object)this.config(filterTwo));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exclude-topic"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicsForLink(ArgumentMatchers.anyString());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testDeleteIncludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2", "test-topic-3"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"test\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"},{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult listTopicsNewResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult, (Object[])new ListTopicsResult[]{listTopicsNewResult});
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne), (Object[])new ClusterLinkConfig[]{this.config(filterOne), this.config(filterTwo), this.config(filterTwo)});
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopicsNew.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)Predef$.MODULE$.Map().empty()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicsForLink(ArgumentMatchers.anyString());
        ((Admin)Mockito.verify((Object)this.destAdmin())).createTopics((Collection)ArgumentMatchers.any());
        ((ClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testNoDuplicateCreateTopicsCallForExistingTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set nonMirrorDestTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        ListTopicsResult listDestTopicsResult = this.mockNoInternalListTopics((Set<String>)nonMirrorDestTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listDestTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testTopicCanBeCreatedAfterConflictingTopicDeletion() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set nonMirrorDestTopics = (Set)Set$.MODULE$.empty();
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResultTopicExists = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResultTopicExists).thenReturn((Object)createTopicsResult);
        ListTopicsResult nonMirrorDestTopicsResult = this.mockNoInternalListTopics((Set<String>)nonMirrorDestTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)nonMirrorDestTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testNoCreateTopicsCallForInternalTopic() {
        TopicListing internalTopic = new TopicListing("_mock_internal_topic", Uuid.ZERO_UUID, true);
        this.verifyNoCreateTopicsForInternalOrConfluentTopics(internalTopic);
    }

    @Test
    public void testNoCreateTopicsCallForConfluentTopic() {
        TopicListing confluentTopic = new TopicListing("_confluent-metadata-auth", Uuid.ZERO_UUID, false);
        this.verifyNoCreateTopicsForInternalOrConfluentTopics(confluentTopic);
    }

    private void verifyNoCreateTopicsForInternalOrConfluentTopics(TopicListing topicListing) {
        this.setupMock(false);
        ListTopicsResult mockListTopicsResult = this.mockListTopics((scala.collection.immutable.Map<String, TopicListing>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicListing.name()), (Object)topicListing)}))), (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)mockListTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics()).runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock(false);
    }

    @Test
    public void testConflictingDestCacheValues() {
        Set sourceTopicsOld = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1", "test-topic-2"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"}));
        this.setupMock(false);
        ListTopicsResult listOldTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsOld, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult listNewTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listOldTopicsResult).thenReturn((Object)listNewTopicsResult);
        ListMirrorsResult mirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)mirrorsResult);
        ListTopicsResult listDestTopicsResult = this.mockNoInternalListTopics((Set<String>)destTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listDestTopicsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopicsOld, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult).thenReturn((Object)this.mockCreateTopics((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-2"), this.topicExistsException()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-1"), (Object)Option$.MODULE$.empty())})))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopicsOld, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopicsOld, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testNoCreateTopicWithInactiveMirrorTopics() {
        this.resetMock();
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.sourceAdmin());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true)))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("testLink", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.PendingStoppedMirror testPendingStopTopicState = new ClusterLinkTopicState.PendingStoppedMirror("testLink", this.linkId(), this.sourceTopicId(), false, Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.FailedMirror testFailedTopicState = new ClusterLinkTopicState.FailedMirror("testLink", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.StoppedMirror testStoppedTopicState = new ClusterLinkTopicState.StoppedMirror("testLink", this.linkId(), this.sourceTopicId(), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.PausedMirror testPausedTopicState = new ClusterLinkTopicState.PausedMirror("testLink", this.linkId(), this.sourceTopicId(), false, true, false, Time.SYSTEM.milliseconds());
        ConcurrentHashMap<String, Object> linkedTopics = new ConcurrentHashMap<String, Object>();
        linkedTopics.put("testTopic", testActiveTopicState);
        linkedTopics.put("testTopicPendingStopped", testPendingStopTopicState);
        linkedTopics.put("testTopicFailed", testFailedTopicState);
        linkedTopics.put("testTopicPaused", testPausedTopicState);
        linkedTopics.put("testTopicStopped", testStoppedTopicState);
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(linkedTopics.keySet()).asScala(), (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
    }

    @Test
    public void testMultipleWritersMergeTopicsToCreate() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1"}));
        String outOfBandTopic = "test-topic-2";
        Set expectedTopicsAtEnd = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1", "test-topic-2"}));
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicsForLink(ArgumentMatchers.anyString())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(node);
        mockAdminClient.addTopicOutOfBand(outOfBandTopic);
        Assertions.assertEquals((Object)scala.collection.immutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{outOfBandTopic})), mockAdminClient.topics());
        new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> mockAdminClient, this.metrics()).runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock(false);
        Assertions.assertEquals((Object)expectedTopicsAtEnd, mockAdminClient.topics());
        Assertions.assertFalse((boolean)mockAdminClient.deleteCalled());
    }

    @Test
    public void testSourceClusterCanContainMirrorTopicsReturnsFalse() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Assertions.assertFalse((boolean)SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result()));
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    @Test
    public void testSourceClusterCanContainMirrorTopicsReturnsTrueDueToWrongErrorMessage() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS with version..."));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Assertions.assertTrue((boolean)SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result()));
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    @Test
    public void testSourceClusterCanContainMirrorTopicsBasicClusterReturnsFalse() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new ClusterLinkDisabledException("Cluster linking is disabled"));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Assertions.assertFalse((boolean)SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result()));
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    @Test
    public void testFilterTopic() {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "src_"})).foreach((Function1 & Serializable)prefix -> {
            ClusterLinkAutoMirroringTest.$anonfun$testFilterTopic$1(prefix);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testFilterTopic$1(String prefix) {
        String topic = new StringBuilder(5).append(prefix).append("topic").toString();
        String confluentBalancerApiStateTopic = new StringBuilder(29).append(prefix).append("_confluent_balancer_api_state").toString();
        String schemaTopic = new StringBuilder(8).append(prefix).append("_schemas").toString();
        String auditLogEventsTopic = new StringBuilder(26).append(prefix).append("confluent-audit-log-events").toString();
        scala.collection.mutable.Map namesToListings = (scala.collection.mutable.Map)Map$.MODULE$.apply(((IterableOnceOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new TopicListing(topic, Uuid.fromString((String)"2Ew1y9BsQYCP6WVAzdKwPw"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)schemaTopic), (Object)new TopicListing(schemaTopic, Uuid.fromString((String)"2Ew1y9BsQYCP6WVAzdKwPw"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)auditLogEventsTopic), (Object)new TopicListing(auditLogEventsTopic, Uuid.fromString((String)"3ww2z11a0ABC7AAAzdzw0w"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)confluentBalancerApiStateTopic), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"QOtODWOVSnufqbbXBMqitw"), false))}))).toSeq());
        Assertions.assertFalse((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), topic));
        Assertions.assertTrue((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), confluentBalancerApiStateTopic));
        Assertions.assertTrue((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), schemaTopic));
        Assertions.assertTrue((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), auditLogEventsTopic));
    }

    public ClusterLinkAutoMirroringTest() {
        this.includeAllFilter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
    }

    public class TestAdminClient
    extends MockAdminClient {
        private scala.collection.immutable.Set<String> topics;
        private boolean deleteCalled;

        public scala.collection.immutable.Set<String> topics() {
            return this.topics;
        }

        public void topics_$eq(scala.collection.immutable.Set<String> x$1) {
            this.topics = x$1;
        }

        public boolean deleteCalled() {
            return this.deleteCalled;
        }

        public void deleteCalled_$eq(boolean x$1) {
            this.deleteCalled = x$1;
        }

        public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
            scala.collection.immutable.Map results = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(newTopics).asScala().map((Function1 & Serializable)newTopic -> {
                KafkaFutureImpl future = new KafkaFutureImpl();
                if (this.topics().contains((Object)newTopic.name())) {
                    future.completeExceptionally((Throwable)new TopicExistsException("Topic already exists"));
                } else {
                    this.topics_$eq((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)this.topics().$plus((Object)newTopic.name())));
                    future.complete(null);
                }
                return new Tuple2((Object)newTopic.name(), (Object)future);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
            Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava());
            return result;
        }

        public DeleteTopicsResult deleteTopics(Collection<String> topics) {
            this.deleteCalled_$eq(true);
            topics.forEach(x -> topics.remove(x));
            return (DeleteTopicsResult)Mockito.mock(DeleteTopicsResult.class);
        }

        public void addTopicOutOfBand(String topic) {
            this.topics_$eq((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)this.topics().$plus((Object)topic)));
        }

        public /* synthetic */ ClusterLinkAutoMirroringTest kafka$server$link$ClusterLinkAutoMirroringTest$TestAdminClient$$$outer() {
            return ClusterLinkAutoMirroringTest.this;
        }

        public TestAdminClient(Node node) {
            if (ClusterLinkAutoMirroringTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
            this.topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            this.deleteCalled = false;
        }
    }
}

