/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ConnectionMode;
import kafka.server.link.LinkMode;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\teg\u0001\u0002\u001f>\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004V\u0001\u0001\u0006I!\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019\u0001\u0007\u0001)A\u00051\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB5\u0001A\u0003%1\rC\u0004k\u0001\t\u0007I\u0011B,\t\r-\u0004\u0001\u0015!\u0003Y\u0011\u001da\u0007A1A\u0005\n]Ca!\u001c\u0001!\u0002\u0013A\u0006b\u00028\u0001\u0005\u0004%Ia\u001c\u0005\u0007m\u0002\u0001\u000b\u0011\u00029\t\u000f]\u0004!\u0019!C\u0005q\"1A\u0010\u0001Q\u0001\neDq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B@\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0006\t\u0013\u0005}\u0001A1A\u0005\n\u0005\u0005\u0002\u0002CA\u001d\u0001\u0001\u0006I!a\t\t\u0013\u0005m\u0002A1A\u0005\n\u0005u\u0002\u0002CA(\u0001\u0001\u0006I!a\u0010\t\u0013\u0005E\u0003A1A\u0005\n\u0005M\u0003\u0002CA2\u0001\u0001\u0006I!!\u0016\t\u0013\u0005\u0015\u0004A1A\u0005\n\u0005\u001d\u0004\u0002CA@\u0001\u0001\u0006I!!\u001b\t\u0017\u0005\u0005\u0005\u00011AA\u0002\u0013%\u00111\u0011\u0005\f\u0003\u0017\u0003\u0001\u0019!a\u0001\n\u0013\ti\tC\u0006\u0002\u001a\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0005bCAN\u0001\u0001\u0007\t\u0019!C\u0005\u0003;C1\"!*\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(\"Y\u00111\u0016\u0001A\u0002\u0003\u0005\u000b\u0015BAP\u0011-\ti\u000b\u0001a\u0001\u0002\u0004%I!a,\t\u0017\u0005]\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0018\u0005\f\u0003{\u0003\u0001\u0019!A!B\u0013\t\t\fC\u0006\u0002@\u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0007bCAb\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bD1\"!3\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002z!Y\u00111\u001a\u0001A\u0002\u0003\u0007I\u0011BAg\u0011-\t9\u000e\u0001a\u0001\u0002\u0004%I!!7\t\u0017\u0005u\u0007\u00011A\u0001B\u0003&\u0011q\u001a\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\tI\u0010\u0001C\u0001\u0003CDqAa\u0001\u0001\t\u0003\t\t\u000fC\u0004\u0003\u000e\u0001!\t!!9\t\u000f\tE\u0001\u0001\"\u0001\u0002b\"9!Q\u0003\u0001\u0005\u0002\u0005\u0005\bb\u0002B\r\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005;\u0001A\u0011AAq\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqA!!\u0001\t\u0013\u0011\u0019\tC\u0004\u0003\u0006\u0002!IAa\"\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BR\u0001\u0011%!Q\u0015\u0005\n\u0005\u0003\u0004\u0011\u0013!C\u0005\u0005\u0007\u0014Ae\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"p]:,7\r^5p]6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003}}\nA\u0001\\5oW*\u0011\u0001)Q\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"A\u001f\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0016\u0003E\u0003\"AU*\u000e\u0003}J!\u0001V \u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000eEJ|7.\u001a:D_:4\u0017n\u001a\u0011\u0002\u00111Lgn\u001b(b[\u0016,\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bA\u0001\\1oO*\tQ,\u0001\u0003kCZ\f\u0017BA0[\u0005\u0019\u0019FO]5oO\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0007Y&t7.\u00133\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a/\u0002\tU$\u0018\u000e\\\u0005\u0003Q\u0016\u0014A!V+J\t\u00069A.\u001b8l\u0013\u0012\u0004\u0013aD:pkJ\u001cWm\u00117vgR,'/\u00133\u0002!M|WO]2f\u00072,8\u000f^3s\u0013\u0012\u0004\u0013!\u00043fgR\u001cE.^:uKJLE-\u0001\beKN$8\t\\;ti\u0016\u0014\u0018\n\u001a\u0011\u0002\u00111Lgn\u001b#bi\u0006,\u0012\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003g\u0006\u000b!A_6\n\u0005U\u0014(aD\"mkN$XM\u001d'j].$\u0015\r^1\u0002\u00131Lgn\u001b#bi\u0006\u0004\u0013!\u00037j].\u0004&o\u001c9t+\u0005I\bC\u00013{\u0013\tYXM\u0001\u0006Qe>\u0004XM\u001d;jKN\f!\u0002\\5oWB\u0013x\u000e]:!\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014X#A@\u0011\u00079\u000b\t!C\u0002\u0002\u0004u\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u0006!\rq\u0015QB\u0005\u0004\u0003\u001fi$\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\n1\u0002\\5oW6\u000bg.Y4feV\u0011\u0011q\u0003\t\u0004\u001d\u0006e\u0011bAA\u000e{\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u00031a\u0017N\\6NC:\fw-\u001a:!\u00035qW\r^<pe.\u001cE.[3oiV\u0011\u00111\u0005\t\u0005\u0003K\t)$\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003\u001d\u0019G.[3oiNT1AQA\u0017\u0015\u0011\ty#!\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019$A\u0002pe\u001eLA!a\u000e\u0002(\tia*\u001a;x_J\\7\t\\5f]R\faB\\3uo>\u00148n\u00117jK:$\b%\u0001\u000bbI6Lg.T3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005j]R,'O\\1mg*!\u0011\u0011JA\u0014\u0003\u0015\tG-\\5o\u0013\u0011\ti%a\u0011\u0003)\u0005#W.\u001b8NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003U\tG-\\5o\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002VA!\u0011qKA0\u001b\t\tIF\u0003\u0003\u0002R\u0005m#\u0002BA/\u0003W\taaY8n[>t\u0017\u0002BA1\u00033\u0012q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u00035\u0019Gn\\:fI\u000ec\u0017.\u001a8ugV\u0011\u0011\u0011\u000e\t\u0007\u0003W\n)(!\u001f\u000e\u0005\u00055$\u0002BA8\u0003c\nq!\\;uC\ndWMC\u0002\u0002t\u001d\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9(!\u001c\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004\u001d\u0006m\u0014bAA?{\t12\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\"mS\u0016tG/\u0001\bdY>\u001cX\rZ\"mS\u0016tGo\u001d\u0011\u0002\u00151Lgn[\"p]\u001aLw-\u0006\u0002\u0002\u0006B\u0019a*a\"\n\u0007\u0005%UHA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\fa\u0002\\5oW\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0006U\u0005c\u0001$\u0002\u0012&\u0019\u00111S$\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003/{\u0012\u0011!a\u0001\u0003\u000b\u000b1\u0001\u001f\u00132\u0003-a\u0017N\\6D_:4\u0017n\u001a\u0011\u0002\u00171Lgn['fiJL7m]\u000b\u0003\u0003?\u00032ATAQ\u0013\r\t\u0019+\u0010\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/A\bmS:\\W*\u001a;sS\u000e\u001cx\fJ3r)\u0011\ty)!+\t\u0013\u0005]%%!AA\u0002\u0005}\u0015\u0001\u00047j].lU\r\u001e:jGN\u0004\u0013aC2p]:l\u0015M\\1hKJ,\"!!-\u0011\u00079\u000b\u0019,C\u0002\u00026v\u0012\u0001e\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"p]:,7\r^5p]6\u000bg.Y4fe\u0006y1m\u001c8o\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\u0006m\u0006\"CALK\u0005\u0005\t\u0019AAY\u00031\u0019wN\u001c8NC:\fw-\u001a:!\u0003-\u0011X-\\8uK\u0006#W.\u001b8\u0016\u0005\u0005e\u0014a\u0004:f[>$X-\u00113nS:|F%Z9\u0015\t\u0005=\u0015q\u0019\u0005\n\u0003/C\u0013\u0011!a\u0001\u0003s\nAB]3n_R,\u0017\tZ7j]\u0002\n!\u0002\\8dC2\fE-\\5o+\t\ty\r\u0005\u0003\u0002R\u0006MWBAA$\u0013\u0011\t).a\u0012\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006qAn\\2bY\u0006#W.\u001b8`I\u0015\fH\u0003BAH\u00037D\u0011\"a&,\u0003\u0003\u0005\r!a4\u0002\u00171|7-\u00197BI6Lg\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003\u001fC3!LAs!\u0011\t9/!>\u000e\u0005\u0005%(\u0002BAv\u0003[\f1!\u00199j\u0015\u0011\ty/!=\u0002\u000f),\b/\u001b;fe*!\u00111_A\u0019\u0003\u0015QWO\\5u\u0013\u0011\t90!;\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rq\u0013Q \t\u0005\u0003O\fy0\u0003\u0003\u0003\u0002\u0005%(!C!gi\u0016\u0014X)Y2i\u0003i!Xm\u001d;D_:tWm\u0019;j_:lu\u000eZ3PkR\u0014w.\u001e8eQ\ry#q\u0001\t\u0005\u0003O\u0014I!\u0003\u0003\u0003\f\u0005%(\u0001\u0002+fgR\f\u0011\u0004^3ti\u000e{gN\\3di&|g.T8eK&s'm\\;oI\"\u001a\u0001Ga\u0002\u0002?Q,7\u000f\u001e)feNL7\u000f^3oi\u000e{gN\\3di&|gNR1jYV\u0014X\rK\u00022\u0005\u000f\tq\u0002^3tiJ+7m\u001c8gS\u001e,(/\u001a\u0015\u0004e\t\u001d\u0011!\u0003;fgR\u0004\u0016-^:fQ\r\u0019$qA\u0001\ri\u0016\u001cH\u000fT8h\u0019\u00164X\r\u001c\u0015\u0004i\t\u001d\u0011A\u0004<fe&4\u0017\u0010T8h\u0019\u00164X\r\u001c\u000b\t\u0003\u001f\u0013)Ca\u0016\u0003h!9!qE\u001bA\u0002\t%\u0012!B2mCjT\b\u0007\u0002B\u0016\u0005\u000b\u0002bA!\f\u0003<\t\u0005c\u0002\u0002B\u0018\u0005o\u00012A!\rH\u001b\t\u0011\u0019DC\u0002\u00036\r\u000ba\u0001\u0010:p_Rt\u0014b\u0001B\u001d\u000f\u00061\u0001K]3eK\u001aLAA!\u0010\u0003@\t)1\t\\1tg*\u0019!\u0011H$\u0011\t\t\r#Q\t\u0007\u0001\t1\u00119E!\n\u0002\u0002\u0003\u0005)\u0011\u0001B%\u0005\ryF%M\t\u0005\u0005\u0017\u0012\t\u0006E\u0002G\u0005\u001bJ1Aa\u0014H\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u0012B*\u0013\r\u0011)f\u0012\u0002\u0004\u0003:L\bb\u0002B-k\u0001\u0007!1L\u0001\tCB\u0004XM\u001c3feB!!Q\fB2\u001b\t\u0011yFC\u0002\u0003b\u0005\u000bQ!\u001e;jYNLAA!\u001a\u0003`\t\u0011Bj\\4DCB$XO]3BaB,g\u000eZ3s\u0011\u001d\u0011I'\u000ea\u0001\u0005W\n1\"\\1y\u0019><G*\u001a<fYB)aI!\u001c\u0003r%\u0019!qN$\u0003\r=\u0003H/[8o!\u0011\u0011\u0019H! \u000e\u0005\tU$\u0002\u0002B<\u0005s\nQ!\u001a<f]RTAAa\u001f\u00022\u0005)1\u000f\u001c45U&!!q\u0010B;\u0005\u0015aUM^3m\u0003I\u0019'/Z1uK\n\u0013xn[3s\u0007>tg-[4\u0015\u0003E\u000bac]3ukB\u001cuN\u001c8fGRLwN\\'b]\u0006<WM\u001d\u000b\u0005\u0003\u001f\u0013I\tC\u0004\u0003\f^\u0002\rA!$\u0002\u001d\r|gN\\3di&|g.T8eKB\u0019aJa$\n\u0007\tEUH\u0001\bD_:tWm\u0019;j_:lu\u000eZ3\u0002!\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\\!e[&tGCAAh\u0003E\u0019'/Z1uKJ+Wn\u001c;f\u0003\u0012l\u0017N\u001c\u000b\u0007\u0003s\u0012YJa(\t\u000f\tu\u0015\b1\u0001\u0002\u0006\u000611m\u001c8gS\u001eDqA!):\u0001\u0004\t\t,A\u0004nC:\fw-\u001a:\u0002\u0017I,g/\u001a:tK:{G-\u001a\u000b\u0007\u0005O\u0013\u0019L!0\u0011\t\t%&qV\u0007\u0003\u0005WSAA!,\u0002\\\u00059a.\u001a;x_J\\\u0017\u0002\u0002BY\u0005W\u00131BU3wKJ\u001cXMT8eK\"9!Q\u0017\u001eA\u0002\t]\u0016A\u00028pI\u0016LE\rE\u0002G\u0005sK1Aa/H\u0005\rIe\u000e\u001e\u0005\n\u0005\u007fS\u0004\u0013!a\u0001\u0005o\u000b\u0011B]3rk\u0016\u001cH/\u00133\u0002+I,g/\u001a:tK:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0019\u0016\u0005\u0005o\u00139m\u000b\u0002\u0003JB!!1\u001aBk\u001b\t\u0011iM\u0003\u0003\u0003P\nE\u0017!C;oG\",7m[3e\u0015\r\u0011\u0019nR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bl\u0005\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ClusterLinkDestConnectionManagerTest {
    private final KafkaConfig brokerConfig = this.createBrokerConfig();
    private final String linkName;
    private final UUID linkId = UUID.randomUUID();
    private final String sourceClusterId;
    private final String destClusterId;
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)new Some((Object)this.sourceClusterId()), (Option)None$.MODULE$, false);
    private final Properties linkProps = new Properties();
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ClusterLinkManager linkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private final AdminMetadataManager adminMetadataManager = new AdminMetadataManager(new LogContext(), 100L, 10000L);
    private final Metrics metrics = new Metrics();
    private final ArrayBuffer<ClusterLinkAdminClient> closedClients = ArrayBuffer$.MODULE$.empty();
    private ClusterLinkConfig linkConfig;
    private ClusterLinkMetrics linkMetrics;
    private ClusterLinkDestConnectionManager connManager;
    private ClusterLinkAdminClient remoteAdmin;
    private ConfluentAdmin kafka$server$link$ClusterLinkDestConnectionManagerTest$$localAdmin;

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private String linkName() {
        return this.linkName;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private String sourceClusterId() {
        return this.sourceClusterId;
    }

    private String destClusterId() {
        return this.destClusterId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private Properties linkProps() {
        return this.linkProps;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private AdminMetadataManager adminMetadataManager() {
        return this.adminMetadataManager;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ArrayBuffer<ClusterLinkAdminClient> closedClients() {
        return this.closedClients;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    private ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    private void linkMetrics_$eq(ClusterLinkMetrics x$1) {
        this.linkMetrics = x$1;
    }

    private ClusterLinkDestConnectionManager connManager() {
        return this.connManager;
    }

    private void connManager_$eq(ClusterLinkDestConnectionManager x$1) {
        this.connManager = x$1;
    }

    private ClusterLinkAdminClient remoteAdmin() {
        return this.remoteAdmin;
    }

    private void remoteAdmin_$eq(ClusterLinkAdminClient x$1) {
        this.remoteAdmin = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.kafka$server$link$ClusterLinkDestConnectionManagerTest$$localAdmin;
    }

    public void kafka$server$link$ClusterLinkDestConnectionManagerTest$$localAdmin_$eq(ConfluentAdmin x$1) {
        this.kafka$server$link$ClusterLinkDestConnectionManagerTest$$localAdmin = x$1;
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(this.linkName(), false))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @AfterEach
    public void tearDown() {
        if (this.connManager() != null) {
            this.connManager().shutdown();
        }
        this.scheduler().shutdown();
        this.metrics().close();
    }

    @Test
    public void testConnectionModeOutbound() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Outbound$.MODULE$);
        Assertions.assertNull((Object)this.remoteAdmin());
        this.connManager().startup();
        Assertions.assertNull((Object)this.remoteAdmin());
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.connManager().processReverseConnection(channel, this.reverseNode(1, -1)));
        Assertions.assertNull((Object)this.localAdmin(), (String)"Local admin client created unnecessarily for outbound dest connection manager");
        this.connManager().shutdown();
    }

    @Test
    public void testConnectionModeInbound() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        Assertions.assertNull((Object)this.remoteAdmin());
        this.connManager().startup();
        Assertions.assertNotNull((Object)this.remoteAdmin());
        Assertions.assertTrue((boolean)this.connManager().reverseConnectionProvider(this.networkClient(), (Option)new Some((Object)this.adminMetadataManager()), "").nonEmpty());
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        ReverseNode node1 = this.reverseNode(1, -1);
        this.connManager().processReverseConnection(channel, node1);
        Assertions.assertEquals((int)1, (int)this.connManager().persistentConnectionCount());
        Assertions.assertEquals((int)1, (int)this.connManager().reverseConnectionCount());
        ReverseNode node2 = this.reverseNode(2, 5);
        Assertions.assertThrows(NetworkException.class, () -> this.connManager().processReverseConnection(channel, node2));
        Assertions.assertEquals((int)1, (int)this.connManager().persistentConnectionCount());
        Assertions.assertEquals((int)1, (int)this.connManager().reverseConnectionCount());
        Assertions.assertNotNull((Object)this.localAdmin(), (String)"Local admin client not created for inbound dest connection manager");
        this.connManager().shutdown();
        Assertions.assertNull((Object)this.localAdmin(), (String)"Local admin client was not shutdown");
    }

    @Test
    public void testPersistentConnectionFailure() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        this.connManager().startup();
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        ((KafkaChannel)Mockito.doNothing().when((Object)channel)).close();
        ReverseNode node = this.reverseNode(1, -1);
        this.networkClient().reverseAndAdd((ReverseChannel)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException("Test exception")});
        Assertions.assertThrows(RuntimeException.class, () -> this.connManager().processReverseConnection(channel, node));
        ((NetworkClient)Mockito.verify((Object)this.networkClient())).reverseAndAdd((ReverseChannel)ArgumentMatchers.any());
    }

    @Test
    public void testReconfigure() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        this.connManager().startup();
        ConfluentAdmin oldLocalAdmin = this.localAdmin();
        ClusterLinkAdminClient oldAdmin = this.remoteAdmin();
        this.linkProps().setProperty("metadata.max.age.ms", "1000");
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps(), true));
        this.connManager().reconfigure(this.linkConfig(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"metadata.max.age.ms"})));
        Assertions.assertEquals((Object)this.connManager().currentConfig().originals(), (Object)this.linkConfig().originals());
        Assertions.assertNotNull((Object)this.remoteAdmin());
        Assertions.assertNotSame((Object)oldAdmin, (Object)this.remoteAdmin());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkAdminClient[]{oldAdmin})), (Object)this.closedClients().toSeq());
        Assertions.assertSame((Object)oldLocalAdmin, (Object)this.localAdmin());
    }

    @Test
    public void testPause() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        this.connManager().startup();
        ClusterLinkAdminClient oldAdmin = this.remoteAdmin();
        this.linkProps().setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "true");
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps(), true));
        this.connManager().reconfigure(this.linkConfig(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
        Assertions.assertEquals((Object)this.connManager().currentConfig().originals(), (Object)this.linkConfig().originals());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkAdminClient[]{oldAdmin})), (Object)this.closedClients().toSeq());
        Assertions.assertNull((Object)this.localAdmin(), (String)"Local admin client was not shutdown");
        Assertions.assertNull((Object)this.remoteAdmin(), (String)"Remote admin client was not shutdown");
        this.linkProps().setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "false");
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps(), true));
        this.connManager().reconfigure(this.linkConfig(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
        Assertions.assertNotNull((Object)this.localAdmin(), (String)"Local admin client was not recreated");
        Assertions.assertNotNull((Object)this.remoteAdmin(), (String)"Remote admin client was not recreated");
    }

    @Test
    public void testLogLevel() {
        Class<ClusterLinkDestConnectionManager> clazz = ClusterLinkDestConnectionManager.class;
        Level oldLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(clazz, Level.ALL);
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        try {
            this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)None$.MODULE$);
            this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)new Some(null));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])org.slf4j.event.Level.values()), (Function1 & Serializable)level -> {
                this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)new Some((Object)level));
                return BoxedUnit.UNIT;
            });
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(clazz, oldLevel);
            appender.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void verifyLogLevel(Class<?> clazz, LogCaptureAppender appender, Option<org.slf4j.event.Level> maxLogLevel) {
        currentMaxLevel = new AtomicReference<V>();
        if (maxLogLevel instanceof Some) {
            var5_5 = new LogContext("[TEST] ", currentMaxLevel);
        } else if (None$.MODULE$.equals(maxLogLevel)) {
            var5_5 = new LogContext("[TEST] ");
        } else {
            throw new MatchError(maxLogLevel);
        }
        logger = var5_5.logger(clazz);
        var8_7 = false;
        var9_8 = null;
        if (!(maxLogLevel instanceof Some)) ** GOTO lbl-1000
        var8_7 = true;
        var9_8 = (Some)maxLogLevel;
        if ((org.slf4j.event.Level)var9_8.value() == null) {
            var4_9 = org.slf4j.event.Level.ERROR;
        } else if (var8_7) {
            var4_9 = (org.slf4j.event.Level)var9_8.value();
        } else if (None$.MODULE$.equals(maxLogLevel)) {
            var4_9 = org.slf4j.event.Level.ERROR;
        } else {
            throw new MatchError(maxLogLevel);
        }
        maxLogLevel.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$verifyLogLevel$1$adapted(java.util.concurrent.atomic.AtomicReference org.slf4j.event.Level ), (Lorg/slf4j/event/Level;)Ljava/lang/Object;)(currentMaxLevel));
        logger.trace("trace message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.TRACE, "[TEST] trace message", appender, var4_9);
        logger.debug("debug message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.DEBUG, "[TEST] debug message", appender, var4_9);
        logger.info("info message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.INFO, "[TEST] info message", appender, var4_9);
        logger.warn("warn message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.WARN, "[TEST] warn message", appender, var4_9);
        logger.error("error message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.ERROR, "[TEST] error message", appender, var4_9);
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void setupConnectionManager(ConnectionMode connectionMode) {
        this.linkProps().put(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), connectionMode.name());
        if (ConnectionMode.Outbound$.MODULE$.equals(connectionMode)) {
            this.linkProps().put("bootstrap.servers", "localhost:123");
        }
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps(), true));
        this.linkMetrics_$eq(new ClusterLinkMetrics(this.linkName(), this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, this.linkManager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$));
        this.linkMetrics().startup();
        this.connManager_$eq(new ClusterLinkDestConnectionManager(this.linkData(), this.linkConfig(), this.destClusterId(), (Option)None$.MODULE$, this.linkMetrics(), (Function2 & Serializable)(config, manager) -> this.createRemoteAdmin((ClusterLinkConfig)config, (ClusterLinkDestConnectionManager)manager), (Function1 & Serializable)x$6 -> this.createLocalAdmin(), this.metadataManager(), this.brokerConfig(), (Time)new MockTime()));
    }

    private ConfluentAdmin createLocalAdmin() {
        this.kafka$server$link$ClusterLinkDestConnectionManagerTest$$localAdmin_$eq((ConfluentAdmin)new MockAdminClient(this){
            private final /* synthetic */ ClusterLinkDestConnectionManagerTest $outer;

            public void close(Duration timeout) {
                super.close(timeout);
                this.$outer.kafka$server$link$ClusterLinkDestConnectionManagerTest$$localAdmin_$eq(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.localAdmin();
    }

    private ClusterLinkAdminClient createRemoteAdmin(ClusterLinkConfig config, ClusterLinkDestConnectionManager manager) {
        Assertions.assertEquals((Object)this.linkConfig().originals(), (Object)config.originals());
        Assertions.assertSame((Object)this.connManager(), (Object)manager);
        this.remoteAdmin_$eq((ClusterLinkAdminClient)Mockito.mock(ClusterLinkAdminClient.class));
        ((ClusterLinkAdminClient)Mockito.doAnswer(invocation -> {
            ClusterLinkDestConnectionManagerTest.$anonfun$createRemoteAdmin$1(this, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)this.remoteAdmin())).close();
        Mockito.when((Object)this.remoteAdmin().networkClient()).thenReturn((Object)this.networkClient());
        Mockito.when((Object)this.remoteAdmin().metadataManager()).thenReturn((Object)this.adminMetadataManager());
        return this.remoteAdmin();
    }

    private ReverseNode reverseNode(int nodeId, int requestId) {
        return new ReverseNode(nodeId, nodeId, new StringBuilder(4).append("host").append(nodeId).toString(), 1234, this.linkId(), requestId, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), KafkaPrincipal.ANONYMOUS, Optional.empty(), null);
    }

    private int reverseNode$default$2() {
        return -1;
    }

    private static final void assertLastLog$1(org.slf4j.event.Level logLevel, String expectedMessage, LogCaptureAppender appender$2, org.slf4j.event.Level maxLevel$1) {
        LoggingEvent event = (LoggingEvent)appender$2.getMessages().last();
        Assertions.assertEquals((Object)(maxLevel$1.toInt() < logLevel.toInt() ? maxLevel$1 : logLevel).name(), (Object)event.getLevel().toString());
        Assertions.assertEquals((Object)expectedMessage, (Object)event.getMessage());
    }

    public static final /* synthetic */ void $anonfun$createRemoteAdmin$1(ClusterLinkDestConnectionManagerTest $this, InvocationOnMock invocation) {
        $this.closedClients().$plus$eq((Object)$this.remoteAdmin());
        $this.remoteAdmin_$eq(null);
    }

    public ClusterLinkDestConnectionManagerTest() {
        this.linkName = "testLink";
        this.sourceClusterId = "sourceCluster";
        this.destClusterId = "destCluster";
    }

    public static final /* synthetic */ Object $anonfun$verifyLogLevel$1$adapted(AtomicReference currentMaxLevel$1, org.slf4j.event.Level x$1) {
        currentMaxLevel$1.set(x$1);
        return BoxedUnit.UNIT;
    }
}

