/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.LinkMode;
import kafka.server.link.MetadataListener;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.PartitionAndState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001B'O\u0001UCQ\u0001\u0018\u0001\u0005\u0002uCq\u0001\u0019\u0001C\u0002\u0013E\u0011\r\u0003\u0004i\u0001\u0001\u0006IA\u0019\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\u0019\b\u0001)A\u0005W\"9A\u000f\u0001b\u0001\n\u0013)\bB\u0002?\u0001A\u0003%a\u000fC\u0004~\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005U\u0001\u0001)A\u0005\u007f\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002(!I\u0011Q\u0007\u0001C\u0002\u0013%\u0011q\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002:!I\u00111\t\u0001C\u0002\u0013%\u0011Q\t\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002H!Y\u00111\u000b\u0001A\u0002\u0003\u0007I\u0011BA+\u0011-\ti\u0006\u0001a\u0001\u0002\u0004%I!a\u0018\t\u0017\u0005-\u0004\u00011A\u0001B\u0003&\u0011q\u000b\u0005\n\u0003[\u0002!\u0019!C\u0005\u0003_B\u0001\"a\u001e\u0001A\u0003%\u0011\u0011\u000f\u0005\n\u0003s\u0002!\u0019!C\u0005\u0003wB\u0001\"a!\u0001A\u0003%\u0011Q\u0010\u0005\f\u0003\u000b\u0003\u0001\u0019!a\u0001\n\u0013\t9\tC\u0006\u0002\u0010\u0002\u0001\r\u00111A\u0005\n\u0005E\u0005bCAK\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0013C1\"a&\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a\"Y\u00111\u0016\u0001A\u0002\u0003\u0007I\u0011BAW\u0011-\t\t\f\u0001a\u0001\u0002\u0003\u0006K!a'\t\u0013\u0005M\u0006\u00011A\u0005\n\u0005U\u0006\"CA_\u0001\u0001\u0007I\u0011BA`\u0011!\t\u0019\r\u0001Q!\n\u0005]\u0006bCAc\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fD1\"a4\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002R\"Y\u0011Q\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BAe\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!a<\u0001\t\u0003\tI\u000eC\u0004\u0002z\u0002!\t!!7\t\u000f\t\r\u0001\u0001\"\u0001\u0002Z\"9!q\u0001\u0001\u0005\u0002\u0005e\u0007b\u0002B\u0006\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005\u001f\u0001A\u0011AAm\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u00033DqAa\u0006\u0001\t\u0003\tI\u000eC\u0004\u0003\u001c\u0001!\t!!7\t\u000f\t}\u0001\u0001\"\u0001\u0002Z\"9!1\u0005\u0001\u0005\u0002\u0005e\u0007b\u0002B\u0014\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0005W\u0001A\u0011AAm\u0011\u001d\u0011y\u0003\u0001C\u0001\u00033DqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u0003j\u0001!\t!!7\t\u000f\t5\u0004\u0001\"\u0001\u0002Z\"9!\u0011\u000f\u0001\u0005\u0002\u0005e\u0007b\u0002B;\u0001\u0011%!q\u000f\u0005\b\u0005\u001b\u0003A\u0011AAm\u0011\u001d\u0011\t\n\u0001C\u0001\u00033DqA!&\u0001\t\u0003\tI\u000eC\u0004\u0003\u001a\u0002!\t!!7\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"9!1\u0015\u0001\u0005\n\t\u0015\u0006b\u0002BY\u0001\u0011%!1\u0017\u0005\n\u0005G\u0004\u0011\u0013!C\u0005\u0005KDqAa?\u0001\t\u0013\u0011i\u0010C\u0005\u0004(\u0001\t\n\u0011\"\u0003\u0004*!I1Q\u0006\u0001\u0012\u0002\u0013%1\u0011\u0006\u0005\n\u0007_\u0001\u0011\u0013!C\u0005\u0007cA\u0011b!\u000e\u0001#\u0003%Ia!\r\t\u000f\r]\u0002\u0001\"\u0003\u0004:!I1q\n\u0001\u0012\u0002\u0013%1\u0011\u000b\u0005\b\u0007+\u0002A\u0011BB,\u0011\u001d\u0019\u0019\u0007\u0001C\u0005\u0007KBqa!\u001c\u0001\t\u0013\u0019y\u0007C\u0004\u0004|\u0001!Ia! \t\u000f\r\u0015\u0005\u0001\"\u0003\u0002Z\ni2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002P!\u0006!A.\u001b8l\u0015\t\t&+\u0001\u0004tKJ4XM\u001d\u0006\u0002'\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001W!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0018\t\u0003?\u0002i\u0011AT\u0001\u0004S\n\u0004X#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\u0014\u0016aA1qS&\u0011q\r\u001a\u0002\u000b\u0003BLg+\u001a:tS>t\u0017\u0001B5ca\u0002\na\u0001\\5oW&#W#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001B;uS2T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n!Q+V%E\u0003\u001da\u0017N\\6JI\u0002\n\u0001\u0002\\5oW:\u000bW.Z\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u0011p\\\u0001\u0005Y\u0006tw-\u0003\u0002|q\n11\u000b\u001e:j]\u001e\f\u0011\u0002\\5oW:\u000bW.\u001a\u0011\u0002\u001bM|WO]2f)>\u0004\u0018nY%e+\u0005y\b\u0003BA\u0001\u0003#i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007G>lWn\u001c8\u000b\u0007M\u000bIA\u0003\u0003\u0002\f\u00055\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0010\u0005\u0019qN]4\n\t\u0005M\u00111\u0001\u0002\u0005+VLG-\u0001\bt_V\u00148-\u001a+pa&\u001c\u0017\n\u001a\u0011\u0002\u000f5,GO]5dgV\u0011\u00111\u0004\t\u0004?\u0006u\u0011bAA\u0010\u001d\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\"!a\n\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQA!!\f\u0002\u0004\u0005)Q\u000f^5mg&!\u0011\u0011GA\u0016\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003s\u0001B!a\u000f\u0002>5\t\u0001+C\u0002\u0002@A\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003\rawnZ\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002N5\u0011\u00111\n\u0006\u0004\u0003\u0007\u0012\u0016\u0002BA(\u0003\u0017\u00121\"\u00112tiJ\f7\r\u001e'pO\u0006!An\\4!\u00031\u0011'o\\6fe\u000e{gNZ5h+\t\t9\u0006\u0005\u0003\u0002<\u0005e\u0013bAA.!\nY1*\u00194lC\u000e{gNZ5h\u0003A\u0011'o\\6fe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002b\u0005\u001d\u0004cA,\u0002d%\u0019\u0011Q\r-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003S\u001a\u0012\u0011!a\u0001\u0003/\n1\u0001\u001f\u00132\u00035\u0011'o\\6fe\u000e{gNZ5hA\u0005YA.\u001b8l\u001b\u0006t\u0017mZ3s+\t\t\t\bE\u0002`\u0003gJ1!!\u001eO\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002\u00191Lgn['b]\u0006<WM\u001d\u0011\u0002\u0017\r|gN\\'b]\u0006<WM]\u000b\u0003\u0003{\u00022aXA@\u0013\r\t\tI\u0014\u0002!\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000e{gN\\3di&|g.T1oC\u001e,'/\u0001\u0007d_:tW*\u00198bO\u0016\u0014\b%\u0001\bgKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0016\u0005\u0005%\u0005cA0\u0002\f&\u0019\u0011Q\u0012(\u00033\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM]'b]\u0006<WM]\u0001\u0013M\u0016$8\r[3s\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002b\u0005M\u0005\"CA55\u0005\u0005\t\u0019AAE\u0003=1W\r^2iKJl\u0015M\\1hKJ\u0004\u0013a\u00043fgR\fE-\\5o\u00072LWM\u001c;\u0016\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003K\u000b9!A\u0004dY&,g\u000e^:\n\t\u0005%\u0016q\u0014\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0014I\u0016\u001cH/\u00113nS:\u001cE.[3oi~#S-\u001d\u000b\u0005\u0003C\ny\u000bC\u0005\u0002ju\t\t\u00111\u0001\u0002\u001c\u0006\u0001B-Z:u\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005]\u0006cA,\u0002:&\u0019\u00111\u0018-\u0003\u0007%sG/A\tok6\u0004\u0016M\u001d;ji&|gn]0%KF$B!!\u0019\u0002B\"I\u0011\u0011\u000e\u0011\u0002\u0002\u0003\u0007\u0011qW\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003E\u0019G.^:uKJd\u0015N\\6D_:4\u0017nZ\u000b\u0003\u0003\u0013\u00042aXAf\u0013\r\tiM\u0014\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017!F2mkN$XM\u001d'j].\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003C\n\u0019\u000eC\u0005\u0002j\r\n\t\u00111\u0001\u0002J\u0006\u00112\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4!\u0003\u0015\u0019X\r^+q)\t\t\t\u0007K\u0002&\u0003;\u0004B!a8\u0002l6\u0011\u0011\u0011\u001d\u0006\u0004K\u0006\r(\u0002BAs\u0003O\fqA[;qSR,'O\u0003\u0003\u0002j\u00065\u0011!\u00026v]&$\u0018\u0002BAw\u0003C\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0014\u0002tB!\u0011q\\A{\u0013\u0011\t90!9\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0005;fgRlU\r^1eCR\fGk\u001c9jGND3aJA\u007f!\u0011\ty.a@\n\t\t\u0005\u0011\u0011\u001d\u0002\u0005)\u0016\u001cH/\u0001\nuKN$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001c\bf\u0001\u0015\u0002~\u00069B/Z:u\u0003\u0012$7k\\;sG\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004S\u0005u\u0018a\u0004;fgR\u0014VmY8oM&<WO]3)\u0007)\ni0\u0001\ruKN$\b+Y;tK\u00124U\r^2iKJ\u001cF/\u0019:ukBD3aKA\u007f\u0003]!Xm\u001d;O_RLg-\u001f*fC\u0012Lhi\u001c:GKR\u001c\u0007\u000eK\u0002-\u0003{\fa\u0003^3tiN{WO]2f\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0004[\u0005u\u0018\u0001\n;fgR\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cv.\u001e:dK:{G/\u0011<bS2\f'\r\\3)\u00079\ni0\u0001\u001euKN$\b+\u0019:uSRLwN\\*uCR,7k\\;sG\u0016tu\u000e^!wC&d\u0017M\u00197f)>\u0004\u0018n\u0019(pi&sW*\u001a;bI\u0006$\u0018m\u00148dK\"\u001aq&!@\u0002\u0001R,7\u000f\u001e)beRLG/[8o'R\fG/Z*pkJ\u001cWMT8u\u0003Z\f\u0017\u000e\\1cY\u0016$v\u000e]5d\u001d>$\u0018J\\'fi\u0006$\u0017\r^1G_J$\u0016.\\3pkRD3\u0001MA\u007f\u0003\u0011\"Xm\u001d;QCJ$\u0018\u000e^5p]N#\u0018\r^3U_BL7MT8u\u0013:lU\r^1eCR\f\u0007fA\u0019\u0002~\u0006!C/Z:u!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f'>,(oY3U_BL7\rR3mKR,G\rK\u00023\u0003{\fa\u0007^3tiB\u000b'\u000f^5uS>t7\u000b^1uKN{WO]2f\u001d>$\u0018I^1jY\u0006\u0014G.Z*pkJ\u001cW\rV8qS\u000e$U\r\\3uK\u0012D3aMA\u007f\u0003m1XM]5gsB\u000b'\u000f^5uS>tg)Y5mkJ,7\u000b^1uKR1!q\u0007B\u001f\u0005?\u00022a\u0018B\u001d\u0013\r\u0011YD\u0014\u0002\u0012!\u0006\u0014H/\u001b;j_:\fe\u000eZ*uCR,\u0007b\u0002B i\u0001\u0007!\u0011I\u0001\tM\u0006LG.\u001e:fgB1!1\tB*\u00053rAA!\u0012\u0003P9!!q\tB'\u001b\t\u0011IEC\u0002\u0003LQ\u000ba\u0001\u0010:p_Rt\u0014\"A-\n\u0007\tE\u0003,A\u0004qC\u000e\\\u0017mZ3\n\t\tU#q\u000b\u0002\u0005\u0019&\u001cHOC\u0002\u0003Ra\u00032a\u0018B.\u0013\r\u0011iF\u0014\u0002\u0012\u001b&\u0014(o\u001c:GC&dWO]3UsB,\u0007b\u0002B1i\u0001\u0007!1M\u0001\u0018Kb\u0004Xm\u0019;QKJ\u001c\u0018n\u001d;f]R4\u0015-\u001b7ve\u0016\u00042a\u0016B3\u0013\r\u00119\u0007\u0017\u0002\b\u0005>|G.Z1o\u0003\u0015\"Xm\u001d;Tk\u000e\u001cWm]:gk2d\u0015N\\6fI2+\u0017\rZ3s\u000bB|7\r[+qI\u0006$X\rK\u00026\u0003{\f\u0011\u0005^3ti\u001a\u000b\u0017\u000e\\3e\u0019&t7.\u001a3MK\u0006$WM]#q_\u000eDW\u000b\u001d3bi\u0016D3ANA\u007f\u00031\"Xm\u001d;V]\u0016D\b/Z2uK\u0012,%O]8s\u0013:d\u0015N\\6fI2+\u0017\rZ3s\u000bB|7\r[+qI\u0006$X\rK\u00028\u0003{\fQD^3sS\u001aLH*\u001b8lK\u0012dU-\u00193fe\u0016\u0003xn\u00195Va\u0012\fG/\u001a\u000b\u0007\u0003C\u0012IH!#\t\u000f\tm\u0004\b1\u0001\u0003~\u0005YQ\u000f\u001d3bi\u0016,%O]8s!\u0011\u0011yH!\"\u000e\u0005\t\u0005%\u0002\u0002BB\u0003\u0007\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005\u000f\u0013\tI\u0001\u0004FeJ|'o\u001d\u0005\b\u0005\u0017C\u0004\u0019\u0001B2\u0003E)\u0007\u0010]3di2Kgn\u001b$bS2,(/Z\u0001 i\u0016\u001cHoU;dG\u0016\u001c8OZ;m\u0019&t7NR1jYV\u0014X-\u00169eCR,\u0007fA\u001d\u0002~\u0006YB/Z:u\r\u0006LG.\u001a3MS:\\g)Y5mkJ,W\u000b\u001d3bi\u0016D3AOA\u007f\u0003]!Xm\u001d;U_>l\u0015M\\=Fa>\u001c\u0007.\u00169eCR,7\u000fK\u0002<\u0003{\fa\u0005^3ti:{W*\u001a;bI\u0006$\u0018-\u00169eCR,gi\u001c:GC&dW\r\u001a)beRLG/[8oQ\ra\u0014Q`\u0001\u0018m\u0016\u0014\u0018NZ=MS:\\g)Y5mkJ,W\u000b\u001d3bi\u0016$B!!\u0019\u0003\"\"9!1P\u001fA\u0002\tu\u0014\u0001G2sK\u0006$X\rT5oW\u001a+Go\u00195fe6\u000bg.Y4feR!\u0011\u0011\u0012BT\u0011\u001d\u0011IK\u0010a\u0001\u0005W\u000bQ\u0001\u001d:paN\u00042\u0001\u001cBW\u0013\r\u0011y+\u001c\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018AD;qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\t\u0003C\u0012)L!7\u0003^\"9!qW A\u0002\te\u0016A\u0002;pa&\u001c7\u000f\u0005\u0005\u0003<\n\u0005'Q\u0019Bj\u001b\t\u0011iLC\u0002\u0003@b\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019M!0\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003H\n=g\u0002\u0002Be\u0005\u0017\u00042Aa\u0012Y\u0013\r\u0011i\rW\u0001\u0007!J,G-\u001a4\n\u0007m\u0014\tNC\u0002\u0003Nb\u00032a\u001eBk\u0013\r\u00119\u000e\u001f\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011Yn\u0010a\u0001\u0003o\u000b\u0011\u0003\\5oW\u0016$G*Z1eKJ,\u0005o\\2i\u0011%\u0011yn\u0010I\u0001\u0002\u0004\u0011\t/\u0001\u0004feJ|'o\u001d\t\t\u0005w\u0013\tM!2\u0003~\u0005AR\u000f\u001d3bi\u0016lU\r^1eCR\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u001d(\u0006\u0002Bq\u0005S\\#Aa;\u0011\t\t5(q_\u0007\u0003\u0005_TAA!=\u0003t\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005kD\u0016AC1o]>$\u0018\r^5p]&!!\u0011 Bx\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\ng\u0016$X\u000f]'pG.$b\"!\u0019\u0003\u0000\u000e=1\u0011DB\u000e\u0007?\u0019\u0019\u0003C\u0004\u0004\u0002\u0005\u0003\raa\u0001\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BB\u0003\u0007\u0017i!aa\u0002\u000b\u0007\r%!+A\u0004dYV\u001cH/\u001a:\n\t\r51q\u0001\u0002\n!\u0006\u0014H/\u001b;j_:Dqa!\u0005B\u0001\u0004\u0019\u0019\"\u0001\u0002uaB!\u0011\u0011AB\u000b\u0013\u0011\u00199\"a\u0001\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"I!1\\!\u0011\u0002\u0003\u0007\u0011q\u0017\u0005\n\u0007;\t\u0005\u0013!a\u0001\u0003o\u000bqB\\;n\u000bB|7\r[+qI\u0006$Xm\u001d\u0005\n\u0007C\t\u0005\u0013!a\u0001\u0005G\n1c\u00197fCJ|eMZ:fiN\u0004VM\u001c3j]\u001eD\u0011b!\nB!\u0003\u0005\rAa\u0019\u0002\u0015I,\u0007\u000f\\1z\u001b>\u001c7.A\ntKR,\b/T8dW\u0012\"WMZ1vYR$3'\u0006\u0002\u0004,)\"\u0011q\u0017Bu\u0003M\u0019X\r^;q\u001b>\u001c7\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003M\u0019X\r^;q\u001b>\u001c7\u000e\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019\u0019D\u000b\u0003\u0003d\t%\u0018aE:fiV\u0004Xj\\2lI\u0011,g-Y;mi\u00122\u0014AF:fiV\u0004h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012lunY6\u0015\r\u0005\u000541HB#\u0011\u001d\u0019iD\u0012a\u0001\u0007\u007f\tQBZ3uG\",'\u000f\u00165sK\u0006$\u0007cA0\u0004B%\u001911\t(\u00031\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM\u001d+ie\u0016\fG\rC\u0005\u0004H\u0019\u0003\n\u00111\u0001\u0004J\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\r\t\u001d71JB\n\u0013\u0011\u0019iE!5\u0003\u0007M+G/\u0001\u0011tKR,\bOR3uG\",'\u000f\u00165sK\u0006$Wj\\2lI\u0011,g-Y;mi\u0012\u0012TCAB*U\u0011\u0019IE!;\u0002\u001d5,G/\u00193bi\u0006$v\u000e]5dgV\u00111\u0011\f\t\u0006\u00077\u001a\tG^\u0007\u0003\u0007;RAaa\u0018\u0003>\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0007\u001b\u001ai&A\u000bnKR\fG-\u0019;b%\u00164'/Z:i)\"\u0014X-\u00193\u0016\u0005\r\u001d\u0004cA0\u0004j%\u001911\u000e(\u00033\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1UQJ,\u0017\rZ\u0001\"gR\f'\u000f^'fi\u0006$\u0017\r^1UQJ,\u0017\rZ!oI\u0006#G\rT5ti\u0016tWM\u001d\u000b\u0005\u0003C\u001a\t\bC\u0004\u0004t)\u0003\ra!\u001e\u0002\u00111L7\u000f^3oKJ\u00042aXB<\u0013\r\u0019IH\u0014\u0002\u0011\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ\fq\"\\3uC\u0012\fG/Y\"mkN$XM]\u000b\u0003\u0007\u007f\u0002B!!\u0001\u0004\u0002&!11QA\u0002\u0005\u001d\u0019E.^:uKJ\f\u0001D^3sS\u001aLh)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014Hj\\2l\u0001")
public class ClusterLinkFetcherManagerTest {
    private final ApiVersion ibp = ApiVersion$.MODULE$.latestVersion();
    private final UUID kafka$server$link$ClusterLinkFetcherManagerTest$$linkId = UUID.randomUUID();
    private final String kafka$server$link$ClusterLinkFetcherManagerTest$$linkName;
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkMetrics kafka$server$link$ClusterLinkFetcherManagerTest$$metrics = new ClusterLinkMetrics(this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName(), this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkId(), (LinkMode)LinkMode.Destination$.MODULE$, null, (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final MockTime kafka$server$link$ClusterLinkFetcherManagerTest$$time = new MockTime();
    private final ReplicaManager kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
    private final AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
    private KafkaConfig kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig;
    private final ClusterLinkManager kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager = (ClusterLinkManager)EasyMock.createNiceMock(ClusterLinkManager.class);
    private final ClusterLinkDestConnectionManager kafka$server$link$ClusterLinkFetcherManagerTest$$connManager = (ClusterLinkDestConnectionManager)EasyMock.createNiceMock(ClusterLinkDestConnectionManager.class);
    private ClusterLinkFetcherManager kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager;
    private Admin kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient;
    private int kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions = 2;
    private ClusterLinkConfig kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig;

    public ApiVersion ibp() {
        return this.ibp;
    }

    public UUID kafka$server$link$ClusterLinkFetcherManagerTest$$linkId() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkId;
    }

    public String kafka$server$link$ClusterLinkFetcherManagerTest$$linkName() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    public ClusterLinkMetrics kafka$server$link$ClusterLinkFetcherManagerTest$$metrics() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics;
    }

    public MockTime kafka$server$link$ClusterLinkFetcherManagerTest$$time() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$time;
    }

    public ReplicaManager kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager;
    }

    private AbstractLog log() {
        return this.log;
    }

    public KafkaConfig kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig;
    }

    private void brokerConfig_$eq(KafkaConfig x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig = x$1;
    }

    public ClusterLinkManager kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager;
    }

    public ClusterLinkDestConnectionManager kafka$server$link$ClusterLinkFetcherManagerTest$$connManager() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$connManager;
    }

    public ClusterLinkFetcherManager kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager;
    }

    private void fetcherManager_$eq(ClusterLinkFetcherManager x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager = x$1;
    }

    public Admin kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient;
    }

    private void destAdminClient_$eq(Admin x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient = x$1;
    }

    public int kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions;
    }

    private void numPartitions_$eq(int x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions = x$1;
    }

    public ClusterLinkConfig kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig() {
        return this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        brokerProps.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), this.ibp().shortVersion());
        this.brokerConfig_$eq(KafkaConfig$.MODULE$.fromProps(brokerProps));
        Properties linkProps = new Properties();
        linkProps.put("bootstrap.servers", "localhost:1234");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics().startup();
        this.destAdminClient_$eq((Admin)EasyMock.createNiceMock(Admin.class));
        this.fetcherManager_$eq(this.createLinkFetcherManager(linkProps));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().initializeMetadata();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.log().localLogEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.log().logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager().fetchResponseSize((ClusterLinkConfig)EasyMock.anyObject())).andReturn((Object)new FetchResponseSize(10, 10)).anyTimes();
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager().updateDynamicFetchSize();
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            this.verifyFetcherManagerLock();
            return BoxedUnit.UNIT;
        }).anyTimes();
        EasyMock.expect((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$connManager().reverseConnectionProvider((NetworkClient)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (String)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.log(), this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager(), this.kafka$server$link$ClusterLinkFetcherManagerTest$$connManager()});
    }

    @AfterEach
    public void tearDown() {
        if (this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager() != null) {
            this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().shutdown();
        }
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics().shutdown();
    }

    @Test
    public void testMetadataTopics() {
        String topic1 = "testTopic1";
        TopicPartition tp1_0 = new TopicPartition(topic1, 0);
        Partition partition1_0 = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition1_0, tp1_0, 1, 0, false, true);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1_0})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1})), this.metadataTopics());
        Assertions.assertEquals((long)0L, (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds()));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0})), true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1})), this.metadataTopics());
        String topic2 = "testTopic2";
        TopicPartition tp2_4 = new TopicPartition(topic2, 4);
        Partition partition2_4 = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition2_4, tp2_4, 1, 0, false, true);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition2_4})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.metadataTopics());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0})), false);
        Assertions.assertEquals(Collections.singletonList(topic2), (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().newMetadataRequestBuilder().topics());
        TopicPartition tp1_1 = new TopicPartition(topic1, 1);
        Partition partition1_1 = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition1_1, tp1_1, 1, 0, false, true);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1_1})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.metadataTopics());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1_0})));
        Assertions.assertEquals((int)2, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().newMetadataRequestBuilder().topics().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.metadataTopics());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0})), false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), this.metadataTopics());
    }

    @Test
    public void testFetcherThreads() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition, tp, 1, 0, false, true);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        Map topics = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.setupMock(partition, tp, 1, 1, false, true);
        this.updateMetadata((Map<String, Integer>)topics, 5, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        EasyMock.verify((Object[])new Object[]{partition});
        this.setupMock(partition, tp, 5, 0, false, true);
        this.updateMetadata((Map<String, Integer>)topics, 5, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        EasyMock.verify((Object[])new Object[]{partition});
        this.setupMock(partition, tp, 5, 1, false, true);
        this.updateMetadata((Map<String, Integer>)topics, 6, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        EasyMock.verify((Object[])new Object[]{partition});
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})), true);
        Assertions.assertEquals(Collections.singletonList(topic), (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().newMetadataRequestBuilder().topics());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().shutdownIdleFetcherThreads();
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        EasyMock.verify((Object[])new Object[]{partition});
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.setupMock(partition, tp, 6, 0, false, true);
        this.updateMetadata((Map<String, Integer>)topics, 6, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp).nonEmpty());
        EasyMock.verify((Object[])new Object[]{partition});
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().shutdown();
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.fetcherManager_$eq(null);
    }

    @Test
    public void testAddSourcePartitions() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition, tp, 1, 0, false, true);
        CreatePartitionsResult createPartitionsResult = (CreatePartitionsResult)EasyMock.createNiceMock(CreatePartitionsResult.class);
        EasyMock.expect((Object)createPartitionsResult.values()).andReturn(Collections.singletonMap(topic, KafkaFuture.completedFuture(null))).anyTimes();
        Capture capturedRequests = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient().createPartitions((java.util.Map)EasyMock.capture((Capture)capturedRequests))).andReturn((Object)createPartitionsResult).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager(), this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient(), createPartitionsResult});
        this.numPartitions_$eq(1);
        Integer numSourcePartitions = Predef$.MODULE$.int2Integer(1);
        int sourceEpoch = 1;
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)numSourcePartitions)}))), sourceEpoch, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp).isDefined());
        Assertions.assertTrue((boolean)((AbstractFetcherThread)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp).get()).fetchState(tp).isDefined());
        Assertions.assertEquals((Object)new Some((Object)this.sourceTopicId()), (Object)((PartitionFetchState)((AbstractFetcherThread)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp).get()).fetchState(tp).get()).topicId());
        numSourcePartitions = Predef$.MODULE$.int2Integer(4);
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)numSourcePartitions)}))), sourceEpoch, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)capturedRequests.getValues().size());
        java.util.Map captured1 = (java.util.Map)capturedRequests.getValues().get(0);
        Assertions.assertEquals((int)1, (int)captured1.size());
        Assertions.assertEquals((int)4, (int)((NewPartitions)captured1.get(topic)).totalCount());
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)numSourcePartitions)}))), sourceEpoch, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)2, (int)capturedRequests.getValues().size());
        java.util.Map captured2 = (java.util.Map)capturedRequests.getValues().get(1);
        Assertions.assertEquals((int)1, (int)captured2.size());
        Assertions.assertEquals((int)4, (int)((NewPartitions)captured2.get(topic)).totalCount());
        this.numPartitions_$eq(4);
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)numSourcePartitions)}))), sourceEpoch, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)2, (int)capturedRequests.getValues().size());
    }

    @Test
    public void testReconfigure() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition, tp, 1, 0, false, true);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().startMetadataThread();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFetcherManagerTest.$anonfun$testReconfigure$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Metadata not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        Map topics = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.setupMock(partition, tp, 2, 1, false, true);
        this.updateMetadata((Map<String, Integer>)topics, 2, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        ClusterLinkFetcherThread fetcherThread1 = (ClusterLinkFetcherThread)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head();
        ClusterLinkMetadata metadata1 = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata();
        ClusterLinkMetadataThread metadataThread1 = this.metadataRefreshThread();
        ClusterLinkNetworkClient metadataClient1 = metadataThread1.clusterLinkClient();
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock(fetcherThread1, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, 0)}))));
        ClusterLinkNetworkClient fetcherClient1 = fetcherThread1.clusterLinkClient();
        fetcherClient1.reconfigure((java.util.Map)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{fetcherClient1});
        HashMap<String, String> newDynamicProps = new HashMap<String, String>();
        newDynamicProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        newDynamicProps.put("ssl.truststore.location", "truststore.jks");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(newDynamicProps, true), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.truststore.location"})));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertSame((Object)fetcherThread1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head());
        Assertions.assertSame((Object)metadata1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata());
        EasyMock.verify((Object[])new Object[]{fetcherClient1});
        HashMap newPeriodicMigrationProps = new HashMap();
        newDynamicProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        newDynamicProps.put(ClusterLinkConfig$.MODULE$.AclSyncMsProp(), "120000");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(newPeriodicMigrationProps, true), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.AclSyncMsProp()})));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertSame((Object)fetcherThread1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head());
        Assertions.assertSame((Object)metadata1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata());
        EasyMock.verify((Object[])new Object[]{fetcherClient1});
        HashMap<String, String> newNonDynamicProps = new HashMap<String, String>();
        newNonDynamicProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        newNonDynamicProps.put("bootstrap.servers", "localhost:5678");
        EasyMock.reset((Object[])new Object[]{fetcherThread1.clusterLinkClient()});
        fetcherClient1.close();
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{fetcherClient1});
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(newNonDynamicProps, true), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertNotSame((Object)metadata1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        this.updateMetadata((Map<String, Integer>)topics, 2, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertNotSame((Object)fetcherThread1, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head());
        Assertions.assertFalse((boolean)metadataClient1.networkClient().active(), (String)"Metadata client not closed");
        ClusterLinkMetadataThread metadataThread2 = this.metadataRefreshThread();
        Assertions.assertNotSame((Object)metadataThread1, (Object)metadataThread2);
        Assertions.assertNotSame((Object)metadataClient1, (Object)metadataThread2.clusterLinkClient());
        Assertions.assertTrue((boolean)metadataThread2.clusterLinkClient().networkClient().active(), (String)"Metadata client not active");
        EasyMock.verify((Object[])new Object[]{fetcherClient1});
        ClusterLinkFetcherThread fetcherThread2 = (ClusterLinkFetcherThread)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().values().head();
        ClusterLinkNetworkClient metadataClient2 = metadataThread2.clusterLinkClient();
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock(fetcherThread2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, 0)}))));
        ClusterLinkNetworkClient fetcherClient2 = fetcherThread2.clusterLinkClient();
        fetcherClient2.reconfigure((java.util.Map)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{fetcherClient2});
        HashMap<String, String> pausedProps = new HashMap<String, String>();
        pausedProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        pausedProps.put(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "true");
        EasyMock.reset((Object[])new Object[]{fetcherThread2.clusterLinkClient()});
        fetcherClient2.close();
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{fetcherClient2});
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(pausedProps, true), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertFalse((boolean)metadataClient2.networkClient().active(), (String)"Metadata client not closed");
        EasyMock.verify((Object[])new Object[]{fetcherClient2});
        HashMap<String, String> newNonDynamicButPausedProps = new HashMap<String, String>();
        newNonDynamicButPausedProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        newNonDynamicButPausedProps.put("bootstrap.servers", "localhost:6789");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(newNonDynamicButPausedProps, ClusterLinkConfig$.MODULE$.create$default$2()), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        EasyMock.verify((Object[])new Object[]{fetcherClient2});
        HashMap<String, String> unpausedProps = new HashMap<String, String>();
        unpausedProps.putAll(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentConfig().originalsStrings());
        unpausedProps.put(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "false");
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().reconfigure(ClusterLinkConfig$.MODULE$.create(unpausedProps, ClusterLinkConfig$.MODULE$.create$default$2()), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        ClusterLinkMetadataThread metadataThread3 = this.metadataRefreshThread();
        Assertions.assertNotSame((Object)metadataThread2, (Object)metadataThread3);
        Assertions.assertTrue((boolean)metadataThread3.clusterLinkClient().networkClient().active(), (String)"Metadata client not active");
        EasyMock.verify((Object[])new Object[]{fetcherClient2});
    }

    @Test
    public void testPausedFetcherStartup() {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().shutdown();
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        props.put(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "true");
        this.fetcherManager_$eq(this.createLinkFetcherManager(props));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().startup();
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        int n = 1;
        int n2 = 0;
        boolean bl = true;
        this.setupMock(partition, tp, n, n2, true, bl);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().removeLinkedFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})), false);
        CreatePartitionsResult createPartitionsResult = (CreatePartitionsResult)EasyMock.createNiceMock(CreatePartitionsResult.class);
        EasyMock.expect((Object)createPartitionsResult.values()).andReturn(Collections.singletonMap(topic, KafkaFuture.completedFuture(null))).anyTimes();
        Capture capturedRequests = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        EasyMock.expect((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient().createPartitions((java.util.Map)EasyMock.capture((Capture)capturedRequests))).andReturn((Object)createPartitionsResult).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager(), this.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient(), createPartitionsResult});
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
    }

    @Test
    public void testNotifyReadyForFetch() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition, tp, 1, 0, false, true);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().maybeNotifyReadyForFetch(partition);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().maybeNotifyReadyForFetch(partition);
        IntRef notificationCount = IntRef.create((int)0);
        ClusterLinkFetcherThread fetcherThread = new ClusterLinkFetcherThread(this, tp, notificationCount){
            private final TopicPartition tp$1;
            private final IntRef notificationCount$1;

            public Set<TopicPartition> partitions() {
                return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1}));
            }

            public void notifyReadyForFetch() {
                super.notifyReadyForFetch();
                ++this.notificationCount$1.elem;
            }
            {
                this.tp$1 = tp$1;
                this.notificationCount$1 = notificationCount$1;
                super("thread-0", 0, $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig(), new ClusterLinkMetadata($outer.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkId(), (LinkMode)LinkMode.Destination$.MODULE$, 100L, 60000L), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), new BrokerEndPoint(0, "localhost", 1000), new FailedPartitions(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager(), null, $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics(), (Time)new MockTime(), (Function0)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final FetchResponseSize apply() {
                        return new FetchResponseSize(100, 1000);
                    }
                }, (ClusterLinkNetworkClient)EasyMock.mock(ClusterLinkNetworkClient.class), (BlockingSend)EasyMock.mock(BlockingSend.class), (Option)None$.MODULE$, (Option)None$.MODULE$);
            }
        };
        Map topics = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.setupMock(partition, tp, 1, 0, false, true);
        this.updateMetadata((Map<String, Integer>)topics, 1, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().put(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().keySet().head(), (Object)fetcherThread);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().updateFetcherThread(tp, (Option)new Some((Object)fetcherThread));
        this.setupLog$1(10L, 5L);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().maybeNotifyReadyForFetch(partition);
        Assertions.assertEquals((int)0, (int)notificationCount.elem);
        this.setupLog$1(10L, 10L);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().maybeNotifyReadyForFetch(partition);
        Assertions.assertEquals((int)1, (int)notificationCount.elem);
    }

    @Test
    public void testSourceNotAvailable() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition, tp, 1, 0, false, true);
        AtomicReference currentCluster = new AtomicReference();
        this.startMetadataThreadAndAddListener(new MetadataListener(this, currentCluster){
            private final /* synthetic */ ClusterLinkFetcherManagerTest $outer;
            private final AtomicReference currentCluster$1;

            public void onMetadataFailure(Exception e) {
                MetadataListener.onMetadataFailure$((MetadataListener)this, (Exception)e);
            }

            public final void onNewMetadata(Cluster newCluster) {
                this.currentCluster$1.set(newCluster);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentCluster$1 = currentCluster$1;
            }
        });
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().getFetcher(tp));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        Assertions.assertNull(currentCluster.get(), (String)"Unexpected metadata update");
        Map topics = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.setupMock(partition, tp, 2, 1, false, true);
        this.updateMetadata((Map<String, Integer>)topics, 2, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFetcherManagerTest.$anonfun$testSourceNotAvailable$3(currentCluster)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Metadata not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().onAvailabilityChange(false);
        Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.updateMetadata((Map<String, Integer>)topics, 2, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().onAvailabilityChange(true);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkFetcherManagerTest.$anonfun$testSourceNotAvailable$5(currentCluster)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"Metadata not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @Test
    public void testPartitionStateSourceNotAvailable() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MirrorFailureType.LinkNotAvailable$[]{MirrorFailureType.LinkNotAvailable$.MODULE$, MirrorFailureType.LinkNotAvailable$.MODULE$}))), false);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.LinkNotAvailable$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure >= (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateSourceNotAvailableTopicNotInMetadataOnce() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{MirrorFailureType.LinkNotAvailable$.MODULE$, MirrorFailureType.SourceTopicUnavailable$.MODULE$}))), false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure < (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateSourceNotAvailableTopicNotInMetadataForTimeout() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{MirrorFailureType.LinkNotAvailable$.MODULE$, MirrorFailureType.SourceTopicUnavailable$.MODULE$, MirrorFailureType.SourceTopicUnavailable$.MODULE$}))), true);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure >= (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateTopicNotInMetadata() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MirrorFailureType.SourceTopicUnavailable$[]{MirrorFailureType.SourceTopicUnavailable$.MODULE$, MirrorFailureType.SourceTopicUnavailable$.MODULE$}))), true);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.SourceTopicUnavailable$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure >= (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateSourceTopicDeleted() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MirrorFailureType.SourceTopicDeleted$[]{MirrorFailureType.SourceTopicDeleted$.MODULE$}))), true);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.SourceTopicDeleted$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure < (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    @Test
    public void testPartitionStateSourceNotAvailableSourceTopicDeleted() {
        PartitionAndState state = this.verifyPartitionFailureState((List<MirrorFailureType>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{MirrorFailureType.SourceTopicUnavailable$.MODULE$, MirrorFailureType.SourceTopicDeleted$.MODULE$}))), true);
        Assertions.assertEquals((Object)new Some((Object)MirrorFailureType.SourceTopicDeleted$.MODULE$), (Object)state.apiFailureType());
        Assertions.assertNotEquals((long)0L, (long)state.failureStartMs().get());
        long timeSinceFirstFailure = this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - state.failureStartMs().get();
        Assertions.assertTrue((timeSinceFirstFailure >= (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() ? 1 : 0) != 0, (String)new StringBuilder(34).append("Incorrect timeSinceFirstFailure:  ").append(timeSinceFirstFailure).toString());
    }

    private PartitionAndState verifyPartitionFailureState(List<MirrorFailureType> failures, boolean expectPersistentFailure) {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        int n = 1;
        int n2 = 0;
        boolean bl = false;
        this.setupMock(partition, tp, n, n2, bl, false);
        if (expectPersistentFailure) {
            partition.failClusterLink((Function1)EasyMock.anyObject());
            EasyMock.expect((Object)BoxedUnit.UNIT).once();
        }
        EasyMock.replay((Object[])new Object[]{partition});
        ConcurrentHashMap linkedPartitions = (ConcurrentHashMap)TestUtils.fieldValue((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), ClusterLinkFetcherManager.class, (String)"linkedPartitions");
        AtomicReference currentCluster = new AtomicReference();
        this.startMetadataThreadAndAddListener(new MetadataListener(this, currentCluster){
            private final /* synthetic */ ClusterLinkFetcherManagerTest $outer;
            private final AtomicReference currentCluster$2;

            public void onMetadataFailure(Exception e) {
                MetadataListener.onMetadataFailure$((MetadataListener)this, (Exception)e);
            }

            public final void onNewMetadata(Cluster newCluster) {
                this.currentCluster$2.set(newCluster);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentCluster$2 = currentCluster$2;
            }
        });
        Assertions.assertEquals(Collections.emptyMap(), (Object)linkedPartitions);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        Assertions.assertEquals(Collections.singleton(tp), (Object)linkedPartitions.keySet());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((PartitionAndState)linkedPartitions.get(tp)).apiFailureType());
        Assertions.assertEquals((long)0L, (long)((PartitionAndState)linkedPartitions.get(tp)).failureStartMs().get());
        Assertions.assertNull(currentCluster.get(), (String)"Unexpected metadata update");
        failures.foreach((Function1 & Serializable)failureType -> {
            ClusterLinkFetcherManagerTest.$anonfun$verifyPartitionFailureState$3(this, tp, linkedPartitions, failureType);
            return BoxedUnit.UNIT;
        });
        return (PartitionAndState)linkedPartitions.get(tp);
    }

    @Test
    public void testSuccessfulLinkedLeaderEpochUpdate() {
        this.verifyLinkedLeaderEpochUpdate(Errors.NONE, false);
    }

    @Test
    public void testFailedLinkedLeaderEpochUpdate() {
        this.verifyLinkedLeaderEpochUpdate(Errors.OPERATION_NOT_ATTEMPTED, false);
    }

    @Test
    public void testUnexpectedErrorInLinkedLeaderEpochUpdate() {
        this.verifyLinkedLeaderEpochUpdate(Errors.UNKNOWN_SERVER_ERROR, true);
    }

    private void verifyLinkedLeaderEpochUpdate(Errors updateError, boolean expectLinkFailure) {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        Capture capturedRequests = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        int n = 1;
        int n2 = 0;
        boolean bl = false;
        this.setupMock(partition, tp, n, n2, bl, false);
        partition.updateLinkedLeaderEpoch(EasyMock.anyInt(), (Function1)EasyMock.capture((Capture)capturedRequests));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        partition.linkedLeaderOffsetsPending(true);
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        partition.linkedLeaderOffsetsPending(true);
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        if (expectLinkFailure) {
            partition.failClusterLink((Function1)EasyMock.anyObject());
            EasyMock.expect((Object)BoxedUnit.UNIT).once();
        }
        EasyMock.replay((Object[])new Object[]{partition});
        this.numPartitions_$eq(1);
        int sourceEpoch = 1;
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions()))}))), sourceEpoch, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        sourceEpoch = 5;
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions()))}))), sourceEpoch, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        long nextMetadataUpdate = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        Assertions.assertTrue((nextMetadataUpdate > 1000L ? 1 : 0) != 0, (String)new StringBuilder(34).append("Unnecessary metadata update after ").append(nextMetadataUpdate).toString());
        ((Function1)capturedRequests.getValue()).apply((Object)updateError);
        nextMetadataUpdate = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        Errors errors = updateError;
        Errors errors2 = Errors.NONE;
        if (!(errors == null ? errors2 != null : !errors.equals(errors2)) || expectLinkFailure) {
            Assertions.assertTrue((nextMetadataUpdate > 1000L ? 1 : 0) != 0, (String)new StringBuilder(34).append("Unnecessary metadata update after ").append(nextMetadataUpdate).toString());
            return;
        }
        Assertions.assertEquals((Long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().metadataRefreshBackoffMs(), (long)nextMetadataUpdate);
    }

    @Test
    public void testSuccessfulLinkFailureUpdate() {
        this.verifyLinkFailureUpdate(Errors.NONE);
    }

    @Test
    public void testFailedLinkFailureUpdate() {
        this.verifyLinkFailureUpdate(Errors.OPERATION_NOT_ATTEMPTED);
    }

    @Test
    public void testTooManyEpochUpdates() {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition, tp, 1, 0, false, true);
        EasyMock.expect((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager().onlinePartition(tp)).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager()});
        Map topics = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(2))}));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.setupMock(partition, tp, 1, 1, false, true);
        this.updateMetadata((Map<String, Integer>)topics, 1, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock((ClusterLinkFetcherThread)((Tuple2)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().head())._2(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 22).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)epoch -> {
            this.setupMock(partition, tp, epoch, 1, false, true);
            this.updateMetadata((Map<String, Integer>)topics, epoch + 1, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        });
        Assertions.assertEquals(Collections.singletonMap(tp, BoxesRunTime.boxToLong((long)0L)), (Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().waitingPartitions());
    }

    @Test
    public void testNoMetadataUpdateForFailedPartition() {
        this.numPartitions_$eq(1);
        String topic = "testTopic1";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        this.setupMock(partition, tp, 1, 0, false, true);
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), this.metadataTopics());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().updateRequested()));
        ConcurrentHashMap linkedPartitions = (ConcurrentHashMap)TestUtils.fieldValue((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), ClusterLinkFetcherManager.class, (String)"linkedPartitions");
        ((PartitionAndState)linkedPartitions.get(tp)).apiFailureType_$eq((Option)new Some((Object)MirrorFailureType.TopicAuthorizationFailed$.MODULE$));
        ((PartitionAndState)linkedPartitions.get(tp)).failureStartMs().set(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds() - (long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs() - 1L);
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions()))}))), 1, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Errors.TOPIC_AUTHORIZATION_FAILED)}))));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().updateRequested()));
    }

    private void verifyLinkFailureUpdate(Errors updateError) {
        String topic = "testTopic";
        TopicPartition tp = new TopicPartition(topic, 0);
        Partition partition = (Partition)EasyMock.mock(Partition.class);
        Capture capturedRequests = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        int n = 1;
        int n2 = 0;
        boolean bl = false;
        this.setupMock(partition, tp, n, n2, bl, false);
        partition.failClusterLink((Function1)EasyMock.capture((Capture)capturedRequests));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{partition});
        this.numPartitions_$eq(1);
        int sourceEpoch = 1;
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition})));
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)Predef$.MODULE$.int2Integer(this.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions()))}))), sourceEpoch, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().fetcherThreadMap().size());
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.empty()), -1, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        long nextMetadataUpdate = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        Assertions.assertEquals((Long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().metadataRefreshBackoffMs(), (long)nextMetadataUpdate);
        Assertions.assertEquals(Collections.emptyList(), (Object)capturedRequests.getValues());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().sleep((long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs());
        this.updateMetadata((Map<String, Integer>)((Map)Map$.MODULE$.empty()), -1, (Map<String, Errors>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Assertions.assertEquals((int)1, (int)capturedRequests.getValues().size());
        ((Function1)capturedRequests.getValue()).apply((Object)updateError);
        nextMetadataUpdate = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().timeToNextUpdate(this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        Assertions.assertEquals((Long)this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().metadataRefreshBackoffMs(), (long)nextMetadataUpdate);
    }

    private ClusterLinkFetcherManager createLinkFetcherManager(Properties props) {
        this.clusterLinkConfig_$eq(ClusterLinkConfig$.MODULE$.create((java.util.Map)props, true));
        return new ClusterLinkFetcherManager(this){
            private final /* synthetic */ ClusterLinkFetcherManagerTest $outer;

            public ClusterLinkFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                ClusterLinkFetcherThread thread = (ClusterLinkFetcherThread)EasyMock.createNiceMock(ClusterLinkFetcherThread.class);
                this.$outer.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock(thread, this.$outer.kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock$default$2());
                return thread;
            }

            public int partitionCount(String topic) {
                return this.$outer.kafka$server$link$ClusterLinkFetcherManagerTest$$numPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkId(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$linkManager(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$connManager(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$brokerConfig(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$replicaManager(), $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$destAdminClient(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, $outer.kafka$server$link$ClusterLinkFetcherManagerTest$$metrics(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Time)$outer.kafka$server$link$ClusterLinkFetcherManagerTest$$time(), (Option)None$.MODULE$);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void updateMetadata(Map<String, Integer> topics, int linkedLeaderEpoch, Map<String, Errors> errors) {
        MetadataResponse metadataResponse;
        MetadataResponse metadataResponse2;
        MetadataResponse metadataResponse3;
        void metadataUpdateWith_topicErrors;
        String metadataUpdateWith_topic;
        void metadataUpdateWith_topicPartitionCounts;
        int metadataUpdateWith_numNodes;
        ClusterLinkMetadata metadata = this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata();
        java.util.Map map = CollectionConverters$.MODULE$.MapHasAsJava(topics).asJava();
        java.util.Map map2 = CollectionConverters$.MODULE$.MapHasAsJava(errors).asJava();
        boolean bl = true;
        String metadataUpdateWith_clusterId = "sourceCluster";
        java.util.Map map3 = Collections.emptyMap();
        short metadataUpdateWith_responseVersion = ApiKeys.METADATA.latestVersion();
        ArrayList<Node> metadataUpdateWith_nodes = new ArrayList<Node>(metadataUpdateWith_numNodes);
        for (int metadataUpdateWith_i = 0; metadataUpdateWith_i < metadataUpdateWith_numNodes; ++metadataUpdateWith_i) {
            metadataUpdateWith_nodes.add(new Node(metadataUpdateWith_i, "localhost", 1969 + metadataUpdateWith_i));
        }
        ArrayList<MetadataResponse.TopicMetadata> metadataUpdateWith_topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        for (Map.Entry metadataUpdateWith_topicPartitionCountEntry : metadataUpdateWith_topicPartitionCounts.entrySet()) {
            void metadataUpdateWith_topicIds;
            metadataUpdateWith_topic = (String)metadataUpdateWith_topicPartitionCountEntry.getKey();
            int metadataUpdateWith_numPartitions = (Integer)metadataUpdateWith_topicPartitionCountEntry.getValue();
            ArrayList<MetadataResponse.PartitionMetadata> metadataUpdateWith_partitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>(metadataUpdateWith_numPartitions);
            for (int metadataUpdateWith_i = 0; metadataUpdateWith_i < metadataUpdateWith_numPartitions; ++metadataUpdateWith_i) {
                TopicPartition metadataUpdateWith_tp = new TopicPartition(metadataUpdateWith_topic, metadataUpdateWith_i);
                Node metadataUpdateWith_leader = (Node)metadataUpdateWith_nodes.get(metadataUpdateWith_i % metadataUpdateWith_nodes.size());
                java.util.List<Integer> metadataUpdateWith_replicaIds = Collections.singletonList(metadataUpdateWith_leader.id());
                java.util.List list = Collections.emptyList();
                Optional<Integer> optional = Optional.ofNullable(Predef$.MODULE$.int2Integer(linkedLeaderEpoch));
                Optional<Integer> optional2 = Optional.of(metadataUpdateWith_leader.id());
                Errors errors2 = Errors.NONE;
                metadataUpdateWith_partitionMetadata.add(new MetadataResponse.PartitionMetadata(errors2, metadataUpdateWith_tp, optional2, optional, metadataUpdateWith_replicaIds, list, metadataUpdateWith_replicaIds, metadataUpdateWith_replicaIds));
            }
            metadataUpdateWith_topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, metadataUpdateWith_topic, metadataUpdateWith_topicIds.getOrDefault(metadataUpdateWith_topic, Uuid.ZERO_UUID), Topic.isInternal((String)metadataUpdateWith_topic), metadataUpdateWith_partitionMetadata, Integer.MIN_VALUE));
        }
        for (Map.Entry metadataUpdateWith_topicErrorEntry : metadataUpdateWith_topicErrors.entrySet()) {
            metadataUpdateWith_topic = (String)metadataUpdateWith_topicErrorEntry.getKey();
            metadataUpdateWith_topicMetadata.add(new MetadataResponse.TopicMetadata((Errors)metadataUpdateWith_topicErrorEntry.getValue(), metadataUpdateWith_topic, Topic.isInternal((String)metadataUpdateWith_topic), Collections.emptyList()));
        }
        int metadataResponse_controllerId = 0;
        MetadataResponse metadataResponse4 = metadataResponse3 = RequestTestUtils.metadataResponse((int)0, metadataUpdateWith_nodes, (String)metadataUpdateWith_clusterId, (int)metadataResponse_controllerId, metadataUpdateWith_topicMetadata, (int)Integer.MIN_VALUE, (short)metadataUpdateWith_responseVersion);
        metadataResponse3 = null;
        MetadataResponse metadataResponse5 = metadataResponse2 = metadataResponse4;
        map3 = null;
        Object var13_11 = null;
        Object var14_13 = null;
        Iterator iterator = null;
        Object var16_15 = null;
        Object var17_16 = null;
        Object var19_18 = null;
        Object var21_20 = null;
        Object var22_21 = null;
        Object var23_22 = null;
        metadataResponse2 = null;
        MetadataResponse metadataResponse6 = metadataResponse = metadataResponse5;
        Object var6_8 = null;
        map2 = null;
        map = null;
        metadataResponse = null;
        MetadataResponse metadataResponse7 = metadataResponse6;
        metadata.update(metadata.updateVersion(), metadataResponse7, false, this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().milliseconds());
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().onNewMetadata(TestUtils.clusterWith((int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(topics).asJava()));
    }

    private Map<String, Errors> updateMetadata$default$3() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private void setupMock(Partition partition, TopicPartition tp, int linkedLeaderEpoch, int numEpochUpdates, boolean clearOffsetsPending, boolean replayMock) {
        EasyMock.reset((Object[])new Object[]{partition});
        EasyMock.expect((Object)partition.topicPartition()).andReturn((Object)tp).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)partition.getLinkedTopicId()).andReturn((Object)this.sourceTopicId()).anyTimes();
        EasyMock.expect((Object)partition.getLinkedLeaderEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)linkedLeaderEpoch))).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partition.getLeaderEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)10)).anyTimes();
        EasyMock.expect((Object)partition.localLogOrException()).andReturn((Object)this.log()).anyTimes();
        EasyMock.expect((Object)partition.leaderLogIfLocal()).andReturn((Object)new Some((Object)this.log())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUnderMinIsr())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        partition.truncateTo(0L, false);
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        if (numEpochUpdates > 0) {
            partition.updateLinkedLeaderEpoch(EasyMock.anyInt(), (Function1)EasyMock.anyObject());
            EasyMock.expect((Object)BoxedUnit.UNIT).times(numEpochUpdates);
        }
        if (this.ibp().$greater$eq((Object)KAFKA_2_7_IV1$.MODULE$)) {
            partition.linkedLeaderOffsetsPending(false);
            EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        } else if (numEpochUpdates > 0) {
            partition.linkedLeaderOffsetsPending(true);
            EasyMock.expect((Object)BoxedUnit.UNIT).times(numEpochUpdates);
        } else if (clearOffsetsPending) {
            partition.linkedLeaderOffsetsPending(false);
            EasyMock.expect((Object)BoxedUnit.UNIT).once();
        }
        if (replayMock) {
            EasyMock.replay((Object[])new Object[]{partition});
        }
    }

    private int setupMock$default$3() {
        return 1;
    }

    private int setupMock$default$4() {
        return 0;
    }

    private boolean setupMock$default$5() {
        return false;
    }

    private boolean setupMock$default$6() {
        return true;
    }

    public void kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock(ClusterLinkFetcherThread fetcherThread, scala.collection.immutable.Set<TopicPartition> partitions) {
        EasyMock.reset((Object[])new Object[]{fetcherThread});
        InitialFetchState initialFetchState = (InitialFetchState)EasyMock.createNiceMock(InitialFetchState.class);
        scala.collection.immutable.Map partitionAndOffsets = ((IterableOnceOps)partitions.map((Function1 & Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)initialFetchState))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        EasyMock.expect((Object)fetcherThread.partitionsAndOffsets()).andReturn((Object)partitionAndOffsets).anyTimes();
        PartitionFetchState fetchState = (PartitionFetchState)EasyMock.createNiceMock(PartitionFetchState.class);
        EasyMock.expect((Object)fetchState.topicId()).andReturn((Object)new Some((Object)this.sourceTopicId())).anyTimes();
        EasyMock.expect((Object)fetcherThread.fetchState((TopicPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)fetchState)).anyTimes();
        ClusterLinkNetworkClient fetcherClient = (ClusterLinkNetworkClient)EasyMock.createNiceMock(ClusterLinkNetworkClient.class);
        EasyMock.expect((Object)fetcherThread.clusterLinkClient()).andReturn((Object)fetcherClient).anyTimes();
        fetcherThread.shutdown();
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            fetcherClient.close();
            return BoxedUnit.UNIT;
        }).anyTimes();
        Capture removedPartitions = EasyMock.newCapture();
        EasyMock.expect((Object)fetcherThread.removePartitions((Set)EasyMock.capture((Capture)removedPartitions))).andAnswer(() -> ((IterableOnceOps)((IterableOps)removedPartitions.getValue()).map((Function1 & Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)fetchState))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).anyTimes();
        EasyMock.replay((Object[])new Object[]{fetcherThread, fetchState});
    }

    public scala.collection.immutable.Set<TopicPartition> kafka$server$link$ClusterLinkFetcherManagerTest$$setupFetcherThreadMock$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private scala.collection.immutable.Set<String> metadataTopics() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().currentMetadata().newMetadataRequestBuilder().topics()).asScala().toSet();
    }

    private ClusterLinkMetadataThread metadataRefreshThread() {
        return (ClusterLinkMetadataThread)TestUtils.fieldValue((Object)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager(), ClusterLinkFetcherManager.class, (String)"metadataRefreshThread");
    }

    private void startMetadataThreadAndAddListener(MetadataListener listener) {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().startMetadataThread();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFetcherManagerTest.$anonfun$startMetadataThreadAndAddListener$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Metadata not updated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.metadataRefreshThread().addListener(listener);
    }

    private Cluster metadataCluster() {
        return (Cluster)TestUtils.fieldValue((Object)this.metadataRefreshThread(), ClusterLinkMetadataThread.class, (String)"currentMetadataCluster");
    }

    private void verifyFetcherManagerLock() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(() -> Assertions.assertEquals((int)0, (int)this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager().deadThreadCount()), BoxesRunTime.boxToInteger((int)0)).get(10L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$1(ClusterLinkFetcherManagerTest $this) {
        return $this.metadataCluster() != null;
    }

    public static final /* synthetic */ String $anonfun$testReconfigure$2() {
        return "Metadata not updated";
    }

    private final void setupLog$1(long leo, long hwm) {
        EasyMock.reset((Object[])new Object[]{this.log()});
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.log().logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)leo)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.log().highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)hwm)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.log()});
    }

    public static final /* synthetic */ void kafka$server$link$ClusterLinkFetcherManagerTest$$$anonfun$testSourceNotAvailable$1(Cluster cluster, AtomicReference currentCluster$1) {
        currentCluster$1.set(cluster);
    }

    public static final /* synthetic */ boolean $anonfun$testSourceNotAvailable$3(AtomicReference currentCluster$1) {
        return currentCluster$1.getAndSet(null) != null;
    }

    public static final /* synthetic */ String $anonfun$testSourceNotAvailable$4() {
        return "Metadata not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testSourceNotAvailable$5(AtomicReference currentCluster$1) {
        return currentCluster$1.getAndSet(null) != null;
    }

    public static final /* synthetic */ String $anonfun$testSourceNotAvailable$6() {
        return "Metadata not updated";
    }

    public static final /* synthetic */ void kafka$server$link$ClusterLinkFetcherManagerTest$$$anonfun$verifyPartitionFailureState$1(Cluster cluster, AtomicReference currentCluster$2) {
        currentCluster$2.set(cluster);
    }

    public static final /* synthetic */ void $anonfun$verifyPartitionFailureState$3(ClusterLinkFetcherManagerTest $this, TopicPartition tp$2, ConcurrentHashMap linkedPartitions$1, MirrorFailureType failureType) {
        $this.kafka$server$link$ClusterLinkFetcherManagerTest$$time().sleep((long)$this.kafka$server$link$ClusterLinkFetcherManagerTest$$clusterLinkConfig().retryTimeoutMs());
        ClusterLinkFetcherManager qual$1 = $this.kafka$server$link$ClusterLinkFetcherManagerTest$$fetcherManager();
        String x$9 = failureType.toString();
        boolean x$10 = qual$1.onPartitionLinkFailure$default$4();
        qual$1.onPartitionLinkFailure(tp$2, failureType, x$9, x$10);
        Assertions.assertNotEquals((long)0L, (long)((PartitionAndState)linkedPartitions$1.get(tp$2)).failureStartMs().get());
    }

    public static final /* synthetic */ Integer $anonfun$updateMetadata$1(int linkedLeaderEpoch$1, TopicPartition x$5) {
        return Predef$.MODULE$.int2Integer(linkedLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$startMetadataThreadAndAddListener$1(ClusterLinkFetcherManagerTest $this) {
        return $this.metadataCluster() != null;
    }

    public static final /* synthetic */ String $anonfun$startMetadataThreadAndAddListener$2() {
        return "Metadata not updated";
    }

    public ClusterLinkFetcherManagerTest() {
        this.kafka$server$link$ClusterLinkFetcherManagerTest$$linkName = "testLink";
    }
}

