/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BlockingSend;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.OffsetTruncationState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaFetcherThreadTest;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkAdminManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkTestUtils$;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.FetchState;
import kafka.server.link.LinkMode;
import kafka.server.link.MirrorFailureType;
import kafka.server.metadata.ZkMetadataCache;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tMf\u0001B\u0013'\u00015BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013%q\u0007\u0003\u0004A\u0001\u0001\u0006I\u0001\u000f\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u0019I\u0005\u0001)A\u0005\u0007\"9!\n\u0001b\u0001\n\u0013Y\u0005B\u0002*\u0001A\u0003%A\nC\u0004T\u0001\t\u0007I\u0011B&\t\rQ\u0003\u0001\u0015!\u0003M\u0011%)\u0006\u00011AA\u0002\u0013%a\u000bC\u0005[\u0001\u0001\u0007\t\u0019!C\u00057\"I\u0011\r\u0001a\u0001\u0002\u0003\u0006Ka\u0016\u0005\bE\u0002\u0001\r\u0011\"\u0003d\u0011\u001d9\u0007\u00011A\u0005\n!DaA\u001b\u0001!B\u0013!\u0007bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0002\u0001\u000b\u0011B7\t\u000fE\u0004!\u0019!C\u0005e\"1a\u000f\u0001Q\u0001\nMDQa\u001e\u0001\u0005RaD\u0011\"a/\u0001#\u0003%\t\"!0\t\u0013\u0005M\u0007!%A\u0005\u0012\u0005u\u0006bBAk\u0001\u0011\u0005\u0013q\u001b\u0005\b\u0003_\u0004A\u0011BAy\u0011\u001d\tI\u0010\u0001C!\u0003/DqAa\u0001\u0001\t\u0003\t9\u000eC\u0004\u0003\b\u0001!\t!a6\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!Q\u0004\u0001\u0005\u0002\t}\u0001b\u0002B+\u0001\u0011\u0005\u0013q\u001b\u0005\b\u0005O\u0002A\u0011\tB5\u0011%\u0011\u0019\bAI\u0001\n\u0003\u0011)\bC\u0004\u0003z\u0001!\t%a6\t\u000f\tu\u0004\u0001\"\u0001\u0002X\"9!\u0011\u0011\u0001\u0005\u0002\u0005]\u0007b\u0002BC\u0001\u0011E#q\u0011\u0002\u001d\u00072,8\u000f^3s\u0019&t7NR3uG\",'\u000f\u00165sK\u0006$G+Z:u\u0015\t9\u0003&\u0001\u0003mS:\\'BA\u0015+\u0003\u0019\u0019XM\u001d<fe*\t1&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0003CA\u00181\u001b\u0005A\u0013BA\u0019)\u0005a\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bIR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0002\"!\u000e\u0001\u000e\u0003\u0019\nQb\u00197vgR,'\u000fT5oW&#W#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001B;uS2T\u0011!P\u0001\u0005U\u00064\u0018-\u0003\u0002@u\t!Q+V%E\u00039\u0019G.^:uKJd\u0015N\\6JI\u0002\nqb\u00197vgR,'\u000fT5oW:\u000bW.Z\u000b\u0002\u0007B\u0011AiR\u0007\u0002\u000b*\u0011a\tP\u0001\u0005Y\u0006tw-\u0003\u0002I\u000b\n11\u000b\u001e:j]\u001e\f\u0001c\u00197vgR,'\u000fT5oW:\u000bW.\u001a\u0011\u0002)\rdWo\u001d;fe2Kgn\u001b\"bG.|gMZ't+\u0005a\u0005CA'Q\u001b\u0005q%\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es%aA%oi\u0006)2\r\\;ti\u0016\u0014H*\u001b8l\u0005\u0006\u001c7n\u001c4g\u001bN\u0004\u0013!\u00047bO\u001eLgn\u001a+j[\u0016l5/\u0001\bmC\u001e<\u0017N\\4US6,Wj\u001d\u0011\u0002\u001b\u0019,Go\u00195feRC'/Z1e+\u00059\u0006CA\u001bY\u0013\tIfE\u0001\rDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\f\u0011CZ3uG\",'\u000f\u00165sK\u0006$w\fJ3r)\tav\f\u0005\u0002N;&\u0011aL\u0014\u0002\u0005+:LG\u000fC\u0004a\u0017\u0005\u0005\t\u0019A,\u0002\u0007a$\u0013'\u0001\bgKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0011\u0002\u0013%\u001cH)\u001a7bs\u0016$W#\u00013\u0011\u00055+\u0017B\u00014O\u0005\u001d\u0011un\u001c7fC:\fQ\"[:EK2\f\u00170\u001a3`I\u0015\fHC\u0001/j\u0011\u001d\u0001g\"!AA\u0002\u0011\f!\"[:EK2\f\u00170\u001a3!\u0003E1W\r^2i%\u0016\u001c\bo\u001c8tKNK'0Z\u000b\u0002[B\u0011QG\\\u0005\u0003_\u001a\u0012\u0011CR3uG\"\u0014Vm\u001d9p]N,7+\u001b>f\u0003I1W\r^2i%\u0016\u001c\bo\u001c8tKNK'0\u001a\u0011\u0002%\rdWo\u001d;fe2Kgn['fiJL7m]\u000b\u0002gB\u0011Q\u0007^\u0005\u0003k\u001a\u0012!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006\u00192\r\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2tA\u0005Q2M]3bi\u0016\u0014V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bIRa\u0012\u0010`A\t\u0003+\t)#a\f\u0002:\u0005\r\u0013qLA8\u0003s\n\u0019*a(\u0002,\u0006]\u0006CA\u0018{\u0013\tY\bF\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\u0006{R\u0001\rA`\u0001\u0005]\u0006lW\rE\u0002\u0000\u0003\u001bqA!!\u0001\u0002\nA\u0019\u00111\u0001(\u000e\u0005\u0005\u0015!bAA\u0004Y\u00051AH]8pizJ1!a\u0003O\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001*a\u0004\u000b\u0007\u0005-a\n\u0003\u0004\u0002\u0014Q\u0001\r\u0001T\u0001\nM\u0016$8\r[3s\u0013\u0012Dq!a\u0006\u0015\u0001\u0004\tI\"\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyBK\u0001\bG2,8\u000f^3s\u0013\u0011\t\u0019#!\b\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\"9\u0011q\u0005\u000bA\u0002\u0005%\u0012\u0001\u00042s_.,'oQ8oM&<\u0007cA\u0018\u0002,%\u0019\u0011Q\u0006\u0015\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0003c!\u0002\u0019AA\u001a\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u00020\u0003kI1!a\u000e)\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7\u000fC\u0004\u0002<Q\u0001\r!!\u0010\u0002\u0015I,\u0007\u000f\\5dC6;'\u000fE\u00020\u0003\u007fI1!!\u0011)\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!!\u0012\u0015\u0001\u0004\t9%A\u0004nKR\u0014\u0018nY:\u0011\t\u0005%\u00131L\u0007\u0003\u0003\u0017RA!!\u0012\u0002N)!\u0011qJA)\u0003\u0019\u0019w.\\7p]*\u00191&a\u0015\u000b\t\u0005U\u0013qK\u0001\u0007CB\f7\r[3\u000b\u0005\u0005e\u0013aA8sO&!\u0011QLA&\u0005\u001diU\r\u001e:jGNDq!!\u0019\u0015\u0001\u0004\t\u0019'\u0001\u0003uS6,\u0007\u0003BA3\u0003Wj!!a\u001a\u000b\t\u0005%\u0014QJ\u0001\u0006kRLGn]\u0005\u0005\u0003[\n9G\u0001\u0003US6,\u0007bBA9)\u0001\u0007\u00111O\u0001\u0006cV|G/\u0019\t\u0004_\u0005U\u0014bAA<Q\ta!+\u001a9mS\u000e\f\u0017+^8uC\"9\u00111\u0010\u000bA\u0002\u0005u\u0014\u0001\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3s!\u0015i\u0015qPAB\u0013\r\t\tI\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u00069a-\u001a;dQ\u0016\u0014(bAAGU\u0005!A/[3s\u0013\u0011\t\t*a\"\u0003!QKWM]*uCR,g)\u001a;dQ\u0016\u0014\b\"CAK)A\u0005\t\u0019AAL\u0003iaW-\u00193fe\u0016sG\r]8j]R\u0014En\\2lS:<7+\u001a8e!\u0015i\u0015qPAM!\ry\u00131T\u0005\u0004\u0003;C#\u0001\u0004\"m_\u000e\\\u0017N\\4TK:$\u0007\"CAQ)A\u0005\t\u0019AAR\u00035awnZ\"p]R,\u0007\u0010^(qiB)Q*a \u0002&B!\u0011QMAT\u0013\u0011\tI+a\u001a\u0003\u00151{wmQ8oi\u0016DH\u000fC\u0005\u0002.R\u0001\n\u00111\u0001\u00020\u0006\tb-\u001a;dQ\n\u000b7m[(gM6\u001bx\n\u001d;\u0011\u000b5\u000by(!-\u0011\u00075\u000b\u0019,C\u0002\u00026:\u0013A\u0001T8oO\"I\u0011\u0011\u0018\u000b\u0011\u0002\u0003\u0007\u0011qV\u0001\u0015M\u0016$8\r\u001b\"bG.|eMZ't\u001b\u0006Dx\n\u001d;\u0002K\r\u0014X-\u0019;f%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193%I\u00164\u0017-\u001e7uIE\u001aTCAA`U\u0011\ty+!1,\u0005\u0005\r\u0007\u0003BAc\u0003\u001fl!!a2\u000b\t\u0005%\u00171Z\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!4O\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\f9MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQe\u0019:fCR,'+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$C-\u001a4bk2$H%\r\u001b\u0002\u000f\rdW-\u00198vaR\tA\fK\u0002\u0018\u00037\u0004B!!8\u0002l6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019/A\u0002ba&TA!!:\u0002h\u00069!.\u001e9ji\u0016\u0014(\u0002BAu\u0003/\nQA[;oSRLA!!<\u0002`\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012G2,8\u000f^3s\u0019&t7nQ8oM&<WCAAz!\r)\u0014Q_\u0005\u0004\u0003o4#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006\u00194\u000f[8vY\u0012,6/\u001a'fC\u0012,'/\u00128e\u001f\u001a47/\u001a;JM&sG/\u001a:Ce>\\WM\u001d,feNLwN\u001c\"fY><(\u0007\r\u0015\u00043\u0005u\b\u0003BAo\u0003\u007fLAA!\u0001\u0002`\n!A+Z:u\u0003u!Xm\u001d;T_V\u00148-Z(gMN,Go\u001d)f]\u0012LgnZ*uCR,\u0007f\u0001\u000e\u0002~\u00061C/Z:u'>,(oY3PM\u001a\u001cX\r^:QK:$\u0017N\\4Ti\u0006$XmV5uQ&\u0013\u0007O\r\u001c)\u0007m\ti0A\u0010wKJLg-_*pkJ\u001cWm\u00144gg\u0016$8\u000fU3oI&twm\u0015;bi\u0016$2\u0001\u0018B\b\u0011\u001d\u0011\t\u0002\ba\u0001\u0005'\t1!\u001b2q!\u0011\u0011)B!\u0007\u000e\u0005\t]!bAAqU%!!1\u0004B\f\u0005)\t\u0005/\u001b,feNLwN\\\u0001!g\u0016$X\u000f\u001d$fi\u000eDWM]'b]\u0006<WM]!oIB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0003\"\t\r#q\nB*!\u001di%1\u0005B\u0014\u0005[I1A!\nO\u0005\u0019!V\u000f\u001d7feA\u0019QG!\u000b\n\u0007\t-bEA\rDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bC\u0002B\u0018\u0005s\u0011i$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003\u001diW\u000f^1cY\u0016T1Aa\u000eO\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005w\u0011\tDA\u0002TKR\u0004B!a\u0007\u0003@%!!\u0011IA\u000f\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0002bu\u0001\rA!\u0012\u0011\t\t\u001d#1J\u0007\u0003\u0005\u0013R1!!\u001b+\u0013\u0011\u0011iE!\u0013\u0003\u00115{7m\u001b+j[\u0016DaA!\u0015\u001e\u0001\u0004a\u0015!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0004\u0003\u0012u\u0001\rAa\u0005\u0002AQ,7\u000f\u001e$pY2|w/\u001a:JgRC'o\u001c;uY\u0016$wJ\u001c'po\u0012K7o\u001b\u0015\u0004=\u0005u\bf\u0002\u0010\u0003\\\t\u0005$1\r\t\u0005\u0003;\u0014i&\u0003\u0003\u0003`\u0005}'\u0001\u0003#jg\u0006\u0014G.\u001a3\u0002\u000bY\fG.^3\"\u0005\t\u0015\u0014\u0001\b#jg.\u0004C\u000f\u001b:piRdW\rI5tA9|G\u000fI1qa2LW\rZ\u0001\u001am\u0016\u0014\u0018NZ=NCJ\\'+\u001a9mS\u000e\fG\u000b\u001b:piRdW\rF\u0003]\u0005W\u0012y\u0007C\u0004\u0003n}\u0001\r!!\u0010\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4fe\"A!\u0011O\u0010\u0011\u0002\u0003\u0007A*A\u0003uS6,7/A\u0012wKJLg-_'be.\u0014V\r\u001d7jG\u0006$\u0006N]8ui2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t]$f\u0001'\u0002B\u0006A4\u000f[8vY\u0012tu\u000e\u001e$fi\u000eDG*Z1eKJ,\u0005o\\2i\u001f:4\u0015N]:u\r\u0016$8\r[,ji\"$&/\u001e8dCR,wJ\u001c$fi\u000eD\u0007fA\u0011\u0002~\u0006AB/Z:u\r\u0016$8\r[3s)\"\u0014X-\u00193CC\u000e\\wN\u001a4)\u0007\t\ni0A\u000euKN$\u0018\t\u001a6vgRd\u0015mZ4j]\u001e\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004G\u0005u\u0018A\u0007<fe&4\u0017p\u00144gg\u0016$(+Z9vKN$h+\u001a:tS>tGc\u0002/\u0003\n\n-%1\u0015\u0005\b\u0005#!\u0003\u0019\u0001B\n\u0011\u001d\u0011i\t\na\u0001\u0005\u001f\u000b1d\u001c4gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$\b\u0003\u0002BI\u0005;sAAa%\u0003\u001a6\u0011!Q\u0013\u0006\u0005\u0005/\u000bi%\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011YJ!&\u00029=3gm]3ug\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti&!!q\u0014BQ\u0005\u001d\u0011U/\u001b7eKJTAAa'\u0003\u0016\"9!Q\u0015\u0013A\u0002\t\u001d\u0016A\u00057jgR|eMZ:fiN\u0014V-];fgR\u0004BA!+\u00030:!!1\u0013BV\u0013\u0011\u0011iK!&\u0002%1K7\u000f^(gMN,Go\u001d*fcV,7\u000f^\u0005\u0005\u0005?\u0013\tL\u0003\u0003\u0003.\nU\u0005")
public class ClusterLinkFetcherThreadTest
extends ReplicaFetcherThreadTest {
    private final UUID kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkId = UUID.randomUUID();
    private final String kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkName;
    private final int clusterLinkBackoffMs;
    private final int laggingTimeMs;
    private ClusterLinkFetcherThread kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread;
    private boolean kafka$server$link$ClusterLinkFetcherThreadTest$$isDelayed = false;
    private final FetchResponseSize kafka$server$link$ClusterLinkFetcherThreadTest$$fetchResponseSize = new FetchResponseSize(100, 1000);
    private final ClusterLinkMetrics kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkMetrics = new ClusterLinkMetrics(this.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkName(), this.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkId(), (LinkMode)LinkMode.Destination$.MODULE$, null, (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);

    public UUID kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkId() {
        return this.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkId;
    }

    public String kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkName() {
        return this.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkName;
    }

    private int clusterLinkBackoffMs() {
        return this.clusterLinkBackoffMs;
    }

    private int laggingTimeMs() {
        return this.laggingTimeMs;
    }

    public ClusterLinkFetcherThread kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread() {
        return this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread;
    }

    public void kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread_$eq(ClusterLinkFetcherThread x$1) {
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread = x$1;
    }

    private boolean isDelayed() {
        return this.kafka$server$link$ClusterLinkFetcherThreadTest$$isDelayed;
    }

    public void kafka$server$link$ClusterLinkFetcherThreadTest$$isDelayed_$eq(boolean x$1) {
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$isDelayed = x$1;
    }

    public FetchResponseSize kafka$server$link$ClusterLinkFetcherThreadTest$$fetchResponseSize() {
        return this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetchResponseSize;
    }

    public ClusterLinkMetrics kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkMetrics() {
        return this.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkMetrics;
    }

    @Override
    public ReplicaFetcherThread createReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<TierStateFetcher> tierStateFetcher, Option<BlockingSend> leaderEndpointBlockingSend, Option<LogContext> logContextOpt, Option<Object> fetchBackOffMsOpt, Option<Object> fetchBackOffMsMaxOpt) {
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)EasyMock.mock(ClusterLinkFetcherManager.class);
        EasyMock.expect((Object)fetcherManager.partition((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)None$.MODULE$).anyTimes();
        fetcherManager.updatePartitionFetchState((TopicPartition)EasyMock.anyObject(TopicPartition.class), (FetchState)EasyMock.anyObject(FetchState.class));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcherManager.onPartitionLinkFailure((TopicPartition)EasyMock.anyObject(TopicPartition.class), (MirrorFailureType)EasyMock.anyObject(MirrorFailureType.class), EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.replay((Object[])new Object[]{fetcherManager});
        return new ClusterLinkFetcherThread(this, name, brokerConfig, fetcherManager, failedPartitions, replicaMgr, quota, leaderEndpointBlockingSend){
            private final /* synthetic */ ClusterLinkFetcherThreadTest $outer;

            public void clearPartitionLinkFailure(TopicPartition tp, long fetchOffset) {
            }

            public boolean isReadyForFetch(TopicPartition tp) {
                return true;
            }

            public void delayPartitions(Iterable<TopicPartition> partitions) {
                super.delayPartitions(partitions);
                this.$outer.kafka$server$link$ClusterLinkFetcherThreadTest$$isDelayed_$eq(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(name$1, 0, brokerConfig$1, $outer.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkConfig(), new ClusterLinkMetadata(brokerConfig$1, $outer.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkName(), $outer.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkId(), (LinkMode)LinkMode.Destination$.MODULE$, 100L, 60000L), fetcherManager$1, $outer.brokerEndPoint(), failedPartitions$1, replicaMgr$1, quota$1, $outer.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkMetrics(), (Time)new SystemTime(), (Function0)new Serializable($outer){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ ClusterLinkFetcherThreadTest $outer;

                    public final FetchResponseSize apply() {
                        return this.$outer.kafka$server$link$ClusterLinkFetcherThreadTest$$fetchResponseSize();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (ClusterLinkNetworkClient)EasyMock.mock(ClusterLinkNetworkClient.class), leaderEndpointBlockingSend$1.isDefined() ? (BlockingSend)leaderEndpointBlockingSend$1.get() : (BlockingSend)EasyMock.mock(BlockingSend.class), (Option)None$.MODULE$, (Option)None$.MODULE$);
            }
        };
    }

    @Override
    public Option<Object> createReplicaFetcherThread$default$13() {
        return None$.MODULE$;
    }

    @Override
    public Option<Object> createReplicaFetcherThread$default$14() {
        return None$.MODULE$;
    }

    @Override
    @AfterEach
    public void cleanup() {
        if (this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread() != null) {
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().shutdown();
        }
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkMetrics().shutdown();
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$isDelayed_$eq(false);
        super.cleanup();
    }

    public ClusterLinkConfig kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkConfig() {
        Properties props = new Properties();
        props.put("bootstrap.servers", new StringBuilder(1).append(this.brokerEndPoint().host()).append(":").append(this.brokerEndPoint().port()).toString());
        props.put(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), Integer.toString(this.clusterLinkBackoffMs()));
        props.put(ClusterLinkConfig$.MODULE$.LinkFetcherMaxLaggingPartitionsProp(), "2");
        props.put(ClusterLinkConfig$.MODULE$.LinkFetcherLaggingPartitionMsProp(), Integer.toString(this.laggingTimeMs()));
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)props, true);
    }

    @Override
    @Test
    public void shouldUseLeaderEndOffsetIfInterBrokerVersionBelow20() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(props);
        Metrics metrics = new Metrics();
        boolean isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((java.util.Map)brokerConfig.values(), (Metrics)metrics) != null;
        ClusterLinkAdminManager clusterLinkAdminManager = new ClusterLinkAdminManager(brokerConfig, "clusterId", ClusterLinkTestUtils$.MODULE$.createClusterLinkManager(), metrics, (Time)new MockTime(), isMultiTenant);
        try {
            NewClusterLink newClusterLink = new NewClusterLink("test-link", "clusterId", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
            Assertions.assertThrows(InvalidClusterLinkException.class, () -> clusterLinkAdminManager.createClusterLink(newClusterLink, (Option)None$.MODULE$, new ListenerName("EXTERNAL"), false, false, 1000, 1).get());
        }
        finally {
            clusterLinkAdminManager.shutdown();
        }
    }

    @Test
    public void testSourceOffsetsPendingState() {
        this.verifySourceOffsetsPendingState(ApiVersion$.MODULE$.latestVersion());
    }

    @Test
    public void testSourceOffsetsPendingStateWithIbp26() {
        this.verifySourceOffsetsPendingState((ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private void verifySourceOffsetsPendingState(ApiVersion ibp) {
        void var4_4;
        MetadataResponse metadataResponse;
        MetadataResponse metadataResponse2;
        MetadataResponse metadataResponse3;
        void metadataUpdateWith_topicErrors;
        String metadataUpdateWith_topic;
        void metadataUpdateWith_topicPartitionCounts;
        int metadataUpdateWith_numNodes;
        void var5_5;
        MockTime time = new MockTime();
        Tuple2<ClusterLinkFetcherManager, Set<Partition>> tuple2 = this.setupFetcherManagerAndPartitions(time, 1, ibp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)tuple2._1();
        Set partitions = (Set)tuple2._2();
        TopicPartition tp = new TopicPartition("topic", 0);
        Partition partition = (Partition)var5_5.head();
        Assertions.assertNull((Object)this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread(), (String)"Fetcher thread created without metadata");
        java.util.Map<String, Integer> map = Collections.singletonMap("topic", Predef$.MODULE$.int2Integer(1));
        java.util.Map<String, Errors> map2 = Collections.singletonMap("topic", Errors.NONE);
        boolean bl = true;
        String metadataUpdateWith_clusterId = "cluster";
        java.util.Map map3 = Collections.emptyMap();
        short metadataUpdateWith_responseVersion = ApiKeys.METADATA.latestVersion();
        ArrayList<Node> metadataUpdateWith_nodes = new ArrayList<Node>(metadataUpdateWith_numNodes);
        for (int metadataUpdateWith_i = 0; metadataUpdateWith_i < metadataUpdateWith_numNodes; ++metadataUpdateWith_i) {
            metadataUpdateWith_nodes.add(new Node(metadataUpdateWith_i, "localhost", 1969 + metadataUpdateWith_i));
        }
        ArrayList<MetadataResponse.TopicMetadata> metadataUpdateWith_topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        for (Map.Entry metadataUpdateWith_topicPartitionCountEntry : metadataUpdateWith_topicPartitionCounts.entrySet()) {
            void metadataUpdateWith_topicIds;
            metadataUpdateWith_topic = (String)metadataUpdateWith_topicPartitionCountEntry.getKey();
            int metadataUpdateWith_numPartitions = (Integer)metadataUpdateWith_topicPartitionCountEntry.getValue();
            ArrayList<MetadataResponse.PartitionMetadata> metadataUpdateWith_partitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>(metadataUpdateWith_numPartitions);
            for (int metadataUpdateWith_i = 0; metadataUpdateWith_i < metadataUpdateWith_numPartitions; ++metadataUpdateWith_i) {
                TopicPartition metadataUpdateWith_tp = new TopicPartition(metadataUpdateWith_topic, metadataUpdateWith_i);
                Node metadataUpdateWith_leader = (Node)metadataUpdateWith_nodes.get(metadataUpdateWith_i % metadataUpdateWith_nodes.size());
                List<Integer> metadataUpdateWith_replicaIds = Collections.singletonList(metadataUpdateWith_leader.id());
                List list = Collections.emptyList();
                Optional<Integer> optional = Optional.ofNullable(Predef$.MODULE$.int2Integer(1));
                Optional<Integer> optional2 = Optional.of(metadataUpdateWith_leader.id());
                Errors errors = Errors.NONE;
                metadataUpdateWith_partitionMetadata.add(new MetadataResponse.PartitionMetadata(errors, metadataUpdateWith_tp, optional2, optional, metadataUpdateWith_replicaIds, list, metadataUpdateWith_replicaIds, metadataUpdateWith_replicaIds));
            }
            metadataUpdateWith_topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, metadataUpdateWith_topic, metadataUpdateWith_topicIds.getOrDefault(metadataUpdateWith_topic, Uuid.ZERO_UUID), Topic.isInternal((String)metadataUpdateWith_topic), metadataUpdateWith_partitionMetadata, Integer.MIN_VALUE));
        }
        for (Map.Entry metadataUpdateWith_topicErrorEntry : metadataUpdateWith_topicErrors.entrySet()) {
            metadataUpdateWith_topic = (String)metadataUpdateWith_topicErrorEntry.getKey();
            metadataUpdateWith_topicMetadata.add(new MetadataResponse.TopicMetadata((Errors)metadataUpdateWith_topicErrorEntry.getValue(), metadataUpdateWith_topic, Topic.isInternal((String)metadataUpdateWith_topic), Collections.emptyList()));
        }
        int metadataResponse_controllerId = 0;
        MetadataResponse metadataResponse4 = metadataResponse3 = RequestTestUtils.metadataResponse((int)0, metadataUpdateWith_nodes, (String)metadataUpdateWith_clusterId, (int)metadataResponse_controllerId, metadataUpdateWith_topicMetadata, (int)Integer.MIN_VALUE, (short)metadataUpdateWith_responseVersion);
        metadataResponse3 = null;
        MetadataResponse metadataResponse5 = metadataResponse2 = metadataResponse4;
        map3 = null;
        Object var16_14 = null;
        Object var17_16 = null;
        Iterator iterator = null;
        Object var19_18 = null;
        Object var20_19 = null;
        Object var22_21 = null;
        Object var24_23 = null;
        Object var25_24 = null;
        Object var26_25 = null;
        metadataResponse2 = null;
        MetadataResponse metadataResponse6 = metadataResponse = metadataResponse5;
        Object var9_11 = null;
        map2 = null;
        map = null;
        metadataResponse = null;
        MetadataResponse metadataResponse7 = metadataResponse6;
        var4_4.currentMetadata().update(1, metadataResponse7, false, time.milliseconds());
        var4_4.onNewMetadata(var4_4.currentMetadata().fetch());
        Assertions.assertNotNull((Object)this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread(), (String)"Fetcher thread not created");
        if (ibp.$greater$eq((Object)KAFKA_2_7_IV1$.MODULE$)) {
            Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)TestUtils.fieldValue((Object)partition, Partition.class, (String)"needsLinkedLeaderOffsets")), (String)new StringBuilder(24).append("State not reset for IBP ").append(ibp).toString());
            return;
        }
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)TestUtils.fieldValue((Object)partition, Partition.class, (String)"needsLinkedLeaderOffsets")), (String)"State reset before fetching offsets");
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updateFetchOffsetAndMaybeMarkTruncationComplete((Map)Predef$.MODULE$.Map().empty());
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)TestUtils.fieldValue((Object)partition, Partition.class, (String)"needsLinkedLeaderOffsets")), (String)"State reset before source offsets available");
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updateFetchOffsetAndMaybeMarkTruncationComplete((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetTruncationState(10L, false))})));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)TestUtils.fieldValue((Object)partition, Partition.class, (String)"needsLinkedLeaderOffsets")), (String)"State reset before truncation");
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updateFetchOffsetAndMaybeMarkTruncationComplete((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetTruncationState(10L, true))})));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)TestUtils.fieldValue((Object)partition, Partition.class, (String)"needsLinkedLeaderOffsets")), (String)"State not reset after truncation");
    }

    public Tuple2<ClusterLinkFetcherManager, Set<Partition>> setupFetcherManagerAndPartitions(MockTime time, int numPartitions, ApiVersion ibp) {
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        IsrChangeListener isrChangeListener = (IsrChangeListener)EasyMock.createNiceMock(IsrChangeListener.class);
        AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.brokerTopicStats()).andReturn(EasyMock.mock(BrokerTopicStats.class)).anyTimes();
        Set partitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numPartitions - 1).foreach((Function1 & Serializable)partitionNum -> ClusterLinkFetcherThreadTest.$anonfun$setupFetcherManagerAndPartitions$1(time, isrChangeListener, logManager, log, replicaManager, partitions, BoxesRunTime.unboxToInt((Object)partitionNum)));
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ibp.shortVersion());
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend blockingSend = (BlockingSend)EasyMock.createNiceMock(BlockingSend.class);
        blockingSend.close();
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        ClusterLinkDestConnectionManager connManager = (ClusterLinkDestConnectionManager)EasyMock.createNiceMock(ClusterLinkDestConnectionManager.class);
        EasyMock.expect((Object)connManager.reverseConnectionProvider((NetworkClient)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (String)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).anyTimes();
        ClusterLinkManager linkManager = (ClusterLinkManager)EasyMock.createNiceMock(ClusterLinkManager.class);
        EasyMock.expect((Object)linkManager.fetchResponseSize((ClusterLinkConfig)EasyMock.anyObject())).andReturn((Object)this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetchResponseSize()).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, linkManager, log, blockingSend});
        ClusterLinkFetcherManager fetcherManager = new ClusterLinkFetcherManager(this, linkManager, connManager, brokerConfig, replicaManager, time, blockingSend, numPartitions){
            private final /* synthetic */ ClusterLinkFetcherThreadTest $outer;
            public final KafkaConfig brokerConfig$2;
            public final ReplicaManager replicaManager$1;
            public final BlockingSend blockingSend$1;
            private final int numPartitions$1;

            public ClusterLinkFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
                this.$outer.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread_$eq(new ClusterLinkFetcherThread(this){

                    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
                    }

                    public Option<Object> latestEpoch(TopicPartition topicPartition) {
                        return new Some((Object)BoxesRunTime.boxToInteger((int)1));
                    }
                });
                return this.$outer.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread();
            }

            public int partitionCount(String topic) {
                return this.numPartitions$1;
            }

            public /* synthetic */ ClusterLinkFetcherThreadTest kafka$server$link$ClusterLinkFetcherThreadTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerConfig$2 = brokerConfig$2;
                this.replicaManager$1 = replicaManager$1;
                this.blockingSend$1 = blockingSend$1;
                this.numPartitions$1 = numPartitions$1;
                super($outer.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkName(), $outer.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkId(), $outer.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkConfig(), linkManager$1, connManager$1, brokerConfig$2, replicaManager$1, null, (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, $outer.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkMetrics(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Time)time$1, (Option)None$.MODULE$);
            }
        };
        fetcherManager.initializeMetadata();
        fetcherManager.addLinkedFetcherForPartitions((Iterable)partitions);
        return new Tuple2((Object)fetcherManager, (Object)partitions);
    }

    @Override
    @Disabled(value="Disk throttle is not applied")
    @Test
    public void testFollowerIsThrottledOnLowDisk() {
        super.testFollowerIsThrottledOnLowDisk();
    }

    @Override
    public void verifyMarkReplicaThrottle(ReplicaManager replicaManager, int times) {
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)times))).markClusterLinkReplicaThrottle();
    }

    @Override
    public int verifyMarkReplicaThrottle$default$2() {
        return 1;
    }

    @Override
    @Test
    public void shouldNotFetchLeaderEpochOnFirstFetchWithTruncateOnFetch() {
        this.verifyFetchLeaderEpochOnFirstFetch(ApiVersion$.MODULE$.latestVersion(), 1);
    }

    @Test
    public void testFetcherThreadBackoff() {
        super.shouldPollIndefinitelyIfLeaderReturnsAnyException();
        Assertions.assertTrue((boolean)this.isDelayed());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAdjustLaggingPartitions() {
        void var4_4;
        void var3_3;
        MetadataResponse metadataResponse;
        MetadataResponse metadataResponse2;
        MetadataResponse metadataResponse3;
        void metadataUpdateWith_topicErrors;
        String metadataUpdateWith_topic;
        void metadataUpdateWith_topicPartitionCounts;
        int metadataUpdateWith_numNodes;
        MockTime time = new MockTime();
        Tuple2<ClusterLinkFetcherManager, Set<Partition>> tuple2 = this.setupFetcherManagerAndPartitions(time, 4, ApiVersion$.MODULE$.latestVersion());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)tuple2._1();
        Set partitions = (Set)tuple2._2();
        Assertions.assertNull((Object)this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread(), (String)"Fetcher thread created without metadata");
        java.util.Map<String, Integer> map = Collections.singletonMap("topic", Predef$.MODULE$.int2Integer(4));
        java.util.Map<String, Errors> map2 = Collections.singletonMap("topic", Errors.NONE);
        boolean bl = true;
        String metadataUpdateWith_clusterId = "cluster";
        java.util.Map map3 = Collections.emptyMap();
        short metadataUpdateWith_responseVersion = ApiKeys.METADATA.latestVersion();
        ArrayList<Node> metadataUpdateWith_nodes = new ArrayList<Node>(metadataUpdateWith_numNodes);
        for (int metadataUpdateWith_i = 0; metadataUpdateWith_i < metadataUpdateWith_numNodes; ++metadataUpdateWith_i) {
            metadataUpdateWith_nodes.add(new Node(metadataUpdateWith_i, "localhost", 1969 + metadataUpdateWith_i));
        }
        ArrayList<MetadataResponse.TopicMetadata> metadataUpdateWith_topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        for (Map.Entry metadataUpdateWith_topicPartitionCountEntry : metadataUpdateWith_topicPartitionCounts.entrySet()) {
            void metadataUpdateWith_topicIds;
            metadataUpdateWith_topic = (String)metadataUpdateWith_topicPartitionCountEntry.getKey();
            int metadataUpdateWith_numPartitions = (Integer)metadataUpdateWith_topicPartitionCountEntry.getValue();
            ArrayList<MetadataResponse.PartitionMetadata> metadataUpdateWith_partitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>(metadataUpdateWith_numPartitions);
            for (int metadataUpdateWith_i = 0; metadataUpdateWith_i < metadataUpdateWith_numPartitions; ++metadataUpdateWith_i) {
                TopicPartition metadataUpdateWith_tp = new TopicPartition(metadataUpdateWith_topic, metadataUpdateWith_i);
                Node metadataUpdateWith_leader = (Node)metadataUpdateWith_nodes.get(metadataUpdateWith_i % metadataUpdateWith_nodes.size());
                List<Integer> metadataUpdateWith_replicaIds = Collections.singletonList(metadataUpdateWith_leader.id());
                List list = Collections.emptyList();
                Optional<Integer> optional = Optional.ofNullable(Predef$.MODULE$.int2Integer(1));
                Optional<Integer> optional2 = Optional.of(metadataUpdateWith_leader.id());
                Errors errors = Errors.NONE;
                metadataUpdateWith_partitionMetadata.add(new MetadataResponse.PartitionMetadata(errors, metadataUpdateWith_tp, optional2, optional, metadataUpdateWith_replicaIds, list, metadataUpdateWith_replicaIds, metadataUpdateWith_replicaIds));
            }
            metadataUpdateWith_topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, metadataUpdateWith_topic, metadataUpdateWith_topicIds.getOrDefault(metadataUpdateWith_topic, Uuid.ZERO_UUID), Topic.isInternal((String)metadataUpdateWith_topic), metadataUpdateWith_partitionMetadata, Integer.MIN_VALUE));
        }
        for (Map.Entry metadataUpdateWith_topicErrorEntry : metadataUpdateWith_topicErrors.entrySet()) {
            metadataUpdateWith_topic = (String)metadataUpdateWith_topicErrorEntry.getKey();
            metadataUpdateWith_topicMetadata.add(new MetadataResponse.TopicMetadata((Errors)metadataUpdateWith_topicErrorEntry.getValue(), metadataUpdateWith_topic, Topic.isInternal((String)metadataUpdateWith_topic), Collections.emptyList()));
        }
        int metadataResponse_controllerId = 0;
        MetadataResponse metadataResponse4 = metadataResponse3 = RequestTestUtils.metadataResponse((int)0, metadataUpdateWith_nodes, (String)metadataUpdateWith_clusterId, (int)metadataResponse_controllerId, metadataUpdateWith_topicMetadata, (int)Integer.MIN_VALUE, (short)metadataUpdateWith_responseVersion);
        metadataResponse3 = null;
        MetadataResponse metadataResponse5 = metadataResponse2 = metadataResponse4;
        map3 = null;
        Object var14_11 = null;
        Object var15_13 = null;
        Iterator iterator = null;
        Object var17_15 = null;
        Object var18_16 = null;
        Object var20_18 = null;
        Object var22_20 = null;
        Object var23_21 = null;
        Object var24_22 = null;
        metadataResponse2 = null;
        MetadataResponse metadataResponse6 = metadataResponse = metadataResponse5;
        Object var7_8 = null;
        map2 = null;
        map = null;
        metadataResponse = null;
        MetadataResponse metadataResponse7 = metadataResponse6;
        var3_3.currentMetadata().update(1, metadataResponse7, false, time.milliseconds());
        var3_3.onNewMetadata(var3_3.currentMetadata().fetch());
        Assertions.assertNotNull((Object)this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread(), (String)"Fetcher thread not created");
        Assertions.assertEquals((int)1, (int)var3_3.fetcherThreadMap().size());
        Assertions.assertEquals((int)0, (int)var3_3.unassignedPartitionCount());
        int laggingPartitionCaughtUpTime = 1;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionNum -> {
            TopicPartition tp = new TopicPartition("topic", partitionNum);
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updatePartitionLastCaughtUpTime(tp, (long)laggingPartitionCaughtUpTime);
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updateFetcherLagStats(tp, (long)(partitionNum + 100));
        });
        var3_3.maybeAdjustFetcherLaggingPartitions();
        Assertions.assertEquals((int)0, (int)var3_3.unassignedPartitionCount());
        Assertions.assertEquals((int)2, (int)var3_3.throttledPartitionCount());
        var3_3.throttledPartitions().contains((Object)new TopicPartition("topic", 2));
        var3_3.throttledPartitions().contains((Object)new TopicPartition("topic", 3));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionNum -> {
            TopicPartition tp = new TopicPartition("topic", partitionNum);
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updateFetcherLagStats(tp, 0L);
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updatePartitionLastCaughtUpTime(tp, Long.MAX_VALUE);
        });
        var3_3.maybeAdjustFetcherLaggingPartitions();
        Assertions.assertEquals((int)0, (int)var3_3.unassignedPartitionCount());
        Assertions.assertEquals((int)0, (int)var3_3.throttledPartitionCount());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionNum -> {
            TopicPartition tp = new TopicPartition("topic", partitionNum);
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updatePartitionLastCaughtUpTime(tp, (long)laggingPartitionCaughtUpTime);
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updateFetcherLagStats(tp, (long)(partitionNum + 100));
        });
        Assertions.assertEquals((Object)new Tuple2((Object)ClusterLinkFetcherThread.AdjustmentType$.MODULE$.NoAdjustment(), (Object)None$.MODULE$), (Object)this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().adjustLaggingPartitionsRequired((long)(laggingPartitionCaughtUpTime + this.laggingTimeMs() * 2)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionNum -> {
            TopicPartition tp = new TopicPartition("topic", partitionNum);
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updatePartitionLastCaughtUpTime(tp, (long)laggingPartitionCaughtUpTime);
            this.kafka$server$link$ClusterLinkFetcherThreadTest$$fetcherThread().updateFetcherLagStats(tp, (long)(partitionNum + 100));
        });
        var3_3.maybeAdjustFetcherLaggingPartitions();
        Assertions.assertEquals((int)0, (int)var3_3.unassignedPartitionCount());
        Assertions.assertEquals((int)2, (int)var3_3.throttledPartitionCount());
        var3_3.throttledPartitions().contains((Object)new TopicPartition("topic", 2));
        var3_3.throttledPartitions().contains((Object)new TopicPartition("topic", 3));
        var3_3.addLinkedFetcherForPartitions((Iterable)var4_4);
        Assertions.assertEquals((int)0, (int)var3_3.unassignedPartitionCount());
        Assertions.assertEquals((int)0, (int)var3_3.throttledPartitionCount());
    }

    @Override
    public void verifyOffsetRequestVersion(ApiVersion ibp, OffsetsForLeaderEpochRequest.Builder offsetForLeaderEpochRequest, ListOffsetsRequest.Builder listOffsetsRequest) {
        Assertions.assertEquals((int)3, (int)offsetForLeaderEpochRequest.oldestAllowedVersion());
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)offsetForLeaderEpochRequest.latestAllowedVersion());
        Assertions.assertEquals((int)0, (int)listOffsetsRequest.oldestAllowedVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(), (short)listOffsetsRequest.latestAllowedVersion());
    }

    private static final boolean offsetsPending$1(Partition partition$1) {
        return BoxesRunTime.unboxToBoolean((Object)TestUtils.fieldValue((Object)partition$1, Partition.class, (String)"needsLinkedLeaderOffsets"));
    }

    public static final /* synthetic */ Integer $anonfun$verifySourceOffsetsPendingState$1(TopicPartition x$3) {
        return Predef$.MODULE$.int2Integer(1);
    }

    public static final /* synthetic */ Set $anonfun$setupFetcherManagerAndPartitions$1(MockTime time$1, IsrChangeListener isrChangeListener$1, LogManager logManager$1, AbstractLog log$1, ReplicaManager replicaManager$1, Set partitions$1, int partitionNum) {
        TopicPartition tp = new TopicPartition("topic", partitionNum);
        boolean bl = false;
        int zkMetadataCache_brokerId = 0;
        Partition partition = new Partition(tp, 10000L, ApiVersion$.MODULE$.latestVersion(), 0, (Time)time$1, isrChangeListener$1, (DelayedOperations)EasyMock.createNiceMock(DelayedOperations.class), (MetadataCache)new ZkMetadataCache(zkMetadataCache_brokerId, bl), logManager$1, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (AlterIsrManager)new TestUtils.MockAlterIsrManager(), (Option)None$.MODULE$, false, (Option)None$.MODULE$);
        partition.log_$eq((Option)new Some((Object)log$1));
        EasyMock.expect((Object)replicaManager$1.localLogOrException(tp)).andReturn((Object)log$1).anyTimes();
        EasyMock.expect((Object)replicaManager$1.onlinePartition(tp)).andReturn((Object)new Some((Object)partition)).anyTimes();
        TestUtils.setFieldValue((Object)partition, (String)"leaderEpoch", (Object)BoxesRunTime.boxToInteger((int)2));
        return (Set)partitions$1.$plus$eq((Object)partition);
    }

    public static final /* synthetic */ Integer $anonfun$testAdjustLaggingPartitions$1(TopicPartition x$5) {
        return Predef$.MODULE$.int2Integer(1);
    }

    public ClusterLinkFetcherThreadTest() {
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkName = "testCluster";
        this.clusterLinkBackoffMs = 100;
        this.laggingTimeMs = 1000;
        this.kafka$server$link$ClusterLinkFetcherThreadTest$$clusterLinkMetrics().startup();
    }
}

