/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.FilterJson;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005u2AAC\u0006\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0001=!)1\u0007\u0001C\u0001=!)Q\u0007\u0001C\u0001=!)q\u0007\u0001C\u0001=!)\u0011\b\u0001C\u0001=!)1\b\u0001C\u0001=\tI2\t\\;ti\u0016\u0014H*\u001b8l\r&dG/\u001a:Kg>tG+Z:u\u0015\taQ\"\u0001\u0003mS:\\'B\u0001\b\u0010\u0003\u0019\u0019XM\u001d<fe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0017\u0005aC/Z:u\u000b6\u0004H/_*ue&tw\rU1sg\u0016\u001cHk\\#naRLxI]8va\u001aKG\u000e^3sg*\u001bxN\u001c\u000b\u0002?A\u0011A\u0003I\u0005\u0003CU\u0011A!\u00168ji\"\u0012!a\t\t\u0003I5j\u0011!\n\u0006\u0003M\u001d\n1!\u00199j\u0015\tA\u0013&A\u0004kkBLG/\u001a:\u000b\u0005)Z\u0013!\u00026v]&$(\"\u0001\u0017\u0002\u0007=\u0014x-\u0003\u0002/K\t!A+Z:u\u0003\u001d\"Xm\u001d;WC2LGm\u0015;sS:<\u0007+\u0019:tKN$vn\u0012:pkB4\u0015\u000e\u001c;feNT5o\u001c8)\u0005\r\u0019\u0013\u0001\u0006;fgRtU\u000f\u001c7Kg>t\u0017I]4v[\u0016tG\u000f\u000b\u0002\u0005G\u0005)B/Z:u\u0013:4\u0018\r\\5e\r&dG/\u001a:UsB,\u0007FA\u0003$\u0003U!Xm\u001d;NSN\u001c\u0018N\\4GS2$XM\u001d+za\u0016D#AB\u0012\u0002-Q,7\u000f^'jgNLgn\u001a)biR,'O\u001c+za\u0016D#aB\u0012\u0002-Q,7\u000f^%om\u0006d\u0017\u000e\u001a)biR,'O\u001c+za\u0016D#\u0001C\u0012\u0002)Q,7\u000f^#naRL\b+\u0019;uKJtG+\u001f9fQ\tI1\u0005")
public class ClusterLinkFilterJsonTest {
    @Test
    public void testEmptyStringParsesToEmptyGroupFiltersJson() {
        Assertions.assertTrue((boolean)ClusterLinkFilterJson$.MODULE$.parse("").isEmpty());
    }

    @Test
    public void testValidStringParsesToGroupFiltersJson() {
        String groupFiltersJson = "{\n  \"groupFilters\": [ { \"name\": \"*\", \"patternType\": \"LITERAL\", \"filterType\": \"INCLUDE\" } ]}";
        Option groupJson = ClusterLinkFilterJson$.MODULE$.parse(groupFiltersJson);
        Assertions.assertTrue((boolean)groupJson.isDefined());
        ClusterLinkFilter groupFilter = (ClusterLinkFilter)((FilterJson)groupJson.get()).filters().head();
        Assertions.assertEquals((Object)"*", (Object)groupFilter.name());
        Assertions.assertEquals((Object)"LITERAL", (Object)groupFilter.patternType());
        Assertions.assertEquals((Object)"INCLUDE", (Object)groupFilter.filterType());
    }

    @Test
    public void testNullJsonArgument() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parse("{}"));
        Assertions.assertEquals((Object)"ClusterLinkFilters cannot be the JSON null", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidFilterType() {
        String groupFiltersJson = "{\n  \"groupFilters\": [ { \"name\": \"*\", \"patternType\": \"LITERAL\", \"filterType\": \"FOO\" } ]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parse(groupFiltersJson));
        Assertions.assertEquals((Object)"Unknown filterType: FOO", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingFilterType() {
        String groupFiltersJson = "{\n  \"groupFilters\": [ { \"name\": \"*\", \"patternType\": \"LITERAL\" } ]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parse(groupFiltersJson));
        Assertions.assertEquals((Object)"filterType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPatternType() {
        String groupFiltersJson = "{\n  \"groupFilters\": [ { \"name\": \"*\", \"filterType\": \"INCLUDE\" } ]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parse(groupFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidPatternType() {
        String groupFiltersJson = "{\n  \"groupFilters\": [ { \"name\": \"*\", \"patternType\": \"FOO\", \"filterType\": \"INCLUDE\" } ]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parse(groupFiltersJson));
        Assertions.assertEquals((Object)"Unknown patternType: FOO", (Object)thrown.getMessage());
    }

    @Test
    public void testEmptyPatternType() {
        String groupFiltersJson = "{\n  \"groupFilters\": [ { \"name\": \"*\", \"patternType\": \"\", \"filterType\": \"INCLUDE\" } ]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterLinkFilterJson$.MODULE$.parse(groupFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be empty.", (Object)thrown.getMessage());
    }
}

