/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkBrokerMetrics;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.LinkMode;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001\u0002\u0010 \u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u00033\u0011\u0019i\u0004\u0001)A\u0005g!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002(\u0001A\u0003%\u0001\tC\u0004P\u0001\t\u0007I\u0011\u0002)\t\rq\u0003\u0001\u0015!\u0003R\u0011\u001di\u0006A1A\u0005\nyCaA\u001a\u0001!\u0002\u0013y\u0006bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007[\u0002\u0001\u000b\u0011B5\t\u000f9\u0004!\u0019!C\u0005_\"9\u0011\u0011\u0001\u0001!\u0002\u0013\u0001\b\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011!\t9\u0002\u0001Q\u0001\n\u0005\u001d\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\t9\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0011!\t\u0019\u0004\u0001Q\u0001\n\u00055\u0002\"CA\u001b\u0001\t\u0007I\u0011BA\u001c\u0011!\ty\u0004\u0001Q\u0001\n\u0005e\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003C\u0002A\u0011AA\"\u0011\u001d\tY\u0007\u0001C\u0001\u0003\u0007Bq!a\u001c\u0001\t\u0003\t\u0019\u0005C\u0004\u0002t\u0001!I!a\u0011\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x\t12\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t)\u0016\u001cHO\u0003\u0002!C\u0005!A.\u001b8l\u0015\t\u00113%\u0001\u0004tKJ4XM\u001d\u0006\u0002I\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\f\t\u0003a\u0001i\u0011aH\u0001\u0007i\u0016t\u0017M\u001c;\u0016\u0003M\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\t1\fgn\u001a\u0006\u0002q\u0005!!.\u0019<b\u0013\tQTG\u0001\u0004TiJLgnZ\u0001\bi\u0016t\u0017M\u001c;!\u00031!XM\\1oiB\u0013XMZ5y\u00035!XM\\1oiB\u0013XMZ5yA\u0005AA.\u001b8l\t\u0006$\u0018-F\u0001A!\r\te\tS\u0007\u0002\u0005*\u00111\tR\u0001\nS6lW\u000f^1cY\u0016T!!R\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002H\u0005\n\u00191+Z9\u0011\u0005%cU\"\u0001&\u000b\u0005-\u001b\u0013A\u0001>l\u0013\ti%JA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0003%a\u0017N\\6ECR\f\u0007%A\u0007t_V\u00148-\u001a+pa&\u001c\u0017\nZ\u000b\u0002#B\u0011!KW\u0007\u0002'*\u0011A+V\u0001\u0007G>lWn\u001c8\u000b\u0005\u00112&BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001eL!aW*\u0003\tU+\u0018\u000eZ\u0001\u000fg>,(oY3U_BL7-\u00133!\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0002?B\u0019\u0011I\u00121\u0011\t!\n7mY\u0005\u0003E&\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u0015e\u0013\t)\u0017FA\u0002J]R\f1\u0002]1si&$\u0018n\u001c8tA\u00051\u0001/Y;tK\u0012,\u0012!\u001b\t\u0004\u0003\u001aS\u0007C\u0001\u0015l\u0013\ta\u0017FA\u0004C_>dW-\u00198\u0002\u000fA\fWo]3eA\u0005IA.\u001b8l\u001b>$Wm]\u000b\u0002aB\u0019\u0011IR9\u0013\tI$xO\u001f\u0004\u0005g\u0002\u0001\u0011O\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002)k&\u0011a/\u000b\u0002\b!J|G-^2u!\t\u0001\u00040\u0003\u0002z?\tAA*\u001b8l\u001b>$W\r\u0005\u0002|}6\tAP\u0003\u0002~o\u0005\u0011\u0011n\\\u0005\u0003\u007fr\u0014AbU3sS\u0006d\u0017N_1cY\u0016\f!\u0002\\5oW6{G-Z:!\u0003\u0019!x\u000e]5dgV\u0011\u0011q\u0001\t\u0007\u0003\u0006%1'!\u0004\n\u0007\u0005-!IA\u0002NCB\u0014b!a\u0004u\u0003#Qh!B:\u0001\u0001\u00055\u0001c\u0001\u0019\u0002\u0014%\u0019\u0011QC\u0010\u0003+\rcWo\u001d;fe2Kgn\u001b+pa&\u001c7\u000b^1uK\u00069Ao\u001c9jGN\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003;\u0001B!a\b\u0002$5\u0011\u0011\u0011\u0005\u0006\u0004\u00033\u0019\u0016\u0002BA\u0013\u0003C\u0011q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u001di\u0017M\\1hKJ,\"!!\f\u0011\u0007A\ny#C\u0002\u00022}\u0011!c\u00117vgR,'\u000fT5oW6\u000bg.Y4fe\u0006AQ.\u00198bO\u0016\u0014\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\t\tI\u0004E\u00021\u0003wI1!!\u0010 \u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003AiW\r^1eCR\fW*\u00198bO\u0016\u0014\b%\u0001\u0005uK\u0006\u0014Hi\\<o)\t\t)\u0005E\u0002)\u0003\u000fJ1!!\u0013*\u0005\u0011)f.\u001b;)\u0007a\ti\u0005\u0005\u0003\u0002P\u0005uSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002X\u0005e\u0013a\u00026va&$XM\u001d\u0006\u0004\u00037B\u0016!\u00026v]&$\u0018\u0002BA0\u0003#\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0017Q,7\u000f^'fiJL7m\u001d\u0015\u00043\u0005\u0015\u0004\u0003BA(\u0003OJA!!\u001b\u0002R\t!A+Z:u\u0003Y!Xm\u001d;QCV\u001cX\r\u001a+pa&\u001cW*\u001a;sS\u000e\u001c\bf\u0001\u000e\u0002f\u0005\tC/Z:u\u0007>tGO]8mY\u0016\u0014X*\u001a;sS\u000e\u001c\u0018j]\"p]R\u0014x\u000e\u001c7fe\"\u001a1$!\u001a\u0002\u0013M,G/\u001e9N_\u000e\\\u0017AE1tg\u0016\u0014H/T3ue&\u001cW)];bYN$b!!\u0012\u0002z\u0005\r\u0005bBA>;\u0001\u0007\u0011QP\u0001\u0005]\u0006lW\rE\u0002S\u0003\u007fJ1!!!T\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\b\u0003\u000bk\u0002\u0019AAD\u00035)\u0007\u0010]3di\u0016$g+\u00197vKB\u0019\u0001&!#\n\u0007\u0005-\u0015F\u0001\u0004E_V\u0014G.\u001a")
public class ClusterLinkMetricsTest {
    private final String tenant;
    private final String tenantPrefix = new StringBuilder(1).append(this.tenant()).append("_").toString();
    private final Seq<ClusterLinkData> linkData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkData[]{new ClusterLinkData(new StringBuilder(11).append(this.tenantPrefix()).append("test-link-1").toString(), UUID.randomUUID(), (Option)None$.MODULE$, (Option)new Some((Object)this.tenantPrefix()), false), new ClusterLinkData("test-link-2", UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)}));
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final Seq<Tuple2<Object, Object>> partitions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(4, 1), new Tuple2.mcII.sp(6, 2)}));
    private final Seq<Object> paused = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true}));
    private final Seq<Product> linkModes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{LinkMode.Destination$.MODULE$, LinkMode.Source$.MODULE$}));
    private final Map<String, Product> topics;
    private final Metrics metrics;
    private final ClusterLinkManager manager;
    private final ClusterLinkMetadataManager metadataManager;

    private String tenant() {
        return this.tenant;
    }

    private String tenantPrefix() {
        return this.tenantPrefix;
    }

    private Seq<ClusterLinkData> linkData() {
        return this.linkData;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private Seq<Tuple2<Object, Object>> partitions() {
        return this.partitions;
    }

    private Seq<Object> paused() {
        return this.paused;
    }

    private Seq<Product> linkModes() {
        return this.linkModes;
    }

    private Map<String, Product> topics() {
        return this.topics;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClusterLinkManager manager() {
        return this.manager;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testMetrics() {
        this.setupMock();
        ClusterLinkBrokerMetrics brokerMetrics = new ClusterLinkBrokerMetrics(this.metrics());
        brokerMetrics.startup();
        Seq brokerSensors = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Sensor[]{brokerMetrics.linkedTopicPartitionAdditionSensor(), brokerMetrics.linkedLeaderEpochChangeSensor(), brokerMetrics.aclsAddedSensor(), brokerMetrics.aclsAddFailedSensor(), brokerMetrics.aclsDeletedSensor(), brokerMetrics.aclsDeleteFailedSensor(), brokerMetrics.consumerOffsetCommitSensor(), brokerMetrics.consumerOffsetCommitFailedSensor(), brokerMetrics.topicConfigUpdateSensor(), brokerMetrics.topicConfigUpdateFailedSensor(), brokerMetrics.sourceReverseConnectionCreatedSensor(), brokerMetrics.destReverseConnectionCreatedSensor(), brokerMetrics.sourceReverseConnectionClosedSensor(), brokerMetrics.destReverseConnectionClosedSensor(), brokerMetrics.sourceReverseConnectionFailedSensor()}));
        brokerSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$1(this, s);
            return BoxedUnit.UNIT;
        });
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (LinkMode)LinkMode.Source$.MODULE$, this.manager(), (Option)new Some((Object)brokerMetrics), this.metrics(), (Option)new Some((Object)this.tenant()));
        linkMetrics.startup();
        Seq sensors = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Sensor[]{linkMetrics.activeLinkCountSensor(), linkMetrics.throttleTimeSensor(), linkMetrics.linkedTopicPartitionAdditionSensor(), linkMetrics.linkedLeaderEpochChangeSensor(), linkMetrics.aclsAddedSensor(), linkMetrics.aclsAddFailedSensor(), linkMetrics.aclsDeletedSensor(), linkMetrics.aclsDeleteFailedSensor(), linkMetrics.consumerOffsetCommitSensor(), linkMetrics.consumerOffsetCommitFailedSensor(), linkMetrics.topicConfigUpdateSensor(), linkMetrics.topicConfigUpdateFailedSensor(), linkMetrics.linkSourceUnavailableSensor(), linkMetrics.reverseConnectionCreatedSensor(), linkMetrics.reverseConnectionClosedSensor(), linkMetrics.sourceReverseConnectionFailedSensor()}));
        sensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$2(this, s);
            return BoxedUnit.UNIT;
        });
        this.assertMetricEquals(linkMetrics.mirrorPartitionCountMetricName(), 4.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
        sensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$4(this, s);
            return BoxedUnit.UNIT;
        });
        brokerSensors.foreach((Function1 & Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$5(this, s);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPausedTopicMetrics() {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().apply(1)).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().apply(1)).linkId(), (LinkMode)this.linkModes().apply(1), this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$);
        linkMetrics.startup();
        this.assertMetricEquals((MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        this.assertMetricEquals(linkMetrics.mirrorPartitionCountMetricName(), 6.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testPausedTopicMetrics$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
    }

    @Test
    public void testControllerMetricsIsController() {
        this.setupMock();
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (LinkMode)this.linkModes().head(), this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$);
        linkMetrics.startup();
        this.assertMetricEquals((MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        linkMetrics.shutdown();
    }

    private void setupMock() {
        EasyMock.reset((Object[])new Object[]{this.manager()});
        EasyMock.reset((Object[])new Object[]{this.metadataManager()});
        EasyMock.expect((Object)this.manager().listClusterLinks()).andReturn(this.linkData()).anyTimes();
        ((IterableOps)this.partitions().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Tuple2 data = (Tuple2)x0$1._1();
            int index = x0$1._2$mcI$sp();
            ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)EasyMock.mock(ClusterLinkFetcherManager.class);
            EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fetcherManager.mirrorPartitionCount())).andReturn((Object)BoxesRunTime.boxToInteger((int)data._1$mcI$sp())).anyTimes();
            EasyMock.replay((Object[])new Object[]{fetcherManager});
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.manager().fetcherManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).andReturn((Object)new Some((Object)fetcherManager)).anyTimes();
            return iExpectationSetters;
        });
        ((IterableOnceOps)this.paused().zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            boolean paused = x0$2._1$mcZ$sp();
            int index = x0$2._2$mcI$sp();
            ClusterLinkConfig config = (ClusterLinkConfig)EasyMock.mock(ClusterLinkConfig.class);
            EasyMock.expect((Object)config.clusterLinkPaused()).andReturn((Object)Predef$.MODULE$.boolean2Boolean(paused)).anyTimes();
            EasyMock.replay((Object[])new Object[]{config});
            ClusterLinkClientManager clientManager = (ClusterLinkClientManager)EasyMock.mock(ClusterLinkClientManager.class);
            EasyMock.expect((Object)clientManager.currentConfig()).andReturn((Object)config).anyTimes();
            EasyMock.replay((Object[])new Object[]{clientManager});
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.manager().clientManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).andReturn((Object)new Some((Object)clientManager)).anyTimes();
            return iExpectationSetters;
        });
        EasyMock.expect((Object)this.manager().metadataManager()).andReturn((Object)this.metadataManager()).anyTimes();
        this.linkData().foreach((Function1 & Serializable)data -> {
            EasyMock.expect((Object)this.manager().resolveLinkId(data.linkName())).andReturn((Object)new Some((Object)data.linkId())).anyTimes();
            return EasyMock.expect((Object)this.manager().linkState(data.linkName())).andReturn((Object)ActiveClusterLink$.MODULE$).anyTimes();
        });
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.eq((boolean)false)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.metadataManager().mirrorTopicsForLink(((ClusterLinkData)this.linkData().head()).linkName())).andReturn(this.topics().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$4(this, t)))).anyTimes();
        EasyMock.expect((Object)this.metadataManager().mirrorTopicsForLink(((ClusterLinkData)this.linkData().apply(1)).linkName())).andReturn(this.topics().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetricsTest.$anonfun$setupMock$5(this, t)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.manager()});
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
    }

    private void assertMetricEquals(MetricName name, double expectedValue) {
        Option option = CollectionConverters$.MODULE$.MapHasAsScala(this.metrics().metrics()).asScala().get((Object)name);
        if (option instanceof Some) {
            KafkaMetric metric = (KafkaMetric)((Some)option).value();
            Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)expectedValue), (Object)metric.metricValue());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Metric ").append(name).append(" not found").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$1(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$2(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$3(ClusterLinkMetricsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean bl;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                bl = true;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    bl = false;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        bl = false;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            bl = true;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                bl = true;
                            } else {
                                throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                            }
                        }
                    }
                }
            }
            $this.assertMetricEquals(name, (double)bl);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$4(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNull((Object)$this.metrics().getSensor(s.name()), (String)new StringBuilder(32).append("Sensor ").append(s.name()).append(" should not be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$5(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(34).append("Sensor ").append(s.name()).append(" should still be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testPausedTopicMetrics$1(ClusterLinkMetricsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int n;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                n = 2;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    n = 2;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        n = 0;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            n = 0;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                n = 0;
                            } else {
                                throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                            }
                        }
                    }
                }
            }
            $this.assertMetricEquals(name, n);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$4(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().head()).linkName());
    }

    public static final /* synthetic */ boolean $anonfun$setupMock$5(ClusterLinkMetricsTest $this, Tuple2 t) {
        return ((ClusterLinkTopicState)t._2()).linkName().equals(((ClusterLinkData)$this.linkData().apply(1)).linkName());
    }

    public ClusterLinkMetricsTest() {
        this.tenant = "test-tenant";
        Object[] objectArray = new Tuple2[5];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds()));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new ClusterLinkTopicState.StoppedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.List().empty(), Time.SYSTEM.milliseconds()));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds()));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds()));
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds()));
        this.topics = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.metrics = new Metrics();
        this.manager = (ClusterLinkManager)EasyMock.mock(ClusterLinkManager.class);
        this.metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManager.class);
    }
}

