/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkPauseMirrorTopics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u0017.\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004J\u0001\u0001\u0006I!\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019\u0011\u0006\u0001)A\u0005\u0019\"91\u000b\u0001b\u0001\n\u0013!\u0006B\u00021\u0001A\u0003%Q\u000bC\u0004b\u0001\t\u0007I\u0011\u0002!\t\r\t\u0004\u0001\u0015!\u0003B\u0011\u001d\u0019\u0007A1A\u0005\n-Ca\u0001\u001a\u0001!\u0002\u0013a\u0005bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007U\u0002\u0001\u000b\u0011B4\t\u000f-\u0004!\u0019!C\u0005Y\"1A\u000f\u0001Q\u0001\n5Dq!\u001e\u0001C\u0002\u0013%a\u000f\u0003\u0004{\u0001\u0001\u0006Ia\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\t\t\u0001\u0001Q\u0001\nuDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002$\u0001!\t!!\u0002\t\u000f\u00055\u0002\u0001\"\u0001\u0002\u0006!9\u0011q\u0007\u0001\u0005\u0002\u0005\u0015\u0001bBA\u001e\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u007f\u0001A\u0011AA\u0003\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bAq!a\u0012\u0001\t\u0003\t)\u0001C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\u0006!9\u00111\f\u0001\u0005\n\u0005\u0015\u0001bBA/\u0001\u0011%\u0011q\f\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002\n\u0002!I!a#\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\"9\u0011Q\u0013\u0001\u0005\n\u0005]\u0005bBAN\u0001\u0011%\u0011Q\u0014\u0005\b\u0003_\u0003A\u0011BAY\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!a2\u0001\t\u0013\tI\rC\u0004\u0002h\u0002!I!!;\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006\t\u00013\t\\;ti\u0016\u0014H*\u001b8l!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001cH+Z:u\u0015\tqs&\u0001\u0003mS:\\'B\u0001\u00192\u0003\u0019\u0019XM\u001d<fe*\t!'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002{A\u0011a\bA\u0007\u0002[\u0005AA.\u001b8l\u001d\u0006lW-F\u0001B!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mC:<'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013aa\u0015;sS:<\u0017!\u00037j].t\u0015-\\3!\u0003\u0019a\u0017N\\6JIV\tA\n\u0005\u0002N!6\taJ\u0003\u0002P\u000b\u0006!Q\u000f^5m\u0013\t\tfJ\u0001\u0003V+&#\u0015a\u00027j].LE\rI\u0001\u000eg>,(oY3U_BL7-\u00133\u0016\u0003U\u0003\"A\u00160\u000e\u0003]S!\u0001W-\u0002\r\r|W.\\8o\u0015\t\u0011$L\u0003\u0002\\9\u00061\u0011\r]1dQ\u0016T\u0011!X\u0001\u0004_J<\u0017BA0X\u0005\u0011)V/\u001b3\u0002\u001dM|WO]2f)>\u0004\u0018nY%eA\u0005iq\u000e\u001e5fe2Kgn\u001b(b[\u0016\fab\u001c;iKJd\u0015N\\6OC6,\u0007%A\u0006pi\",'\u000fT5oW&#\u0017\u0001D8uQ\u0016\u0014H*\u001b8l\u0013\u0012\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u00059\u0007C\u0001 i\u0013\tIWF\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013!B1e[&tW#A7\u0011\u00059\u0014X\"A8\u000b\u0005-\u0004(BA9Z\u0003\u001d\u0019G.[3oiNL!a]8\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u00061\u0011\rZ7j]\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0002oB\u0011a\b_\u0005\u0003s6\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002+5\f\u0007\u0010V8qS\u000e\u001c\b+\u001a:Ji\u0016\u0014\u0018\r^5p]V\tQ\u0010\u0005\u00027}&\u0011qp\u000e\u0002\u0004\u0013:$\u0018AF7bqR{\u0007/[2t!\u0016\u0014\u0018\n^3sCRLwN\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005\u001d\u0001c\u0001\u001c\u0002\n%\u0019\u00111B\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0004)\u0005=\u0001\u0003BA\t\u0003?i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0004CBL'\u0002BA\r\u00037\tqA[;qSR,'OC\u0002\u0002\u001eq\u000bQA[;oSRLA!!\t\u0002\u0014\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!FA\u0014!\u0011\t\t\"!\u000b\n\t\u0005-\u00121\u0003\u0002\n\u0003\u001a$XM]#bG\"\f!\u0004^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7/R7qifD3AFA\u0019!\u0011\t\t\"a\r\n\t\u0005U\u00121\u0003\u0002\u0005)\u0016\u001cH/\u0001\u000euKN$\b+Y;tK6K'O]8s)>\u0004\u0018nY:QCV\u001cX\rK\u0002\u0018\u0003c\tA\u0004^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7/\u00168qCV\u001cX\rK\u0002\u0019\u0003c\t!\u0005^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7OT8u\u0007>tGO]8mY\u0016\u0014\bfA\r\u00022\u0005\u0019C/Z:u!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c\b+Y;tK\u0016C8-\u001a9uS>t\u0007f\u0001\u000e\u00022\u0005aB/Z:u!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c\u0018IY8si\u0016$\u0007fA\u000e\u00022\u0005I1/\u001a;va6{7m\u001b\u000b\u0005\u0003\u000f\ty\u0005C\u0004\u0002Rq\u0001\r!a\u0015\u0002\u0011%\u001cH*Z1eKJ\u00042ANA+\u0013\r\t9f\u000e\u0002\b\u0005>|G.Z1o\u0003)\u0011X\r\u001d7bs6{7m[\u0001\u000bm\u0016\u0014\u0018NZ=N_\u000e\\\u0017A\u0003;p\u0019&t7NT1nKR\u0019\u0011)!\u0019\t\u000f\u0005\rt\u00041\u0001\u0002T\u00059\u0011n](uQ\u0016\u0014\u0018\u0001\u0003;p\u0019&t7.\u00133\u0015\u00071\u000bI\u0007C\u0004\u0002d\u0001\u0002\r!a\u0015\u0002\u0017\u0005\u001cG/\u001b<f'R\fG/\u001a\u000b\u0005\u0003_\n)\bE\u0002?\u0003cJ1!a\u001d.\u0005U\u0019E.^:uKJd\u0015N\\6U_BL7m\u0015;bi\u0016Dq!a\u0019\"\u0001\u0004\t\u0019&A\u0006qCV\u001cX\rZ*uCR,GCCA8\u0003w\ni(!!\u0002\u0006\"9\u00111\r\u0012A\u0002\u0005M\u0003bBA@E\u0001\u0007\u00111K\u0001\nY&t7\u000eT3wK2Dq!a!#\u0001\u0004\t\u0019&\u0001\u0006u_BL7\rT3wK2Dq!a\"#\u0001\u0004\t\u0019&A\u0005xCN4\u0015-\u001b7fI\u0006Ya-Y5mK\u0012\u001cF/\u0019;f)\u0011\ty'!$\t\u000f\u0005\r4\u00051\u0001\u0002T\u0005\u0019\u0002/\u001a8eS:<7\u000b^8qa\u0016$7\u000b^1uKR!\u0011qNAJ\u0011\u001d\t\u0019\u0007\na\u0001\u0003'\nAb\u001d;paB,Gm\u0015;bi\u0016$B!a\u001c\u0002\u001a\"9\u00111M\u0013A\u0002\u0005M\u0013\u0001\u00068foB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7\u000f\u0006\u0003\u0002 \u0006\u0015\u0006c\u0001 \u0002\"&\u0019\u00111U\u0017\u00039\rcWo\u001d;fe2Kgn\u001b)bkN,W*\u001b:s_J$v\u000e]5dg\"9\u0011q\u0015\u0014A\u0002\u0005%\u0016\u0001\u00047j].L5\u000fU1vg\u0016$\u0007#\u0002\u001c\u0002,\u0006M\u0013bAAWo\tIa)\u001e8di&|g\u000eM\u0001\beVtwJ\\2f)\u0011\t9!a-\t\u000f\u0005Uv\u00051\u0001\u0002 \u0006!A/Y:l\u0003UqWm\u001e)bkN,7+^2dKN\u001ch)\u001e;ve\u0016$\"!a/\u0011\u000bY\u000bi,!1\n\u0007\u0005}vKA\u0006LC\u001a\\\u0017MR;ukJ,\u0007c\u0001\"\u0002D&\u0019\u0011QY\"\u0003\tY{\u0017\u000eZ\u0001\u0016]\u0016<\b+Y;tK\u001a\u000b\u0017\u000e\\;sK\u001a+H/\u001e:f)\u0011\tY,a3\t\u000f\u00055\u0017\u00061\u0001\u0002P\u0006\u0011Q\r\u001f\t\u0005\u0003#\f\tO\u0004\u0003\u0002T\u0006ug\u0002BAk\u00037l!!a6\u000b\u0007\u0005e7'\u0001\u0004=e>|GOP\u0005\u0002q%\u0019\u0011q\\\u001c\u0002\u000fA\f7m[1hK&!\u00111]As\u0005%!\u0006N]8xC\ndWMC\u0002\u0002`^\n!#\u001a=qK\u000e$H*\u001b8lK\u0012$v\u000e]5dgR!\u0011qAAv\u0011\u001d\tiO\u000ba\u0001\u0003_\fA\u0002\\5oW\u0016$Gk\u001c9jGN\u0004\u0002\"!=\u0002z\u0006}\u0018q\u000e\b\u0005\u0003g\f)\u0010E\u0002\u0002V^J1!a>8\u0003\u0019\u0001&/\u001a3fM&!\u00111`A\u007f\u0005\ri\u0015\r\u001d\u0006\u0004\u0003o<\u0004\u0003BAy\u0005\u0003I1\u0001SA\u007f\u0003I)\u0007\u0010]3diB\u000bWo]3NSJ\u0014xN]:\u0015\r\u0005\u001d!q\u0001B\n\u0011\u001d\u0011Ia\u000ba\u0001\u0005\u0017\taA^1mk\u0016\u001c\b\u0003CAy\u0003s\fyP!\u0004\u0011\u000bY\u0012y!a4\n\u0007\tEqG\u0001\u0004PaRLwN\u001c\u0005\b\u0005+Y\u0003\u0019AA*\u0003\u0019)g.\u00192mK\u0002")
public class ClusterLinkPauseMirrorTopicsTest {
    private final String linkName;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final String otherLinkName;
    private final UUID otherLinkId = UUID.randomUUID();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)EasyMock.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)EasyMock.mock(ClusterLinkMetadataManager.class);
    private final int maxTopicsPerIteration;

    private String linkName() {
        return this.linkName;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private String otherLinkName() {
        return this.otherLinkName;
    }

    private UUID otherLinkId() {
        return this.otherLinkId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private int maxTopicsPerIteration() {
        return this.maxTopicsPerIteration;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testPauseMirrorTopicsEmpty() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.replayMock();
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)isPaused -> {
            ClusterLinkPauseMirrorTopicsTest.$anonfun$testPauseMirrorTopicsEmpty$1(this, BoxesRunTime.unboxToBoolean((Object)isPaused));
            return BoxedUnit.UNIT;
        });
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsPause() {
        scala.collection.immutable.Map linkedTopics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)this.pausedState(false, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)this.pausedState(false, true, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)this.pausedState(false, false, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)this.pausedState(false, true, false, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)this.pausedState(false, true, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)this.failedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pending-stopped"), (Object)this.pendingStoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stopped"), (Object)this.stoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-active"), (Object)this.activeState(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-topic"), (Object)this.pausedState(true, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-link"), (Object)this.pausedState(true, true, false, false))}));
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)linkedTopics);
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)None$.MODULE$)}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.replayMock();
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> true;
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsUnpause() {
        scala.collection.immutable.Map linkedTopics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)this.pausedState(false, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)this.pausedState(false, true, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)this.pausedState(false, false, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)this.pausedState(false, true, false, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)this.pausedState(false, true, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)this.failedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pending-stopped"), (Object)this.pendingStoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stopped"), (Object)this.stoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-active"), (Object)this.activeState(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-topic"), (Object)this.pausedState(true, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-link"), (Object)this.pausedState(true, true, false, false))}));
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)linkedTopics);
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)None$.MODULE$)}))), false);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.replayMock();
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> false;
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsNotController() {
        this.setupMock(false);
        this.replayMock();
        Function0 & Serializable newPauseMirrorTopics_linkIsPaused = (Function0 & Serializable)() -> {
            throw new RuntimeException("unexpected");
        };
        Object var1_1 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsPauseException() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)None$.MODULE$)}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.pausedState(false, true, false, false))}))));
        this.replayMock();
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> true;
        Object var1_1 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsAborted() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.replayMock();
        IntRef check = IntRef.create((int)0);
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> {
            ++check$1.elem;
            return check$1.elem < 3;
        };
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    private void setupMock(boolean isLeader) {
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.reset((Object[])new Object[]{this.metadataManager()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)isLeader)).anyTimes();
    }

    private void replayMock() {
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
    }

    private void verifyMock() {
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
    }

    private String toLinkName(boolean isOther) {
        if (isOther) {
            return this.otherLinkName();
        }
        return this.linkName();
    }

    private UUID toLinkId(boolean isOther) {
        if (isOther) {
            return this.otherLinkId();
        }
        return this.linkId();
    }

    private ClusterLinkTopicState activeState(boolean isOther) {
        return new ClusterLinkTopicState.Mirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), 111111111L);
    }

    private ClusterLinkTopicState pausedState(boolean isOther, boolean linkLevel, boolean topicLevel, boolean wasFailed) {
        return new ClusterLinkTopicState.PausedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), linkLevel, topicLevel, wasFailed, 22222222L);
    }

    private ClusterLinkTopicState failedState(boolean isOther) {
        return new ClusterLinkTopicState.FailedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), 33333333L);
    }

    private ClusterLinkTopicState pendingStoppedState(boolean isOther) {
        return new ClusterLinkTopicState.PendingStoppedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), false, 44444444L);
    }

    private ClusterLinkTopicState stoppedState(boolean isOther) {
        return new ClusterLinkTopicState.StoppedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), 555555555L);
    }

    private ClusterLinkPauseMirrorTopics newPauseMirrorTopics(Function0<Object> linkIsPaused) {
        return new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10);
    }

    private void runOnce(ClusterLinkPauseMirrorTopics task) {
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)task.runOnce().get(5L, TimeUnit.SECONDS)));
    }

    private KafkaFuture<Void> newPauseSuccessFuture() {
        return KafkaFuture.completedFuture(null);
    }

    /*
     * WARNING - void declaration
     */
    private KafkaFuture<Void> newPauseFailureFuture(Throwable ex) {
        void var2_2;
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(ex);
        return var2_2;
    }

    private void expectLinkedTopics(scala.collection.immutable.Map<String, ClusterLinkTopicState> linkedTopics) {
        TrieMap map = new TrieMap();
        map.$plus$plus$eq(linkedTopics);
        EasyMock.expect((Object)this.metadataManager().mirrorTopicsForLink(EasyMock.anyString())).andReturn((Object)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private void expectPauseMirrors(scala.collection.immutable.Map<String, Option<Throwable>> values, boolean enable) {
        AlterMirrorOp pauseOp = enable ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK;
        scala.collection.immutable.Map ops = ((IterableOnceOps)values.keys().map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)pauseOp))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map results = (scala.collection.immutable.Map)values.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String t = (String)x0$1._1();
                Option option = (Option)x0$1._2();
                if (option instanceof Some) {
                    Throwable ex = (Throwable)((Some)option).value();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), this.newPauseFailureFuture(ex));
                }
            }
            if (x0$1 == null) throw new MatchError(x0$1);
            String t = (String)x0$1._1();
            Option option = (Option)x0$1._2();
            if (!None$.MODULE$.equals(option)) throw new MatchError(x0$1);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)KafkaFuture.completedFuture(null));
        });
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testPauseMirrorTopicsEmpty$1(ClusterLinkPauseMirrorTopicsTest $this, boolean isPaused) {
        ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics;
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> isPaused;
        ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics2 = clusterLinkPauseMirrorTopics = new ClusterLinkPauseMirrorTopics($this.linkId(), $this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, $this.scheduler(), $this.metadataManager(), (Function0 & Serializable)() -> this.admin(), $this.maxTopicsPerIteration(), 10, 10);
        Object var3_2 = null;
        clusterLinkPauseMirrorTopics = null;
        ClusterLinkPauseMirrorTopics pauseMirrorTopics = clusterLinkPauseMirrorTopics2;
        $this.runOnce(pauseMirrorTopics);
    }

    public ClusterLinkPauseMirrorTopicsTest() {
        this.linkName = "link-name";
        this.otherLinkName = "other-link-name";
        this.maxTopicsPerIteration = 5;
    }
}

