/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.LinkMode;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011Ec\u0001B/_\u0001\u0015DQ\u0001\u001c\u0001\u0005\u00025Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0011\u001d\tI\u0001\u0001Q\u0001\naD\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037A\u0011\"a\t\u0001\u0005\u0004%I!!\n\t\u0011\t\r\u0007\u0001)A\u0005\u0003OA\u0011B!2\u0001\u0005\u0004%IAa2\t\u0011\t=\u0007\u0001)A\u0005\u0005\u0013D\u0011B!5\u0001\u0005\u0004%IAa5\t\u0011\tm\u0007\u0001)A\u0005\u0005+D\u0011B!8\u0001\u0005\u0004%IAa8\t\u0011\t\u001d\b\u0001)A\u0005\u0005CD\u0011B!;\u0001\u0005\u0004%IAa;\t\u0011\t5\b\u0001)A\u0005\u0005\u001bC\u0011Ba<\u0001\u0005\u0004%IA!=\t\u0011\t}\b\u0001)A\u0005\u0005gD\u0011b!\u0001\u0001\u0005\u0004%\taa\u0001\t\u0011\r\u0015\u0001\u0001)A\u0005\u0003kC\u0011ba\u0002\u0001\u0005\u0004%\taa\u0001\t\u0011\r%\u0001\u0001)A\u0005\u0003kC\u0011ba\u0003\u0001\u0005\u0004%\taa\u0001\t\u0011\r5\u0001\u0001)A\u0005\u0003kC\u0011ba\u0004\u0001\u0005\u0004%\taa\u0001\t\u0011\rE\u0001\u0001)A\u0005\u0003kCqaa\u0005\u0001\t\u0003\u0011\t\u0006C\u0004\u0004,\u0001!\tA!\u0015\t\u000f\rU\u0002\u0001\"\u0003\u0003R!91q\u0007\u0001\u0005\u0002\tE\u0003bBB!\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0007\u000b\u0002A\u0011\u0001B)\u0011\u001d\u0019I\u0005\u0001C\u0001\u0005#Bqa!\u0014\u0001\t\u0003\u0011\t\u0006C\u0004\u0004R\u0001!\tA!\u0015\t\u000f\rU\u0003\u0001\"\u0001\u0003R!91\u0011\f\u0001\u0005\u0002\tE\u0003bBB/\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0007C\u0002A\u0011\u0001B)\u0011\u001d\u0019)\u0007\u0001C\u0001\u0005#Bqa!\u001b\u0001\t\u0013\u0019Y\u0007C\u0004\u0004t\u0001!\tA!\u0015\t\u000f\r]\u0004\u0001\"\u0001\u0003R!911\u0010\u0001\u0005\u0002\tE\u0003bBB@\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0007\u0007\u0003A\u0011\u0001B)\u0011\u001d\u00199\t\u0001C\u0001\u0005#Bqaa#\u0001\t\u0003\u0011\t\u0006C\u0004\u0004\u0010\u0002!\tA!\u0015\t\u000f\rM\u0005\u0001\"\u0001\u0003R!91q\u0013\u0001\u0005\u0002\tE\u0003b\u0002B7\u0001\u0011%11\u0014\u0005\b\u0007/\u0004A\u0011BBm\u0011\u001d\u0019i\u000e\u0001C\u0005\u0007?Dqaa9\u0001\t\u0013\u0019)\u000fC\u0004\u0004p\u0002!Ia!=\t\u000f\rU\b\u0001\"\u0003\u0004x\"91q\u001e\u0001\u0005\n\rm\bb\u0002C\u0001\u0001\u0011%A1\u0001\u0005\b\t\u0013\u0001A\u0011\u0002C\u0006\u0011\u001d!y\u0001\u0001C\u0005\t#Aq\u0001b\u0006\u0001\t\u0013!I\u0002C\u0004\u0005\u001e\u0001!I\u0001b\b\t\u000f\u00115\u0002\u0001\"\u0003\u0003R!9Aq\u0006\u0001\u0005\n\u0011E\u0002b\u0002C\u001a\u0001\u0011%AQ\u0007\u0005\b\t\u0003\u0002A\u0011\u0002C\"\u0011\u001d!I\u0005\u0001C\u0005\t\u00172a!a\u000b\u0001\t\u00055\u0002B\u00027I\t\u0003\ti\u0004C\u0005\u0002@!\u0013\r\u0011\"\u0001\u0002B!A\u00111\r%!\u0002\u0013\t\u0019\u0005C\u0005\u0002f!\u0013\r\u0011\"\u0001\u0002h!A\u0011q\u0013%!\u0002\u0013\tI\u0007C\u0005\u0002\u001a\"\u0013\r\u0011\"\u0001\u0002\u001c\"A\u0011\u0011\u0016%!\u0002\u0013\ti\nC\u0005\u0002,\"\u0013\r\u0011\"\u0001\u0002.\"A\u00111\u001a%!\u0002\u0013\ty\u000bC\u0004\u0002N\"#\t%a4\t\u000f\t5\u0001\n\"\u0011\u0003\u0010!9!q\u0006%\u0005B\tE\u0002b\u0002B(\u0011\u0012\u0005#\u0011\u000b\u0005\b\u0005'BE\u0011\tB+\u0011\u001d\u00119\u0007\u0013C\u0001\u0005SBqAa\u001cI\t\u0003\u0011\t\bC\u0004\u0003v!#\tEa\u001e\t\u000f\t=\u0005\n\"\u0011\u0003\u0012\"9!\u0011\u0016%\u0005\u0002\t-\u0006b\u0002B^\u0011\u0012\u0005!Q\u0018\u0002\u0018\u00072,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn\u001d+fgRT!a\u00181\u0002\t1Lgn\u001b\u0006\u0003C\n\faa]3sm\u0016\u0014(\"A2\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0002S\u0006)1oY1mC&\u00111\u000e\u001b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0007CA8\u0001\u001b\u0005q\u0016!C:dQ\u0016$W\u000f\\3s+\u0005\u0011\bCA8t\u0013\t!hL\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013!B1e[&tW#\u0001=\u0011\u0007e\f)!D\u0001{\u0015\t18P\u0003\u0002}{\u000691\r\\5f]R\u001c(BA2\u007f\u0015\ry\u0018\u0011A\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0011aA8sO&\u0019\u0011q\u0001>\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u00061\u0011\rZ7j]\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0003\u001f\u00012a\\A\t\u0013\r\t\u0019B\u0018\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\nQb\u00197jK:$X*\u00198bO\u0016\u0014XCAA\u000e!\ry\u0017QD\u0005\u0004\u0003?q&\u0001G\"mkN$XM\u001d'j].\u001cE.[3oi6\u000bg.Y4fe\u0006q1\r\\5f]Rl\u0015M\\1hKJ\u0004\u0013AC1vi\"|'/\u001b>feV\u0011\u0011q\u0005\t\u0004\u0003SAU\"\u0001\u0001\u0003\u001dQ+7\u000f^!vi\"|'/\u001b>feN\u0019\u0001*a\f\u0011\t\u0005E\u0012\u0011H\u0007\u0003\u0003gQA!a\t\u00026)\u0019\u0011q\u00072\u0002\u0011M,7-\u001e:jifLA!a\u000f\u00024\ti\u0011i\u00197BkRDwN]5{KJ$\"!a\n\u0002\u0017\r,(O]3oi\u0006\u001bGn]\u000b\u0003\u0003\u0007\u0002b!!\u0012\u0002P\u0005MSBAA$\u0015\u0011\tI%a\u0013\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\n5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0005\u001d#aA*fiB!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013aA1dY*\u0019\u0011QL?\u0002\r\r|W.\\8o\u0013\u0011\t\t'a\u0016\u0003\u0015\u0005\u001bGNQ5oI&tw-\u0001\u0007dkJ\u0014XM\u001c;BG2\u001c\b%A\toKb$8I]3bi\u0016\u0014Vm];miN,\"!!\u001b\u0011\r\u0005-\u0014\u0011PA?\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014AC2p]\u000e,(O]3oi*!\u00111OA;\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0014\u0001\u00026bm\u0006LA!a\u001f\u0002n\t)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0007CBA@\u0003\u0003\u000b))\u0004\u0002\u0002r%!\u00111QA9\u0005\u0011a\u0015n\u001d;\u0011\r\u0005-\u0014qQAF\u0013\u0011\tI)!\u001c\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\u0011\t\u0019#!%\u000b\u0005\u0005l\u0018\u0002BAK\u0003\u001f\u0013q\"Q2m\u0007J,\u0017\r^3SKN,H\u000e^\u0001\u0013]\u0016DHo\u0011:fCR,'+Z:vYR\u001c\b%A\toKb$H)\u001a7fi\u0016\u0014Vm];miN,\"!!(\u0011\r\u0005-\u0014\u0011PAP!\u0019\ty(!!\u0002\"B1\u00111NAD\u0003G\u0003B!!$\u0002&&!\u0011qUAH\u0005=\t5\r\u001c#fY\u0016$XMU3tk2$\u0018A\u00058fqR$U\r\\3uKJ+7/\u001e7ug\u0002\nq\"\u001e8fqB,7\r^3e\u0007\u0006dGn]\u000b\u0003\u0003_\u0003b!!\u0012\u00022\u0006U\u0016\u0002BAZ\u0003\u000f\u0012aAQ;gM\u0016\u0014\b\u0003BA\\\u0003\u000btA!!/\u0002BB\u0019\u00111\u00185\u000e\u0005\u0005u&bAA`I\u00061AH]8pizJ1!a1i\u0003\u0019\u0001&/\u001a3fM&!\u0011qYAe\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00195\u0002!UtW\r\u001f9fGR,GmQ1mYN\u0004\u0013!B:uCJ$H\u0003BAi\u0005\u0007\u0001D!a5\u0002fBA\u0011qPAk\u00033\f\t/\u0003\u0003\u0002X\u0006E$aA'baB!\u00111\\Ao\u001b\t\tY&\u0003\u0003\u0002`\u0006m#\u0001C#oIB|\u0017N\u001c;\u0011\t\u0005\r\u0018Q\u001d\u0007\u0001\t-\t9OUA\u0001\u0002\u0003\u0015\t!!;\u0003\u0007}#\u0013'\u0005\u0003\u0002l\u0006E\bcA4\u0002n&\u0019\u0011q\u001e5\u0003\u000f9{G\u000f[5oOB1\u00111NAz\u0003oLA!!>\u0002n\ty1i\\7qY\u0016$\u0018n\u001c8Ti\u0006<W\r\u0005\u0003\u0002z\u0006}XBAA~\u0015\u0011\ti0!\u001e\u0002\t1\fgnZ\u0005\u0005\u0005\u0003\tYP\u0001\u0003W_&$\u0007b\u0002B\u0003%\u0002\u0007!qA\u0001\u000bg\u0016\u0014h/\u001a:J]\u001a|\u0007\u0003BAG\u0005\u0013IAAa\u0003\u0002\u0010\n!\u0012)\u001e;i_JL'0\u001a:TKJ4XM]%oM>\f\u0011\"Y;uQ>\u0014\u0018N_3\u0015\r\tE!\u0011\u0004B\u0012!\u0019\ty(!!\u0003\u0014A!\u0011Q\u0012B\u000b\u0013\u0011\u00119\"a$\u0003'\u0005+H\u000f[8sSj\fG/[8o%\u0016\u001cX\u000f\u001c;\t\u000f\tm1\u000b1\u0001\u0003\u001e\u0005q!/Z9vKN$8i\u001c8uKb$\b\u0003BAG\u0005?IAA!\t\u0002\u0010\nQ\u0012)\u001e;i_JL'0\u00192mKJ+\u0017/^3ti\u000e{g\u000e^3yi\"9!QE*A\u0002\t\u001d\u0012aB1di&|gn\u001d\t\u0007\u0003\u007f\n\tI!\u000b\u0011\t\u00055%1F\u0005\u0005\u0005[\tyI\u0001\u0004BGRLwN\\\u0001\nG>tg-[4ve\u0016$BAa\r\u0003:A\u0019qM!\u000e\n\u0007\t]\u0002N\u0001\u0003V]&$\bb\u0002B\u001e)\u0002\u0007!QH\u0001\bG>tg-[4ta\u0011\u0011yDa\u0011\u0011\u0011\u0005}\u0014Q[A[\u0005\u0003\u0002B!a9\u0003D\u0011a!Q\tB\u001d\u0003\u0003\u0005\tQ!\u0001\u0003H\t\u0019q\f\n\u001a\u0012\t\u0005-(\u0011\n\t\u0004O\n-\u0013b\u0001B'Q\n\u0019\u0011I\\=\u0002\u000b\rdwn]3\u0015\u0005\tM\u0012\u0001B1dYN$BAa\u0016\u0003^A1\u0011\u0011 B-\u0003'JAAa\u0017\u0002|\nA\u0011\n^3sC\ndW\rC\u0004\u0003`Y\u0003\rA!\u0019\u0002\r\u0019LG\u000e^3s!\u0011\t)Fa\u0019\n\t\t\u0015\u0014q\u000b\u0002\u0011\u0003\u000ed')\u001b8eS:<g)\u001b7uKJ\fq\"\u00193e\u0003\u000edw*\u001e;PM\n\u000bg\u000e\u001a\u000b\u0005\u0005g\u0011Y\u0007C\u0004\u0003n]\u0003\r!a\u0015\u0002\u0015\u0005\u001cGNQ5oI&tw-\u0001\nsK6|g/Z!dY>+Ho\u00144CC:$G\u0003\u0002B\u001a\u0005gBqA!\u001cY\u0001\u0004\t\u0019&\u0001\u0006de\u0016\fG/Z!dYN$bA!\u001f\u0003\b\n%\u0005\u0007\u0002B>\u0005\u007f\u0002b!a \u0002\u0002\nu\u0004\u0003BAr\u0005\u007f\"1B!!Z\u0003\u0003\u0005\tQ!\u0001\u0003\u0004\n\u0019q\fJ\u001a\u0012\t\u0005-(Q\u0011\t\u0007\u0003W\n\u00190a#\t\u000f\tm\u0011\f1\u0001\u0003\u001e!9!1R-A\u0002\t5\u0015aC1dY\nKg\u000eZ5oON\u0004b!a \u0002\u0002\u0006M\u0013A\u00033fY\u0016$X-Q2mgR1!1\u0013BQ\u0005G\u0003DA!&\u0003\u001aB1\u0011qPAA\u0005/\u0003B!a9\u0003\u001a\u0012Y!1\u0014.\u0002\u0002\u0003\u0005)\u0011\u0001BO\u0005\ryF\u0005N\t\u0005\u0003W\u0014y\n\u0005\u0004\u0002l\u0005M\u00181\u0015\u0005\b\u00057Q\u0006\u0019\u0001B\u000f\u0011\u001d\u0011)K\u0017a\u0001\u0005O\u000b\u0011#Y2m\u0005&tG-\u001b8h\r&dG/\u001a:t!\u0019\ty(!!\u0003b\u0005\u0001\u0012\r\u001a3De\u0016\fG/\u001a*fgVdGo\u001d\u000b\u0007\u0005g\u0011iK!-\t\u000f\t=6\f1\u0001\u0002~\u00059!/Z:vYR\u001c\bb\u0002BZ7\u0002\u0007!QW\u0001\u0002]B\u0019qMa.\n\u0007\te\u0006NA\u0002J]R\f\u0001#\u00193e\t\u0016dW\r^3SKN,H\u000e^:\u0015\r\tM\"q\u0018Ba\u0011\u001d\u0011y\u000b\u0018a\u0001\u0003?CqAa-]\u0001\u0004\u0011),A\u0006bkRDwN]5{KJ\u0004\u0013A\u00027j].LE-\u0006\u0002\u0003JB!\u0011q\u0010Bf\u0013\u0011\u0011i-!\u001d\u0003\tU+\u0016\nR\u0001\bY&t7.\u00133!\u0003%\t7\r\u001c'j].LE-\u0006\u0002\u0003VB!\u00111\u001cBl\u0013\u0011\u0011I.a\u0017\u0003\tU+\u0018\u000eZ\u0001\u000bC\u000edG*\u001b8l\u0013\u0012\u0004\u0013aB7fiJL7m]\u000b\u0003\u0005C\u00042a\u001cBr\u0013\r\u0011)O\u0018\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u001d\t7\r\u001c'jgR,\"A!$\u0002\u0011\u0005\u001cG\u000eT5ti\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0003\u0005g\u0004BA!>\u0003|6\u0011!q\u001f\u0006\u0004\u0005s\u0014\u0017A\u0001>l\u0013\u0011\u0011iPa>\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u000275LwM]1uK>sW\r\u0015:j]\u000eL\u0007/\u00197BG2\u001c(j]8o+\t\t),\u0001\u000fnS\u001e\u0014\u0018\r^3P]\u0016\u0004&/\u001b8dSB\fG.Q2mg*\u001bxN\u001c\u0011\u0002%5LwM]1uK\u0006cG.Q2mg*\u001bxN\\\u0001\u0014[&<'/\u0019;f\u00032d\u0017i\u00197t\u0015N|g\u000eI\u0001\u0017[&<'/\u0019;f\t\u00164\u0017-\u001e7u\u0003\u000ed7OS:p]\u00069R.[4sCR,G)\u001a4bk2$\u0018i\u00197t\u0015N|g\u000eI\u0001\u0017[VdG/\u001b9mK\u0006\u001bGNR5mi\u0016\u00148OS:p]\u00069R.\u001e7uSBdW-Q2m\r&dG/\u001a:t\u0015N|g\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u0015\u0004=\r]\u0001\u0003BB\r\u0007Oi!aa\u0007\u000b\t\ru1qD\u0001\u0004CBL'\u0002BB\u0011\u0007G\tqA[;qSR,'O\u0003\u0003\u0004&\u0005\u0005\u0011!\u00026v]&$\u0018\u0002BB\u0015\u00077\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0010\u00040A!1\u0011DB\u0019\u0013\u0011\u0019\u0019da\u0007\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!C:fiV\u0004Xj\\2l\u0003M!Xm\u001d;BG24\u0015\u000e\u001c;feV\u0003H-\u0019;fQ\r\t31\b\t\u0005\u00073\u0019i$\u0003\u0003\u0004@\rm!\u0001\u0002+fgR\fq\u0002^3ti\u0006\u001bG.\u00113eSRLwN\u001c\u0015\u0004E\rm\u0012A\t;fgR\f5\r\\!eI\u0016$Gk\u001c#fgR\u001cE.^:uKJ|U\u000f^(g\u0005\u0006tG\rK\u0002$\u0007w\ta\u0005^3ti\u0006\u001bGNU3n_Z,GM\u0012:p[\u0012+7\u000f^\"mkN$XM](vi>3')\u00198eQ\r!31H\u0001-i\u0016\u001cH/Q2m\u0003\u0012$\u0017\u000e^5p]^KG\u000f['vYRL\u0007\u000f\\3BG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feND3!JB\u001e\u0003\u0001\"Xm\u001d;O_J+\u0007/Z1uK\u0012,\u0006\u000fZ1uK^CWM\u001c(p\u0007\"\fgnZ3)\u0007\u0019\u001aY$A\u001fuKN$hj\u001c*fa\u0016\fG/\u001a3Va\u0012\fG/Z,iK:tun\u00115b]\u001e,w+\u001b;i\u001bVdG/\u001b9mK\u0006\u001bGNQ5oI&twMR5mi\u0016\u00148\u000fK\u0002(\u0007w\tq\u0002^3ti\u0006\u001bG\u000eR3mKRLwN\u001c\u0015\u0004Q\rm\u0012\u0001\f;fgR\f5\r\u001c#fY\u0016$\u0018n\u001c8XSRDW*\u001e7uSBdW-Q2m\u0005&tG-\u001b8h\r&dG/\u001a:tQ\rI31H\u0001\u001bi\u0016\u001cH/Q2m\u0003\u0012$\u0017\u000e^5p]\u0006sG\rR3mKRLwN\u001c\u0015\u0004U\rm\u0012a\u000b;fgR\f5\r\\!eI&$\u0018n\u001c8B]\u0012$U\r\\3uS>tw+\u001b;i\t\u00164\u0017-\u001e7u\r&dG/\u001a:)\u0007-\u001aY$\u0001\u000fwKJLg-_!dY\u0006#G-\u001b;j_:\fe\u000e\u001a#fY\u0016$\u0018n\u001c8\u0015\r\tM2QNB9\u0011\u001d\u0019y\u0007\fa\u0001\u0003k\u000b!BZ5mi\u0016\u0014(j]8o\u0011\u001d\u0011y\u0006\fa\u0001\u0005C\nq\u0007^3ti\u0006\u001bG.\u00113eSRLwN\\!oI\u0012+G.\u001a;j_:<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0003\u000ed')\u001b8eS:<g)\u001b7uKJ\u001c\bfA\u0017\u0004<\u0005aC/Z:u\u000bb\u001cW\r\u001d;j_:L5\u000f\u00165s_^t\u0017JZ+oC\ndW\rV8HKR\u001cv.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004]\rm\u0012!\r;fgR,%O]8s\u001f:\f5\r\\!eI&$\u0018n\u001c8Va\u0012\fG/Z:M_\u000e\fG.Q2m'\u0016$8i\u001c:sK\u000e$H.\u001f\u0015\u0004_\rm\u0012!\r;fgR,%O]8s\u001f:\f5\r\u001c#fY\u0016$\u0018n\u001c8Va\u0012\fG/Z:M_\u000e\fG.Q2m'\u0016$8i\u001c:sK\u000e$H.\u001f\u0015\u0004a\rm\u0012a\u000e;fgR,%O]8s\u001f:\f5\r\\!eI&$\u0018n\u001c8GkR,(/Z+qI\u0006$Xm\u001d'pG\u0006d\u0017i\u00197TKR\u001cuN\u001d:fGRd\u0017\u0010K\u00022\u0007w\tq\u0007^3ti\u0016\u0013(o\u001c:P]\u0006\u001bG\u000eR3mKRLwN\u001c$viV\u0014X-\u00169eCR,7\u000fT8dC2\f5\r\\'ba\u000e{'O]3di2L\bf\u0001\u001a\u0004<\u0005)B/Z:u\u000bJ\u0014xN](o'>,(oY3BG2\u001c\bfA\u001a\u0004<\u0005IC/Z:u'\u0016\u001cWO]5us\u0012K7/\u00192mK\u0012,\u0005pY3qi&|g\u000eT5nSR<\u0016M\u001d8M_\u001eD3\u0001NB\u001e\u0003I!Xm\u001d;E_\u0016\u001c\u0018J\\5uS\u0006d\u0017N_3)\u0007U\u001aY$\u0001\u000fuKN$Hi\\3t\u001d>$\u0018J\\5uS\u0006d\u0017N_3P]\u0016\u0013(o\u001c:)\u0007Y\u001aY\u0004\u0006\t\u0002T\ru5QVBY\u0007w\u001byla1\u0004N\"91qT\u001cA\u0002\r\u0005\u0016\u0001\u0004:fg>,(oY3UsB,\u0007\u0003BBR\u0007Sk!a!*\u000b\t\r\u001d\u00161L\u0001\te\u0016\u001cx.\u001e:dK&!11VBS\u00051\u0011Vm]8ve\u000e,G+\u001f9f\u0011\u001d\u0019yk\u000ea\u0001\u0003k\u000bAB]3t_V\u00148-\u001a(b[\u0016Dqaa-8\u0001\u0004\u0019),A\u0006qCR$XM\u001d8UsB,\u0007\u0003BBR\u0007oKAa!/\u0004&\nY\u0001+\u0019;uKJtG+\u001f9f\u0011\u001d\u0019il\u000ea\u0001\u0003k\u000bQ\u0002\u001d:j]\u000eL\u0007/\u00197OC6,\u0007bBBao\u0001\u0007\u0011QW\u0001\tQ>\u001cHOT1nK\"91QY\u001cA\u0002\r\u001d\u0017\u0001D1dY>\u0003XM]1uS>t\u0007\u0003BA+\u0007\u0013LAaa3\u0002X\ta\u0011i\u00197Pa\u0016\u0014\u0018\r^5p]\"91qZ\u001cA\u0002\rE\u0017A\u00049fe6L7o]5p]RK\b/\u001a\t\u0005\u0003+\u001a\u0019.\u0003\u0003\u0004V\u0006]#!E!dYB+'/\\5tg&|g\u000eV=qK\u0006i\u0011\r\u001a3BG2\u0014\u0015N\u001c3j]\u001e$BA!$\u0004\\\"9\u0011\u0011\f\u001dA\u0002\u0005M\u0013\u0001\u0005:f[>4X-Q2m\u0005&tG-\u001b8h)\u0011\u0011ii!9\t\u000f\u0005e\u0013\b1\u0001\u0002T\u0005a\u0011M\\=BG24\u0015\u000e\u001c;feR!!\u0011MBt\u0011\u001d\u0019IO\u000fa\u0001\u0007W\fq\u0001\\5oW&#7\u000f\u0005\u0004\u00028\u000e5(Q[\u0005\u0005\u0003#\nI-\u0001\u0005mS:\\\u0017i\u00197t)\u0011\u0011iia=\t\u000f\tM3\b1\u0001\u0003\u000e\u00069A.\u001b8l\u0003\u000edG\u0003BA*\u0007sDq!!\u0017=\u0001\u0004\t\u0019\u0006\u0006\u0003\u0004~\u000e}\bCBA\\\u0007[\f\u0019\u0006C\u0004\u0003Tu\u0002\ra!@\u00023\u0005\u001cGn\u0011:fCRLwN\\*vG\u000e,7o\u001d*fgVdGo\u001d\u000b\u0005\u0003{\")\u0001C\u0004\u0005\by\u0002\rA!.\u0002\u00079,X.A\rbG2\u001c%/Z1uS>tg)Y5mkJ,'+Z:vYR\u001cH\u0003BA?\t\u001bAq\u0001b\u0002@\u0001\u0004\u0011),A\rbG2$U\r\\3uS>t7+^2dKN\u001c(+Z:vYR\u001cH\u0003BAP\t'Aq\u0001\"\u0006A\u0001\u0004\u0011i)A\u0006eK2,G/\u001a3BG2\u001c\u0018!G1dY\u0012+G.\u001a;j_:4\u0015-\u001b7ve\u0016\u0014Vm];miN$B!a(\u0005\u001c!9AQC!A\u0002\t5\u0015!\u00038fo\u000e{gNZ5h)\u0011!\t\u0003b\n\u0011\u0007=$\u0019#C\u0002\u0005&y\u0013\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0011\u001d\u0011YD\u0011a\u0001\tS\u0001\u0002\"a.\u0005,\u0005U\u0016QW\u0005\u0005\u0003/\fI-\u0001\u0006wKJLg-_'pG.\f\u0011cY;se\u0016tG\u000fR3ti\u0006\u001bGnU3u+\t\u0019i0\u0001\nnCR\u001c\u0007.\u001b8h\t\u0016\u001cH/Q2m'\u0016$H\u0003BB\u007f\toAq\u0001\"\u000fF\u0001\u0004!Y$A\u0007bG24\u0015\u000e\u001c;fe*\u001bxN\u001c\t\u0004_\u0012u\u0012b\u0001C =\nq\u0011i\u00197GS2$XM]:Kg>t\u0017!C1dY\u001aKG\u000e^3s)\u0011\u0011\t\u0007\"\u0012\t\u000f\u0011\u001dc\t1\u0001\u00026\u0006Ia-\u001b7uKJ\u001cFO]\u0001\u000fY>\u001c\u0017\r\\!dY\u001aKG\u000e^3s)\u0011\u0011\t\u0007\"\u0014\t\u000f\u0011=s\t1\u0001\u0002T\u00059!-\u001b8eS:<\u0007")
public class ClusterLinkSyncAclsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)EasyMock.createNiceMock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)EasyMock.createNiceMock(ClusterLinkMetadataManager.class);
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)EasyMock.createNiceMock(ClusterLinkClientManager.class);
    private final TestAuthorizer authorizer = new TestAuthorizer();
    private final UUID linkId = UUID.randomUUID();
    private final Uuid aclLinkId = CoreUtils$.MODULE$.toKafkaUUID(this.linkId());
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)EasyMock.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final java.util.List<AclBinding> aclList = new ArrayList<AclBinding>();
    private final ClusterLinkData linkData = new ClusterLinkData("test-link", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final String migrateOnePrincipalAclsJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }"));
    private final String migrateAllAclsJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(309).append("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\",\n      |     \"clusterLinkIds\": [\"").append(Uuid.ZERO_UUID).append("\", \"").append(this.aclLinkId()).append("\"]\n      |    }\n      |  }]\n      | }").toString()));
    private final String migrateDefaultAclsJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }"));
    private final String multipleAclFiltersJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"topic\",\n      |      \"name\": \"foo\",\n      |      \"patternType\": \"literal\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"read\",\n      |     \"permissionType\": \"allow\"\n      |    }\n      |  },\n      |  {\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"topic\",\n      |      \"name\": \"foo\",\n      |      \"patternType\": \"prefixed\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Alice\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"alter\",\n      |     \"permissionType\": \"allow\"\n      |    }\n      |  },\n      |  {\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"cluster\",\n      |      \"name\": \"*\",\n      |      \"patternType\": \"literal\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Mallory\",\n      |     \"host\":\"badhost\",\n      |     \"operation\": \"clusterAction\",\n      |     \"permissionType\": \"deny\"\n      |    }\n      |  }]\n      | }"));

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private TestAuthorizer authorizer() {
        return this.authorizer;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid aclLinkId() {
        return this.aclLinkId;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private java.util.List<AclBinding> aclList() {
        return this.aclList;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    public String migrateOnePrincipalAclsJson() {
        return this.migrateOnePrincipalAclsJson;
    }

    public String migrateAllAclsJson() {
        return this.migrateAllAclsJson;
    }

    public String migrateDefaultAclsJson() {
        return this.migrateDefaultAclsJson;
    }

    public String multipleAclFiltersJson() {
        return this.multipleAclFiltersJson;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    private void setupMock() {
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.reset((Object[])new Object[]{this.metadataManager()});
        EasyMock.reset((Object[])new Object[]{this.clientManager()});
        EasyMock.expect((Object)this.clientManager().scheduler()).andReturn((Object)this.scheduler()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getAdmin()).andReturn((Object)this.admin()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).anyTimes();
        EasyMock.expect((Object)this.clientManager().linkData()).andReturn((Object)new ClusterLinkData("test-link", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)).anyTimes();
    }

    @Test
    public void testAclFilterUpdate() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(3);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding bobAcl = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(bobAcl);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult fullDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        DescribeAclsResult bobDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{bobAcl}))).asJava()));
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateOnePrincipalAclsJson()))).andReturn((Object)bobDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)fullDescribeAclsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 2);
        ClusterLinkConfig bobConfig = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateOnePrincipalAclsJson())}))));
        ClusterLinkConfig allConfig = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)bobConfig).times(2);
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)allConfig).times(1);
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)bobConfig).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set bobAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)bobDescribeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)bobAclSet), this.matchingDestAclSet((AclFiltersJson)bobConfig.aclFilters().get()));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set allAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)fullDescribeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)allAclSet), this.matchingDestAclSet((AclFiltersJson)allConfig.aclFilters().get()));
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(2), 1);
        List notMatchingAcls = CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().toSet().$minus$minus(this.linkAcls((scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{bobAcl}))))).toList().map((Function1 & Serializable)acl -> this.aclDeletionSuccessResults(Collections.singletonList(acl)).get(0));
        this.authorizer().addDeleteResults(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)notMatchingAcls).asJava(), 1);
        TestUtils.setFieldValue((Object)syncAclsTask, (String)"initialized", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set<AclBinding> matchingAcls = this.linkAcls((scala.collection.immutable.Set<AclBinding>)bobAclSet);
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().toSet().$minus$minus(matchingAcls).map((Function1 & Serializable)acl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, Collections.emptySet()))).$plus$plus(matchingAcls), this.matchingDestAclSet((AclFiltersJson)allConfig.aclFilters().get()));
        this.verifyMock();
    }

    @Test
    public void testAclAddition() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)describeAclsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult.values().get()).asScala().toSet(), this.currentDestAclSet());
    }

    @Test
    public void testAclAddedToDestClusterOutOfBand() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic1", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic2", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)describeAclsResult).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set expectedAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        AclBinding outOfBandAclBind = this.linkAcl(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:OutOfBandUser", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        this.authorizer().addAclOutOfBand(outOfBandAclBind);
        this.authorizer().addDeleteResults(this.aclDeletionSuccessResults(Collections.singletonList(outOfBandAclBind)), 1);
        Assertions.assertNotEquals((Object)expectedAclSet, this.currentDestAclSet());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        this.verifyMock();
    }

    @Test
    public void testAclRemovedFromDestClusterOutOfBand() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding bobAcl = this.aclBinding(ResourceType.TOPIC, "topic1", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(bobAcl);
        AclBinding linkedBobAcl = this.linkAcl(bobAcl);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "topic2", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)describeAclsResult).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set expectedAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        this.authorizer().removeAclOutOfBand(linkedBobAcl);
        Assertions.assertNotEquals((Object)expectedAclSet, this.currentDestAclSet());
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(1), 1);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedAclSet, this.currentDestAclSet());
        this.verifyMock();
    }

    @Test
    public void testAclAdditionWithMultipleAclBindingFilters() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testNoRepeatedUpdateWhenNoChange() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)describeAclsResult).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        scala.collection.immutable.Set expectedAclSet = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult.values().get()).asScala().toSet();
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testNoRepeatedUpdateWhenNoChangeWithMultipleAclBindingFilters() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testAclDeletion() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclToDelete = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(aclToDelete);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        ArrayList<AclBinding> acls1 = new ArrayList<AclBinding>(this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY)));
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(acls1));
        java.util.List<AclBinding> acls2 = this.removeAclBinding(aclToDelete);
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(acls2));
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)describeAclsResult1).times(1).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        AclBinding deletedAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.authorizer().addDeleteResults(this.aclDeletionSuccessResults(Collections.singletonList(deletedAclBinding)), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult2.values().get()).asScala().toSet(), this.currentDestAclSet());
    }

    @Test
    public void testAclDeletionWithMultipleAclBindingFilters() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)deletedDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        this.authorizer().addDeleteResults(this.aclDeletionSuccessResults(Collections.singletonList(aclBinding1)), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testAclAdditionAndDeletion() {
        this.verifyAclAdditionAndDeletion(this.migrateAllAclsJson(), this.anyAclFilter((scala.collection.immutable.Set<Uuid>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID, this.aclLinkId()})))));
    }

    @Test
    public void testAclAdditionAndDeletionWithDefaultFilter() {
        this.verifyAclAdditionAndDeletion(this.migrateDefaultAclsJson(), this.anyAclFilter((scala.collection.immutable.Set<Uuid>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID})))));
    }

    private void verifyAclAdditionAndDeletion(String filterJson, AclBindingFilter filter) {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclToDelete = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(aclToDelete);
        ArrayList<AclBinding> acls1 = new ArrayList<AclBinding>(this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW)));
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(acls1));
        AclBinding addedAcl = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        this.addAclBinding(addedAcl);
        java.util.List<AclBinding> acls2 = this.removeAclBinding(aclToDelete);
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(acls2));
        EasyMock.expect((Object)this.admin().describeAcls(filter)).andReturn((Object)describeAclsResult1).times(1).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(2), 1);
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(1), 1);
        AclBinding deletedAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.authorizer().addDeleteResults(this.aclDeletionSuccessResults(Collections.singletonList(deletedAclBinding)), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)filterJson)}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)describeAclsResult2.values().get()).asScala().toSet(), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer().acls(AclBindingFilter.ANY)).asScala().toSet());
    }

    @Test
    public void testAclAdditionAndDeletionWithMultipleAclBindingFilters() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult emptyDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1).andReturn((Object)emptyDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)emptyDescribeAclsResult).times(1).andReturn((Object)describeAclsResult3).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(2), 1);
        this.authorizer().addDeleteResults(this.aclDeletionSuccessResults(Collections.singletonList(aclBinding1)), 1);
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(1), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testExceptionIsThrownIfUnableToGetSourceAcls() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        KafkaFutureImpl describeFuture = new KafkaFutureImpl();
        describeFuture.completeExceptionally((Throwable)new AuthorizationException("Unauthorized for DESCRIBE on Cluster"));
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)new DescribeAclsResult((KafkaFuture)describeFuture));
        EasyMock.replay((Object[])new Object[]{this.admin()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        ExecutionException ex = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS));
        Assertions.assertEquals(AuthorizationException.class, ex.getCause().getCause().getClass());
        this.verifyMock();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclAdditionUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture createFuture = new CompletableFuture();
        createFuture.completeExceptionally((Throwable)new AuthorizationException("Unable to create ACLs"));
        this.authorizer().addCreateResults(Collections.singletonList(createFuture), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclDeletionUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)deletedDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        CompletableFuture deleteFuture = new CompletableFuture();
        deleteFuture.completeExceptionally((Throwable)new AuthorizationException("Unable to delete ACLs"));
        this.authorizer().addDeleteResults(Collections.singletonList(deleteFuture), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclAdditionFutureUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationFailureResults(3), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnAclDeletionFutureUpdatesLocalAclMapCorrectly() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = this.localAclFilter(aclBinding1);
        AclBindingFilter aclBindingFilter2 = this.localAclFilter(aclBinding2);
        AclBindingFilter aclBindingFilter3 = this.localAclFilter(aclBinding3);
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)deletedDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(3), 1);
        this.authorizer().addDeleteResults(this.aclDeletionFailureResults(Collections.singletonList(aclBinding1)), 1);
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        scala.collection.immutable.Set expectedAclSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}));
        Assertions.assertEquals(this.linkAcls((scala.collection.immutable.Set<AclBinding>)expectedAclSet), this.currentDestAclSet());
    }

    @Test
    public void testErrorOnSourceAcls() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        KafkaFutureImpl completedFuture = new KafkaFutureImpl();
        completedFuture.completeExceptionally((Throwable)new TimeoutException("Timed out getting source ACLs"));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult((KafkaFuture)completedFuture);
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)describeAclsResult).once();
        EasyMock.replay((Object[])new Object[]{this.admin()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.startup();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncAclsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
        EasyMock.verify((Object[])new Object[]{this.admin()});
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    @Test
    public void testSecurityDisabledExceptionLimitWarnLog() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(6);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        KafkaFutureImpl futureCompletedWithSecDisException = new KafkaFutureImpl();
        futureCompletedWithSecDisException.completeExceptionally((Throwable)Errors.SECURITY_DISABLED.exception());
        KafkaFuture futureCompletedSuccessfully = KafkaFuture.completedFuture(Collections.emptyList());
        KafkaFutureImpl futureCompletedWithDifferentExecException = new KafkaFutureImpl();
        futureCompletedWithDifferentExecException.completeExceptionally((Throwable)Errors.REQUEST_TIMED_OUT.exception());
        EasyMock.expect((Object)this.admin().describeAcls(this.aclFilter(this.migrateAllAclsJson()))).andReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).times(2).andReturn((Object)new DescribeAclsResult(futureCompletedSuccessfully)).times(1).andReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).times(1).andReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithDifferentExecException)).times(1).andReturn((Object)new DescribeAclsResult((KafkaFuture)futureCompletedWithSecDisException)).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)2, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        Assertions.assertEquals(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncAclsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 950))).getCause().getCause().getClass(), TimeoutException.class);
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncAclsTask.currentNumSecurityDisabledExceptions());
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
        EasyMock.verify((Object[])new Object[]{this.admin()});
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.currentDestAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    @Test
    public void testDoesInitialize() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding acl = this.linkAcl(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW));
        this.authorizer().addAclOutOfBand(acl);
        this.authorizer().addCreateResults(this.aclCreationSuccessResults(1), 1);
        String aclFilterJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }"));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)aclFilterJson)}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
        Assertions.assertTrue((boolean)syncAclsTask.isInitialized());
    }

    @Test
    public void testDoesNotInitializeOnError() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(EasyMock.anyString(), EasyMock.anyBoolean()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.metadataManager()});
        AclBinding acl = this.linkAcl(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW));
        this.authorizer().addAclOutOfBand(acl);
        this.authorizer().addCreateResults(this.aclCreationFailureResults(1), 1);
        String aclFilterJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"principal\": \"User:Bob\",\n        |     \"host\":\"*\",\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }"));
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)aclFilterJson)}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.linkData(), this.metadataManager(), this.metrics());
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.metadataManager()});
        Assertions.assertFalse((boolean)syncAclsTask.isInitialized());
    }

    private AclBinding aclBinding(ResourceType resourceType, String resourceName, PatternType patternType, String principalName, String hostName, AclOperation aclOperation, AclPermissionType permissionType) {
        ResourcePattern resourcePattern = new ResourcePattern(resourceType, resourceName, patternType);
        AccessControlEntry accessControlEntry = new AccessControlEntry(principalName, hostName, aclOperation, permissionType);
        return new AclBinding(resourcePattern, accessControlEntry);
    }

    private java.util.List<AclBinding> addAclBinding(AclBinding acl) {
        this.aclList().add(acl);
        return this.linkAcls(this.aclList());
    }

    private java.util.List<AclBinding> removeAclBinding(AclBinding acl) {
        this.aclList().remove(acl);
        return this.linkAcls(this.aclList());
    }

    private AclBindingFilter anyAclFilter(scala.collection.immutable.Set<Uuid> linkIds) {
        return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, (Collection)CollectionConverters$.MODULE$.SetHasAsJava(linkIds).asJava()));
    }

    private java.util.List<AclBinding> linkAcls(java.util.List<AclBinding> acls) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(acls).asScala().map((Function1 & Serializable)sourceAcl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)sourceAcl, Collections.singleton(this.aclLinkId())))).asJava();
    }

    private AclBinding linkAcl(AclBinding acl) {
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, Collections.singleton(this.aclLinkId()));
    }

    private scala.collection.immutable.Set<AclBinding> linkAcls(scala.collection.immutable.Set<AclBinding> acls) {
        return (scala.collection.immutable.Set)acls.map((Function1 & Serializable)sourceAcl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)sourceAcl, Collections.singleton(this.aclLinkId())));
    }

    /*
     * WARNING - void declaration
     */
    private java.util.List<CompletableFuture<AclCreateResult>> aclCreationSuccessResults(int num) {
        void var2_2;
        ArrayList successList = new ArrayList();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), num).foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> successList.add(CompletableFuture.completedFuture(AclCreateResult.SUCCESS)));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private java.util.List<CompletableFuture<AclCreateResult>> aclCreationFailureResults(int num) {
        void var2_2;
        ArrayList failureList = new ArrayList();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), num).foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> failureList.add(CompletableFuture.completedFuture(new AclCreateResult((ApiException)new AuthenticationException("Unable to authenticate")))));
        return var2_2;
    }

    private java.util.List<CompletableFuture<AclDeleteResult>> aclDeletionSuccessResults(java.util.List<AclBinding> deletedAcls) {
        ArrayList aclBindingDeleteResult = new ArrayList();
        CollectionConverters$.MODULE$.ListHasAsScala(deletedAcls).asScala().foreach((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncAclsTest.$anonfun$aclDeletionSuccessResults$1(aclBindingDeleteResult, acl)));
        return Collections.singletonList(CompletableFuture.completedFuture(new AclDeleteResult(aclBindingDeleteResult)));
    }

    private java.util.List<CompletableFuture<AclDeleteResult>> aclDeletionFailureResults(java.util.List<AclBinding> deletedAcls) {
        ArrayList aclBindingDeleteResult = new ArrayList();
        CollectionConverters$.MODULE$.ListHasAsScala(deletedAcls).asScala().foreach((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncAclsTest.$anonfun$aclDeletionFailureResults$1(aclBindingDeleteResult, acl)));
        return Collections.singletonList(CompletableFuture.completedFuture(new AclDeleteResult(aclBindingDeleteResult)));
    }

    private ClusterLinkConfig newConfig(scala.collection.immutable.Map<String, String> configs) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(configs);
        return ClusterLinkConfig$.MODULE$.create((Map)props, true);
    }

    private void verifyMock() {
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.admin()});
        Assertions.assertEquals((Object)Buffer$.MODULE$.empty(), this.authorizer().unexpectedCalls());
    }

    private scala.collection.immutable.Set<AclBinding> currentDestAclSet() {
        return this.matchingDestAclSet((AclFiltersJson)this.clientManager().currentConfig().aclFilters().get());
    }

    private scala.collection.immutable.Set<AclBinding> matchingDestAclSet(AclFiltersJson aclFilterJson) {
        return ((IterableOnceOps)AclJson$.MODULE$.toAclBindingFilters(aclFilterJson).flatMap((Function1 & Serializable)filter -> {
            AclBindingFilter allFilter = SecurityUtils.aclFilterWithClusterLinkIds((AclBindingFilter)filter, Collections.emptyList());
            return CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer().acls(allFilter)).asScala();
        })).toSet();
    }

    private AclBindingFilter aclFilter(String filterStr) {
        return (AclBindingFilter)AclJson$.MODULE$.toAclBindingFilters((AclFiltersJson)Option$.MODULE$.option2Iterable(AclJson$.MODULE$.parse(filterStr)).head()).head();
    }

    private AclBindingFilter localAclFilter(AclBinding binding) {
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)binding, Collections.singleton(Uuid.ZERO_UUID)).toFilter();
    }

    public static final /* synthetic */ boolean $anonfun$aclDeletionSuccessResults$1(Collection aclBindingDeleteResult$1, AclBinding acl) {
        AclDeleteResult.AclBindingDeleteResult aclBinding = new AclDeleteResult.AclBindingDeleteResult(acl);
        return aclBindingDeleteResult$1.add(aclBinding);
    }

    public static final /* synthetic */ boolean $anonfun$aclDeletionFailureResults$1(Collection aclBindingDeleteResult$2, AclBinding acl) {
        AclDeleteResult.AclBindingDeleteResult aclBinding = new AclDeleteResult.AclBindingDeleteResult(acl, (ApiException)new AuthenticationException("Unable to authenticate"));
        return aclBindingDeleteResult$2.add(aclBinding);
    }

    private class TestAuthorizer
    extends AclAuthorizer {
        private final Set<AclBinding> currentAcls;
        private final ConcurrentLinkedQueue<java.util.List<CompletableFuture<AclCreateResult>>> nextCreateResults;
        private final ConcurrentLinkedQueue<java.util.List<CompletableFuture<AclDeleteResult>>> nextDeleteResults;
        private final Buffer<String> unexpectedCalls;

        public Set<AclBinding> currentAcls() {
            return this.currentAcls;
        }

        public ConcurrentLinkedQueue<java.util.List<CompletableFuture<AclCreateResult>>> nextCreateResults() {
            return this.nextCreateResults;
        }

        public ConcurrentLinkedQueue<java.util.List<CompletableFuture<AclDeleteResult>>> nextDeleteResults() {
            return this.nextDeleteResults;
        }

        public Buffer<String> unexpectedCalls() {
            return this.unexpectedCalls;
        }

        public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return Collections.emptyMap();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            throw new UnsupportedOperationException("authorize()");
        }

        public void configure(Map<String, ?> configs) {
        }

        public void close() {
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return CollectionConverters$.MODULE$.MutableSetHasAsJava((Set)this.currentAcls().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)))).asJava();
        }

        public void addAclOutOfBand(AclBinding aclBinding) {
            this.currentAcls().$plus$eq((Object)aclBinding);
        }

        public void removeAclOutOfBand(AclBinding aclBinding) {
            this.currentAcls().remove((Object)aclBinding);
        }

        /*
         * WARNING - void declaration
         */
        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
            void var3_3;
            java.util.List<CompletableFuture<AclCreateResult>> results = this.nextCreateResults().poll();
            if (results == null) {
                this.unexpectedCalls().$plus$eq((Object)"createAcls");
                return Collections.emptyList();
            }
            ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(aclBindings).asScala().zip((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(results).asScala())).foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                AclBinding acl = (AclBinding)x0$1._1();
                CompletableFuture result = (CompletableFuture)x0$1._2();
                BoxedUnit boxedUnit = result.isDone() && !result.isCompletedExceptionally() && !((AclCreateResult)result.get()).exception().isPresent() ? this.currentAcls().$plus$eq((Object)acl) : BoxedUnit.UNIT;
                return boxedUnit;
            });
            return var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
            void var3_3;
            java.util.List<CompletableFuture<AclDeleteResult>> results = this.nextDeleteResults().poll();
            if (results == null) {
                this.unexpectedCalls().$plus$eq((Object)"deleteAcls");
                return Collections.emptyList();
            }
            ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(aclBindingFilters).asScala().zip((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(results).asScala())).foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                AclBindingFilter filter = (AclBindingFilter)x0$1._1();
                CompletableFuture result = (CompletableFuture)x0$1._2();
                BoxedUnit boxedUnit = result.isDone() && !result.isCompletedExceptionally() && !((AclDeleteResult)result.get()).exception().isPresent() && !CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)result.get()).aclBindingDeleteResults()).asScala().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TestAuthorizer.$anonfun$deleteAcls$2(x$3))) ? this.currentAcls().$minus$minus$eq((IterableOnce)this.currentAcls().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)))) : BoxedUnit.UNIT;
                return boxedUnit;
            });
            return var3_3;
        }

        public void addCreateResults(java.util.List<CompletableFuture<AclCreateResult>> results, int n) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> this.nextCreateResults().add(results));
        }

        public void addDeleteResults(java.util.List<CompletableFuture<AclDeleteResult>> results, int n) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> this.nextDeleteResults().add(results));
        }

        public /* synthetic */ ClusterLinkSyncAclsTest kafka$server$link$ClusterLinkSyncAclsTest$TestAuthorizer$$$outer() {
            return ClusterLinkSyncAclsTest.this;
        }

        public static final /* synthetic */ boolean $anonfun$deleteAcls$2(AclDeleteResult.AclBindingDeleteResult x$3) {
            return x$3.exception().isPresent();
        }

        public TestAuthorizer() {
            if (ClusterLinkSyncAclsTest.this == null) {
                throw null;
            }
            this.currentAcls = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            this.nextCreateResults = new ConcurrentLinkedQueue();
            this.nextDeleteResults = new ConcurrentLinkedQueue();
            this.unexpectedCalls = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        }
    }
}

