/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaQuota;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.easymock.EasyMock;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkTestUtils$ {
    public static final ClusterLinkTestUtils$ MODULE$;
    private static final Metrics metrics;
    private static final MockTime time;
    private static final AuthorizerServerInfo serverInfo;
    private static final KafkaConfig props;
    private static final boolean isMultiTenant;

    static {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        MODULE$ = new ClusterLinkTestUtils$();
        metrics = new Metrics();
        time = new MockTime();
        serverInfo = (AuthorizerServerInfo)EasyMock.mock(AuthorizerServerInfo.class);
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        boolean bl8 = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        Object var5_23 = null;
        props = new KafkaConfig((Map)apply_props, bl8);
        isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((Map)MODULE$.props().values(), (Metrics)MODULE$.metrics()) != null;
    }

    private Metrics metrics() {
        return metrics;
    }

    private MockTime time() {
        return time;
    }

    private AuthorizerServerInfo serverInfo() {
        return serverInfo;
    }

    private KafkaConfig props() {
        return props;
    }

    private boolean isMultiTenant() {
        return isMultiTenant;
    }

    public ClusterLinkManager createClusterLinkManager() {
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(this.props(), "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, this.metrics(), (Time)this.time(), this.isMultiTenant(), (Option)None$.MODULE$);
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        EasyMock.expect((Object)this.serverInfo().interBrokerEndpoint()).andReturn((Object)brokerEndpoint).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInfo()});
        KafkaController controller = (KafkaController)EasyMock.createMock(KafkaController.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        ZkMetadataCache metadataCache = (ZkMetadataCache)EasyMock.createMock(ZkMetadataCache.class);
        EasyMock.expect((Object)zkClient.getChildren("/cluster_links")).andReturn((Object)package$.MODULE$.Seq().empty()).anyTimes();
        EasyMock.expect((Object)zkClient.getClusterLinks((Set)EasyMock.anyObject())).andReturn((Object)Predef$.MODULE$.Map().empty()).anyTimes();
        zkClient.transformEntityConfigs((String)EasyMock.anyObject(), (String)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkClient.clusterLinkExists((UUID)EasyMock.isA(UUID.class)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        zkClient.setOrCreateEntityConfigs(EasyMock.anyString(), EasyMock.anyString(), (Properties)EasyMock.isA(Properties.class));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        zkClient.createClusterLink((ClusterLinkData)EasyMock.isA(ClusterLinkData.class));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        zkClient.createConfigChangeNotification(EasyMock.anyString());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{zkClient});
        ZkSupport zkSupport = new ZkSupport(null, controller, zkClient, (Option)None$.MODULE$, metadataCache);
        manager.initialize(this.serverInfo(), null, (Option)None$.MODULE$, (MetadataSupport)zkSupport, (Option)None$.MODULE$);
        manager.startup(null);
        return (ClusterLinkManager)manager;
    }

    private ClusterLinkTestUtils$() {
    }
}

