/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005%4AAE\n\u00015!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00031\u0003BB\u0018\u0001A\u0003%q\u0005C\u00041\u0001\t\u0007I\u0011A\u0019\t\ra\u0002\u0001\u0015!\u00033\u0011\u001dI\u0004A1A\u0005\u0002iBaA\u0012\u0001!\u0002\u0013Y\u0004\"B$\u0001\t\u0003A\u0005\"B,\u0001\t\u0003A\u0005\"B-\u0001\t\u0003A\u0005\"B.\u0001\t\u0003A\u0005\"B/\u0001\t\u0003A\u0005\"B0\u0001\t\u0003A\u0005\"B1\u0001\t\u0003A\u0005\"B2\u0001\t\u0003A\u0005\"B3\u0001\t\u0003A\u0005\"B4\u0001\t\u0003A%!G\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a+fgRT!\u0001F\u000b\u0002\t1Lgn\u001b\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005\u0019\u0012\u0001\u00037j].t\u0015-\\3\u0016\u0003\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\t1\fgn\u001a\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013F\u0001\u0004TiJLgnZ\u0001\nY&t7NT1nK\u0002\na\u0001\\5oW&#W#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005UZ\u0013\u0001B;uS2L!a\u000e\u001b\u0003\tU+\u0016\nR\u0001\bY&t7.\u00133!\u00035\u0019x.\u001e:dKR{\u0007/[2JIV\t1\b\u0005\u0002=\t6\tQH\u0003\u0002?\u007f\u000511m\\7n_:T!\u0001\u0007!\u000b\u0005\u0005\u0013\u0015AB1qC\u000eDWMC\u0001D\u0003\ry'oZ\u0005\u0003\u000bv\u0012A!V;jI\u0006q1o\\;sG\u0016$v\u000e]5d\u0013\u0012\u0004\u0013A\u0005;fgR4%o\\7Kg>t7\u000b\u001e:j]\u001e$\u0012!\u0013\t\u00039)K!aS\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u00115\u0003\"AT+\u000e\u0003=S!\u0001U)\u0002\u0007\u0005\u0004\u0018N\u0003\u0002S'\u00069!.\u001e9ji\u0016\u0014(B\u0001+C\u0003\u0015QWO\\5u\u0013\t1vJ\u0001\u0003UKN$\u0018\u0001\u0005;fgR$vNS:p]N#(/\u001b8hQ\tIQ*\u0001\u0006uKN$X*\u001b:s_JD#AC'\u0002!Q,7\u000f\u001e)bkN,G-T5se>\u0014\bFA\u0006N\u0003A!Xm\u001d;GC&dW\rZ'jeJ|'\u000f\u000b\u0002\r\u001b\u0006AB/Z:u!\u0016tG-\u001b8h'R|\u0007\u000f]3e\u001b&\u0014(o\u001c:)\u00055i\u0015!\u0005;fgR\u001cFo\u001c9qK\u0012l\u0015N\u001d:pe\"\u0012a\"T\u0001\ri\u0016\u001cHOQ1e\u000b:$(/\u001f\u0015\u0003\u001f5\u000ba\u0002^3ti\n\u000bGMV3sg&|g\u000e\u000b\u0002\u0011\u001b\u0006\u0019B/Z:u\u001bVdG/\u001b9mK\u0016sGO]5fg\"\u0012\u0011#\u0014")
public class ClusterLinkTopicStateTest {
    private final String linkName;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();

    public String linkName() {
        return this.linkName;
    }

    public UUID linkId() {
        return this.linkId;
    }

    public Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    @Test
    public void testFromJsonString() {
        int timeMs = 123456789;
        ClusterLinkTopicState result = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(173).append("|{\n          |  \"Mirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(this.linkId()).append("\"\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), Uuid.ZERO_UUID, (long)timeMs), (Object)result);
        ClusterLinkTopicState mirrorWithSourceTopicId = ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(211).append("|{\n          |  \"Mirror\": {\n          |    \"version\": 1,\n          |    \"time_ms\": ").append(timeMs).append(",\n          |    \"link_name\": \"").append(this.linkName()).append("\",\n          |    \"link_id\": \"").append(this.linkId()).append("\",\n          |    \"source_topic_id\": \"").append(this.sourceTopicId()).append("\"\n          |  }\n          |}").toString())));
        Assertions.assertEquals((Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs), (Object)mirrorWithSourceTopicId);
    }

    @Test
    public void testToJsonString() {
        int timeMs = 123456789;
        ClusterLinkTopicState.Mirror mirror = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), (long)timeMs);
        Assertions.assertEquals((Object)mirror, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(mirror.toJsonString()));
        ClusterLinkTopicState.Mirror mirrorWithSourceTopicId = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), Uuid.ZERO_UUID, (long)timeMs);
        Assertions.assertEquals((Object)mirrorWithSourceTopicId, (Object)ClusterLinkTopicState$.MODULE$.fromJsonString(mirrorWithSourceTopicId.toJsonString()));
    }

    @Test
    public void testMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.Mirror state = new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), timeMs);
        ClusterLinkTopicState.Mirror data = (ClusterLinkTopicState.Mirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertTrue((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
    }

    @Test
    public void testPausedMirror() {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)linkLevel -> {
            ClusterLinkTopicStateTest.$anonfun$testPausedMirror$1(this, BoxesRunTime.unboxToBoolean((Object)linkLevel));
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFailedMirror() {
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.FailedMirror state = new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), timeMs);
        ClusterLinkTopicState.FailedMirror data = (ClusterLinkTopicState.FailedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
    }

    @Test
    public void testPendingStoppedMirror() {
        boolean synchronize = true;
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.PendingStoppedMirror state = new ClusterLinkTopicState.PendingStoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), synchronize, timeMs);
        ClusterLinkTopicState.PendingStoppedMirror data = (ClusterLinkTopicState.PendingStoppedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)synchronize), (Object)BoxesRunTime.boxToBoolean((boolean)data.synchronize()));
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
    }

    @Test
    public void testStoppedMirror() {
        List logEndOffsets = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{12345L, 23456L, 34567L}));
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.StoppedMirror state = new ClusterLinkTopicState.StoppedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), (Seq)logEndOffsets, timeMs);
        ClusterLinkTopicState.StoppedMirror data = (ClusterLinkTopicState.StoppedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)logEndOffsets, (Object)data.logEndOffsets());
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertFalse((boolean)data.state().readOnly());
        Assertions.assertFalse((boolean)data.mirrorIsEstablished());
    }

    @Test
    public void testBadEntry() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(200).append("|{\n            |  \"Unexpected\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"").append(this.linkName()).append("\",\n            |    \"link_id\": \"").append(this.linkId()).append("\"\n            |  }\n            |}").toString()))));
    }

    @Test
    public void testBadVersion() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(196).append("|{\n            |  \"Mirror\": {\n            |    \"version\": 0,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"").append(this.linkName()).append("\",\n            |    \"link_id\": \"").append(this.linkId()).append("\"\n            |  }\n            |}").toString()))));
    }

    @Test
    public void testMultipleEntries() {
        Assertions.assertThrows(IllegalStateException.class, () -> ClusterLinkTopicState$.MODULE$.fromJsonString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(404).append("|{\n            |  \"Mirror\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"test-link-1\",\n            |    \"link_id\": \"").append(UUID.randomUUID()).append("\"\n            |  },\n            |  \"FailedMirror\": {\n            |    \"version\": 1,\n            |    \"time_ms\": 123456789,\n            |    \"link_name\": \"test-link-2\",\n            |    \"link_id\": \"").append(UUID.randomUUID()).append("\"\n            |  }\n            |}").toString()))));
    }

    private final void runTest$1(boolean linkLevel, boolean topicLevel, boolean wasFailed) {
        long timeMs = Time.SYSTEM.milliseconds();
        ClusterLinkTopicState.PausedMirror state = new ClusterLinkTopicState.PausedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), linkLevel, topicLevel, wasFailed, timeMs);
        ClusterLinkTopicState.PausedMirror data = (ClusterLinkTopicState.PausedMirror)ClusterLinkTopicState$.MODULE$.fromJsonString(state.toJsonString());
        Assertions.assertEquals((Object)this.linkName(), (Object)data.linkName());
        Assertions.assertEquals((Object)this.linkId(), (Object)data.linkId());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)linkLevel), (Object)BoxesRunTime.boxToBoolean((boolean)data.linkLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)topicLevel), (Object)BoxesRunTime.boxToBoolean((boolean)data.topicLevel()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)wasFailed), (Object)BoxesRunTime.boxToBoolean((boolean)data.wasFailed()));
        Assertions.assertEquals((long)timeMs, (long)data.timeMs());
        Assertions.assertFalse((boolean)data.state().shouldSync());
        Assertions.assertTrue((boolean)data.state().readOnly());
        Assertions.assertTrue((boolean)data.mirrorIsEstablished());
    }

    public static final /* synthetic */ void $anonfun$testPausedMirror$2(ClusterLinkTopicStateTest $this, boolean linkLevel$1, boolean topicLevel) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)wasFailed -> {
            $this.runTest$1(linkLevel$1, topicLevel, BoxesRunTime.unboxToBoolean((Object)wasFailed));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testPausedMirror$1(ClusterLinkTopicStateTest $this, boolean linkLevel) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)topicLevel -> {
            ClusterLinkTopicStateTest.$anonfun$testPausedMirror$2($this, linkLevel, BoxesRunTime.unboxToBoolean((Object)topicLevel));
            return BoxedUnit.UNIT;
        });
    }

    public ClusterLinkTopicStateTest() {
        this.linkName = "test-link";
    }
}

