/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDynamicLogger;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.resource.PatternType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\u000e\u001c\u0001\tBQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001C\u0002\u0013\u0005a\u0006\u0003\u00043\u0001\u0001\u0006Ia\f\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0011\u0019A\u0004\u0001)A\u0005k!)\u0011\b\u0001C\u0001u!)1\n\u0001C\u0001u!)Q\n\u0001C\u0001u!)q\n\u0001C\u0001u!)\u0011\u000b\u0001C\u0001u!)1\u000b\u0001C\u0001u!)Q\u000b\u0001C\u0001u!)q\u000b\u0001C\u0001u!)\u0011\f\u0001C\u0001u!)1\f\u0001C\u0001u!)Q\f\u0001C\u0001u!)q\f\u0001C\u0001u!)\u0011\r\u0001C\u0001u!)1\r\u0001C\u0001u!)Q\r\u0001C\u0001u!)q\r\u0001C\u0001u!)\u0011\u000e\u0001C\u0001u!)1\u000e\u0001C\u0005Y\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0002\u0015\u00072,8\u000f^3s\u0019&t7.\u0016;jYN$Vm\u001d;\u000b\u0005qi\u0012\u0001\u00027j].T!AH\u0010\u0002\rM,'O^3s\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u001c\u0003)a\u0017N\\6D_:4\u0017nZ\u000b\u0002_A\u0011A\u0006M\u0005\u0003cm\u0011\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003-a\u0017N\\6D_:4\u0017n\u001a\u0011\u0002)Q|\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t+\u0005)\u0004C\u0001\u00177\u0013\t94D\u0001\u000eNSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7/A\u000bu_BL7mQ8oM&<7+\u001f8d%VdWm\u001d\u0011\u0002%Q,7\u000f\u001e,bY&$G*\u001b8l\u001d\u0006lWm\u001d\u000b\u0002wA\u0011A\u0005P\u0005\u0003{\u0015\u0012A!\u00168ji\"\u0012aa\u0010\t\u0003\u0001&k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b1!\u00199j\u0015\t!U)A\u0004kkBLG/\u001a:\u000b\u0005\u0019;\u0015!\u00026v]&$(\"\u0001%\u0002\u0007=\u0014x-\u0003\u0002K\u0003\n!A+Z:u\u0003Q!Xm\u001d;J]Z\fG.\u001b3MS:\\g*Y7fg\"\u0012qaP\u0001\u0018i\u0016\u001cHOV1mS\u0012\fG/Z'jeJ|'\u000f\u0015:paND#\u0001C \u00029Q,7\u000f\u001e,bY&$\u0017\r^3NSJ\u0014xN\u001d)s_B\u001cX)\u001c9us\"\u0012\u0011bP\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/Z%om\u0006d\u0017\u000eZ'jeJ|'\u000f\u0015:paND#AC \u0002KQ,7\u000f\u001e,bY&$\u0017\r^3J]Z\fG.\u001b3NSJ\u0014xN\u001d)s_B\u001c8+\u001f8p]fl\u0007FA\u0006@\u0003M!Xm\u001d;J]&$X*\u001b:s_J\u0004&o\u001c9tQ\taq(\u0001\u0010uKN$\u0018J\\5u\u001b&\u0014(o\u001c:Qe>\u00048\u000fT8dC2\fEn^1zg\"\u0012QbP\u0001(i\u0016\u001cH/\u00138ji6K'O]8s!J|\u0007o]+oW:|wO\\\"p]\u001aLw-S4o_J,G\r\u000b\u0002\u000f\u007f\u0005)B/Z:u+B$\u0017\r^3NSJ\u0014xN\u001d)s_B\u001c\bFA\b@\u0003%\"Xm\u001d;Va\u0012\fG/Z'jeJ|'\u000f\u0015:paN,fn\u001b8po:\u001cuN\u001c4jO&;gn\u001c:fI\"\u0012\u0001cP\u0001\u001fi\u0016\u001cHOU3t_24Xm\u0011:fCR,Gk\u001c9jGN#\u0018M\u001c3be\u0012D#!E \u00029Q,7\u000f\u001e*fg>dg/Z\"sK\u0006$X-T5se>\u0014Hk\u001c9jG\"\u0012!cP\u0001#i\u0016\u001cHOU3t_24Xm\u0011:fCR,W*\u001b:s_J$v\u000e]5d\u000bJ\u0014xN]:)\u0005My\u0014\u0001\b;fgR4\u0016\r\\5eCR,7I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003)}\n!\u0002^3ti\u001aKG\u000e^3sQ\t)r(A\tuKN$H)\u001f8b[&\u001cGj\\4hKJD#AF \u0002\u00155\f7.Z\"p]\u001aLw\r\u0006\u0002nqB\u0011aN^\u0007\u0002_*\u0011\u0001/]\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003eN\fqa\u00197jK:$8O\u0003\u0002!i*\u0011QoR\u0001\u0007CB\f7\r[3\n\u0005]|'AB\"p]\u001aLw\rC\u0003z/\u0001\u0007!0A\u0004f]R\u0014\u0018.Z:\u0011\u000bm\f9!!\u0004\u000f\u0007q\f\u0019AD\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\u0006\na\u0001\u0010:p_Rt\u0014\"\u0001\u0014\n\u0007\u0005\u0015Q%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00111\u0002\u0002\u0004'\u0016\f(bAA\u0003KAIA%a\u0004\u0002\u0014\u0005M\u00111E\u0005\u0004\u0003#)#A\u0002+va2,7\u0007\u0005\u0003\u0002\u0016\u0005ua\u0002BA\f\u00033\u0001\"!`\u0013\n\u0007\u0005mQ%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037)\u0003c\u0001\u0013\u0002&%\u0019\u0011qE\u0013\u0003\u000f\t{w\u000e\\3b]\u0006qQ.Y6f!J|\u0007/\u001a:uS\u0016\u001cH\u0003BA\u0017\u0003{\u0001B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003vi&d'BAA\u001c\u0003\u0011Q\u0017M^1\n\t\u0005m\u0012\u0011\u0007\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB=\u0019\u0001\u0004\ty\u0004E\u0003|\u0003\u000f\t\t\u0005E\u0004%\u0003\u0007\n\u0019\"a\u0005\n\u0007\u0005\u0015SE\u0001\u0004UkBdWMM\u0001\u0013[\u0006\\Wm\u0011:fCR\f'\r\\3U_BL7\r\u0006\u0006\u0002L\u0005\r\u0014qMA9\u0003w\u0002B!!\u0014\u0002^9!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013aB7fgN\fw-\u001a\u0006\u0004\u0003/\u001a\u0018AB2p[6|g.\u0003\u0003\u0002\\\u0005E\u0013aF\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H)\u0019;b\u0013\u0011\ty&!\u0019\u0003\u001d\r\u0013X-\u0019;bE2,Gk\u001c9jG*!\u00111LA)\u0011\u001d\t)'\u0007a\u0001\u0003'\tAA\\1nK\"9\u0011\u0011N\rA\u0002\u0005-\u0014!\u00048v[B\u000b'\u000f^5uS>t7\u000fE\u0002%\u0003[J1!a\u001c&\u0005\rIe\u000e\u001e\u0005\b\u0003gJ\u0002\u0019AA;\u0003!a\u0017N\\6OC6,\u0007#\u0002\u0013\u0002x\u0005M\u0011bAA=K\t1q\n\u001d;j_:Dq!! \u001a\u0001\u0004\t)(A\u0006nSJ\u0014xN\u001d+pa&\u001c\u0007")
public class ClusterLinkUtilsTest {
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    }, true);
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    public ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @Test
    public void testValidLinkNames() {
        String assertValid$1_linkName = "ABCXYZ.abcxyz-0123456789_";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName);
        Object var1_1 = null;
        String assertValid$1_linkName2 = "...";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName2);
        Object var2_2 = null;
        String assertValid$1_linkName3 = "_.-";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName3);
        Object var3_3 = null;
        String assertValid$1_linkName4 = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0123456789"), 20);
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName4);
    }

    @Test
    public void testInvalidLinkNames() {
        ClusterLinkUtilsTest.assertInvalid$1(null);
        ClusterLinkUtilsTest.assertInvalid$1("");
        ClusterLinkUtilsTest.assertInvalid$1(".");
        ClusterLinkUtilsTest.assertInvalid$1("..");
        ClusterLinkUtilsTest.assertInvalid$1("test/link");
        ClusterLinkUtilsTest.assertInvalid$1("test:link");
        ClusterLinkUtilsTest.assertInvalid$1("test\\link");
        ClusterLinkUtilsTest.assertInvalid$1("test\nlink");
        ClusterLinkUtilsTest.assertInvalid$1("test\tlink");
        ClusterLinkUtilsTest.assertInvalid$1(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0123456789"), 30));
    }

    @Test
    public void testValidateMirrorProps() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true")}))));
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props);
    }

    @Test
    public void testValidateMirrorPropsEmpty() {
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", new Properties());
    }

    @Test
    public void testValidateInvalidMirrorProps() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact")}))));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testValidateInvalidMirrorPropsSynonym() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanupPolicyProp()), (Object)"compact")}))));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testInitMirrorProps() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple3((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)LogConfig$.MODULE$.PreferTierFetchMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple3((Object)LogConfig$.MODULE$.SegmentMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)LogConfig$.MODULE$.SegmentBytesProp(), (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true")}))));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test");
        Assertions.assertEquals((Object)this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"10485760")})))), (Object)newLocalProps);
    }

    @Test
    public void testInitMirrorPropsLocalAlways() {
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact")}))));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> new MirrorTopicConfigsDelegate(localProps, this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())), this.topicConfigSyncRules()).initMirrorProps("test"));
    }

    @Test
    public void testInitMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        Properties localProps = new Properties();
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test").isEmpty());
    }

    @Test
    public void testUpdateMirrorProps() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple3((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)LogConfig$.MODULE$.PreferTierFetchMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple3((Object)LogConfig$.MODULE$.SegmentMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)LogConfig$.MODULE$.SegmentBytesProp(), (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"delete"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"524288"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentMsProp()), (Object)"200000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"1048576")}))));
        Properties expectedLocalProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"10485760"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentMsProp()), (Object)"200000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"1048576")}))));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test");
        Assertions.assertEquals((Object)expectedLocalProps, (Object)newLocalProps);
    }

    @Test
    public void testUpdateMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"another.bad.config.key"), (Object)"23456")}))));
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test").isEmpty());
    }

    @Test
    public void testResolveCreateTopicStandard() {
        Properties configs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true")}))));
        CreateTopicsRequestData.CreatableTopic topic = this.makeCreatableTopic("test-topic", 4, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        ClusterLinkUtils.ResolveCreateTopic result = ClusterLinkUtils$.MODULE$.resolveCreateTopic(topic, (Option)None$.MODULE$, configs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, "");
        Assertions.assertEquals((Object)configs, (Object)result.configs());
        Assertions.assertTrue((boolean)result.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopic() {
        UUID linkId = UUID.randomUUID();
        Properties configs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true")}))));
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
        Properties expectedConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact")}))));
        ClusterLinkUtils.ResolveCreateTopic result1 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, true, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, "");
        Assertions.assertEquals((Object)configs, (Object)result1.configs());
        Assertions.assertTrue((boolean)result1.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result1.numPartitions());
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{node}))).asJava();
        List partitionInfos = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, node, nodeList, nodeList), new TopicPartitionInfo(1, node, nodeList, nodeList), new TopicPartitionInfo(2, node, nodeList, nodeList)}));
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, remoteConfig));
        ClusterLinkUtils.ResolveCreateTopic result2 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        Assertions.assertEquals((Object)expectedConfigs, (Object)result2.configs());
        Assertions.assertTrue((boolean)(result2.topicState().get() instanceof ClusterLinkTopicState.Mirror));
        Assertions.assertEquals((Object)"link-name", (Object)((ClusterLinkTopicState)result2.topicState().get()).linkName());
        Assertions.assertEquals((int)3, (int)result2.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopicErrors() {
        String topic = "test-topic";
        String linkName = "link-name";
        UUID linkId = UUID.randomUUID();
        Properties validConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true")}))));
        Properties invalidConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact")}))));
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[]{node}))).asJava();
        List partitionInfos = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, node, nodeList, nodeList), new TopicPartitionInfo(1, node, nodeList, nodeList), new TopicPartitionInfo(2, node, nodeList, nodeList)}));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)None$.MODULE$), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, 4, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)"different-topic")), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(UnsupportedVersionException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), invalidConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new TimeoutException("timeout"));
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        }, ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos).asJava());
            CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
            future.complete(new ClusterLinkTopicInfo(description, this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        Assertions.assertEquals((Object)((ClusterLinkNotFoundException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
            TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)authorizedOperations).asJava());
            CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
            future.complete(new ClusterLinkTopicInfo(description, this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)None$.MODULE$, validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        }, ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291))).getMessage(), (Object)new StringBuilder(41).append("Cluster link with name '").append(linkName).append("' does not exist.").toString());
    }

    @Test
    public void testValidateCreatePartitions() {
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, true, (Option)None$.MODULE$);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        future.complete(BoxesRunTime.boxToInteger((int)3));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some(future));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)new Some(future));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 4, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
    }

    @Test
    public void testFilter() {
        ClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$1("fooLiteral", PatternType.LITERAL, "include");
        ClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$1("bar", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo barExclude = ClusterLinkUtilsTest.filterInfo$1("barExclude", PatternType.PREFIXED, "exclude");
        ClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$1("baz", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo bazExclude = ClusterLinkUtilsTest.filterInfo$1("bazExclude", PatternType.LITERAL, "exclude");
        scala.collection.immutable.Seq filters = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude, baz, bazExclude}));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters)._2()).toSet());
        scala.collection.immutable.Seq filters2 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "include")})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters2)._2()).toSet());
        scala.collection.immutable.Seq filters3 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "exclude")})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters3)._2()).toSet());
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("bar"));
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("barInclude"));
        Assertions.assertFalse((boolean)bar.matchesIncludeOrExclude("foo"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExclude"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExcluded"));
        Assertions.assertFalse((boolean)barExclude.matchesIncludeOrExclude("foo"));
    }

    @Test
    public void testDynamicLogger() {
        RuntimeException e1 = new RuntimeException("runtime exception");
        IllegalStateException e2 = new IllegalStateException("illegal state");
        IllegalArgumentException e3 = new IllegalArgumentException("illegal arg");
        scala.collection.immutable.Seq exceptions = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RuntimeException[]{e1, e2, e3}));
        scala.collection.mutable.Map errorCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map debugCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map warnCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Logging logging = new Logging(null, errorCounts, debugCounts, warnCounts){
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final scala.collection.mutable.Map errorCounts$1;
            private final scala.collection.mutable.Map debugCounts$1;
            private final scala.collection.mutable.Map warnCounts$1;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.errorCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.errorCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.debugCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.debugCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.warnCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.warnCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }
            {
                this.errorCounts$1 = errorCounts$1;
                this.debugCounts$1 = debugCounts$1;
                this.warnCounts$1 = warnCounts$1;
            }
        };
        ClusterLinkDynamicLogger dynamicLogger = new ClusterLinkDynamicLogger(logging, 4, 2, 50);
        ClusterLinkUtilsTest.clearCounts$1(exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> dynamicLogger.error(e1.getMessage(), (Throwable)e1));
            ClusterLinkUtilsTest.verifyCounts$1(e1, 4, 0, 6, errorCounts, warnCounts, debugCounts, dynamicLogger);
            ClusterLinkUtilsTest.clearCounts$1(exceptions, errorCounts, debugCounts, warnCounts);
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                int n = i % 2;
                switch (n) {
                    case 0: {
                        dynamicLogger.error(e1.getMessage(), (Throwable)e1);
                        return;
                    }
                    case 1: {
                        dynamicLogger.error(e2.getMessage(), (Throwable)e2);
                        return;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            });
            ClusterLinkUtilsTest.verifyCounts$1(e1, 4, 0, 6, errorCounts, warnCounts, debugCounts, dynamicLogger);
            ClusterLinkUtilsTest.verifyCounts$1(e2, 4, 0, 6, errorCounts, warnCounts, debugCounts, dynamicLogger);
            ClusterLinkUtilsTest.clearCounts$1(exceptions, errorCounts, debugCounts, warnCounts);
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dynamicLogger.error(new StringBuilder(5).append("test ").append(i).toString(), (Throwable)e1));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1(exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dynamicLogger.error("test", (Throwable)new RuntimeException(new StringBuilder(5).append("test ").append(i).toString(), e1)));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1(exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int n = i % 3;
            switch (n) {
                case 0: {
                    dynamicLogger.error("test", (Throwable)e1);
                    return;
                }
                case 1: {
                    dynamicLogger.error("test", (Throwable)e2);
                    return;
                }
                case 2: {
                    dynamicLogger.error("test", (Throwable)e3);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        });
        exceptions.foreach((Function1 & Serializable)e -> {
            ClusterLinkUtilsTest.verifyCounts$1(e, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
            return BoxedUnit.UNIT;
        });
        dynamicLogger.resetErrors();
        ClusterLinkUtilsTest.clearCounts$1(exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> dynamicLogger.error(e1.getMessage(), (Throwable)e1));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> dynamicLogger.error(e2.getMessage(), (Throwable)e2));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 4, 2, 94, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.verifyCounts$1(e2, 4, 4, 192, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1(exceptions, errorCounts, debugCounts, warnCounts);
    }

    private Config makeConfig(scala.collection.immutable.Seq<Tuple3<String, String, Object>> entries) {
        scala.collection.immutable.Seq configEntries = (scala.collection.immutable.Seq)entries.map((Function1 & Serializable)entry -> {
            ConfigEntry.ConfigSource source = BoxesRunTime.unboxToBoolean((Object)entry._3()) ? ConfigEntry.ConfigSource.DEFAULT_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
            return new ConfigEntry((String)entry._1(), (String)entry._2(), source, false, false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava(), ConfigEntry.ConfigType.UNKNOWN, null);
        });
        return new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)configEntries).asJavaCollection());
    }

    /*
     * WARNING - void declaration
     */
    private Properties makeProperties(scala.collection.immutable.Seq<Tuple2<String, String>> entries) {
        void var2_2;
        Properties props = new Properties();
        entries.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(name, value);
            return object;
        });
        return var2_2;
    }

    private CreateTopicsRequestData.CreatableTopic makeCreatableTopic(String name, int numPartitions, Option<String> linkName, Option<String> mirrorTopic) {
        return new CreateTopicsRequestData.CreatableTopic().setName(name).setNumPartitions(numPartitions).setReplicationFactor((short)3).setLinkName((String)linkName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setMirrorTopic((String)mirrorTopic.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final void assertValid$1(String linkName) {
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
    }

    private static final void assertInvalid$1(String linkName) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateLinkName(linkName), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    private static final ClusterLinkFilterInfo filterInfo$1(String name, PatternType patternType, String filterType) {
        return new ClusterLinkFilterInfo(name, patternType, filterType, new ClusterLinkFilter(name, patternType.name(), filterType));
    }

    private static final scala.collection.immutable.Set filter$1(scala.collection.immutable.Set items, scala.collection.immutable.Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilter(items, filters)._1();
    }

    private static final void clearCounts$1(scala.collection.immutable.Seq exceptions$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map debugCounts$1, scala.collection.mutable.Map warnCounts$1) {
        exceptions$1.foreach((Function1 & Serializable)e -> {
            errorCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
            debugCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
            return (scala.collection.mutable.Map)warnCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
        });
    }

    private static final void verifyCounts$1(Throwable e, int expectedErrors, int expectedWarn, int expectedDebug, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, ClusterLinkDynamicLogger dynamicLogger$1) {
        Assertions.assertEquals((int)expectedErrors, (int)BoxesRunTime.unboxToInt((Object)errorCounts$1.apply(e.getClass())), (String)"Incorrect error count");
        Assertions.assertEquals((int)expectedWarn, (int)BoxesRunTime.unboxToInt((Object)warnCounts$1.apply(e.getClass())), (String)"Incorrect warn count");
        Assertions.assertEquals((int)expectedDebug, (int)BoxesRunTime.unboxToInt((Object)debugCounts$1.apply(e.getClass())), (String)"Incorrect debug count");
        dynamicLogger$1.resetErrors();
    }
}

