/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.log.AbortedTxn;
import kafka.log.MergedLog$;
import kafka.tier.Generators$;
import kafka.tier.OffsetRange;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierAbortedTxnReader;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.scalacheck.Arbitrary;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.Prop;
import org.scalacheck.Prop$;
import org.scalacheck.Shrink;
import org.scalacheck.Shrink$;
import org.scalacheck.Test;
import org.scalacheck.util.Buildable$;
import org.scalacheck.util.Pretty;
import org.scalacheck.util.Pretty$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.anyvals.PosInt;
import org.scalactic.anyvals.PosInt$;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscarded$;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MaxSize$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfig$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.CheckerAsserting$;
import org.scalatestplus.scalacheck.Checkers;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration$InternalPropertyCheckConfiguration$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Tag(value="propertybased")
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\t\u0012\u0001YAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\rC\u0006\u0003\u00046\u0001\u0001\u0006I!\f\u0005\bm\u0001\u0011\r\u0011b\u00038\u0011\u0019q\u0005\u0001)A\u0005q!9q\n\u0001b\u0001\n\u0017\u0001\u0006BB-\u0001A\u0003%\u0011\u000bC\u0003[\u0001\u0011\u00051\fC\u0003l\u0001\u0011%A\u000eC\u0003s\u0001\u0011%1\u000fC\u0003v\u0001\u0011\u00051\fC\u0003x\u0001\u0011\u00051\fC\u0003z\u0001\u0011%!\u0010C\u0004\u0002\f\u0001!I!!\u0004\t\r\u0005\u0015\u0002\u0001\"\u0001\\\u0005\u0001\"\u0016.\u001a:BE>\u0014H/\u001a3Uq:\u0014V-\u00193feB\u0013x\u000e]3sif$Vm\u001d;\u000b\u0005I\u0019\u0012\u0001\u0002;jKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001qc\b\t\u00031ui\u0011!\u0007\u0006\u00035m\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003q\t1a\u001c:h\u0013\tq\u0012D\u0001\u0005Gk:\u001cV/\u001b;f!\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0006tG\u0006d\u0017m\u00195fG.T!\u0001J\u000e\u0002\u001bM\u001c\u0017\r\\1uKN$\b\u000f\\;t\u0013\t1\u0013E\u0001\u0005DQ\u0016\u001c7.\u001a:t\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t\u0011#A\u000bhK:,'/\u0019;pe\u0012\u0013\u0018N^3o\u0007>tg-[4\u0016\u00035\u0002\"AL\u0018\u000e\u0003\u0001I!\u0001M\u0019\u00035A\u0013x\u000e]3sif\u001c\u0005.Z2l\u0007>tg-[4ve\u0006$\u0018n\u001c8\n\u0005I\u001a$!D\"p]\u001aLw-\u001e:bi&|gN\u0003\u000253\u0005!\u0001O]8q\u0003Y9WM\\3sCR|'\u000f\u0012:jm\u0016t7i\u001c8gS\u001e\u0004\u0013aD1sE>3gm]3u%\u0006tw-Z:\u0016\u0003a\u00022!O\u001e>\u001b\u0005Q$B\u0001\u0012\u001c\u0013\ta$HA\u0005Be\nLGO]1ssB\u0019a\bS&\u000f\u0005}*eB\u0001!D\u001b\u0005\t%B\u0001\"\u0016\u0003\u0019a$o\\8u}%\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u000f\u00069\u0001/Y2lC\u001e,'\"\u0001#\n\u0005%S%aA*fc*\u0011ai\u0012\t\u0003U1K!!T\t\u0003\u0017=3gm]3u%\u0006tw-Z\u0001\u0011CJ\u0014wJ\u001a4tKR\u0014\u0016M\\4fg\u0002\na\"\u0019:c\u0003\n|'\u000f^3e)bt7/F\u0001R!\rI4H\u0015\t\u0004}!\u001b\u0006C\u0001+X\u001b\u0005)&B\u0001,\u0014\u0003\rawnZ\u0005\u00031V\u0013!\"\u00112peR,G\r\u0016=o\u0003=\t'OY!c_J$X\r\u001a+y]N\u0004\u0013\u0001\u0006;fgR|eMZ:fiNluN\\8u_:L7\rF\u0001]!\tif,D\u0001H\u0013\tyvI\u0001\u0003V]&$\bF\u0001\u0005b!\t\u0011\u0017.D\u0001d\u0015\t!W-A\u0002ba&T!AZ4\u0002\u000f),\b/\u001b;fe*\u0011\u0001nG\u0001\u0006UVt\u0017\u000e^\u0005\u0003U\u000e\u0014A\u0001V3ti\u0006!2\r[3dW\u0016k\u0007\u000f^=Pe:{g.R7qif$\"!\u001c9\u0011\u0005er\u0017BA8;\u0005\u0011\u0001&o\u001c9\t\u000bEL\u0001\u0019\u0001*\u0002\u0017\u0005\u0014wN\u001d;fIRChn]\u0001\u0014G\",7m\u001b*fC\u0012\fE\u000e\\'be.,'o\u001d\u000b\u0003[RDQ!\u001d\u0006A\u0002I\u000b!\u0005^3tiN+'/[1mSjLgnZ!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\bFA\u0006b\u0003\t\"Xm\u001d;M_\u000e\fG/Z*qK\u000eLg-[2Ue\u0006t7/Y2uS>t'+\u00198hK\"\u0012A\"Y\u0001\u001cO\u0016tgj\u001c8TKF,XM\u001c;jC2\f%m\u001c:uK\u0012$\u0006P\\:\u0015\tmt\u0018q\u0001\t\u0004sq\u001c\u0016BA?;\u0005\r9UM\u001c\u0005\u0007\u007f6\u0001\r!!\u0001\u0002\u000bM$\u0018M\u001d;\u0011\u0007u\u000b\u0019!C\u0002\u0002\u0006\u001d\u00131!\u00138u\u0011\u001d\tI!\u0004a\u0001\u0003\u0003\t1!\u001a8e\u0003E\t'm\u001c:uK\u0012$\u0006P\\%o%\u0006tw-\u001a\u000b\u0007\u0003\u001f\tY\"a\t\u0011\ru\u000b\tbUA\u000b\u0013\r\t\u0019b\u0012\u0002\n\rVt7\r^5p]F\u00022!XA\f\u0013\r\tIb\u0012\u0002\b\u0005>|G.Z1o\u0011\u0019yh\u00021\u0001\u0002\u001eA\u0019Q,a\b\n\u0007\u0005\u0005rI\u0001\u0003M_:<\u0007bBA\u0005\u001d\u0001\u0007\u0011QD\u0001%i\u0016\u001cHOT8o'\u0016\fX/\u001a8uS\u0006d\u0017IY8si\u0016$GK]1og\u0006\u001cG/[8og\"\u0012q\"\u0019\u0015\b\u0001\u0005-\u0012\u0011GA\u001a!\r\u0011\u0017QF\u0005\u0004\u0003_\u0019'a\u0001+bO\u0006)a/\u00197vK\u0006\u0012\u0011QG\u0001\u000eaJ|\u0007/\u001a:us\n\f7/\u001a3")
public class TierAbortedTxnReaderPropertyTest
extends FunSuite
implements Checkers {
    private final Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private final Arbitrary<scala.collection.immutable.Seq<OffsetRange>> arbOffsetRanges;
    private final Arbitrary<scala.collection.immutable.Seq<AbortedTxn>> arbAbortedTxns;
    private volatile ScalaCheckConfiguration$InternalPropertyCheckConfiguration$ InternalPropertyCheckConfiguration$module;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$PropertyCheckConfig$ PropertyCheckConfig$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscarded$ MaxDiscarded$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$MaxSize$ MaxSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;

    public <A1, P, ASSERTION> Object check(Function1<A1, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, P, ASSERTION> Object check(Function2<A1, A2, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, P, ASSERTION> Object check(Function3<A1, A2, A3, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, P, ASSERTION> Object check(Function4<A1, A2, A3, A4, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, A5, P, ASSERTION> Object check(Function5<A1, A2, A3, A4, A5, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, Arbitrary<A5> a5, Shrink<A5> s5, Function1<A5, Pretty> pp5, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, a5, s5, pp5, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, A5, A6, P, ASSERTION> Object check(Function6<A1, A2, A3, A4, A5, A6, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, Arbitrary<A5> a5, Shrink<A5> s5, Function1<A5, Pretty> pp5, Arbitrary<A6> a6, Shrink<A6> s6, Function1<A6, Pretty> pp6, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, a5, s5, pp5, a6, s6, pp6, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <ASSERTION> Object check(Prop p, Test.Parameters prms, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, (Prop)p, (Test.Parameters)prms, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <ASSERTION> Object check(Prop p, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, (Prop)p, configParams, (Configuration.PropertyCheckConfigurable)config, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Configuration.PropertyCheckConfiguration PropertyCheckConfig2PropertyCheckConfiguration(Configuration.PropertyCheckConfig p) {
        return ScalaCheckConfiguration.PropertyCheckConfig2PropertyCheckConfiguration$((ScalaCheckConfiguration)this, (Configuration.PropertyCheckConfig)p);
    }

    public Test.Parameters getParams(scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable c) {
        return ScalaCheckConfiguration.getParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfigurable)c);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscarded maxDiscarded(int value) {
        return Configuration.maxDiscarded$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.MaxSize maxSize(int value) {
        return Configuration.maxSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public ScalaCheckConfiguration$InternalPropertyCheckConfiguration$ org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration() {
        if (this.InternalPropertyCheckConfiguration$module == null) {
            this.org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration$lzycompute$1();
        }
        return this.InternalPropertyCheckConfiguration$module;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$PropertyCheckConfig$ PropertyCheckConfig() {
        if (this.PropertyCheckConfig$module == null) {
            this.PropertyCheckConfig$lzycompute$1();
        }
        return this.PropertyCheckConfig$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscarded$ MaxDiscarded() {
        if (this.MaxDiscarded$module == null) {
            this.MaxDiscarded$lzycompute$1();
        }
        return this.MaxDiscarded$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$MaxSize$ MaxSize() {
        if (this.MaxSize$module == null) {
            this.MaxSize$lzycompute$1();
        }
        return this.MaxSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    private Arbitrary<scala.collection.immutable.Seq<OffsetRange>> arbOffsetRanges() {
        return this.arbOffsetRanges;
    }

    private Arbitrary<scala.collection.immutable.Seq<AbortedTxn>> arbAbortedTxns() {
        return this.arbAbortedTxns;
    }

    @Test
    public void testOffsetsMonotonic() {
        this.check(Prop$.MODULE$.forAll((Function1 & Serializable)offsets -> {
            ObjectRef result = ObjectRef.create((Object)Prop$.MODULE$.passed());
            ObjectRef lastEndOffset = ObjectRef.create((Object)None$.MODULE$);
            offsets.foreach((Function1 & Serializable)offsetRange -> {
                TierAbortedTxnReaderPropertyTest.$anonfun$testOffsetsMonotonic$2(lastEndOffset, result, offsetRange);
                return BoxedUnit.UNIT;
            });
            return (Prop)result.elem;
        }, Predef$.MODULE$.$conforms(), this.arbOffsetRanges(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory())), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).viewSeed("testOffsetsMonotonic"), (scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("TierAbortedTxnReaderPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
    }

    private Prop checkEmptyOrNonEmpty(scala.collection.immutable.Seq<AbortedTxn> abortedTxns) {
        Option abortedTxnsBuf = MergedLog$.MODULE$.serializeAbortedTransactions(abortedTxns);
        return Prop$.MODULE$.propBoolean(abortedTxnsBuf.isEmpty() && abortedTxns.isEmpty() || abortedTxnsBuf.nonEmpty() && abortedTxns.nonEmpty());
    }

    private Prop checkReadAllMarkers(scala.collection.immutable.Seq<AbortedTxn> abortedTxns) {
        return (Prop)MergedLog$.MODULE$.serializeAbortedTransactions(abortedTxns).map((Function1 & Serializable)abortedTxnBuf -> {
            ByteBufferInputStream inputStream = new ByteBufferInputStream(abortedTxnBuf);
            Buffer readMarkers = CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)CancellationContext.newContext(), (InputStream)inputStream, (long)0L, (long)Long.MAX_VALUE)).asScala();
            return Prop$.MODULE$.AnyOperators((Function0 & Serializable)() -> abortedTxns.toSet(), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).$eq$qmark((Object)readMarkers.toSet());
        }).getOrElse((Function0 & Serializable)() -> Prop$.MODULE$.undecided());
    }

    @Test
    public void testSerializingAbortedTransactions() {
        this.check(Prop$.MODULE$.forAll((Function1 & Serializable)abortedTxns -> this.checkReadAllMarkers((scala.collection.immutable.Seq<AbortedTxn>)abortedTxns).$amp$amp((Function0 & Serializable)() -> this.checkEmptyOrNonEmpty((scala.collection.immutable.Seq<AbortedTxn>)abortedTxns)), Predef$.MODULE$.$conforms(), this.arbAbortedTxns(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory())), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).viewSeed("testSerializingAbortedTransactions"), (scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("TierAbortedTxnReaderPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    @Test
    public void testLocateSpecificTransactionRange() {
        this.check(Prop$.MODULE$.forAll(Generators$.MODULE$.abortedTransactionGen().suchThat((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).flatMap((Function1 & Serializable)abortedTxns -> Gen$.MODULE$.pick(1, (Iterable)abortedTxns).map((Function1 & Serializable)x$2 -> (AbortedTxn)x$2.head()).flatMap((Function1 & Serializable)pick -> Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)pick.firstOffset()), (Object)BoxesRunTime.boxToLong((long)pick.lastOffset()), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).flatMap((Function1 & Serializable)startOffset -> TierAbortedTxnReaderPropertyTest.$anonfun$testLocateSpecificTransactionRange$5(pick, abortedTxns, BoxesRunTime.unboxToLong((Object)startOffset))))), (Function1 & Serializable)x0$1 -> {
            long lastOffset;
            long startOffset;
            AbortedTxn guaranteedItem;
            scala.collection.immutable.Seq abortedTxns;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    abortedTxns = (scala.collection.immutable.Seq)x0$1._1();
                    guaranteedItem = (AbortedTxn)x0$1._2();
                    startOffset = BoxesRunTime.unboxToLong((Object)x0$1._3());
                    lastOffset = BoxesRunTime.unboxToLong((Object)x0$1._4());
                    if (abortedTxns != null && guaranteedItem != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            ByteBuffer buffer = (ByteBuffer)MergedLog$.MODULE$.serializeAbortedTransactions((Seq)abortedTxns).get();
            ByteBufferInputStream inputStream = new ByteBufferInputStream(buffer);
            Buffer readAbortedTransactions = CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)CancellationContext.newContext(), (InputStream)inputStream, (long)startOffset, (long)lastOffset)).asScala();
            Object[] objectArray = new Prop[1];
            readAbortedTransactions.contains((Object)guaranteedItem);
            readAbortedTransactions.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierAbortedTxnReaderPropertyTest.$anonfun$testLocateSpecificTransactionRange$8(lastOffset, x$3)));
            objectArray[0] = Prop$.MODULE$.propBoolean(!readAbortedTransactions.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierAbortedTxnReaderPropertyTest.$anonfun$testLocateSpecificTransactionRange$9(startOffset, x$4))));
            Prop prop = Prop$.MODULE$.all((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return prop;
        }, Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkTuple4(Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory())), Shrink$.MODULE$.shrinkAny(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$)), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)), (scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("TierAbortedTxnReaderPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }

    private Gen<AbortedTxn> genNonSequentialAbortedTxns(int start, int end) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)(end - 1)), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)firstOffset -> TierAbortedTxnReaderPropertyTest.$anonfun$genNonSequentialAbortedTxns$1(end, BoxesRunTime.unboxToInt((Object)firstOffset)));
    }

    private Function1<AbortedTxn, Object> abortedTxnInRange(long start, long end) {
        return (Function1 & Serializable)abortedTxn -> BoxesRunTime.boxToBoolean((boolean)TierAbortedTxnReaderPropertyTest.$anonfun$abortedTxnInRange$1(start, end, abortedTxn));
    }

    @Test
    public void testNonSequentialAbortedTransactions() {
        this.check(Prop$.MODULE$.forAll(Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1000), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)rangeStart -> TierAbortedTxnReaderPropertyTest.$anonfun$testNonSequentialAbortedTransactions$1(this, BoxesRunTime.unboxToInt((Object)rangeStart))), (Function1 & Serializable)x0$1 -> {
            Prop prop;
            if (x0$1 == null) throw new MatchError(x0$1);
            int fetchStart = BoxesRunTime.unboxToInt((Object)x0$1._1());
            int fetchEnd = BoxesRunTime.unboxToInt((Object)x0$1._2());
            scala.collection.immutable.Seq abortedTxns = (scala.collection.immutable.Seq)x0$1._3();
            if (abortedTxns == null) throw new MatchError(x0$1);
            if (abortedTxns.isEmpty()) {
                prop = Prop$.MODULE$.undecided();
                return prop;
            } else {
                ByteBuffer buffer = (ByteBuffer)MergedLog$.MODULE$.serializeAbortedTransactions((Seq)abortedTxns).get();
                ByteBufferInputStream inputStream = new ByteBufferInputStream(buffer);
                List readAbortedTxns = TierAbortedTxnReader.readInto((CancellationContext)CancellationContext.newContext(), (InputStream)inputStream, (long)fetchStart, (long)fetchEnd);
                scala.collection.immutable.Seq expectedAbortedTxns = (scala.collection.immutable.Seq)abortedTxns.filter(this.abortedTxnInRange(fetchStart, fetchEnd));
                prop = Prop$.MODULE$.AnyOperators((Function0 & Serializable)() -> expectedAbortedTxns.toSet(), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).$eq$qmark((Object)CollectionConverters$.MODULE$.ListHasAsScala(readAbortedTxns).asScala().toSet());
            }
            return prop;
        }, Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkTuple3(Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory()))), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).viewSeed("testNonSequentialAbortedTransactions"), (scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("TierAbortedTxnReaderPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }

    private final void org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration$lzycompute$1() {
        synchronized (this) {
            if (this.InternalPropertyCheckConfiguration$module == null) {
                this.InternalPropertyCheckConfiguration$module = new ScalaCheckConfiguration$InternalPropertyCheckConfiguration$((ScalaCheckConfiguration)this);
            }
            return;
        }
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        synchronized (this) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
            return;
        }
    }

    private final void PropertyCheckConfig$lzycompute$1() {
        synchronized (this) {
            if (this.PropertyCheckConfig$module == null) {
                this.PropertyCheckConfig$module = new Configuration$PropertyCheckConfig$((Configuration)this);
            }
            return;
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        synchronized (this) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxDiscarded$lzycompute$1() {
        synchronized (this) {
            if (this.MaxDiscarded$module == null) {
                this.MaxDiscarded$module = new Configuration$MaxDiscarded$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        synchronized (this) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
            return;
        }
    }

    private final void MinSize$lzycompute$1() {
        synchronized (this) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxSize$lzycompute$1() {
        synchronized (this) {
            if (this.MaxSize$module == null) {
                this.MaxSize$module = new Configuration$MaxSize$((Configuration)this);
            }
            return;
        }
    }

    private final void SizeRange$lzycompute$1() {
        synchronized (this) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
            return;
        }
    }

    private final void Workers$lzycompute$1() {
        synchronized (this) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testOffsetsMonotonic$2(ObjectRef lastEndOffset$1, ObjectRef result$1, OffsetRange offsetRange) {
        Option option = (Option)lastEndOffset$1.elem;
        if (option instanceof Some) {
            if (BoxesRunTime.unboxToLong((Object)((Some)option).value()) > offsetRange.startOffset()) {
                result$1.elem = Prop$.MODULE$.falsified();
                return;
            }
            lastEndOffset$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)offsetRange.endOffset()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            lastEndOffset$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)offsetRange.endOffset()));
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ Tuple4 $anonfun$testLocateSpecificTransactionRange$6(scala.collection.immutable.Seq abortedTxns$3, AbortedTxn pick$1, long startOffset$1, long endOffset) {
        return new Tuple4((Object)abortedTxns$3, (Object)pick$1, (Object)BoxesRunTime.boxToLong((long)startOffset$1), (Object)BoxesRunTime.boxToLong((long)endOffset));
    }

    public static final /* synthetic */ Gen $anonfun$testLocateSpecificTransactionRange$5(AbortedTxn pick$1, scala.collection.immutable.Seq abortedTxns$3, long startOffset) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)(pick$1.lastOffset() + 1L)), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).map((Function1 & Serializable)endOffset -> TierAbortedTxnReaderPropertyTest.$anonfun$testLocateSpecificTransactionRange$6(abortedTxns$3, pick$1, startOffset, BoxesRunTime.unboxToLong((Object)endOffset)));
    }

    public static final /* synthetic */ boolean $anonfun$testLocateSpecificTransactionRange$8(long x5$1, AbortedTxn x$3) {
        return x$3.firstOffset() > x5$1;
    }

    public static final /* synthetic */ boolean $anonfun$testLocateSpecificTransactionRange$9(long x4$1, AbortedTxn x$4) {
        return x$4.lastOffset() < x4$1;
    }

    public static final /* synthetic */ AbortedTxn $anonfun$genNonSequentialAbortedTxns$3(int firstOffset$1, int lastOffset$1, int producerId) {
        return new AbortedTxn((long)producerId, (long)firstOffset$1, (long)lastOffset$1, 0L);
    }

    public static final /* synthetic */ Gen $anonfun$genNonSequentialAbortedTxns$2(int firstOffset$1, int lastOffset) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)5), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)producerId -> TierAbortedTxnReaderPropertyTest.$anonfun$genNonSequentialAbortedTxns$3(firstOffset$1, lastOffset, BoxesRunTime.unboxToInt((Object)producerId)));
    }

    public static final /* synthetic */ Gen $anonfun$genNonSequentialAbortedTxns$1(int end$1, int firstOffset) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)(firstOffset + 1)), (Object)BoxesRunTime.boxToInteger((int)end$1), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)lastOffset -> TierAbortedTxnReaderPropertyTest.$anonfun$genNonSequentialAbortedTxns$2(firstOffset, BoxesRunTime.unboxToInt((Object)lastOffset)));
    }

    public static final /* synthetic */ boolean $anonfun$abortedTxnInRange$1(long start$1, long end$2, AbortedTxn abortedTxn) {
        return start$1 <= abortedTxn.lastOffset() && abortedTxn.firstOffset() <= end$2;
    }

    public static final /* synthetic */ Tuple3 $anonfun$testNonSequentialAbortedTransactions$5(int fetchStart$1, scala.collection.immutable.Seq abortedTxn$1, int fetchEnd) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)fetchStart$1), (Object)BoxesRunTime.boxToInteger((int)fetchEnd), (Object)abortedTxn$1);
    }

    public static final /* synthetic */ Gen $anonfun$testNonSequentialAbortedTransactions$4(int rangeEnd$1, scala.collection.immutable.Seq abortedTxn$1, int fetchStart) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)(fetchStart + 1)), (Object)BoxesRunTime.boxToInteger((int)rangeEnd$1), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)fetchEnd -> TierAbortedTxnReaderPropertyTest.$anonfun$testNonSequentialAbortedTransactions$5(fetchStart, abortedTxn$1, BoxesRunTime.unboxToInt((Object)fetchEnd)));
    }

    public static final /* synthetic */ Gen $anonfun$testNonSequentialAbortedTransactions$2(TierAbortedTxnReaderPropertyTest $this, int rangeStart$1, int rangeEnd) {
        return Gen$.MODULE$.containerOf($this.genNonSequentialAbortedTxns(rangeStart$1, rangeEnd), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory()), Predef$.MODULE$.$conforms()).flatMap((Function1 & Serializable)abortedTxn -> Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)rangeStart$1), (Object)BoxesRunTime.boxToInteger((int)(rangeEnd - 1)), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)fetchStart -> TierAbortedTxnReaderPropertyTest.$anonfun$testNonSequentialAbortedTransactions$4(rangeEnd, abortedTxn, BoxesRunTime.unboxToInt((Object)fetchStart))));
    }

    public static final /* synthetic */ Gen $anonfun$testNonSequentialAbortedTransactions$1(TierAbortedTxnReaderPropertyTest $this, int rangeStart) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)1001), (Object)BoxesRunTime.boxToInteger((int)2000), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)rangeEnd -> TierAbortedTxnReaderPropertyTest.$anonfun$testNonSequentialAbortedTransactions$2($this, rangeStart, BoxesRunTime.unboxToInt((Object)rangeEnd)));
    }

    public TierAbortedTxnReaderPropertyTest() {
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        Checkers.$init$((Checkers)this);
        this.generatorDrivenConfig = new Configuration.PropertyCheckConfiguration((Configuration)this, ((PosInt)PosInt$.MODULE$.from(10000).get()).value(), this.PropertyCheckConfiguration().apply$default$2(), this.PropertyCheckConfiguration().apply$default$3(), this.PropertyCheckConfiguration().apply$default$4(), this.PropertyCheckConfiguration().apply$default$5());
        this.arbOffsetRanges = Arbitrary$.MODULE$.apply((Function0 & Serializable)() -> Generators$.MODULE$.offsetRangesGen(0L));
        this.arbAbortedTxns = Arbitrary$.MODULE$.apply((Function0 & Serializable)() -> Generators$.MODULE$.abortedTransactionGen());
    }
}

