/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.Defaults$;
import kafka.log.LocalLog$;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogTestUtils$;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.HostedPartition;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.AwaitingDeleteComplete$;
import kafka.tier.Config;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.MaterializationComplete$;
import kafka.tier.MaterializingState$;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierObjectGarbageCollector;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r}e\u0001\u0002\u001f>\u0001\tCQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004V\u0001\u0001\u0006Ia\u0014\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019q\u0006\u0001)A\u00051\"9q\f\u0001b\u0001\n\u0013\u0001\u0007BB4\u0001A\u0003%\u0011\rC\u0004i\u0001\t\u0007I\u0011B5\t\r5\u0004\u0001\u0015!\u0003k\u0011\u001dq\u0007A1A\u0005\n=DaA\u001e\u0001!\u0002\u0013\u0001\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007y\u0002\u0001\u000b\u0011B=\t\u000fu\u0004!\u0019!C\u0005}\"9\u0011\u0011\t\u0001!\u0002\u0013y\bbCA\"\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bB1\"!\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002P!Y\u00111\f\u0001A\u0002\u0003\u0005\u000b\u0015BA$\u0011%\ti\u0006\u0001b\u0001\n\u0013\ty\u0006\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA1\u0011%\t\u0019\b\u0001b\u0001\n\u0013\ty\u0006\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA1\u0011%\t9\b\u0001b\u0001\n\u0013\tI\b\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BA>\u0011%\t\u0019\n\u0001b\u0001\n\u0013\t)\n\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0011BAL\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!!/\u0001\t\u0003\tY\fC\u0004\u0002l\u0002!\t!!<\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0001b\u0002B\b\u0001\u0011\u0005!\u0011\u0003\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u00119\u0003\u0001C\u0001\u0005SAqAa\r\u0001\t\u0003\u0011)\u0004C\u0004\u0003@\u0001!\tA!\u0011\t\u000f\t-\u0003\u0001\"\u0001\u0003N!9!q\u000b\u0001\u0005\u0002\u0005\u0005\u0006b\u0002B1\u0001\u0011%!1\r\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011\u001d\u0011\u0019\u000b\u0001C\u0005\u0005KCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u00034\u0002!IA!.\t\u000f\t\u0005\b\u0001\"\u0003\u0003d\"9!q\u001d\u0001\u0005\n\t%\bb\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0005\u007f\u0004A\u0011BB\u0001\u0011%\u0019I\u0005AI\u0001\n\u0013\u0019Y\u0005C\u0005\u0004b\u0001\t\n\u0011\"\u0003\u0004d!I1q\r\u0001\u0012\u0002\u0013%1\u0011\u000e\u0005\n\u0007[\u0002\u0011\u0013!C\u0005\u0007SB\u0011ba\u001c\u0001#\u0003%Ia!\u001d\t\u0013\rU\u0004!%A\u0005\n\r]\u0004\"CB>\u0001E\u0005I\u0011BB?\u0011%\u0019\t\tAI\u0001\n\u0013\u0019iH\u0002\u0004\u0004\u0004\u0002!1Q\u0011\u0005\u0007\u0013b\"\ta!$\t\u000f\t\u0005\b\b\"\u0011\u0004\u0014\"91\u0011\u0014\u001d\u0005B\rm%\u0001\n+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J$Vm\u001d;\u000b\u0005yz\u0014\u0001\u0002;jKJT\u0011\u0001Q\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\t\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0003\"\u0001\u0014\u0001\u000e\u0003u\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011v(\u0001\u0004tKJ4XM]\u0005\u0003)F\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003E!\u0018.\u001a:U_BL7mQ8ogVlWM]\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111,P\u0001\u0006i>\u0004\u0018nY\u0005\u0003;j\u0013\u0011\u0003V5feR{\u0007/[2D_:\u001cX/\\3s\u0003I!\u0018.\u001a:U_BL7mQ8ogVlWM\u001d\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013R\u0003!iW\r^1eCR\f\u0017B\u00014d\u0005IY%+\u00194u\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005\u0001B/[3s)>\u0004\u0018nY'b]\u0006<WM]\u000b\u0002UB\u0011\u0011l[\u0005\u0003Yj\u0013\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002#QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\b%\u0001\u0003uS6,W#\u00019\u0011\u0005E$X\"\u0001:\u000b\u0005M|\u0014!B;uS2\u001c\u0018BA;s\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005I\bCA9{\u0013\tY(OA\u0007N_\u000e\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013!\u0004;jKJ,Gm\u00142kK\u000e$8/F\u0001\u0000!!\t\t!a\u0003\u0002\u0010\u0005UQBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011B#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u000e\u0005\r!aA'baB\u0019A*!\u0005\n\u0007\u0005MQH\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]B1\u0011qCA\u0014\u0003[qA!!\u0007\u0002$9!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \u0005\u000ba\u0001\u0010:p_Rt\u0014\"\u0001$\n\u0007\u0005\u0015R)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00121\u0006\u0002\u0005\u0019&\u001cHOC\u0002\u0002&\u0015\u0003B!a\f\u0002<9!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026u\nQa\u001d;pe\u0016LA!!\u000f\u00024\u0005yA+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0003\u0003\u0002>\u0005}\"AD(cU\u0016\u001cG/T3uC\u0012\fG/\u0019\u0006\u0005\u0003s\t\u0019$\u0001\buS\u0016\u0014X\rZ(cU\u0016\u001cGo\u001d\u0011\u00029\u0011,G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;peV\u0011\u0011q\t\t\u0004\u0019\u0006%\u0013bAA&{\t\u0001C+[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s\u0003\u0001\"W\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J|F%Z9\u0015\t\u0005E\u0013q\u000b\t\u0004\t\u0006M\u0013bAA+\u000b\n!QK\\5u\u0011%\tI&EA\u0001\u0002\u0004\t9%A\u0002yIE\nQ\u0004Z3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'\u000fI\u0001\u0004I&\u0014XCAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\n!![8\u000b\u0005\u0005-\u0014\u0001\u00026bm\u0006LA!a\u001c\u0002f\t!a)\u001b7f\u0003\u0011!\u0017N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\n!\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u00111\u0010\t\u0005\u0003{\ni)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003\u0019\u0019w.\\7p]*\u0019\u0001)!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0015aA8sO&!\u0011qRA@\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n\u0001#\u001b8ji&\fGNQ1dW>4g-T:\u0016\u0005\u0005]\u0005c\u0001#\u0002\u001a&\u0019\u00111T#\u0003\t1{gnZ\u0001\u0012S:LG/[1m\u0005\u0006\u001c7n\u001c4g\u001bN\u0004\u0013\u0001\u0003;fCJ$wn\u001e8\u0015\u0005\u0005E\u0003fA\u000e\u0002&B!\u0011qUA[\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016aA1qS*!\u0011qVAY\u0003\u001dQW\u000f]5uKJTA!a-\u0002\n\u0006)!.\u001e8ji&!\u0011qWAU\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u000buKN$\u0018J\\5uS\u0006$X\rR3mKRLwN\u001c\u000b\u0005\u0003#\ni\fC\u0004\u0002@r\u0001\r!!1\u0002\u001f!\f7\u000fV5fe>\u0013'.Z2u\u000f\u000e\u00032\u0001RAb\u0013\r\t)-\u0012\u0002\b\u0005>|G.Z1oQ\u001da\u0012\u0011ZAm\u00037\u0004B!a3\u0002V6\u0011\u0011Q\u001a\u0006\u0005\u0003\u001f\f\t.\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\t\u0019.!,\u0002\rA\f'/Y7t\u0013\u0011\t9.!4\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"\u0011Q\\Ap3\u0005\t\u0011$\u0001\u0001)\u0007q\t\u0019\u000f\u0005\u0003\u0002f\u0006\u001dXBAAi\u0013\u0011\tI/!5\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u000buKN$8i\\7qY\u0016$X\rR3mKRLwN\u001c\u000b\u0005\u0003#\ny\u000fC\u0004\u0002@v\u0001\r!!1)\u000fu\tI-!7\u0002t2\"\u0011Q\\ApQ\ri\u00121]\u0001\u0019i\u0016\u001cHOQ3hS:l\u0015\r^3sS\u0006d\u0017N_1uS>tG\u0003BA)\u0003wDq!a0\u001f\u0001\u0004\t\t\rK\u0004\u001f\u0003\u0013\fI.a@-\t\u0005u\u0017q\u001c\u0015\u0004=\u0005\r\u0018a\u0005;fgR$U\r\\3uKB\u000b'\u000f^5uS>tG\u0003BA)\u0005\u000fAq!a0 \u0001\u0004\t\t\rK\u0004 \u0003\u0013\fINa\u0003-\t\u0005u\u0017q\u001c\u0015\u0004?\u0005\r\u0018a\u0007;fgR$U\u000f\u001d7jG\u0006$X\rR3mKR,\u0017J\\5uS\u0006$X\r\u0006\u0003\u0002R\tM\u0001bBA`A\u0001\u0007\u0011\u0011\u0019\u0015\bA\u0005%\u0017\u0011\u001cB\fY\u0011\ti.a8)\u0007\u0001\n\u0019/A\u0018uKN$8i\u001c7mK\u000e$H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:XSRDwJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002R\t}\u0001bBA`C\u0001\u0007\u0011\u0011\u0019\u0015\bC\u0005%\u0017\u0011\u001cB\u0012Y\u0011\ti.a8)\u0007\u0005\n\u0019/\u0001\u0019uKN$8i\u001c7mK\u000e$H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:XSRDwJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c\u000b\u0005\u0003#\u0012Y\u0003C\u0004\u0002@\n\u0002\r!!1)\u000f\t\nI-!7\u000301\"\u0011Q\\ApQ\r\u0011\u00131]\u0001.i\u0016\u001cHoQ8mY\u0016\u001cG\u000fR3mKR,G\rU1si&$\u0018n\u001c8t/&$\bNT8oKB\u000b'\u000f^5uS>tG\u0003BA)\u0005oAq!a0$\u0001\u0004\t\t\rK\u0004$\u0003\u0013\fINa\u000f-\t\u0005u\u0017q\u001c\u0015\u0004G\u0005\r\u0018\u0001\u000e;fgR\u001cu\u000e\u001c7fGR$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn],ji\",U.[4sCRLwN\u001c#ve&twMU3bIR!\u0011\u0011\u000bB\"\u0011\u001d\ty\f\na\u0001\u0003\u0003Ds\u0001JAe\u00033\u00149\u0005\f\u0003\u0002^\u0006}\u0007f\u0001\u0013\u0002d\u0006\u0019B/Z:u%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011\u0011\u000bB(\u0011\u001d\ty,\na\u0001\u0003\u0003Ds!JAe\u00033\u0014\u0019\u0006\f\u0003\u0002^\u0006}\u0007fA\u0013\u0002d\u0006!B/Z:u\u000f\u0006\u0014(-Y4f\u0007>dG.Z2u_JD3A\nB.!\u0011\t9K!\u0018\n\t\t}\u0013\u0011\u0016\u0002\u0005)\u0016\u001cH/A\nde\u0016\fG/Z'fi\u0006$\u0017\r^1J[\u0006<W\r\u0006\u0004\u0003f\tE$\u0011\u0011\t\u0005\u0005O\u0012i'\u0004\u0002\u0003j)!!1NAB\u0003\u0015IW.Y4f\u0013\u0011\u0011yG!\u001b\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0011\u001d\u0011\u0019h\na\u0001\u0005k\n1\u0002^8qS\u000eLU.Y4fgB1\u0011q\u0003B<\u0005wJAA!\u001f\u0002,\t\u00191+Z9\u0011\t\t\u001d$QP\u0005\u0005\u0005\u007f\u0012IG\u0001\u0006U_BL7-S7bO\u0016DqAa!(\u0001\u0004\u0011))A\nj[\u0006<Wm\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\u0005\u0003\u0003\b\n5UB\u0001BE\u0015\u0011\u0011Y)a!\u0002\tI\fg\r^\u0005\u0005\u0005\u001f\u0013II\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\u00027Y,'/\u001b4z\t\u0016dW\r^3Qe\u0016Le.\u001b;jCR,7)\u00197m)\u0019\t\tF!&\u0003\u001a\"9!q\u0013\u0015A\u0002\u0005=\u0011\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\u0011Y\n\u000ba\u0001\u0005;\u000b1\u0002^5nKN\u001c\u0015\r\u001c7fIB\u0019AIa(\n\u0007\t\u0005VIA\u0002J]R\f\u0001D^3sS\u001aLH)\u001a7fi\u0016Le.\u001b;jCR,7)\u00197m)\u0019\t\tFa*\u0003*\"9!qS\u0015A\u0002\u0005=\u0001b\u0002BNS\u0001\u0007!QT\u0001'GJ,\u0017\r^3US\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014H\u0003BA)\u0005_CqA!-+\u0001\u0004\t\t-A\tiCN$\u0016.\u001a:fI>\u0013'.Z2u\u000f\u000e\u000bQ#\u001b8ji&\fG/Z*fO6,g\u000e^+qY>\fG\r\u0006\u0007\u00038\n\r'Q\u0019Be\u00053\u0014i\u000e\u0005\u0003\u0003:\n}VB\u0001B^\u0015\u0011\u0011i,a \u0002\rI,7m\u001c:e\u0013\u0011\u0011\tMa/\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\u00119j\u000ba\u0001\u0003\u001fAqAa2,\u0001\u0004\u0011i*A\u0006mK\u0006$WM]#q_\u000eD\u0007b\u0002BfW\u0001\u0007!QZ\u0001\t_\nTWm\u0019;JIB!!q\u001aBk\u001b\t\u0011\tN\u0003\u0003\u0003T\u0006%\u0014\u0001B;uS2LAAa6\u0003R\n!Q+V%E\u0011\u001d\u0011Yn\u000ba\u0001\u0003/\u000b!BY1tK>3gm]3u\u0011\u001d\u0011yn\u000ba\u0001\u0003/\u000b\u0011\"\u001a8e\u001f\u001a47/\u001a;\u00023%t\u0017\u000e^5bi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0005o\u0013)\u000fC\u0004\u0003\u00182\u0002\r!a\u0004\u00023\r|W\u000e\u001d7fi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0005o\u0013Y\u000fC\u0004\u0003\u00186\u0002\r!a\u0004\u0002\u001b5,Wn\u001c:z%\u0016\u001cwN\u001d3t)\u0011\u00119L!=\t\r\u0011t\u0003\u0019\u0001Bz!\u0011\u0011)Pa?\u000e\u0005\t](b\u0001B}{\u00051Am\\7bS:LAA!@\u0003x\n!\u0012IY:ue\u0006\u001cG\u000fV5fe6+G/\u00193bi\u0006\f\u0011b\u0019:fCR,Gj\\4\u0015)\r\r1qBB\t\u00077\u0019)c!\u000b\u0004.\rU2\u0011IB#!\u0011\u0019)aa\u0003\u000e\u0005\r\u001d!bAB\u0005\u007f\u0005\u0019An\\4\n\t\r51q\u0001\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0004\u0002^=\u0002\r!!\u0019\t\u0013\rMq\u0006%AA\u0002\rU\u0011AB2p]\u001aLw\r\u0005\u0003\u0004\u0006\r]\u0011\u0002BB\r\u0007\u000f\u0011\u0011\u0002T8h\u0007>tg-[4\t\u0013\ruq\u0006%AA\u0002\r}\u0011\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\r\u00016\u0011E\u0005\u0004\u0007G\t&\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011%\u00199c\fI\u0001\u0002\u0004\t9*\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u0013\r-r\u0006%AA\u0002\u0005]\u0015!\u0004:fG>4XM]=Q_&tG\u000f\u0003\u0005x_A\u0005\t\u0019AB\u0018!\r\t8\u0011G\u0005\u0004\u0007g\u0011(!C*dQ\u0016$W\u000f\\3s\u0011!qw\u0006%AA\u0002\r]\u0002\u0003BB\u001d\u0007{i!aa\u000f\u000b\u0007M\fy(\u0003\u0003\u0004@\rm\"\u0001\u0002+j[\u0016D\u0011ba\u00110!\u0003\u0005\rA!(\u000235\f\u0007\u0010\u0015:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0005\n\u0007\u000fz\u0003\u0013!a\u0001\u0005;\u000b1\u0005\u001d:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>t7\t[3dW&sG/\u001a:wC2l5/A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$#'\u0006\u0002\u0004N)\"1QCB(W\t\u0019\t\u0006\u0005\u0003\u0004T\ruSBAB+\u0015\u0011\u00199f!\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAB.\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r}3Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\u001aTCAB3U\u0011\u0019yba\u0014\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r-$\u0006BAL\u0007\u001f\n1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIU\n1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIY*\"aa\u001d+\t\r=2qJ\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeN\u000b\u0003\u0007sRCaa\u000e\u0004P\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%qU\u00111q\u0010\u0016\u0005\u0005;\u001by%A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$\u0013H\u0001\u0005MSN$XM\\3s'\u0011A4ia\"\u0011\u00071\u001bI)C\u0002\u0004\fv\u0012q\u0004R3mKR,G\rU1si&$\u0018n\u001c8t\u0007\"\fgnZ3MSN$XM\\3s)\t\u0019y\tE\u0002\u0004\u0012bj\u0011\u0001\u0001\u000b\u0007\u0003#\u001a)ja&\t\u000f\t]%\b1\u0001\u0002\u0010!1QP\u000fa\u0001\u0003+\tQc\u001d;paB\u000b'\u000f^5uS>tG)\u001a7fi&|g\u000e\u0006\u0003\u0002R\ru\u0005b\u0002BLw\u0001\u0007\u0011q\u0002")
public class TierDeletedPartitionsCoordinatorTest {
    private final ReplicaManager kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TierTopicConsumer kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final KRaftMetadataCache metadataCache = new KRaftMetadataCache(0);
    private final TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private final MockTime kafka$tier$TierDeletedPartitionsCoordinatorTest$$time = new MockTime();
    private final MockScheduler kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().scheduler();
    private final scala.collection.mutable.Map<TopicIdPartition, List<TierObjectStore.ObjectMetadata>> tieredObjects = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private TierDeletedPartitionsCoordinator deletedPartitionsCoordinator;
    private final File dir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.dir());
    private final TopicPartition tierTopicPartition;
    private final long initialBackoffMs;

    public ReplicaManager kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager;
    }

    public TierTopicConsumer kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public MockTime kafka$tier$TierDeletedPartitionsCoordinatorTest$$time() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time;
    }

    public MockScheduler kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler;
    }

    private scala.collection.mutable.Map<TopicIdPartition, List<TierObjectStore.ObjectMetadata>> tieredObjects() {
        return this.tieredObjects;
    }

    private TierDeletedPartitionsCoordinator deletedPartitionsCoordinator() {
        return this.deletedPartitionsCoordinator;
    }

    private void deletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.deletedPartitionsCoordinator = x$1;
    }

    private File dir() {
        return this.dir;
    }

    private File logDir() {
        return this.logDir;
    }

    private TopicPartition tierTopicPartition() {
        return this.tierTopicPartition;
    }

    private long initialBackoffMs() {
        return this.initialBackoffMs;
    }

    @AfterEach
    public void teardown() {
        this.dir().delete();
        Mockito.framework().clearInlineMocks();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInitiateDeletion(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-1", UUID.randomUUID(), 0), new TopicIdPartition("foo-2", UUID.randomUUID(), 2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-3", UUID.randomUUID(), 0)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        deletedPartitionsMap.foreach((Function1 & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int tierTopicPartitionId = x0$2._1$mcI$sp();
            ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
            return tuple2;
        }));
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(1, new TopicIdPartition("foo", UUID.randomUUID(), 0), 20L);
        Assertions.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1 & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            int tierTopicPartitionId = x0$3._1$mcI$sp();
            ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$3._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
            return tuple2;
        }));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCompleteDeletion(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        TopicIdPartition foo_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition foo_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 2);
        TopicIdPartition foo_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 5);
        LongRef offset = LongRef.create((long)0L);
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_1, foo_2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        deletedPartitionsMap.foreach((Function1 & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$2(this, offset, x0$1);
            return BoxedUnit.UNIT;
        });
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(0, foo_1);
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(3, foo_3);
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_2})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)0))).pendingDeletions().keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)3))).pendingDeletions().keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)5))).pendingDeletions().keySet());
        Assertions.assertEquals((int)3, (int)immigratedPartitions.size());
        this.deletedPartitionsCoordinator().handleEmigration(0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), (Object)immigratedPartitions.keySet());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBeginMaterialization(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Tuple2 foo_1 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-1", UUID.randomUUID(), 0));
        Tuple2 foo_2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-2", UUID.randomUUID(), 2));
        Tuple2 foo_3 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-3", UUID.randomUUID(), 2));
        Tuple2 foo_4 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new TopicIdPartition("foo-4", UUID.randomUUID(), 5));
        this.deletedPartitionsCoordinator().handleImmigration(0);
        this.deletedPartitionsCoordinator().handleImmigration(3);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 10L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 20L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_4._1$mcI$sp(), (TopicIdPartition)foo_4._2(), 30L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 31L);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_1._1$mcI$sp()))).inProgressDeletions().contains(foo_1._2()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_2._1$mcI$sp()))).inProgressDeletions().contains(foo_2._2()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_4._1$mcI$sp()))).inProgressDeletions().contains(foo_4._2()));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)immigratedPartitions.values().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$1(x$2)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 32L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 34L);
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)immigratedPartitions.values().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$2(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_1._2(), (TopicIdPartition)foo_2._2(), (TopicIdPartition)foo_4._2()}))).foreach((Function1 & Serializable)topicIdPartition -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$3(this, topicIdPartition);
            return BoxedUnit.UNIT;
        });
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).register((java.util.Map)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<java.util.Map<TopicIdPartition, TierTopicConsumer.ClientCtx>>(null, foo_1, foo_2, foo_4){
            private final Tuple2 foo_1$1;
            private final Tuple2 foo_2$1;
            private final Tuple2 foo_4$1;

            public boolean matches(java.util.Map<TopicIdPartition, TierTopicConsumer.ClientCtx> argument) {
                Set set = CollectionConverters$.MODULE$.SetHasAsScala(argument.keySet()).asScala();
                Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)this.foo_1$1._2(), (TopicIdPartition)this.foo_2$1._2(), (TopicIdPartition)this.foo_4$1._2()}));
                return !(set != null ? !set.equals(object) : object != null);
            }
            {
                this.foo_1$1 = foo_1$1;
                this.foo_2$1 = foo_2$1;
                this.foo_4$1 = foo_4$1;
            }
        }));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer()});
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_3._1$mcI$sp(), (TopicIdPartition)foo_3._2(), 100L);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).pendingDeletions().keySet());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2());
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).inProgressDeletions().keySet());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeletePartition(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        int tierTopicPartition = 1;
        TopicIdPartition deletedPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        TopicIdPartition deletedPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 0);
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments_1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> TierDeletedPartitionsCoordinatorTest.$anonfun$testDeletePartition$1(deletedPartition_1, BoxesRunTime.unboxToInt((Object)i)));
        this.tieredObjects().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deletedPartition_1), (Object)tieredSegments_1.toList()));
        this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_1, (long)deleteInitiateOffset_1);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_2, (long)deleteInitiateOffset_2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().keySet());
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map inProgressPartitions = ((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions();
        Assertions.assertEquals((int)2, (int)inProgressPartitions.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MaterializingState$[]{MaterializingState$.MODULE$, MaterializingState$.MODULE$})), (Object)inProgressPartitions.values().map((Function1 & Serializable)x$4 -> x$4.currentState()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().isEmpty());
        int numCompacted = 2;
        LongRef offset = LongRef.create((long)0L);
        InProgressDeletion inProgress_1 = (InProgressDeletion)inProgressPartitions.apply((Object)deletedPartition_1);
        ((IterableOnceOps)tieredSegments_1.take(numCompacted)).foreach((Function1 & Serializable)segment -> {
            OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$2.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
            ++offset$2.elem;
            return inProgress_1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Compaction, stateOffsetAndEpoch, TierObjectStore.OpaqueData.ZEROED), stateOffsetAndEpoch);
        });
        ((IterableOnceOps)tieredSegments_1.drop(numCompacted)).foreach((Function1 & Serializable)segment -> {
            OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$2.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
            ++offset$2.elem;
            return inProgress_1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Archive, stateOffsetAndEpoch, TierObjectStore.OpaqueData.ZEROED), stateOffsetAndEpoch);
        });
        inProgress_1.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(deletedPartition_1, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.deletedPartitionsCoordinator().maybeBeginDeletion();
        Assertions.assertEquals((Object)AwaitingDeleteComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(tierTopicPartition, deletedPartition_1);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MaterializingState$[]{MaterializingState$.MODULE$})), (Object)inProgressPartitions.values().map((Function1 & Serializable)x$5 -> x$5.currentState()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDuplicateDeleteInitiate(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        int tierTopicPartition = 1;
        TopicIdPartition partition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        int deleteCompleteOffset_1 = 15;
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> TierDeletedPartitionsCoordinatorTest.$anonfun$testDuplicateDeleteInitiate$1(partition, BoxesRunTime.unboxToInt((Object)i)));
        this.tieredObjects().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)tieredSegments.toList()));
        this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, partition, (long)deleteInitiateOffset_2);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        InProgressDeletion inProgress = (InProgressDeletion)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions().apply((Object)partition);
        LongRef offset = LongRef.create((long)0L);
        tieredSegments.foreach((Function1 & Serializable)segment -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testDuplicateDeleteInitiate$2(offset, inProgress, segment);
            return BoxedUnit.UNIT;
        });
        Mockito.reset((Object[])new TierTopicConsumer[]{this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer()});
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), new OffsetAndEpoch((long)deleteCompleteOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.never())).deregister(partition);
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_2, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), new OffsetAndEpoch((long)(deleteInitiateOffset_2 + 1), Optional.of(Predef$.MODULE$.int2Integer(0))));
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).deregister(partition);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithOnlinePartition(boolean hasTierObjectGC) {
        void var9_9;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        AbstractLog log = this.createLog(this.logDir(), this.createLog$default$2(), new BrokerTopicStats(), 0L, 0L, this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        int leaderEpoch = 0;
        this.deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Online(partition));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MemoryRecords[]{this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), this.initiatePartitionDeletion(topicIdPartition_1), this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), this.initiatePartitionDeletion(topicIdPartition_2), this.completePartitionDeletion(topicIdPartition_1)}))).foreach((Function1 & Serializable)record -> log.appendAsLeader(record, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.updateHighWatermark(log.logEndOffset());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)log.logEndOffset(), (long)var9_9);
        ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)this.tierTopicPartition().partition()));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition_2})), (Object)immigratedPartition.pendingDeletions().keySet().toList());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithOfflinePartition(boolean hasTierObjectGC) {
        void var5_5;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)HostedPartition.Offline$.MODULE$);
        ByteBuffer buffer = ByteBuffer.allocate(200);
        int startOffset = 0;
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), (long)startOffset, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)var5_5, (long)startOffset);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithNonePartition(boolean hasTierObjectGC) {
        void var5_5;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)HostedPartition.None$.MODULE$);
        ByteBuffer buffer = ByteBuffer.allocate(200);
        int startOffset = 0;
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), (long)startOffset, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)var5_5, (long)startOffset);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithEmigrationDuringRead(boolean hasTierObjectGC) {
        void var9_9;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        AbstractLog log = this.createLog(this.logDir(), this.createLog$default$2(), new BrokerTopicStats(), 0L, 0L, this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        int leaderEpoch = 0;
        this.deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Online(partition));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MemoryRecords[]{this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), this.initiatePartitionDeletion(topicIdPartition_1), this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), this.initiatePartitionDeletion(topicIdPartition_2), this.completePartitionDeletion(topicIdPartition_1)}))).foreach((Function1 & Serializable)record -> log.appendAsLeader(record, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.updateHighWatermark(log.logEndOffset());
        this.deletedPartitionsCoordinator().handleEmigration(this.tierTopicPartition().partition());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)var9_9);
        Assertions.assertEquals((int)0, (int)this.deletedPartitionsCoordinator().immigratedPartitions().size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReconfiguration(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        ListBuffer heartbeats = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int initialDelayMs = 100;
        ObjectRef config = ObjectRef.create((Object)new Config(200L, 100, 15000L));
        TierDeletedPartitionsCoordinator coordinator = new TierDeletedPartitionsCoordinator(this, config, heartbeats){
            private final /* synthetic */ TierDeletedPartitionsCoordinatorTest $outer;
            private final ListBuffer heartbeats$1;

            public void heartbeat() {
                super.heartbeat();
                this.heartbeats$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.heartbeats$1 = heartbeats$1;
                super((Scheduler)$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), $outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager(), $outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), ((Config)config$1.elem).intervalMs(), ((Config)config$1.elem).maxInprogressPartitions(), ((Config)config$1.elem).deleteBackoffMs(), "foo", (Time)$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), (Option)None$.MODULE$);
            }
        };
        coordinator.startup();
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(initialDelayMs);
        Assertions.assertEquals((int)1, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs());
        Assertions.assertEquals((int)2, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L);
        Assertions.assertEquals((int)2, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L + 1L);
        Assertions.assertEquals((int)3, (int)heartbeats.size());
        config.elem = new Config(10L, 100, 15000L);
        coordinator.reconfigure((Config)config.elem);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(1L);
        Assertions.assertEquals((int)4, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs());
        Assertions.assertEquals((int)5, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L);
        Assertions.assertEquals((int)5, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L + 1L);
        Assertions.assertEquals((int)6, (int)heartbeats.size());
        coordinator.shutdown();
    }

    @Test
    public void testGarbageCollector() {
        this.createTierDeletedPartitionsCoordinator(true);
        Seq topicPartitions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-1", UUID.randomUUID(), 0), new TopicIdPartition("foo-2", UUID.randomUUID(), 2), new TopicIdPartition("foo-3", UUID.randomUUID(), 0)}));
        this.deletedPartitionsCoordinator().handleImmigration(0);
        this.deletedPartitionsCoordinator().trackInitLeader(0, (TopicIdPartition)topicPartitions.apply(0), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.deletedPartitionsCoordinator().handleImmigration(1);
        this.deletedPartitionsCoordinator().trackInitLeader(1, (TopicIdPartition)topicPartitions.apply(1), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.deletedPartitionsCoordinator().handleImmigration(2);
        this.deletedPartitionsCoordinator().trackInitLeader(2, (TopicIdPartition)topicPartitions.apply(2), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        TopicImage topicImage1 = new TopicImage(((TopicIdPartition)topicPartitions.apply(0)).topic(), new Uuid(((TopicIdPartition)topicPartitions.apply(0)).topicId().getMostSignificantBits(), ((TopicIdPartition)topicPartitions.apply(0)).topicId().getLeastSignificantBits()), null, null);
        this.metadataCache().setImage(this.createMetadataImage((Seq<TopicImage>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicImage[]{topicImage1}))), new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.deletedPartitionsCoordinator().trackPreInitiatePartitionDelete(1, (TopicIdPartition)topicPartitions.apply(1), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds());
        this.deletedPartitionsCoordinator().trackPreInitiatePartitionDelete(2, (TopicIdPartition)topicPartitions.apply(2), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(this.initialBackoffMs() - 5L);
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(1), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(2), 0);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(this.initialBackoffMs());
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
    }

    private MetadataImage createMetadataImage(Seq<TopicImage> topicImages, org.apache.kafka.raft.OffsetAndEpoch imageOffsetAndEpoch) {
        return new MetadataImage(imageOffsetAndEpoch, FeaturesImage.EMPTY, ClusterImage.EMPTY, new TopicsImage(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)topicImages.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)topicImages.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava(), new HashMap(), new HashMap()), ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }

    private void verifyDeletePreInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeletePreInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$2;

            public boolean matches(TierPartitionDeletePreInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$2;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$2 = topicIdPartition$2;
            }
        }));
    }

    private void verifyDeleteInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeleteInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$3;

            public boolean matches(TierPartitionDeleteInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$3;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$3 = topicIdPartition$3;
            }
        }));
    }

    private void createTierDeletedPartitionsCoordinator(boolean hasTieredObjectGC) {
        None$ tieredObjectGC = hasTieredObjectGC ? new Some((Function0 & Serializable)() -> new TierObjectGarbageCollector(this.tierTopicManager(), this.metadataCache(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time())) : None$.MODULE$;
        this.deletedPartitionsCoordinator_$eq(new TierDeletedPartitionsCoordinator((Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager(), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), 1L, 100, this.initialBackoffMs(), "foo", (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), (Option)tieredObjectGC));
        this.deletedPartitionsCoordinator().registerListener((DeletedPartitionsChangeListener)new Listener());
    }

    private MemoryRecords initiateSegmentUpload(TopicIdPartition topicIdPartition, int leaderEpoch, UUID objectId, long baseOffset, long endOffset) {
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, objectId, baseOffset, endOffset, 10L, 100L, 500, true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), TierObjectStore.OpaqueData.ZEROED);
        return this.memoryRecords((AbstractTierMetadata)uploadInitiate);
    }

    private MemoryRecords initiatePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteInitiate(topicIdPartition, 0, UUID.randomUUID()));
    }

    private MemoryRecords completePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID()));
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords memoryRecords(AbstractTierMetadata metadata) {
        void withRecords_records;
        void withRecords_compressionType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, metadata.serializeKey(), metadata.serializeValue())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        return MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private AbstractLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, long logStartOffset, long recoveryPoint, Scheduler scheduler, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        return LogTestUtils$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), TierLogComponents$.MODULE$.EMPTY(), new LogDirFailureChannel(10), (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, true, (Option<Uuid>)None$.MODULE$, true);
    }

    private LogConfig createLog$default$2() {
        return LogTestUtils$.MODULE$.createLogConfig(Defaults$.MODULE$.SegmentMs(), Defaults$.MODULE$.SegmentSize(), Defaults$.MODULE$.RetentionMs(), Defaults$.MODULE$.RetentionSize(), Defaults$.MODULE$.SegmentJitterMs(), Defaults$.MODULE$.CleanupPolicy(), Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.IndexInterval(), Defaults$.MODULE$.MaxIndexSize(), Defaults$.MODULE$.MessageFormatVersion(), Defaults$.MODULE$.FileDeleteDelayMs(), Defaults$.MODULE$.TierEnable(), Defaults$.MODULE$.TierLocalHotsetBytes(), Defaults$.MODULE$.TierLocalHotsetMs(), Defaults$.MODULE$.TierSegmentHotsetRollMinBytes(), Defaults$.MODULE$.PreferTierFetchMs(), true);
    }

    private BrokerTopicStats createLog$default$3() {
        return new BrokerTopicStats();
    }

    private long createLog$default$4() {
        return 0L;
    }

    private long createLog$default$5() {
        return 0L;
    }

    private Scheduler createLog$default$6() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler();
    }

    private Time createLog$default$7() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time();
    }

    private int createLog$default$8() {
        return 3600000;
    }

    private int createLog$default$9() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public static final /* synthetic */ void $anonfun$testInitiateDeletion$3(TierDeletedPartitionsCoordinatorTest $this, int tierTopicPartitionId$1, TopicIdPartition deletedPartition) {
        $this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartitionId$1, deletedPartition, 10L);
    }

    public static final /* synthetic */ void $anonfun$testInitiateDeletion$2(TierDeletedPartitionsCoordinatorTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ((scala.collection.immutable.Set)x0$1._2()).foreach((Function1 & Serializable)deletedPartition -> {
                TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$3($this, tierTopicPartitionId, deletedPartition);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testCompleteDeletion$3(TierDeletedPartitionsCoordinatorTest $this, int tierTopicPartitionId$2, LongRef offset$1, TopicIdPartition deletedPartition) {
        $this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartitionId$2, deletedPartition, offset$1.elem);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testCompleteDeletion$2(TierDeletedPartitionsCoordinatorTest $this, LongRef offset$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ((scala.collection.immutable.Set)x0$1._2()).foreach((Function1 & Serializable)deletedPartition -> {
                TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$3($this, tierTopicPartitionId, offset$1, deletedPartition);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$testBeginMaterialization$1(ImmigratedTierTopicPartition x$2) {
        return x$2.pendingDeletions().size();
    }

    public static final /* synthetic */ int $anonfun$testBeginMaterialization$2(ImmigratedTierTopicPartition x$3) {
        return x$3.pendingDeletions().size();
    }

    public static final /* synthetic */ void $anonfun$testBeginMaterialization$3(TierDeletedPartitionsCoordinatorTest $this, TopicIdPartition topicIdPartition) {
        ((TierTopicConsumer)Mockito.verify((Object)$this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).deregister((TopicIdPartition)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TopicIdPartition>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$1;

            public boolean matches(TopicIdPartition argument) {
                TopicIdPartition topicIdPartition = argument;
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$1;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
            }
        }));
    }

    public static final /* synthetic */ TierObjectStore.ObjectMetadata $anonfun$testDeletePartition$1(TopicIdPartition deletedPartition_1$1, int i) {
        return new TierObjectStore.ObjectMetadata(deletedPartition_1$1, UUID.randomUUID(), 0, (long)i, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    }

    public static final /* synthetic */ TierObjectStore.ObjectMetadata $anonfun$testDuplicateDeleteInitiate$1(TopicIdPartition partition$1, int i) {
        return new TierObjectStore.ObjectMetadata(partition$1, UUID.randomUUID(), 0, (long)i, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    }

    public static final /* synthetic */ void $anonfun$testDuplicateDeleteInitiate$2(LongRef offset$3, InProgressDeletion inProgress$1, TierObjectStore.ObjectMetadata segment) {
        OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$3.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
        inProgress$1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Archive, stateOffsetAndEpoch, TierObjectStore.OpaqueData.ZEROED), stateOffsetAndEpoch);
        ++offset$3.elem;
    }

    public TierDeletedPartitionsCoordinatorTest() {
        File parseTopicPartitionName_dir = this.logDir();
        this.tierTopicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.initialBackoffMs = 10L;
    }

    private class Listener
    implements DeletedPartitionsChangeListener {
        public void initiatePartitionDeletion(TopicIdPartition topicIdPartition, List<TierObjectStore.ObjectMetadata> tieredObjects) {
        }

        public void stopPartitionDeletion(TopicIdPartition topicIdPartition) {
        }

        public /* synthetic */ TierDeletedPartitionsCoordinatorTest kafka$tier$TierDeletedPartitionsCoordinatorTest$Listener$$$outer() {
            return TierDeletedPartitionsCoordinatorTest.this;
        }

        public Listener() {
            if (TierDeletedPartitionsCoordinatorTest.this == null) {
                throw null;
            }
        }
    }
}

