/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005A3A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C)/!)a\u0004\u0001C\u0001?!)1\n\u0001C\u0005\u0019\nQC+[3s)>\u0004\u0018nY'b]\u0006<WM]*pMR4\u0015-\u001b7ve\u0016Le\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0004\t\u0003\u0011!\u0018.\u001a:\u000b\u0003%\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002C\u0001\u0004CBL\u0017BA\t\u000f\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u0015!\t)\u0002!D\u0001\u0007\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u00111!\u00138u\u0003=!Xm\u001d;T_\u001a$h)Y5mkJ,GC\u0001\u0011$!\tI\u0012%\u0003\u0002#5\t!QK\\5u\u0011\u0015!3\u00011\u0001&\u0003\u0019\tXo\u001c:v[B\u0011a%\f\b\u0003O-\u0002\"\u0001\u000b\u000e\u000e\u0003%R!A\u000b\u0006\u0002\rq\u0012xn\u001c;?\u0013\ta#$\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017\u001bQ\u0011\u0019\u0011g\u0010!\u0011\u0005IjT\"A\u001a\u000b\u0005Q*\u0014\u0001\u00039s_ZLG-\u001a:\u000b\u0005Y:\u0014A\u00029be\u0006l7O\u0003\u00029s\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001e<\u0003\u0015QWO\\5u\u0015\u0005a\u0014aA8sO&\u0011ah\r\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0003\u0005\u000b\u0013AQ\u0001\u0003u.DCa\u0001#I\u0013B\u0011QIR\u0007\u0002k%\u0011q)\u000e\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013AS\u0001\u0019w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBj\u0018\u0001\u0006;jKJ$\u0016m]6t\u0007f\u001cG.Z:D_VtG/F\u0001N!\tIb*\u0003\u0002P5\t!Aj\u001c8h\u0001")
public class TierTopicManagerSoftFailureIntegrationTest
extends IntegrationTestHarness {
    @Override
    public int brokerCount() {
        return 1;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testSoftFailure(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicManagerSoftFailureIntegrationTest.$anonfun$testSoftFailure$1(broker);
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerSoftFailureIntegrationTest.$anonfun$testSoftFailure$4(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for cycle count to be non-zero");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Properties properties = new Properties();
        properties.put("client.id", TierTopicProducerSupplier.clientId((String)"clusterId", (int)0, (long)0L));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        try (KafkaProducer producer = this.createProducer(x$2, x$3, properties);){
            byte[] keyBytes = new byte[127];
            byte[] valBytes = new byte[33];
            producer.send(new ProducerRecord("_confluent-tier-state", Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L), (Object)keyBytes, (Object)valBytes)).get();
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerSoftFailureIntegrationTest.$anonfun$testSoftFailure$6(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"timeout waiting for TierTopicManager to no longer be ready to uncaught exception");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        long countAfterNotReady = this.tierTasksCyclesCount();
        Thread.sleep(3000L);
        Assertions.assertEquals((long)countAfterNotReady, (long)this.tierTasksCyclesCount());
    }

    private long tierTasksCyclesCount() {
        return BoxesRunTime.unboxToLong((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(ManagementFactory.getPlatformMBeanServer().getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=CyclesPerSec"), new String[]{"Count"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToLong((long)TierTopicManagerSoftFailureIntegrationTest.$anonfun$tierTasksCyclesCount$1(attr)))).head());
    }

    public static final /* synthetic */ boolean $anonfun$testSoftFailure$2(TierTopicManager eta$0$1$1) {
        return eta$0$1$1.isReady();
    }

    public static final /* synthetic */ String $anonfun$testSoftFailure$3() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    public static final /* synthetic */ void $anonfun$testSoftFailure$1(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReady()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testSoftFailure$4(TierTopicManagerSoftFailureIntegrationTest $this) {
        return $this.tierTasksCyclesCount() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSoftFailure$5() {
        return "Timed out waiting for cycle count to be non-zero";
    }

    public static final /* synthetic */ boolean $anonfun$testSoftFailure$6(TierTopicManagerSoftFailureIntegrationTest $this) {
        return !((TierTopicManager)((KafkaBroker)$this.brokers().head()).tierTopicManagerOpt().get()).isReady();
    }

    public static final /* synthetic */ String $anonfun$testSoftFailure$7() {
        return "timeout waiting for TierTopicManager to no longer be ready to uncaught exception";
    }

    public static final /* synthetic */ long $anonfun$tierTasksCyclesCount$1(Attribute attr) {
        return BoxesRunTime.unboxToLong((Object)attr.getValue());
    }

    public TierTopicManagerSoftFailureIntegrationTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
    }
}

