/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.tier.client.TierTopicClient;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.topic.TierTopicManagerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d3Aa\u0003\u0007\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\r9\u0002\u0001\u0015!\u0003,\u0011\u001dy\u0003A1A\u0005\n)Ba\u0001\r\u0001!\u0002\u0013Y\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"B\"\u0001\t\u0003\u0011\u0004\"B#\u0001\t\u0003\u0011$a\u0005+jKJ$v\u000e]5d\u00072LWM\u001c;UKN$(BA\u0007\u000f\u0003\u0019\u0019G.[3oi*\u0011q\u0002E\u0001\u0005i&,'OC\u0001\u0012\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\tA\"A\u0005dYV\u001cH/\u001a:JIV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0012\u0003\rM#(/\u001b8h\u0003)\u0019G.^:uKJLE\rI\u0001\tEJ|7.\u001a:JIV\t1\u0006\u0005\u0002\u0016Y%\u0011QF\u0006\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003)Ign\u001d;b]\u000e,\u0017\nZ\u0001\fS:\u001cH/\u00198dK&#\u0007%\u0001\u000buKN$8i\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u000b\u0002gA\u0011Q\u0003N\u0005\u0003kY\u0011A!\u00168ji\"\u0012\u0001b\u000e\t\u0003q\u0005k\u0011!\u000f\u0006\u0003um\n1!\u00199j\u0015\taT(A\u0004kkBLG/\u001a:\u000b\u0005yz\u0014!\u00026v]&$(\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cs\t!A+Z:u\u0003Q!Xm\u001d;Qe>$WoY3s\u00072LWM\u001c;JI\"\u0012\u0011bN\u0001$i\u0016\u001cH/T3ue&\u001c7OU3q_J$XM]\"p]\u001aLwMT8u!J,7/\u001a8uQ\tQq\u0007")
public class TierTopicClientTest {
    private final String clusterId;
    private final int brokerId;
    private final int instanceId;

    private String clusterId() {
        return this.clusterId;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private int instanceId() {
        return this.instanceId;
    }

    @Test
    public void testConsumerClientId() {
        String clientIdSuffix = "suffix";
        Assertions.assertTrue((boolean)TierTopicClient.isTierTopicClient((String)TierTopicConsumerSupplier.clientId((String)this.clusterId(), (int)this.brokerId(), (int)this.instanceId(), (String)clientIdSuffix)));
    }

    @Test
    public void testProducerClientId() {
        Assertions.assertTrue((boolean)TierTopicClient.isTierTopicClient((String)TierTopicProducerSupplier.clientId((String)this.clusterId(), (int)this.brokerId(), (long)this.instanceId())));
    }

    @Test
    public void testMetricsReporterConfigNotPresent() {
        Supplier<Map<String, Object>> configsSupplier = new Supplier<Map<String, Object>>(null){

            /*
             * WARNING - void declaration
             */
            public Map<String, Object> get() {
                void var1_1;
                HashMap<String, String> configs = new HashMap<String, String>();
                configs.put("bootstrap.servers", "bootstrap");
                configs.put("metric.reporters", "reporter");
                return var1_1;
            }
        };
        TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig((Supplier)configsSupplier, "tierNamespace", (short)2, (short)1, 0, "clusterId", Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.int2Integer(200), Predef$.MODULE$.int2Integer(300), Collections.singletonList("logDir"));
        Properties producerConfigs = TierTopicProducerSupplier.properties((TierTopicManagerConfig)tierTopicManagerConfig, (String)"clientId");
        Assertions.assertEquals((Object)"bootstrap", (Object)producerConfigs.getProperty("bootstrap.servers"));
        Assertions.assertNull((Object)producerConfigs.getProperty("metric.reporters"));
        Properties consumerConfigs = TierTopicConsumerSupplier.properties((TierTopicManagerConfig)tierTopicManagerConfig, (String)"clientId");
        Assertions.assertEquals((Object)"bootstrap", (Object)consumerConfigs.getProperty("bootstrap.servers"));
        Assertions.assertNull((Object)consumerConfigs.getProperty("metric.reporters"));
    }

    public TierTopicClientTest() {
        this.clusterId = "cluster-id";
        this.brokerId = 3;
        this.instanceId = 10;
    }
}

