/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u0004;\u0001\u0001\u0006I!\f\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019A\u0005\u0001)A\u0005{!9\u0011\n\u0001b\u0001\n\u0003Q\u0005BB*\u0001A\u0003%1\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003]\u0001\u0011\u0005Q\fC\u0003j\u0001\u0011E!\u000eC\u0003\u007f\u0001\u0011Eq\u0010C\u0004\u0002\u000e\u0001!\t\"a\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0005\u0002*!9\u00111\u0007\u0001\u0005\u0012\u0005U\u0002bBA\u001d\u0001\u0011E\u00111\b\u0005\b\u0003\u0003\u0002A\u0011CA\"\u0011%\t\t\u0006AI\u0001\n#\t\u0019\u0006C\u0004\u0002j\u0001!\t\"a\u001b\t\u000f\u0005e\u0004\u0001\"\u0005\u0002|!9\u0011Q\u0014\u0001\u0005\u0012\u0005}\u0005bBAU\u0001\u0011E\u00111\u0016\u0005\b\u0003g\u0003A\u0011CA[\u0011%\t\u0019\rAI\u0001\n#\t)MA\tCCN,G+[3s'R\fG/\u001a+fgRT!AG\u000e\u0002\u000bM$\u0018\r^3\u000b\u0005qi\u0012\u0001\u0002;jKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%;\u000511/\u001a:wKJL!AJ\u0012\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\r\u0002\u0013Q|\u0007/[2OC6,W#A\u0017\u0011\u00059:dBA\u00186!\t\u00014'D\u00012\u0015\t\u0011t$\u0001\u0004=e>|GO\u0010\u0006\u0002i\u0005)1oY1mC&\u0011agM\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027g\u0005QAo\u001c9jG:\u000bW.\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tQ\b\u0005\u0002?\r6\tqH\u0003\u0002A\u0003\u000611m\\7n_:T!A\b\"\u000b\u0005\r#\u0015AB1qC\u000eDWMC\u0001F\u0003\ry'oZ\u0005\u0003\u000f~\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u0015\u0001(o\u001c9t+\u0005Y\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0011)H/\u001b7\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00029s_B\u001c\b%A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011aK\u0017\t\u0003/bk\u0011aM\u0005\u00033N\u0012A!\u00168ji\")1\f\u0003a\u0001\u0017\u0006Q\u0001O]8qKJ$\u0018.Z:\u0002\u001dA\u0014X\r]1sK\u001a{'\u000fV3tiR\ta\u000b\u000b\u0002\n?B\u0011\u0001mZ\u0007\u0002C*\u0011!mY\u0001\u0004CBL'B\u00013f\u0003\u001dQW\u000f]5uKJT!A\u001a#\u0002\u000b),h.\u001b;\n\u0005!\f'A\u0003\"fM>\u0014X-R1dQ\u0006yA/[3s\u0019><7+Z4nK:$8\u000f\u0006\u0002luB\u0019A.\u001d;\u000f\u00055|gB\u0001\u0019o\u0013\u0005!\u0014B\u000194\u0003\u001d\u0001\u0018mY6bO\u0016L!A]:\u0003\t1K7\u000f\u001e\u0006\u0003aN\u0002\"!\u001e=\u000e\u0003YT!a^\u000f\u0002\u00071|w-\u0003\u0002zm\nqA+[3s\u0019><7+Z4nK:$\b\"B<\u000b\u0001\u0004Y\bCA;}\u0013\tihOA\u0006BEN$(/Y2u\u0019><\u0017AH<bSR4uN\u001d%piN+GOU3uK:$\u0018n\u001c8U_.K7m[%o)\r1\u0016\u0011\u0001\u0005\b\u0003\u0007Y\u0001\u0019AA\u0003\u0003!\u0011X\r\u001d7jG\u0006\u001c\b\u0003\u00027r\u0003\u000f\u00012aVA\u0005\u0013\r\tYa\r\u0002\u0004\u0013:$\u0018a\u0007<fe&4\u0017\u0010V5fe\u0016$7+Z4nK:$8\u000fR3mKR,G\rF\u0004W\u0003#\t\u0019\"a\t\t\u000b-b\u0001\u0019A\u0017\t\u000f\u0005UA\u00021\u0001\u0002\u0018\u0005AqN\u00196Ti>\u0014X\r\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tibG\u0001\u0006gR|'/Z\u0005\u0005\u0003C\tYBA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0011\u0019\t)\u0003\u0004a\u0001W\u0006qA/[3sK\u0012\u001cVmZ7f]R\u001c\u0018!G<bSR4uN\u001d*fa2L7-\u0019+p\u000f\u0016$\u0018J\\*z]\u000e$RAVA\u0016\u0003_Aq!!\f\u000e\u0001\u0004\t9!\u0001\u0005mK\u0006$WM]%e\u0011\u001d\t\t$\u0004a\u0001\u0003\u000f\t!BZ8mY><XM]%e\u0003Y\tG\r\u001a*fa2L7-\u0019+p\u0003N\u001c\u0018n\u001a8nK:$H\u0003BA\u0004\u0003oAq!!\f\u000f\u0001\u0004\t9!A\u0015baB,g\u000eZ'fgN\fw-Z:B]\u0012<\u0016-\u001b;V]RLG\u000eV5fe\u0016$\u0017I\u001c3Ts:\u001cW\r\u001a\u000b\u0006-\u0006u\u0012q\b\u0005\b\u0003[y\u0001\u0019AA\u0004\u0011\u001d\t\td\u0004a\u0001\u0003\u000f\t\u0001&\u00199qK:$W*Z:tC\u001e,7\u000fV8MK\u0006$WM]!oI^\u000b\u0017\u000e^+oi&dG+[3sK\u0012$b!!\u0012\u0002L\u00055\u0003cA,\u0002H%\u0019\u0011\u0011J\u001a\u0003\t1{gn\u001a\u0005\b\u0003[\u0001\u0002\u0019AA\u0004\u0011%\ty\u0005\u0005I\u0001\u0002\u0004\t9!A\u0006ok6\u001cVmZ7f]R\u001c\u0018AM1qa\u0016tG-T3tg\u0006<Wm\u001d+p\u0019\u0016\fG-\u001a:B]\u0012<\u0016-\u001b;V]RLG\u000eV5fe\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U#\u0006BA\u0004\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G\u001a\u0014AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001#M\u0016$8\r\u001b+jKJ,G-\u00118e\u0019>\u001c\u0017\r\u001c#bi\u0006\fe\u000e\u001a,bY&$\u0017\r^3\u0015\u000bY\u000bi'a\u001c\t\u000f\u00055\"\u00031\u0001\u0002\b!9\u0011\u0011\u000f\nA\u0002\u0005M\u0014!\u00044pY2|w/\u001a:JI>\u0003H\u000fE\u0003X\u0003k\n9!C\u0002\u0002xM\u0012aa\u00149uS>t\u0017!\b4fi\u000eDG)\u0019;b\u0003:$g+\u00197jI\u0006$XMU3ta>t7/Z:\u0015\u001bY\u000bi(a \u0002\u0002\u0006\u0015\u0015\u0011RAG\u0011\u001d\tic\u0005a\u0001\u0003\u000fAq!!\u001d\u0014\u0001\u0004\t\u0019\bC\u0004\u0002\u0004N\u0001\r!a\u0002\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0003\u000f\u001b\u0002\u0019AA#\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\u0005-5\u00031\u0001\u0002F\u0005!1/\u001b>f\u0011\u001d\tyi\u0005a\u0001\u0003#\u000b!B]3qY&\u001c\u0017-\u0012:s!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL\u007f\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u001c\u0006U%AB#se>\u00148/\u0001\u0007to&$8\r\u001b'fC\u0012,'\u000fF\u0003W\u0003C\u000b)\u000bC\u0004\u0002$R\u0001\r!a\u0002\u0002\u001f\r,(O]3oi2+\u0017\rZ3s\u0013\u0012Dq!a*\u0015\u0001\u0004\t9!A\tdkJ\u0014XM\u001c;G_2dwn^3s\u0013\u0012\f\u0011d\u0019:fCR,Gk\u001c9jG\u0006sGmR3u%\u0016\u0004H.[2bgR\u0011\u0011Q\u0016\t\b/\u0006=\u0016qAA\u0004\u0013\r\t\tl\r\u0002\u0007)V\u0004H.\u001a\u001a\u0002#\rD\u0017M\\4f)>\u0004\u0018nY\"p]\u001aLw\rF\u0004W\u0003o\u000bY,a0\t\r\u0005ef\u00031\u0001.\u0003\u001d\u0001(o\u001c9LKfDa!!0\u0017\u0001\u0004i\u0013!\u00039s_B4\u0016\r\\;f\u0011!\t\tM\u0006I\u0001\u0002\u0004i\u0013!\u0002;pa&\u001c\u0017aG2iC:<W\rV8qS\u000e\u001cuN\u001c4jO\u0012\"WMZ1vYR$3'\u0006\u0002\u0002H*\u001aQ&a\u0016")
public class BaseTierStateTest
extends BaseRequestTest {
    private final String topicName;
    private final TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
    private final Properties props = new Properties();

    public String topicName() {
        return this.topicName;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    @BeforeEach
    public void prepareForTest() {
        this.props().clear();
        this.props().put("confluent.tier.enable", "true");
        this.props().put("segment.bytes", "2048");
        this.props().put("confluent.tier.local.hotset.bytes", "2048");
        this.props().put("confluent.tier.local.hotset.ms", "10");
        this.props().put("retention.bytes", "20480");
        this.props().put("min.cleanable.dirty.ratio", "0.1");
        this.props().put("file.delete.delay.ms", "10");
    }

    public List<TierLogSegment> tierLogSegments(AbstractLog log) {
        return log.tieredLogSegments().toList();
    }

    public void waitForHotSetRetentionToKickIn(List<Object> replicas) {
        replicas.foreach((Function1)(JFunction1.mcVI.sp & Serializable)replica -> {
            AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(replica).get()).replicaManager().getLog(this.topicPartition()).get();
            long l = 200L;
            long waitUntilTrue_waitTimeMs = 60000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!BaseTierStateTest.$anonfun$waitForHotSetRetentionToKickIn$2(log)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for hot set retention to kick in");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        });
    }

    public void verifyTieredSegmentsDeleted(String topicName, TierObjectStore objStore, List<TierLogSegment> tieredSegments) {
        tieredSegments.foreach((Function1 & Serializable)segment -> {
            BaseTierStateTest.$anonfun$verifyTieredSegmentsDeleted$1(this, objStore, topicName, segment);
            return BoxedUnit.UNIT;
        });
    }

    public void waitForReplicaToGetInSync(int leaderId, int followerId) {
        Partition leaderPart = ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getPartitionOrException(this.topicPartition());
        boolean loaded = false;
        IntRef numAttempts = IntRef.create((int)0);
        while (!loaded && numAttempts.elem < 25) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> ((KafkaBroker)this.brokerForId(followerId).get()).replicaManager().getPartitionOrException(this.topicPartition()));
            if (try_ instanceof Success) {
                loaded = true;
                continue;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Exception returned: ").append(ex).append(" while getting partition at follower. numAttempts: ").append(numAttempts$1.elem).toString());
                Thread.sleep(200L);
                ++numAttempts.elem;
                continue;
            }
            throw new MatchError((Object)try_);
        }
        Partition followerPart = ((KafkaBroker)this.brokerForId(followerId).get()).replicaManager().getPartitionOrException(this.topicPartition());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$waitForReplicaToGetInSync$3(leaderPart, followerId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting replica to get in sync");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        Assertions.assertEquals((long)((AbstractLog)leaderPart.log().get()).logStartOffset(), (long)((AbstractLog)followerPart.log().get()).logStartOffset(), (String)"Log start offset mismatch");
        Assertions.assertEquals((Long)((Long)((AbstractLog)leaderPart.log().get()).tierPartitionState().startOffset().get()), (Long)((Long)((AbstractLog)followerPart.log().get()).tierPartitionState().startOffset().get()), (String)"First tiered offset mismatch");
        Assertions.assertEquals((long)((AbstractLog)leaderPart.log().get()).tierPartitionState().endOffset(), (long)((AbstractLog)followerPart.log().get()).tierPartitionState().endOffset(), (String)"Last tiered offset mismatch");
        Assertions.assertEquals((long)((AbstractLog)leaderPart.log().get()).logEndOffset(), (long)((AbstractLog)followerPart.log().get()).logEndOffset(), (String)"Log end offset mismatch");
    }

    public int addReplicaToAssignment(int leaderId) {
        ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignmentResult;
        scala.collection.immutable.Seq currentAssignment = ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getPartitionOrException(this.topicPartition()).inSyncReplicaIds().toSeq();
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        int replicaToAdd = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)adminClient.describeCluster().nodes().get()).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()))).toSet().find((Function1)(JFunction1.mcZI.sp & Serializable)x -> !currentAssignment.contains((Object)BoxesRunTime.boxToInteger((int)x))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1));
        if (replicaToAdd == -1) {
            throw new IllegalStateException("Cannot add a replica because # of brokers == # of replicas");
        }
        scala.collection.immutable.Seq targetAssignment = (scala.collection.immutable.Seq)currentAssignment.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaToAdd));
        List logDirs = (List)package$.MODULE$.List().fill(targetAssignment.size(), (Function0 & Serializable)() -> "\"any\"");
        String reassignmentJson = new StringBuilder(28).append("{\"version\":1,\"partitions\":").append(new StringBuilder(54).append("[{\"topic\":\"foo\",\"partition\":0,\"replicas\":").append(targetAssignment.mkString("[", ",", "]")).append(",\"log_dirs\":").append(logDirs.mkString("[", ",", "]")).append("}").toString()).append("]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, reassignmentJson, -1L, -1L, 10000L, Time.SYSTEM);
        ReassignPartitionsCommand.VerifyAssignmentResult expectedResult = new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)targetAssignment, (Seq)package$.MODULE$.Seq().empty()), new ReassignPartitionsCommand.Assignment((Seq)targetAssignment, (Seq)package$.MODULE$.Seq().empty()), true))})), false, (Map)Map$.MODULE$.empty(), false);
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!expectedResult.equals((Object)(verifyAssignmentResult = ReassignPartitionsCommand$.MODULE$.verifyAssignment((Admin)adminClient, reassignmentJson, false)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(0).append(new StringBuilder(48).append("Timed out waiting for verifyAssignment result ").append(expectedResult).append(". ").toString()).append(new StringBuilder(22).append("The latest result was ").append(verifyAssignmentResult).toString()).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
        return replicaToAdd;
    }

    public void appendMessagesAndWaitUntilTieredAndSynced(int leaderId, int followerId) {
        long endOffset = this.appendMessagesToLeaderAndWaitUntilTiered(leaderId, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog followerLog = (AbstractLog)((KafkaBroker)this.brokerForId(followerId).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$appendMessagesAndWaitUntilTieredAndSynced$1(endOffset, followerLog)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for all messages to be written, synced and tiered");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
    }

    public long appendMessagesToLeaderAndWaitUntilTiered(int leaderId, int numSegments) {
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        long oldLogEndOffset = log.logEndOffset();
        int oldNumSegments = log.numberOfSegments();
        int numMessages = 100;
        int n = 0;
        while (log.numberOfSegments() <= oldNumSegments + numSegments) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
            n += numMessages;
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(log.logEndOffset() == (long)n + oldLogEndOffset && log.tierPartitionState().numSegments() >= log.numberOfSegments() - 1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(0).append(new StringBuilder(122).append("Timeout waiting for all messages to be written, synced and tiered. oldLogEndOffset: ").append(oldLogEndOffset).append(", newLogEndOffset: ").append(log.logEndOffset()).append(", messages sent: ").append(n).append(", ").toString()).append(new StringBuilder(62).append("old numOfSegments: ").append(oldNumSegments).append(", new numOfSegments: ").append(log.numberOfSegments()).append(", tiered numSegments: ").append(log.tierPartitionState().numSegments()).toString()).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        return log.logEndOffset();
    }

    public int appendMessagesToLeaderAndWaitUntilTiered$default$2() {
        return 5;
    }

    public void fetchTieredAndLocalDataAndValidate(int leaderId, Option<Object> followerIdOpt) {
        AbstractLog leaderLog = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$fetchTieredAndLocalDataAndValidate$1(leaderLog)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseTierStateTest.$anonfun$fetchTieredAndLocalDataAndValidate$2(leaderLog));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        int leaderEpoch = ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getPartitionOrException(this.topicPartition()).getLeaderEpoch();
        long fetchSizeBytes = leaderLog.tierPartitionState().totalSize();
        this.fetchDataAndValidateResponses(leaderId, followerIdOpt, leaderEpoch, leaderLog.logStartOffset(), fetchSizeBytes, Errors.OFFSET_TIERED);
        fetchSizeBytes = leaderLog.size() - leaderLog.tierPartitionState().totalSize();
        this.fetchDataAndValidateResponses(leaderId, followerIdOpt, leaderEpoch, leaderLog.tierPartitionState().endOffset() + 1L, fetchSizeBytes, Errors.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public void fetchDataAndValidateResponses(int leaderId, Option<Object> followerIdOpt, int leaderEpoch, long fetchOffset, long size, Errors replicaErr) {
        short ver = 11;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(this.topicPartition(), new FetchRequest.PartitionData(Uuid.ZERO_UUID, fetchOffset, 0L, (int)size, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        FetchRequest consumerFetchRequest = FetchRequest.Builder.forConsumer((short)ver, (int)0, (int)0, partitionMap).build(ver);
        FetchResponseData.PartitionData consumerResponsePartitionData = (FetchResponseData.PartitionData)((FetchResponse)this.connectAndReceive((AbstractRequest)consumerFetchRequest, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).responseData(Collections.emptyMap(), ver).get(this.topicPartition());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)consumerResponsePartitionData.errorCode(), (String)"Unexpected error returned by consumer fetch request");
        if (followerIdOpt.isDefined()) {
            void forReplica_minBytes;
            void forReplica_maxWait;
            int n = (int)size;
            boolean bl = false;
            int forReplica_replicaId = BoxesRunTime.unboxToInt((Object)followerIdOpt.get());
            FetchRequest replicaFetchRequest = new FetchRequest.Builder(ver, ver, forReplica_replicaId, (int)forReplica_maxWait, (int)forReplica_minBytes, partitionMap).build(ver);
            FetchResponseData.PartitionData replicaResponsePartitionData = (FetchResponseData.PartitionData)((FetchResponse)this.connectAndReceive((AbstractRequest)replicaFetchRequest, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).responseData(Collections.emptyMap(), ver).get(this.topicPartition());
            Assertions.assertEquals((short)replicaErr.code(), (short)replicaResponsePartitionData.errorCode(), (String)"Unexpected error returned by replica fetch request");
        }
    }

    public void switchLeader(int currentLeaderId, int currentFollowerId) {
        this.killBroker(currentLeaderId);
        Partition partition = ((KafkaBroker)this.brokerForId(currentFollowerId).get()).replicaManager().getPartitionOrException(this.topicPartition());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!partition.isLeader()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for new leader to elect");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        this.restartDeadBroker(currentLeaderId, this.restartDeadBroker$default$2());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BaseTierStateTest.$anonfun$switchLeader$3(partition, currentLeaderId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for server to start");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
    }

    public Tuple2<Object, Object> createTopicAndGetReplicas() {
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topicPartition().topic(), 1, 2, this.props(), this.createTopic$default$5());
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        int replica1 = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        int replica2 = TestUtils$.MODULE$.findFollowerId(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers());
        return new Tuple2.mcII.sp(replica1, replica2);
    }

    public void changeTopicConfig(String propKey, String propValue, String topic) {
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(propKey, propValue), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, topic), Collections.singletonList(alterConfigOp));
        this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()).incrementalAlterConfigs(configs).all().get(5L, TimeUnit.SECONDS);
    }

    public String changeTopicConfig$default$3() {
        return this.topicPartition().topic();
    }

    public static final /* synthetic */ boolean $anonfun$waitForHotSetRetentionToKickIn$2(AbstractLog log$1) {
        return log$1.localLogStartOffset() > log$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$waitForHotSetRetentionToKickIn$3() {
        return "Timed out waiting for hot set retention to kick in";
    }

    public static final /* synthetic */ void $anonfun$verifyTieredSegmentsDeleted$2(BaseTierStateTest $this, BooleanRef deleted$1, TierObjectStore objStore$1, TierLogSegment segment$1, String topicName$1, IntRef retries$1, TierObjectStore.FileType fileType) {
        deleted$1.elem = false;
        while (!deleted$1.elem) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> objStore$1.getObject((TierObjectStore.ObjectStoreMetadata)segment$1.metadata(), fileType));
            if (try_ instanceof Success) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("[").append(topicName$1).append("] ").append(segment$1.metadata().toString()).append(" ").append(fileType.toString()).append(" not deleted yet. Back off and retry").toString());
                ++retries$1.elem;
                Assertions.assertTrue((retries$1.elem < 100 ? 1 : 0) != 0, (String)new StringBuilder(31).append("[").append(topicName$1).append("] ").append(segment$1.metadata().toString()).append(" ").append(fileType.toString()).append(" not deleted in max retries").toString());
                Thread.sleep(200L);
                continue;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                Assertions.assertEquals(TierObjectStoreRetriableException.class, exception.getClass(), (String)new StringBuilder(44).append("[").append(topicName$1).append("] Unexpected exception while checking for ").append(segment$1.metadata().toString()).append(" ").append(fileType.toString()).toString());
                deleted$1.elem = true;
                continue;
            }
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$verifyTieredSegmentsDeleted$1(BaseTierStateTest $this, TierObjectStore objStore$1, String topicName$1, TierLogSegment segment) {
        BooleanRef deleted = BooleanRef.create((boolean)false);
        IntRef retries = IntRef.create((int)0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])TierObjectStore.FileType.values()), (Function1 & Serializable)fileType -> {
            BaseTierStateTest.$anonfun$verifyTieredSegmentsDeleted$2($this, deleted, objStore$1, segment, topicName$1, retries, fileType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicaToGetInSync$3(Partition leaderPart$1, int followerId$1) {
        return leaderPart$1.inSyncReplicaIds().contains((Object)BoxesRunTime.boxToInteger((int)followerId$1));
    }

    public static final /* synthetic */ String $anonfun$waitForReplicaToGetInSync$4() {
        return "Timed out waiting replica to get in sync";
    }

    public static final /* synthetic */ boolean $anonfun$addReplicaToAssignment$5(ObjectRef latestResult$1, ConfluentAdmin adminClient$1, String reassignmentJson$1, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1) {
        latestResult$1.elem = ReassignPartitionsCommand$.MODULE$.verifyAssignment((Admin)adminClient$1, reassignmentJson$1, false);
        return expectedResult$1.equals((Object)((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem));
    }

    public static final /* synthetic */ String $anonfun$addReplicaToAssignment$6(ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1, ObjectRef latestResult$1) {
        return new StringBuilder(0).append(new StringBuilder(48).append("Timed out waiting for verifyAssignment result ").append(expectedResult$1).append(". ").toString()).append(new StringBuilder(22).append("The latest result was ").append((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesAndWaitUntilTieredAndSynced$1(long endOffset$1, AbstractLog followerLog$1) {
        return endOffset$1 == followerLog$1.logEndOffset();
    }

    public static final /* synthetic */ String $anonfun$appendMessagesAndWaitUntilTieredAndSynced$2() {
        return "Timeout waiting for all messages to be written, synced and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesToLeaderAndWaitUntilTiered$1(AbstractLog log$2, IntRef totalMessages$1, long oldLogEndOffset$1) {
        return log$2.logEndOffset() == (long)totalMessages$1.elem + oldLogEndOffset$1 && log$2.tierPartitionState().numSegments() >= log$2.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$appendMessagesToLeaderAndWaitUntilTiered$2(long oldLogEndOffset$1, AbstractLog log$2, IntRef totalMessages$1, int oldNumSegments$1) {
        return new StringBuilder(0).append(new StringBuilder(122).append("Timeout waiting for all messages to be written, synced and tiered. oldLogEndOffset: ").append(oldLogEndOffset$1).append(", newLogEndOffset: ").append(log$2.logEndOffset()).append(", messages sent: ").append(totalMessages$1.elem).append(", ").toString()).append(new StringBuilder(62).append("old numOfSegments: ").append(oldNumSegments$1).append(", new numOfSegments: ").append(log$2.numberOfSegments()).append(", tiered numSegments: ").append(log$2.tierPartitionState().numSegments()).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$fetchTieredAndLocalDataAndValidate$1(AbstractLog leaderLog$1) {
        return leaderLog$1.logStartOffset() < leaderLog$1.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$fetchTieredAndLocalDataAndValidate$2(AbstractLog leaderLog$1) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(leaderLog$1.logStartOffset()).append(" localLogStartOffset ").append(leaderLog$1.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$switchLeader$1(Partition partition$1) {
        return partition$1.isLeader();
    }

    public static final /* synthetic */ String $anonfun$switchLeader$2() {
        return "Timed out waiting for new leader to elect";
    }

    public static final /* synthetic */ boolean $anonfun$switchLeader$3(Partition partition$1, int currentLeaderId$1) {
        return partition$1.inSyncReplicaIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeaderId$1));
    }

    public static final /* synthetic */ String $anonfun$switchLeader$4() {
        return "Timed out waiting for server to start";
    }

    public BaseTierStateTest() {
        this.topicName = "foo";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierTopicDeleteBackoffMsProp(), "15000");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataMaxPollMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
    }
}

