/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.state.BaseTierStateTest;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.topic.TierTopic;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001\u0002\u0010 \u0001\u0019BQa\u000b\u0001\u0005\u00021BQA\f\u0001\u0005B=BqA\u000e\u0001A\u0002\u0013%q\u0007C\u0004<\u0001\u0001\u0007I\u0011\u0002\u001f\t\r\t\u0003\u0001\u0015)\u00039\u0011\u001d\u0019\u0005\u00011A\u0005\n]Bq\u0001\u0012\u0001A\u0002\u0013%Q\t\u0003\u0004H\u0001\u0001\u0006K\u0001\u000f\u0005\b\u0011\u0002\u0001\r\u0011\"\u00038\u0011\u001dI\u0005\u00011A\u0005\n)Ca\u0001\u0014\u0001!B\u0013A\u0004bB'\u0001\u0001\u0004%IA\u0014\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0011\u00199\u0007\u0001)Q\u0005\u001f\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007B\u0002:\u0001A\u0003%!\u000eC\u0004t\u0001\t\u0007I\u0011B5\t\rQ\u0004\u0001\u0015!\u0003k\u0011\u001d)\bA1A\u0005\n%DaA\u001e\u0001!\u0002\u0013Q\u0007bB<\u0001\u0005\u0004%I!\u001b\u0005\u0007q\u0002\u0001\u000b\u0011\u00026\t\u000fe\u0004\u0001\u0019!C\u0005u\"I\u0011q\u0001\u0001A\u0002\u0013%\u0011\u0011\u0002\u0005\b\u0003\u001b\u0001\u0001\u0015)\u0003|\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!!\f\u0001\t\u0013\ty\u0003C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\tY#+Z:u_J,Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bk\\:u%\u0016\u001cwN^3ss>3G)\u0019;b)\u0016\u001cHO\u0003\u0002!C\u0005)1\u000f^1uK*\u0011!eI\u0001\u0005i&,'OC\u0001%\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0014\u0011\u0005!JS\"A\u0010\n\u0005)z\"!\u0005\"bg\u0016$\u0016.\u001a:Ti\u0006$X\rV3ti\u00061A(\u001b8jiz\"\u0012!\f\t\u0003Q\u0001\t1B\u0019:pW\u0016\u00148i\\;oiV\t\u0001\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$GA\u0002J]R\f\u0011c\u001c7e\u0019><7\u000b^1si>3gm]3u+\u0005A\u0004CA\u0019:\u0013\tQ$G\u0001\u0003M_:<\u0017!F8mI2{wm\u0015;beR|eMZ:fi~#S-\u001d\u000b\u0003{\u0001\u0003\"!\r \n\u0005}\u0012$\u0001B+oSRDq!\u0011\u0003\u0002\u0002\u0003\u0007\u0001(A\u0002yIE\n!c\u001c7e\u0019><7\u000b^1si>3gm]3uA\u0005yq\u000e\u001c3M_\u001e,e\u000eZ(gMN,G/A\npY\u0012dunZ#oI>3gm]3u?\u0012*\u0017\u000f\u0006\u0002>\r\"9\u0011iBA\u0001\u0002\u0004A\u0014\u0001E8mI2{w-\u00128e\u001f\u001a47/\u001a;!\u0003EqWm\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\u0001\u0016]\u0016<Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$x\fJ3r)\ti4\nC\u0004B\u0015\u0005\u0005\t\u0019\u0001\u001d\u0002%9,w\u000fT8h'R\f'\u000f^(gMN,G\u000fI\u0001\u0015M&\u00148\u000f^*fO6,g\u000e^'fi\u0006$\u0017\r^1\u0016\u0003=\u00032!\r)S\u0013\t\t&G\u0001\u0004PaRLwN\u001c\t\u0003'\u0006t!\u0001\u00160\u000f\u0005UcfB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tIV%\u0001\u0004=e>|GOP\u0005\u0002I%\u0011!eI\u0005\u0003;\u0006\nQa\u001d;pe\u0016L!a\u00181\u0002\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016T!!X\u0011\n\u0005\t\u001c'aE(cU\u0016\u001cGo\u0015;pe\u0016lU\r^1eCR\f'BA0a\u0003a1\u0017N]:u'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uC~#S-\u001d\u000b\u0003{\u0019Dq!Q\u0007\u0002\u0002\u0003\u0007q*A\u000bgSJ\u001cHoU3h[\u0016tG/T3uC\u0012\fG/\u0019\u0011\u0002-\rdwN\\3e\r&\u00148\u000f^*fO6,g\u000e\u001e$jY\u0016,\u0012A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\f!![8\u000b\u0003=\fAA[1wC&\u0011\u0011\u000f\u001c\u0002\u0005\r&dW-A\fdY>tW\r\u001a$jeN$8+Z4nK:$h)\u001b7fA\u0005\t3\r\\8oK\u00124\u0015N]:u'\u0016<W.\u001a8u\u001f\u001a47/\u001a;J]\u0012,\u0007PR5mK\u0006\u00113\r\\8oK\u00124\u0015N]:u'\u0016<W.\u001a8u\u001f\u001a47/\u001a;J]\u0012,\u0007PR5mK\u0002\nAe\u00197p]\u0016$g)\u001b:tiN+w-\\3oiRKW.Z:uC6\u0004\u0018J\u001c3fq\u001aKG.Z\u0001&G2|g.\u001a3GSJ\u001cHoU3h[\u0016tG\u000fV5nKN$\u0018-\u001c9J]\u0012,\u0007PR5mK\u0002\n1c\u00197p]\u0016$G+[3s'R\fG/\u001a$jY\u0016\fAc\u00197p]\u0016$G+[3s'R\fG/\u001a$jY\u0016\u0004\u0013A\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015\u000e\\3QCRDW#A>\u0011\u0007q\f\tA\u0004\u0002~}B\u0011qKM\u0005\u0003\u007fJ\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003\u000b\u0011aa\u0015;sS:<'BA@3\u0003y!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GS2,\u0007+\u0019;i?\u0012*\u0017\u000fF\u0002>\u0003\u0017Aq!\u0011\r\u0002\u0002\u0003\u000710A\u000euS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)\u001b7f!\u0006$\b\u000eI\u0001,i\u0016\u001cHOU3ti>\u0014X\rT8h'R\f'\u000f^(gMN,G\u000fU8tiJ+7m\u001c<fef|e\rR1uCR\tQ\bK\u0002\u001b\u0003+\u0001B!a\u0006\u0002*5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0002ba&TA!a\b\u0002\"\u00059!.\u001e9ji\u0016\u0014(\u0002BA\u0012\u0003K\tQA[;oSRT!!a\n\u0002\u0007=\u0014x-\u0003\u0003\u0002,\u0005e!\u0001\u0002+fgR\fA\u0006Z3mKR,g)\u001b:tiRKWM]3e'\u0016<W.\u001a8u\u0003:$g+\u00197jI\u0006$XMT3x\u001f\u001a47/\u001a;\u0015\u000bu\n\t$!\u000e\t\r\u0005M2\u00041\u00011\u0003\u0019aW-\u00193fe\"9\u0011qG\u000eA\u0002\u0005e\u0012a\u00034pY2|w/\u001a:PaR\u00042!\r)1\u0003-\u0012\u0017mY6va\u001aK'o\u001d;TK\u001elWM\u001c;B]\u0012$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GS2,GcA\u001f\u0002@!1\u00111\u0007\u000fA\u0002A\nQC]3d_Z,'\u000fT8h'R\f'\u000f^(gMN,G\u000fF\u0003>\u0003\u000b\n9\u0005\u0003\u0004\u00024u\u0001\r\u0001\r\u0005\u0007\u0003\u0013j\u0002\u0019\u0001\u0019\u0002\u0011\u0019|G\u000e\\8xKJ\u0004")
public class RestoreLogStartOffsetPostRecoveryOfDataTest
extends BaseTierStateTest {
    private long oldLogStartOffset = 0L;
    private long oldLogEndOffset = 0L;
    private long newLogStartOffset = 0L;
    private Option<TierObjectStore.ObjectStoreMetadata> firstSegmentMetadata = None$.MODULE$;
    private final File clonedFirstSegmentFile = TestUtils.tempFile();
    private final File clonedFirstSegmentOffsetIndexFile = TestUtils.tempFile();
    private final File clonedFirstSegmentTimestampIndexFile = TestUtils.tempFile();
    private final File clonedTierStateFile = TestUtils.tempFile();
    private String tierPartitionStateFilePath = "";

    @Override
    public int brokerCount() {
        return 3;
    }

    private long oldLogStartOffset() {
        return this.oldLogStartOffset;
    }

    private void oldLogStartOffset_$eq(long x$1) {
        this.oldLogStartOffset = x$1;
    }

    private long oldLogEndOffset() {
        return this.oldLogEndOffset;
    }

    private void oldLogEndOffset_$eq(long x$1) {
        this.oldLogEndOffset = x$1;
    }

    private long newLogStartOffset() {
        return this.newLogStartOffset;
    }

    private void newLogStartOffset_$eq(long x$1) {
        this.newLogStartOffset = x$1;
    }

    private Option<TierObjectStore.ObjectStoreMetadata> firstSegmentMetadata() {
        return this.firstSegmentMetadata;
    }

    private void firstSegmentMetadata_$eq(Option<TierObjectStore.ObjectStoreMetadata> x$1) {
        this.firstSegmentMetadata = x$1;
    }

    private File clonedFirstSegmentFile() {
        return this.clonedFirstSegmentFile;
    }

    private File clonedFirstSegmentOffsetIndexFile() {
        return this.clonedFirstSegmentOffsetIndexFile;
    }

    private File clonedFirstSegmentTimestampIndexFile() {
        return this.clonedFirstSegmentTimestampIndexFile;
    }

    private File clonedTierStateFile() {
        return this.clonedTierStateFile;
    }

    private String tierPartitionStateFilePath() {
        return this.tierPartitionStateFilePath;
    }

    private void tierPartitionStateFilePath_$eq(String x$1) {
        this.tierPartitionStateFilePath = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRestoreLogStartOffsetPostRecoveryOfData() {
        void var3_3;
        void var2_2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        int replica2 = tuple2._2$mcI$sp();
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var2_2, (int)var3_3);
        this.waitForHotSetRetentionToKickIn((List<Object>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var2_2, var3_3}))));
        this.fetchTieredAndLocalDataAndValidate((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.backupFirstSegmentAndTierPartitionStateFile((int)var2_2);
        this.deleteFirstTieredSegmentAndValidateNewOffset((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.fetchTieredAndLocalDataAndValidate((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.recoverLogStartOffset((int)var2_2, (int)var3_3);
        this.fetchTieredAndLocalDataAndValidate((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.deleteFirstTieredSegmentAndValidateNewOffset((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var2_2, (int)var3_3);
        this.fetchTieredAndLocalDataAndValidate((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.switchLeader((int)var2_2, (int)var3_3);
        this.deleteFirstTieredSegmentAndValidateNewOffset((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var2_2)));
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var3_3, (int)var2_2);
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var2_2)));
        int replica3 = this.addReplicaToAssignment((int)var3_3);
        ((KafkaServer)this.serverForId((int)var2_2).get()).shutdown();
        ((KafkaServer)this.serverForId((int)var2_2).get()).awaitShutdown();
        this.switchLeader((int)var3_3, replica3);
        this.deleteFirstTieredSegmentAndValidateNewOffset(replica3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.appendMessagesAndWaitUntilTieredAndSynced(replica3, (int)var3_3);
        this.fetchTieredAndLocalDataAndValidate(replica3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
    }

    private void deleteFirstTieredSegmentAndValidateNewOffset(int leader, Option<Object> followerOpt) {
        AbstractLog leaderLog = (AbstractLog)((KafkaServer)this.serverForId(leader).get()).replicaManager().getLog(this.topicPartition()).get();
        String oldRetentionBytes = ((Hashtable)this.adminZkClient().getAllTopicConfigs().apply((Object)this.topicName())).get("retention.bytes").toString();
        Iterator segments = leaderLog.tierPartitionState().segments();
        Assertions.assertTrue((boolean)segments.hasNext());
        long newRetentionSize = leaderLog.size() - (long)((TierLogSegment)segments.next()).size();
        segments = leaderLog.tierPartitionState().segments();
        this.newLogStartOffset_$eq(((TierLogSegment)segments.next()).endOffset() + 1L);
        this.changeTopicConfig("retention.bytes", Long.toString(newRetentionSize), this.changeTopicConfig$default$3());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$1(this, leaderLog)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$2(this, leaderLog));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        Assertions.assertEquals((long)this.newLogStartOffset(), (long)leaderLog.logStartOffset());
        if (followerOpt.isDefined()) {
            AbstractLog followerLog = (AbstractLog)((KafkaServer)this.serverForId(BoxesRunTime.unboxToInt((Object)followerOpt.get())).get()).replicaManager().getLog(this.topicPartition()).get();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 30000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$3(this, followerLog)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$4(this, leaderLog));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 30000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$5(this, followerLog)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$6(this, followerLog));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), l3));
            }
        }
        this.changeTopicConfig("retention.bytes", oldRetentionBytes, this.changeTopicConfig$default$3());
    }

    private void backupFirstSegmentAndTierPartitionStateFile(int leader) {
        ReplicaManager leaderReplicaManager = ((KafkaServer)this.serverForId(leader).get()).replicaManager();
        AbstractLog leaderLog = (AbstractLog)leaderReplicaManager.getLog(this.topicPartition()).get();
        this.oldLogStartOffset_$eq(leaderLog.logStartOffset());
        this.oldLogEndOffset_$eq(leaderLog.logEndOffset());
        Iterator segments = leaderLog.tierPartitionState().segments();
        Assertions.assertTrue((boolean)segments.hasNext());
        TierLogSegment firstSegment = (TierLogSegment)segments.next();
        this.firstSegmentMetadata_$eq((Option<TierObjectStore.ObjectStoreMetadata>)new Some((Object)new TierObjectStore.ObjectMetadata(firstSegment.metadata().topicIdPartition(), firstSegment.objectId(), leaderLog.tierPartitionState().tierEpoch(), firstSegment.baseOffset(), firstSegment.metadata().hasAbortedTxns(), firstSegment.metadata().hasProducerState(), firstSegment.metadata().hasEpochState(), firstSegment.metadata().opaqueData())));
        TierObjectStore objectStore = (TierObjectStore)leaderReplicaManager.tierReplicaComponents().logComponents().objectStoreOpt().get();
        ByteStreams.copy((InputStream)objectStore.getObject((TierObjectStore.ObjectStoreMetadata)this.firstSegmentMetadata().get(), TierObjectStore.FileType.SEGMENT).getInputStream(), (OutputStream)new FileOutputStream(this.clonedFirstSegmentFile()));
        ByteStreams.copy((InputStream)objectStore.getObject((TierObjectStore.ObjectStoreMetadata)this.firstSegmentMetadata().get(), TierObjectStore.FileType.OFFSET_INDEX).getInputStream(), (OutputStream)new FileOutputStream(this.clonedFirstSegmentOffsetIndexFile()));
        ByteStreams.copy((InputStream)objectStore.getObject((TierObjectStore.ObjectStoreMetadata)this.firstSegmentMetadata().get(), TierObjectStore.FileType.TIMESTAMP_INDEX).getInputStream(), (OutputStream)new FileOutputStream(this.clonedFirstSegmentTimestampIndexFile()));
        FileTierPartitionState fileTierPartitionState = (FileTierPartitionState)leaderLog.tierPartitionState();
        fileTierPartitionState.flush();
        this.tierPartitionStateFilePath_$eq(fileTierPartitionState.flushedPath());
        ByteStreams.copy((InputStream)new FileInputStream(this.tierPartitionStateFilePath()), (OutputStream)new FileOutputStream(this.clonedTierStateFile()));
    }

    /*
     * WARNING - void declaration
     */
    private void recoverLogStartOffset(int leader, int follower) {
        Producer tierProducer = RecoveryUtils.createTierTopicProducer((Properties)this.producerConfig(), (String)"RestoreLogStartOffsetPostRecoveryOfData");
        String tierTopicName = TierTopic.topicName((String)this.serverConfig().getProperty(KafkaConfig$.MODULE$.TierMetadataNamespaceProp()));
        int numTierTopicPartitions = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp())));
        ReplicaManager leaderReplicaManager = ((KafkaServer)this.serverForId(leader).get()).replicaManager();
        AbstractLog leaderLog = (AbstractLog)leaderReplicaManager.getLog(this.topicPartition()).get();
        TierPartitionState leaderTierPartitionState = leaderLog.tierPartitionState();
        AbstractLog followerLog = (AbstractLog)((KafkaServer)this.serverForId(follower).get()).replicaManager().getLog(this.topicPartition()).get();
        TierPartitionState followerTierPartitionState = followerLog.tierPartitionState();
        TopicIdPartition topicIdPartition = (TopicIdPartition)leaderTierPartitionState.topicIdPartition().get();
        TierPartitionFence fencingEvent = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), true);
        RecoveryUtils.injectTierTopicEvent((Producer)tierProducer, (AbstractTierMetadata)fencingEvent, (String)tierTopicName, (int)numTierTopicPartitions);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$1(leaderTierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$2(leaderTierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$3(followerTierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$4(leaderTierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!leaderLog.isFrozenLogStartOffsetState()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for freezing log start offset on the leader after fencing.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = 30000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!followerLog.isFrozenLogStartOffsetState()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Timed out waiting for freezing log start offset on the follower after fencing.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)this.newLogStartOffset(), (long)leaderLog.logStartOffset());
        Assertions.assertEquals((long)this.newLogStartOffset(), (long)followerLog.logStartOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)leaderLog.logEndOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)followerLog.logEndOffset());
        TierObjectStore objectStore = (TierObjectStore)leaderReplicaManager.tierReplicaComponents().logComponents().objectStoreOpt().get();
        objectStore.putObject((TierObjectStore.ObjectStoreMetadata)this.firstSegmentMetadata().get(), this.clonedFirstSegmentFile(), TierObjectStore.FileType.SEGMENT);
        objectStore.putObject((TierObjectStore.ObjectStoreMetadata)this.firstSegmentMetadata().get(), this.clonedFirstSegmentOffsetIndexFile(), TierObjectStore.FileType.OFFSET_INDEX);
        objectStore.putObject((TierObjectStore.ObjectStoreMetadata)this.firstSegmentMetadata().get(), this.clonedFirstSegmentTimestampIndexFile(), TierObjectStore.FileType.TIMESTAMP_INDEX);
        OffsetAndEpoch restoreOffsetAndEpoch = leaderTierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch();
        TierPartitionForceRestore restoreEvent = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), this.oldLogStartOffset(), this.oldLogEndOffset(), restoreOffsetAndEpoch, "", Predef$.MODULE$.boolean2Boolean(true));
        TierObjectStore.TierStateRestoreSnapshotMetadata restoreMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(restoreEvent);
        objectStore.putObject((TierObjectStore.ObjectStoreMetadata)restoreMetadata, this.clonedTierStateFile(), TierObjectStore.FileType.TIER_STATE_SNAPSHOT);
        RecoveryUtils.injectTierTopicEvent((Producer)tierProducer, (AbstractTierMetadata)restoreEvent, (String)tierTopicName, (int)numTierTopicPartitions);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs5 = 30000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$9(this, leaderLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$10(this, leaderLog));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs6 = 30000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$11(this, followerLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$12(this, leaderLog));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionStatus.FROZEN_LOG_START_OFFSET, (Object)leaderTierPartitionState.status());
        Assertions.assertEquals((Object)TierPartitionStatus.FROZEN_LOG_START_OFFSET, (Object)followerTierPartitionState.status());
        Assertions.assertTrue((boolean)leaderLog.isFrozenLogStartOffsetState());
        Assertions.assertTrue((boolean)followerLog.isFrozenLogStartOffsetState());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)leaderLog.logEndOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)followerLog.logEndOffset());
        TierPartitionUnfreezeLogStartOffset unfreezeMetadata = new TierPartitionUnfreezeLogStartOffset(topicIdPartition, UUID.randomUUID());
        RecoveryUtils.injectTierTopicEvent((Producer)tierProducer, (AbstractTierMetadata)unfreezeMetadata, (String)tierTopicName, (int)numTierTopicPartitions);
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs7 = 30000L;
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$13(leaderTierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$14(leaderTierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
        }
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs8 = 30000L;
        long waitUntilTrue_startTime8 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$15(followerTierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs8) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$16(leaderTierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs8), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs9 = 30000L;
        long waitUntilTrue_startTime9 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$17(leaderLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime9 + waitUntilTrue_waitTimeMs9) {
                Assertions.fail((String)"Timed out waiting for unfreezing log start offset on the leader after fencing.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs9), (long)waitUntilTrue_pause));
        }
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs10 = 30000L;
        long waitUntilTrue_startTime10 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$19(followerLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime10 + waitUntilTrue_waitTimeMs10) {
                Assertions.fail((String)"Timed out waiting for unfreezing log start offset on the follower after fencing.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs10), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)this.oldLogStartOffset(), (long)leaderLog.logStartOffset());
        Assertions.assertEquals((long)this.oldLogStartOffset(), (long)followerLog.logStartOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)leaderLog.logEndOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)followerLog.logEndOffset());
        tierProducer.close();
    }

    public static final /* synthetic */ boolean $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$1(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$1) {
        return BoxesRunTime.equals(leaderLog$1.tierPartitionState().startOffset().get(), (Object)BoxesRunTime.boxToLong((long)$this.newLogStartOffset()));
    }

    public static final /* synthetic */ String $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$2(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$1) {
        return new StringBuilder(96).append("Timed out waiting for records being deleted. Leader's tierPartitionState.StartOffset: ").append(leaderLog$1.tierPartitionState().startOffset().get()).append(" expected ").append($this.newLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$3(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog followerLog$1) {
        return BoxesRunTime.equals(followerLog$1.tierPartitionState().startOffset().get(), (Object)BoxesRunTime.boxToLong((long)$this.newLogStartOffset()));
    }

    public static final /* synthetic */ String $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$4(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$1) {
        return new StringBuilder(98).append("Timed out waiting for records being deleted. Follower's tierPartitionState.StartOffset: ").append(leaderLog$1.tierPartitionState().startOffset().get()).append(" expected ").append($this.newLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$5(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog followerLog$1) {
        return $this.newLogStartOffset() == followerLog$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$6(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog followerLog$1) {
        return new StringBuilder(0).append(new StringBuilder(89).append("Timed out waiting for follower's log start offset to catch up: Follower logStartOffset: ").append(followerLog$1.logStartOffset()).append(" ").toString()).append(new StringBuilder(19).append(" expected offset = ").append($this.newLogStartOffset()).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$1(TierPartitionState leaderTierPartitionState$1) {
        return TierPartitionStatus.FROZEN_LOG_START_OFFSET.equals(leaderTierPartitionState$1.status());
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$2(TierPartitionState leaderTierPartitionState$1) {
        return new StringBuilder(111).append("Timed out waiting for tier partition state status after fencing. Leader's tierPartitionState.status: ").append(leaderTierPartitionState$1.status()).append(" expected ").append(TierPartitionStatus.FROZEN_LOG_START_OFFSET).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$3(TierPartitionState followerTierPartitionState$1) {
        return TierPartitionStatus.FROZEN_LOG_START_OFFSET.equals(followerTierPartitionState$1.status());
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$4(TierPartitionState leaderTierPartitionState$1) {
        return new StringBuilder(113).append("Timed out waiting for tier partition state status after fencing. Follower's tierPartitionState.status: ").append(leaderTierPartitionState$1.status()).append(" expected ").append(TierPartitionStatus.FROZEN_LOG_START_OFFSET).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$5(AbstractLog leaderLog$2) {
        return leaderLog$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$6() {
        return "Timed out waiting for freezing log start offset on the leader after fencing.";
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$7(AbstractLog followerLog$2) {
        return followerLog$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$8() {
        return "Timed out waiting for freezing log start offset on the follower after fencing.";
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$9(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$2) {
        return $this.oldLogStartOffset() == leaderLog$2.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$10(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$2) {
        return new StringBuilder(103).append("Timed out waiting for updated log start offset after force restore. Leader's logStartOffset: ").append(leaderLog$2.logStartOffset()).append(" expected ").append($this.oldLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$11(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog followerLog$2) {
        return $this.oldLogStartOffset() == followerLog$2.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$12(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$2) {
        return new StringBuilder(105).append("Timed out waiting for updated log start offset after force restore. Follower's logStartOffset: ").append(leaderLog$2.logStartOffset()).append(" expected ").append($this.oldLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$13(TierPartitionState leaderTierPartitionState$1) {
        return TierPartitionStatus.ONLINE.equals(leaderTierPartitionState$1.status());
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$14(TierPartitionState leaderTierPartitionState$1) {
        return new StringBuilder(112).append("Timed out waiting for tier partition state status after unfreeze. Leader's tierPartitionState.status: ").append(leaderTierPartitionState$1.status()).append(" expected ").append(TierPartitionStatus.ONLINE).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$15(TierPartitionState followerTierPartitionState$1) {
        return TierPartitionStatus.ONLINE.equals(followerTierPartitionState$1.status());
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$16(TierPartitionState leaderTierPartitionState$1) {
        return new StringBuilder(114).append("Timed out waiting for tier partition state status after unfreeze. Follower's tierPartitionState.status: ").append(leaderTierPartitionState$1.status()).append(" expected ").append(TierPartitionStatus.ONLINE).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$17(AbstractLog leaderLog$2) {
        return !leaderLog$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$18() {
        return "Timed out waiting for unfreezing log start offset on the leader after fencing.";
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$19(AbstractLog followerLog$2) {
        return !followerLog$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$20() {
        return "Timed out waiting for unfreezing log start offset on the follower after fencing.";
    }
}

