/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.IOException;
import java.io.InputStream;
import kafka.tier.store.AutoAbortingGenericInputStream;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AutoAbortingGenericInputStreamTest {
    @Test
    public void drainTest() throws IOException {
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 90;
            }
        });
        inputStream.close();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 100L, 110L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        int read2 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read2);
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }

    @Test
    public void excessiveDrainTest() throws IOException {
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        inputStream.close();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 100L, 300L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        int read2 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read2);
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }

    @Test
    public void readBufferNoBytesRemaininingTest() throws IOException {
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 9;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return -1;
            }
        });
        inputStream.close();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 10L, 20L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)9, (int)read1);
        int read2 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)-1, (int)read2);
        Assertions.assertEquals((long)11L, (long)autoAborting.remainingBytes());
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }

    @Test
    public void readSingleNoBytesRemaininingTest() throws IOException {
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        EasyMock.expect((Object)inputStream.read()).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 17;
            }
        });
        EasyMock.expect((Object)inputStream.read()).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return -1;
            }
        });
        inputStream.close();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 10L, 20L);
        int read1 = autoAborting.read();
        Assertions.assertEquals((int)17, (int)read1);
        int read2 = autoAborting.read();
        Assertions.assertEquals((int)-1, (int)read2);
        Assertions.assertEquals((long)19L, (long)autoAborting.remainingBytes());
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }

    @Test
    public void exceptionOnReadAttemptReread() throws IOException {
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andThrow((Throwable)new IOException("failed to read"));
        inputStream.close();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 100L, 300L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        Assertions.assertThrows(IOException.class, () -> autoAborting.read(new byte[10]));
        Assertions.assertThrows(IllegalStateException.class, () -> autoAborting.read(new byte[10]));
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }

    @Test
    public void abortTest() throws IOException {
        InputStream inputStream = (InputStream)EasyMock.createNiceMock(InputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andThrow((Throwable)new IOException("failed to read"));
        inputStream.close();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingGenericInputStream autoAborting = new AutoAbortingGenericInputStream(inputStream, 100L, 110L);
        int read1 = autoAborting.read(new byte[10]);
        Assertions.assertEquals((int)10, (int)read1);
        Assertions.assertThrows(IOException.class, () -> autoAborting.read(new byte[10]));
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }
}

