/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.GcsTierObjectStore;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}b\u0001\u0002\u0015*\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004D\u0001\u0001\u0006I!\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u0019\t\u0006\u0001)A\u0005\r\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006BB,\u0001A\u0003%A\u000bC\u0004Y\u0001\t\u0007I\u0011A-\t\ru\u0003\u0001\u0015!\u0003[\u0011\u001dq\u0006A1A\u0005\u0002}Ca\u0001\u001d\u0001!\u0002\u0013\u0001\u0007bB9\u0001\u0005\u0004%\tA\u001d\u0005\u0007w\u0002\u0001\u000b\u0011B:\t\u000fq\u0004!\u0019!C\u0001{\"9\u0011\u0011\u0002\u0001!\u0002\u0013q\b\"CA\u0006\u0001\t\u0007I\u0011AA\u0007\u0011!\ty\u0002\u0001Q\u0001\n\u0005=\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u000b\u0002A\u0011AA\u0012\u0011\u001d\ty\u0005\u0001C\u0001\u0003GAq!a\u0015\u0001\t\u0003\t\u0019\u0003C\u0004\u0002X\u0001!\t!a\t\t\u000f\u0005m\u0003\u0001\"\u0001\u0002$!9\u0011q\f\u0001\u0005\u0002\u0005\r\u0002bBA2\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003O\u0002A\u0011AA\u0012\u0011\u001d\tY\u0007\u0001C\u0001\u0003GAq!a\u001c\u0001\t\u0003\t\u0019\u0003C\u0004\u0002t\u0001!\t!a\t\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAX\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003g\u0003A\u0011AA\u0012\r\u0019\t9\f\u0001\u0001\u0002:\"Q\u00111\u001e\u0012\u0003\u0006\u0004%\t!!<\t\u0015\u0005u(E!A!\u0002\u0013\ty\u000f\u0003\u00048E\u0011\u0005\u0011q \u0005\b\u0005\u000f\u0011C\u0011\tB\u0005\u0011\u001d\u0011)B\tC\u0001\u0005/\u0011acR2t)&,'o\u00142kK\u000e$8\u000b^8sKR+7\u000f\u001e\u0006\u0003U-\nQa\u001d;pe\u0016T!\u0001L\u0017\u0002\tQLWM\u001d\u0006\u0002]\u0005)1.\u00194lC\u000e\u00011C\u0001\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011!K\u0001\t[>\u001c7\u000eV5nKV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002A[\u0005)Q\u000f^5mg&\u0011!i\u0010\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\bgR|'/Y4f+\u00051\u0005CA$P\u001b\u0005A%B\u0001#J\u0015\tQ5*A\u0003dY>,HM\u0003\u0002M\u001b\u00061qm\\8hY\u0016T\u0011AT\u0001\u0004G>l\u0017B\u0001)I\u0005\u001d\u0019Fo\u001c:bO\u0016\f\u0001b\u001d;pe\u0006<W\rI\u0001\u0007EV\u001c7.\u001a;\u0016\u0003Q\u0003\"aR+\n\u0005YC%A\u0002\"vG.,G/A\u0004ck\u000e\\W\r\u001e\u0011\u0002\r\r|gNZ5h+\u0005Q\u0006C\u0001\u001e\\\u0013\ta\u0016F\u0001\rHGN$\u0016.\u001a:PE*,7\r^*u_J,7i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0005nKR\fG-\u0019;b+\u0005\u0001\u0007CA1n\u001d\t\u00117N\u0004\u0002dU:\u0011A-\u001b\b\u0003K\"l\u0011A\u001a\u0006\u0003O>\na\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\ta\u0017&A\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0013\tqwN\u0001\bPE*,7\r^'fi\u0006$\u0017\r^1\u000b\u00051L\u0013!C7fi\u0006$\u0017\r^1!\u0003!!Xm\u001d;GS2,W#A:\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018AA5p\u0015\u0005A\u0018\u0001\u00026bm\u0006L!A_;\u0003\t\u0019KG.Z\u0001\ni\u0016\u001cHOR5mK\u0002\n!A\u00192\u0016\u0003y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004]\f1A\\5p\u0013\u0011\t9!!\u0001\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0002cE\u0002\n\u0011\"\\1ti\u0016\u00148*Z=\u0016\u0005\u0005=\u0001\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0005i&t7NC\u0002\u0002\u001a-\u000baa\u0019:zaR|\u0017\u0002BA\u000f\u0003'\u0011A!Q3bI\u0006QQ.Y:uKJ\\U-\u001f\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u0005\u0015\u0002c\u0001\u001a\u0002(%\u0019\u0011\u0011F\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0004%\u00055\u0002\u0003BA\u0018\u0003\u0003j!!!\r\u000b\t\u0005M\u0012QG\u0001\u0004CBL'\u0002BA\u001c\u0003s\tqA[;qSR,'O\u0003\u0003\u0002<\u0005u\u0012!\u00026v]&$(BAA \u0003\ry'oZ\u0005\u0005\u0003\u0007\n\tD\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0002^3tiNKgn\u001a7f!V$\bfA\n\u0002JA!\u0011qFA&\u0013\u0011\ti%!\r\u0003\tQ+7\u000f^\u0001\bi\u0016\u001cHo\u0011*DQ\r!\u0012\u0011J\u0001\u001di\u0016\u001cHoU5oO2,\u0007+\u001e;XSRD\u0017IY8si\u0016$G\u000b\u001f8tQ\r)\u0012\u0011J\u0001%i\u0016\u001cHoU5oO2,\u0007+\u001e;Qe>$WoY3s'R\fG/Z#q_\u000eD7\u000b^1uK\"\u001aa#!\u0013\u0002)Q,7\u000f\u001e#fY\u0016$X-\u00117m'V\u001c7-Z:tQ\r9\u0012\u0011J\u0001!i\u0016\u001cH\u000fR3mKR,7k\\7f\r\u0006LG.\u001a3HKR,\u0005pY3qi&|g\u000eK\u0002\u0019\u0003\u0013\n!\u0005^3ti\u0012+G.\u001a;f'>lWMR1jY\u0016$w)\u001a;O_\u0016C8-\u001a9uS>t\u0007fA\r\u0002J\u0005\u0011D/Z:u\u000b:\u001c'/\u001f9uK\u00124U\r^2i/&$\bNT8F]\u000e\u0014\u0018\u0010\u001d;j_:\\U-_'b]\u0006<WM\u001d+ie><8\u000fK\u0002\u001b\u0003\u0013\n\u0011\b^3ti\u001e\u001b7\u000fV5fe>\u0013'.Z2u'R|'/Z\"p]N$(/^2u)\"\u0014xn^:XSRD\u0017J\u001c<bY&$7*Z=D_:4\u0017n\u001a\u0015\u00047\u0005%\u0013A\u000b;fgR\u0004&/\u001a9QkR\u001cVmZ7f]R<\u0016\u000e\u001e5F]\u000e\u0014\u0018\u0010\u001d;j_:\\U-_'b]\u0006<WM\u001d\u0015\u00049\u0005%\u0013!\f;fgR\u0004&/\u001a9QkR\u001cVmZ7f]R<\u0016\u000e\u001e5pkR,en\u0019:zaRLwN\\&fs6\u000bg.Y4fe\"\u001aQ$!\u0013\u0002aQ,7\u000f^#oGJL\b\u000f^3e'\u0016<W.\u001a8u%\u0016\fG-V:fg\u0016s7M]=qi&|gnS3z\u001b\u0006t\u0017mZ3s)\u0011\t)#a\u001f\t\u000f\u0005ud\u00041\u0001\u0002\u0000\u0005Aa-\u001b7fif\u0004X\rE\u0002b\u0003\u0003K1!a!p\u0005!1\u0015\u000e\\3UsB,\u0007f\u0002\u0010\u0002\b\u0006]\u0015\u0011\u0014\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BAI\u0003k\ta\u0001]1sC6\u001c\u0018\u0002BAK\u0003\u0017\u0013!\"\u00128v[N{WO]2f\u0003\u00151\u0018\r\\;fG\t\ty\bK\u0002\u001f\u0003;\u0003B!a(\u0002\"6\u0011\u0011qR\u0005\u0005\u0003G\u000byIA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fq\u0004^3ti\u0016s7M]=qi\u0016$'+Z1e%\u00164'/Z:iKN\u001c\u0015m\u00195f)\u0011\t)#!+\t\u000f\u0005ut\u00041\u0001\u0002\u0000!:q$a\"\u0002\u0018\u0006e\u0005fA\u0010\u0002\u001e\u0006\tB/Z:u\u000b:\u001c'/\u001f9uK\u0012\u0004V\u000f^:)\u0007\u0001\nI%\u0001\u000euKN$XI\\2ssB$X\r\u001a*fgR|'/\u001a\"z\u0007>\u0004\u0018\u0010K\u0002\"\u0003\u0013\u00121eR2t'R|'/Y4f\u0007>\u0004\u0018PU3rk\u0016\u001cHo\u00149uS>t7/T1uG\",'/\u0006\u0003\u0002<\u0006e7#\u0002\u0012\u0002>\u0006%\u0007\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\rw/\u0001\u0003mC:<\u0017\u0002BAd\u0003\u0003\u0014aa\u00142kK\u000e$\bCBAf\u0003#\f).\u0004\u0002\u0002N*!\u0011qZA\u001f\u0003\u001diwnY6ji>LA!a5\u0002N\ny\u0011I]4v[\u0016tG/T1uG\",'\u000f\u0005\u0003\u0002X\u0006eG\u0002\u0001\u0003\b\u00037\u0014#\u0019AAo\u0005\u0005!\u0016\u0003BAp\u0003K\u00042AMAq\u0013\r\t\u0019o\r\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u0014q]\u0005\u0004\u0003S\u001c$aA!os\u0006Y1m\u001c9z%\u0016\fX/Z:u+\t\ty\u000f\u0005\u0003\u0002r\u0006]hbA$\u0002t&\u0019\u0011Q\u001f%\u0002\u000fM#xN]1hK&!\u0011\u0011`A~\u0005-\u0019u\u000e]=SKF,Xm\u001d;\u000b\u0007\u0005U\b*\u0001\u0007d_BL(+Z9vKN$\b\u0005\u0006\u0003\u0003\u0002\t\u0015\u0001#\u0002B\u0002E\u0005UW\"\u0001\u0001\t\u000f\u0005-X\u00051\u0001\u0002p\u00069Q.\u0019;dQ\u0016\u001cH\u0003\u0002B\u0006\u0005#\u00012A\rB\u0007\u0013\r\u0011ya\r\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011\u0019B\na\u0001\u0003+\f\u0001\"\u0019:hk6,g\u000e^\u0001\u0012_B$\u0018n\u001c8MSN$X*\u0019;dQ\u0016\u001cHC\u0002B\u0006\u00053\u0011\t\u0004C\u0004\u0003\u001c\u001d\u0002\rA!\b\u0002\u0017=\u0004H/[8o\u0019&\u001cH/\r\u0019\u0005\u0005?\u0011i\u0003\u0005\u0004\u0003\"\t\u001d\"1F\u0007\u0003\u0005GQ1A!\nx\u0003\u0011)H/\u001b7\n\t\t%\"1\u0005\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002X\n5B\u0001\u0004B\u0018\u00053\t\t\u0011!A\u0003\u0002\u0005u'aA0%c!9!1G\u0014A\u0002\tU\u0012aC8qi&|g\u000eT5tiJ\u0002DAa\u000e\u0003<A1!\u0011\u0005B\u0014\u0005s\u0001B!a6\u0003<\u0011a!Q\bB\u0019\u0003\u0003\u0005\tQ!\u0001\u0002^\n\u0019q\f\n\u001a")
public class GcsTierObjectStoreTest {
    private final MockTime mockTime = new MockTime();
    private final Storage storage = (Storage)Mockito.mock(Storage.class);
    private final Bucket bucket = (Bucket)Mockito.mock(Bucket.class);
    private final GcsTierObjectStoreConfig config = GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"prefix", (String)"region", (Integer)Predef$.MODULE$.int2Integer(10240), (String)"path", null, null);
    private final TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    private final File testFile = TestUtils.tempFile();
    private final ByteBuffer bb = ByteBuffer.allocate(0);
    private final Aead masterKey;

    public MockTime mockTime() {
        return this.mockTime;
    }

    public Storage storage() {
        return this.storage;
    }

    public Bucket bucket() {
        return this.bucket;
    }

    public GcsTierObjectStoreConfig config() {
        return this.config;
    }

    public TierObjectStore.ObjectMetadata metadata() {
        return this.metadata;
    }

    public File testFile() {
        return this.testFile;
    }

    public ByteBuffer bb() {
        return this.bb;
    }

    public Aead masterKey() {
        return this.masterKey;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.storage().get(ArgumentMatchers.anyString(), new Storage.BucketGetOption[]{(Storage.BucketGetOption)ArgumentMatchers.any(Storage.BucketGetOption.class)})).thenReturn((Object)this.bucket());
        Mockito.when((Object)this.storage().writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0])).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)this.storage().writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.any(Storage.BlobWriteOption.class)})).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)this.storage().copy((Storage.CopyRequest)ArgumentMatchers.any(Storage.CopyRequest.class))).thenReturn(Mockito.mock(CopyWriter.class));
        Mockito.when((Object)this.bucket().getLocation()).thenReturn((Object)"REGION");
    }

    @Test
    public void testSinglePut() {
        new GcsTierObjectStore(this.storage(), null, this.config()).putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)3))).writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0]);
    }

    @Test
    public void testCRC() {
        ByteBuffer al = ByteBuffer.allocate(5);
        al.put((byte)1);
        al.flip();
        Assertions.assertEquals((Object)"oBbQUg==", (Object)GcsTierObjectStore.crc32c((ByteBuffer)al));
    }

    @Test
    public void testSinglePutWithAbortedTxns() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArgumentCaptor capturedBlobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor capturedOption = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);
        objectStore.putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.of(this.bb()), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)4))).writer((BlobInfo)capturedBlobInfos.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)capturedOption.capture()});
        List captureds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedBlobInfos.getAllValues()).asScala().map((Function1 & Serializable)x$1 -> x$1)).map((Function1 & Serializable)x$2 -> x$2.getCrc32c())).toList();
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{null, null, null, "AAAAAA=="})), (Object)captureds);
        Assertions.assertEquals((Object)Storage.BlobWriteOption.crc32cMatch(), (Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedOption.getAllValues()).asScala().map((Function1 & Serializable)x$3 -> x$3)).head());
    }

    @Test
    public void testSinglePutProducerStateEpochState() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArgumentCaptor capturedBlobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor capturedOption = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);
        objectStore.putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.of(this.testFile()), Optional.empty(), Optional.of(this.bb()));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)5))).writer((BlobInfo)capturedBlobInfos.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)capturedOption.capture()});
        List captureds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedBlobInfos.getAllValues()).asScala().map((Function1 & Serializable)x$4 -> x$4)).map((Function1 & Serializable)x$5 -> x$5.getCrc32c())).toList();
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{null, null, null, null, "AAAAAA=="})), (Object)captureds);
        Assertions.assertEquals((Object)Storage.BlobWriteOption.crc32cMatch(), (Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedOption.getAllValues()).asScala().map((Function1 & Serializable)x$6 -> x$6)).head());
    }

    @Test
    public void testDeleteAllSuccess() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        objectStore.deleteSegment(this.metadata());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)0))).get((BlobId)ArgumentMatchers.any(BlobId.class));
    }

    @Test
    public void testDeleteSomeFailedGetException() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn((Object)blob);
        try {
            objectStore.deleteSegment(this.metadata());
        }
        catch (TierObjectStoreRetriableException tierObjectStoreRetriableException) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(BlobId.class));
            ((BlobInfo)Mockito.verify((Object)blob, (VerificationMode)Mockito.atLeastOnce())).getBlobId();
            return;
        }
        Assertions.fail((String)"TierObjectStoreRetriableException should have been thrown when attempting to delete segments");
    }

    @Test
    public void testDeleteSomeFailedGetNoException() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn(null);
        objectStore.deleteSegment(this.metadata());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)2))).get((BlobId)ArgumentMatchers.any(BlobId.class));
    }

    @Test
    public void testEncryptedFetchWithNoEncryptionKeyManagerThrows() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.fromByteArray((byte[])"foo".getBytes()));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.SEGMENT));
    }

    @Test
    public void testGcsTierObjectStoreConstructThrowsWithInvalidKeyConfig() {
        GcsTierObjectStoreConfig config = GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"prefix", (String)"region", (Integer)Predef$.MODULE$.int2Integer(10240), (String)"path", (String)"invalid", (Duration)Duration.ofSeconds(30L));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> new GcsTierObjectStore((Time)this.mockTime(), null, config));
    }

    @Test
    public void testPrepPutSegmentWithEncryptionKeyManager() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.OpaqueData opaqueData1 = objectStore.prepPutSegment();
        TierObjectStore.OpaqueData opaqueData2 = objectStore.prepPutSegment();
        Assertions.assertTrue((boolean)Arrays.equals(opaqueData1.intoByteArray(), opaqueData2.intoByteArray()));
        this.mockTime().sleep(31000L);
        Assertions.assertFalse((boolean)Arrays.equals(opaqueData1.intoByteArray(), objectStore.prepPutSegment().intoByteArray()));
    }

    @Test
    public void testPrepPutSegmentWithoutEncryptionKeyManager() {
        Assertions.assertTrue((boolean)Arrays.equals(new GcsTierObjectStore(this.storage(), null, this.config()).prepPutSegment().intoByteArray(), TierObjectStore.OpaqueData.ZEROED.intoByteArray()));
    }

    @ParameterizedTest
    @EnumSource(value=TierObjectStore.FileType.class)
    public void testEncryptedSegmentReadUsesEncryptionKeyManager(TierObjectStore.FileType filetype) {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        ReadChannel reader = (ReadChannel)Mockito.mock(ReadChannel.class);
        Mockito.when((Object)this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.any()})).thenReturn((Object)reader).thenReturn((Object)reader);
        objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, filetype);
        if (filetype.equals((Object)TierObjectStore.FileType.SEGMENT)) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
            return;
        }
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
    }

    @ParameterizedTest
    @EnumSource(value=TierObjectStore.FileType.class)
    public void testEncryptedReadRefreshesCache(TierObjectStore.FileType filetype) {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        encryptionKeyManager.clear();
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))})).thenReturn((Object)blob);
        Mockito.when((Object)blob.getMetadata()).thenReturn((Object)expectedKeyContext.metadata);
        ReadChannel reader = (ReadChannel)Mockito.mock(ReadChannel.class);
        Mockito.when((Object)this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.any()})).thenReturn((Object)reader).thenReturn((Object)reader);
        objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, filetype);
        if (filetype.equals((Object)TierObjectStore.FileType.SEGMENT)) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))});
            return;
        }
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))});
    }

    @Test
    public void testEncryptedPuts() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        objectStore.putSegment(metadata, this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).writer((BlobInfo)ArgumentMatchers.any(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.encryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
    }

    @Test
    public void testEncryptedRestoreByCopy() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        String dataKeyBase64 = encryptionKeyManager.keyContext((KeySha)keySha).cleartextDataKey.base64Encoded();
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        String versionId = "1234";
        String bucketName = "bucket";
        String segmentPath = metadata.toPath("", TierObjectStore.FileType.SEGMENT);
        BlobId source = BlobId.of((String)bucketName, (String)segmentPath, (Long)Predef$.MODULE$.long2Long(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(versionId))));
        BlobId target = BlobId.of((String)bucketName, (String)segmentPath);
        Storage.BlobTargetOption targetOption = Storage.BlobTargetOption.encryptionKey((String)dataKeyBase64);
        Storage.CopyRequest copyRequest = Storage.CopyRequest.newBuilder().setSource(source).setSourceOptions(new Storage.BlobSourceOption[]{Storage.BlobSourceOption.decryptionKey((String)dataKeyBase64)}).setTarget(target, new Storage.BlobTargetOption[]{targetOption}).build();
        objectStore.restoreObjectByCopy(metadata, segmentPath, new VersionInformation(versionId));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).copy((Storage.CopyRequest)ArgumentMatchers.argThat(new GcsStorageCopyRequestOptionsMatcher(this, copyRequest)));
        String indexFilePath = metadata.toPath("", TierObjectStore.FileType.OFFSET_INDEX);
        BlobId source2 = BlobId.of((String)bucketName, (String)indexFilePath, (Long)Predef$.MODULE$.long2Long(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(versionId))));
        BlobId target2 = BlobId.of((String)bucketName, (String)indexFilePath);
        Storage.CopyRequest copyRequest2 = Storage.CopyRequest.newBuilder().setSource(source2).setTarget(target2).build();
        objectStore.restoreObjectByCopy(metadata, indexFilePath, new VersionInformation(versionId));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).copy((Storage.CopyRequest)ArgumentMatchers.argThat(new GcsStorageCopyRequestOptionsMatcher(this, copyRequest2)));
    }

    public GcsTierObjectStoreTest() {
        AeadConfig.register();
        this.masterKey = (Aead)KeysetHandle.generateNew((KeyTemplate)KeyTemplates.get((String)"AES256_GCM_RAW")).getPrimitive(Aead.class);
    }

    public class GcsStorageCopyRequestOptionsMatcher<T>
    implements ArgumentMatcher<T> {
        private final Storage.CopyRequest copyRequest;
        public final /* synthetic */ GcsTierObjectStoreTest $outer;

        public Storage.CopyRequest copyRequest() {
            return this.copyRequest;
        }

        public boolean matches(T argument) {
            Storage.CopyRequest other = (Storage.CopyRequest)argument;
            return this.optionListMatches(this.copyRequest().getSourceOptions(), other.getSourceOptions()) && this.optionListMatches(this.copyRequest().getTargetOptions(), other.getTargetOptions());
        }

        public boolean optionListMatches(java.util.List<?> optionList1, java.util.List<?> optionList2) {
            if (optionList1 == null && optionList2 == null) {
                return true;
            }
            if (optionList1 == null) {
                return false;
            }
            if (optionList2 == null) {
                return false;
            }
            if (optionList1.size() != optionList2.size()) {
                return false;
            }
            return optionList1.containsAll(optionList2);
        }

        public /* synthetic */ GcsTierObjectStoreTest kafka$tier$store$GcsTierObjectStoreTest$GcsStorageCopyRequestOptionsMatcher$$$outer() {
            return this.$outer;
        }

        public GcsStorageCopyRequestOptionsMatcher(GcsTierObjectStoreTest $outer, Storage.CopyRequest copyRequest) {
            this.copyRequest = copyRequest;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

