/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreMetricsEnabled;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.utils.MockTime;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005q4A\u0001F\u000b\u00019!)1\u0005\u0001C\u0001I!9q\u0005\u0001a\u0001\n\u0003A\u0003bB\u001b\u0001\u0001\u0004%\tA\u000e\u0005\u0007y\u0001\u0001\u000b\u0015B\u0015\t\u000fu\u0002\u0001\u0019!C\u0001}!9!\t\u0001a\u0001\n\u0003\u0019\u0005BB#\u0001A\u0003&q\bC\u0004G\u0001\u0001\u0007I\u0011A$\t\u000f-\u0003\u0001\u0019!C\u0001\u0019\"1a\n\u0001Q!\n!Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004U\u0001\u0001\u0006I!\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0011\u0019q\u0006\u0001)A\u0005/\"9q\f\u0001b\u0001\n\u0003\u0001\u0007BB4\u0001A\u0003%\u0011\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003v\u0001\u0011\u0005\u0011\u000eC\u0003{\u0001\u0011\u0005\u0011NA\u0011US\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u001b\u0016$(/[2t\u000b:\f'\r\\3e)\u0016\u001cHO\u0003\u0002\u0017/\u0005)1\u000f^8sK*\u0011\u0001$G\u0001\u0005i&,'OC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\tQ#A\u0004nKR\u0014\u0018nY:\u0016\u0003%\u0002\"AK\u001a\u000e\u0003-R!a\n\u0017\u000b\u00055r\u0013AB2p[6|gN\u0003\u0002\u001b_)\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0013\t!4FA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003oi\u0002\"A\b\u001d\n\u0005ez\"\u0001B+oSRDqaO\u0002\u0002\u0002\u0003\u0007\u0011&A\u0002yIE\n\u0001\"\\3ue&\u001c7\u000fI\u0001\f_\nTWm\u0019;Ti>\u0014X-F\u0001@!\t1\u0003)\u0003\u0002B+\tYRj\\2l\u0013:lU-\\8ssRKWM](cU\u0016\u001cGo\u0015;pe\u0016\fqb\u001c2kK\u000e$8\u000b^8sK~#S-\u001d\u000b\u0003o\u0011Cqa\u000f\u0004\u0002\u0002\u0003\u0007q(\u0001\u0007pE*,7\r^*u_J,\u0007%A\rnKR\u0014\u0018nY:F]\u0006\u0014G.\u001a3PE*,7\r^*u_J,W#\u0001%\u0011\u0005\u0019J\u0015B\u0001&\u0016\u0005u!\u0016.\u001a:PE*,7\r^*u_J,W*\u001a;sS\u000e\u001cXI\\1cY\u0016$\u0017!H7fiJL7m]#oC\ndW\rZ(cU\u0016\u001cGo\u0015;pe\u0016|F%Z9\u0015\u0005]j\u0005bB\u001e\n\u0003\u0003\u0005\r\u0001S\u0001\u001b[\u0016$(/[2t\u000b:\f'\r\\3e\u001f\nTWm\u0019;Ti>\u0014X\rI\u0001\te\u0016\u001c\bo\u001c8tKV\t\u0011\u000b\u0005\u0002'%&\u00111+\u0006\u0002\u0018)&,'o\u00142kK\u000e$8\u000b^8sKJ+7\u000f]8og\u0016\f\u0011B]3ta>t7/\u001a\u0011\u0002\u00115,G/\u00193bi\u0006,\u0012a\u0016\t\u00031ns!AJ-\n\u0005i+\u0012a\u0004+jKJ|%M[3diN#xN]3\n\u0005qk&AD(cU\u0016\u001cG/T3uC\u0012\fG/\u0019\u0006\u00035V\t\u0011\"\\3uC\u0012\fG/\u0019\u0011\u0002\tQLW.Z\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011A-G\u0001\u0006kRLGn]\u0005\u0003M\u000e\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002o!\u0012\u0011c\u001b\t\u0003YNl\u0011!\u001c\u0006\u0003]>\f1!\u00199j\u0015\t\u0001\u0018/A\u0004kkBLG/\u001a:\u000b\u0005I\f\u0014!\u00026v]&$\u0018B\u0001;n\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\fi\u0016\u001cH/T3ue&\u001c7\u000f\u000b\u0002\u0013oB\u0011A\u000e_\u0005\u0003s6\u0014A\u0001V3ti\u0006\u0011B/Z:u\u0019\u0006$XM\\2z\u001b\u0016$(/[2tQ\t\u0019r\u000f")
public class TierObjectStoreMetricsEnabledTest {
    private Metrics metrics = null;
    private MockInMemoryTierObjectStore objectStore = null;
    private TierObjectStoreMetricsEnabled metricsEnabledObjectStore = null;
    private final TierObjectStoreResponse response = (TierObjectStoreResponse)Mockito.mock(TierObjectStoreResponse.class);
    private final TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    private final MockTime time = new MockTime(100L, 1000L);

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public MockInMemoryTierObjectStore objectStore() {
        return this.objectStore;
    }

    public void objectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.objectStore = x$1;
    }

    public TierObjectStoreMetricsEnabled metricsEnabledObjectStore() {
        return this.metricsEnabledObjectStore;
    }

    public void metricsEnabledObjectStore_$eq(TierObjectStoreMetricsEnabled x$1) {
        this.metricsEnabledObjectStore = x$1;
    }

    public TierObjectStoreResponse response() {
        return this.response;
    }

    public TierObjectStore.ObjectMetadata metadata() {
        return this.metadata;
    }

    public MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setup() {
        this.metrics_$eq(new Metrics());
        this.objectStore_$eq((MockInMemoryTierObjectStore)Mockito.mock(MockInMemoryTierObjectStore.class));
        this.metricsEnabledObjectStore_$eq(new TierObjectStoreMetricsEnabled((TierObjectStore)this.objectStore(), this.metrics(), (Time)this.time()));
    }

    @Test
    public void testMetrics() {
        MetricName segmentFetchedTotal = new MetricName("SegmentFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName offsetIndexFetchedTotal = new MetricName("OffsetIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName timestampIndexFetchedTotal = new MetricName("TimestampIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName transactionIndexFetchedTotal = new MetricName("TransactionIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName producerStateFetchedTotal = new MetricName("ProducerStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName epochStateFetchedTotal = new MetricName("EpochStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName tierStateFetchedTotal = new MetricName("TierStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        Mockito.when((Object)this.objectStore().getObject((TierObjectStore.ObjectStoreMetadata)ArgumentMatchers.any(), (TierObjectStore.FileType)ArgumentMatchers.any(), (Integer)ArgumentMatchers.any(), (Integer)ArgumentMatchers.any())).thenReturn((Object)this.response());
        this.metricsEnabledObjectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(segmentFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.OFFSET_INDEX, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(offsetIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.TIMESTAMP_INDEX, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(timestampIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.TRANSACTION_INDEX, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(transactionIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.PRODUCER_STATE, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(producerStateFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.EPOCH_STATE, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(epochStateFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObject((TierObjectStore.ObjectStoreMetadata)this.metadata(), TierObjectStore.FileType.TIER_STATE_SNAPSHOT, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(0));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(tierStateFetchedTotal).metricValue());
    }

    @Test
    public void testLatencyMetrics() {
        MetricName putLatency50Percentile = new MetricName("PutLatency50Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName putLatency90Percentile = new MetricName("PutLatency90Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName putLatency99Percentile = new MetricName("PutLatency99Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName deleteLatency50Percentile = new MetricName("DeleteLatency50Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName deleteLatency90Percentile = new MetricName("DeleteLatency90Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName deleteLatency99Percentile = new MetricName("DeleteLatency99Percentile", "TierObjectStore", "", Collections.emptyMap());
        File file = new File("/tmp/tmp");
        double latencyDeltaMs = 0.1;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            IntRef sleepTimeInMillisecond = IntRef.create((int)0);
            sleepTimeInMillisecond.elem = i <= 89 ? 0 : (i <= 98 ? 5 : 10);
            ((MockInMemoryTierObjectStore)Mockito.doAnswer(x$1 -> {
                TierObjectStoreMetricsEnabledTest.$anonfun$testLatencyMetrics$2(this, sleepTimeInMillisecond, x$1);
                return BoxedUnit.UNIT;
            }).when((Object)this.objectStore())).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
            ((MockInMemoryTierObjectStore)Mockito.doAnswer(x$2 -> {
                TierObjectStoreMetricsEnabledTest.$anonfun$testLatencyMetrics$3(this, sleepTimeInMillisecond, x$2);
                return BoxedUnit.UNIT;
            }).when((Object)this.objectStore())).deleteSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any());
            this.metricsEnabledObjectStore().putSegment(this.metadata(), file, file, file, Optional.empty(), Optional.empty(), Optional.empty());
            this.metricsEnabledObjectStore().deleteSegment(this.metadata());
        });
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(putLatency50Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(putLatency90Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(putLatency99Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(deleteLatency50Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(deleteLatency90Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(deleteLatency99Percentile).metricValue()), (double)latencyDeltaMs);
    }

    public static final /* synthetic */ void $anonfun$testLatencyMetrics$2(TierObjectStoreMetricsEnabledTest $this, IntRef sleepTimeInMillisecond$1, InvocationOnMock x$1) {
        $this.time().sleep(sleepTimeInMillisecond$1.elem);
    }

    public static final /* synthetic */ void $anonfun$testLatencyMetrics$3(TierObjectStoreMetricsEnabledTest $this, IntRef sleepTimeInMillisecond$1, InvocationOnMock x$2) {
        $this.time().sleep(sleepTimeInMillisecond$1.elem);
    }
}

