/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import kafka.utils.MockTime;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class EncryptionKeyManagerTest {
    MockTime time = new MockTime();
    Metrics metrics = new Metrics((Time)this.time);

    EncryptionKeyManagerTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testKeyGenerationOnFirstAccess(boolean useHook) throws GeneralSecurityException {
        KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
        KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        Aead masterKey = (Aead)keySetHandle.getPrimitive(Aead.class);
        MockKeypathHook keypathHook = new MockKeypathHook();
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager((Time)this.time, this.metrics, masterKey, Duration.ofMinutes(30L));
            if (useHook) {
                manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)keypathHook);
            }
            KeySha active = manager.activeKeySha();
            Assertions.assertNotNull((Object)active);
            KeyContext ctx = manager.keyContext(active);
            Assertions.assertFalse((boolean)ctx.cleartextDataKey.base64Encoded().isEmpty());
            if (useHook) {
                KeySha reparsed = manager.registerKeyFromObjectMetadata(keypathHook.current);
                Assertions.assertEquals((Object)reparsed, (Object)active);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreFromWellKnownKeypath() throws GeneralSecurityException {
        KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
        KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        Aead masterKey = (Aead)keySetHandle.getPrimitive(Aead.class);
        MockKeypathHook keypathHook = this.writeOutKey((Time)this.time, masterKey);
        KeySha restoreKeySha = KeySha.fromBase64Encoded((String)keypathHook.current.get("io.confluent/key-sha-256"));
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager((Time)this.time, this.metrics, masterKey, Duration.ofMinutes(30L));
            manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)keypathHook);
            Assertions.assertEquals((Object)restoreKeySha, (Object)manager.activeKeySha());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreExpiredKeyFromWellKnownKeypath() throws GeneralSecurityException {
        Duration expiration = Duration.ofMinutes(30L);
        KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
        KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        Aead masterKey = (Aead)keySetHandle.getPrimitive(Aead.class);
        MockKeypathHook keypathHook = this.writeOutKey((Time)this.time, masterKey);
        this.time.sleep(expiration.toMillis() + 1L);
        KeySha expiredKeySha = KeySha.fromBase64Encoded((String)keypathHook.current.get("io.confluent/key-sha-256"));
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager((Time)this.time, this.metrics, masterKey, expiration);
            manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)keypathHook);
            Assertions.assertNotEquals((Object)expiredKeySha, (Object)manager.activeKeySha());
            Assertions.assertNotNull((Object)manager.keyContext(expiredKeySha));
            KeySha newKeySha = KeySha.fromBase64Encoded((String)keypathHook.current.get("io.confluent/key-sha-256"));
            Assertions.assertEquals((Object)newKeySha, (Object)manager.activeKeySha());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeyRotation() throws GeneralSecurityException {
        Duration expiration = Duration.ofMinutes(30L);
        KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
        KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        Aead masterKey = (Aead)keySetHandle.getPrimitive(Aead.class);
        MockKeypathHook keypathHook = new MockKeypathHook();
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager((Time)this.time, this.metrics, masterKey, expiration);
            manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)keypathHook);
            KeySha firstKey = manager.activeKeySha();
            this.time.sleep(expiration.toMillis() + 1L);
            KeySha secondKey = manager.activeKeySha();
            Assertions.assertNotEquals((Object)firstKey, (Object)secondKey);
            Assertions.assertNotEquals((Object)manager.keyContext((KeySha)firstKey).cleartextDataKey, (Object)manager.keyContext((KeySha)secondKey).cleartextDataKey);
            Assertions.assertNotNull((Object)manager.keyContext(firstKey));
            Assertions.assertNotNull((Object)manager.keyContext(secondKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptKeyThrowingIsRetriableException() throws GeneralSecurityException {
        Duration expiration = Duration.ofMinutes(30L);
        MockKeypathHook keypathHook = new MockKeypathHook();
        KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
        KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        MutableBoolean shouldThrow = new MutableBoolean(false);
        ThrowingAead throwingAead = new ThrowingAead(shouldThrow, (Aead)keySetHandle.getPrimitive(Aead.class));
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager((Time)this.time, this.metrics, (Aead)throwingAead, expiration);
            manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)keypathHook);
            shouldThrow.setValue(true);
            EncryptionKeyManager finalManager = manager;
            Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> ((EncryptionKeyManager)finalManager).activeKeySha());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecryptKeyFromWellKnownPathThrowingIsRetriableException() throws GeneralSecurityException {
        Duration expiration = Duration.ofMinutes(30L);
        KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
        KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        Aead masterKey = (Aead)keySetHandle.getPrimitive(Aead.class);
        MockKeypathHook keypathHook = this.writeOutKey((Time)this.time, masterKey);
        MutableBoolean shouldThrow = new MutableBoolean(false);
        ThrowingAead throwingAead = new ThrowingAead(shouldThrow, masterKey);
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager((Time)this.time, this.metrics, (Aead)throwingAead, expiration);
            manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)keypathHook);
            EncryptionKeyManager finalManager = manager;
            shouldThrow.setValue(true);
            Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> ((EncryptionKeyManager)finalManager).activeKeySha());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecryptKeyFromObjectMetadataThrowingIsRetriableException() throws GeneralSecurityException {
        Duration expiration = Duration.ofMinutes(30L);
        KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
        KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        Aead masterKey = (Aead)keySetHandle.getPrimitive(Aead.class);
        MockKeypathHook keypathHook = this.writeOutKey((Time)this.time, masterKey);
        MutableBoolean shouldThrow = new MutableBoolean(false);
        ThrowingAead throwingAead = new ThrowingAead(shouldThrow, masterKey);
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager((Time)this.time, this.metrics, (Aead)throwingAead, expiration);
            manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)keypathHook);
            EncryptionKeyManager finalManager = manager;
            shouldThrow.setValue(true);
            Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> finalManager.registerKeyFromObjectMetadata(keypathHook.current));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetrics() throws GeneralSecurityException {
        Duration expiration = Duration.ofSeconds(1L);
        MockKeypathHook keypathHook = new MockKeypathHook();
        KeyTemplate keyTemplate = KeyTemplates.get((String)"AES256_GCM_RAW");
        KeysetHandle keySetHandle = KeysetHandle.generateNew((KeyTemplate)keyTemplate);
        DelayingAeads masterKey = new DelayingAeads((Aead)keySetHandle.getPrimitive(Aead.class));
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager((Time)this.time, this.metrics, (Aead)masterKey, expiration);
            manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)keypathHook);
            Assertions.assertEquals((double)0.0, (Double)((Double)this.metrics.metric(manager.metrics.encryptCountMetricName).metricValue()));
            Assertions.assertEquals((double)0.0, (Double)((Double)this.metrics.metric(manager.metrics.decryptCountMetricName).metricValue()));
            Assertions.assertEquals((long)0L, (Long)((Long)this.metrics.metric(manager.metrics.activeKeyAgeMetricName).metricValue()));
            Assertions.assertEquals((long)1000L, (Long)((Long)this.metrics.metric(manager.metrics.maxKeyAgeMetricName).metricValue()));
            manager.activeKeySha();
            this.time.sleep(500L);
            Assertions.assertEquals((long)500L, (Long)((Long)this.metrics.metric(manager.metrics.activeKeyAgeMetricName).metricValue()));
            Assertions.assertEquals((double)1.0, (Double)((Double)this.metrics.metric(manager.metrics.encryptCountMetricName).metricValue()));
            Assertions.assertEquals((double)0.0, (Double)((Double)this.metrics.metric(manager.metrics.decryptCountMetricName).metricValue()));
            this.time.sleep(5000L);
            this.writeOutKey((Time)this.time, keypathHook, masterKey);
            manager.activeKeySha();
            Assertions.assertEquals((double)1.0, (Double)((Double)this.metrics.metric(manager.metrics.encryptCountMetricName).metricValue()));
            Assertions.assertEquals((double)1.0, (Double)((Double)this.metrics.metric(manager.metrics.decryptCountMetricName).metricValue()));
            Assertions.assertEquals((long)100L, (Long)((Long)this.metrics.metric(manager.metrics.activeKeyAgeMetricName).metricValue()));
            Assertions.assertEquals((double)200.0, (Double)((Double)this.metrics.metric(manager.metrics.encrypt50PMetricName).metricValue()));
            Assertions.assertEquals((double)100.0, (Double)((Double)this.metrics.metric(manager.metrics.decrypt50PMetricName).metricValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutKey(Time time, MockKeypathHook writer, Aead masterKey) {
        try (EncryptionKeyManager manager = null;){
            manager = new EncryptionKeyManager(time, null, masterKey, Duration.ofDays(0L));
            manager.bindHook((EncryptionKeyManager.WellKnownKeypathHook)writer);
            KeySha active = manager.activeKeySha();
            Assertions.assertNotNull((Object)active);
        }
    }

    private MockKeypathHook writeOutKey(Time time, Aead masterKey) {
        MockKeypathHook keypathWriter = new MockKeypathHook();
        this.writeOutKey(time, keypathWriter, masterKey);
        return keypathWriter;
    }

    static {
        try {
            AeadConfig.register();
        }
        catch (GeneralSecurityException e) {
            throw new TierObjectStoreFatalException("failed to initialize Tink", (Throwable)e);
        }
    }

    private final class DelayingAeads
    implements Aead {
        private final Aead masterKeyAead;

        DelayingAeads(Aead masterKeyAead) {
            this.masterKeyAead = masterKeyAead;
        }

        public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            EncryptionKeyManagerTest.this.time.sleep(100L);
            return this.masterKeyAead.encrypt(plaintext, associatedData);
        }

        public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            EncryptionKeyManagerTest.this.time.sleep(100L);
            return this.masterKeyAead.decrypt(ciphertext, associatedData);
        }
    }

    private static final class MutableBoolean {
        private boolean value;

        MutableBoolean(boolean value) {
            this.value = value;
        }

        void setValue(boolean value) {
            this.value = value;
        }

        boolean getValue() {
            return this.value;
        }
    }

    private static class ThrowingAead
    implements Aead {
        private final MutableBoolean shouldThrow;
        private final Aead masterKeyAead;

        ThrowingAead(MutableBoolean shouldThrow, Aead masterKeyAead) {
            this.shouldThrow = shouldThrow;
            this.masterKeyAead = masterKeyAead;
        }

        public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            if (this.shouldThrow.getValue()) {
                throw new GeneralSecurityException("throw!");
            }
            return this.masterKeyAead.encrypt(plaintext, associatedData);
        }

        public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            if (this.shouldThrow.getValue()) {
                throw new GeneralSecurityException("throw!");
            }
            return this.masterKeyAead.decrypt(ciphertext, associatedData);
        }
    }

    static class MockKeypathHook
    implements EncryptionKeyManager.WellKnownKeypathHook {
        Map<String, String> current = new HashMap<String, String>();

        MockKeypathHook() {
        }

        public void writeWellKnownPathMetadata(Map<String, String> metadata) {
            this.current = metadata;
        }

        public Map<String, String> fetchWellKnownPathMetadata() {
            return this.current;
        }
    }
}

