/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kafka.tier.TopicIdPartition;
import kafka.tier.tasks.QueueEntry;
import kafka.tier.tasks.UpdatableQueue;
import kafka.tier.tasks.UpdatableQueueEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005Y2AAB\u0004\u0001\u001d!)Q\u0003\u0001C\u0001-!9\u0011\u0004\u0001b\u0001\n\u0013Q\u0002BB\u0011\u0001A\u0003%1\u0004C\u0003#\u0001\u0011\u00051\u0005C\u00035\u0001\u0011\u00051E\u0001\nVa\u0012\fG/\u00192mKF+X-^3UKN$(B\u0001\u0005\n\u0003\u0015!\u0018m]6t\u0015\tQ1\"\u0001\u0003uS\u0016\u0014(\"\u0001\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u00059\u0011!B9vKV,W#A\u000e\u0011\u0007aab$\u0003\u0002\u001e\u000f\tqQ\u000b\u001d3bi\u0006\u0014G.Z)vKV,\u0007C\u0001\r \u0013\t\u0001sA\u0001\u0006Rk\u0016,X-\u00128uef\fa!];fk\u0016\u0004\u0013\u0001\u0006;fgR\u0004Vo\u001d5V]\ndwnY6t)\u0006\\W\rF\u0001%!\t\u0001R%\u0003\u0002'#\t!QK\\5uQ\t!\u0001\u0006\u0005\u0002*e5\t!F\u0003\u0002,Y\u0005\u0019\u0011\r]5\u000b\u00055r\u0013a\u00026va&$XM\u001d\u0006\u0003_A\nQA[;oSRT\u0011!M\u0001\u0004_J<\u0017BA\u001a+\u0005\u0011!Vm\u001d;\u0002+Q,7\u000f^\"m_N,WK\u001c2m_\u000e\\7\u000fV1lK\"\u0012Q\u0001\u000b")
public class UpdatableQueueTest {
    private final UpdatableQueue<QueueEntry> queue = new UpdatableQueue();

    private UpdatableQueue<QueueEntry> queue() {
        return this.queue;
    }

    @Test
    public void testPushUnblocksTake() {
        TopicIdPartition topicPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        Future future = Future$.MODULE$.apply((Function0 & Serializable)() -> (QueueEntry)this.queue().take(), ExecutionContext.Implicits$.MODULE$.global());
        this.queue().push((UpdatableQueueEntry)new QueueEntry(topicPartition));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!future.isCompleted()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for future to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertEquals((Object)topicPartition, (Object)((QueueEntry)((Try)future.value().get()).get()).topicIdPartition());
    }

    @Test
    public void testCloseUnblocksTake() {
        Future future = Future$.MODULE$.apply((Function0 & Serializable)() -> (QueueEntry)this.queue().take(), ExecutionContext.Implicits$.MODULE$.global());
        this.queue().close();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!future.isCompleted()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for future to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (QueueEntry)((Try)future.value().get()).get(), ClassTag$.MODULE$.apply(CancellationException.class), new Position("UpdatableQueueTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
    }

    public static final /* synthetic */ boolean $anonfun$testPushUnblocksTake$2(Future future$1) {
        return future$1.isCompleted();
    }

    public static final /* synthetic */ String $anonfun$testPushUnblocksTake$3() {
        return "Timed out waiting for future to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testCloseUnblocksTake$2(Future future$2) {
        return future$2.isCompleted();
    }

    public static final /* synthetic */ String $anonfun$testCloseUnblocksTake$3() {
        return "Timed out waiting for future to complete";
    }
}

