/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.OffsetIndex;
import kafka.log.ProducerStateManager;
import kafka.log.TimeIndex;
import kafka.log.TransactionIndex;
import kafka.log.UploadableSegment;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ReplicaManager;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.Logging;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\u001df\u0001B\u001d;\u0001\rCQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004[\u0001\u0001\u0006IA\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0001]\u0011\u0019)\u0007\u0001)A\u0005;\"9a\r\u0001a\u0001\n\u00039\u0007b\u00028\u0001\u0001\u0004%\ta\u001c\u0005\u0007k\u0002\u0001\u000b\u0015\u00025\t\u000fY\u0004\u0001\u0019!C\u0001o\"9a\u0010\u0001a\u0001\n\u0003y\bbBA\u0002\u0001\u0001\u0006K\u0001\u001f\u0005\n\u0003\u000b\u0001\u0001\u0019!C\u0001\u0003\u000fA\u0011\"!\u0006\u0001\u0001\u0004%\t!a\u0006\t\u0011\u0005m\u0001\u0001)Q\u0005\u0003\u0013A\u0011\"!\b\u0001\u0001\u0004%\t!a\b\t\u0013\u00055\u0002\u00011A\u0005\u0002\u0005=\u0002\u0002CA\u001a\u0001\u0001\u0006K!!\t\t\u0013\u0005U\u0002\u00011A\u0005\u0002\u0005]\u0002\"CA#\u0001\u0001\u0007I\u0011AA$\u0011!\tY\u0005\u0001Q!\n\u0005e\u0002\"CA'\u0001\u0001\u0007I\u0011AA(\u0011%\tY\u0007\u0001a\u0001\n\u0003\ti\u0007\u0003\u0005\u0002r\u0001\u0001\u000b\u0015BA)\u0011%\t\u0019\b\u0001a\u0001\n\u0003\t)\bC\u0005\u0002\b\u0002\u0001\r\u0011\"\u0001\u0002\n\"A\u0011Q\u0012\u0001!B\u0013\t9\bC\u0005\u0002\u0010\u0002\u0011\r\u0011\"\u0001\u0002\u0012\"A\u00111\u0014\u0001!\u0002\u0013\t\u0019\nC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005]\u0006\u0001\"\u0001\u0002 \"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005}\u0005bBAf\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003\u001f\u0004A\u0011AAP\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003?Cq!a6\u0001\t\u0003\ty\nC\u0004\u0002\\\u0002!\t!a(\t\u000f\u0005}\u0007\u0001\"\u0001\u0002 \"9\u00111\u001d\u0001\u0005\u0002\u0005}\u0005bBAt\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003W\u0004A\u0011AAP\u0011\u001d\ty\u000f\u0001C\u0001\u0003?Cq!a=\u0001\t\u0003\ty\nC\u0004\u0002x\u0002!\t!a(\t\u000f\u0005m\b\u0001\"\u0001\u0002 \"9\u0011q \u0001\u0005\u0002\u0005}\u0005b\u0002B\u0002\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0005\u000f\u0001A\u0011AAP\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003?CqAa\u0004\u0001\t\u0003\ty\nC\u0004\u0003\u0014\u0001!IA!\u0006\t\u000f\t=\u0002\u0001\"\u0003\u00032!9!q\n\u0001\u0005\n\tE\u0003b\u0002B-\u0001\u0011%!1\f\u0005\b\u0005W\u0002A\u0011\u0002B7\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000fCqAa%\u0001\t\u0013\u0011)JA\bBe\u000eD\u0017N^3UCN\\G+Z:u\u0015\tYD(A\u0004be\u000eD\u0017N^3\u000b\u0005ur\u0014!\u0002;bg.\u001c(BA A\u0003\u0011!\u0018.\u001a:\u000b\u0003\u0005\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\t*\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013a!\u00118z%\u00164\u0007CA&O\u001b\u0005a%BA'A\u0003\u001diW\r\u001e:jGNL!a\u0014'\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0004=S:LGO\u0010\u000b\u0002%B\u00111\u000bA\u0007\u0002u\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0002-B\u0011q\u000bW\u0007\u0002}%\u0011\u0011L\u0010\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8!\u0003A!WMZ1vYR\fu/Y5u)&lW-F\u0001^!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0005ekJ\fG/[8o\u0015\t\u0011g)\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001Z0\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\tB-\u001a4bk2$\u0018i^1jiRKW.\u001a\u0011\u0002\u0007\r$\b0F\u0001i!\tIG.D\u0001k\u0015\tYg(A\u0004gKR\u001c\u0007.\u001a:\n\u00055T'aE\"b]\u000e,G\u000e\\1uS>t7i\u001c8uKb$\u0018aB2uq~#S-\u001d\u000b\u0003aN\u0004\"!R9\n\u0005I4%\u0001B+oSRDq\u0001^\u0004\u0002\u0002\u0003\u0007\u0001.A\u0002yIE\nAa\u0019;yA\u0005\u0001B/[3s)>\u0004\u0018nY'b]\u0006<WM]\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u00111PP\u0001\u0006i>\u0004\u0018nY\u0005\u0003{j\u0014\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002)QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014x\fJ3r)\r\u0001\u0018\u0011\u0001\u0005\bi*\t\t\u00111\u0001y\u0003E!\u0018.\u001a:U_BL7-T1oC\u001e,'\u000fI\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002 \u0002\u000bM$xN]3\n\t\u0005M\u0011Q\u0002\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006\u0019B/[3s\u001f\nTWm\u0019;Ti>\u0014Xm\u0018\u0013fcR\u0019\u0001/!\u0007\t\u0011Ql\u0011\u0011!a\u0001\u0003\u0013\t\u0001\u0003^5fe>\u0013'.Z2u'R|'/\u001a\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005!\u0002\rM,'O^3s\u0013\u0011\tY#!\n\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011\"/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x\fJ3r)\r\u0001\u0018\u0011\u0007\u0005\tiB\t\t\u00111\u0001\u0002\"\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b!\u0002\u000f\rdWo\u001d;fe&!\u00111IA\u001f\u0005%\u0001\u0016M\u001d;ji&|g.A\u0007qCJ$\u0018\u000e^5p]~#S-\u001d\u000b\u0004a\u0006%\u0003\u0002\u0003;\u0014\u0003\u0003\u0005\r!!\u000f\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\u0003uS6,WCAA)!\u0011\t\u0019&a\u001a\u000e\u0005\u0005U#\u0002BA,\u00033\nQ!\u001e;jYNTA!a\u0017\u0002^\u000511m\\7n_:T1!QA0\u0015\u0011\t\t'a\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)'A\u0002pe\u001eLA!!\u001b\u0002V\t!A+[7f\u0003!!\u0018.\\3`I\u0015\fHc\u00019\u0002p!AAOFA\u0001\u0002\u0004\t\t&A\u0003uS6,\u0007%A\u0004u[B4\u0015\u000e\\3\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0003S>T!!!!\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\u000bYH\u0001\u0003GS2,\u0017a\u0003;na\u001aKG.Z0%KF$2\u0001]AF\u0011!!\u0018$!AA\u0002\u0005]\u0014\u0001\u0003;na\u001aKG.\u001a\u0011\u0002\u001fQLWM\u001d+bg.\u001c8i\u001c8gS\u001e,\"!a%\u0011\t\u0005U\u0015qS\u0007\u0002y%\u0019\u0011\u0011\u0014\u001f\u0003\u001fQKWM\u001d+bg.\u001c8i\u001c8gS\u001e\f\u0001\u0003^5feR\u000b7o[:D_:4\u0017n\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0003AD3!HAR!\u0011\t)+a-\u000e\u0005\u0005\u001d&\u0002BAU\u0003W\u000b1!\u00199j\u0015\u0011\ti+a,\u0002\u000f),\b/\u001b;fe*!\u0011\u0011WA2\u0003\u0015QWO\\5u\u0013\u0011\t),a*\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rq\u00121\u0018\t\u0005\u0003K\u000bi,\u0003\u0003\u0002@\u0006\u001d&!C!gi\u0016\u0014X)Y2i\u0003i!Xm\u001d;FgR\f'\r\\5tQ&tw\rT3bI\u0016\u00148\u000f[5qQ\ry\u0012Q\u0019\t\u0005\u0003K\u000b9-\u0003\u0003\u0002J\u0006\u001d&\u0001\u0002+fgR\f1\u0004^3tiRKWM]*fO6,g\u000e^%om\u0006d\u0017\u000eZ#q_\u000eD\u0007f\u0001\u0011\u0002F\u0006aB/Z:u\u001b\u0016$\u0018\rZ1uCNK'0\u001a#ve&tw-\u00169m_\u0006$\u0007fA\u0011\u0002F\u0006\u0019B/Z:u%\u0016$(/\u001f)viN+w-\\3oi\"\u001a!%!2\u00027Q,7\u000f^'fi\u0006$\u0017\r^1TSj,\u0017I\u001a;feV\u0003Hn\\1eQ\r\u0019\u0013QY\u0001\"i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8EkJLgnZ%oSRL\u0017\r^3Va2|\u0017\r\u001a\u0015\u0004I\u0005\u0015\u0017a\u000e;fgR,\u0005pY3qi&|g\u000eR;sS:<\u0017J\\5uS\u0006$X-\u00169m_\u0006$w\u000b[3o!\u0006\u0014H/\u001b;j_:L5/\u00168dY\u0016\fg\u000eK\u0002&\u0003\u000b\fA\u0007^3ti\u0016C8-\u001a9uS>tG)\u001e:j]\u001eLe.\u001b;jCR,W\u000b\u001d7pC\u0012<\u0006.\u001a8US\u0016\u0014\u0018N\\4ESN\f'\r\\3eQ\r1\u0013QY\u0001\u001fi\u0016\u001cHoU3h[\u0016tG\u000fR3mKR,G\rR;sS:<W\u000b\u001d7pC\u0012D3aJAc\u0003\u0011\"Xm\u001d;Be\u000eD\u0017N^3UCN\\7)\u00198dK2dW\r\u001a\"fM>\u0014X-\u00169m_\u0006$\u0007f\u0001\u0015\u0002F\u0006\u0001C/Z:u+:\\gn\\<o\u000bb\u001cW\r\u001d;j_:$UO]5oOV\u0003Hn\\1eQ\rI\u0013QY\u0001\u001ai\u0016\u001cH\u000fV5feN+w-\\3oi:{7+Z4nK:$8\u000fK\u0002+\u0003\u000b\fa\u0005^3tiRKWM]*fO6,g\u000e^,ji\"|W\u000f\u001e'fC\u0012,'/\u00129pG\"\u001cF/\u0019;fQ\rY\u0013QY\u0001$i\u0016\u001cH\u000fV5feN+w-\\3oi^KG\u000f\u001b'fC\u0012,'/\u00129pG\"\u001cF/\u0019;fQ\ra\u0013QY\u0001!i\u0016\u001cH/\u0011:dQ&4XM\u001d+bg.\u001cV\r^:QCV\u001cXm\u00148SKR\u0014\u0018\u0010K\u0002.\u0003\u000b\fq\u0005^3ti\u000e\u000bgnY3mY\u0016$\u0017I]2iSZ,G+Y:l\t>,7OT8u!J|wM]3tg\"\u001aa&!2\u0002CQ,7\u000f\u001e%b]\u0012dWmU3h[\u0016tG\u000fR3mKR,G-\u0012=dKB$\u0018n\u001c8)\u0007=\n)-\u0001\u001cuKN$\b*\u00198eY&twMR8s'\u0016<W.\u001a8u\t\u0016dW\r^3e\u000bb\u001cW\r\u001d;j_:$UO]5oOR\u0013\u0018M\\:ji&|g\u000eK\u00021\u0003\u000b\f\u0001\u0006^3tiJ+GO]5bE2,W\t_2faRLwN\u001c$fi\u000eD\u0017N\\4Pa\u0006\fX/\u001a#bi\u0006D3!MAc\u0003\r\"Xm\u001d;J]&$\u0018.\u0019;f+Bdw.\u00193XSRDWK\\2mK\u0006tG*Z1eKJ$BAa\u0006\u0003&A1!\u0011\u0004B\u000e\u0005?i\u0011!Y\u0005\u0004\u0005;\t'A\u0002$viV\u0014X\rE\u0002T\u0005CI1Aa\t;\u0005A\t%o\u00195jm\u0016$\u0016m]6Ti\u0006$X\rC\u0004\u0003(I\u0002\rA!\u000b\u0002\u001bUt7\r\\3b]2+\u0017\rZ3s!\r)%1F\u0005\u0004\u0005[1%a\u0002\"p_2,\u0017M\\\u0001*i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8IC:$G.\u001b8h\tV\u0014\u0018N\\4J]&$\u0018.\u0019;f+Bdw.\u00193\u0015\t\t]!1\u0007\u0005\b\u0005k\u0019\u0004\u0019\u0001B\u001c\u0003\u0005)\u0007\u0003\u0002B\u001d\u0005\u0013rAAa\u000f\u0003F9!!Q\bB\"\u001b\t\u0011yDC\u0002\u0003B\t\u000ba\u0001\u0010:p_Rt\u0014\"A$\n\u0007\t\u001dc)A\u0004qC\u000e\\\u0017mZ3\n\t\t-#Q\n\u0002\n\u000bb\u001cW\r\u001d;j_:T1Aa\u0012G\u0003\u0005\"Xm\u001d;Fq\u000e,\u0007\u000f^5p]\"\u000bg\u000e\u001a7j]\u001e$UO]5oOV\u0003Hn\\1e)\u0019\u00119Ba\u0015\u0003V!9!Q\u0007\u001bA\u0002\t]\u0002b\u0002B,i\u0001\u0007!\u0011F\u0001\u000eI\u0016dW\r^3TK\u001elWM\u001c;\u0002\u001d5|7m\u001b'pON+w-\\3oiR!!Q\fB5!\u0011\u0011yF!\u001a\u000e\u0005\t\u0005$b\u0001B2\u0001\u0006\u0019An\\4\n\t\t\u001d$\u0011\r\u0002\u000b\u0019><7+Z4nK:$\bbBA:k\u0001\u0007\u0011qO\u0001\u0017[>\u001c7\u000eV5feB\u000b'\u000f^5uS>t7\u000b^1uKR!!q\u000eB>!\u0011\u0011\tHa\u001e\u000e\u0005\tM$b\u0001B;}\u0005)1\u000f^1uK&!!\u0011\u0010B:\u0005I!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000f\tud\u00071\u0001\u0003\u0000\u0005YA.Z1eKJ,\u0005o\\2i!\r)%\u0011Q\u0005\u0004\u0005\u00073%aA%oi\u0006yQn\\2l\u0003\n\u001cHO]1di2{w\r\u0006\u0003\u0003\n\n=\u0005\u0003\u0002B0\u0005\u0017KAA!$\u0003b\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\u0011\tj\u000ea\u0001\u0005;\n!\u0002\\8h'\u0016<W.\u001a8u\u0003-!\u0018.\u001a:TK\u001elWM\u001c;\u0015\r\t]%1\u0015BS!\u0011\u0011IJa(\u000e\u0005\tm%b\u0001BO}\u00051Am\\7bS:LAA!)\u0003\u001c\n\u0011B+[3s\u001f\nTWm\u0019;NKR\fG-\u0019;b\u0011\u001d\u0011\u0019\u0007\u000fa\u0001\u0005\u0013CqA! 9\u0001\u0004\u0011y\b")
public class ArchiveTaskTest
implements KafkaMetricsGroup {
    private final TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("cbf4eaed-cc00-47dc-b08c-f1f5685f085d"), 0);
    private final FiniteDuration defaultAwaitTime = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
    private CancellationContext ctx = CancellationContext.newContext();
    private TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private Partition partition = (Partition)Mockito.mock(Partition.class);
    private Time time = new MockTime();
    private File tmpFile = TestUtils.tempFile();
    private final TierTasksConfig tierTasksConfig = new TierTasksConfig(1, 1, 1, 600000L, 500L, 50, 300000, false, (Option)None$.MODULE$);
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
    }

    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (MetricName)metricName, metric);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
    }

    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (MetricName)metricName, (String)eventType, (TimeUnit)timeUnit);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
    }

    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (MetricName)metricName);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public FiniteDuration defaultAwaitTime() {
        return this.defaultAwaitTime;
    }

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(TierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    public void tmpFile_$eq(File x$1) {
        this.tmpFile = x$1;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    @BeforeEach
    public void setup() {
        this.tmpFile_$eq(TestUtils.tempFile());
    }

    @AfterEach
    public void tearDown() {
        this.tmpFile().delete();
        this.ctx().cancel();
        Mockito.reset((Object[])new Object[]{this.tierTopicManager(), this.tierObjectStore(), this.replicaManager()});
    }

    @Test
    public void testEstablishingLeadership() {
        int leaderEpoch = 0;
        ArgumentCaptor metadataCaptor = ArgumentCaptor.forClass(TierTopicInitLeader.class);
        org.apache.kafka.raft.OffsetAndEpoch topicCreationOffsetAndEpoch = new org.apache.kafka.raft.OffsetAndEpoch(100L, 1);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        BeforeUpload nextState = (BeforeUpload)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)new BeforeUpload(leaderEpoch), (Object)nextState, (String)"Expected task to establish leadership");
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager())).addMetadata((AbstractTierMetadata)metadataCaptor.capture());
        Assertions.assertEquals(Optional.empty(), (Object)((TierTopicInitLeader)metadataCaptor.getValue()).partitionCreationOffsetAndEpoch());
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)new Some((Object)topicCreationOffsetAndEpoch));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        BeforeUpload validOffsetResult = (BeforeUpload)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)new BeforeUpload(leaderEpoch), (Object)validOffsetResult, (String)"Expected task to establish leadership");
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.atLeast((int)1))).addMetadata((AbstractTierMetadata)metadataCaptor.capture());
        Assertions.assertEquals(Optional.of(topicCreationOffsetAndEpoch), (Object)((TierTopicInitLeader)metadataCaptor.getValue()).partitionCreationOffsetAndEpoch());
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.NOT_TIERABLE));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed(new Object()));
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
    }

    @Test
    public void testTierSegmentInvalidEpoch() {
        int leaderEpoch = 0;
        TierPartitionState tps = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch + 1))).getMock();
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tps);
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)nextState, (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected segment tiering to fail due to fencing");
    }

    @Test
    public void testMetadataSizeDuringUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        int epochStateSize = 100;
        long producerStateSize = 2000000000L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)(logSegment.size() + epochStateSize) + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        ByteBuffer epochState = ByteBuffer.wrap(new byte[epochStateSize]);
        File producerState = (File)Mockito.mock(File.class);
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)producerState.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)producerState.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)producerStateSize));
        ((TierObjectStore)Mockito.doNothing().when((Object)this.tierObjectStore())).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value");
        Assertions.assertTrue((afterUpload.uploadedSize() > 0L ? 1 : 0) != 0, (String)"metadata size of AfterUpload object is negative and overflowed");
    }

    @Test
    public void testRetryPutSegment() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.ZEROED);
        MockInMemoryTierObjectStore inMemoryTierObjectStore = new MockInMemoryTierObjectStore(this.time(), new MockInMemoryTierObjectStoreConfig());
        int epochStateSize = 100;
        long producerStateSize = 0L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)(logSegment.size() + epochStateSize) + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        ByteBuffer epochState = ByteBuffer.wrap(new byte[epochStateSize]);
        File producerState = this.tmpFile();
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), (TierObjectStore)inMemoryTierObjectStore, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value");
        Assertions.assertTrue((afterUpload.uploadedSize() > 0L ? 1 : 0) != 0, (String)"metadata size of AfterUpload object is negative and overflowed");
        Assertions.assertEquals((int)abortedTxnsPos, (int)abortedTxns.position());
        Assertions.assertEquals((int)0, (int)epochState.position());
        UploadableSegment uploadableSegment2 = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload2 = new Upload(leaderEpoch, uploadInitiate, uploadableSegment2);
        Future uploadResult2 = ArchiveTask$.MODULE$.upload(upload2, this.topicIdPartition(), this.time(), this.ctx(), (TierObjectStore)inMemoryTierObjectStore, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload2 = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult2, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload2.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value after second retried upload");
    }

    @Test
    public void testMetadataSizeAfterUpload() {
        int testUploadSize = 400;
        String metricName = "BytesPerSec";
        this.removeMetric(metricName, this.removeMetric$default$2());
        Meter byteRate = this.newMeter(metricName, "bytes per second", TimeUnit.SECONDS, this.newMeter$default$4());
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        AfterUpload afterUpload = new AfterUpload(0, uploadInitiate, (long)testUploadSize);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)new Some((Object)byteRate), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)testUploadSize, (long)byteRate.count(), (String)"tier archiver mean rate shows no data uploaded to tiered storage");
    }

    @Test
    public void testExceptionDuringInitiateUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringInitiateUpload(new IllegalStateException("illegal state"));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
    }

    @Test
    public void testExceptionDuringInitiateUploadWhenPartitionIsUnclean() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result(this.testInitiateUploadWithUncleanLeader(true), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(66).append("Unexpected transition to next state ").append(state.toString()).append(" when partition needs recovery").toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierMetadataRetriableException.class, ex.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex.getMessage().contains("is undergoing unclean leader recovery"), (String)"Unexpected cause for exception");
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result(this.testInitiateUploadWithUncleanLeader(false), (Duration)this.defaultAwaitTime()));
        if (try_2 instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_2).value();
            Assertions.assertEquals(Upload.class, state.getClass(), (String)"Unexpected next state");
            return;
        }
        if (try_2 instanceof Failure) {
            Throwable ex2 = ((Failure)try_2).exception();
            throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex2).toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        }
        throw new MatchError((Object)try_2);
    }

    @Test
    public void testExceptionDuringInitiateUploadWhenTieringDisabled() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment})));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future maybeInitUploadState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)maybeInitUploadState, (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(72).append("Unexpected transition to next state ").append(state.toString()).append(" when partition has tiering disabled").toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            Assertions.assertEquals(NotTierablePartitionException.class, ex.getClass(), (String)"Unexpected exception");
            return;
        }
        throw new MatchError((Object)try_);
    }

    @Test
    public void testSegmentDeletedDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new NoSuchFileException("segment deleted"), true);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
    }

    @Test
    public void testArchiveTaskCancelledBeforeUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), false, false, false, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.ctx().cancel();
        Future nextState = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (AfterUpload)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(TierArchiverFencedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
    }

    @Test
    public void testUnknownExceptionDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new IllegalStateException("illegal state"), false);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
    }

    @Test
    public void testTierSegmentNoSegments() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AbstractLog emptyLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)emptyLog.tierableLogSegments()).thenReturn((Object)CollectionConverters$.MODULE$.ListHasAsScala(Collections.emptyList()).asScala()).getMock();
        Partition partition = (Partition)Mockito.when((Object)((Partition)Mockito.mock(Partition.class)).log()).thenReturn((Object)new Some((Object)emptyLog)).getMock();
        Mockito.when((Object)emptyLog.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)emptyLog));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()) instanceof BeforeUpload), (String)"Expected segment tiering to complete successfully, but not progress to AfterUpload");
    }

    @Test
    public void testTierSegmentWithoutLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = this.mockTierPartitionState(leaderEpoch);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)None$.MODULE$);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        TierObjectMetadata metadata = this.tierSegment(log, leaderEpoch);
        Assertions.assertEquals((long)metadata.baseOffset(), (long)0L, (String)"expected start offset to be 0");
        Assertions.assertEquals((long)metadata.endOffset(), (long)9L, (String)"expected end offset to be 9");
    }

    @Test
    public void testTierSegmentWithLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = this.mockTierPartitionState(leaderEpoch);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        byte[] epochArray = new byte[100];
        LeaderEpochFileCache mockLeaderEpochCache = (LeaderEpochFileCache)Mockito.mock(LeaderEpochFileCache.class);
        Mockito.when((Object)mockLeaderEpochCache.snapshotForSegment(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)epochArray);
        long nextOffset = logSegment.readNextOffset();
        ((LeaderEpochFileCache)Mockito.doNothing().when((Object)mockLeaderEpochCache)).truncateFromEnd(nextOffset);
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)new Some((Object)mockLeaderEpochCache));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)new Some((Object)ByteBuffer.wrap(epochArray)), (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Assertions.assertTrue((boolean)this.tierSegment(log, leaderEpoch).hasEpochState(), (String)"expected metadata to claim to have epoch state");
        ((TierObjectStore)Mockito.verify((Object)this.tierObjectStore(), (VerificationMode)Mockito.times((int)1))).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull());
    }

    @Test
    public void testArchiverTaskSetsPauseOnRetry() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TierMetadataRetriableException("something"), new TierObjectStoreRetriableException("foo", (Throwable)new RuntimeException("foo"))});
        Mockito.when((Object)this.partition().metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result.pausedUntil().isDefined(), (String)"expected the task to be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"expected the task to not be canceled");
        Instant pauseTime = (Instant)result.pausedUntil().get();
        this.time().sleep(100L);
        ArchiveTask result2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result2.pausedUntil().isDefined(), (String)"expected the task to be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"expected the task to not be canceled");
        Assertions.assertTrue((boolean)((Instant)result2.pausedUntil().get()).isAfter(pauseTime), (String)"expected the second pause time to be larger than the first");
    }

    @Test
    public void testCancelledArchiveTaskDoesNotProgress() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        this.ctx().cancel();
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).state() instanceof BeforeLeader), (String)"expected task to remain in BeforeLeader");
    }

    @Test
    public void testHandleSegmentDeletedException() {
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        BeforeLeader beforeLeader = new BeforeLeader(0);
        BeforeUpload beforeUpload = new BeforeUpload(0);
        Upload upload = new Upload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), (UploadableSegment)Mockito.mock(UploadableSegment.class));
        AfterUpload afterUpload = new AfterUpload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), 0L);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> beforeLeader.handleSegmentDeletedException(exception), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
        Assertions.assertEquals(BeforeUpload.class, (Object)beforeUpload.handleSegmentDeletedException(exception).getClass());
        Assertions.assertEquals(BeforeUpload.class, (Object)upload.handleSegmentDeletedException(exception).getClass());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> afterUpload.handleSegmentDeletedException(exception), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
    }

    @Test
    public void testHandlingForSegmentDeletedExceptionDuringTransition() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenThrow(new Throwable[]{exception});
        BeforeUpload beforeUpload = new BeforeUpload(42);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)result.state(), (Object)beforeUpload);
        Assertions.assertEquals((int)result.retryCount(), (int)1);
    }

    @Test
    public void testRetriableExceptionFetchingOpaqueData() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierPartitionState tierPartitionState = this.mockTierPartitionState(42);
        TierObjectStore throwingTierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)throwingTierObjectStore.prepPutSegment()).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("key fetch error")});
        BeforeUpload beforeUpload = new BeforeUpload(42);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), throwingTierObjectStore, this.replicaManager(), this.tierTasksConfig(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assertions.assertEquals((Object)result.state(), (Object)beforeUpload);
        Assertions.assertEquals((int)result.retryCount(), (int)1);
    }

    private Future<ArchiveTaskState> testInitiateUploadWithUncleanLeader(boolean uncleanLeader) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeader));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment})));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringInitiateUpload(Exception e) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment})));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenThrow(new Throwable[]{e});
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringUpload(Exception e, boolean deleteSegment) {
        int leaderEpoch = 0;
        File fileToUse = this.tmpFile();
        if (deleteSegment) {
            fileToUse = (File)Mockito.mock(File.class);
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fileToUse.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        LogSegment logSegment = this.mockLogSegment(fileToUse);
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.getFirstBatchTimestamp(), logSegment.size(), false, false, false, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.tierObjectStore().putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private LogSegment mockLogSegment(File tmpFile) {
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.mock(OffsetIndex.class);
        Mockito.when((Object)offsetIndex.file()).thenReturn((Object)tmpFile);
        TimeIndex timeIndex = (TimeIndex)Mockito.mock(TimeIndex.class);
        Mockito.when((Object)timeIndex.file()).thenReturn((Object)tmpFile);
        TransactionIndex txnIndex = (TransactionIndex)Mockito.mock(TransactionIndex.class);
        Mockito.when((Object)txnIndex.file()).thenReturn((Object)tmpFile);
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        Mockito.when((Object)fileRecords.file()).thenReturn((Object)tmpFile);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.readNextOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)10L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.baseOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.largestTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1000));
        Mockito.when((Object)logSegment.log()).thenReturn((Object)fileRecords);
        Mockito.when((Object)logSegment.offsetIndex()).thenReturn((Object)offsetIndex);
        Mockito.when((Object)logSegment.timeIndex()).thenReturn((Object)timeIndex);
        Mockito.when((Object)logSegment.txnIndex()).thenReturn((Object)txnIndex);
        return logSegment;
    }

    private TierPartitionState mockTierPartitionState(int leaderEpoch) {
        return (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog mockAbstractLog(LogSegment logSegment) {
        void var2_2;
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment})));
        return var2_2;
    }

    private TierObjectMetadata tierSegment(AbstractLog log, int leaderEpoch) {
        Future beforeUploadResult = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Upload upload = (Upload)Await$.MODULE$.result((Awaitable)beforeUploadResult, (Duration)this.defaultAwaitTime());
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)this.defaultAwaitTime());
        TierSegmentUploadInitiate uploadInitiate = upload.uploadInitiate();
        return new TierObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), uploadInitiate.messageId(), uploadInitiate.baseOffset(), uploadInitiate.endOffset(), uploadInitiate.maxTimestamp(), uploadInitiate.firstBatchTimestamp(), uploadInitiate.size(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, uploadInitiate.hasEpochState(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, true, true, -1L);
    }
}

