/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogConfig;
import kafka.log.TierLogSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.CompactStats;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.tasks.CompactionTasksConfig;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.CompactionTask$;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.utils.MockTime;
import kafka.utils.Throttler;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\r\u001a\u0001\tBQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001A\u0002\u0013\u0005a\u0006C\u0004=\u0001\u0001\u0007I\u0011A\u001f\t\r\r\u0003\u0001\u0015)\u00030\u0011\u001d!\u0005A1A\u0005\u0002\u0015Caa\u0013\u0001!\u0002\u00131\u0005b\u0002'\u0001\u0005\u0004%\t!\u0014\u0005\u0007%\u0002\u0001\u000b\u0011\u0002(\t\u000fM\u0003!\u0019!C\u0001)\"1\u0001\f\u0001Q\u0001\nUCQ!\u0017\u0001\u0005\u0002iCq! \u0001\u0012\u0002\u0013\u0005a\u0010\u0003\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u007f\u0011%\t)\u0002AI\u0001\n\u0003\t9\u0002C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAJ\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003/\u0003A\u0011AA>\u0011\u001d\tY\n\u0001C\u0001\u0003wBq!a(\u0001\t\u0003\tY\bC\u0004\u0002$\u0002!\t!a\u001f\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002|\tIB+[3s\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014H+Z:u\u0015\tQ2$\u0001\u0006d_6\u0004\u0018m\u0019;j_:T!\u0001H\u000f\u0002\u000bQ\f7o[:\u000b\u0005yy\u0012\u0001\u0002;jKJT\u0011\u0001I\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0002\"\u0001\f\u0001\u000e\u0003e\t\u0001\"\\8dWRKW.Z\u000b\u0002_A\u0011\u0001GO\u0007\u0002c)\u0011!gM\u0001\u0006kRLGn\u001d\u0006\u0003iU\naaY8n[>t'B\u0001\u00117\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\n\u0005m\n$\u0001\u0002+j[\u0016\fA\"\\8dWRKW.Z0%KF$\"AP!\u0011\u0005\u0011z\u0014B\u0001!&\u0005\u0011)f.\u001b;\t\u000f\t\u001b\u0011\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\u0002\u00135|7m\u001b+j[\u0016\u0004\u0013!\u0003;ie>$H\u000f\\3s+\u00051\u0005CA$J\u001b\u0005A%B\u0001\u001a \u0013\tQ\u0005JA\u0005UQJ|G\u000f\u001e7fe\u0006QA\u000f\u001b:piRdWM\u001d\u0011\u00021QLWM]\"p[B\f7\r^5p]R\u000b7o[\"p]\u001aLw-F\u0001O!\ty\u0005+D\u0001\u001c\u0013\t\t6DA\u000bD_6\u0004\u0018m\u0019;j_:$\u0016m]6t\u0007>tg-[4\u00023QLWM]\"p[B\f7\r^5p]R\u000b7o[\"p]\u001aLw\rI\u0001\u0016i&,'oQ8na\u0006\u001cG/[8o\u001b\u0016$(/[2t+\u0005)\u0006C\u0001\u0017W\u0013\t9\u0016DA\u000bUS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:\u0002-QLWM]\"p[B\f7\r^5p]6+GO]5dg\u0002\n\u0011BY;jY\u0012\u001cVmZ:\u0015\u000bmk7/_>\u0011\u0007q#wM\u0004\u0002^E:\u0011a,Y\u0007\u0002?*\u0011\u0001-I\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019J!aY\u0013\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\u0004'\u0016\f(BA2&!\tA7.D\u0001j\u0015\tQw$A\u0002m_\u001eL!\u0001\\5\u0003\u001dQKWM\u001d'pON+w-\\3oi\")an\u0003a\u0001_\u0006)1/\u001b>fgB\u0019A\f\u001a9\u0011\u0005\u0011\n\u0018B\u0001:&\u0005\rIe\u000e\u001e\u0005\bi.\u0001\n\u00111\u0001v\u0003M1\u0017N]:u\u0005\u0006$8\r\u001b+j[\u0016\u001cH/Y7q!\raFM\u001e\t\u0003I]L!\u0001_\u0013\u0003\t1{gn\u001a\u0005\bu.\u0001\n\u00111\u0001v\u00031i\u0017\r\u001f+j[\u0016\u001cH/Y7q\u0011\u001da8\u0002%AA\u0002Y\f!BY1tK>3gm]3u\u0003M\u0011W/\u001b7e'\u0016<7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005y(fA;\u0002\u0002-\u0012\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003%)hn\u00195fG.,GMC\u0002\u0002\u000e\u0015\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t\"a\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\nck&dGmU3hg\u0012\"WMZ1vYR$3'A\nck&dGmU3hg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u001a)\u001aa/!\u0001\u0002\u0019\t,\u0018\u000e\u001c3N_\u000e\\Gj\\4\u0015%\u0005}\u0011QEA\u0019\u0003k\tI$!\u0010\u0002B\u0005\u0015\u0013\u0011\n\t\u0004Q\u0006\u0005\u0012bAA\u0012S\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\t9c\u0004a\u0001\u0003S\t\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\t\u0005-\u0012QF\u0007\u0002;%\u0019\u0011qF\u000f\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007BBA\u001a\u001f\u0001\u00071,A\u0005dY\u0016\fgnU3hg\"1\u0011qG\bA\u0002m\u000b\u0011\u0002Z5sif\u001cVmZ:\t\r\u0005mr\u00021\u0001q\u0003\u0011\u0019\u0018N_3\t\r\u0005}r\u00021\u0001q\u00039awnZ*uCJ$xJ\u001a4tKRDa!a\u0011\u0010\u0001\u00041\u0018aF2p[B\f7\r\u001e#jeRL8\u000b^1si>3gm]3u\u0011\u0019\t9e\u0004a\u0001m\u0006\u0011B/[3sK\u0012dunZ#oI>3gm]3u\u0011\u001d\tYe\u0004a\u0001\u0003\u001b\n\u0011#[:US\u0016\u00148i\\7qC\u000e$\u0018M\u00197f!\r!\u0013qJ\u0005\u0004\u0003#*#a\u0002\"p_2,\u0017M\\\u0001\u001cEVLG\u000eZ'pG.$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0019\u0005]\u00131MA7\u0003c\n\u0019(!\u001e\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018\u001e\u0003\u0015\u0019H/\u0019;f\u0013\u0011\t\t'a\u0017\u0003%QKWM\u001d)beRLG/[8o'R\fG/\u001a\u0005\b\u0003K\u0002\u0002\u0019AA4\u0003Aa\u0017m\u001d;D_6\u0004\u0018m\u0019;Ti\u0006$8\u000f\u0005\u0003\u0002Z\u0005%\u0014\u0002BA6\u00037\u0012AbQ8na\u0006\u001cGo\u0015;biNDq!a\u001c\u0011\u0001\u0004\t9'A\fbG\u000e,X.\u001e7bi\u0016$7i\\7qC\u000e$8\u000b^1ug\"1\u0011q\t\tA\u0002YDa!a\u0011\u0011\u0001\u00041\bBBA<!\u0001\u0007\u0001/A\u0005u_R\fGnU5{K\u0006)C/Z:u'\u000eDW\rZ;mS:<G*Y4D_6\u0004\u0018m\u0019;j_:,eMZ5dS\u0016t7-\u001f\u000b\u0002}!\u001a\u0011#a \u0011\t\u0005\u0005\u0015qR\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006\u0019\u0011\r]5\u000b\t\u0005%\u00151R\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ti\tO\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003#\u000b\u0019I\u0001\u0003UKN$\u0018A\t;fgR\u001c6\r[3ek2Lgn\u001a'bO6Kgn\u00117fC:\f'\r\\3SCRLw\u000eK\u0002\u0013\u0003\u007f\n1\u0005^3tiN\u001b\u0007.\u001a3vY&tw\rT1h\u001b\u0006D8i\\7qC\u000e$\u0018n\u001c8MC\u001el5\u000fK\u0002\u0014\u0003\u007f\n1\u0005^3tiN\u001b\u0007.\u001a3vY&tw\rT1h\u001b&t7i\\7qC\u000e$\u0018n\u001c8MC\u001el5\u000fK\u0002\u0015\u0003\u007f\n\u0011\u0004^3tiN\u001b\u0007.\u001a3vY&tw\rT1h\u001d>tG)\u001b:us\"\u001aQ#a \u00029Q,7\u000f^*dQ\u0016$W\u000f\\5oO2\u000bw\rR3mKR,Gk\u001c9jG\"\u001aa#a \u0002MQ,7\u000f^*dQ\u0016$W\u000f\\5oO2\u000bwMT8o)&,'oQ8na\u0006\u001cG/\u001a3U_BL7\rK\u0002\u0018\u0003\u007f\u0002")
public class TierLogCleanerManagerTest {
    private Time mockTime = new MockTime(0L, 0L);
    private final Throttler throttler;
    private final CompactionTasksConfig tierCompactionTaskConfig;
    private final TierCompactionMetrics tierCompactionMetrics;

    public Time mockTime() {
        return this.mockTime;
    }

    public void mockTime_$eq(Time x$1) {
        this.mockTime = x$1;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public CompactionTasksConfig tierCompactionTaskConfig() {
        return this.tierCompactionTaskConfig;
    }

    public TierCompactionMetrics tierCompactionMetrics() {
        return this.tierCompactionMetrics;
    }

    public Seq<TierLogSegment> buildSegs(Seq<Object> sizes, Seq<Object> firstBatchTimestamp, Seq<Object> maxTimestamp, long baseOffset) {
        ListBuffer segsList = new ListBuffer();
        LongRef segBaseOffset = LongRef.create((long)baseOffset);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), sizes.size()).foreach((Function1 & Serializable)i -> TierLogCleanerManagerTest.$anonfun$buildSegs$1(sizes, segBaseOffset, firstBatchTimestamp, maxTimestamp, segsList, BoxesRunTime.unboxToInt((Object)i)));
        return segsList.toList();
    }

    public Seq<Object> buildSegs$default$2() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
    }

    public Seq<Object> buildSegs$default$3() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
    }

    public long buildSegs$default$4() {
        return 0L;
    }

    public AbstractLog buildMockLog(TopicIdPartition topicIdPartition, Seq<TierLogSegment> cleanSegs, Seq<TierLogSegment> dirtySegs, int size, int logStartOffset, long compactDirtyStartOffset, long tieredLogEndOffset, boolean isTierCompactable) {
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(logStartOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.size())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(size)));
        Mockito.when((Object)log.tieredLogSegments(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)compactDirtyStartOffset))).thenAnswer(x$1 -> cleanSegs.iterator());
        Mockito.when((Object)log.tieredLogSegments(ArgumentMatchers.eq((long)compactDirtyStartOffset), ArgumentMatchers.eq((long)(compactDirtyStartOffset + 1L)))).thenAnswer(x$2 -> dirtySegs.iterator());
        Mockito.when((Object)log.tieredLogSegments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((long)(tieredLogEndOffset + 1L)))).thenAnswer(x$3 -> dirtySegs.iterator());
        Mockito.when((Object)log.tieredLogSegments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((long)Long.MAX_VALUE))).thenAnswer(x$4 -> dirtySegs.iterator());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log.isTierCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isTierCompactable));
        return log;
    }

    public TierPartitionState buildMockTierPartitionState(CompactStats lastCompactStats, CompactStats accumulatedCompactStats, long tieredLogEndOffset, long compactDirtyStartOffset, int totalSize) {
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)tieredLogEndOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.compactDirtyStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)compactDirtyStartOffset));
        Mockito.when((Object)tierPartitionState.lastCompactStats()).thenReturn((Object)lastCompactStats);
        Mockito.when((Object)tierPartitionState.accumulatedCompactStats()).thenReturn((Object)accumulatedCompactStats);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.totalSize())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(totalSize)));
        return tierPartitionState;
    }

    @Test
    public void testSchedulingLagCompactionEfficiency() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), this.buildSegs$default$2(), this.buildSegs$default$3(), this.buildSegs$default$4());
        Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}));
        Seq<Object> x$3 = this.buildSegs$default$2();
        Seq<Object> x$4 = this.buildSegs$default$3();
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)x$1, x$3, x$4, 41L);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 80L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 300L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        LogConfig.ConfluentLogConfig confluentLogConfig = (LogConfig.ConfluentLogConfig)Mockito.mock(LogConfig.ConfluentLogConfig.class);
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(0.2));
        Mockito.when((Object)confluentLogConfig.tierCleanerMinCleanableRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(0.5));
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tieredLogSegments(compactDirtyStartOffset, Long.MAX_VALUE)).thenAnswer(x$5 -> package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$));
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        this.mockTime().sleep(501L);
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)60L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.6, (double)logToClean.cleanableRatio());
        Assertions.assertEquals((double)0.45, (double)logToClean.expectedCompactionEfficiency(), (double)0.001, (String)"Scheduling lag should use the min compaction efficiency value as threshold was met");
        Assertions.assertTrue((boolean)logToClean.cleanable(), (String)"compaction efficiency should lead to cleanable log");
    }

    @Test
    public void testSchedulingLagMinCleanableRatio() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), this.buildSegs$default$2(), this.buildSegs$default$3(), this.buildSegs$default$4());
        Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}));
        Seq x$2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{100L, 100L}));
        Seq<Object> x$4 = this.buildSegs$default$2();
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)x$1, x$4, (Seq<Object>)x$2, 41L);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        LogConfig.ConfluentLogConfig confluentLogConfig = (LogConfig.ConfluentLogConfig)Mockito.mock(LogConfig.ConfluentLogConfig.class);
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(Double.MAX_VALUE));
        Mockito.when((Object)confluentLogConfig.tierCleanerMinCleanableRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(0.5));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.tieredLogSegments(compactDirtyStartOffset, Long.MAX_VALUE)).thenAnswer(x$6 -> package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$));
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        this.mockTime().sleep(301L);
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)60L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.6, (double)logToClean.cleanableRatio());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)logToClean.thresholdMaxCompactionDelayMs());
        CancellationContext ctx = CancellationContext.newContext();
        CompactionTask task = new CompactionTask(ctx.subContext(), topicIdPartition, (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(0, (Option)None$.MODULE$), this.tierCompactionMetrics());
        MockTime time = new MockTime();
        task.maybeUpdateLogToClean(replicaManager, time.milliseconds());
        Assertions.assertTrue((boolean)((TierLogToClean)task.logToClean().get()).cleanable(), (String)"compaction ratio should lead to cleanable log");
        Mockito.when((Object)log.tieredLogSegments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((long)(tieredLogEndOffset + 1L)))).thenAnswer(x$7 -> package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        task.maybeUpdateLogToClean(replicaManager, time.milliseconds());
        Assertions.assertEquals((Object)new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(0))), (Object)((TierLogToClean)task.logToClean().get()).computedAtMaterializedOffset());
        Assertions.assertEquals((long)0L, (long)((TierLogToClean)task.logToClean().get()).cleanableBytes());
    }

    @Test
    public void testSchedulingLagMaxCompactionLagMs() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{100L, 100L}))), this.buildSegs$default$3(), this.buildSegs$default$4());
        Seq x$1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}));
        Seq x$2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{300L, 200L}));
        Seq<Object> x$4 = this.buildSegs$default$3();
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)x$1, (Seq<Object>)x$2, x$4, 41L);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        LogConfig.ConfluentLogConfig confluentLogConfig = (LogConfig.ConfluentLogConfig)Mockito.mock(LogConfig.ConfluentLogConfig.class);
        Mockito.when((Object)logConfig.maxCompactionLagMs()).thenReturn((Object)Predef$.MODULE$.long2Long(300L));
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(Double.MAX_VALUE));
        Mockito.when((Object)confluentLogConfig.tierCleanerMinCleanableRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(0.5));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        this.mockTime().sleep(501L);
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)60L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.6, (double)logToClean.cleanableRatio());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)logToClean.thresholdMaxCompactionDelayMs());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)logToClean.cleanable()));
    }

    @Test
    public void testSchedulingLagMinCompactionLagMs() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.mockTime_$eq((Time)new MockTime(0L, 0L));
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{100L, 100L}))), this.buildSegs$default$4());
        Seq<TierLogSegment> dirtySegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{30, 30}))), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{300L, 700L}))), 41L);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 100L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)log.tieredLogSegments(ArgumentMatchers.eq((long)compactDirtyStartOffset), ArgumentMatchers.eq((long)71L))).thenAnswer(x$8 -> ((IterableOnce)dirtySegs.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TierLogCleanerManagerTest.$anonfun$testSchedulingLagMinCompactionLagMs$2(x$9)))).iterator());
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        LogConfig.ConfluentLogConfig confluentLogConfig = (LogConfig.ConfluentLogConfig)Mockito.mock(LogConfig.ConfluentLogConfig.class);
        Mockito.when((Object)logConfig.compactionLagMs()).thenReturn((Object)Predef$.MODULE$.long2Long(200L));
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(Double.MAX_VALUE));
        Mockito.when((Object)confluentLogConfig.tierCleanerMinCleanableRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(0.6));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        this.mockTime().sleep(501L);
        Predef$.MODULE$.println((Object)log.topicPartition());
        TierLogToClean logToClean = CompactionTask$.MODULE$.getTierLogToClean(log, this.mockTime(), this.mockTime().milliseconds());
        Assertions.assertEquals((long)40L, (long)logToClean.cleanBytes());
        Assertions.assertEquals((long)30L, (long)logToClean.cleanableBytes());
        Assertions.assertEquals((double)0.42, (double)logToClean.cleanableRatio(), (double)0.009);
        Assertions.assertEquals((long)71L, (long)logToClean.firstUncleanableOffset());
    }

    @Test
    public void testSchedulingLagNonDirty() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("compactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.time()).thenReturn((Object)this.mockTime());
        Seq<TierLogSegment> cleanSegs = this.buildSegs((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{20, 20}))), this.buildSegs$default$2(), this.buildSegs$default$3(), this.buildSegs$default$4());
        Seq dirtySegs = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
        long compactDirtyStartOffset = 41L;
        CompactStats lastCompactStats = new CompactStats(100L, 40L, 60L);
        CompactStats accumulatedCompactStats = new CompactStats(500L, 200L, 250L);
        long tieredLogEndOffset = 41L;
        AbstractLog log = this.buildMockLog(topicIdPartition, cleanSegs, (Seq<TierLogSegment>)dirtySegs, 100, 0, compactDirtyStartOffset, tieredLogEndOffset, true);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        LogConfig.ConfluentLogConfig confluentLogConfig = (LogConfig.ConfluentLogConfig)Mockito.mock(LogConfig.ConfluentLogConfig.class);
        Mockito.when((Object)logConfig.maxCompactionLagMs()).thenReturn((Object)Predef$.MODULE$.long2Long(Long.MAX_VALUE));
        Mockito.when((Object)logConfig.confluentLogConfig()).thenReturn((Object)confluentLogConfig);
        Mockito.when((Object)confluentLogConfig.tierCleanerCompactMinEfficiencyRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(Double.MAX_VALUE));
        Mockito.when((Object)confluentLogConfig.tierCleanerMinCleanableRatio()).thenReturn((Object)Predef$.MODULE$.double2Double(0.5));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        TierPartitionState tierPartitionState = this.buildMockTierPartitionState(lastCompactStats, accumulatedCompactStats, tieredLogEndOffset, compactDirtyStartOffset, 100);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        CancellationContext ctx = CancellationContext.newContext();
        MockTime time = new MockTime();
        CompactionTask task = new CompactionTask(ctx.subContext(), topicIdPartition, (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(0, (Option)None$.MODULE$), this.tierCompactionMetrics());
        task.maybeUpdateLogToClean(replicaManager, time.milliseconds());
        Assertions.assertFalse((boolean)((TierLogToClean)task.logToClean().get()).cleanable(), (String)"No dirty bytes should result in non cleanable log");
    }

    @Test
    public void testSchedulingLagDeleteTopic() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("deleteTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logConfig.delete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logConfig.compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        CancellationContext ctx = CancellationContext.newContext();
        MockTime time = new MockTime();
        CompactionTask task = new CompactionTask(ctx.subContext(), topicIdPartition, (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(0, (Option)None$.MODULE$), this.tierCompactionMetrics());
        task.maybeUpdateLogToClean(replicaManager, time.milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)task.logToClean(), (String)"Scheduling lag of delete-retention partition should be None");
    }

    @Test
    public void testSchedulingLagNonTierCompactedTopic() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("nonCompactTopic", UUID.randomUUID(), 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicIdPartition.topicPartition());
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logConfig.delete())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)logConfig.compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        CancellationContext ctx = CancellationContext.newContext();
        CompactionTask task = new CompactionTask(ctx.subContext(), topicIdPartition, (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(0, (Option)None$.MODULE$), this.tierCompactionMetrics());
        MockTime time = new MockTime();
        task.maybeUpdateLogToClean(replicaManager, time.milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)task.logToClean());
    }

    public static final /* synthetic */ ListBuffer $anonfun$buildSegs$1(Seq sizes$1, LongRef segBaseOffset$1, Seq firstBatchTimestamp$1, Seq maxTimestamp$1, ListBuffer segsList$1, int i) {
        TierLogSegment seg = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)seg.size())).thenReturn(sizes$1.apply(i - 1));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)seg.baseOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)segBaseOffset$1.elem));
        segBaseOffset$1.elem += (long)BoxesRunTime.unboxToInt((Object)sizes$1.apply(i - 1));
        if (firstBatchTimestamp$1.nonEmpty()) {
            Mockito.when((Object)BoxesRunTime.boxToLong((long)seg.firstBatchTimestamp())).thenReturn(firstBatchTimestamp$1.apply(i - 1));
        }
        if (maxTimestamp$1.nonEmpty()) {
            Mockito.when((Object)BoxesRunTime.boxToLong((long)seg.maxTimestamp())).thenReturn(maxTimestamp$1.apply(i - 1));
        }
        return (ListBuffer)segsList$1.append((Object)seg);
    }

    public static final /* synthetic */ boolean $anonfun$testSchedulingLagMinCompactionLagMs$2(TierLogSegment x$9) {
        return x$9.maxTimestamp() == 300L;
    }

    public TierLogCleanerManagerTest() {
        String string;
        String string2;
        Time x$3 = this.mockTime();
        boolean bl = true;
        String string3 = string2 = "throttler";
        string2 = null;
        String x$5 = string3;
        String string4 = string = "entries";
        string = null;
        String x$6 = string4;
        this.throttler = new Throttler(2.147483647E9, Integer.MAX_VALUE, bl, x$5, x$6, x$3);
        this.tierCompactionTaskConfig = new CompactionTasksConfig(0x4000000, 0.9, 524288, 0x100000, Double.MAX_VALUE, 300, 0, 0x40000000L);
        this.tierCompactionMetrics = new TierCompactionMetrics(new LogCleanerMetrics((Option)None$.MODULE$), (Option)None$.MODULE$);
    }
}

