/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicListeners;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierTopicListenersTest {
    @Test
    public void addAndRemoveTrackedTest() {
        MockTime time = new MockTime();
        TierTopicListeners listeners = new TierTopicListeners((Time)time);
        TopicIdPartition topicIdPartition = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);
        UUID objectId = UUID.randomUUID();
        CompletableFuture result = new CompletableFuture();
        TierSegmentDeleteInitiate metadata = new TierSegmentDeleteInitiate(topicIdPartition, 0, objectId, new OffsetAndEpoch(30L, Optional.of(1)));
        listeners.addTracked((AbstractTierMetadata)metadata, result);
        Assertions.assertEquals((long)1L, (long)listeners.numListeners());
        time.sleep(1L);
        Assertions.assertEquals((long)Duration.ofMillis(1L).toNanos(), (long)((Long)listeners.maxListenerTimeNanos().get()));
        Optional removedFutureOpt = listeners.getAndRemoveTracked((AbstractTierMetadata)metadata);
        Assertions.assertEquals((long)0L, (long)listeners.numListeners());
        Assertions.assertFalse((boolean)listeners.maxListenerTimeNanos().isPresent());
        Assertions.assertTrue((boolean)removedFutureOpt.isPresent());
        ((CompletableFuture)removedFutureOpt.get()).complete(TierPartitionState.AppendResult.ACCEPTED);
        try {
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, result.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Assertions.fail();
        }
    }

    @Test
    public void replaceListenerTest() {
        MockTime time = new MockTime();
        TierTopicListeners listeners = new TierTopicListeners((Time)time);
        TopicIdPartition topicIdPartition = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);
        UUID objectId = UUID.randomUUID();
        CompletableFuture result = new CompletableFuture();
        TierSegmentDeleteInitiate metadata = new TierSegmentDeleteInitiate(topicIdPartition, 0, objectId, new OffsetAndEpoch(30L, Optional.of(1)));
        listeners.addTracked((AbstractTierMetadata)metadata, result);
        Assertions.assertEquals((long)1L, (long)listeners.numListeners());
        TierSegmentDeleteInitiate replace = new TierSegmentDeleteInitiate(topicIdPartition, 0, objectId, new OffsetAndEpoch(30L, Optional.of(1)));
        CompletableFuture result2 = new CompletableFuture();
        listeners.addTracked((AbstractTierMetadata)replace, result2);
        Assertions.assertEquals((long)1L, (long)listeners.numListeners());
        Assertions.assertTrue((boolean)result.isCompletedExceptionally());
        Assertions.assertFalse((boolean)result2.isDone());
    }

    @Test
    public void shutdownTest() {
        MockTime time = new MockTime();
        TierTopicListeners listeners = new TierTopicListeners((Time)time);
        TopicIdPartition topicIdPartition = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);
        UUID objectId = UUID.randomUUID();
        CompletableFuture result = new CompletableFuture();
        TierSegmentDeleteInitiate metadata = new TierSegmentDeleteInitiate(topicIdPartition, 0, objectId, new OffsetAndEpoch(30L, Optional.of(1)));
        listeners.addTracked((AbstractTierMetadata)metadata, result);
        Assertions.assertEquals((long)1L, (long)listeners.numListeners());
        Assertions.assertEquals((long)0L, (long)((Long)listeners.maxListenerTimeNanos().get()));
        listeners.shutdown();
        Assertions.assertFalse((boolean)listeners.maxListenerTimeNanos().isPresent());
        Assertions.assertTrue((boolean)result.isCancelled());
        Assertions.assertEquals((long)0L, (long)listeners.numListeners());
    }

    @Test
    public void addRemoveListenersForTopicIdPartition() {
        MockTime time = new MockTime();
        TierTopicListeners listeners = new TierTopicListeners((Time)time);
        TopicIdPartition topicIdPartition = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);
        CompletableFuture result1 = new CompletableFuture();
        TierSegmentDeleteInitiate deleteInitiate = new TierSegmentDeleteInitiate(topicIdPartition, 0, UUID.randomUUID(), new OffsetAndEpoch(30L, Optional.of(1)));
        listeners.addTracked((AbstractTierMetadata)deleteInitiate, result1);
        time.sleep(1L);
        CompletableFuture result2 = new CompletableFuture();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, UUID.randomUUID(), new OffsetAndEpoch(30L, Optional.of(1)));
        listeners.addTracked((AbstractTierMetadata)uploadComplete, result2);
        Assertions.assertEquals((long)2L, (long)listeners.numListeners());
        Assertions.assertEquals((long)Duration.ofMillis(1L).toNanos(), (long)((Long)listeners.maxListenerTimeNanos().get()));
        Collection removedFutures = listeners.getAndRemoveAll(topicIdPartition);
        removedFutures.forEach(f -> f.complete(TierPartitionState.AppendResult.FENCED));
        Assertions.assertFalse((boolean)listeners.maxListenerTimeNanos().isPresent());
        try {
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, result1.get());
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, result2.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Assertions.fail();
        }
        Assertions.assertEquals((long)0L, (long)listeners.numListeners());
    }
}

