/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.NoOpLogOffsetsListener$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\u0014(\u00011BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004B\u0001\u0001\u0006I!\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u00019\u0011\u0019\u0019\u0005\u0001)A\u0005s!9A\t\u0001b\u0001\n\u0003)\u0005B\u0002'\u0001A\u0003%a\tC\u0004N\u0001\t\u0007I\u0011\u0001(\t\re\u0003\u0001\u0015!\u0003P\u0011\u001dQ\u0006A1A\u0005\u00029Caa\u0017\u0001!\u0002\u0013y\u0005b\u0002/\u0001\u0005\u0004%\tA\u0014\u0005\u0007;\u0002\u0001\u000b\u0011B(\t\u000fy\u0003!\u0019!C\u0001?\"1a\r\u0001Q\u0001\n\u0001Dqa\u001a\u0001C\u0002\u0013\u0005\u0001\u000e\u0003\u0004u\u0001\u0001\u0006I!\u001b\u0005\nk\u0002\u0001\r\u00111A\u0005\u0002YD\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011A?\t\u0015\u0005\u001d\u0001\u00011A\u0001B\u0003&q\u000fC\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\f!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u001a\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003k\u0001A\u0011AA\f\u0011\u001d\ty\u0004\u0001C\u0001\u0003/Aq!!\u0013\u0001\t\u0003\t9\u0002C\u0004\u0002N\u0001!\t!a\u0006\t\u000f\u0005E\u0003\u0001\"\u0001\u0002\u0018!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0001bBA-\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003;\u0002A\u0011AA\f\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002\n\u0002!I!a#\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\"9\u0011Q\u0015\u0001\u0005\n\u0005]!a\u0005#v[BdunZ*fO6,g\u000e^:UKN$(B\u0001\u0015*\u0003\u0015!xn\u001c7t\u0015\u0005Q\u0013!B6bM.\f7\u0001A\n\u0003\u00015\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00016!\t1\u0004!D\u0001(\u0003\u0019!X\u000e\u001d#jeV\t\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005\u0011\u0011n\u001c\u0006\u0002}\u0005!!.\u0019<b\u0013\t\u00015H\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005Y1/Z4nK:$h*Y7f+\u00051\u0005CA$K\u001b\u0005A%BA%>\u0003\u0011a\u0017M\\4\n\u0005-C%AB*ue&tw-\u0001\u0007tK\u001elWM\u001c;OC6,\u0007%A\u0006m_\u001e4\u0015\u000e\\3QCRDW#A(\u0011\u0005A;fBA)V!\t\u0011v&D\u0001T\u0015\t!6&\u0001\u0004=e>|GOP\u0005\u0003->\na\u0001\u0015:fI\u00164\u0017BA&Y\u0015\t1v&\u0001\u0007m_\u001e4\u0015\u000e\\3QCRD\u0007%A\u0007j]\u0012,\u0007PR5mKB\u000bG\u000f[\u0001\u000fS:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5!\u0003E!\u0018.\\3J]\u0012,\u0007PR5mKB\u000bG\u000f[\u0001\u0013i&lW-\u00138eKb4\u0015\u000e\\3QCRD\u0007%\u0001\u0003uS6,W#\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rL\u0013!B;uS2\u001c\u0018BA3c\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u00022bi\u000eDWm]\u000b\u0002SB\u0019!n\\9\u000e\u0003-T!\u0001\\7\u0002\u000f5,H/\u00192mK*\u0011anL\u0001\u000bG>dG.Z2uS>t\u0017B\u00019l\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005Y\u0012\u0018BA:(\u0005%\u0011\u0015\r^2i\u0013:4w.\u0001\u0005cCR\u001c\u0007.Z:!\u0003\rawnZ\u000b\u0002oB\u0011\u0001P_\u0007\u0002s*\u0011Q/K\u0005\u0003wf\u00141\"\u00112tiJ\f7\r\u001e'pO\u00069An\\4`I\u0015\fHc\u0001@\u0002\u0004A\u0011af`\u0005\u0004\u0003\u0003y#\u0001B+oSRD\u0001\"!\u0002\u0014\u0003\u0003\u0005\ra^\u0001\u0004q\u0012\n\u0014\u0001\u00027pO\u0002\nqb\u00195fG.\u001cX/\\#oC\ndW\rZ\u000b\u0003\u0003\u001b\u00012ALA\b\u0013\r\t\tb\f\u0002\b\u0005>|G.Z1o\u0003I1G\u000f]:DY\u0016\fg.\u001e9F]\u0006\u0014G.\u001a3\u0002\u000bM,G/\u00169\u0015\u0003yD3aFA\u000e!\u0011\ti\"a\f\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t1!\u00199j\u0015\u0011\t)#a\n\u0002\u000f),\b/\u001b;fe*!\u0011\u0011FA\u0016\u0003\u0015QWO\\5u\u0015\t\ti#A\u0002pe\u001eLA!!\r\u0002 \tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!\u0005$GmU5na2,'+Z2pe\u0012\u001c\u0018\u0001\u0003;fCJ$un\u001e8)\u0007e\tI\u0004\u0005\u0003\u0002\u001e\u0005m\u0012\u0002BA\u001f\u0003?\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002AQ,7\u000f\u001e\"bi\u000eD\u0017I\u001c3SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1PkR\u0004X\u000f\u001e\u0015\u00045\u0005\r\u0003\u0003BA\u000f\u0003\u000bJA!a\u0012\u0002 \t!A+Z:u\u0003A!Xm\u001d;Qe&tG\u000fR1uC2{w\rK\u0002\u001c\u0003\u0007\nq\u0003^3ti\u0012+X\u000e]%oI\u0016DX*[:nCR\u001c\u0007.Z:)\u0007q\t\u0019%A\fuKN$H)^7q)&lW-\u00138eKb,%O]8sg\"\u001aQ$a\u0011\u00025Q,7\u000f\u001e#v[B$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3)\u0007y\t\u0019%A\fuKN$H)^7q\u001b\u0016$\u0018\rZ1uCJ+7m\u001c:eg\"\u001aq$a\u0011\u0002%Q,7\u000f\u001e#v[B,U\u000e\u001d;z\u0013:$W\r\u001f\u0015\u0004A\u0005\r\u0013A\u0005:v]\u0012+X\u000e\u001d'pON+w-\\3oiN$2aTA3\u0011\u001d\t9'\ta\u0001\u0003S\nA!\u0019:hgB!a&a\u001bP\u0013\r\tig\f\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0012e\u0016\fGMQ1uG\"lU\r^1eCR\fG\u0003BA:\u0003s\u0002BALA;\u001f&\u0019\u0011qO\u0018\u0003\r=\u0003H/[8o\u0011\u001d\tYH\ta\u0001\u0003{\nQ\u0001\\5oKN\u0004R!a \u0002\u0006>k!!!!\u000b\u0007\u0005\rU(\u0001\u0003vi&d\u0017\u0002BAD\u0003\u0003\u0013A\u0002T5ti&#XM]1u_J\f\u0001C]3bI\n\u000bGo\u00195SK\u000e|'\u000fZ:\u0015\t\u00055\u0015Q\u0013\t\u0006\u0003\u001f\u000b\tjT\u0007\u0002[&\u0019\u00111S7\u0003\u0007M+\u0017\u000fC\u0004\u0002|\r\u0002\r!! \u0002'A\f'o]3NKR\fG-\u0019;b\r&,G\u000eZ:\u0015\t\u0005m\u0015\u0011\u0015\t\u0006!\u0006uujT\u0005\u0004\u0003?C&aA'ba\"1\u00111\u0015\u0013A\u0002=\u000bA\u0001\\5oK\u0006Y\u0012m]:feR$U/\u001c9M_\u001e\u0014VmY8sI6+G/\u00193bi\u0006\u0004")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private AbstractLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean ftpsCleanupEnabled() {
        return false;
    }

    @BeforeEach
    public void setUp() {
        NoOpLogOffsetsListener$ noOpLogOffsetsListener$;
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        props.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some(Mockito.mock(TierTopicConsumer.class)), (Option)new Some(Mockito.mock(TierObjectStore.class)), new TierPartitionStateFactory(true, this.checksumEnabled(), true, this.ftpsCleanupEnabled()));
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2());
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        Metrics x$8 = new Metrics();
        int x$11 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        None$ x$15 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        NoOpLogOffsetsListener$ noOpLogOffsetsListener$2 = noOpLogOffsetsListener$ = NoOpLogOffsetsListener$.MODULE$;
        noOpLogOffsetsListener$ = null;
        NoOpLogOffsetsListener$ x$18 = noOpLogOffsetsListener$2;
        this.log_$eq((AbstractLog)MergedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, x$8, (Time)x$6, 300000, 3600000, x$11, x$12, tierLogComponents, true, (Option)x$15, true, (LogOffsetsListener)x$18, (Option)x$17));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            void withRecords_partitionLeaderEpoch;
            MemoryRecords memoryRecords;
            AbstractLog qual$1 = this.log();
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toSeq().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            boolean bl = false;
            CompressionType withRecords_compressionType = CompressionType.NONE;
            MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
            Object var7_5 = null;
            simpleRecordArray = null;
            memoryRecords = null;
            MemoryRecords x$1 = memoryRecords2;
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            ApiVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            return qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchAndRecordMetadataOutput() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerEpoch;
        void withTransactionalRecords_producerId;
        MemoryRecords memoryRecords;
        void withIdempotentRecords_records;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        MemoryRecords memoryRecords2;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        MemoryRecords memoryRecords3;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        MemoryRecords memoryRecords4;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        MemoryRecords memoryRecords5;
        AbstractLog qual$1 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        MemoryRecords memoryRecords6 = memoryRecords5 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        Object var31_4 = null;
        simpleRecordArray = null;
        memoryRecords5 = null;
        MemoryRecords x$1 = memoryRecords6;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
        AbstractLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())};
        boolean bl2 = false;
        CompressionType withRecords_compressionType2 = CompressionType.GZIP;
        MemoryRecords memoryRecords7 = memoryRecords4 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        Object var35_13 = null;
        simpleRecordArray2 = null;
        memoryRecords4 = null;
        MemoryRecords x$6 = memoryRecords7;
        AppendOrigin x$8 = qual$2.appendAsLeader$default$3();
        ApiVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, 3, x$8, x$9, x$10);
        AbstractLog qual$3 = this.log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())};
        boolean bl3 = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        MemoryRecords memoryRecords8 = memoryRecords3 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var39_22 = null;
        simpleRecordArray3 = null;
        memoryRecords3 = null;
        MemoryRecords x$11 = memoryRecords8;
        AppendOrigin x$13 = qual$3.appendAsLeader$default$3();
        ApiVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, 3, x$13, x$14, x$15);
        AbstractLog qual$4 = this.log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("h".getBytes())};
        int n = 234123;
        short s = (short)15;
        long l = 29342342L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        MemoryRecords memoryRecords9 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        Object var43_33 = null;
        simpleRecordArray4 = null;
        memoryRecords2 = null;
        MemoryRecords x$16 = memoryRecords9;
        AppendOrigin x$18 = qual$4.appendAsLeader$default$3();
        ApiVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, 3, x$18, x$19, x$20);
        AbstractLog qual$5 = this.log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())};
        int n2 = 266;
        short s2 = (short)99;
        long l2 = 98323L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.GZIP;
        MemoryRecords memoryRecords10 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)withTransactionalRecords_producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        Object var50_44 = null;
        simpleRecordArray5 = null;
        memoryRecords = null;
        MemoryRecords x$21 = memoryRecords10;
        AppendOrigin x$23 = qual$5.appendAsLeader$default$3();
        ApiVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, 5, x$23, x$24, x$25);
        AbstractLog qual$6 = this.log();
        MemoryRecords x$26 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        AppendOrigin.Coordinator$ x$27 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, 7, (AppendOrigin)x$27, x$29, x$30);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()});
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    @Test
    public void testDumpTierPartitionState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(this.log().topicPartition().topic(), UUID.randomUUID(), this.log().topicPartition().partition());
        AbstractLog qual$1 = this.log();
        Uuid x$1 = topicIdPartition.kafkaTopicId();
        int x$2 = qual$1.assignTopicId$default$2();
        qual$1.assignTopicId(x$1, x$2);
        this.log().tierPartitionState().beginCatchup();
        this.log().tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), new OffsetAndEpoch(0L, Optional.empty()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.log().tierPartitionState().append((AbstractTierMetadata)new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 1L, 1500L, 100L, 100, true, false, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), TierObjectStore.OpaqueData.ZEROED), new OffsetAndEpoch(1L, Optional.empty())));
        this.log().tierPartitionState().flush();
        String suffix = this.checksumEnabled() ? Algorithm.ADLER.suffix : Algorithm.NO_CHECKSUM.suffix;
        String[] stringArray = new String[2];
        stringArray[0] = "--files";
        stringArray[1] = new StringBuilder(0).append(MergedLog$.MODULE$.tierStateFile(this.log().dir(), 0L, "").getAbsolutePath()).append(suffix).toString();
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments(stringArray), topicIdPartition);
        String[] stringArray2 = new String[2];
        stringArray2[0] = "--files";
        stringArray2[1] = new StringBuilder(8).append(MergedLog$.MODULE$.tierStateFile(this.log().dir(), 0L, "").getAbsolutePath()).append(".mutable").append(suffix).toString();
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments(stringArray2), topicIdPartition);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_records;
        String string;
        String string2;
        MockTime mockTime = new MockTime();
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string3 = string2 = Defaults$.MODULE$.CleanupPolicy();
        string2 = null;
        String x$6 = string3;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        String string4 = string = Defaults$.MODULE$.MessageFormatVersion();
        string = null;
        String x$10 = string4;
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        boolean bl = Defaults$.MODULE$.TierEnable();
        long l6 = Defaults$.MODULE$.TierLocalHotsetBytes();
        long l7 = Defaults$.MODULE$.TierLocalHotsetMs();
        int n4 = Defaults$.MODULE$.TierSegmentHotsetRollMinBytes();
        long l8 = Defaults$.MODULE$.PreferTierFetchMs();
        boolean bl2 = true;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 0x100000, l2, l3, l4, x$6, n, n2, n3, x$10, l5, bl, l6, l7, n4, l8, bl2);
        MergedLog log = LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), mockTime.scheduler(), (Time)mockTime, 0L, 0L, 300000, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), TierLogComponents$.MODULE$.EMPTY(), new LogDirFailureChannel(10), (LogOffsetsListener)NoOpLogOffsetsListener$.MODULE$, true, (Option<Uuid>)None$.MODULE$, true);
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = new MetadataRecordSerde();
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var33_23 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "false", "--files", this.logFilePath()});
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "false", "--files", this.logFilePath()});
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        CompressionType withRecords_compressionType2 = CompressionType.NONE;
        Object var34_28 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])withRecords_records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var36_29 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "false", "--files", this.logFilePath()});
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        Predef$.MODULE$.assert(output.contains("skipping"));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        System.setOut(System.out);
        return outContent.toString();
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator tokens = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")), (Function1 & Serializable)x$6 -> x$6.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7))))));
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = (FetchDataInfo)this.log().read(0L, Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--deep-iteration", "--files", this.logFilePath()}).split("\n")).listIterator();
        CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.records().batches()).asScala().foreach((Function1 & Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)this.batches().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$3) {
        return x$3.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.batches().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(0).append(suffix).append(new StringBuilder(18).append(" key: message key ").append(offset$1.elem).toString()).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(0).append(suffix).append(new StringBuilder(24).append(" payload: message value ").append(offset$1.elem).toString()).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    private static final void validate$1(String output, TopicIdPartition topicIdPartition$1) {
        Object[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps(lines), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains("Header"))).get()).contains(topicIdPartition$1.topicIdAsBase64()));
        Assertions.assertTrue((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps(lines), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("SEGMENT_UPLOAD_INITIATE"))));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$17)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$18)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$20)))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$21)))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9)))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$10)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$11)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$12)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$13)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$15)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$16)))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

