/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.checksum.Adler32WithInPlaceUpdate;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005=2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u00011!)Q\u0006\u0001C\u00011\ta\u0012\t\u001a7feN\u0012t+\u001b;i\u0013:\u0004F.Y2f+B$\u0017\r^3UKN$(B\u0001\u0005\n\u0003\u0015)H/\u001b7t\u0015\u0005Q\u0011!B6bM.\f7\u0001A\n\u0003\u00015\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\b\u0003)yg\u000e\\=BaB,g\u000e\u001a\u000b\u00023A\u0011aBG\u0005\u00037=\u0011A!\u00168ji\"\u0012!!\b\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\n1!\u00199j\u0015\t\u00113%A\u0004kkBLG/\u001a:\u000b\u0005\u0011*\u0013!\u00026v]&$(\"\u0001\u0014\u0002\u0007=\u0014x-\u0003\u0002)?\t!A+Z:u\u0003)yg\u000e\\=Va\u0012\fG/\u001a\u0015\u0003\u0007u\t1$\u001b8QY\u0006\u001cW-\u00169eCR,\u0017I]8v]\u0012|e/\u001a:GY><\bF\u0001\u0003\u001e\u0003=\t\u0007\u000f]3oI\u0006sG-\u00169eCR,\u0007FA\u0003\u001e\u0001")
public class Adler32WithInPlaceUpdateTest {
    @Test
    public void onlyAppend() {
        Adler32WithInPlaceUpdate adler32 = new Adler32WithInPlaceUpdate();
        String str1 = RandomStringUtils.randomAscii((int)10);
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str1));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(str1));
        String str2 = RandomStringUtils.randomAscii((int)1000);
        String expectedStr = new StringBuilder(0).append(str1).append(str2).toString();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str2));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str3 = RandomStringUtils.randomAscii((int)10000);
        expectedStr = new StringBuilder(0).append(expectedStr).append(str3).toString();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str3));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str4 = RandomStringUtils.randomAscii((int)100000);
        expectedStr = new StringBuilder(0).append(expectedStr).append(str4).toString();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str4));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str5 = RandomStringUtils.randomAscii((int)1000000);
        expectedStr = new StringBuilder(0).append(expectedStr).append(str5).toString();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str5));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
    }

    @Test
    public void onlyUpdate() {
        Adler32WithInPlaceUpdate adler32 = new Adler32WithInPlaceUpdate();
        String str1 = "abcdef";
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str1));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(str1));
        String str2 = "pq";
        String expectedStr = "abpqef";
        adler32.update(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str2), CheckedFileIOTestUtils$.MODULE$.toByteBuffer("cd"), 2L);
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str3 = "rs";
        expectedStr = "abpqrs";
        adler32.update(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str3), CheckedFileIOTestUtils$.MODULE$.toByteBuffer("ef"), 4L);
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str4 = "no";
        expectedStr = "nopqrs";
        adler32.update(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str4), CheckedFileIOTestUtils$.MODULE$.toByteBuffer("ab"), 0L);
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str5 = "xyz";
        expectedStr = "nopxyz";
        adler32.update(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str5), CheckedFileIOTestUtils$.MODULE$.toByteBuffer("qrs"), 3L);
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
    }

    @Test
    public void inPlaceUpdateAroundOverFlow() {
        byte str = 0;
        byte update = -1;
        Adler32WithInPlaceUpdate adler32 = new Adler32WithInPlaceUpdate();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str));
        long val0 = adler32.getValue();
        adler32.update(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(update), CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str), 0L);
        long updateVal = adler32.getValue();
        adler32.reset();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(update));
        Assertions.assertEquals((long)adler32.getValue(), (long)updateVal);
        adler32.update(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str), CheckedFileIOTestUtils$.MODULE$.toByteBuffer(update), 0L);
        Assertions.assertEquals((long)adler32.getValue(), (long)val0);
    }

    @Test
    public void appendAndUpdate() {
        Adler32WithInPlaceUpdate adler32 = new Adler32WithInPlaceUpdate();
        String str1 = "abc";
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str1));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(str1));
        String str2 = "def";
        String expectedStr = new StringBuilder(0).append(str1).append(str2).toString();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str2));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str3 = "123";
        expectedStr = new StringBuilder(0).append(str1).append(str3).toString();
        adler32.update(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str3), CheckedFileIOTestUtils$.MODULE$.toByteBuffer("def"), 3L);
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str4 = "xyz";
        expectedStr = new StringBuilder(0).append(expectedStr).append(str4).toString();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str4));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String prevStr = expectedStr;
        String str5 = RandomStringUtils.randomAscii((int)1000000);
        expectedStr = new StringBuilder(0).append(expectedStr).append(str5).toString();
        adler32.append(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str5));
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
        String str6 = RandomStringUtils.randomAscii((int)1000000);
        expectedStr = new StringBuilder(0).append(prevStr).append(str6).toString();
        adler32.update(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str6), CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str5), (long)prevStr.length());
        Assertions.assertEquals((long)adler32.getValue(), (long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expectedStr));
    }
}

