/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import kafka.tier.serdes.CheckedFileIOHeader;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.TestArguments;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.kafka.common.errors.MultiChecksumTypeException;
import org.apache.kafka.common.errors.OtherChecksumTypeException;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tEc\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004F\u0001\u0001\u0006I!\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0003=\u0011\u00199\u0005\u0001)A\u0005{!9\u0001\n\u0001b\u0001\n\u0013a\u0004BB%\u0001A\u0003%Q\bC\u0004K\u0001\t\u0007I\u0011B&\t\rY\u0003\u0001\u0015!\u0003M\u0011\u001d9\u0006A1A\u0005\naCa\u0001\u0018\u0001!\u0002\u0013I\u0006bB/\u0001\u0005\u0004%I\u0001\u0017\u0005\u0007=\u0002\u0001\u000b\u0011B-\t\u000b}\u0003A\u0011\u00011\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!!$\u0001\t\u0003\ty\tC\u0004\u0002 \u0002!\t!a$\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002\u0010\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006bBAY\u0001\u0011%\u00111\u0017\u0005\b\u0003\u001f\u0004A\u0011AAH\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+Dq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002h\u0002!\t!a$\t\u000f\u0005-\b\u0001\"\u0001\u0002\u0010\"9\u0011q\u001e\u0001\u0005\n\u0005E\bbBA|\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[AqA!\u0013\u0001\t\u0013\u0011YEA\tDQ\u0016\u001c7.\u001a3GS2,\u0017j\u0014+fgRT!\u0001L\u0017\u0002\u000bU$\u0018\u000e\\:\u000b\u00039\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001cA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u0016\u0002\u0011Q,7\u000f^*ueF*\u0012!\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bA\u0001\\1oO*\t!)\u0001\u0003kCZ\f\u0017B\u0001#@\u0005\u0019\u0019FO]5oO\u0006IA/Z:u'R\u0014\u0018\u0007I\u0001\ti\u0016\u001cHo\u0015;se\u0005IA/Z:u'R\u0014(\u0007I\u0001\ti\u0016\u001cHo\u0015;sg\u0005IA/Z:u'R\u00148\u0007I\u0001\u000bi\u0016\u001cH\u000fS3bI\u0016\u0014X#\u0001'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016a\u00034mCR\u0014WO\u001a4feNT!!\u0015*\u0002\r\u001d|wn\u001a7f\u0015\u0005\u0019\u0016aA2p[&\u0011QK\u0014\u0002\u0012\r2\fGOQ;gM\u0016\u0014()^5mI\u0016\u0014\u0018a\u0003;fgRDU-\u00193fe\u0002\nA\u0002^3ti\"+\u0017\rZ3s\u0013\u0012,\u0012!\u0017\t\u0003eiK!aW\u001a\u0003\u0007%sG/A\u0007uKN$\b*Z1eKJLE\rI\u0001\u0013Kb\u0004Xm\u0019;fI\"+\u0017\rZ3s'&TX-A\nfqB,7\r^3e\u0011\u0016\fG-\u001a:TSj,\u0007%\u0001\u0006uKN$8I]3bi\u0016$\"!\u00193\u0011\u0005I\u0012\u0017BA24\u0005\u0011)f.\u001b;\t\u000b\u0015t\u0001\u0019\u00014\u0002\t\u0005\u0014xm\u001d\t\u0003O*t!A\u000f5\n\u0005%\\\u0013!\u0004+fgR\f%oZ;nK:$8/\u0003\u0002lY\n!\u0011I]4t\u0015\tI7\u0006\u000b\u0003\u000f]rl\bCA8{\u001b\u0005\u0001(BA9s\u0003!\u0001(o\u001c<jI\u0016\u0014(BA:u\u0003\u0019\u0001\u0018M]1ng*\u0011QO^\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\b0A\u0003kk:LGOC\u0001z\u0003\ry'oZ\u0005\u0003wB\u0014q\"\u0011:hk6,g\u000e^:T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0002}B\u0011qm`\u0005\u0004\u0003\u0003a'A\u0006,bY&$\u0017I]4v[\u0016tGo\u001d)s_ZLG-\u001a:)\u00079\t)\u0001\u0005\u0003\u0002\b\u0005%Q\"\u0001:\n\u0007\u0005-!OA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f!\u0003^3ti\"+\u0017\rZ3s\u0007\",7m[:v[R\u0019\u0011-!\u0005\t\u000b\u0015|\u0001\u0019\u00014)\u000b=qG0!\u0006$\u0005\u0005]\u0001cA4\u0002\u001a%\u0019\u00111\u00047\u00037Y\u000bG.\u001b3BI2,'/\u0011:hk6,g\u000e^:Qe>4\u0018\u000eZ3sQ\ry\u0011QA\u0001#i\u0016\u001cHo\u0016:ji\u0016<\u0016\u000e\u001e5J]R,'\u000f\\3bm\u0016$')\u001f;f\u0005V4g-\u001a:\u0015\u0007\u0005\f\u0019\u0003C\u0003f!\u0001\u0007a\r\u000b\u0003\u0011]rl\bf\u0001\t\u0002\u0006\u0005)B/Z:u/JLG/Z,ji\"\u0004vn]5uS>tGcA1\u0002.!)Q-\u0005a\u0001M\"\"\u0011C\u001c?~Q\r\t\u0012QA\u0001\ni\u0016\u001cHo\u0016:ji\u0016$2!YA\u001c\u0011\u0015)'\u00031\u0001gQ\u0011\u0011b\u000e`?)\u0007I\t)!\u0001\u0006uKN$(+Z(qK:$2!YA!\u0011\u0015)7\u00031\u0001gQ\u0011\u0019b\u000e`?)\u0007M\t)!A\u000fuKN$hi\u001c:dK6{G-\u001b4z\r&dW\rV8GC&dw\n]3o)\r\t\u00171\n\u0005\u0006KR\u0001\rA\u001a\u0015\u0006)9d\u0018Q\u0003\u0015\u0004)\u0005\u0015\u0011!\t;fgR4uN]2f\u001b>$\u0017NZ=GS2,Gk\u001c$bS24\u0016\r\\5eCR,GcA1\u0002V!)Q-\u0006a\u0001M\"*QC\u001c?\u0002\u0016!\u001aQ#!\u0002\u0002\u0019Q,7\u000f\u001e+sk:\u001c\u0017\r^3\u0015\u0007\u0005\fy\u0006C\u0003f-\u0001\u0007a\r\u000b\u0003\u0017]rl\bf\u0001\f\u0002\u0006\u0005AB/Z:u)J,hnY1uK^KG\u000f\u001b)pg&$\u0018n\u001c8\u0015\u0007\u0005\fI\u0007C\u0003f/\u0001\u0007a\r\u000b\u0003\u0018]rl\bfA\f\u0002\u0006\u0005qA/Z:u)J\fgn\u001d4feR{GcA1\u0002t!)Q\r\u0007a\u0001M\"\"\u0001D\u001c?~Q\rA\u0012QA\u0001\u0011i\u0016\u001cH\u000f\u0016:b]N4WM\u001d$s_6$2!YA?\u0011\u0015)\u0017\u00041\u0001gQ\u0011Ib\u000e`?)\u0007e\t)!A\u0012uKN$HK]1og\u001a,'\u000fV8XSRD\u0007k\\:ji&|gNR8s)\u0006\u0014x-\u001a;\u0015\u0007\u0005\f9\tC\u0003f5\u0001\u0007a\r\u000b\u0003\u001b]rl\bf\u0001\u000e\u0002\u0006\u0005)B/Z:u%\u0016\u0004X-\u0019;fI6KwM]1uKR{G#A1)\u0007m\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI\n^\u0001\u0004CBL\u0017\u0002BAO\u0003/\u0013A\u0001V3ti\u0006\tC/Z:u\u001b&<'/\u0019;f\rJ|WNT8o\u0007\",7m[:v[R{\u0017\t\u001a7fe\"\u001aA$a%\u0002CQ,7\u000f^'jOJ\fG/\u001a$s_6\fE\r\\3s)>tuN\\\"iK\u000e\\7/^7)\u0007u\t\u0019*\u0001\buKN$8+\u001e9fe\ncwnY6\u0015\u0007\u0005\fY\u000bC\u0003f=\u0001\u0007a\rK\u0003\u001f]r\f)\u0002K\u0002\u001f\u0003\u000b\t\u0011#\u001b8wC2LGm\u00149f]\"+G\u000e]3s)\u0015\t\u0017QWAc\u0011\u001d\t9l\ba\u0001\u0003s\u000b\u0011\"\u00197h_JLG\u000f[7\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0,\u0003!\u0019\u0007.Z2lgVl\u0017\u0002BAb\u0003{\u0013\u0011\"\u00117h_JLG\u000f[7\t\u000f\u0005\u001dw\u00041\u0001\u0002J\u0006\u00012/\u001e9fe\ncwnY6MK:<G\u000f\u001b\t\u0004e\u0005-\u0017bAAgg\t)1\u000b[8si\u0006yA/Z:u\u0013:4\u0018\r\\5e\u001fB,g\u000eK\u0002!\u0003'\u000b\u0001\u0002^3ti>\u0003XM\u001c\u000b\u0004C\u0006]\u0007\"B3\"\u0001\u00041\u0007&B\u0011oy\u0006U\u0001fA\u0011\u0002\u0006\u0005qA/Z:u\u001fB,g\u000eR5sK\u000e$HcA1\u0002b\")QM\ta\u0001M\"*!E\u001c?\u0002\u0016!\u001a!%!\u0002\u0002-Q,7\u000f^%om\u0006d\u0017\u000eZ'jOJ\fG/\u001a$jY\u0016D3aIAJ\u0003]!Xm\u001d;Nk2$\u0018\u000e\u001d7f\r>\u0014X.\u0019;GS2,7\u000fK\u0002%\u0003'\u000b!%\u001b8wC2LGMR5mK\u000eC\u0017M\u001c8fY>\u0003XM]1uS>t7\u000fS3ma\u0016\u0014H#B1\u0002t\u0006U\bbBA\\K\u0001\u0007\u0011\u0011\u0018\u0005\b\u0003\u000f,\u0003\u0019AAe\u0003\u0001\"Xm\u001d;J]Z\fG.\u001b3GS2,7\t[1o]\u0016dw\n]3sCRLwN\\:)\u0007\u0019\n\u0019*A\twKJLg-\u001f$jY\u0016\u001cuN\u001c;f]R$r!YA\u0000\u0005/\u0011\t\u0003C\u0004\u0003\u0002\u001d\u0002\rAa\u0001\u0002\u0011\u0015D\b/Z2uK\u0012\u0004BA!\u0002\u0003\u00149!!q\u0001B\b!\r\u0011IaM\u0007\u0003\u0005\u0017Q1A!\u00040\u0003\u0019a$o\\8u}%\u0019!\u0011C\u001a\u0002\rA\u0013X\rZ3g\u0013\r!%Q\u0003\u0006\u0004\u0005#\u0019\u0004b\u0002B\rO\u0001\u0007!1D\u0001\u0007M&dW-S(\u0011\t\u0005m&QD\u0005\u0005\u0005?\tiLA\u0007DQ\u0016\u001c7.\u001a3GS2,\u0017j\u0014\u0005\b\u0005G9\u0003\u0019\u0001B\u0013\u00031!wNV1mS\u0012\fG/[8o!\r\u0011$qE\u0005\u0004\u0005S\u0019$a\u0002\"p_2,\u0017M\\\u0001\rm\u0016\u0014\u0018NZ=IK\u0006$WM\u001d\u000b\nC\n=\"1\tB#\u0005\u000fBqA!\r)\u0001\u0004\u0011\u0019$\u0001\u0003qCRD\u0007\u0003\u0002B\u001b\u0005\u007fi!Aa\u000e\u000b\t\te\"1H\u0001\u0005M&dWMC\u0002\u0003>\u0005\u000b1A\\5p\u0013\u0011\u0011\tEa\u000e\u0003\tA\u000bG\u000f\u001b\u0005\b\u0005\u0003A\u0003\u0019\u0001B\u0002\u0011\u001d\t9\r\u000ba\u0001\u0003\u0013DqAa\t)\u0001\u0004\u0011)#A\u0003{KJ|7\u000f\u0006\u0003\u0003\u0004\t5\u0003B\u0002B(S\u0001\u0007\u0011,A\u0001o\u0001")
public class CheckedFileIOTest {
    private final String testStr1;
    private final String testStr2;
    private final String testStr3;
    private final FlatBufferBuilder testHeader = new FlatBufferBuilder().forceDefaults(true);
    private final int testHeaderId = CheckedFileIOHeader.createCheckedFileIOHeader((FlatBufferBuilder)this.testHeader(), (byte)1, (long)1L, (long)0L);
    private final int expectedHeaderSize;

    private String testStr1() {
        return this.testStr1;
    }

    private String testStr2() {
        return this.testStr2;
    }

    private String testStr3() {
        return this.testStr3;
    }

    private FlatBufferBuilder testHeader() {
        return this.testHeader;
    }

    private int testHeaderId() {
        return this.testHeaderId;
    }

    private int expectedHeaderSize() {
        return this.expectedHeaderSize;
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testCreate(TestArguments.Args args) {
        Path path = File.createTempFile("testCreate", args.algorithm().suffix).toPath();
        Assertions.assertThrows(FileAlreadyExistsException.class, () -> CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength()));
        Files.delete(path);
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Assertions.assertThrows(FileAlreadyExistsException.class, () -> CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength()));
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testHeaderChecksum(TestArguments.Args args) {
        CheckedFileIO checkedFileIO;
        String expectedStr = "";
        String prvExpectedStr = "";
        Path adlerPath = new File(new StringBuilder(10).append("testHeader").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)adlerPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO2 = checkedFileIO = CheckedFileIO.open((Path)adlerPath, (boolean)false, (OpenOption[])open_options);
        Object var6_5 = null;
        checkedFileIO = null;
        CheckedFileIO cfIO = checkedFileIO2;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), 0L);
        expectedStr = new StringBuilder(0).append(expectedStr).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.flush();
        prvExpectedStr = expectedStr;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), 0L);
        expectedStr = new StringBuilder(0).append(this.testStr2()).append(this.testStr3().substring(this.testStr2().length())).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.flush();
        prvExpectedStr = expectedStr;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), (long)this.testStr2().length());
        expectedStr = new StringBuilder(0).append(this.testStr2()).append(this.testStr1()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.flush();
        prvExpectedStr = expectedStr;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(adlerPath, prvExpectedStr, args.superBlockLength(), args.doValidation());
        cfIO.close();
        Files.delete(adlerPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testWriteWithInterleavedByteBuffer(TestArguments.Args args) {
        CheckedFileIO checkedFileIO;
        Path path = new File(new StringBuilder(34).append("testWriteWithInterleavedByteBuffer").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO2 = checkedFileIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        Object var5_3 = null;
        checkedFileIO = null;
        CheckedFileIO cfIO = checkedFileIO2;
        String expectedStr = this.testStr2();
        cfIO.write(CheckedFileIOTest.toInterleavedByteBuffer$1(this.testStr2()), 0L);
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTest.toInterleavedByteBuffer$1(this.testStr1()), 1L);
        expectedStr = new StringBuilder(0).append(this.testStr2().substring(0, 1)).append(this.testStr1()).append(this.testStr2().substring(1 + this.testStr1().length())).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTest.toInterleavedByteBuffer$1(this.testStr3()), 1L);
        expectedStr = new StringBuilder(0).append(this.testStr2().substring(0, 1)).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testWriteWithPosition(TestArguments.Args args) {
        CheckedFileIO checkedFileIO;
        Path path = new File(new StringBuilder(21).append("testWriteWithPosition").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO2 = checkedFileIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        Object var6_3 = null;
        checkedFileIO = null;
        CheckedFileIO cfIO = checkedFileIO2;
        this.testStr1();
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        String expectedStr = this.testStr1();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)this.testStr1().length());
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr2()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), (long)this.testStr1().length());
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)this.testStr1().length());
        expectedStr = new StringBuilder(1).append(this.testStr1()).append(this.testStr2()).append("3").toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), (long)(this.testStr1().length() + this.testStr3().length() + 5));
        expectedStr = new StringBuilder(1).append(this.testStr1()).append(this.testStr2()).append("3").append(this.zeros(5)).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        String randomStr = RandomStringUtils.randomAscii((int)100000);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(randomStr), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(randomStr).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testWrite(TestArguments.Args args) {
        CheckedFileIO checkedFileIO;
        Path path = new File(new StringBuilder(9).append("testWrite").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO2 = checkedFileIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        Object var6_3 = null;
        checkedFileIO = null;
        CheckedFileIO cfIO = checkedFileIO2;
        this.testStr1();
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()));
        String expectedStr = this.testStr1();
        Assertions.assertEquals((long)expectedStr.length(), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr2()).toString();
        Assertions.assertEquals((long)expectedStr.length(), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.position((long)this.testStr1().length());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()));
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr3()).toString();
        Assertions.assertEquals((long)expectedStr.length(), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.position((long)this.testStr1().length());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        expectedStr = new StringBuilder(1).append(this.testStr1()).append(this.testStr2()).append("3").toString();
        Assertions.assertEquals((long)(this.testStr1().length() + this.testStr2().length()), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.position((long)(this.testStr1().length() + this.testStr3().length() + 5));
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()));
        expectedStr = new StringBuilder(1).append(this.testStr1()).append(this.testStr2()).append("3").append(this.zeros(5)).append(this.testStr3()).toString();
        Assertions.assertEquals((long)expectedStr.length(), (long)cfIO.position());
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        String randomStr = RandomStringUtils.randomAscii((int)100000);
        cfIO.position((long)expectedStr.length());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(randomStr), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(randomStr).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testReOpen(TestArguments.Args args) {
        CheckedFileIO checkedFileIO;
        void openOrCreate_options;
        void openOrCreate_superBlockLength;
        CheckedFileIO checkedFileIO2;
        Path path = new File(new StringBuilder(10).append("testReOpen").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        String expectedStr = this.testStr1();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(path, "", args.superBlockLength(), args.doValidation());
        cfIO.close();
        this.verifyHeader(path, expectedStr, args.superBlockLength(), args.doValidation());
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        short s = args.superBlockLength();
        Algorithm openOrCreate_algo = args.algorithm();
        CheckedFileIO checkedFileIO3 = checkedFileIO2 = CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        Object var6_8 = null;
        openOptionArray = null;
        checkedFileIO2 = null;
        cfIO = checkedFileIO3;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO4 = checkedFileIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options2);
        Object var10_10 = null;
        checkedFileIO = null;
        cfIO = checkedFileIO4;
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)this.testStr1().length());
        expectedStr = new StringBuilder(0).append(this.testStr1()).append(this.testStr2()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        this.verifyHeader(path, this.testStr1(), args.superBlockLength(), args.doValidation());
        cfIO.flush();
        this.verifyHeader(path, expectedStr, args.superBlockLength(), args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testForceModifyFileToFailOpen(TestArguments.Args args) {
        Path adlerPath = new File(new StringBuilder(33).append("testForceModifyFileToFailChecksum").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)adlerPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)adlerPath, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.close();
        FileChannel fc = FileChannel.open(adlerPath, StandardOpenOption.WRITE);
        Utils.writeFully((FileChannel)fc, (long)fc.size(), (ByteBuffer)CheckedFileIOTestUtils$.MODULE$.toByteBuffer("extra"));
        fc.close();
        Assertions.assertTrue((boolean)((IOException)Assertions.assertThrows(IOException.class, () -> {
            void openOrCreate_options;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            short openOrCreate_superBlockLength = args.superBlockLength();
            Algorithm openOrCreate_algo = args.algorithm();
            CheckedFileIO.openOrCreate((Path)adlerPath, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        })).getMessage().contains("File couldn't be opened because file sz has changed to"));
        Files.delete(adlerPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testForceModifyFileToFailValidate(TestArguments.Args args) {
        Path adlerPath = new File(new StringBuilder(33).append("testForceModifyFileToFailValidate").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)adlerPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)adlerPath, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), 0L);
        this.verifyFileContent(this.testStr2(), cfIO, args.doValidation());
        cfIO.close();
        FileChannel fc = FileChannel.open(adlerPath, StandardOpenOption.WRITE);
        Utils.writeFully((FileChannel)fc, (long)args.superBlockLength(), (ByteBuffer)CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()));
        fc.close();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ};
        Object var6_6 = null;
        cfIO = CheckedFileIO.open((Path)adlerPath, (boolean)false, (OpenOption[])open_options2);
        Assertions.assertFalse((boolean)cfIO.validate());
        cfIO.close();
        Files.delete(adlerPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTruncate(TestArguments.Args args) {
        Path path = new File(new StringBuilder(12).append("testTruncate").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var4_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.truncate(0L);
        this.verifyFileContent("", cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.truncate(0L);
        this.verifyFileContent("", cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), 0L);
        this.verifyFileContent(this.testStr2(), cfIO, args.doValidation());
        cfIO.truncate(5L);
        this.verifyFileContent(this.testStr2().substring(0, 5), cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), 5L);
        this.verifyFileContent(new StringBuilder(0).append(this.testStr2().substring(0, 5)).append(this.testStr3()).toString(), cfIO, args.doValidation());
        cfIO.truncate(100L);
        this.verifyFileContent(new StringBuilder(0).append(this.testStr2().substring(0, 5)).append(this.testStr3()).toString(), cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTruncateWithPosition(TestArguments.Args args) {
        Path path = new File(new StringBuilder(24).append("testTruncateWithPosition").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var4_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.position(3L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.truncate(5L);
        Assertions.assertEquals((long)3L, (long)cfIO.position());
        this.verifyFileContent(this.testStr1().substring(0, 5), cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTransferTo(TestArguments.Args args) {
        CheckedFileIO checkedFileIO;
        CheckedFileIO checkedFileIO2;
        Path srcPath = new File(new StringBuilder(18).append("testTransferTo-src").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO3 = checkedFileIO2 = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Object var6_3 = null;
        checkedFileIO2 = null;
        CheckedFileIO cfIO = checkedFileIO3;
        Path destPath = new File(new StringBuilder(19).append("testTransferTo-dest").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO4 = checkedFileIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        Object var8_7 = null;
        checkedFileIO = null;
        CheckedFileIO dstIO = checkedFileIO4;
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent("", dstIO, args.doValidation());
        cfIO.transferTo(0L, (long)this.testStr1().length(), dstIO);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent(this.testStr1(), dstIO, args.doValidation());
        dstIO.truncate(0L);
        cfIO.transferTo(3L, (long)(this.testStr1().length() - 3), dstIO);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent(this.testStr1().substring(3), dstIO, args.doValidation());
        cfIO.transferTo((long)this.testStr1().length(), 100L, dstIO);
        this.verifyFileContent(this.testStr1().substring(3), dstIO, args.doValidation());
        cfIO.close();
        dstIO.close();
        Files.delete(srcPath);
        Files.delete(destPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTransferFrom(TestArguments.Args args) {
        CheckedFileIO checkedFileIO;
        Path srcPath = new File(new StringBuilder(20).append("testTransferFrom-src").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO2 = checkedFileIO = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Object var6_3 = null;
        checkedFileIO = null;
        CheckedFileIO cfIO = checkedFileIO2;
        Path destPath = new File(new StringBuilder(21).append("testTransferFrom-dest").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var8_7 = null;
        ObjectRef dstIO = ObjectRef.create((Object)CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2));
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent("", (CheckedFileIO)dstIO.elem, args.doValidation());
        ((CheckedFileIO)dstIO.elem).transferFrom(cfIO, 0L, (long)this.testStr1().length());
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent(this.testStr1(), (CheckedFileIO)dstIO.elem, args.doValidation());
        ((CheckedFileIO)dstIO.elem).truncate(0L);
        ((CheckedFileIO)dstIO.elem).transferFrom(cfIO, 3L, (long)(this.testStr1().length() - 3));
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        this.verifyFileContent(this.testStr1().substring(3), (CheckedFileIO)dstIO.elem, args.doValidation());
        ((CheckedFileIO)dstIO.elem).close();
        OpenOption[] open_options3 = new OpenOption[]{StandardOpenOption.READ};
        Object var9_9 = null;
        dstIO.elem = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options3);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CheckedFileIO)dstIO$1.elem).transferFrom(cfIO, 0L, (long)this.testStr1().length()))).getMessage().contains("Cannot transfer from as file is read-only"));
        cfIO.close();
        ((CheckedFileIO)dstIO.elem).close();
        Files.delete(srcPath);
        Files.delete(destPath);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidArgumentsProvider.class)
    public void testTransferToWithPositionForTarget(TestArguments.Args args) {
        CheckedFileIO checkedFileIO;
        CheckedFileIO checkedFileIO2;
        Path srcPath = new File(new StringBuilder(30).append("testTransferToWithPosition-src").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO3 = checkedFileIO2 = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Object var6_3 = null;
        checkedFileIO2 = null;
        CheckedFileIO cfIO = checkedFileIO3;
        Path destPath = new File(new StringBuilder(31).append("testTransferToWithPosition-dest").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO4 = checkedFileIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        Object var8_7 = null;
        checkedFileIO = null;
        CheckedFileIO dstIO = checkedFileIO4;
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        dstIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        this.verifyFileContent(this.testStr2(), dstIO, args.doValidation());
        cfIO.transferTo(0L, (long)this.testStr1().length(), dstIO);
        this.verifyFileContent(new StringBuilder(0).append(this.testStr2()).append(this.testStr1()).toString(), dstIO, args.doValidation());
        cfIO.close();
        dstIO.close();
        Files.delete(srcPath);
        Files.delete(destPath);
    }

    @Test
    public void testRepeatedMigrateTo() {
        CheckedFileIO checkedFileIO;
        CheckedFileIO checkedFileIO2;
        Algorithm srcAlgorithm = Algorithm.ADLER;
        short srcSuperBlockLength = 4096;
        Path srcPath = new File(new StringBuilder(25).append("testRepeatedMigrateTo-src").append(srcAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)srcAlgorithm, (short)srcSuperBlockLength);
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var14_4 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        String expectedStr = this.testStr1();
        this.verifyFileContent(expectedStr, cfIO, true);
        cfIO.close();
        Algorithm destAlgorithm = Algorithm.NO_CHECKSUM;
        short destSuperBlockLength = 0;
        Path destPath = new File(new StringBuilder(26).append("testRepeatedMigrateTo-dest").append(destAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)destSuperBlockLength);
        Assertions.assertFalse((boolean)Files.exists(srcPath, new LinkOption[0]));
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO3 = checkedFileIO2 = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        Object var15_10 = null;
        checkedFileIO2 = null;
        cfIO = checkedFileIO3;
        this.verifyFileContent(expectedStr, cfIO, false);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(this.testStr2()).toString();
        this.verifyFileContent(expectedStr, cfIO, false);
        cfIO.close();
        Path newSrcPath = new File(new StringBuilder(28).append("testRepeatedMigrateTo-srcNew").append(srcAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.migrateFile((Path)destPath, (Path)newSrcPath, (short)srcSuperBlockLength);
        Assertions.assertFalse((boolean)Files.exists(destPath, new LinkOption[0]));
        Path tmpPath = new File(new StringBuilder(17).append("CheckedFileIO.tmp").append(srcAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)tmpPath, (Algorithm)srcAlgorithm, (short)srcSuperBlockLength);
        OpenOption[] open_options3 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var17_14 = null;
        CheckedFileIO tmpIO = CheckedFileIO.open((Path)tmpPath, (boolean)false, (OpenOption[])open_options3);
        tmpIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()));
        Path anotherSrcPath = new File(new StringBuilder(32).append("testRepeatedMigrateTo-srcAnother").append(srcAlgorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)anotherSrcPath, (Algorithm)srcAlgorithm, (short)srcSuperBlockLength);
        OpenOption[] open_options4 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var18_17 = null;
        CheckedFileIO srcAnotherIO = CheckedFileIO.open((Path)anotherSrcPath, (boolean)false, (OpenOption[])open_options4);
        srcAnotherIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        OpenOption[] open_options5 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO4 = checkedFileIO = CheckedFileIO.open((Path)newSrcPath, (boolean)false, (OpenOption[])open_options5);
        Object var19_19 = null;
        checkedFileIO = null;
        cfIO = checkedFileIO4;
        this.verifyFileContent(expectedStr, cfIO, true);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr3()), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(this.testStr3()).toString();
        this.verifyFileContent(expectedStr, cfIO, true);
        this.verifyFileContent(this.testStr3(), tmpIO, true);
        this.verifyFileContent(this.testStr2(), srcAnotherIO, true);
        cfIO.close();
        tmpIO.close();
        srcAnotherIO.close();
        Files.delete(anotherSrcPath);
        Files.delete(tmpPath);
        Files.delete(newSrcPath);
    }

    @Test
    public void testMigrateFromNonChecksumToAdler() {
        ((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", this.testStr1(), RandomStringUtils.randomAscii((int)4096), RandomStringUtils.randomAscii((int)0xA00000)}))).foreach((Function1 & Serializable)str -> {
            CheckedFileIOTest.$anonfun$testMigrateFromNonChecksumToAdler$1(this, str);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMigrateFromAdlerToNonChecksum() {
        ((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", this.testStr1(), RandomStringUtils.randomAscii((int)4096), RandomStringUtils.randomAscii((int)0xA00000)}))).foreach((Function1 & Serializable)str -> {
            CheckedFileIOTest.$anonfun$testMigrateFromAdlerToNonChecksum$1(this, str);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testSuperBlock(TestArguments.Args args) {
        void openOrCreate_options;
        void openOrCreate_superBlockLength;
        CheckedFileIO checkedFileIO;
        Path path = new File(new StringBuilder(14).append("testSuperBlock").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        String expectedStr = this.testStr1();
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.close();
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        short s = args.superBlockLength();
        Algorithm openOrCreate_algo = Algorithm.ADLER;
        CheckedFileIO checkedFileIO2 = checkedFileIO = CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        Object var6_8 = null;
        openOptionArray = null;
        checkedFileIO = null;
        cfIO = checkedFileIO2;
        this.verifyFileContent(this.testStr1(), cfIO, args.doValidation());
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)expectedStr.length());
        expectedStr = new StringBuilder(0).append(expectedStr).append(this.testStr2()).toString();
        this.verifyFileContent(expectedStr, cfIO, args.doValidation());
        cfIO.close();
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            void openOrCreate_options;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            short openOrCreate_superBlockLength = (short)4000;
            Algorithm openOrCreate_algo = Algorithm.ADLER;
            CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        })).getMessage().contains("Incorrect superBlockLength"));
        Files.delete(path);
    }

    private void invalidOpenHelper(Algorithm algorithm, short superBlockLength) {
        Path path = new File(new StringBuilder(15).append("testInvalidOpen").append(algorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        ObjectRef otherAlgorithm = ObjectRef.create(null);
        if (algorithm.equals(Algorithm.ADLER)) {
            otherAlgorithm.elem = Algorithm.NO_CHECKSUM;
        } else {
            Algorithm algorithm2 = algorithm;
            Algorithm algorithm3 = Algorithm.NO_CHECKSUM;
            if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
                otherAlgorithm.elem = Algorithm.ADLER;
            }
        }
        Assertions.assertTrue((boolean)((OtherChecksumTypeException)Assertions.assertThrows(OtherChecksumTypeException.class, () -> {
            void openOrCreate_options;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            Algorithm openOrCreate_algo = (Algorithm)otherAlgorithm$1.elem;
            CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        })).getMessage().contains("file exists"));
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.openOrCreate((Path)path, (Algorithm)algorithm, (short)superBlockLength, (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE}))).getMessage().contains("options missing READ and WRITE"));
        Files.delete(path);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            OpenOption[] openOrCreate_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            CheckedFileIO.openOrCreate((Path)path, (Algorithm)algorithm, (short)superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        })).getMessage().contains("CREATE or CREATE_NEW option is missing"));
    }

    @Test
    public void testInvalidOpen() {
        this.invalidOpenHelper(Algorithm.ADLER, (short)600);
        this.invalidOpenHelper(Algorithm.ADLER, (short)4096);
        this.invalidOpenHelper(Algorithm.NO_CHECKSUM, (short)0);
        Path adlerPath = new File(new StringBuilder(24).append("testInvalidOpenWithAdler").append(Algorithm.ADLER.suffix).toString()).toPath();
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.create((Path)adlerPath, (Algorithm)Algorithm.ADLER, (short)((short)5000)))).getMessage().contains("Incorrect super block length argument for algorithm"));
        Path noChecksumPath = new File(new StringBuilder(29).append("testInvalidOpenWithNoChecksum").append(Algorithm.NO_CHECKSUM.suffix).toString()).toPath();
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.create((Path)noChecksumPath, (Algorithm)Algorithm.NO_CHECKSUM, (short)((short)10)))).getMessage().contains("Incorrect super block length argument for algorithm"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testOpen(TestArguments.Args args) {
        void openOrCreate_options;
        void openOrCreate_superBlockLength;
        Path path = new File(new StringBuilder(8).append("testOpen").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var4_3 = null;
        ObjectRef cfIO = ObjectRef.create((Object)CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options));
        ((CheckedFileIO)cfIO.elem).write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L);
        this.verifyFileContent(this.testStr1(), (CheckedFileIO)cfIO.elem, args.doValidation());
        ((CheckedFileIO)cfIO.elem).close();
        Files.delete(path);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE};
        short s = args.superBlockLength();
        Algorithm openOrCreate_algo = args.algorithm();
        Object var5_7 = null;
        openOptionArray = null;
        cfIO.elem = CheckedFileIO.openOrCreate((Path)path, (Algorithm)openOrCreate_algo, (short)openOrCreate_superBlockLength, (boolean)false, (OpenOption[])openOrCreate_options);
        ((CheckedFileIO)cfIO.elem).write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), 0L);
        this.verifyFileContent(this.testStr2(), (CheckedFileIO)cfIO.elem, args.doValidation());
        ((CheckedFileIO)cfIO.elem).close();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ};
        Object var8_8 = null;
        cfIO.elem = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options2);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CheckedFileIO)cfIO$2.elem).write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1())))).getMessage().contains("Cannot write as file is read-only"));
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CheckedFileIO)cfIO$2.elem).write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), 0L))).getMessage().contains("Cannot write as file is read-only"));
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((CheckedFileIO)cfIO$2.elem).flush())).getMessage().contains("Cannot flush as file is read-only"));
        ((CheckedFileIO)cfIO.elem).close();
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            OpenOption[] open_options = new OpenOption[]{StandardOpenOption.WRITE};
            CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        })).getMessage().contains("options has WRITE but missing READ"));
        Files.delete(path);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TestArguments.ValidAdlerArgumentsProvider.class)
    public void testOpenDirect(TestArguments.Args args) {
        Path path = new File(new StringBuilder(14).append("testOpenDirect").append(args.algorithm().suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)args.algorithm(), (short)args.superBlockLength());
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var4_3 = null;
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()));
        cfIO.close();
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        Object var5_5 = null;
        cfIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options2);
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()), (long)this.testStr1().length());
        this.verifyFileContent(new StringBuilder(0).append(this.testStr1()).append(this.testStr2()).toString(), cfIO, args.doValidation());
        cfIO.close();
        Files.delete(path);
    }

    @Test
    public void testInvalidMigrateFile() {
        Algorithm srcAlgo = Algorithm.NO_CHECKSUM;
        short srcSuperBlockLength = 0;
        Path srcPath = new File(new StringBuilder(26).append("testInvalidMigrateFile-src").append(srcAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)srcAlgo, (short)srcSuperBlockLength);
        Algorithm destAlgo = Algorithm.ADLER;
        short destSuperBlockLength = 4096;
        Path destPath = new File(new StringBuilder(27).append("testInvalidMigrateFile-dest").append(destAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath, (Algorithm)destAlgo, (short)destSuperBlockLength);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)destSuperBlockLength))).getMessage().contains("Destination file path is present in migrate"));
        Files.delete(destPath);
        Path destPath2 = new File(new StringBuilder(28).append("testInvalidMigrateFile-dest2").append(destAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)destPath2, (Algorithm)destAlgo, (short)destSuperBlockLength);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.migrateFile((Path)destPath2, (Path)destPath, (short)destSuperBlockLength))).getMessage().contains("Source and destination algorithm are same for migrate"));
        Files.delete(destPath2);
        Files.delete(srcPath);
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)4096))).getMessage().contains("Source input file path is not present in migrate"));
    }

    @Test
    public void testMultipleFormatFiles() {
        Algorithm algo1 = Algorithm.NO_CHECKSUM;
        short superBlockLength1 = 0;
        Path path1 = new File(new StringBuilder(23).append("testMultipleFormatFiles").append(algo1.suffix).toString()).toPath();
        Algorithm algo2 = Algorithm.ADLER;
        short superBlockLength2 = 4096;
        Path path2 = new File(new StringBuilder(23).append("testMultipleFormatFiles").append(algo2.suffix).toString()).toPath();
        CheckedFileIO.create((Path)path2, (Algorithm)algo2, (short)superBlockLength2);
        CheckedFileIO cfIO = CheckedFileIO.open((Path)path2, (boolean)false, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr2()));
        cfIO.close();
        CheckedFileIO.create((Path)path1, (Algorithm)algo1, (short)superBlockLength1);
        Assertions.assertTrue((boolean)((MultiChecksumTypeException)Assertions.assertThrows(MultiChecksumTypeException.class, () -> {
            OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            CheckedFileIO.open((Path)path1, (boolean)false, (OpenOption[])open_options);
        })).getMessage().contains("Both non-checksum file"));
        Assertions.assertTrue((boolean)((MultiChecksumTypeException)Assertions.assertThrows(MultiChecksumTypeException.class, () -> {
            OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            CheckedFileIO.open((Path)path2, (boolean)false, (OpenOption[])open_options);
        })).getMessage().contains("Both non-checksum file"));
        cfIO = CheckedFileIO.open((Path)path1, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()));
        this.verifyFileContent(this.testStr1(), cfIO, false);
        cfIO.close();
        cfIO = CheckedFileIO.open((Path)path2, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        this.verifyFileContent(this.testStr2(), cfIO, true);
        cfIO.close();
        Files.delete(path1);
        Files.delete(path2);
    }

    private void invalidFileChannelOperationsHelper(Algorithm algorithm, short superBlockLength) {
        CheckedFileIO checkedFileIO;
        Path path = new File(new StringBuilder(38).append("testInvalidFileChannelOperationsHelper").append(algorithm.suffix).toString()).toPath();
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO2 = checkedFileIO = CheckedFileIO.open((Path)path, (boolean)false, (OpenOption[])open_options);
        Object var10_4 = null;
        checkedFileIO = null;
        CheckedFileIO cfIO = checkedFileIO2;
        IllegalArgumentException ex1 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cfIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(this.testStr1()), -1L));
        if (algorithm.equals(Algorithm.ADLER)) {
            Assertions.assertTrue((boolean)ex1.getMessage().contains("Cannot write as position"));
        }
        IllegalArgumentException ex2 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cfIO.position(-1L));
        Algorithm algorithm2 = algorithm;
        Algorithm algorithm3 = Algorithm.ADLER;
        if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
            Assertions.assertTrue((boolean)ex2.getMessage().contains("Cannot set as position"));
        }
        IllegalArgumentException ex3 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> cfIO.truncate(-1L));
        Algorithm algorithm4 = algorithm;
        Algorithm algorithm5 = Algorithm.ADLER;
        if (!(algorithm4 != null ? !algorithm4.equals(algorithm5) : algorithm5 != null)) {
            Assertions.assertTrue((boolean)ex3.getMessage().contains("Cannot truncate as size"));
        }
        Files.delete(path);
    }

    @Test
    public void testInvalidFileChannelOperations() {
        this.invalidFileChannelOperationsHelper(Algorithm.ADLER, (short)500);
        this.invalidFileChannelOperationsHelper(Algorithm.ADLER, (short)4096);
        this.invalidFileChannelOperationsHelper(Algorithm.NO_CHECKSUM, (short)0);
    }

    private void verifyFileContent(String expected, CheckedFileIO fileIO, boolean doValidation) {
        Assertions.assertTrue((boolean)fileIO.validate());
        if (doValidation) {
            Assertions.assertEquals((long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expected), (Long)((Long)fileIO.checksum().get()));
        }
        Assertions.assertEquals((long)expected.length(), (long)fileIO.size());
        ByteBuffer bb = ByteBuffer.allocate(expected.length()).order(ByteOrder.LITTLE_ENDIAN);
        fileIO.read(bb, 0L);
        Assertions.assertEquals((Object)bb, (Object)CheckedFileIOTestUtils$.MODULE$.toByteBuffer(expected).flip());
    }

    private void verifyHeader(Path path, String expected, short superBlockLength, boolean doValidation) {
        if (!doValidation) {
            return;
        }
        RandomAccessFile inp = new RandomAccessFile(((Object)path).toString(), "r");
        FileChannel fc = inp.getChannel();
        ByteBuffer bb = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        Utils.readFully((FileChannel)fc, (ByteBuffer)bb, (long)0L);
        Assertions.assertFalse((boolean)bb.hasRemaining());
        bb.flip();
        Assertions.assertEquals((short)superBlockLength, (short)bb.getShort());
        Assertions.assertEquals((int)this.expectedHeaderSize(), (int)bb.getShort());
        bb = ByteBuffer.allocate(this.expectedHeaderSize()).order(ByteOrder.LITTLE_ENDIAN);
        Utils.readFully((FileChannel)fc, (ByteBuffer)bb, (long)4L);
        Assertions.assertFalse((boolean)bb.hasRemaining());
        bb.flip();
        inp.close();
        CheckedFileIOHeader header = CheckedFileIOHeader.getRootAsCheckedFileIOHeader((ByteBuffer)bb);
        Assertions.assertEquals((int)1, (int)header.version());
        Assertions.assertEquals((long)CheckedFileIOTestUtils$.MODULE$.computeChecksum(expected), (long)header.checksum());
        Assertions.assertEquals((long)expected.length(), (long)header.endPosition());
    }

    private String zeros(int n) {
        byte[] ar = new byte[n];
        Arrays.fill(ar, (byte)0);
        ByteBuffer bb = ByteBuffer.wrap(ar).order(ByteOrder.LITTLE_ENDIAN);
        return new String(bb.array(), "ASCII");
    }

    /*
     * WARNING - void declaration
     */
    private static final ByteBuffer toInterleavedByteBuffer$1(String s) {
        void var1_1;
        ByteBuffer bb = ByteBuffer.allocate(1000);
        String randomStr = "123";
        bb.put(randomStr.getBytes());
        bb.put(s.getBytes());
        bb.position(3);
        bb.limit(3 + s.length());
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$testMigrateFromNonChecksumToAdler$1(CheckedFileIOTest $this, String str) {
        CheckedFileIO checkedFileIO;
        CheckedFileIO checkedFileIO2;
        Algorithm srcAlgo = Algorithm.NO_CHECKSUM;
        short srcSuperBlockLength = 0;
        Path srcPath = new File(new StringBuilder(37).append("testMigrateFromNonChecksumToAdler-src").append(srcAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)srcAlgo, (short)srcSuperBlockLength);
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO3 = checkedFileIO2 = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Object var10_5 = null;
        checkedFileIO2 = null;
        CheckedFileIO srcIO = checkedFileIO3;
        Algorithm destAlgo = Algorithm.ADLER;
        short destSuperBlockLength = 4096;
        Path destPath = new File(new StringBuilder(38).append("testMigrateFromNonChecksumToAdler-dest").append(destAlgo.suffix).toString()).toPath();
        srcIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str));
        srcIO.close();
        CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)destSuperBlockLength);
        Assertions.assertFalse((boolean)Files.exists(srcPath, new LinkOption[0]));
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO4 = checkedFileIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        Object var12_11 = null;
        checkedFileIO = null;
        CheckedFileIO destIO = checkedFileIO4;
        $this.verifyFileContent(str, destIO, false);
        destIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer($this.testStr1()), (long)str.length());
        $this.verifyFileContent(new StringBuilder(0).append(str).append($this.testStr1()).toString(), destIO, false);
        destIO.close();
        Files.delete(destPath);
    }

    public static final /* synthetic */ void $anonfun$testMigrateFromAdlerToNonChecksum$1(CheckedFileIOTest $this, String str) {
        CheckedFileIO checkedFileIO;
        CheckedFileIO checkedFileIO2;
        Algorithm srcAlgo = Algorithm.ADLER;
        short srcSuperBlockLength = 4096;
        Path srcPath = new File(new StringBuilder(37).append("testMigrateFromAdlerToNonChecksum-src").append(srcAlgo.suffix).toString()).toPath();
        CheckedFileIO.create((Path)srcPath, (Algorithm)srcAlgo, (short)srcSuperBlockLength);
        OpenOption[] open_options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO3 = checkedFileIO2 = CheckedFileIO.open((Path)srcPath, (boolean)false, (OpenOption[])open_options);
        Object var10_5 = null;
        checkedFileIO2 = null;
        CheckedFileIO srcIO = checkedFileIO3;
        Algorithm destAlgo = Algorithm.NO_CHECKSUM;
        short destSuperBlockLength = 0;
        Path destPath = new File(new StringBuilder(38).append("testMigrateFromAdlerToNonChecksum-dest").append(destAlgo.suffix).toString()).toPath();
        srcIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer(str));
        srcIO.close();
        CheckedFileIO.migrateFile((Path)srcPath, (Path)destPath, (short)destSuperBlockLength);
        Assertions.assertFalse((boolean)Files.exists(srcPath, new LinkOption[0]));
        OpenOption[] open_options2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
        CheckedFileIO checkedFileIO4 = checkedFileIO = CheckedFileIO.open((Path)destPath, (boolean)false, (OpenOption[])open_options2);
        Object var12_11 = null;
        checkedFileIO = null;
        CheckedFileIO destIO = checkedFileIO4;
        $this.verifyFileContent(str, destIO, false);
        destIO.write(CheckedFileIOTestUtils$.MODULE$.toByteBuffer($this.testStr1()), destIO.size());
        $this.verifyFileContent(new StringBuilder(0).append(str).append($this.testStr1()).toString(), destIO, false);
        destIO.close();
        Files.delete(destPath);
    }

    public CheckedFileIOTest() {
        this.testStr1 = "str1ng1";
        this.testStr2 = "str2ng22";
        this.testStr3 = "str3ng333";
        this.testHeader().finish(this.testHeaderId());
        this.expectedHeaderSize = this.testHeader().dataBuffer().remaining();
    }
}

