/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.utils.ReplicationUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u001d4AAE\n\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB\u0016\u0001A\u0003%Q\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rY\u0002\u0001\u0015!\u0003/\u0011\u001d9\u0004A1A\u0005\n\u0011Ba\u0001\u000f\u0001!\u0002\u0013)\u0003bB\u001d\u0001\u0005\u0004%I\u0001\n\u0005\u0007u\u0001\u0001\u000b\u0011B\u0013\t\u000fm\u0002!\u0019!C\u0005I!1A\b\u0001Q\u0001\n\u0015Bq!\u0010\u0001C\u0002\u0013%A\u0005\u0003\u0004?\u0001\u0001\u0006I!\n\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u0019I\u0005\u0001)A\u0005\u0003\")!\n\u0001C!\u0017\")\u0011\r\u0001C\u0001E\n!\"+\u001a9mS\u000e\fG/[8o+RLGn\u001d+fgRT!\u0001F\u000b\u0002\u000bU$\u0018\u000e\\:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\u0011A$F\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005yY\"!E)v_J,X\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\t\t\u0003E\u0001i\u0011aE\u0001\nu.4VM]:j_:,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0004\u0013:$\u0018A\u0003>l-\u0016\u00148/[8oA\u0005)Ao\u001c9jGV\ta\u0006\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005!A.\u00198h\u0015\u0005\u0019\u0014\u0001\u00026bm\u0006L!!\u000e\u0019\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005I\u0001/\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00027fC\u0012,'/A\u0004mK\u0006$WM\u001d\u0011\u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\rY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eI\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\u0006\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eI\u0001\u0004SN\u0014X#A!\u0011\u0007\t;U%D\u0001D\u0015\t!U)A\u0005j[6,H/\u00192mK*\u0011aiJ\u0001\u000bG>dG.Z2uS>t\u0017B\u0001%D\u0005\u0011a\u0015n\u001d;\u0002\t%\u001c(\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0019>\u0003\"AJ'\n\u00059;#\u0001B+oSRDQ\u0001\u0015\tA\u0002E\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003%nk\u0011a\u0015\u0006\u0003)V\u000b1!\u00199j\u0015\t1v+A\u0004kkBLG/\u001a:\u000b\u0005aK\u0016!\u00026v]&$(\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002]'\nAA+Z:u\u0013:4w\u000e\u000b\u0002\u0011=B\u0011!kX\u0005\u0003AN\u0013!BQ3g_J,W)Y2i\u0003Y!Xm\u001d;Va\u0012\fG/\u001a'fC\u0012,'/\u00118e\u0013N\u0014H#\u0001')\u0005E!\u0007C\u0001*f\u0013\t17K\u0001\u0003UKN$\b")
public class ReplicationUtilsTest
extends QuorumTestHarness {
    private final int zkVersion;
    private final String topic;
    private final int partition;
    private final int leader;
    private final int leaderEpoch;
    private final int controllerEpoch;
    private final List<Object> isr = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));

    private int zkVersion() {
        return this.zkVersion;
    }

    private String topic() {
        return this.topic;
    }

    private int partition() {
        return this.partition;
    }

    private int leader() {
        return this.leader;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private List<Object> isr() {
        return this.isr;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.zkClient().makeSurePersistentPathExists(TopicZNode$.MODULE$.path(this.topic()));
        TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(this.leader(), this.leaderEpoch(), this.isr(), LeaderRecoveryState.RECOVERED, 1, (Option)None$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.zkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)leaderIsrAndControllerEpoch)})), ZkVersion$.MODULE$.MatchAnyVersion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateLeaderAndIsr() {
        void var17_17;
        void var16_16;
        void var13_13;
        void var12_12;
        void var9_9;
        void var8_8;
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog(new TopicPartition(this.topic(), this.partition()), false)).thenReturn((Object)new Some((Object)log));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.config()).thenReturn(configs.head());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaFetcherManager()).thenReturn(Mockito.mock(ReplicaFetcherManager.class));
        Mockito.when((Object)replicaManager.zkClient()).thenReturn((Object)new Some((Object)this.zkClient()));
        this.zkClient().makeSurePersistentPathExists("/isr_change_notification");
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        LeaderAndIsr newLeaderAndIsr1 = new LeaderAndIsr(this.leader(), this.leaderEpoch(), replicas, LeaderRecoveryState.RECOVERED, 0, (Option)None$.MODULE$);
        Tuple2 tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr1, this.controllerEpoch());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded1 = tuple2._1$mcZ$sp();
        int newZkVersion1 = tuple2._2$mcI$sp();
        Assertions.assertTrue((boolean)var8_8);
        Assertions.assertEquals((int)var9_9, (int)1);
        LeaderAndIsr newLeaderAndIsr2 = new LeaderAndIsr(this.leader(), this.leaderEpoch(), replicas, LeaderRecoveryState.RECOVERED, this.zkVersion() + 1, (Option)None$.MODULE$);
        Tuple2 tuple22 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr2, this.controllerEpoch());
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded2 = tuple22._1$mcZ$sp();
        int newZkVersion2 = tuple22._2$mcI$sp();
        Assertions.assertTrue((boolean)var12_12);
        Assertions.assertEquals((int)var13_13, (int)1);
        LeaderAndIsr newLeaderAndIsr3 = new LeaderAndIsr(this.leader(), this.leaderEpoch() + 1, replicas, LeaderRecoveryState.RECOVERED, this.zkVersion() + 1, (Option)None$.MODULE$);
        Tuple2 tuple23 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient(), new TopicPartition(this.topic(), this.partition()), newLeaderAndIsr3, this.controllerEpoch());
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded3 = tuple23._1$mcZ$sp();
        int newZkVersion3 = tuple23._2$mcI$sp();
        Assertions.assertFalse((boolean)var16_16);
        Assertions.assertEquals((int)var17_17, (int)-1);
    }

    public ReplicationUtilsTest() {
        this.zkVersion = 1;
        this.topic = "my-topic-test";
        this.partition = 0;
        this.leader = 1;
        this.leaderEpoch = 1;
        this.controllerEpoch = 1;
    }
}

