/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.TopicPartitionStateZNode$;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005I2Aa\u0002\u0005\u0003\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013!)a\u0006\u0001C\u00013!)\u0001\u0007\u0001C\u00013\taBk\u001c9jGB\u000b'\u000f^5uS>t7\u000b^1uKjsu\u000eZ3UKN$(BA\u0005\u000b\u0003\tQ8NC\u0001\f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0018\u00015\t\u0001\"\u0001\u000euKN$XI\\2pI\u0016$UmY8eKJ+7m\u001c<fe&tw\rF\u0001\u001b!\ty1$\u0003\u0002\u001d!\t!QK\\5uQ\t\u0011a\u0004\u0005\u0002 Q5\t\u0001E\u0003\u0002\"E\u0005\u0019\u0011\r]5\u000b\u0005\r\"\u0013a\u00026va&$XM\u001d\u0006\u0003K\u0019\nQA[;oSRT\u0011aJ\u0001\u0004_J<\u0017BA\u0015!\u0005\u0011!Vm\u001d;\u00023Q,7\u000f^#oG>$W\rR3d_\u0012,'+Z2pm\u0016\u0014X\r\u001a\u0015\u0003\u0007y\t!\u0003^3ti\u0012+7m\u001c3f\u001f2$g+\u00197vK\"\u0012AAH\u0001\"i\u0016\u001cH/\u00168dY\u0016\fg.\u00118e%\u0016\u001cwN^3sS:<\u0017j]#oG>$W\r\u001a\u0015\u0003\u000by\tA\u0003^3tiVs7\r\\3b]&\u001bXI\\2pI\u0016$\u0007F\u0001\u0004\u001f\u0001")
public final class TopicPartitionStateZNodeTest {
    @Test
    public void testEncodeDecodeRecovering() {
        int zkVersion = 5;
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stat.getVersion())).thenReturn((Object)BoxesRunTime.boxToInteger((int)zkVersion));
        LeaderIsrAndControllerEpoch expected = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, 6, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERING, zkVersion, (Option)None$.MODULE$), 10);
        Assertions.assertEquals((Object)new Some((Object)expected), (Object)TopicPartitionStateZNode$.MODULE$.decode(TopicPartitionStateZNode$.MODULE$.encode(expected), stat));
    }

    @Test
    public void testEncodeDecodeRecovered() {
        int zkVersion = 5;
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stat.getVersion())).thenReturn((Object)BoxesRunTime.boxToInteger((int)zkVersion));
        LeaderIsrAndControllerEpoch expected = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, 6, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, zkVersion, (Option)None$.MODULE$), 10);
        Assertions.assertEquals((Object)new Some((Object)expected), (Object)TopicPartitionStateZNode$.MODULE$.decode(TopicPartitionStateZNode$.MODULE$.encode(expected), stat));
    }

    @Test
    public void testDecodeOldValue() {
        int zkVersion = 5;
        Stat stat = (Stat)Mockito.mock(Stat.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stat.getVersion())).thenReturn((Object)BoxesRunTime.boxToInteger((int)zkVersion));
        LeaderIsrAndControllerEpoch expected = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, 6, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, zkVersion, (Option)None$.MODULE$), 10);
        scala.collection.immutable.Map partitionState = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)expected.leaderAndIsr().leader())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)expected.leaderAndIsr().leaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)expected.controllerEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expected.leaderAndIsr().isr()).asJava())}));
        Assertions.assertEquals((Object)new Some((Object)expected), (Object)TopicPartitionStateZNode$.MODULE$.decode(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionState).asJava()), stat));
    }

    @Test
    public void testUncleanAndRecoveringIsEncoded() {
        int zkVersion = 5;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)((Stat)Mockito.mock(Stat.class)).getVersion())).thenReturn((Object)BoxesRunTime.boxToInteger((int)zkVersion));
        LeaderIsrAndControllerEpoch expected = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, 6, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERING, zkVersion, (Option)None$.MODULE$), 10);
        JsonObject jsonValue = ((JsonValue)Json$.MODULE$.parseBytes(TopicPartitionStateZNode$.MODULE$.encode(expected)).get()).asJsonObject();
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)jsonValue.apply("confluent_is_unclean_leader").to((DecodeJson)DecodeJson.DecodeBoolean$.MODULE$)));
        Assertions.assertEquals((byte)LeaderRecoveryState.RECOVERING.value(), (byte)((byte)BoxesRunTime.unboxToInt((Object)jsonValue.apply("leader_recovery_state").to((DecodeJson)DecodeJson.DecodeInt$.MODULE$))));
    }

    @Test
    public void testUncleanIsEncoded() {
        int zkVersion = 5;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)((Stat)Mockito.mock(Stat.class)).getVersion())).thenReturn((Object)BoxesRunTime.boxToInteger((int)zkVersion));
        LeaderIsrAndControllerEpoch expected = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, 6, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, zkVersion, (Option)None$.MODULE$), 10);
        JsonObject jsonValue = ((JsonValue)Json$.MODULE$.parseBytes(TopicPartitionStateZNode$.MODULE$.encode(expected)).get()).asJsonObject();
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)jsonValue.apply("confluent_is_unclean_leader").to((DecodeJson)DecodeJson.DecodeBoolean$.MODULE$)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)jsonValue.get("leader_recovery_state"));
    }
}

