/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.availability;

import io.confluent.kafka.availability.NetworkAvailabilityManager;
import io.confluent.kafka.availability.NetworkAvailabilityManager$;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.DefaultChannelMetadataRegistry;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerCallbackHandler;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001\u0002\u0004\b\u00019AQ!\u0006\u0001\u0005\u0002YAQ!\u0007\u0001\u0005\u0002iAQa\u000b\u0001\u0005\u0002iAQ!\f\u0001\u0005\n9BQa\u0011\u0001\u0005\n\u0011\u0013AeU1tY\u0006+H\u000f[3oi&\u001c\u0017\r^8s\u0007>tg.Z2uS>t\u0007+\u001b8hgR+7\u000f\u001e\u0006\u0003\u0011%\tA\"\u0019<bS2\f'-\u001b7jifT!AC\u0006\u0002\u000b-\fgm[1\u000b\u00031\tA!\u001e8ji\u000e\u00011C\u0001\u0001\u0010!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011aB\u0001\u001di\u0016\u001cH\u000fT1uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0005Y\u0002C\u0001\t\u001d\u0013\ti\u0012C\u0001\u0003V]&$\bF\u0001\u0002 !\t\u0001\u0013&D\u0001\"\u0015\t\u00113%A\u0002ba&T!\u0001J\u0013\u0002\u000f),\b/\u001b;fe*\u0011aeJ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Q\u0005\u0019qN]4\n\u0005)\n#\u0001\u0002+fgR\fQ\u0005^3ti\u000e{gN\\3di&|g\u000eU5oON\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;)\u0005\ry\u0012A\u0006;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;\u0015\tmyC'\u0011\u0005\u0006a\u0011\u0001\r!M\u0001\bm\u0016\u00148/[8o!\t\u0001\"'\u0003\u00024#\t)1\u000b[8si\")Q\u0007\u0002a\u0001m\u0005!R\r\u001f9fGR,GmU8gi^\f'/\u001a(b[\u0016\u0004\"a\u000e \u000f\u0005ab\u0004CA\u001d\u0012\u001b\u0005Q$BA\u001e\u000e\u0003\u0019a$o\\8u}%\u0011Q(E\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>#!)!\t\u0002a\u0001m\u00059R\r\u001f9fGR,GmU8gi^\f'/\u001a,feNLwN\\\u0001\u0013g\u0016$X\u000f]!vi\",g\u000e^5dCR|'\u000fF\u0004F%\"\u0004(o\u001e?\u0011\u0005\u0019\u0003V\"A$\u000b\u0005!K\u0015!D1vi\",g\u000e^5dCR|'O\u0003\u0002K\u0017\u0006A1/Z2ve&$\u0018P\u0003\u0002M\u001b\u000611m\\7n_:T!A\u0003(\u000b\u0005=;\u0013AB1qC\u000eDW-\u0003\u0002R\u000f\n92+Y:m'\u0016\u0014h/\u001a:BkRDWM\u001c;jG\u0006$xN\u001d\u0005\u0006'\u0016\u0001\r\u0001V\u0001\bG>tg-[4ta\t)v\f\u0005\u0003W7ZjV\"A,\u000b\u0005aK\u0016\u0001B;uS2T\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n\u0019Q*\u00199\u0011\u0005y{F\u0002\u0001\u0003\nAJ\u000b\t\u0011!A\u0003\u0002\u0005\u00141a\u0018\u00132#\t\u0011W\r\u0005\u0002\u0011G&\u0011A-\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001b-\u0003\u0002h#\t\u0019\u0011I\\=\t\u000b%,\u0001\u0019\u00016\u0002\u001dQ\u0014\u0018M\\:q_J$H*Y=feB\u00111N\\\u0007\u0002Y*\u0011QnS\u0001\b]\u0016$xo\u001c:l\u0013\tyGN\u0001\bUe\u0006t7\u000f]8si2\u000b\u00170\u001a:\t\u000bE,\u0001\u0019\u0001\u001c\u0002\u00135,7\r[1oSNl\u0007\"B:\u0006\u0001\u0004!\u0018\u0001E7fi\u0006$\u0017\r^1SK\u001eL7\u000f\u001e:z!\tYW/\u0003\u0002wY\n92\t[1o]\u0016dW*\u001a;bI\u0006$\u0018MU3hSN$(/\u001f\u0005\u0006q\u0016\u0001\r!_\u0001\u0016SNLe\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s!\t\u0001\"0\u0003\u0002|#\t9!i\\8mK\u0006t\u0007\"B?\u0006\u0001\u0004q\u0018A\u00078fi^|'o[!wC&d\u0017MY5mSRLX*\u00198bO\u0016\u0014\bcA@\u0002\u000e5\u0011\u0011\u0011\u0001\u0006\u0004\u0011\u0005\r!b\u0001\u0006\u0002\u0006)!\u0011qAA\u0005\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0002\f\u0005\u0011\u0011n\\\u0005\u0005\u0003\u001f\t\tA\u0001\u000eOKR<xN]6Bm\u0006LG.\u00192jY&$\u00180T1oC\u001e,'\u000f")
public class SaslAuthenticatorConnectionPingsTest {
    @Test
    public void testLatestApiVersionsRequest() {
        this.testApiVersionsRequest(ApiKeys.API_VERSIONS.latestVersion(), "apache-kafka-java", AppInfoParser.getVersion());
    }

    @Test
    public void testConnectionPingsApiVersionsRequest() {
        this.testApiVersionsRequest(ApiKeys.API_VERSIONS.latestVersion(), NetworkAvailabilityManager$.MODULE$.CONNECTION_PINGS_CLIENT_SOFTWARE_NAME(), AppInfoParser.getVersion());
    }

    private void testApiVersionsRequest(short version, String expectedSoftwareName, String expectedSoftwareVersion) {
        String string = expectedSoftwareName;
        String string2 = NetworkAvailabilityManager$.MODULE$.CONNECTION_PINGS_CLIENT_SOFTWARE_NAME();
        boolean isConnectionPingsClient = !(string != null ? !string.equals(string2) : string2 != null);
        NetworkAvailabilityManager networkAvailabilityManager = new NetworkAvailabilityManager();
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        DefaultChannelMetadataRegistry metadataRegistry = new DefaultChannelMetadataRegistry();
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)metadataRegistry, false, networkAvailabilityManager);
        ByteBuffer headerBuffer = RequestTestUtils.serializeRequestHeader((RequestHeader)new RequestHeader(ApiKeys.API_VERSIONS, version, "clientId", 0));
        ByteBuffer requestBuffer = (isConnectionPingsClient ? new ApiVersionsRequest(new ApiVersionsRequestData().setClientSoftwareName(expectedSoftwareName).setClientSoftwareVersion(AppInfoParser.getVersion()), version) : new ApiVersionsRequest.Builder().build(version)).serialize();
        requestBuffer.rewind();
        Mockito.when((Object)transportLayer.socketChannel().socket().getInetAddress()).thenReturn((Object)InetAddress.getLoopbackAddress());
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class)))).then(invocation -> BoxesRunTime.boxToInteger((int)SaslAuthenticatorConnectionPingsTest.foo$1(invocation, headerBuffer, requestBuffer))).then(invocation -> BoxesRunTime.boxToInteger((int)SaslAuthenticatorConnectionPingsTest.foo$2(invocation, headerBuffer, requestBuffer)));
        Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.connectionPings());
        authenticator.authenticate();
        if (isConnectionPingsClient) {
            Assertions.assertEquals((long)1L, (long)networkAvailabilityManager.connectionPings());
        } else {
            Assertions.assertEquals((long)0L, (long)networkAvailabilityManager.connectionPings());
        }
        Assertions.assertEquals((Object)expectedSoftwareName, (Object)metadataRegistry.clientInformation().softwareName());
        Assertions.assertEquals((Object)expectedSoftwareVersion, (Object)metadataRegistry.clientInformation().softwareVersion());
        ((ReadableByteChannel)Mockito.verify((Object)transportLayer, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    private SaslServerAuthenticator setupAuthenticator(Map<String, ?> configs, TransportLayer transportLayer, String mechanism, ChannelMetadataRegistry metadataRegistry, boolean isInterBrokerListener, NetworkAvailabilityManager networkAvailabilityManager) {
        ApiVersionsResponse apiVersionsResponse;
        new TestJaasConfig().addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap());
        Map<String, Subject> subjects = Collections.singletonMap(mechanism, new Subject());
        Map<String, SaslServerCallbackHandler> callbackHandlers = Collections.singletonMap(mechanism, new SaslServerCallbackHandler());
        ApiMessageType.ListenerType defaultApiVersionsResponse_listenerType = ApiMessageType.ListenerType.ZK_BROKER;
        ApiVersionsResponse apiVersionsResponse2 = apiVersionsResponse = ApiVersionsResponse.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)defaultApiVersionsResponse_listenerType);
        Object var10_9 = null;
        apiVersionsResponse = null;
        ApiVersionsResponse apiVersionsResponse3 = apiVersionsResponse2;
        return new SaslServerAuthenticator(configs, callbackHandlers, "node", subjects, null, new ListenerName("ssl"), isInterBrokerListener, SecurityProtocol.SASL_SSL, transportLayer, Collections.emptyMap(), metadataRegistry, Time.SYSTEM, () -> apiVersionsResponse3, (RequestCallback)networkAvailabilityManager);
    }

    private static final int foo$1(InvocationOnMock invocation, ByteBuffer headerBuffer$1, ByteBuffer requestBuffer$1) {
        ((ByteBuffer)invocation.getArgument(0)).putInt(headerBuffer$1.remaining() + requestBuffer$1.remaining());
        return 4;
    }

    private static final int foo$2(InvocationOnMock invocation, ByteBuffer headerBuffer$1, ByteBuffer requestBuffer$1) {
        ((ByteBuffer)invocation.getArgument(0)).put(headerBuffer$1.duplicate()).put(requestBuffer$1.duplicate());
        return headerBuffer$1.remaining() + requestBuffer$1.remaining();
    }
}

