/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.durability.topic;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Optional;
import kafka.durability.Utils$;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.OffsetChangeEvent;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.topic.DurabilityTopicMessageFormatter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\u000e\u001d\u0001\u0015BQ\u0001\f\u0001\u0005\u00025B\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011A\u0019\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0003Q\u0004\"\u0003!\u0001\u0001\u0004\u0005\t\u0015)\u00033\u0011%\t\u0005\u00011AA\u0002\u0013\u0005!\tC\u0005O\u0001\u0001\u0007\t\u0019!C\u0001\u001f\"I\u0011\u000b\u0001a\u0001\u0002\u0003\u0006Ka\u0011\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002MC\u0011b\u0016\u0001A\u0002\u0003\u0007I\u0011\u0001-\t\u0013i\u0003\u0001\u0019!A!B\u0013!\u0006\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0001T\u0011%a\u0006\u00011AA\u0002\u0013\u0005Q\fC\u0005`\u0001\u0001\u0007\t\u0011)Q\u0005)\"I\u0001\r\u0001a\u0001\u0002\u0004%\t!\u0019\u0005\nU\u0002\u0001\r\u00111A\u0005\u0002-D\u0011\"\u001c\u0001A\u0002\u0003\u0005\u000b\u0015\u00022\t\u00139\u0004\u0001\u0019!a\u0001\n\u0003y\u0007\"C:\u0001\u0001\u0004\u0005\r\u0011\"\u0001u\u0011%1\b\u00011A\u0001B\u0003&\u0001\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010\u0003\u0004\u0002\n\u0001!\t\u0001\u001f\u0005\u0007\u0003'\u0001A\u0011\u0001=\t\r\u0005]\u0001\u0001\"\u0001y\u0011\u0019\tY\u0002\u0001C\u0001q\"1\u0011q\u0004\u0001\u0005\u0002aDa!a\t\u0001\t\u0003A(a\t#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e;feR+7\u000f\u001e\u0006\u0003;y\tQ\u0001^8qS\u000eT!a\b\u0011\u0002\u0015\u0011,(/\u00192jY&$\u0018P\u0003\u0002\"E\u0005)1.\u00194lC*\t1%\u0001\u0003v]&$8\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001\u001d\u0003%1wN]7biR,'/F\u00013!\t\u0019t'D\u00015\u0015\tiRG\u0003\u0002 m)\t\u0011%\u0003\u00029i\tyB)\u001e:bE&d\u0017\u000e^=U_BL7-T3tg\u0006<WMR8s[\u0006$H/\u001a:\u0002\u001b\u0019|'/\\1ui\u0016\u0014x\fJ3r)\tYd\b\u0005\u0002(y%\u0011Q\b\u000b\u0002\u0005+:LG\u000fC\u0004@\u0007\u0005\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0013'\u0001\u0006g_Jl\u0017\r\u001e;fe\u0002\nA\u0001\u001e9jIV\t1\t\u0005\u0002E\u00196\tQI\u0003\u0002G\u000f\u000611m\\7n_:T!!\t%\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u0016\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\u0011Q\u0004\u0018\u000eZ0%KF$\"a\u000f)\t\u000f}2\u0011\u0011!a\u0001\u0007\u0006)A\u000f]5eA\u0005)Q\r]8dQV\tA\u000b\u0005\u0002(+&\u0011a\u000b\u000b\u0002\u0004\u0013:$\u0018!C3q_\u000eDw\fJ3r)\tY\u0014\fC\u0004@\u0013\u0005\u0005\t\u0019\u0001+\u0002\r\u0015\u0004xn\u00195!\u0003\u001d1XM]:j_:\f1B^3sg&|gn\u0018\u0013fcR\u00111H\u0018\u0005\b\u007f1\t\t\u00111\u0001U\u0003!1XM]:j_:\u0004\u0013\u0001\u00022b_N,\u0012A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f!![8\u000b\u0003\u001d\fAA[1wC&\u0011\u0011\u000e\u001a\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0003!\u0011\u0017m\\:`I\u0015\fHCA\u001em\u0011\u001dyt\"!AA\u0002\t\fQAY1pg\u0002\n!\u0001]:\u0016\u0003A\u0004\"aY9\n\u0005I$'a\u0003)sS:$8\u000b\u001e:fC6\fa\u0001]:`I\u0015\fHCA\u001ev\u0011\u001dy$#!AA\u0002A\f1\u0001]:!\u0003\u0015\u0019X\r^+q)\u0005Y\u0004F\u0001\u000b{!\rY\u0018QA\u0007\u0002y*\u0011QP`\u0001\u0004CBL'bA@\u0002\u0002\u00059!.\u001e9ji\u0016\u0014(bAA\u0002\u0015\u0006)!.\u001e8ji&\u0019\u0011q\u0001?\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000eg_Jl\u0017\r^(gMN,Go\u00115b]\u001e,WI^3oiR+7\u000f\u001e\u0015\u0004+\u00055\u0001cA>\u0002\u0010%\u0019\u0011\u0011\u0003?\u0003\tQ+7\u000f^\u0001\u001dM>\u0014X.\u0019;EK2,G/\u001a*fG>\u0014Hm]#wK:$H+Z:uQ\r1\u0012QB\u0001\u001bM>\u0014X.\u0019;Fa>\u001c\u0007n\u00115b]\u001e,WI^3oiR+7\u000f\u001e\u0015\u0004/\u00055\u0011\u0001\u00074pe6\fG/S:s\u000bb\u0004\u0018M\u001c3Fm\u0016tG\u000fV3ti\"\u001a\u0001$!\u0004\u0002=\u0019|'/\\1u%\u0016$XM\u001c;j_:\u001c\u0005.\u00198hK\u00163XM\u001c;UKN$\bfA\r\u0002\u000e\u0005\u0001cm\u001c:nCR\u001cF/\u0019:u\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$H+Z:uQ\rQ\u0012Q\u0002")
public class DurabilityTopicMessageFormatterTest {
    private DurabilityTopicMessageFormatter formatter;
    private TopicIdPartition tpid;
    private int epoch;
    private int version;
    private ByteArrayOutputStream baos;
    private PrintStream ps;

    public DurabilityTopicMessageFormatter formatter() {
        return this.formatter;
    }

    public void formatter_$eq(DurabilityTopicMessageFormatter x$1) {
        this.formatter = x$1;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public void tpid_$eq(TopicIdPartition x$1) {
        this.tpid = x$1;
    }

    public int epoch() {
        return this.epoch;
    }

    public void epoch_$eq(int x$1) {
        this.epoch = x$1;
    }

    public int version() {
        return this.version;
    }

    public void version_$eq(int x$1) {
        this.version = x$1;
    }

    public ByteArrayOutputStream baos() {
        return this.baos;
    }

    public void baos_$eq(ByteArrayOutputStream x$1) {
        this.baos = x$1;
    }

    public PrintStream ps() {
        return this.ps;
    }

    public void ps_$eq(PrintStream x$1) {
        this.ps = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.formatter_$eq(new DurabilityTopicMessageFormatter());
        this.tpid_$eq(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test", 0)));
        this.epoch_$eq(0);
        this.version_$eq(1);
        this.baos_$eq(new ByteArrayOutputStream());
        this.ps_$eq(new PrintStream(this.baos()));
    }

    @Test
    public void formatOffsetChangeEventTest() {
        OffsetChangeEvent obj = OffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 0L);
        ConsumerRecord record = new ConsumerRecord(this.tpid().topicPartition().topic(), this.tpid().topicPartition().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(20).append("OffsetChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatDeleteRecordsEventTest() {
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_trimmedOffset;
        DeleteRecordsEvent deleteRecordsEvent;
        Set set = DeleteRecordsEvent$.MODULE$.apply$default$6();
        long l = 0L;
        long l2 = 100L;
        int n = this.epoch();
        long l3 = 100L;
        TopicIdPartition apply_id = this.tpid();
        DeleteRecordsEvent deleteRecordsEvent2 = deleteRecordsEvent = new DeleteRecordsEvent(apply_id, (long)apply_trimmedOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr);
        Object var4_6 = null;
        set = null;
        deleteRecordsEvent = null;
        DeleteRecordsEvent obj = deleteRecordsEvent2;
        ConsumerRecord record = new ConsumerRecord(this.tpid().topicPartition().topic(), this.tpid().topicPartition().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(21).append("DeleteRecordsEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatEpochChangeEventTest() {
        void apply_isr;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_firstOffset;
        EpochChangeEvent epochChangeEvent;
        Set set = EpochChangeEvent$.MODULE$.apply$default$6();
        long l = 0L;
        long l2 = 100L;
        int n = this.epoch();
        long l3 = 50L;
        TopicIdPartition apply_id = this.tpid();
        EpochChangeEvent epochChangeEvent2 = epochChangeEvent = new EpochChangeEvent(apply_id, (long)apply_firstOffset, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (Set)apply_isr);
        Object var4_6 = null;
        set = null;
        epochChangeEvent = null;
        EpochChangeEvent obj = epochChangeEvent2;
        ConsumerRecord record = new ConsumerRecord(this.tpid().topicPartition().topic(), this.tpid().topicPartition().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(19).append("EpochChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatIsrExpandEventTest() {
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_expandBrokerId;
        IsrExpandEvent isrExpandEvent;
        long l = 0L;
        long l2 = 100L;
        int n = this.epoch();
        int n2 = 5;
        TopicIdPartition apply_id = this.tpid();
        IsrExpandEvent isrExpandEvent2 = isrExpandEvent = new IsrExpandEvent(apply_id, (int)apply_expandBrokerId, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset);
        Object var4_5 = null;
        isrExpandEvent = null;
        IsrExpandEvent obj = isrExpandEvent2;
        ConsumerRecord record = new ConsumerRecord(this.tpid().topicPartition().topic(), this.tpid().topicPartition().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(17).append("IsrExpandEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatRetentionChangeEventTest() {
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        void apply_version;
        void apply_size;
        void apply_timeMs;
        RetentionChangeEvent retentionChangeEvent;
        long l = 0L;
        long l2 = 100L;
        int n = this.epoch();
        int n2 = this.version();
        long l3 = 1000L;
        long l4 = 50L;
        TopicIdPartition apply_id = this.tpid();
        RetentionChangeEvent retentionChangeEvent2 = retentionChangeEvent = new RetentionChangeEvent(apply_id, (long)apply_timeMs, (long)apply_size, (int)apply_version, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset);
        Object var4_7 = null;
        retentionChangeEvent = null;
        RetentionChangeEvent obj = retentionChangeEvent2;
        ConsumerRecord record = new ConsumerRecord(this.tpid().topicPartition().topic(), this.tpid().topicPartition().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(23).append("RetentionChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void formatStartOffsetChangeEventTest() {
        void apply_isr;
        void apply_retentionValue;
        void apply_retentionType;
        void apply_logStartOffset;
        void apply_highWatermark;
        void apply_epoch;
        StartOffsetChangeEvent startOffsetChangeEvent;
        Set set = StartOffsetChangeEvent$.MODULE$.apply$default$7();
        long l = 0L;
        byte by = (byte)RetentionType$.MODULE$.SizeBasedRetention().id();
        long l2 = 21L;
        long l3 = 100L;
        int n = this.epoch();
        TopicIdPartition apply_id = this.tpid();
        StartOffsetChangeEvent startOffsetChangeEvent2 = startOffsetChangeEvent = new StartOffsetChangeEvent(apply_id, 2, (int)apply_epoch, (long)apply_highWatermark, (long)apply_logStartOffset, (byte)apply_retentionType, (long)apply_retentionValue, (Set)apply_isr);
        Object var4_7 = null;
        set = null;
        startOffsetChangeEvent = null;
        StartOffsetChangeEvent obj = startOffsetChangeEvent2;
        ConsumerRecord record = new ConsumerRecord(this.tpid().topicPartition().topic(), this.tpid().topicPartition().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = Utils$.MODULE$.consumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(25).append("StartOffsetChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }
}

