/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import kafka.log.LocalLog$;
import kafka.log.LogConfig;
import kafka.log.MergedLog$;
import kafka.restore.operators.FtpsSegmentView;
import kafka.restore.operators.RestorePartitionOperator;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001B\u0013'\u00015BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000f\u0001\u0005\u0002eBQ!\u0010\u0001\u0005\u0002eBQA\u0010\u0001\u0005\u0002eBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004K\u0001\u0001\u0006I!\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0001\u0006\u0001)A\u0005\u001b\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB.\u0001A\u0003%1\u000bC\u0004]\u0001\t\u0007I\u0011A/\t\r\u0019\u0004\u0001\u0015!\u0003_\u0011\u001d9\u0007A1A\u0005\u0002uCa\u0001\u001b\u0001!\u0002\u0013q\u0006bB5\u0001\u0005\u0004%\tA\u001b\u0005\u0007m\u0002\u0001\u000b\u0011B6\t\u000f]\u0004!\u0019!C\u0001q\"1Q\u0010\u0001Q\u0001\neDqA \u0001C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0001\u0011%\ty\u0001\u0001b\u0001\n\u0003\t\t\u0002\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\n\u0011!1\u0006A1A\u0005\u0002\u0005u\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\b\t\u0013\u0005\u001d\u0002A1A\u0005\u0002\u0005%\u0002\u0002CA\u001c\u0001\u0001\u0006I!a\u000b\t\u0013\u0005e\u0002A1A\u0005\u0002\u0005m\u0002\u0002CA$\u0001\u0001\u0006I!!\u0010\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0003bBA:\u0001\u0011\u0005\u00111\n\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t\t\f\u0001C\u0005\u0003gCq!!0\u0001\t\u0013\ty\fC\u0005\u0002Z\u0002\u0011\r\u0011\"\u0003\u0002\\\"A\u0011Q\u001c\u0001!\u0002\u0013\tyJA\u000fSKN$xN]3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G+Z:u\u0015\t9\u0003&A\u0003u_>d7O\u0003\u0002*U\u0005)1.\u00194lC*\t1&\u0001\u0003v]&$8\u0001A\n\u0003\u00019\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001'\u0003=\u0019\u0007.Z2lgVlWI\\1cY\u0016$W#\u0001\u001e\u0011\u0005=Z\u0014B\u0001\u001f1\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0004^5fe\u000ecW-\u00198fe\u001a+\u0017\r^;sK\u0016s\u0017M\u00197fI\u00069C/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u00072,\u0017M\\;q\r\u0016\fG/\u001e:f\u000b:\f'\r\\3e\u0003E\u0019\u0007.Z2lgVl\u0017\t\\4pe&$\b.\\\u000b\u0002\u0003B\u0011!\tS\u0007\u0002\u0007*\u0011A)R\u0001\tG\",7m[:v[*\u0011aiR\u0001\u0006kRLGn\u001d\u0006\u0002S%\u0011\u0011j\u0011\u0002\n\u00032<wN]5uQ6\f!c\u00195fG.\u001cX/\\!mO>\u0014\u0018\u000e\u001e5nA\u0005\u00012/\u001e9fe\ncwnY6MK:<G\u000f[\u000b\u0002\u001bB\u0011qFT\u0005\u0003\u001fB\u0012Qa\u00155peR\f\u0011c];qKJ\u0014En\\2l\u0019\u0016tw\r\u001e5!\u0003\u001d1\u0017m\u0019;pef,\u0012a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bQa\u001d;bi\u0016T!\u0001W$\u0002\tQLWM]\u0005\u00035V\u0013\u0011\u0004V5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a\u000b7\r^8ss\u0006Aa-Y2u_JL\b%A\u0005qCJ,g\u000e\u001e#jeV\ta\f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006\u0011\u0011n\u001c\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0003GS2,\u0017A\u00039be\u0016tG\u000fR5sA\u0005\u0019A-\u001b:\u0002\t\u0011L'\u000fI\u0001\u0003iB,\u0012a\u001b\t\u0003YRl\u0011!\u001c\u0006\u0003]>\faaY8n[>t'BA\u0015q\u0015\t\t(/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0006\u0019qN]4\n\u0005Ul'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013\u0001\u0002;qS\u0012,\u0012!\u001f\t\u0003unl\u0011aV\u0005\u0003y^\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\u000bQ\u0004\u0018\u000e\u001a\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9aR\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005-\u0011Q\u0001\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mA\u0005!A/[7f+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005]Q\"A#\n\u0007\u0005eQI\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!+\t\ty\u0002E\u0002U\u0003CI1!a\tV\u0005Y1\u0015\u000e\\3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017AB:uCR,\u0007%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u00111\u0006\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011G$\u0002\u00071|w-\u0003\u0003\u00026\u0005=\"!\u0003'pO\u000e{gNZ5h\u0003)awnZ\"p]\u001aLw\rI\u0001\u0013G>tg\r\\;f]RdunZ\"p]\u001aLw-\u0006\u0002\u0002>A!\u0011qHA\"\u001d\r\t\t%G\u0007\u0002\u0001%!\u0011QIA\u001a\u0005I\u0019uN\u001c4mk\u0016tG\u000fT8h\u0007>tg-[4\u0002'\r|gN\u001a7vK:$Hj\\4D_:4\u0017n\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u00055\u0003cA\u0018\u0002P%\u0019\u0011\u0011\u000b\u0019\u0003\tUs\u0017\u000e\u001e\u0015\u0004;\u0005U\u0003\u0003BA,\u0003Kj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0004CBL'\u0002BA0\u0003C\nqA[;qSR,'OC\u0002\u0002dI\fQA[;oSRLA!a\u001a\u0002Z\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d3po:D3AHA7!\u0011\t9&a\u001c\n\t\u0005E\u0014\u0011\f\u0002\n\u0003\u001a$XM]#bG\"\fa\u0003^3tiV\u0003H-\u0019;f'\u0016<W.\u001a8u'R\fG/\u001a\u0015\u0004?\u0005]\u0004\u0003BA,\u0003sJA!a\u001f\u0002Z\t!A+Z:u\u0003a)\b\u000f\\8bI&s\u0017\u000e^1uK\u0006sGmQ8na2,G/\u001a\u000b\u000f\u0003\u001b\n\t)a#\u0002\u001c\u0006\u0015\u0016\u0011VAW\u0011\u001d\t\u0019\t\ta\u0001\u0003\u000b\u000bQ!\u001a9pG\"\u00042aLAD\u0013\r\tI\t\r\u0002\u0004\u0013:$\bbBAGA\u0001\u0007\u0011qR\u0001\t_\nTWm\u0019;JIB!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002\u0002\u0016\n\fA!\u001e;jY&!\u0011\u0011TAJ\u0005\u0011)V+\u0013#\t\u000f\u0005u\u0005\u00051\u0001\u0002 \u0006Y1\u000f^1si>3gm]3u!\ry\u0013\u0011U\u0005\u0004\u0003G\u0003$\u0001\u0002'p]\u001eDq!a*!\u0001\u0004\ty*A\u0005f]\u0012|eMZ:fi\"9\u00111\u0016\u0011A\u0002\u0005\u0015\u0015\u0001B:ju\u0016Dq!a,!\u0001\u0004\ty*\u0001\u0007nCb$\u0016.\\3ti\u0006l\u0007/A\reK2,G/Z%oSRL\u0017\r^3B]\u0012\u001cu.\u001c9mKR,G\u0003CA'\u0003k\u000b9,!/\t\u000f\u0005\r\u0015\u00051\u0001\u0002\u0006\"9\u0011QR\u0011A\u0002\u0005=\u0005bBA^C\u0001\u0007\u0011qT\u0001\u0011I\u0016dW\r^3D_6\u0004H.\u001a;f)N\f\u0001cZ3u)&,'o\u0015;bi\u00164\u0015\u000e\\3\u0015\t\u0005\u0005\u0017q\u001b\t\u0005\u0003\u0007\f\tN\u0004\u0003\u0002F\u00065\u0007cAAda5\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017d\u0013A\u0002\u001fs_>$h(C\u0002\u0002PB\na\u0001\u0015:fI\u00164\u0017\u0002BAj\u0003+\u0014aa\u0015;sS:<'bAAha!)qM\ta\u0001=\u0006\trN\\3NS:,H/Z%o\u001b&dG.[:\u0016\u0005\u0005}\u0015AE8oK6Kg.\u001e;f\u0013:l\u0015\u000e\u001c7jg\u0002\u0002")
public class RestoreTierPartitionStateTest {
    private final Algorithm checksumAlgorithm = this.checksumEnabled() ? Algorithm.ADLER : Algorithm.NO_CHECKSUM;
    private final short superBlockLength = (short)(this.checksumEnabled() ? 512 : 0);
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true, this.checksumEnabled(), this.tierCleanerFeatureEnabled(), this.tierPartitionStateCleanupFeatureEnabled());
    private final File parentDir = TestUtils.tempDirectory(null, null);
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
    private final TopicPartition tp;
    private final TopicIdPartition tpid;
    private final LogDirFailureChannel logDirFailureChannel;
    private final MockTime time;
    private final FileTierPartitionState state;
    private final LogConfig logConfig;
    private final LogConfig.ConfluentLogConfig confluentLogConfig;
    private final long oneMinuteInMillis;

    public boolean checksumEnabled() {
        return false;
    }

    public boolean tierCleanerFeatureEnabled() {
        return false;
    }

    public boolean tierPartitionStateCleanupFeatureEnabled() {
        return false;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public short superBlockLength() {
        return this.superBlockLength;
    }

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime time() {
        return this.time;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public LogConfig.ConfluentLogConfig confluentLogConfig() {
        return this.confluentLogConfig;
    }

    @BeforeEach
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ debug_this = TestUtils$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = RestoreTierPartitionStateTest.$anonfun$setup$2(this, op);
                Object var3_3 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)debug_this, (String)msgWithLogIdent_msg));
                return;
            }
        });
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().confluentLogConfig()).thenReturn((Object)this.confluentLogConfig());
        Mockito.when((Object)this.confluentLogConfig().tierEnable()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(true));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    @Test
    public void testUpdateSegmentState() {
        int epoch = 3;
        int numOffsetsInSegment = 49;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef baseOffset = IntRef.create((int)0);
        long start = System.currentTimeMillis();
        LongRef timestamp = LongRef.create((long)start);
        ArrayBuffer objectIds = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            int endOffset = baseOffset$1.elem + numOffsetsInSegment;
            UUID objectId = UUID.randomUUID();
            objectIds.$plus$eq((Object)objectId);
            this.uploadInitateAndComplete(epoch, objectId, baseOffset$1.elem, endOffset, 100, timestamp$1.elem);
            timestamp$1.elem += this.oneMinuteInMillis();
            baseOffset$1.elem = endOffset + 1;
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.deleteInitiateAndComplete(epoch, (UUID)objectIds.apply(i), start));
        this.state().close();
        RestorePartitionOperator restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis());
        FtpsSegmentView operatorContext = restoreOperator.operatorContext();
        long headerSize = operatorContext.header().size();
        Assertions.assertEquals((long)150L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((int)3, (int)operatorContext.segmentStateMap().size());
        Assertions.assertEquals((int)2, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)1, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        Map pathmap = CollectionConverters$.MODULE$.MapHasAsScala(restoreOperator.restore()).asScala();
        Assertions.assertEquals((long)50L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((long)headerSize, (long)operatorContext.header().size());
        Assertions.assertEquals((int)2, (int)pathmap.size());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> Assertions.assertTrue((boolean)pathmap.keySet().contains(objectIds.apply(index))));
        restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis());
        operatorContext = restoreOperator.operatorContext();
        Assertions.assertEquals((long)50L, (long)operatorContext.header().startOffset());
        Assertions.assertEquals((long)headerSize, (long)operatorContext.header().size());
        Assertions.assertEquals((int)0, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)3, (int)operatorContext.segmentCountWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.tierCleanerFeatureEnabled(), this.tierPartitionStateCleanupFeatureEnabled(), (Time)this.time());
        TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, null, null, this.tierPartitionStateCleanupFeatureEnabled(), start);
        reopenedState.close();
    }

    private void uploadInitateAndComplete(int epoch, UUID objectId, long startOffset, long endOffset, int size, long maxTimestamp) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, startOffset, endOffset, maxTimestamp, -1L, size, false, false, false, TierUploadType.Archive, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private void deleteInitiateAndComplete(int epoch, UUID objectId, long deleteCompleteTs) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId, stateOffset, deleteCompleteTs), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private String getTierStateFile(File dir) {
        Object object = new Object();
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)file -> {
                RestoreTierPartitionStateTest.$anonfun$getTierStateFile$1(object, file);
                return BoxedUnit.UNIT;
            });
            return null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (String)ex.value();
            }
            throw ex;
        }
    }

    private long oneMinuteInMillis() {
        return this.oneMinuteInMillis;
    }

    public static final /* synthetic */ String $anonfun$setup$2(RestoreTierPartitionStateTest $this, TierPartitionState.RecoveryOperation op$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append($this.state().topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$getTierStateFile$1(Object nonLocalReturnKey1$1, File file) {
        if (file.isFile() && MergedLog$.MODULE$.isTierStateFile(file)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)file.getAbsolutePath());
        }
    }

    public RestoreTierPartitionStateTest() {
        File parseTopicPartitionName_dir = this.dir();
        Object var1_1 = null;
        this.tp = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.tpid = new TopicIdPartition(this.tp().topic(), UUID.randomUUID(), this.tp().partition());
        this.logDirFailureChannel = new LogDirFailureChannel(5);
        this.time = new MockTime();
        this.state = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled(), this.tierCleanerFeatureEnabled(), this.tierPartitionStateCleanupFeatureEnabled(), (Time)this.time());
        this.logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        this.confluentLogConfig = (LogConfig.ConfluentLogConfig)Mockito.mock(LogConfig.ConfluentLogConfig.class);
        this.oneMinuteInMillis = 60000L;
    }
}

