/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\u0007\u000e\u0001IAQa\u0006\u0001\u0005\u0002aAQA\u0007\u0001\u0005\u0002mAQ\u0001\u0014\u0001\u0005\u00025CQa\u0015\u0001\u0005\u0002QCQA\u0017\u0001\u0005\u0002mCQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001b\u0001\u0005\u0002%<QA^\u0007\t\u0002]4Q\u0001D\u0007\t\u0002aDQaF\u0005\u0005\u0002qDQaS\u0005\u0005\u0002u\u0014\u0011\u0005\u00157bS:$X\r\u001f;D_:\u001cX/\\3s'V\u00147o\u0019:jaRLwN\u001c+fgRT!AD\b\u0002\u0007\u0005\u0004\u0018NC\u0001\u0011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0007\n\u0005Yi!\u0001F!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011A\u0003A\u0001\u0018i\u0016\u001cH\u000fU1ui\u0016\u0014hnU;cg\u000e\u0014\u0018\u000e\u001d;j_:$2\u0001\b\u00120!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0011)f.\u001b;\t\u000b\r\u0012\u0001\u0019\u0001\u0013\u0002\rE,xN];n!\t)CF\u0004\u0002'UA\u0011qEH\u0007\u0002Q)\u0011\u0011&E\u0001\u0007yI|w\u000e\u001e \n\u0005-r\u0012A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\u0010\t\u000bA\u0012\u0001\u0019\u0001\u0013\u0002\u001b\u001d\u0014x.\u001e9Qe>$xnY8mQ\u0011\u0011!GP \u0011\u0005MbT\"\u0001\u001b\u000b\u0005U2\u0014A\u00029be\u0006l7O\u0003\u00028q\u00059!.\u001e9ji\u0016\u0014(BA\u001d;\u0003\u0015QWO\\5u\u0015\u0005Y\u0014aA8sO&\u0011Q\b\u000e\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013\u0001Q\u0001+w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhf\u001a:pkB\u0004&o\u001c;pG>dWh_\u0019~Q\u0011\u0011!\tS%\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0014\u0001\u00039s_ZLG-\u001a:\n\u0005\u001d#%\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&\u0001&\"\u0003-\u000b!fZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u0006cG.A\u0011uKN$8+\u001e2tKF,XM\u001c;QCR$XM\u001d8Tk\n\u001c8M]5qi&|g\u000eF\u0002\u001d\u001d>CQaI\u0002A\u0002\u0011BQ\u0001M\u0002A\u0002\u0011BCa\u0001\u001a?\u007f!\"1A\u0011%SY\u0005Q\u0015!\u0007;fgR\u0004\u0016\r\u001e;fe:,fn];cg\u000e\u0014\u0018\u000e\u001d;j_:$2\u0001H+W\u0011\u0015\u0019C\u00011\u0001%\u0011\u0015\u0001D\u00011\u0001%Q\u0011!!GP )\t\u0011\u0011\u0005*\u0017\u0017\u0002\u0015\u0006yB/Z:u\u000bb\u0004\u0018M\u001c3j]\u001e$v\u000e]5d'V\u00147o\u0019:jaRLwN\\:\u0015\u0007qaV\fC\u0003$\u000b\u0001\u0007A\u0005C\u00031\u000b\u0001\u0007A\u0005\u000b\u0003\u0006eyz\u0004\u0006B\u0003C\u0011\u0002d\u0013AS\u0001 i\u0016\u001cHo\u00155sS:\\\u0017N\\4U_BL7mU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001cHc\u0001\u000fdI\")1E\u0002a\u0001I!)\u0001G\u0002a\u0001I!\"aA\r @Q\u00111!\tS4-\u0003)\u000bA\u0003^3tiVs7/\u001e2tGJL'-\u001a+pa&\u001cGc\u0001\u000fkW\")1e\u0002a\u0001I!)\u0001g\u0002a\u0001I!\"qA\r @Q\u00119!\t\u00138-\u0003)CC\u0001\u00019IkB\u0011\u0011o]\u0007\u0002e*\u0011aBN\u0005\u0003iJ\u0014q\u0001V5nK>,HO\b\u0002\u00031\u0006\t\u0003\u000b\\1j]R,\u0007\u0010^\"p]N,X.\u001a:Tk\n\u001c8M]5qi&|g\u000eV3tiB\u0011A#C\n\u0003\u0013e\u0004\"!\b>\n\u0005mt\"AB!osJ+g\rF\u0001x+\u0005q\b#B@\u0002\u000e\u0005EQBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\rM$(/Z1n\u0015\u0011\t9!!\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0017\tAA[1wC&!\u0011qBA\u0001\u0005\u0019\u0019FO]3b[B\u00191)a\u0005\n\u0007\u0005UAIA\u0005Be\u001e,X.\u001a8ug\u0002")
public class PlaintextConsumerSubscriptionTest
extends AbstractConsumerTest {
    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPatternSubscription(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1), this.sendRecords$default$4());
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1), this.sendRecords$default$4());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener(this));
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1), this.sendRecords$default$4());
        assignment = (Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSubsequentPatternSubscription(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0), this.sendRecords$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener(this));
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0), this.sendRecords$default$4());
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener(this));
        assignment = (Set)assignment.$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        assignment = (Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPatternUnsubscription(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener(this));
        Set assignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment(consumer, (Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testExpandingTopicSubscriptions(String quorum, String groupProtocol) {
        String otherTopic = "other";
        Set initialAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)initialAssignment);
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Set expandedAssignment = (Set)initialAssignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)expandedAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testShrinkingTopicSubscriptions(String quorum, String groupProtocol) {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Set initialAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)initialAssignment);
        Set shrunkenAssignment = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (Set<TopicPartition>)shrunkenAssignment);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUnsubscribeTopic(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }
}

