/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function1;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\f\u0018\u0005qA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0011\u0019I\u0005\u0001)A\u0005\u0007\"9!\n\u0001b\u0001\n\u0003\u0011\u0005BB&\u0001A\u0003%1\tC\u0004M\u0001\t\u0007I\u0011\u0001\"\t\r5\u0003\u0001\u0015!\u0003D\u0011\u001dq\u0005A1A\u0005\u0002\tCaa\u0014\u0001!\u0002\u0013\u0019\u0005b\u0002)\u0001\u0005\u0004%\tA\u0011\u0005\u0007#\u0002\u0001\u000b\u0011B\"\t\u000fI\u0003!\u0019!C\u0001\u0005\"11\u000b\u0001Q\u0001\n\rCq\u0001\u0016\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004Z\u0001\u0001\u0006IA\u0016\u0005\b5\u0002\u0011\r\u0011\"\u0001V\u0011\u0019Y\u0006\u0001)A\u0005-\")A\f\u0001C\u0001;\")\u0011\r\u0001C\u0005E\")A\u0010\u0001C\u0001{\nQ\"I]8lKJDU-\u00197uQ\u000e{W.\\1oI>\u0003H/[8og*\u0011\u0001$G\u0001\u0006C\u0012l\u0017N\u001c\u0006\u00025\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001e!\tq\u0002&D\u0001 \u0015\t\u0001\u0013%\u0001\u0003vi&d'B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\u0011!\u0004\n\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014x-\u0003\u0002*?\t)2i\\7nC:$G)\u001a4bk2$x\n\u001d;j_:\u001c\u0018\u0001B1sON\u00042\u0001L\u00182\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#!B!se\u0006L\bC\u0001\u001a:\u001d\t\u0019t\u0007\u0005\u00025[5\tQG\u0003\u000277\u00051AH]8pizJ!\u0001O\u0017\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q5\na\u0001P5oSRtDC\u0001 A!\ty\u0004!D\u0001\u0018\u0011\u0015Q#\u00011\u0001,\u0003=\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014X#A\"\u0011\u0007\u0011;\u0015'D\u0001F\u0015\u00051\u0015A\u00036paR\u001c\u0018.\u001c9mK&\u0011\u0001*\u0012\u0002\u001c\u0003J<W/\\3oi\u0006\u001b7-\u001a9uS:<w\n\u001d;j_:\u001c\u0006/Z2\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u0004\u0013\u0001E2p[6\fg\u000eZ\"p]\u001aLwm\u00149u\u0003E\u0019w.\\7b]\u0012\u001cuN\u001c4jO>\u0003H\u000fI\u0001\ne\u0016\f7o\u001c8PaR\f!B]3bg>tw\n\u001d;!\u00031\u0011'o\\6fe&#7o\u00149u\u00035\u0011'o\\6fe&#7o\u00149uA\u0005y\u0001.Z1mi\"\u001cF/\u0019;vg>\u0003H/\u0001\tiK\u0006dG\u000f[*uCR,8o\u00149uA\u0005a1m\\7q_:,g\u000e^(qi\u0006i1m\\7q_:,g\u000e^(qi\u0002\n\u0001BZ8sG\u0016|\u0005\u000f^\u000b\u0002-B\u0011AiV\u0005\u00031\u0016\u0013\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0003%1wN]2f\u001fB$\b%A\u0006eKN\u001c'/\u001b2f\u001fB$\u0018\u0001\u00043fg\u000e\u0014\u0018NY3PaR\u0004\u0013A\u0003<fe&4\u00170\u0011:hgR\ta\f\u0005\u0002-?&\u0011\u0001-\f\u0002\u0005+:LG/\u0001\nwKJLg-\u001f*fcVL'/\u001a3Be\u001e\u001cHc\u00010dQ\")A\r\u0006a\u0001K\u00069q\u000e\u001d;j_:\u001c\bC\u0001#g\u0013\t9WIA\u0005PaRLwN\\*fi\")\u0011\u000e\u0006a\u0001U\u0006A!/Z9vSJ,G\rE\u0002-W6L!\u0001\\\u0017\u0003\u0015q\u0012X\r]3bi\u0016$g\b\r\u0002ogB\u0019Ai\\9\n\u0005A,%AC(qi&|gn\u00159fGB\u0011!o\u001d\u0007\u0001\t%!\b.!A\u0001\u0002\u000b\u0005QOA\u0002`IE\n\"A^=\u0011\u00051:\u0018B\u0001=.\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\f>\n\u0005ml#aA!os\u0006Aa\r\\1h\u001d\u0006lW\r\u0006\u00022}\"1q0\u0006a\u0001\u0003\u0003\taa\u001c9uS>t\u0007\u0007BA\u0002\u0003\u000f\u0001B\u0001R8\u0002\u0006A\u0019!/a\u0002\u0005\u0015\u0005%a0!A\u0001\u0002\u000b\u0005QOA\u0002`II\u0002")
public final class BrokerHealthCommandOptions
extends CommandDefaultOptions {
    private final ArgumentAcceptingOptionSpec<String> bootstrapServer;
    private final ArgumentAcceptingOptionSpec<String> commandConfigOpt;
    private final ArgumentAcceptingOptionSpec<String> reasonOpt;
    private final ArgumentAcceptingOptionSpec<String> brokerIdsOpt;
    private final ArgumentAcceptingOptionSpec<String> healthStatusOpt;
    private final ArgumentAcceptingOptionSpec<String> componentOpt;
    private final OptionSpecBuilder forceOpt;
    private final OptionSpecBuilder describeOpt;

    public ArgumentAcceptingOptionSpec<String> bootstrapServer() {
        return this.bootstrapServer;
    }

    public ArgumentAcceptingOptionSpec<String> commandConfigOpt() {
        return this.commandConfigOpt;
    }

    public ArgumentAcceptingOptionSpec<String> reasonOpt() {
        return this.reasonOpt;
    }

    public ArgumentAcceptingOptionSpec<String> brokerIdsOpt() {
        return this.brokerIdsOpt;
    }

    public ArgumentAcceptingOptionSpec<String> healthStatusOpt() {
        return this.healthStatusOpt;
    }

    public ArgumentAcceptingOptionSpec<String> componentOpt() {
        return this.componentOpt;
    }

    public OptionSpecBuilder forceOpt() {
        return this.forceOpt;
    }

    public OptionSpecBuilder describeOpt() {
        return this.describeOpt;
    }

    public void verifyArgs() {
        if (new .colon.colon(this.healthStatusOpt(), (List)new .colon.colon((Object)this.describeOpt(), (List)Nil$.MODULE$)).count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.options.has(x$1))) != 1) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Command must include exactly one action: ").append(this.flagName((OptionSpec<?>)this.healthStatusOpt())).append(" OR ").append(this.flagName((OptionSpec<?>)this.describeOpt())).append(".").toString());
        }
        if (this.options.has(this.healthStatusOpt())) {
            this.verifyRequiredArgs(this.options, (Seq<OptionSpec<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServer(), this.reasonOpt(), this.brokerIdsOpt(), this.componentOpt()}));
            return;
        }
        if (this.options.has((OptionSpec)this.describeOpt())) {
            this.verifyRequiredArgs(this.options, (Seq<OptionSpec<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServer()}));
            if (this.options.has(this.reasonOpt())) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Describe cannot be used with ").append(this.flagName((OptionSpec<?>)this.reasonOpt())).append("!").toString());
            }
            if (this.options.has(this.brokerIdsOpt())) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Describe cannot be used with ").append(this.flagName((OptionSpec<?>)this.brokerIdsOpt())).append("!").toString());
            }
            if (this.options.has(this.componentOpt())) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Describe cannot be used with ").append(this.flagName((OptionSpec<?>)this.componentOpt())).append("!").toString());
            }
            return;
        }
    }

    private void verifyRequiredArgs(OptionSet options, Seq<OptionSpec<?>> required) {
        required.foreach((Function1 & Serializable)arg -> {
            BrokerHealthCommandOptions.$anonfun$verifyRequiredArgs$1(options, arg);
            return BoxedUnit.UNIT;
        });
    }

    public String flagName(OptionSpec<?> option) {
        return new StringBuilder(2).append("--").append(option.options().get(0)).toString();
    }

    public static final /* synthetic */ void $anonfun$verifyRequiredArgs$1(OptionSet options$1, OptionSpec arg) {
        if (!options$1.has(arg)) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Missing required argument '").append(arg).append("'").toString());
        }
    }

    public BrokerHealthCommandOptions(String[] args) {
        super(args);
        this.bootstrapServer = this.parser.accepts("bootstrap-server", "A hostname and port for the broker to connect to, in the form host:port. Multiple comma separated URLs can be given. REQUIRED.").withRequiredArg().describedAs("host:port").ofType(String.class);
        this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("file").ofType(String.class);
        this.reasonOpt = this.parser.accepts("reason", "Reason for changing a broker component's health status. Valid characters for the reason are the ASCII alphanumerics, '.', '_', and '-'. The string cannot start with the '.' character and must be between 1-32 characters. Example: operator").withRequiredArg().describedAs("reason").ofType(String.class);
        this.brokerIdsOpt = this.parser.accepts("broker-ids", "Comma separated non-negative integers representing a non-empty list of broker ids whose broker component health status we want to update.").withRequiredArg().describedAs("id1, id2, id3, ...").ofType(String.class);
        this.healthStatusOpt = this.parser.accepts("health-status", "The health status we want to apply to the given broker component. One of DEGRADED or HEALTHY. Degraded brokers will be less preferred as partition leaders compared to brokers with normal health.").withRequiredArg().describedAs("HEALTHY").ofType(String.class);
        this.componentOpt = this.parser.accepts("component", "The broker component whose health status we want to update. One of UNSPECIFIED, STORAGE, NETWORK, or EXTERNAL_CONNECTIVITY_STARTUP.").withRequiredArg().describedAs("UNSPECIFIED").ofType(String.class);
        this.forceOpt = this.parser.accepts("force", "Whether the operation will be forced if the cluster has already reached the max number of brokers that can be demoted.");
        this.describeOpt = this.parser.accepts("describe", "Describe degraded brokers. Degraded brokers are less preferred as partition leaders compared to brokers with normal health.");
        this.options = this.parser.parse(args);
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps makes calls to the Broker Health API. It changes broker component health status and describes degraded brokers. Degraded brokers will be less preferred as partition leaders compared to brokers with normal health.");
        this.verifyArgs();
    }
}

