/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.UUID;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.MutateTopicIdCommand;
import kafka.admin.ZkSecurityMigrator$;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class MutateTopicIdCommand$
implements Logging {
    public static final MutateTopicIdCommand$ MODULE$ = new MutateTopicIdCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        try {
            this.unhandled(args);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(throwable.getMessage());
                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
            }
            if (throwable != null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ")).append("'").toString());
                throwable.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
            }
            throw null;
        }
    }

    public void unhandled(String[] args) {
        MutateTopicIdCommand.ConfigCommandOptions opts = new MutateTopicIdCommand.ConfigCommandOptions(args);
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to mutate topic ids. Note that this operation is dangerous and for EXCEPTIONAL USE ONLY.");
        if (opts.options.has(opts.zkConnectOpt())) {
            this.processTopicMutationWithZk((String)opts.options.valueOf(opts.zkConnectOpt()), opts);
            return;
        }
        Predef$.MODULE$.println((Object)"--zookeeper must be used with this command as state is modified directly.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processTopicMutationWithZk(String zkConnectString, MutateTopicIdCommand.ConfigCommandOptions opts) {
        ZKClientConfig zkClientConfig = (ZKClientConfig)ZkSecurityMigrator$.MODULE$.createZkClientConfigFromOption(opts.options, (OptionSpec<String>)opts.zkTlsConfigFile()).getOrElse((Function0 & Serializable)() -> new ZKClientConfig());
        boolean x$2 = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
        Time x$6 = Time.SYSTEM;
        String x$9 = "kafka.server";
        String x$10 = "SessionExpireListener";
        boolean x$11 = false;
        boolean x$12 = true;
        try (KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, x$2, 30000, 30000, Integer.MAX_VALUE, x$6, "ConfigCommand", zkClientConfig, x$9, x$10, x$11, x$12);){
            Uuid uuid;
            boolean bl;
            String topic = (String)opts.options.valueOf(opts.topic());
            String topicId = (String)opts.options.valueOf(opts.topicId());
            String string = (String)opts.options.valueOf(opts.typeOpt());
            switch (string == null ? 0 : string.hashCode()) {
                case -1106578487: {
                    if (!"legacy".equals(string)) throw new IllegalArgumentException("Only supported type options are legacy and modern.");
                    bl = true;
                    break;
                }
                case -1068799201: {
                    if (!"modern".equals(string)) throw new IllegalArgumentException("Only supported type options are legacy and modern.");
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only supported type options are legacy and modern.");
                }
            }
            boolean legacyTopicId = bl;
            try {
                uuid = Uuid.fromString((String)topicId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(new StringBuilder(51).append("Base64 topic id was not found, trying ").append(topicId).append(" as hex UUID.").toString());
                uuid = CoreUtils$.MODULE$.toKafkaUUID(UUID.fromString(topicId));
            }
            Uuid resolvedTopicId = uuid;
            zkClient.dangerouslyMutateTopicId(topic, resolvedTopicId, legacyTopicId, BoxesRunTime.unboxToBoolean((Object)opts.options.valueOf(opts.dryrunOpt())));
            return;
        }
    }

    private MutateTopicIdCommand$() {
    }
}

