/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.MetadataChange;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import java.util.Map;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.event.MetadataCollectorEvent;
import kafka.catalog.metadata.ClusterLinkInfo;
import kafka.common.TenantHelpers;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;

public class ClusterLinkCreationEvent
extends MetadataCollectorEvent {
    private final Map<String, ClusterLinkInfo> newClusterLinks;

    public ClusterLinkCreationEvent(ZKMetadataCollector collector, Map<String, ClusterLinkInfo> newClusterLinks, Time time) {
        super(collector, time);
        this.newClusterLinks = newClusterLinks;
    }

    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        LOG.debug("Creating cluster links {} ", this.newClusterLinks.keySet());
        Timestamp eventTimestamp = Timestamps.fromMillis((long)this.eventObservedTimeMillis);
        for (Map.Entry<String, ClusterLinkInfo> entry : this.newClusterLinks.entrySet()) {
            String linkName = entry.getKey();
            ClusterLinkInfo clusterLinkInfo = entry.getValue();
            String logicalClusterId = clusterLinkInfo.logicalClusterId();
            try {
                Uuid linkId = clusterLinkInfo.clusterLinkId();
                ClusterLinkConfig clusterLinkConfig = this.getClusterLinkConfigForClusterLink(context, linkId);
                if (clusterLinkConfig != null) {
                    MetadataEvent clusterLinkMetadataEvent = MetadataEventUtils.clusterLinkMetadataEvent(TenantHelpers.extractLogicalName(linkName), linkId, clusterLinkInfo.linkMode(), clusterLinkInfo.connectionMode(), clusterLinkInfo.remoteClusterId(), clusterLinkInfo.localClusterId(), eventTimestamp, eventTimestamp);
                    context.localStore().addClusterLinkMetadataEvent(logicalClusterId, linkName, clusterLinkMetadataEvent);
                    MetadataChange clusterLinkMetadataChange = MetadataEventUtils.entityCreateEvent(logicalClusterId, clusterLinkMetadataEvent);
                    this.emitClusterLinkDeltaEvent(context, clusterLinkMetadataChange);
                }
                context.removeClusterLinkFromInitialSnapshot(linkName);
            }
            catch (Exception e) {
                LOG.error("Skipping cluster link '{}' due to", (Object)linkName, (Object)e);
                context.catalogMetrics().collectorEventHandleErrorSensor.record();
            }
        }
    }

    public String toString() {
        return "ClusterLinkCreationEvent(newClusterLinks=" + this.newClusterLinks.keySet() + ')';
    }
}

