/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.controller.KRaftQueueItem;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\r\u001b\u0001}A\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0015\r\u0011\"\u0001B\u0011!y\u0005A!A!\u0002\u0013\u0011\u0005\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011A)\t\u0011a\u0003!\u0011!Q\u0001\nIC\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\tC\u0002\u0011\t\u0011)A\u00057\"A!\r\u0001BC\u0002\u0013\u00051\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003e\u0011!Q\u0007A!b\u0001\n\u0003Y\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011I\u0004!Q1A\u0005\u0002MD\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0015\u0005\r\u0001A!b\u0001\n\u0003\t)\u0001\u0003\u0006\u0002\u000e\u0001\u0011\t\u0011)A\u0005\u0003\u000fA!\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011\u001d\t9\u0003\u0001C\u0001\u0003SA\u0001\"!\u0011\u0001\u0005\u0004%I\u0001\u000e\u0005\b\u0003\u0007\u0002\u0001\u0015!\u00036\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002Z\u0001!\t%!\u0015\u0003--\u0013\u0016M\u001a;SKF,Xm\u001d;TK:$G\u000b\u001b:fC\u0012T!a\u0007\u000f\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u001e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0011.!\t\t3&D\u0001#\u0015\t\u0019C%\u0001\u0003vi&d'BA\u0013'\u0003\u0019\u0019XM\u001d<fe*\u0011Qd\n\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014x-\u0003\u0002-E\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e!\tq\u0013'D\u00010\u0015\t\u0001D$A\u0003vi&d7/\u0003\u00023_\t9Aj\\4hS:<\u0017\u0001D2p]R\u0014x\u000e\u001c7fe&#W#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u0007%sG/A\u0007d_:$(o\u001c7mKJLE\rI\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQB\u0019aGP\u001b\n\u0005}:$!\u0003$v]\u000e$\u0018n\u001c81\u0003\u0015\tX/Z;f+\u0005\u0011\u0005cA\"J\u00176\tAI\u0003\u0002F\r\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\r:%\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0012\u0013QB\u00117pG.LgnZ)vKV,\u0007C\u0001'N\u001b\u0005Q\u0012B\u0001(\u001b\u00059Y%+\u00194u#V,W/Z%uK6\fa!];fk\u0016\u0004\u0013!\u00048fi^|'o[\"mS\u0016tG/F\u0001S!\t\u0019f+D\u0001U\u0015\t)f%A\u0004dY&,g\u000e^:\n\u0005]#&!\u0004(fi^|'o[\"mS\u0016tG/\u0001\boKR<xN]6DY&,g\u000e\u001e\u0011\u0002\u0015\t\u0014xn[3s\u001d>$W-F\u0001\\!\tav,D\u0001^\u0015\tqf%\u0001\u0004d_6lwN\\\u0005\u0003Av\u0013AAT8eK\u0006Y!M]8lKJtu\u000eZ3!\u0003\u0019\u0019wN\u001c4jOV\tA\r\u0005\u0002fO6\taM\u0003\u0002&9%\u0011\u0001N\u001a\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\tQLW.Z\u000b\u0002YB\u0011Qn\\\u0007\u0002]*\u0011\u0001'X\u0005\u0003a:\u0014A\u0001V5nK\u0006)A/[7fA\u0005q\"/Z9vKN$(+\u0019;f\u0003:$\u0017+^3vKRKW.Z'fiJL7m]\u000b\u0002iB\u0011QO`\u0007\u0002m*\u0011q\u000f_\u0001\u0005G>\u0014XM\u0003\u0002zu\u00069Q.\u001a;sS\u000e\u001c(BA>}\u0003\u0019I\u0018-\\7fe*\tQ0A\u0002d_6L!a <\u0003\u000bQKW.\u001a:\u0002?I,\u0017/^3tiJ\u000bG/Z!oIF+X-^3US6,W*\u001a;sS\u000e\u001c\b%A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ,\"!a\u0002\u0011\u00071\u000bI!C\u0002\u0002\fi\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\u0002\t9\fW.\u001a\t\u0005\u0003'\t\tC\u0004\u0003\u0002\u0016\u0005u\u0001cAA\fo5\u0011\u0011\u0011\u0004\u0006\u0004\u00037q\u0012A\u0002\u001fs_>$h(C\u0002\u0002 ]\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010o\u00051A(\u001b8jiz\"b#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\t9$!\u000f\u0002<\u0005u\u0012q\b\t\u0003\u0019\u0002AQaM\nA\u0002UBQ\u0001P\nA\u0002uBQ\u0001Q\nA\u0002\tCQ\u0001U\nA\u0002ICQ!W\nA\u0002mCQAY\nA\u0002\u0011DQA[\nA\u00021DQA]\nA\u0002QDq!a\u0001\u0014\u0001\u0004\t9\u0001C\u0004\u0002\u0010M\u0001\r!!\u0005\u0002\u001fM|7m[3u)&lWm\\;u\u001bN\f\u0001c]8dW\u0016$H+[7f_V$Xj\u001d\u0011\u0002\r\u0011|wk\u001c:l)\t\tI\u0005E\u00027\u0003\u0017J1!!\u00148\u0005\u0011)f.\u001b;\u0002\u0017\t\u0014xn[3s%\u0016\fG-\u001f\u000b\u0003\u0003'\u00022ANA+\u0013\r\t9f\u000e\u0002\b\u0005>|G.Z1o\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e")
public class KRaftRequestSendThread
extends ShutdownableThread
implements Logging {
    private final int controllerId;
    private final Function0<Object> controllerEpoch;
    private final BlockingQueue<KRaftQueueItem> queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final Timer requestRateAndQueueTimeMetrics;
    private final StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public BlockingQueue<KRaftQueueItem> queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Timer requestRateAndQueueTimeMetrics() {
        return this.requestRateAndQueueTimeMetrics;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    public void doWork() {
        KRaftQueueItem kRaftQueueItem = this.queue().take();
        if (kRaftQueueItem == null) {
            throw new MatchError(null);
        }
        ApiKeys apiKey = kRaftQueueItem.apiKey();
        AbstractControlRequest.Builder<? extends AbstractControlRequest> requestBuilder = kRaftQueueItem.request();
        Function1<AbstractResponse, BoxedUnit> callback = kRaftQueueItem.callback();
        long l = kRaftQueueItem.enqueueTimeMs();
        this.requestRateAndQueueTimeMetrics().update(this.time().milliseconds() - l, TimeUnit.MILLISECONDS);
        ClientResponse clientResponse = null;
        try {
            boolean isSendSuccessful = false;
            while (this.isRunning() && !isSendSuccessful) {
                void var3_3;
                try {
                    if (!this.brokerReady()) {
                        isSendSuccessful = false;
                        this.pause(100L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    ClientRequest clientRequest = this.networkClient().newClientRequest(this.brokerNode().idString(), (AbstractRequest.Builder)var3_3, this.time().milliseconds(), true);
                    clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time());
                    isSendSuccessful = true;
                }
                catch (Throwable e) {
                    this.warn((Function0<String>)((Function0 & Serializable)() -> KRaftRequestSendThread.$anonfun$doWork$1(this, (AbstractControlRequest.Builder)var3_3)), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    this.networkClient().close(this.brokerNode().idString());
                    isSendSuccessful = false;
                    this.pause(100L, TimeUnit.MILLISECONDS);
                }
            }
            if (clientResponse != null) {
                void var4_4;
                ApiKeys api;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = requestHeader.apiKey();
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.STOP_REPLICA;
                    if (apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.UPDATE_METADATA;
                        if (apiKeys5 == null ? apiKeys6 != null : !apiKeys5.equals(apiKeys6)) {
                            void var2_2;
                            throw new KafkaException(new StringBuilder(28).append("Unexpected apiKey received: ").append(var2_2).toString());
                        }
                    }
                }
                AbstractResponse response = clientResponse.responseBody();
                this.stateChangeLogger().withControllerEpoch(this.controllerEpoch.apply$mcI$sp()).trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Received response ").append(response).append(" for request ").append(api).append(" with correlation id ").append(requestHeader.correlationId()).append(" sent to broker ").append(this.brokerNode()).toString());
                if (var4_4 != null) {
                    var4_4.apply((Object)response);
                }
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Controller ").append(this.controllerId()).append(" fails to send a request to broker ").append(this.brokerNode()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
        }
    }

    private boolean brokerReady() {
        try {
            if (!NetworkClientUtils.isReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (long)this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (Time)this.time(), (long)this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeoutMs()).append(" ms").toString());
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Controller ").append(this.controllerId()).append(" connected to ").append(this.brokerNode()).append(" for sending state change requests").toString());
            }
            return true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Controller ").append(this.controllerId()).append("'s connection to broker ").append(this.brokerNode()).append(" was unsuccessful").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            return false;
        }
    }

    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.networkClient().initiateClose();
            return true;
        }
        return false;
    }

    private final void backoff$1() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ String $anonfun$doWork$1(KRaftRequestSendThread $this, AbstractControlRequest.Builder requestBuilder$1) {
        return new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerEpoch.apply$mcI$sp()).append(" fails to send request ").append(requestBuilder$1).append(" ").append("to broker ").append($this.brokerNode()).append(". Reconnecting to broker.").toString();
    }

    public KRaftRequestSendThread(int controllerId, Function0<Object> controllerEpoch, BlockingQueue<KRaftQueueItem> queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, Timer requestRateAndQueueTimeMetrics, StateChangeLogger stateChangeLogger, String name) {
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        this.requestRateAndQueueTimeMetrics = requestRateAndQueueTimeMetrics;
        this.stateChangeLogger = stateChangeLogger;
        super(name);
        this.logIdent_$eq(new StringBuilder(34).append("[RequestSendThread controllerId=").append(controllerId).append("] ").toString());
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

