/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.PartitionLoadScheduler;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;
import org.apache.kafka.coordinator.group.runtime.Deserializer;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\b\u0010\u0001YA\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!A\u0006A!A!\u0002\u0013)\u0006\"B-\u0001\t\u0003Q\u0006b\u00022\u0001\u0005\u0004%Ia\u0019\u0005\u0007]\u0002\u0001\u000b\u0011\u00023\t\u000f=\u0004!\u0019!C\u0005a\"1Q\u000f\u0001Q\u0001\nEDQA\u001e\u0001\u0005B]Dq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002V\u0001!\t%a\u0016\u0003+\r{wN\u001d3j]\u0006$xN\u001d'pC\u0012,'/S7qY*\u0011\u0001#E\u0001\u0006OJ|W\u000f\u001d\u0006\u0003%M\t1bY8pe\u0012Lg.\u0019;pe*\tA#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0016\u0005]y3\u0003\u0002\u0001\u0019Am\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0004C-jS\"\u0001\u0012\u000b\u0005\r\"\u0013a\u0002:v]RLW.\u001a\u0006\u0003!\u0015R!A\u0005\u0014\u000b\u0005Q9#B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001eL!\u0001\f\u0012\u0003#\r{wN\u001d3j]\u0006$xN\u001d'pC\u0012,'\u000f\u0005\u0002/_1\u0001A!\u0002\u0019\u0001\u0005\u0004\t$!\u0001+\u0012\u0005IB\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$a\u0002(pi\"Lgn\u001a\t\u0003geJ!A\u000f\u001b\u0003\u0007\u0005s\u0017\u0010\u0005\u0002=\u007f5\tQH\u0003\u0002?'\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0011!\u0018.\\3\u0011\u0005\r;U\"\u0001#\u000b\u0005y*%B\u0001$'\u0003\u0019\u0019w.\\7p]&\u0011\u0001\n\u0012\u0002\u0005)&lW-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005-sU\"\u0001'\u000b\u00055\u001b\u0012AB:feZ,'/\u0003\u0002P\u0019\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018\u0001\u00043fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bcA\u0011S[%\u00111K\t\u0002\r\t\u0016\u001cXM]5bY&TXM]\u0001\u000fY>\fGMQ;gM\u0016\u00148+\u001b>f!\t\u0019d+\u0003\u0002Xi\t\u0019\u0011J\u001c;\u0002\u000fQD'/Z1eg\u00061A(\u001b8jiz\"baW/_?\u0002\f\u0007c\u0001/\u0001[5\tq\u0002C\u0003B\r\u0001\u0007!\tC\u0003J\r\u0001\u0007!\nC\u0003Q\r\u0001\u0007\u0011\u000bC\u0003U\r\u0001\u0007Q\u000bC\u0003Y\r\u0001\u0007Q+A\u0005jgJ+hN\\5oOV\tA\r\u0005\u0002fY6\taM\u0003\u0002hQ\u00061\u0011\r^8nS\u000eT!!\u001b6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002l9\u0005!Q\u000f^5m\u0013\tigMA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000bSN\u0014VO\u001c8j]\u001e\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005\t\bC\u0001:t\u001b\u0005\t\u0012B\u0001;\u0012\u0005Y\u0001\u0016M\u001d;ji&|g\u000eT8bIN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005!An\\1e)\u0015A\u0018QEA\u0019!\rI(\u0010`\u0007\u0002Q&\u00111\u0010\u001b\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007cA?\u0002 9\u0019a0a\u0007\u000f\u0007}\fIB\u0004\u0003\u0002\u0002\u0005]a\u0002BA\u0002\u0003+qA!!\u0002\u0002\u00149!\u0011qAA\t\u001d\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007+\u00051AH]8pizJ\u0011AK\u0005\u0003Q%J!\u0001F\u0014\n\u0005I1\u0013B\u0001\t&\u0013\t\u0019C%C\u0002\u0002\u001e\t\n\u0011cQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ3s\u0013\u0011\t\t#a\t\u0003\u00171{\u0017\rZ*v[6\f'/\u001f\u0006\u0004\u0003;\u0011\u0003bBA\u0014\u0017\u0001\u0007\u0011\u0011F\u0001\u0003iB\u0004B!a\u000b\u0002.5\tQ)C\u0002\u00020\u0015\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0013\u0017\u0001\u0007\u00111\u0007\t\u0005C\u0005UR&C\u0002\u00028\t\u00121cQ8pe\u0012Lg.\u0019;peBc\u0017-\u001f2bG.\fa\u0001Z8M_\u0006$GCCA\u001f\u0003\u0007\n)%a\u0012\u0002LA\u00191'a\u0010\n\u0007\u0005\u0005CG\u0001\u0003V]&$\bbBA\u0014\u0019\u0001\u0007\u0011\u0011\u0006\u0005\u0007%1\u0001\r!a\r\t\r\u0005%C\u00021\u0001y\u0003\u00191W\u000f^;sK\"9\u0011Q\n\u0007A\u0002\u0005=\u0013aC:uCJ$H+[7f\u001bN\u00042aMA)\u0013\r\t\u0019\u0006\u000e\u0002\u0005\u0019>tw-A\u0003dY>\u001cX\r\u0006\u0002\u0002>\u0001")
public class CoordinatorLoaderImpl<T>
implements CoordinatorLoader<T>,
Logging {
    private final Time time;
    private final ReplicaManager replicaManager;
    private final Deserializer<T> deserializer;
    private final int loadBufferSize;
    private final AtomicBoolean isRunning;
    private final PartitionLoadScheduler scheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    private PartitionLoadScheduler scheduler() {
        return this.scheduler;
    }

    public CompletableFuture<CoordinatorLoader.LoadSummary> load(TopicPartition tp, CoordinatorPlayback<T> coordinator) {
        CompletableFuture<CoordinatorLoader.LoadSummary> future = new CompletableFuture<CoordinatorLoader.LoadSummary>();
        long startTimeMs = this.time.milliseconds();
        try {
            this.scheduler().schedule(tp.partition(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.doLoad(tp, coordinator, future, startTimeMs));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
        }
        catch (Throwable ex) {
            future.completeExceptionally(new RuntimeException("Unexpected error while scheduling loading.", ex));
        }
        return future;
    }

    private void doLoad(TopicPartition tp, CoordinatorPlayback<T> coordinator, CompletableFuture<CoordinatorLoader.LoadSummary> future, long startTimeMs) {
        block17: {
            long schedulerQueueTimeMs = this.time.milliseconds() - startTimeMs;
            try {
                Option<AbstractLog> option = this.replicaManager.getLog(tp);
                if (None$.MODULE$.equals(option)) {
                    future.completeExceptionally((Throwable)new NotLeaderOrFollowerException(new StringBuilder(60).append("Could not load records from ").append(tp).append(" because the log does not exist.").toString()));
                    break block17;
                }
                if (option instanceof Some) {
                    AbstractLog log = (AbstractLog)((Some)option).value();
                    ByteBuffer buffer = ByteBuffer.allocate(0);
                    LongRef currentOffset = LongRef.create((long)log.logStartOffset());
                    boolean readAtLeastOneRecord = true;
                    LongRef previousHighWatermark = LongRef.create((long)-1L);
                    LongRef numRecords = LongRef.create((long)0L);
                    long numBytes = 0L;
                    while (currentOffset.elem < this.logEndOffset$1(tp) && readAtLeastOneRecord && this.isRunning().get()) {
                        MemoryRecords memoryRecords;
                        AbstractFetchDataInfo abstractFetchDataInfo = log.read(currentOffset.elem, this.loadBufferSize, FetchIsolation.LOG_END, true, false);
                        if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                            throw new IllegalStateException(new StringBuilder(40).append("Unexpected tiered segment for ").append(tp).append(" partition").toString());
                        }
                        FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                        readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                        Records records = fetchDataInfo.records;
                        if (records instanceof MemoryRecords) {
                            memoryRecords = (MemoryRecords)records;
                        } else if (records instanceof FileRecords) {
                            FileRecords fileRecords = (FileRecords)records;
                            int sizeInBytes = fileRecords.sizeInBytes();
                            int bytesNeeded = Math.max(this.loadBufferSize, sizeInBytes);
                            if (buffer.capacity() < bytesNeeded) {
                                if (this.loadBufferSize < bytesNeeded) {
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Loaded metadata from ").append(tp).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured buffer size (").append($this.loadBufferSize).append(" bytes).").toString());
                                }
                                buffer = ByteBuffer.allocate(bytesNeeded);
                            } else {
                                buffer.clear();
                            }
                            fileRecords.readInto(buffer, 0);
                            memoryRecords = new MemoryRecords(buffer);
                        } else {
                            throw new MatchError((Object)records);
                        }
                        MemoryRecords memoryRecords2 = memoryRecords;
                        memoryRecords2.batches().forEach(batch -> {
                            if (batch.isControlBatch()) {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$4(this, tp, batch, coordinator, record);
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$7(this, numRecords, tp, batch, coordinator, record);
                                    return BoxedUnit.UNIT;
                                });
                            }
                            currentOffset$1.elem = batch.nextOffset();
                            long currentHighWatermark = log.highWatermark();
                            if (currentOffset$1.elem >= currentHighWatermark) {
                                coordinator.updateLastWrittenOffset(Predef$.MODULE$.long2Long(currentOffset$1.elem));
                                if (currentHighWatermark > previousHighWatermark$1.elem) {
                                    coordinator.updateLastCommittedOffset(Predef$.MODULE$.long2Long(currentHighWatermark));
                                    previousHighWatermark$1.elem = currentHighWatermark;
                                    return;
                                }
                                return;
                            }
                        });
                        numBytes += (long)memoryRecords2.sizeInBytes();
                    }
                    long endTimeMs = this.time.milliseconds();
                    if (this.logEndOffset$1(tp) == -1L) {
                        future.completeExceptionally((Throwable)new NotLeaderOrFollowerException(new StringBuilder(93).append("Stopped loading records from ").append(tp).append(" because the partition is not online or is no longer the leader.").toString()));
                    } else if (this.isRunning().get()) {
                        future.complete(new CoordinatorLoader.LoadSummary(startTimeMs, endTimeMs, schedulerQueueTimeMs, numRecords.elem, numBytes));
                    } else {
                        future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
                    }
                    break block17;
                }
                throw new MatchError(option);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
        }
    }

    public void close() {
        if (!this.isRunning().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Coordinator loader is already shutting down.");
            return;
        }
        this.scheduler().shutdown();
    }

    private final long logEndOffset$1(TopicPartition tp$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(tp$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ void $anonfun$doLoad$4(CoordinatorLoaderImpl $this, TopicPartition tp$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Record record) {
        block10: {
            block9: {
                ControlRecordType controlRecordType;
                ControlRecordType controlRecordType2;
                block8: {
                    ControlRecordType controlRecord;
                    ControlRecordType controlRecordType3 = controlRecord = ControlRecordType.parse((ByteBuffer)record.key());
                    ControlRecordType controlRecordType4 = ControlRecordType.COMMIT;
                    if (!(controlRecordType3 != null ? !controlRecordType3.equals(controlRecordType4) : controlRecordType4 != null)) {
                        if ($this.isTraceEnabled()) {
                            $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(110).append("Replaying end transaction marker from ").append(tp$2).append(" at offset ").append(record.offset()).append(" to commit transaction ").append("with producer id ").append(batch$1.producerId()).append(" and producer epoch ").append(batch$1.producerEpoch()).append(".").toString());
                        }
                        coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.COMMIT);
                        return;
                    }
                    controlRecordType2 = controlRecord;
                    controlRecordType = ControlRecordType.ABORT;
                    if (controlRecordType2 != null) break block8;
                    if (controlRecordType != null) {
                        return;
                    }
                    break block9;
                }
                if (!controlRecordType2.equals(controlRecordType)) break block10;
            }
            if ($this.isTraceEnabled()) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(109).append("Replaying end transaction marker from ").append(tp$2).append(" at offset ").append(record.offset()).append(" to abort transaction ").append("with producer id ").append(batch$1.producerId()).append(" and producer epoch ").append(batch$1.producerEpoch()).append(".").toString());
            }
            coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.ABORT);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$10(CoordinatorLoaderImpl $this, TopicPartition tp$2, Record record$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Object coordinatorRecord) {
        try {
            if ($this.isTraceEnabled()) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Replaying record ").append(coordinatorRecord).append(" from ").append(tp$2).append(" at offset ").append(record$2.offset()).append(" ").append("with producer id ").append(batch$1.producerId()).append(" and producer epoch ").append(batch$1.producerEpoch()).append(".").toString());
            }
            coordinator$2.replay(record$2.offset(), batch$1.producerId(), batch$1.producerEpoch(), coordinatorRecord);
            return;
        }
        catch (RuntimeException ex) {
            String msg = new StringBuilder(88).append("Replaying record ").append(coordinatorRecord).append(" from ").append(tp$2).append(" at offset ").append(record$2.offset()).append(" ").append("with producer id ").append(batch$1.producerId()).append(" and producer epoch ").append(batch$1.producerEpoch()).append(" ").append("failed due to: ").append(ex.getMessage()).toString();
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(msg).append(".").toString());
            throw new RuntimeException(msg, ex);
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$7(CoordinatorLoaderImpl $this, LongRef numRecords$1, TopicPartition tp$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Record record) {
        Some some;
        ++numRecords$1.elem;
        try {
            some = new Some($this.deserializer.deserialize(record.key(), record.value()));
        }
        catch (CoordinatorLoader.UnknownRecordTypeException ex) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Unknown record type ").append(ex.unknownType()).append(" while loading offsets and group metadata ").append("from ").append(tp$2).append(". Ignoring it. It could be a left over from an aborted upgrade.").toString());
            some = None$.MODULE$;
        }
        catch (RuntimeException ex) {
            String msg = new StringBuilder(43).append("Deserializing record ").append(record).append(" from ").append(tp$2).append(" failed due to: ").append(ex.getMessage()).toString();
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(msg).append(".").toString());
            throw new RuntimeException(msg, ex);
        }
        some.foreach((Function1 & Serializable)coordinatorRecord -> {
            CoordinatorLoaderImpl.$anonfun$doLoad$10($this, tp$2, record, batch$1, coordinator$2, coordinatorRecord);
            return BoxedUnit.UNIT;
        });
    }

    public CoordinatorLoaderImpl(Time time, ReplicaManager replicaManager, Deserializer<T> deserializer, int loadBufferSize, int threads) {
        this.time = time;
        this.replicaManager = replicaManager;
        this.deserializer = deserializer;
        this.loadBufferSize = loadBufferSize;
        this.isRunning = new AtomicBoolean(true);
        this.scheduler = new PartitionLoadScheduler(threads, "group-coordinator-loader-");
    }
}

