/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.util.Map;
import kafka.metrics.BrokerLoad;
import kafka.network.ProcessorTimeoutOptions;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.security.DefaultRequestCallbackManager;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class SocketServer$ {
    public static final SocketServer$ MODULE$ = new SocketServer$();
    private static final String MetricsGroup = "socket-server-metrics";
    private static final Set<String> ReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"socket.send.buffer.bytes", "max.connections.per.ip", "max.connections.per.ip.overrides", "max.connections.per.tenant", "max.connections", "max.connection.creation.rate", KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp(), "max.connections.protected.listeners", "connections.max.idle.ms"}));
    private static final Set<String> ListenerQuotaReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"max.connections", "max.connection.creation.rate", KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp(), KafkaConfig$.MODULE$.MaxConnectionRatePerIpThrottleEnableThresholdProp(), KafkaConfig$.MODULE$.ListenerConnectionRatePerIpMaxProp(), KafkaConfig$.MODULE$.ListenerConnectionRatePerIpFloorProp(), KafkaConfig$.MODULE$.ListenerConnectionRatePerIpStepProp(), "max.connection.creation.rate.per.tenant.enable.threshold", "confluent.max.connection.rate.per.tenant", "confluent.floor.connection.rate.per.tenant", "confluent.step.connection.rate.per.tenant"}));
    private static final Set<String> ListenerNonQuotaReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp(), "connections.max.idle.ms"}));

    public RequestCallback $lessinit$greater$default$7() {
        return new DefaultRequestCallbackManager();
    }

    public AuditLogProvider $lessinit$greater$default$8() {
        return NoOpAuditLogProvider.INSTANCE;
    }

    public Option<ReverseNode.ReverseCallback> $lessinit$greater$default$9() {
        return None$.MODULE$;
    }

    public Option<BrokerLoad> $lessinit$greater$default$10() {
        return None$.MODULE$;
    }

    public String MetricsGroup() {
        return MetricsGroup;
    }

    public Set<String> ReconfigurableConfigs() {
        return ReconfigurableConfigs;
    }

    public Set<String> ListenerQuotaReconfigurableConfigs() {
        return ListenerQuotaReconfigurableConfigs;
    }

    public Set<String> ListenerNonQuotaReconfigurableConfigs() {
        return ListenerNonQuotaReconfigurableConfigs;
    }

    public void closeSocket(SocketChannel channel, Logging logging) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> channel.socket().close(), logging, Level.ERROR);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> channel.close(), logging, Level.ERROR);
    }

    public ProcessorTimeoutOptions getTimeoutOptionsFromConfig(KafkaConfig config, ListenerName listenerName) {
        Map<String, Object> parsedConfigs = config.valuesWithPrefixOverride(listenerName.configPrefix());
        long connectionMaxIdleMs = BoxesRunTime.unboxToLong((Object)parsedConfigs.getOrDefault("connections.max.idle.ms", config.getLong("connections.max.idle.ms")));
        long connectionMaxAgeMs = BoxesRunTime.unboxToLong((Object)parsedConfigs.getOrDefault(KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp(), config.getLong(KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp())));
        long connectionMinCloseIntervalMs = BoxesRunTime.unboxToLong((Object)parsedConfigs.getOrDefault(KafkaConfig$.MODULE$.ConnectionMinExpireIntervalMsProp(), config.getLong(KafkaConfig$.MODULE$.ConnectionMinExpireIntervalMsProp())));
        return new ProcessorTimeoutOptions(connectionMaxIdleMs, connectionMaxAgeMs, connectionMinCloseIntervalMs);
    }

    private SocketServer$() {
    }
}

