/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.concurrent.DefaultEventExecutor;
import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.raft.CompositeRaftTracer;
import io.confluent.kafka.raft.RaftTracer;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kafka.durability.audit.manager.KRaftDurabilityAuditor$;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.raft.KRaftSnapshotMetrics;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r-v!B\"E\u0011\u0003Ie!B&E\u0011\u0003a\u0005\"B*\u0002\t\u0003!\u0006\"B+\u0002\t\u00131\u0006\"\u00028\u0002\t\u0013y\u0007BB@\u0002\t\u0013\t\t\u0001C\u0004\u0002\u0018\u0005!\t!!\u0007\u0007\u000b-#\u0005!a\t\t\u0013\u0005=sA!A!\u0002\u0013\u0019\u0007BCA\u0006\u000f\t\u0005\t\u0015!\u0003\u0002\u000e!Q\u0011\u0011K\u0004\u0003\u0002\u0003\u0006I!a\u0015\t\u0015\u0005}sA!A!\u0002\u0013\t\t\u0007\u0003\u0006\u0002p\u001d\u0011\t\u0011)A\u0005\u0003cB!\"a\u001e\b\u0005\u0003\u0005\u000b\u0011BA*\u0011)\tIh\u0002B\u0001B\u0003%\u00111\u0010\u0005\u000b\u0003\u000b;!\u0011!Q\u0001\n\u0005\u001d\u0005BCAI\u000f\t\u0005\t\u0015!\u0003\u0002\u0014\"Q\u0011\u0011T\u0004\u0003\u0006\u0004%\t!a'\t\u0015\u0005-wA!A!\u0002\u0013\ti\n\u0003\u0006\u0002N\u001e\u0011\t\u0011)A\u0005\u0003\u001fD!\"!6\b\u0005\u0003\u0005\u000b\u0011BAl\u0011)\t\to\u0002B\u0001B\u0003%\u00111\u001d\u0005\u000b\u0003_<!\u0011!Q\u0001\n\u0005E\bBB*\b\t\u0003\u00119\u0001C\u0005\u0003(\u001d\u0011\r\u0011\"\u0003\u0003*!A!qG\u0004!\u0002\u0013\u0011Y\u0003C\u0005\u0003:\u001d\u0011\r\u0011\"\u0001\u0003<!A!\u0011J\u0004!\u0002\u0013\u0011i\u0004C\u0005\u0003L\u001d\u0011\r\u0011\"\u0003\u0003N!A!QK\u0004!\u0002\u0013\u0011y\u0005C\u0005\u0003X\u001d\u0011\r\u0011\"\u0003\u0003Z!9!1L\u0004!\u0002\u0013\u0019\u0007\"\u0003B/\u000f\t\u0007I\u0011\u0002B0\u0011!\u00119g\u0002Q\u0001\n\t\u0005\u0004\"\u0003B5\u000f\t\u0007I\u0011\u0002B6\u0011!\u0011\u0019h\u0002Q\u0001\n\t5\u0004\u0002\u0003@\b\u0005\u0004%IA!\u001e\t\u000f\t]t\u0001)A\u0005/\"I!\u0011P\u0004C\u0002\u0013%!1\u0010\u0005\t\u0005\u007f:\u0001\u0015!\u0003\u0003~!I!\u0011Q\u0004C\u0002\u0013\u0005#1\u0011\u0005\t\u0005\u0017;\u0001\u0015!\u0003\u0003\u0006\"I!QR\u0004C\u0002\u0013%!q\u0012\u0005\t\u0005/;\u0001\u0015!\u0003\u0003\u0012\"I!\u0011T\u0004C\u0002\u0013%!1\u0014\u0005\t\u0005S;\u0001\u0015!\u0003\u0003\u001e\"I!1V\u0004C\u0002\u0013%!Q\u0016\u0005\t\u0005k;\u0001\u0015!\u0003\u00030\"I!qW\u0004C\u0002\u0013\u0005#\u0011\u0018\u0005\t\u0005\u0003<\u0001\u0015!\u0003\u0003<\"I!1Y\u0004C\u0002\u0013%!Q\u0019\u0005\t\u0005\u001b<\u0001\u0015!\u0003\u0003H\"I!qZ\u0004A\u0002\u0013%!\u0011\u001b\u0005\n\u0005O<\u0001\u0019!C\u0005\u0005SD\u0001Ba<\bA\u0003&!1\u001b\u0005\b\u0005c<A\u0011\u0001Bz\u0011\u001d\u0011)p\u0002C\u0001\u0005gDqAa>\b\t\u0003\u0012I\u0010C\u0004\u0004\u000e\u001d!\tea\u0004\t\u000f\r\u001ds\u0001\"\u0003\u0004J!91qK\u0004\u0005\n\re\u0003bBB.\u000f\u0011%1Q\f\u0005\b\u0007?:A\u0011BB1\u0011\u001d\u0019\u0019g\u0002C\u0005\u0007KBqa!\u001c\b\t\u0013\u0019y\u0007C\u0004\u0004\n\u001e!\tea#\t\u000f\rMu\u0001\"\u0011\u0004\u0016\u0006\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\u0006\u0003\u000b\u001a\u000bAA]1gi*\tq)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005)\u000bQ\"\u0001#\u0003!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u00148CA\u0001N!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!S\u0001\u0013GJ,\u0017\r^3M_\u001e$\u0015N]3di>\u0014\u0018\u0010F\u0002X?\u0006\u0004\"\u0001W/\u000e\u0003eS!AW.\u0002\u0005%|'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013AAR5mK\")\u0001m\u0001a\u0001/\u00061An\\4ESJDQAY\u0002A\u0002\r\f!\u0002\\8h\t&\u0014h*Y7f!\t!7N\u0004\u0002fSB\u0011amT\u0007\u0002O*\u0011\u0001\u000eS\u0001\u0007yI|w\u000e\u001e \n\u0005)|\u0015A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A[(\u0002\u00171|7m\u001b#bi\u0006$\u0015N\u001d\u000b\u0003av\u0004\"!]>\u000e\u0003IT!a\u001d;\u0002\tU$\u0018\u000e\u001c\u0006\u0003kZ\faa]3sm\u0016\u0014(BA$x\u0015\tA\u00180\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0006\u0019qN]4\n\u0005q\u0014(\u0001\u0003$jY\u0016dunY6\t\u000by$\u0001\u0019A,\u0002\u000f\u0011\fG/\u0019#je\u0006\u0011\u0002.Y:ES\u001a4WM]3oi2{w\rR5s)\u0011\t\u0019!!\u0003\u0011\u00079\u000b)!C\u0002\u0002\b=\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\f\u0015\u0001\r!!\u0004\u0002\r\r|gNZ5h!\u0011\ty!a\u0005\u000e\u0005\u0005E!BA;G\u0013\u0011\t)\"!\u0005\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u001a[\u0006L(-\u001a#fY\u0016$X-T3uC\u0012\fG/\u0019'pO\u0012K'\u000f\u0006\u0003\u0002\u001c\u0005\u0005\u0002c\u0001(\u0002\u001e%\u0019\u0011qD(\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u00171\u0001\u0019AA\u0007+\u0011\t)#!\r\u0014\r\u001di\u0015qEA\"!\u0015Q\u0015\u0011FA\u0017\u0013\r\tY\u0003\u0012\u0002\f%\u00064G/T1oC\u001e,'\u000f\u0005\u0003\u00020\u0005EB\u0002\u0001\u0003\b\u0003g9!\u0019AA\u001b\u0005\u0005!\u0016\u0003BA\u001c\u0003{\u00012ATA\u001d\u0013\r\tYd\u0014\u0002\b\u001d>$\b.\u001b8h!\rq\u0015qH\u0005\u0004\u0003\u0003z%aA!osB!\u0011QIA&\u001b\t\t9EC\u0002\u0002J\u0019\u000bQ!\u001e;jYNLA!!\u0014\u0002H\t9Aj\\4hS:<\u0017!C2mkN$XM]%e\u0003IiW\r^1eCR\fGj\\4ESJ,V/\u001b3\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017w\u0003\u0019\u0019w.\\7p]&!\u0011QLA,\u0005\u0011)V/\u001b3\u0002\u0017I,7m\u001c:e'\u0016\u0014H-\u001a\t\u0007\u0003G\nY'!\f\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nQb]3sS\u0006d\u0017N_1uS>t'bAA-i&!\u0011QNA3\u0005-\u0011VmY8sIN+'\u000fZ3\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011QKA:\u0013\u0011\t)(a\u0016\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00069Ao\u001c9jG&#\u0017\u0001\u0002;j[\u0016\u0004B!! \u0002\u00026\u0011\u0011q\u0010\u0006\u0005\u0003\u0013\n9&\u0003\u0003\u0002\u0004\u0006}$\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002\n\u00065UBAAF\u0015\u0011\t))a\u0016\n\t\u0005=\u00151\u0012\u0002\b\u001b\u0016$(/[2t\u0003M!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007p\u00149u!\u0011q\u0015QS2\n\u0007\u0005]uJ\u0001\u0004PaRLwN\\\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\ti\n\u0005\u0004\u0002 \u0006\u001d\u00161V\u0007\u0003\u0003CSA!a)\u0002&\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005M\\\u0016\u0002BAU\u0003C\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\ti+a,\u00024\u0006}VBAAS\u0013\u0011\t\t,!*\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tIlW\u0001\u0005Y\u0006tw-\u0003\u0003\u0002>\u0006]&aB%oi\u0016<WM\u001d\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*\u0019\u0011QY.\u0002\u00079,G/\u0003\u0003\u0002J\u0006\r'!E%oKR\u001cvnY6fi\u0006#GM]3tg\u0006i2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,\u0007%\u0001\tc_>$8\u000f\u001e:baN+'O^3sgB1\u0011QVAi\u0003\u007fKA!a5\u0002&\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0002\u001d1|7-\u00197MSN$XM\\3sgB!\u0011\u0011\\Ao\u001b\t\tYN\u0003\u0002Fm&!\u0011q\\An\u0005%)e\u000e\u001a9pS:$8/A\tgCR\fGNR1vYRD\u0015M\u001c3mKJ\u0004B!!:\u0002l6\u0011\u0011q\u001d\u0006\u0004\u0003S$\u0018!\u00024bk2$\u0018\u0002BAw\u0003O\u0014ABR1vYRD\u0015M\u001c3mKJ\f!\u0003^5fe>\u0013'.Z2u'R|'/Z(qiB1\u0011QVAz\u0003oLA!!>\u0002&\nAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002z\n\rQBAA~\u0015\u0011\ti0a@\u0002\u000bM$xN]3\u000b\u0007\t\u0005a)\u0001\u0003uS\u0016\u0014\u0018\u0002\u0002B\u0003\u0003w\u0014q\u0002V5fe>\u0013'.Z2u'R|'/\u001a\u000b\u001f\u0005\u0013\u0011YA!\u0004\u0003\u0010\tE!1\u0003B\u000b\u0005/\u0011IBa\u0007\u0003\u001e\t}!\u0011\u0005B\u0012\u0005K\u0001BAS\u0004\u0002.!1\u0011qJ\fA\u0002\rDq!a\u0003\u0018\u0001\u0004\ti\u0001C\u0004\u0002R]\u0001\r!a\u0015\t\u000f\u0005}s\u00031\u0001\u0002b!9\u0011qN\fA\u0002\u0005E\u0004bBA</\u0001\u0007\u00111\u000b\u0005\b\u0003s:\u0002\u0019AA>\u0011\u001d\t)i\u0006a\u0001\u0003\u000fCq!!%\u0018\u0001\u0004\t\u0019\nC\u0004\u0002\u001a^\u0001\r!!(\t\u000f\u00055w\u00031\u0001\u0002P\"9\u0011Q[\fA\u0002\u0005]\u0007bBAq/\u0001\u0007\u00111\u001d\u0005\b\u0003_<\u0002\u0019AAy\u0003\u0019\u0019Gn\\:fIV\u0011!1\u0006\t\u0005\u0005[\u0011\u0019$\u0004\u0002\u00030)!!\u0011GAQ\u0003\u0019\tGo\\7jG&!!Q\u0007B\u0018\u00055\tEo\\7jG\n{w\u000e\\3b]\u000691\r\\8tK\u0012\u0004\u0013aC1qSZ+'o]5p]N,\"A!\u0010\u0011\t\t}\"QI\u0007\u0003\u0005\u0003R1Aa\u0011w\u0003\u001d\u0019G.[3oiNLAAa\u0012\u0003B\tY\u0011\t]5WKJ\u001c\u0018n\u001c8t\u00031\t\u0007/\u001b,feNLwN\\:!\u0003)\u0011\u0018M\u001a;D_:4\u0017nZ\u000b\u0003\u0005\u001f\u0002B!!7\u0003R%!!1KAn\u00051\tVo\u001c:v[\u000e{gNZ5h\u0003-\u0011\u0018M\u001a;D_:4\u0017n\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&DX#A2\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"A!\u0019\u0011\t\u0005u$1M\u0005\u0005\u0005K\nyH\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0005[\u00022!\u001dB8\u0013\r\u0011\tH\u001d\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u000b\u0002/\u0006AA-\u0019;b\t&\u0014\b%A\u0006eCR\fG)\u001b:M_\u000e\\WC\u0001B?!\u0011q\u0015Q\u00139\u0002\u0019\u0011\fG/\u0019#je2{7m\u001b\u0011\u0002\u001bI,\u0007\u000f\\5dCR,G\rT8h+\t\u0011)\t\u0005\u0003\u0002Z\n\u001d\u0015\u0002\u0002BE\u00037\u0014QBU3qY&\u001c\u0017\r^3e\u0019><\u0017A\u0004:fa2L7-\u0019;fI2{w\rI\u0001\u000b]\u0016$8\t[1o]\u0016dWC\u0001BI!\u0011\tINa%\n\t\tU\u00151\u001c\u0002\u0014\u0017\u000647.\u0019(fi^|'o[\"iC:tW\r\\\u0001\f]\u0016$8\t[1o]\u0016d\u0007%A\bfqBL'/\u0019;j_:$\u0016.\\3s+\t\u0011i\n\u0005\u0003\u0003 \n\u0015VB\u0001BQ\u0015\r\u0011\u0019K]\u0001\u0006i&lWM]\u0005\u0005\u0005O\u0013\tKA\u0006TsN$X-\u001c+j[\u0016\u0014\u0018\u0001E3ya&\u0014\u0018\r^5p]RKW.\u001a:!\u0003E)\u0007\u0010]5sCRLwN\\*feZL7-Z\u000b\u0003\u0005_\u00032A\u0013BY\u0013\r\u0011\u0019\f\u0012\u0002\u001d)&l\u0017N\\4XQ\u0016,G.\u0012=qSJ\fG/[8o'\u0016\u0014h/[2f\u0003I)\u0007\u0010]5sCRLwN\\*feZL7-\u001a\u0011\u0002\r\rd\u0017.\u001a8u+\t\u0011Y\f\u0005\u0004\u0002Z\nu\u0016QF\u0005\u0005\u0005\u007f\u000bYNA\bLC\u001a\\\u0017MU1gi\u000ec\u0017.\u001a8u\u0003\u001d\u0019G.[3oi\u0002\nAb\u00197jK:$HI]5wKJ,\"Aa2\u0011\r\u0005e'\u0011ZA\u0017\u0013\u0011\u0011Y-a7\u0003+-\u000bgm[1SC\u001a$8\t\\5f]R$%/\u001b<fe\u0006i1\r\\5f]R$%/\u001b<fe\u0002\n\u0001\"\u001a=fGV$xN]\u000b\u0003\u0005'\u0004RATAK\u0005+\u0004BAa6\u0003d6\u0011!\u0011\u001c\u0006\u0005\u0003G\u0013YNC\u0002H\u0005;TAAa8\u0003b\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u00025&!!Q\u001dBm\u00055)e/\u001a8u\u000bb,7-\u001e;pe\u0006aQ\r_3dkR|'o\u0018\u0013fcR!\u00111\u0004Bv\u0011%\u0011i/NA\u0001\u0002\u0004\u0011\u0019.A\u0002yIE\n\u0011\"\u001a=fGV$xN\u001d\u0011\u0002\u000fM$\u0018M\u001d;vaR\u0011\u00111D\u0001\tg\",H\u000fZ8x]\u0006A!/Z4jgR,'\u000f\u0006\u0003\u0002\u001c\tm\bb\u0002B\u007fs\u0001\u0007!q`\u0001\tY&\u001cH/\u001a8feB11\u0011AB\u0004\u0003[qA!!7\u0004\u0004%!1QAAn\u0003)\u0011\u0016M\u001a;DY&,g\u000e^\u0005\u0005\u0007\u0013\u0019YA\u0001\u0005MSN$XM\\3s\u0015\u0011\u0019)!a7\u0002\u001b!\fg\u000e\u001a7f%\u0016\fX/Z:u))\u0019\tba\b\u00040\re2Q\b\t\u0007\u0003?\u000b9ka\u0005\u0011\t\rU11D\u0007\u0003\u0007/QAa!\u0007\u0002X\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0004\u001e\r]!AC!qS6+7o]1hK\"91\u0011\u0005\u001eA\u0002\r\r\u0012aB2p]R,\u0007\u0010\u001e\t\u0005\u0007K\u0019Y#\u0004\u0002\u0004()!1\u0011FA,\u0003!\u0011X-];fgR\u001c\u0018\u0002BB\u0017\u0007O\u0011aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u00042i\u0002\raa\r\u0002\r!,\u0017\rZ3s!\u0011\u0019)c!\u000e\n\t\r]2q\u0005\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000f\rm\"\b1\u0001\u0004\u0014\u00059!/Z9vKN$\bbBB u\u0001\u00071\u0011I\u0001\u000eGJ,\u0017\r^3e)&lW-T:\u0011\u00079\u001b\u0019%C\u0002\u0004F=\u0013A\u0001T8oO\u0006iR.Y=cK\n+\u0018\u000e\u001c3SC\u001a$8K\\1qg\"|G/T1oC\u001e,'\u000f\u0006\u0002\u0004LA)a*!&\u0004NA!1qJB*\u001b\t\u0019\tFC\u0002F\u0003\u007fLAa!\u0016\u0004R\t!2JU1giNs\u0017\r]:i_Rl\u0015M\\1hKJ\fqBY;jY\u0012\u0014\u0016M\u001a;DY&,g\u000e\u001e\u000b\u0003\u0005w\u000b1CY;jY\u0012tU\r^<pe.\u001c\u0005.\u00198oK2$\"A!%\u0002\u001b\r\u0014X-\u0019;f\t\u0006$\u0018\rR5s)\u00059\u0016\u0001\u00052vS2$W*\u001a;bI\u0006$\u0018\rT8h)\t\u00199\u0007E\u0002K\u0007SJ1aa\u001bE\u0005AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w-\u0001\nck&dGMT3uo>\u00148n\u00117jK:$HCAB9!\u001dq51OB<\u0007\u0007K1a!\u001eP\u0005\u0019!V\u000f\u001d7feA!1\u0011PB@\u001b\t\u0019YH\u0003\u0003\u0004~\u0005]\u0013a\u00028fi^|'o[\u0005\u0005\u0007\u0003\u001bYH\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0003@\r\u0015\u0015\u0002BBD\u0005\u0003\u0012QBT3uo>\u00148n\u00117jK:$\u0018A\u00047fC\u0012,'/\u00118e\u000bB|7\r[\u000b\u0003\u0007\u001b\u0003B!!7\u0004\u0010&!1\u0011SAn\u00059aU-\u00193fe\u0006sG-\u00129pG\"\f\u0011B^8uKJtu\u000eZ3\u0015\r\r]5qTBU!\u0015q\u0015QSBM!\u0011\t)fa'\n\t\ru\u0015q\u000b\u0002\u0005\u001d>$W\rC\u0004\u0004\"\n\u0003\raa)\u0002\u0005%$\u0007c\u0001(\u0004&&\u00191qU(\u0003\u0007%sG\u000fC\u0004\u0003~\n\u0003\raa\u001e")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final Endpoints localListeners;
    private final Optional<TierObjectStore> tierObjectStoreOpt;
    private final AtomicBoolean closed;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Option<EventExecutor> executor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void maybeDeleteMetadataLogDir(KafkaConfig config) {
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    private Option<EventExecutor> executor() {
        return this.executor;
    }

    private void executor_$eq(Option<EventExecutor> x$1) {
        this.executor = x$1;
    }

    public void startup() {
        this.client().initialize(this.controllerQuorumVotersFuture().get(), (QuorumStateStore)new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        if (!this.closed().getAndSet(true)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationTimer().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.clientDriver().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.client().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.netChannel().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.replicatedLog().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$3 -> {
                x$3.destroy();
                return BoxedUnit.UNIT;
            }), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.executor().foreach((Function1 & Serializable)x$4 -> x$4.shutdown()), this, Level.WARN);
            return;
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestContext context, RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(context, header, request, createdTimeMs);
    }

    private Option<KRaftSnapshotManager> maybeBuildRaftSnapshotManager() {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return None$.MODULE$;
        }
        if (!this.config.processRoles().contains((Object)ProcessRole.ControllerRole)) {
            return None$.MODULE$;
        }
        if (!this.tierObjectStoreOpt.isPresent()) {
            throw new ConfigException(new StringBuilder(45).append("tier.enable is set to ").append(this.config.confluentConfig().tierEnable()).append(", should be set to true").toString());
        }
        Function<TopicIdPartition, Optional<Path>> topicIdPath = tpId -> {
            TopicIdPartition topicIdPartition = tpId;
            TopicIdPartition topicIdPartition2 = new TopicIdPartition(KafkaRaftServer$.MODULE$.MetadataTopicId(), KafkaRaftServer$.MODULE$.MetadataPartition());
            if (topicIdPartition != null && topicIdPartition.equals(topicIdPartition2)) {
                TopicPartition logDirName_topicPartition = $this.topicPartition;
                Object var3_3 = null;
                return Optional.of(new File($this.config.metadataLogDir(), LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toPath());
            }
            return Optional.empty();
        };
        int pendingTasksCapacity = 1024;
        this.executor_$eq((Option<EventExecutor>)new Some((Object)new DefaultEventExecutor(Executors.defaultThreadFactory(), pendingTasksCapacity)));
        return new Some((Object)KRaftSnapshotManager.create((EventExecutor)this.executor().get(), this.tierObjectStoreOpt.get(), new KRaftSnapshotMetrics(this.metrics), this.logContext(), topicIdPath, this.clusterId, this.config.nodeId(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteEnableFlag(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteRetentionMs(), this.time));
    }

    private KafkaRaftClient<T> buildRaftClient() {
        ObjectRef tracers = ObjectRef.create((Object)new .colon.colon((Object)KRaftDurabilityAuditor$.MODULE$, (List)Nil$.MODULE$));
        this.maybeBuildRaftSnapshotManager().foreach((Function1 & Serializable)snapshotTracer -> {
            tracers.elem = ((List)tracers.elem).$colon$colon((Object)snapshotTracer);
            return BoxedUnit.UNIT;
        });
        return new KafkaRaftClient(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), this.time, (ExpirationService)this.expirationService(), this.logContext(), this.config.processRoles().contains((Object)ProcessRole.ControllerRole), this.clusterId, this.bootstrapServers, this.localListeners, Features.KRAFT_VERSION.supportedVersionRange(), this.raftConfig(), (RaftTracer)new CompositeRaftTracer(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)tracers.elem)).asJava(), this.logContext()));
    }

    /*
     * WARNING - void declaration
     */
    private KafkaNetworkChannel buildNetworkChannel() {
        void var3_3;
        void var2_2;
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)tuple2._1();
        NetworkClient netClient = (NetworkClient)tuple2._2();
        return new KafkaNetworkChannel(this.time, (ListenerName)var2_2, (KafkaClient)var3_3, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.metrics, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000), x$6 -> this.client().traceLogStartOffsetChange(), x$7 -> this.client().traceLogSnapshotGeneration());
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        void clientChannelBuilder_logContext;
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        void clientChannelBuilder_config;
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        SecurityProtocol controllerSecurityProtocol = (SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()));
        LogContext logContext = this.logContext();
        boolean bl = this.config.saslInterBrokerHandshakeRequestEnable();
        Time time = this.time;
        String string = this.config.saslMechanismControllerProtocol();
        KafkaConfig kafkaConfig = this.config;
        JaasContext.Type clientChannelBuilder_contextType = JaasContext.Type.SERVER;
        Object var13_8 = null;
        kafkaConfig = null;
        string = null;
        time = null;
        logContext = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerSecurityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientChannelBuilder_config, (ListenerName)controllerListenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)clientChannelBuilder_logContext, null, null);
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2((Object)controllerListenerName, (Object)networkClient);
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    @Override
    public Option<Node> voterNode(int id, ListenerName listener) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.client().voterNode(id, listener)));
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, Endpoints localListeners, FaultHandler fatalFaultHandler, Optional<TierObjectStore> tierObjectStoreOpt) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.localListeners = localListeners;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.closed = new AtomicBoolean(false);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), false);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
        this.executor = None$.MODULE$;
    }
}

