/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import kafka.server.ControllerRegistrationManager$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ControllerRegistrationRequest;
import org.apache.kafka.common.requests.ControllerRegistrationResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.ListenerInfo;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\teg\u0001\u0002$H\u00011C\u0001B\u001a\u0001\u0003\u0006\u0004%\ta\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005Q\"AA\u000e\u0001BC\u0002\u0013\u0005Q\u000e\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003o\u0011!Q\bA!b\u0001\n\u0003Y\b\"CA\u0004\u0001\t\u0005\t\u0015!\u0003}\u0011%\tI\u0001\u0001BC\u0002\u0013\u0005Q\u000eC\u0005\u0002\f\u0001\u0011\t\u0011)A\u0005]\"Q\u0011Q\u0002\u0001\u0003\u0006\u0004%\t!a\u0004\t\u0015\u00055\u0002A!A!\u0002\u0013\t\t\u0002\u0003\u0006\u00020\u0001\u0011)\u0019!C\u0001\u0003cA!\"!\u000f\u0001\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011)\tY\u0004\u0001BC\u0002\u0013\u0005\u0011Q\b\u0005\u000b\u0003\u000f\u0002!\u0011!Q\u0001\n\u0005}\u0002BCA%\u0001\t\u0015\r\u0011\"\u0001\u0002L!Q\u00111\u000b\u0001\u0003\u0002\u0003\u0006I!!\u0014\t\u0015\u0005U\u0003A!b\u0001\n\u0003\t9\u0006\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u00033B!\"!\u0019\u0001\u0005\u000b\u0007I\u0011AA2\u0011)\t9\b\u0001B\u0001B\u0003%\u0011Q\r\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t)\n\u0001C!\u0003/Cq!!'\u0001\t\u0013\t9\nC\u0005\u0002\u001c\u0002\u0011\r\u0011\"\u0001\u0002\u001e\"A\u0011Q\u0015\u0001!\u0002\u0013\ty\nC\u0005\u0002(\u0002\u0001\r\u0011\"\u0001\u00022!I\u0011\u0011\u0016\u0001A\u0002\u0013\u0005\u00111\u0016\u0005\t\u0003o\u0003\u0001\u0015)\u0003\u00024!I\u0011\u0011\u0018\u0001A\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u0007\u0004\u0001\u0019!C\u0001\u0003\u000bD\u0001\"!3\u0001A\u0003&\u0011Q\u0018\u0005\n\u0003\u0017\u0004\u0001\u0019!C\u0001\u0003wC\u0011\"!4\u0001\u0001\u0004%\t!a4\t\u0011\u0005M\u0007\u0001)Q\u0005\u0003{C\u0011\"!6\u0001\u0001\u0004%I!a6\t\u0013\u0005\u0015\b\u00011A\u0005\n\u0005\u001d\b\u0002CAv\u0001\u0001\u0006K!!7\t\u0013\u00055\b\u00011A\u0005\u0002\u0005E\u0002\"CAx\u0001\u0001\u0007I\u0011AAy\u0011!\t)\u0010\u0001Q!\n\u0005M\u0002bCA|\u0001\u0001\u0007\t\u0019!C\u0005\u0003sD1Ba\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0006!Y!\u0011\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA~\u0011)\u0011Y\u0001\u0001b\u0001\n\u00039%Q\u0002\u0005\t\u00057\u0001\u0001\u0015!\u0003\u0003\u0010\u00191!Q\u0004\u0001\u0005\u0005?Aq!!\u001f/\t\u0003\u0011Y\u0004C\u0004\u0003B9\"\tEa\u0011\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003H!9!Q\n\u0001\u0005\u0002\t\r\u0003b\u0002B(\u0001\u0011\u0005#1\t\u0005\b\u0005#\u0002A\u0011\tB*\r\u0019\u0011Y\b\u0001\u0003\u0003~!Q!qK\u001b\u0003\u0002\u0003\u0006IA!\u0017\t\u0015\t\rTG!A!\u0002\u0013\u0011)\u0007C\u0004\u0002zU\"\tAa \t\u000f\t\u0005S\u0007\"\u0011\u0003D!9!q\u0011\u0001\u0005\n\t\r\u0003b\u0002BE\u0001\u0011%!1\t\u0004\u0007\u0005\u0017\u0003AA!$\t\u000f\u0005eD\b\"\u0001\u0003\u0016\"9!\u0011\u0014\u001f\u0005B\tm\u0005b\u0002BWy\u0011\u0005#1\t\u0005\b\u0005_\u0003A\u0011\u0002B\"\u0011\u001d\u0011\t\f\u0001C\u0005\u0005g;\u0011B!/H\u0003\u0003E\tAa/\u0007\u0011\u0019;\u0015\u0011!E\u0001\u0005{Cq!!\u001fD\t\u0003\u0011y\fC\u0005\u0003B\u000e\u000b\n\u0011\"\u0001\u0003D\ni2i\u001c8ue>dG.\u001a:SK\u001eL7\u000f\u001e:bi&|g.T1oC\u001e,'O\u0003\u0002I\u0013\u000611/\u001a:wKJT\u0011AS\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001QjU-\u0011\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\r\u0005s\u0017PU3g!\t!v+D\u0001V\u0015\t1\u0016*A\u0003vi&d7/\u0003\u0002Y+\n9Aj\\4hS:<\u0007C\u0001.e\u001b\u0005Y&B\u0001/^\u0003%\u0001XO\u00197jg\",'O\u0003\u0002_?\u0006)\u0011.\\1hK*\u0011!\n\u0019\u0006\u0003C\n\fa!\u00199bG\",'\"A2\u0002\u0007=\u0014x-\u0003\u0002f7\n\tR*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0002\r9|G-Z%e+\u0005A\u0007C\u0001(j\u0013\tQwJA\u0002J]R\fqA\\8eK&#\u0007%A\u0005dYV\u001cH/\u001a:JIV\ta\u000e\u0005\u0002pm:\u0011\u0001\u000f\u001e\t\u0003c>k\u0011A\u001d\u0006\u0003g.\u000ba\u0001\u0010:p_Rt\u0014BA;P\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U|\u0015AC2mkN$XM]%eA\u0005!A/[7f+\u0005a\bcA?\u0002\u00045\taP\u0003\u0002W\u007f*\u0019\u0011\u0011A0\u0002\r\r|W.\\8o\u0013\r\t)A \u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq\u0006\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002#M,\b\u000f]8si\u0016$g)Z1ukJ,7/\u0006\u0002\u0002\u0012A9\u00111CA\u000f]\u0006\u0005RBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u00037\tAA[1wC&!\u0011qDA\u000b\u0005\ri\u0015\r\u001d\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE0\u0002\u00115,G/\u00193bi\u0006LA!a\u000b\u0002&\taa+\u001a:tS>t'+\u00198hK\u0006\u00112/\u001e9q_J$X\r\u001a$fCR,(/Z:!\u0003IQ8.T5he\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0016\u0005\u0005M\u0002c\u0001(\u00026%\u0019\u0011qG(\u0003\u000f\t{w\u000e\\3b]\u0006\u0019\"p['jOJ\fG/[8o\u000b:\f'\r\\3eA\u0005i\u0011N\\2be:\fG/[8o\u0013\u0012,\"!a\u0010\u0011\t\u0005\u0005\u00131I\u0007\u0002\u007f&\u0019\u0011QI@\u0003\tU+\u0018\u000eZ\u0001\u000fS:\u001c\u0017M\u001d8bi&|g.\u00133!\u00031a\u0017n\u001d;f]\u0016\u0014\u0018J\u001c4p+\t\ti\u0005\u0005\u0003\u0002$\u0005=\u0013\u0002BA)\u0003K\u0011A\u0002T5ti\u0016tWM]%oM>\fQ\u0002\\5ti\u0016tWM]%oM>\u0004\u0013\u0001\u0007:fg\u0016tG-\u0012=q_:,g\u000e^5bY\n\u000b7m[8gMV\u0011\u0011\u0011\f\t\u0004{\u0006m\u0013bAA/}\n\u0011R\t\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g\u0003e\u0011Xm]3oI\u0016C\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\u0011\u0002O\r,(O]3oi6+G/\u00193bi\u0006,en\u0019:zaR|'OR1di>\u0014\u0018pU;qa2LWM]\u000b\u0003\u0003K\u0002b!a\u001a\u0002n\u0005ETBAA5\u0015\u0011\tY'!\u0006\u0002\u0011\u0019,hn\u0019;j_:LA!a\u001c\u0002j\tA1+\u001e9qY&,'\u000f\u0005\u0003\u0002$\u0005M\u0014\u0002BA;\u0003K\u0011\u0001$T3uC\u0012\fG/Y#oGJL\b\u000f^8s\r\u0006\u001cGo\u001c:z\u0003!\u001aWO\u001d:f]RlU\r^1eCR\fWI\\2ssB$xN\u001d$bGR|'/_*vaBd\u0017.\u001a:!\u0003\u0019a\u0014N\\5u}Q1\u0012QPAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019\nE\u0002\u0002\u0000\u0001i\u0011a\u0012\u0005\u0006MV\u0001\r\u0001\u001b\u0005\u0006YV\u0001\rA\u001c\u0005\u0006uV\u0001\r\u0001 \u0005\u0007\u0003\u0013)\u0002\u0019\u00018\t\u000f\u00055Q\u00031\u0001\u0002\u0012!9\u0011qF\u000bA\u0002\u0005M\u0002bBA\u001e+\u0001\u0007\u0011q\b\u0005\b\u0003\u0013*\u0002\u0019AA'\u0011%\t)&\u0006I\u0001\u0002\u0004\tI\u0006C\u0004\u0002bU\u0001\r!!\u001a\u0002\t9\fW.\u001a\u000b\u0002]\u0006IAn\\4Qe\u00164\u0017\u000e_\u0001\u000bY><7i\u001c8uKb$XCAAP!\ri\u0018\u0011U\u0005\u0004\u0003Gs(A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003)\u0001XM\u001c3j]\u001e\u0014\u0006oY\u0001\u000fa\u0016tG-\u001b8h%B\u001cw\fJ3r)\u0011\ti+a-\u0011\u00079\u000by+C\u0002\u00022>\u0013A!\u00168ji\"I\u0011QW\u000e\u0002\u0002\u0003\u0007\u00111G\u0001\u0004q\u0012\n\u0014a\u00039f]\u0012Lgn\u001a*qG\u0002\nab];dG\u0016\u001c8OZ;m%B\u001c7/\u0006\u0002\u0002>B\u0019a*a0\n\u0007\u0005\u0005wJ\u0001\u0003M_:<\u0017AE:vG\u000e,7o\u001d4vYJ\u00038m]0%KF$B!!,\u0002H\"I\u0011Q\u0017\u0010\u0002\u0002\u0003\u0007\u0011QX\u0001\u0010gV\u001c7-Z:tMVd'\u000b]2tA\u0005Qa-Y5mK\u0012\u0014\u0006oY:\u0002\u001d\u0019\f\u0017\u000e\\3e%B\u001c7o\u0018\u0013fcR!\u0011QVAi\u0011%\t),IA\u0001\u0002\u0004\ti,A\u0006gC&dW\r\u001a*qGN\u0004\u0013aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005e\u0007\u0003BAn\u0003Cl!!!8\u000b\t\u0005\u0005\u0011q\u001c\u0006\u0003\u0011~KA!a9\u0002^\nyQ*\u001a;bI\u0006$\u0018MV3sg&|g.A\nnKR\fG-\u0019;b-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002.\u0006%\b\"CA[I\u0005\u0005\t\u0019AAm\u0003AiW\r^1eCR\fg+\u001a:tS>t\u0007%A\bsK\u001eL7\u000f^3sK\u0012Le\u000eT8h\u0003M\u0011XmZ5ti\u0016\u0014X\rZ%o\u0019><w\fJ3r)\u0011\ti+a=\t\u0013\u0005Uv%!AA\u0002\u0005M\u0012\u0001\u0005:fO&\u001cH/\u001a:fI&sGj\\4!\u0003=y6\r[1o]\u0016dW*\u00198bO\u0016\u0014XCAA~!\u0011\ti0a@\u000e\u0005\u0005}\u0017\u0002\u0002B\u0001\u0003?\u0014aDT8eKR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002'}\u001b\u0007.\u00198oK2l\u0015M\\1hKJ|F%Z9\u0015\t\u00055&q\u0001\u0005\n\u0003kS\u0013\u0011!a\u0001\u0003w\f\u0001cX2iC:tW\r\\'b]\u0006<WM\u001d\u0011\u0002\u0015\u00154XM\u001c;Rk\u0016,X-\u0006\u0002\u0003\u0010A!!\u0011\u0003B\f\u001b\t\u0011\u0019BC\u0002\u0003\u0016}\u000bQ!];fk\u0016LAA!\u0007\u0003\u0014\ty1*\u00194lC\u00163XM\u001c;Rk\u0016,X-A\u0006fm\u0016tG/U;fk\u0016\u0004#!D*ikR$wn\u001e8Fm\u0016tGoE\u0003/\u0005C\u0011i\u0003\u0005\u0003\u0003$\t%RB\u0001B\u0013\u0015\u0011\u00119#!\u0007\u0002\t1\fgnZ\u0005\u0005\u0005W\u0011)C\u0001\u0004PE*,7\r\u001e\t\u0005\u0005_\u0011)D\u0004\u0003\u0003\u0012\tE\u0012\u0002\u0002B\u001a\u0005'\t!\"\u0012<f]R\fV/Z;f\u0013\u0011\u00119D!\u000f\u0003\u000b\u00153XM\u001c;\u000b\t\tM\"1\u0003\u000b\u0003\u0005{\u00012Aa\u0010/\u001b\u0005\u0001\u0011a\u0001:v]R\u0011\u0011QV\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003[\u0013I\u0005C\u0004\u0003LE\u0002\r!a?\u0002\u001d\rD\u0017M\u001c8fY6\u000bg.Y4fe\u0006i!-Z4j]NCW\u000f\u001e3po:\fQa\u00197pg\u0016\f\u0001c\u001c8NKR\fG-\u0019;b+B$\u0017\r^3\u0015\u0011\u00055&Q\u000bB1\u0005WBqAa\u00165\u0001\u0004\u0011I&A\u0003eK2$\u0018\r\u0005\u0003\u0003\\\tuS\"A/\n\u0007\t}SLA\u0007NKR\fG-\u0019;b\t\u0016dG/\u0019\u0005\b\u0005G\"\u0004\u0019\u0001B3\u0003!qWm^%nC\u001e,\u0007\u0003\u0002B.\u0005OJ1A!\u001b^\u00055iU\r^1eCR\f\u0017*\\1hK\"9!Q\u000e\u001bA\u0002\t=\u0014\u0001C7b]&4Wm\u001d;\u0011\t\tE$qO\u0007\u0003\u0005gR1A!\u001e^\u0003\u0019aw.\u00193fe&!!\u0011\u0010B:\u00059au.\u00193fe6\u000bg.\u001b4fgR\u00141#T3uC\u0012\fG/Y+qI\u0006$X-\u0012<f]R\u001cR!\u000eB\u0011\u0005[!bA!!\u0003\u0004\n\u0015\u0005c\u0001B k!9!q\u000b\u001dA\u0002\te\u0003b\u0002B2q\u0001\u0007!QM\u0001 [\u0006L(-Z*f]\u0012\u001cuN\u001c;s_2dWM\u001d*fO&\u001cHO]1uS>t\u0017AG:f]\u0012\u001cuN\u001c;s_2dWM\u001d*fO&\u001cHO]1uS>t'a\u0007*fO&\u001cHO]1uS>t'+Z:q_:\u001cX\rS1oI2,'oE\u0003=\u0005C\u0011y\t\u0005\u0003\u0002~\nE\u0015\u0002\u0002BJ\u0003?\u0014!eQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014HC\u0001BL!\r\u0011y\u0004P\u0001\u000b_:\u001cu.\u001c9mKR,G\u0003BAW\u0005;CqAa(?\u0001\u0004\u0011\t+\u0001\u0005sKN\u0004xN\\:f!\u0011\u0011\u0019K!+\u000e\u0005\t\u0015&b\u0001BT?\u000691\r\\5f]R\u001c\u0018\u0002\u0002BV\u0005K\u0013ab\u00117jK:$(+Z:q_:\u001cX-A\u0005p]RKW.Z8vi\u0006)3o\u00195fIVdWMT3yi\u000e{W.\\;oS\u000e\fG/[8o\u0003\u001a$XM\u001d$bS2,(/Z\u0001\u001ag\u000eDW\rZ;mK:+\u0007\u0010^\"p[6,h.[2bi&|g\u000e\u0006\u0003\u0002.\nU\u0006b\u0002B\\\u0003\u0002\u0007\u0011QX\u0001\u000bS:$XM\u001d<bY6\u001b\u0018!H\"p]R\u0014x\u000e\u001c7feJ+w-[:ue\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007\u0005}4i\u0005\u0002D\u001bR\u0011!1X\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t\u0015'\u0006BA-\u0005\u000f\\#A!3\u0011\t\t-'Q[\u0007\u0003\u0005\u001bTAAa4\u0003R\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005'|\u0015AC1o]>$\u0018\r^5p]&!!q\u001bBg\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ControllerRegistrationManager
implements Logging,
MetadataPublisher {
    private final int nodeId;
    private final String clusterId;
    private final Time time;
    private final String threadNamePrefix;
    private final Map<String, VersionRange> supportedFeatures;
    private final boolean zkMigrationEnabled;
    private final Uuid incarnationId;
    private final ListenerInfo listenerInfo;
    private final ExponentialBackoff resendExponentialBackoff;
    private final Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier;
    private final LogContext logContext;
    private boolean pendingRpc;
    private long successfulRpcs;
    private long failedRpcs;
    private MetadataVersion kafka$server$ControllerRegistrationManager$$metadataVersion;
    private boolean registeredInLog;
    private NodeToControllerChannelManager kafka$server$ControllerRegistrationManager$$_channelManager;
    private final KafkaEventQueue eventQueue;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ExponentialBackoff $lessinit$greater$default$9() {
        return ControllerRegistrationManager$.MODULE$.$lessinit$greater$default$9();
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Time time() {
        return this.time;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public boolean zkMigrationEnabled() {
        return this.zkMigrationEnabled;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public ListenerInfo listenerInfo() {
        return this.listenerInfo;
    }

    public ExponentialBackoff resendExponentialBackoff() {
        return this.resendExponentialBackoff;
    }

    public Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier() {
        return this.currentMetadataEncryptorFactorySupplier;
    }

    public String name() {
        return "ControllerRegistrationManager";
    }

    private String logPrefix() {
        StringBuilder builder = new StringBuilder("[ControllerRegistrationManager");
        builder.append(" id=").append(this.nodeId());
        builder.append(" incarnation=").append((Object)this.incarnationId());
        builder.append("] ");
        return builder.toString();
    }

    public LogContext logContext() {
        return this.logContext;
    }

    public boolean pendingRpc() {
        return this.pendingRpc;
    }

    public void pendingRpc_$eq(boolean x$1) {
        this.pendingRpc = x$1;
    }

    public long successfulRpcs() {
        return this.successfulRpcs;
    }

    public void successfulRpcs_$eq(long x$1) {
        this.successfulRpcs = x$1;
    }

    public long failedRpcs() {
        return this.failedRpcs;
    }

    public void failedRpcs_$eq(long x$1) {
        this.failedRpcs = x$1;
    }

    private MetadataVersion metadataVersion() {
        return this.kafka$server$ControllerRegistrationManager$$metadataVersion;
    }

    public void kafka$server$ControllerRegistrationManager$$metadataVersion_$eq(MetadataVersion x$1) {
        this.kafka$server$ControllerRegistrationManager$$metadataVersion = x$1;
    }

    public boolean registeredInLog() {
        return this.registeredInLog;
    }

    public void registeredInLog_$eq(boolean x$1) {
        this.registeredInLog = x$1;
    }

    public NodeToControllerChannelManager kafka$server$ControllerRegistrationManager$$_channelManager() {
        return this.kafka$server$ControllerRegistrationManager$$_channelManager;
    }

    public void kafka$server$ControllerRegistrationManager$$_channelManager_$eq(NodeToControllerChannelManager x$1) {
        this.kafka$server$ControllerRegistrationManager$$_channelManager = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    /*
     * WARNING - void declaration
     */
    public void start(NodeToControllerChannelManager channelManager) {
        void append_event;
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        EventQueue.Event event = () -> {
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> "initialized channel manager.");
                this.kafka$server$ControllerRegistrationManager$$_channelManager_$eq(channelManager);
                this.kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
                return;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "start error", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        };
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (Function)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)append_event);
    }

    public void beginShutdown() {
        this.eventQueue().beginShutdown("beginShutdown");
    }

    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    /*
     * WARNING - void declaration
     */
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        if (delta.featuresDelta() != null || delta.clusterDelta() != null && delta.clusterDelta().changedControllers().containsKey(BoxesRunTime.boxToInteger((int)this.nodeId()))) {
            void append_event;
            KafkaEventQueue kafkaEventQueue = this.eventQueue();
            MetadataUpdateEvent metadataUpdateEvent = new MetadataUpdateEvent(this, delta, newImage);
            if (kafkaEventQueue == null) {
                throw null;
            }
            kafkaEventQueue.enqueue(EventQueue.EventInsertionType.APPEND, null, (Function)EventQueue.NoDeadlineFunction.INSTANCE, (EventQueue.Event)append_event);
            return;
        }
    }

    public void kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration() {
        if (this.registeredInLog()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "maybeSendControllerRegistration: controller is already registered.");
            return;
        }
        if (this.kafka$server$ControllerRegistrationManager$$_channelManager() == null) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "maybeSendControllerRegistration: cannot register yet because the channel manager has not been initialized.");
            return;
        }
        if (!this.metadataVersion().isControllerRegistrationSupported()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(148).append("maybeSendControllerRegistration: cannot register yet because the metadata.version is ").append("still ").append(this.metadataVersion()).append(", which does not support KIP-919 controller registration.").toString());
            return;
        }
        if (this.pendingRpc()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "maybeSendControllerRegistration: waiting for the previous RPC to complete.");
            return;
        }
        this.sendControllerRegistration();
    }

    private void sendControllerRegistration() {
        ControllerRegistrationRequestData.FeatureCollection features = new ControllerRegistrationRequestData.FeatureCollection();
        CollectionConverters$.MODULE$.MapHasAsScala(this.supportedFeatures()).asScala().foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerRegistrationManager.$anonfun$sendControllerRegistration$1(features, x0$1)));
        ArrayList metadataEncryptors = new ArrayList();
        this.currentMetadataEncryptorFactorySupplier().get().getAllKnownEncryptorIds().forEach(u -> metadataEncryptors.add(new ControllerRegistrationRequestData.Encryptor().setEncryptorId(u)));
        ControllerRegistrationRequestData data = new ControllerRegistrationRequestData().setControllerId(this.nodeId()).setFeatures(features).setIncarnationId(this.incarnationId()).setListeners(this.listenerInfo().toControllerRegistrationRequest()).setZkMigrationReady(this.zkMigrationEnabled()).setMetadataEncryptors(metadataEncryptors);
        this.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(47).append("sendControllerRegistration: attempting to send ").append(data).toString());
        this.kafka$server$ControllerRegistrationManager$$_channelManager().sendRequest((AbstractRequest.Builder)new ControllerRegistrationRequest.Builder(data), (ControllerRequestCompletionHandler)new RegistrationResponseHandler());
        this.pendingRpc_$eq(true);
    }

    public void kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure() {
        long delayMs = this.resendExponentialBackoff().backoff(this.failedRpcs());
        this.failedRpcs_$eq(this.failedRpcs() + 1L);
        this.scheduleNextCommunication(delayMs);
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleNextCommunication(long intervalMs) {
        void scheduleDeferred_event;
        void scheduleDeferred_deadlineNsCalculator;
        void scheduleDeferred_tag;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(46).append("Scheduling next communication at ").append(intervalMs).append(" ms from now.").toString());
        long deadlineNs = this.time().nanoseconds() + TimeUnit.MILLISECONDS.toNanos(intervalMs);
        KafkaEventQueue kafkaEventQueue = this.eventQueue();
        EventQueue.Event event = () -> this.kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
        EventQueue.DeadlineFunction deadlineFunction = new EventQueue.DeadlineFunction(deadlineNs);
        String string = "communication";
        if (kafkaEventQueue == null) {
            throw null;
        }
        kafkaEventQueue.enqueue(EventQueue.EventInsertionType.DEFERRED, (String)scheduleDeferred_tag, (Function)scheduleDeferred_deadlineNsCalculator, (EventQueue.Event)scheduleDeferred_event);
    }

    public static final /* synthetic */ boolean $anonfun$sendControllerRegistration$1(ControllerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            VersionRange range = (VersionRange)x0$1._2();
            return features$1.add((ImplicitLinkedHashCollection.Element)new ControllerRegistrationRequestData.Feature().setName(name).setMinSupportedVersion(range.min()).setMaxSupportedVersion(range.max()));
        }
        throw new MatchError(null);
    }

    public ControllerRegistrationManager(int nodeId, String clusterId, Time time, String threadNamePrefix, Map<String, VersionRange> supportedFeatures, boolean zkMigrationEnabled, Uuid incarnationId, ListenerInfo listenerInfo, ExponentialBackoff resendExponentialBackoff, Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier) {
        this.nodeId = nodeId;
        this.clusterId = clusterId;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.supportedFeatures = supportedFeatures;
        this.zkMigrationEnabled = zkMigrationEnabled;
        this.incarnationId = incarnationId;
        this.listenerInfo = listenerInfo;
        this.resendExponentialBackoff = resendExponentialBackoff;
        this.currentMetadataEncryptorFactorySupplier = currentMetadataEncryptorFactorySupplier;
        this.logContext = new LogContext(this.logPrefix());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.pendingRpc = false;
        this.successfulRpcs = 0L;
        this.failedRpcs = 0L;
        this.kafka$server$ControllerRegistrationManager$$metadataVersion = MetadataVersion.MINIMUM_KRAFT_VERSION;
        this.registeredInLog = false;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), new java.lang.StringBuilder(21).append(threadNamePrefix).append("registration-manager-").toString(), (EventQueue.Event)new ShutdownEvent());
    }

    private class MetadataUpdateEvent
    implements EventQueue.Event {
        private final MetadataDelta delta;
        private final MetadataImage newImage;
        public final /* synthetic */ ControllerRegistrationManager $outer;

        public String name() {
            return super.name();
        }

        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public void run() {
            try {
                if (this.delta.featuresDelta() != null) {
                    this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().kafka$server$ControllerRegistrationManager$$metadataVersion_$eq(this.newImage.features().metadataVersion());
                }
                if (this.delta.clusterDelta() != null && this.delta.clusterDelta().changedControllers().containsKey(BoxesRunTime.boxToInteger((int)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().nodeId()))) {
                    ControllerRegistration curRegistration = (ControllerRegistration)this.newImage.cluster().controllers().get(BoxesRunTime.boxToInteger((int)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().nodeId()));
                    if (curRegistration == null) {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "Registration removed for this node ID.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(false);
                    } else if (!curRegistration.incarnationId().equals((Object)this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().incarnationId())) {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(51).append("Found registration for ").append(curRegistration.incarnationId()).append(" instead of our incarnation.").toString());
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(false);
                    } else {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "Our registration has been persisted to the metadata log.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(true);
                    }
                }
                this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
                return;
            }
            catch (Throwable t) {
                this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "onMetadataUpdate error", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer() {
            return this.$outer;
        }

        public MetadataUpdateEvent(ControllerRegistrationManager $outer, MetadataDelta delta, MetadataImage newImage) {
            this.delta = delta;
            this.newImage = newImage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class RegistrationResponseHandler
    implements ControllerRequestCompletionHandler {
        public void onComplete(ClientResponse response) {
            Errors errorCode;
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().pendingRpc_$eq(false);
            if (response.authenticationException() != null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: authentication error", (Function0<Throwable>)(Function0 & Serializable)() -> response.authenticationException());
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.versionMismatch() != null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: unsupported API version error", (Function0<Throwable>)(Function0 & Serializable)() -> response.versionMismatch());
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.responseBody() == null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: unknown error");
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (!(response.responseBody() instanceof ControllerRegistrationResponse)) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: invalid response type error");
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            ControllerRegistrationResponse message = (ControllerRegistrationResponse)response.responseBody();
            Errors errors = errorCode = Errors.forCode((short)message.data().errorCode());
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().successfulRpcs_$eq(this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().successfulRpcs() + 1L);
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().failedRpcs_$eq(0L);
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: controller acknowledged ControllerRegistrationRequest.");
                return;
            }
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(58).append("RegistrationResponseHandler: controller returned error ").append(errorCode).append(" ").append("(").append(message.data().errorMessage()).append(")").toString());
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
        }

        public void onTimeout() {
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "RegistrationResponseHandler: channel manager timed out before sending the request.");
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer() {
            return ControllerRegistrationManager.this;
        }

        public RegistrationResponseHandler() {
            if (ControllerRegistrationManager.this == null) {
                throw null;
            }
        }
    }

    private class ShutdownEvent
    implements EventQueue.Event {
        public String name() {
            return super.name();
        }

        public void handleException(Throwable x$1) {
            super.handleException(x$1);
        }

        public void run() {
            try {
                this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "shutting down.");
                if (this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager() != null) {
                    this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager().shutdown();
                    this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager_$eq(null);
                }
            }
            catch (Throwable t) {
                this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().error((Function0<String>)(Function0 & Serializable)() -> "ControllerRegistrationManager.stop error", (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer() {
            return ControllerRegistrationManager.this;
        }

        public ShutdownEvent() {
            if (ControllerRegistrationManager.this == null) {
                throw null;
            }
        }
    }
}

