/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.Collection;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class DelegationTokenManagerZk$ {
    public static final DelegationTokenManagerZk$ MODULE$ = new DelegationTokenManagerZk$();
    private static final String OwnerKey = "owner";
    private static final String TokenRequesterKey = "tokenRequester";
    private static final String RenewersKey = "renewers";
    private static final String IssueTimestampKey = "issueTimestamp";
    private static final String MaxTimestampKey = "maxTimestamp";
    private static final String ExpiryTimestampKey = "expiryTimestamp";
    private static final String TokenIdKey = "tokenId";
    private static final String VersionKey = "version";
    private static final int CurrentVersion = 3;

    private String OwnerKey() {
        return OwnerKey;
    }

    private String TokenRequesterKey() {
        return TokenRequesterKey;
    }

    private String RenewersKey() {
        return RenewersKey;
    }

    private String IssueTimestampKey() {
        return IssueTimestampKey;
    }

    private String MaxTimestampKey() {
        return MaxTimestampKey;
    }

    private String ExpiryTimestampKey() {
        return ExpiryTimestampKey;
    }

    private String TokenIdKey() {
        return TokenIdKey;
    }

    private String VersionKey() {
        return VersionKey;
    }

    private int CurrentVersion() {
        return CurrentVersion;
    }

    public Map<String, Object> toJsonCompatibleMap(TokenInformation tokenInfo) {
        scala.collection.mutable.Map tokenInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        tokenInfoMap.update((Object)this.VersionKey(), (Object)BoxesRunTime.boxToInteger((int)this.CurrentVersion()));
        tokenInfoMap.update((Object)this.OwnerKey(), (Object)Sanitizer.sanitize((String)tokenInfo.ownerAsString()));
        tokenInfoMap.update((Object)this.TokenRequesterKey(), (Object)Sanitizer.sanitize((String)tokenInfo.tokenRequester().toString()));
        tokenInfoMap.update((Object)this.RenewersKey(), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(tokenInfo.renewersAsString()).asScala().map((Function1 & Serializable)e -> Sanitizer.sanitize((String)e))).asJava());
        tokenInfoMap.update((Object)this.IssueTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.issueTimestamp()));
        tokenInfoMap.update((Object)this.MaxTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.maxTimestamp()));
        tokenInfoMap.update((Object)this.ExpiryTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.expiryTimestamp()));
        tokenInfoMap.update((Object)this.TokenIdKey(), (Object)tokenInfo.tokenId());
        return tokenInfoMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    public Option<TokenInformation> fromBytes(byte[] bytes) {
        if (bytes == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(bytes))) {
            return None$.MODULE$;
        }
        Option<JsonValue> option = Json$.MODULE$.parseBytes(bytes);
        if (option instanceof Some) {
            void decodeSeq_factory;
            KafkaPrincipal owner;
            JsonObject mainJs = ((JsonValue)((Some)option).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)mainJs.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            Predef$.MODULE$.require(version > 0 && version <= this.CurrentVersion());
            KafkaPrincipal tokenRequester = owner = SecurityUtils.parseKafkaPrincipal((String)Sanitizer.desanitize((String)mainJs.apply(this.OwnerKey()).to(DecodeJson$DecodeString$.MODULE$)));
            if (version >= 3) {
                tokenRequester = SecurityUtils.parseKafkaPrincipal((String)Sanitizer.desanitize((String)mainJs.apply(this.TokenRequesterKey()).to(DecodeJson$DecodeString$.MODULE$)));
            }
            Factory factory = Seq$.MODULE$.iterableFactory();
            DecodeJson$DecodeString$ decodeSeq_decodeJson = DecodeJson$DecodeString$.MODULE$;
            Object var16_8 = null;
            factory = null;
            scala.collection.immutable.Seq renewers = (scala.collection.immutable.Seq)((IterableOps)((scala.collection.immutable.Seq)mainJs.apply(this.RenewersKey()).to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                private final DecodeJson decodeJson$2;
                private final Factory factory$1;

                public Object decode(JsonNode node) {
                    return DecodeJson.decode$(this, node);
                }

                public final Either<String, S> decodeEither(JsonNode node) {
                    return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                }
                {
                    this.decodeJson$2 = decodeJson$2;
                    this.factory$1 = factory$1;
                }
            })).map((Function1 & Serializable)x$1 -> Sanitizer.desanitize((String)x$1))).map((Function1 & Serializable)x$1 -> SecurityUtils.parseKafkaPrincipal((String)x$1));
            long issueTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.IssueTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long expiryTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.ExpiryTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long maxTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.MaxTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            String tokenId = mainJs.apply(this.TokenIdKey()).to(DecodeJson$DecodeString$.MODULE$);
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, tokenRequester, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)renewers).asJava(), issueTimestamp, maxTimestamp, expiryTimestamp);
            return new Some((Object)tokenInfo);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private DelegationTokenManagerZk$() {
    }
}

