/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.K2ControllerHandler;
import io.confluent.k2.kafka.K2TopicMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.ConfigAdminManager$;
import kafka.server.K2ControllerApis$ErrorDetermination$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.MapOps;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001\u0002\u001e<\u0001\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!a\u0007A!A!\u0002\u0013i\u0007\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u0015\u0005\u001d\u0001A!A!\u0002\u0013\tI\u0001\u0003\u0006\u0002 \u0001\u0011\t\u0011)A\u0005\u0003CAq!!\u000e\u0001\t\u0003\t9\u0004C\u0005\u0002L\u0001\u0011\r\u0011\"\u0001\u0002N!A\u0011Q\u000b\u0001!\u0002\u0013\ty\u0005C\u0005\u0002X\u0001\u0011\r\u0011\"\u0001\u0002Z!A\u0011\u0011\r\u0001!\u0002\u0013\tYF\u0002\u0004\u0002d\u0001!\u0011Q\r\u0005\u000b\u0003Or!\u0011!Q\u0001\n\u0005%\u0004BCA;\u001d\t\u0005\t\u0015!\u0003\u0002x!9\u0011Q\u0007\b\u0005\u0002\u0005\r\u0005\"CAG\u001d\u0001\u0007I\u0011BAH\u0011%\tIJ\u0004a\u0001\n\u0013\tY\n\u0003\u0005\u0002(:\u0001\u000b\u0015BAI\u0011\u001d\tIK\u0004C\u0001\u0003W3a!!,\u0001\t\u0006=\u0006BCAe-\tU\r\u0011\"\u0001\u0002L\"Q\u00111\u001b\f\u0003\u0012\u0003\u0006I!!4\t\u0015\u0005UgC!f\u0001\n\u0003\t9\u000e\u0003\u0006\u0002jZ\u0011\t\u0012)A\u0005\u00033Dq!!\u000e\u0017\t\u0003\tY\u000fC\u0005\u0002tZ\t\t\u0011\"\u0001\u0002v\"I\u00111 \f\u0012\u0002\u0013\u0005\u0011Q \u0005\n\u0005'1\u0012\u0013!C\u0001\u0005+A\u0011B!\u0007\u0017\u0003\u0003%\tEa\u0007\t\u0013\t\u001db#!A\u0005\u0002\t%\u0002\"\u0003B\u0016-\u0005\u0005I\u0011\u0001B\u0017\u0011%\u00119DFA\u0001\n\u0003\u0012I\u0004C\u0005\u0003HY\t\t\u0011\"\u0001\u0003J!I!Q\n\f\u0002\u0002\u0013\u0005#q\n\u0005\n\u0005'2\u0012\u0011!C!\u0005+B\u0011Ba\u0016\u0017\u0003\u0003%\tE!\u0017\t\u0013\tmc#!A\u0005B\tus!\u0003B1\u0001\u0005\u0005\t\u0012\u0002B2\r%\ti\u000bAA\u0001\u0012\u0013\u0011)\u0007C\u0004\u00026%\"\tAa\u001f\t\u0013\t]\u0013&!A\u0005F\te\u0003\"\u0003B?S\u0005\u0005I\u0011\u0011B@\u0011%\u0011))KA\u0001\n\u0003\u00139\tC\u0004\u0003\u0016\u0002!IAa&\t\u000f\te\u0006\u0001\"\u0001\u0003<\"9!q\u001a\u0001\u0005\u0002\tE\u0007b\u0002Bk\u0001\u0011\u0005!q\u001b\u0005\b\u00057\u0004A\u0011\u0001Bo\u0011\u001d\u0011\t\u000f\u0001C\u0001\u0005GDqAa:\u0001\t\u0013\u0011I\u000fC\u0004\u0003n\u0002!IAa<\t\u000f\r=\u0001\u0001\"\u0003\u0004\u0012!91Q\u0004\u0001\u0005\n\r}\u0001bBB\u0013\u0001\u0011%1q\u0005\u0005\b\u0007W\u0002A\u0011BB7\u0005AY%gQ8oiJ|G\u000e\\3s\u0003BL7O\u0003\u0002={\u000511/\u001a:wKJT\u0011AP\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011i\u0012\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005![U\"A%\u000b\u0005)k\u0014!B;uS2\u001c\u0018B\u0001'J\u0005\u001daunZ4j]\u001e\faB]3rk\u0016\u001cHo\u00115b]:,G\u000e\u0005\u0002P%6\t\u0001K\u0003\u0002R{\u00059a.\u001a;x_J\\\u0017BA*Q\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003\u0005ZK!aV\"\u0003\u0007%sG/\u0001\u0004d_:4\u0017n\u001a\t\u00035nk\u0011aO\u0005\u00039n\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006Q\u0011-\u001e;i_JL'0\u001a:\u0011\u0007\t{\u0016-\u0003\u0002a\u0007\n1q\n\u001d;j_:\u0004\"A\u00196\u000e\u0003\rT!!\u00183\u000b\u0005q*'B\u0001 g\u0015\t9\u0007.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0006\u0019qN]4\n\u0005-\u001c'AC!vi\"|'/\u001b>fe\u00061\u0011/^8uCN\u0004\"A\u001c=\u000f\u0005=4hB\u00019v\u001d\t\tH/D\u0001s\u0015\t\u0019x(\u0001\u0004=e>|GOP\u0005\u0002}%\u0011A(P\u0005\u0003on\nA\"U;pi\u00064\u0015m\u0019;pefL!!\u001f>\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\t98(\u0001\u0003uS6,\u0007cA?\u0002\u00045\taP\u0003\u0002K\u007f*\u0019\u0011\u0011A3\u0002\r\r|W.\\8o\u0013\r\t)A \u0002\u0005)&lW-\u0001\rd_:$(o\u001c7mKJ\u0014V-];fgRD\u0015M\u001c3mKJ\u0004B!a\u0003\u0002\u001c5\u0011\u0011Q\u0002\u0006\u0004}\u0005=!\u0002BA\t\u0003'\t!a\u001b\u001a\u000b\t\u0005U\u0011qC\u0001\nG>tg\r\\;f]RT!!!\u0007\u0002\u0005%|\u0017\u0002BA\u000f\u0003\u001b\u00111c\u0013\u001aD_:$(o\u001c7mKJD\u0015M\u001c3mKJ\f\u0001\"\u001a=fGV$xN\u001d\t\u0005\u0003G\t\t$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003W\ti#\u0001\u0003vi&d'BAA\u0018\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012Q\u0005\u0002\t\u000bb,7-\u001e;pe\u00061A(\u001b8jiz\"\"#!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\n)%a\u0012\u0002JA\u0011!\f\u0001\u0005\u0006\u001b&\u0001\rA\u0014\u0005\u0006)&\u0001\r!\u0016\u0005\u00061&\u0001\r!\u0017\u0005\u0006;&\u0001\rA\u0018\u0005\u0006Y&\u0001\r!\u001c\u0005\u0006w&\u0001\r\u0001 \u0005\b\u0003\u000fI\u0001\u0019AA\u0005\u0011\u001d\ty\"\u0003a\u0001\u0003C\tQB]3rk\u0016\u001cH\u000fS3ma\u0016\u0014XCAA(!\rQ\u0016\u0011K\u0005\u0004\u0003'Z$\u0001\u0006*fcV,7\u000f\u001e%b]\u0012dWM\u001d%fYB,'/\u0001\bsKF,Xm\u001d;IK2\u0004XM\u001d\u0011\u0002\u0015\u0005,H\u000f\u001b%fYB,'/\u0006\u0002\u0002\\A\u0019!,!\u0018\n\u0007\u0005}3H\u0001\u0006BkRD\u0007*\u001a7qKJ\f1\"Y;uQ\"+G\u000e]3sA\t\t2\t\\;ti\u0016\u0014\u0018)\u001e;i_JL'0\u001a:\u0014\u00059\t\u0015A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN@\u0002\u0011I,\u0017/^3tiNLA!a\u001d\u0002n\tq!+Z9vKN$8i\u001c8uKb$\u0018!C8qKJ\fG/[8o!\u0011\tI(a \u000e\u0005\u0005m$bAA?\u007f\u0006\u0019\u0011m\u00197\n\t\u0005\u0005\u00151\u0010\u0002\r\u0003\u000edw\n]3sCRLwN\u001c\u000b\u0007\u0003\u000b\u000bI)a#\u0011\u0007\u0005\u001de\"D\u0001\u0001\u0011\u001d\t9'\u0005a\u0001\u0003SBq!!\u001e\u0012\u0001\u0004\t9(A\fiCN\u001cE.^:uKJ\fU\u000f\u001e5pe&T\u0018\r^5p]V\u0011\u0011\u0011\u0013\t\u0005\u0005~\u000b\u0019\nE\u0002C\u0003+K1!a&D\u0005\u001d\u0011un\u001c7fC:\f1\u0004[1t\u00072,8\u000f^3s\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8`I\u0015\fH\u0003BAO\u0003G\u00032AQAP\u0013\r\t\tk\u0011\u0002\u0005+:LG\u000fC\u0005\u0002&N\t\t\u00111\u0001\u0002\u0012\u0006\u0019\u0001\u0010J\u0019\u00021!\f7o\u00117vgR,'/Q;uQ>\u0014\u0018N_1uS>t\u0007%\u0001\u0007jg\u0006+H\u000f[8sSj,G-\u0006\u0002\u0002\u0014\n\u0011RI\u001d:pe\u0012+G/\u001a:nS:\fG/[8o'\u00191\u0012)!-\u00028B\u0019!)a-\n\u0007\u0005U6IA\u0004Qe>$Wo\u0019;\u0011\t\u0005e\u00161\u0019\b\u0005\u0003w\u000byLD\u0002r\u0003{K\u0011\u0001R\u0005\u0004\u0003\u0003\u001c\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\f9M\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002B\u000e\u000b\u0011\"\u001a:s_J\u001cu\u000eZ3\u0016\u0005\u00055\u0007c\u0001\"\u0002P&\u0019\u0011\u0011[\"\u0003\u000bMCwN\u001d;\u0002\u0015\u0015\u0014(o\u001c:D_\u0012,\u0007%\u0001\u0007feJ|'/T3tg\u0006<W-\u0006\u0002\u0002ZB!\u00111\\Ar\u001d\u0011\ti.a8\u0011\u0005E\u001c\u0015bAAq\u0007\u00061\u0001K]3eK\u001aLA!!:\u0002h\n11\u000b\u001e:j]\u001eT1!!9D\u00035)'O]8s\u001b\u0016\u001c8/Y4fAQ1\u0011Q^Ax\u0003c\u00042!a\"\u0017\u0011\u001d\tIm\u0007a\u0001\u0003\u001bDq!!6\u001c\u0001\u0004\tI.\u0001\u0003d_BLHCBAw\u0003o\fI\u0010C\u0005\u0002Jr\u0001\n\u00111\u0001\u0002N\"I\u0011Q\u001b\u000f\u0011\u0002\u0003\u0007\u0011\u0011\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyP\u000b\u0003\u0002N\n\u00051F\u0001B\u0002!\u0011\u0011)Aa\u0004\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t51)\u0001\u0006b]:|G/\u0019;j_:LAA!\u0005\u0003\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0003\u0016\u0005\u00033\u0014\t!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005;\u0001BAa\b\u0003&5\u0011!\u0011\u0005\u0006\u0005\u0005G\ti#\u0001\u0003mC:<\u0017\u0002BAs\u0005C\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012!V\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yC!\u000e\u0011\u0007\t\u0013\t$C\u0002\u00034\r\u00131!\u00118z\u0011!\t)+IA\u0001\u0002\u0004)\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tm\u0002C\u0002B\u001f\u0005\u0007\u0012y#\u0004\u0002\u0003@)\u0019!\u0011I\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003F\t}\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a%\u0003L!I\u0011QU\u0012\u0002\u0002\u0003\u0007!qF\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u001e\tE\u0003\u0002CASI\u0005\u0005\t\u0019A+\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!V\u0001\ti>\u001cFO]5oOR\u0011!QD\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M%q\f\u0005\n\u0003K;\u0013\u0011!a\u0001\u0005_\t!#\u0012:s_J$U\r^3s[&t\u0017\r^5p]B\u0019\u0011qQ\u0015\u0014\u000b%\u00129Ga\u001d\u0011\u0015\t%$qNAg\u00033\fi/\u0004\u0002\u0003l)\u0019!QN\"\u0002\u000fI,h\u000e^5nK&!!\u0011\u000fB6\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0005k\u0012I(\u0004\u0002\u0003x)!\u0011\u0011DA\u0017\u0013\u0011\t)Ma\u001e\u0015\u0005\t\r\u0014!B1qa2LHCBAw\u0005\u0003\u0013\u0019\tC\u0004\u0002J2\u0002\r!!4\t\u000f\u0005UG\u00061\u0001\u0002Z\u00069QO\\1qa2LH\u0003\u0002BE\u0005#\u0003BAQ0\u0003\fB9!I!$\u0002N\u0006e\u0017b\u0001BH\u0007\n1A+\u001e9mKJB\u0011Ba%.\u0003\u0003\u0005\r!!<\u0002\u0007a$\u0003'A\bsK\u000e|'\u000f\u001a(fo\u0016\u0013(o\u001c:t)!\tiJ!'\u0003&\n=\u0006b\u0002BN]\u0001\u0007!QT\u0001\u0012M&\u00148\u000f^#se>\u0014()\u001f+pa&\u001c\u0007\u0003\u0003BP\u0005C\u000bI.!<\u000e\u0005\u0005%\u0012\u0002\u0002BR\u0003S\u00111!T1q\u0011\u001d\u00119K\fa\u0001\u0005S\u000ba\"\u00194gK\u000e$X\r\u001a+pa&\u001c7\u000f\u0005\u0004\u0003>\t-\u0016\u0011\\\u0005\u0005\u0005[\u0013yDA\u0002TKRDqA!-/\u0001\u0004\u0011\u0019,\u0001\u000efeJ|'\u000fR3uKJl\u0017N\\1uS>t7+\u001e9qY&,'\u000fE\u0003C\u0005k\u000bi/C\u0002\u00038\u000e\u0013\u0011BR;oGRLwN\u001c\u0019\u00023!\fg\u000e\u001a7f\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e\u000b\u0005\u0003;\u0013i\fC\u0004\u0003@>\u0002\rA!1\u0002\u000fI,\u0017/^3tiB!!1\u0019Be\u001d\ry%QY\u0005\u0004\u0005\u000f\u0004\u0016A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0005\u0017\u0014iMA\u0004SKF,Xm\u001d;\u000b\u0007\t\u001d\u0007+\u0001\u0013iC:$G.Z%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u)\u0011\tiJa5\t\u000f\t}\u0006\u00071\u0001\u0003B\u0006y\u0002.\u00198eY\u0016dUmZ1ds\u0006cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;\u0015\t\u0005u%\u0011\u001c\u0005\b\u0005\u007f\u000b\u0004\u0019\u0001Ba\u0003eA\u0017M\u001c3mK\u0012+G.\u001a;f)>\u0004\u0018nY:SKF,Xm\u001d;\u0015\t\u0005u%q\u001c\u0005\b\u0005\u007f\u0013\u0004\u0019\u0001Ba\u0003uA\u0017M\u001c3mK\u000e\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001c(+Z9vKN$H\u0003BAO\u0005KDqAa04\u0001\u0004\u0011\t-A\u000ed_:4\u0017N]7U_BL7\rR3mKRLwN\\#oC\ndW\r\u001a\u000b\u0005\u0003;\u0013Y\u000fC\u0004\u0003@R\u0002\rA!1\u0002C\u001d,GOT8o5\u0016\u0014x\u000eV8qS\u000eLEm\u001d+p\u001f\u000e\u001cWO\u001d:f]\u000e,W*\u00199\u0015\t\tE8Q\u0001\t\t\u0005?\u0013\u0019Pa>\u0003\u0000&!!Q_A\u0015\u0005\u001dA\u0015m\u001d5NCB\u0004BA!?\u0003|6\tq0C\u0002\u0003~~\u0014A!V;jIB!!qDB\u0001\u0013\u0011\u0019\u0019A!\t\u0003\u000f%sG/Z4fe\"91qA\u001bA\u0002\r%\u0011a\u00053fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$\b\u0003BA6\u0007\u0017IAa!\u0004\u0002n\t\u0019B)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0006ABo\u001c;bYJ+\u0017/^3ti\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0007U\u001b\u0019\u0002C\u0004\u0004\u0016Y\u0002\raa\u0006\u0002\u001bQ|\u0007/[2NKR\fG-\u0019;b!\u0011\tYa!\u0007\n\t\rm\u0011Q\u0002\u0002\u0010\u0017J\"v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0006\u0019s-\u001a;O_:tU\u000f\u001c7U_BL7MT1nKN$vnT2dkJ\u0014XM\\2f\u001b\u0006\u0004H\u0003BB\u0011\u0007G\u0001\u0002Ba(\u0003t\u0006e'q \u0005\b\u0007\u000f9\u0004\u0019AB\u0005\u0003\u0011\nW\u000f\u001e5pe&TX-\u00118e!>\u0004X\u000f\\1uKR+g\u000e^1uSZ,'+Z:vYR\u001cHCCB\u0015\u0007_\u0019\tda\u000f\u0004BA1!qTB\u0016\u00033LAa!\f\u0002*\t9\u0001*Y:i'\u0016$\bbBA4q\u0001\u0007\u0011\u0011\u000e\u0005\b\u0007gA\u0004\u0019AB\u001b\u0003M\u0019'/Z1uKR{\u0007/[2t%\u0016\fX/Z:u!\u0011\tYga\u000e\n\t\re\u0012Q\u000e\u0002\u0014\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e\u0005\b\u0007{A\u0004\u0019AB \u00039\u0001xn]:jE2,WI\u001d:peN\u0004\u0002Ba(\u0003t\u0006e\u0017Q\u001e\u0005\b\u0007\u0007B\u0004\u0019AB#\u0003\u001d\u0011Xm];miN\u0004Baa\u0012\u0004f9!1\u0011JB0\u001d\u0011\u0019Yea\u0017\u000f\t\r53\u0011\f\b\u0005\u0007\u001f\u001a9F\u0004\u0003\u0004R\rUcbA9\u0004T%\t\u0011.\u0003\u0002hQ&\u0011aHZ\u0005\u0004\u0003\u0003)\u0017bAB/\u007f\u00069Q.Z:tC\u001e,\u0017\u0002BB1\u0007G\n\u0001d\u0011:fCR,Gk\u001c9jGN\u0014Vm\u001d9p]N,G)\u0019;b\u0015\r\u0019if`\u0005\u0005\u0007O\u001aIG\u0001\u0010De\u0016\fG/\u00192mKR{\u0007/[2SKN,H\u000e^\"pY2,7\r^5p]*!1\u0011MB2\u000359W\r\u001e$jYR,'/\u001a3CsRA1qNB?\u0007\u007f\u001a\u0019\t\u0005\u0003\u0004r\r]d\u0002BB%\u0007gJAa!\u001e\u0004d\u000592I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0007s\u001aYH\u0001\rDe\u0016\fG/\u00192mKR{\u0007/[2D_2dWm\u0019;j_:TAa!\u001e\u0004d!911G\u001dA\u0002\rU\u0002bBBAs\u0001\u00071\u0011F\u0001\u0018i>\u0004\u0018n\u0019(b[\u0016\u001cHk\u001c+ssR{7I]3bi\u0016Dqa!\":\u0001\u0004\t\u0019*A\tiK\u0006dG\u000f[2iK\u000e\\G+\u001a8b]R\u0004")
public class K2ControllerApis
implements Logging {
    private volatile K2ControllerApis$ErrorDetermination$ ErrorDetermination$module;
    private final KafkaConfig config;
    private final K2ControllerHandler controllerRequestHandler;
    private final Executor executor;
    private final RequestHandlerHelper requestHelper;
    private final AuthHelper authHelper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private K2ControllerApis$ErrorDetermination$ ErrorDetermination() {
        if (this.ErrorDetermination$module == null) {
            this.ErrorDetermination$lzycompute$1();
        }
        return this.ErrorDetermination$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    private void recordNewErrors(java.util.Map<String, ErrorDetermination> firstErrorByTopic, Set<String> affectedTopics, Function0<ErrorDetermination> errorDeterminationSupplier) {
        if (affectedTopics.nonEmpty()) {
            ErrorDetermination errorDetermination = (ErrorDetermination)errorDeterminationSupplier.apply();
            affectedTopics.foreach((Function1 & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
            return;
        }
    }

    public void handleCreateTopicsRequest(RequestChannel.Request request) {
        None$ maybeTopicsToCreate;
        scala.collection.immutable.Set nonStandardReplicationFactorUnsupportedInK2;
        boolean healthcheckTenant;
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class));
        Iterable topics = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)createTopicsRequest.data().topics()).asScala();
        scala.collection.immutable.Set topicNameSet = ((Iterable)topics.map((Function1 & Serializable)x$1 -> x$1.name())).toSet();
        boolean validateOnly = createTopicsRequest.data().validateOnly();
        HashMap<String, ErrorDetermination> firstErrorByTopic = new HashMap<String, ErrorDetermination>();
        Set recordNewErrors_affectedTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"__cluster_metadata"}));
        if (recordNewErrors_affectedTopics.nonEmpty()) {
            ErrorDetermination recordNewErrors_errorDetermination = K2ControllerApis.$anonfun$handleCreateTopicsRequest$2(this);
            recordNewErrors_affectedTopics.foreach((Function1 & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
        }
        Object var22_7 = null;
        Object var23_8 = null;
        scala.collection.immutable.Set mirroredTopicsUnsupportedInK2 = ((IterableOnceOps)((IterableOps)topics.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleCreateTopicsRequest$3(t)))).map((Function1 & Serializable)x$2 -> x$2.name())).toSet();
        if (mirroredTopicsUnsupportedInK2.nonEmpty()) {
            ErrorDetermination recordNewErrors_errorDetermination = K2ControllerApis.$anonfun$handleCreateTopicsRequest$5(this);
            mirroredTopicsUnsupportedInK2.foreach((Function1 & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
        }
        Object var24_10 = null;
        scala.collection.immutable.Set duplicatedTopicNames = ((MapOps)((IterableOps)topics.filter((Function1 & Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)topicNameSet.contains((Object)topic.name())))).groupBy((Function1 & Serializable)x$3 -> x$3.name()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleCreateTopicsRequest$8(x0$1)))).keySet();
        if (duplicatedTopicNames.nonEmpty()) {
            ErrorDetermination recordNewErrors_errorDetermination = K2ControllerApis.$anonfun$handleCreateTopicsRequest$9(this);
            duplicatedTopicNames.foreach((Function1 & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
        }
        Object var25_12 = null;
        KafkaPrincipal kafkaPrincipal = request.context().principal;
        boolean bl = healthcheckTenant = kafkaPrincipal instanceof MultiTenantPrincipal ? ((MultiTenantPrincipal)kafkaPrincipal).tenantMetadata().isHealthcheckTenant : false;
        if (!healthcheckTenant) {
            scala.collection.immutable.Set manualPartitionAssignmentsUnsupportedInK2 = ((IterableOnceOps)((IterableOps)topics.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleCreateTopicsRequest$10(t)))).map((Function1 & Serializable)x$4 -> x$4.name())).toSet();
            if (manualPartitionAssignmentsUnsupportedInK2.nonEmpty()) {
                ErrorDetermination recordNewErrors_errorDetermination = K2ControllerApis.$anonfun$handleCreateTopicsRequest$12(this);
                manualPartitionAssignmentsUnsupportedInK2.foreach((Function1 & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
            }
            Object var26_16 = null;
        }
        if ((nonStandardReplicationFactorUnsupportedInK2 = ((IterableOnceOps)((IterableOps)topics.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleCreateTopicsRequest$13(this, t)))).map((Function1 & Serializable)x$5 -> x$5.name())).toSet()).nonEmpty()) {
            ErrorDetermination recordNewErrors_errorDetermination = K2ControllerApis.$anonfun$handleCreateTopicsRequest$15(this);
            nonStandardReplicationFactorUnsupportedInK2.foreach((Function1 & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
        }
        Object var27_18 = null;
        CreateTopicsResponseData.CreatableTopicResultCollection results = new CreateTopicsResponseData.CreatableTopicResultCollection(createTopicsRequest.data().topics().size());
        HashSet<String> topicNamesToTryToCreate = this.authorizeAndPopulateTentativeResults(request.context(), createTopicsRequest, firstErrorByTopic, results);
        Object object = maybeTopicsToCreate = topicNamesToTryToCreate.isEmpty() ? None$.MODULE$ : new Some((Object)this.getFilteredBy(createTopicsRequest, topicNamesToTryToCreate, healthcheckTenant));
        if (maybeTopicsToCreate instanceof Some) {
            CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = (CreateTopicsRequestData.CreatableTopicCollection)((Some)maybeTopicsToCreate).value();
            RequestContext x$12 = request.context();
            Iterable x$42 = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)topicsToCreate).asScala().map((Function1 & Serializable)t -> t.name());
            boolean x$6 = this.authHelper().filterByAuthorized$default$5();
            Function1 & Serializable x$7 = (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
            scala.collection.immutable.Set<String> topicsAuthorizedForDescribeConfigs = this.authHelper().filterByAuthorized(x$12, AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, x$42, x$6, false, x$7);
            this.controllerRequestHandler.createTopics(topicsToCreate, CollectionConverters$.MODULE$.SetHasAsJava(topicsAuthorizedForDescribeConfigs).asJava(), validateOnly).whenCompleteAsyncRaw((createResult, throwable) -> this.sendResponse$1((CreateTopicsResponseData.CreatableTopicResultCollection)createResult, (Throwable)throwable, createTopicsRequest, results, request), this.executor);
            return;
        }
        if (None$.MODULE$.equals(maybeTopicsToCreate)) {
            this.sendResponse$1(new CreateTopicsResponseData.CreatableTopicResultCollection(), null, createTopicsRequest, results, request);
            return;
        }
        throw new MatchError((Object)maybeTopicsToCreate);
    }

    public void handleIncrementalAlterConfigsRequest(RequestChannel.Request request) {
        IncrementalAlterConfigsRequest alterConfigsRequest = (IncrementalAlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(IncrementalAlterConfigsRequest.class));
        IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection resources = alterConfigsRequest.data().resources();
        if (resources.stream().anyMatch(resource -> {
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            ConfigResource.Type type2 = ConfigResource.Type.TOPIC;
            return type == null ? type2 != null : !type.equals(type2);
        })) {
            throw new InvalidRequestException("Cannot alter configs for Freight topics and non-topic entities in the same RPC");
        }
        if (resources.isEmpty()) {
            throw new InvalidRequestException("Must specify at least one entity when altering configs");
        }
        HashMap firstErrorByTopic = new HashMap();
        scala.collection.immutable.Set duplicatedTopicNames = ((MapOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resources).asScala().groupBy((Function1 & Serializable)x$7 -> x$7.resourceName()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$3(x0$1)))).keySet();
        if (duplicatedTopicNames.nonEmpty()) {
            ErrorDetermination recordNewErrors_errorDetermination = K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$4(this);
            duplicatedTopicNames.foreach((Function1 & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
        }
        Object var8_6 = null;
        ArrayBuffer authorized = new ArrayBuffer();
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resources).asScala().filter((Function1 & Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$5(firstErrorByTopic, resource)))).foreach((Function1 & Serializable)resource -> {
            String topicName = resource.resourceName();
            if (CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().exists((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$7(config)))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Empty or null value not supported for config key."));
            }
            if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x$8 -> x$8.name()))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Error due to duplicate config keys."));
            }
            if (CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().exists((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleIncrementalAlterConfigsRequest$9(config)))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Null value not supported for config update."));
            }
            if (!this.authHelper().authorize(request.context(), AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.TOPIC_AUTHORIZATION_FAILED.code(), "Authorization failed."));
            }
            return authorized.append(resource);
        });
        if (authorized.isEmpty()) {
            this.sendResponse$2(Collections.emptyMap(), null, alterConfigsRequest, resources, firstErrorByTopic, request);
            return;
        }
        java.util.Map requestsByAuthorizedTopicName = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)authorized.map((Function1 & Serializable)resource -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource.resourceName()), (Object)K2ControllerApis.getAlterConfigOps$1(resource.configs())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        this.controllerRequestHandler.alterTopicConfigs(requestsByAuthorizedTopicName, true, alterConfigsRequest.data().validateOnly()).whenCompleteAsyncRaw((alterResults, throwable) -> this.sendResponse$2((java.util.Map)alterResults, (Throwable)throwable, alterConfigsRequest, resources, firstErrorByTopic, request), this.executor);
    }

    public void handleLegacyAlterConfigsRequest(RequestChannel.Request request) {
        AlterConfigsRequest alterConfigsRequest = (AlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(AlterConfigsRequest.class));
        AlterConfigsRequestData.AlterConfigsResourceCollection resources = alterConfigsRequest.data().resources();
        if (resources.stream().anyMatch(resource -> {
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            ConfigResource.Type type2 = ConfigResource.Type.TOPIC;
            return type == null ? type2 != null : !type.equals(type2);
        })) {
            throw new InvalidRequestException("Cannot alter configs for Freight topics and non-topic entities in the same RPC");
        }
        if (resources.isEmpty()) {
            throw new InvalidRequestException("Must specify at least one entity when altering configs");
        }
        HashMap firstErrorByTopic = new HashMap();
        scala.collection.immutable.Set duplicatedTopicNames = ((MapOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resources).asScala().groupBy((Function1 & Serializable)x$10 -> x$10.resourceName()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$3(x0$1)))).keySet();
        if (duplicatedTopicNames.nonEmpty()) {
            ErrorDetermination recordNewErrors_errorDetermination = K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$4(this);
            duplicatedTopicNames.foreach((Function1 & Serializable)topic -> firstErrorByTopic.putIfAbsent((String)topic, errorDetermination));
        }
        Object var8_6 = null;
        ArrayBuffer authorized = new ArrayBuffer();
        ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resources).asScala().filter((Function1 & Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$5(firstErrorByTopic, resource)))).foreach((Function1 & Serializable)resource -> {
            String topicName = resource.resourceName();
            if (CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().exists((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$7(config)))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Empty or null value not supported for config key."));
            }
            if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x$11 -> x$11.name()))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Error due to duplicate config keys."));
            }
            if (CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().exists((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleLegacyAlterConfigsRequest$9(config)))) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.INVALID_REQUEST.code(), "Null value not supported for config update."));
            }
            if (!this.authHelper().authorize(request.context(), AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return firstErrorByTopic.put(topicName, new ErrorDetermination(this, Errors.TOPIC_AUTHORIZATION_FAILED.code(), "Authorization failed."));
            }
            return authorized.append(resource);
        });
        java.util.Map requestsByAuthorizedTopicName = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)authorized.map((Function1 & Serializable)resource -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource.resourceName()), (Object)K2ControllerApis.getAlterConfigOps$2(resource.configs())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        if (requestsByAuthorizedTopicName.isEmpty()) {
            this.sendResponse$3(Collections.emptyMap(), null, alterConfigsRequest, resources, firstErrorByTopic, request);
            return;
        }
        this.controllerRequestHandler.alterTopicConfigs(requestsByAuthorizedTopicName, false, alterConfigsRequest.data().validateOnly()).whenCompleteAsyncRaw((alterResults, throwable) -> this.sendResponse$3((java.util.Map)alterResults, (Throwable)throwable, alterConfigsRequest, resources, firstErrorByTopic, request), this.executor);
    }

    public void handleDeleteTopicsRequest(RequestChannel.Request request) {
        this.confirmTopicDeletionEnabled(request);
        DeleteTopicsRequest deleteTopicsRequest = (DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class));
        HashMap<String, Integer> nonNullTopicNamesToOccurrenceMap = this.getNonNullTopicNamesToOccurrenceMap(deleteTopicsRequest);
        HashSet nonNullNonRepeatedTopicNames = new HashSet();
        nonNullTopicNamesToOccurrenceMap.entrySet().stream().filter(entry -> BoxesRunTime.equals(entry.getValue(), (Object)BoxesRunTime.boxToInteger((int)1))).forEach(entry -> nonNullNonRepeatedTopicNames.add(entry.getKey()));
        HashMap<Uuid, Integer> nonZeroTopicIdsToOccurrenceMap = this.getNonZeroTopicIdsToOccurrenceMap(deleteTopicsRequest);
        HashSet nonZeroNonRepeatedTopicIds = new HashSet();
        nonZeroTopicIdsToOccurrenceMap.entrySet().stream().filter(entry -> BoxesRunTime.equals(entry.getValue(), (Object)BoxesRunTime.boxToInteger((int)1))).forEach(entry -> nonZeroNonRepeatedTopicIds.add(entry.getKey()));
        if (nonNullNonRepeatedTopicNames.isEmpty() && nonZeroNonRepeatedTopicIds.isEmpty()) {
            this.maybeTryToDeleteTopicsAndSendResponse$1(Collections.emptySet(), null, request, deleteTopicsRequest, nonNullTopicNamesToOccurrenceMap, nonZeroTopicIdsToOccurrenceMap);
            return;
        }
        this.controllerRequestHandler.getTopicMetadata(nonNullNonRepeatedTopicNames, nonZeroNonRepeatedTopicIds).whenCompleteAsyncRaw((topicMetadataForDeletions, throwable) -> this.maybeTryToDeleteTopicsAndSendResponse$1((java.util.Set)topicMetadataForDeletions, (Throwable)throwable, request, deleteTopicsRequest, nonNullTopicNamesToOccurrenceMap, nonZeroTopicIdsToOccurrenceMap), this.executor);
    }

    public void handleCreatePartitionsRequest(RequestChannel.Request request) {
        CreatePartitionsRequest createPartitionsRequest = (CreatePartitionsRequest)request.body(ClassTag$.MODULE$.apply(CreatePartitionsRequest.class));
        CreatePartitionsRequestData.CreatePartitionsTopicCollection topics = createPartitionsRequest.data().topics();
        boolean validateOnly = createPartitionsRequest.data().validateOnly();
        HashMap validCreatePartitionsTopics = new HashMap();
        HashSet duplicateTopicNames = new HashSet();
        ArrayList responses = new ArrayList();
        topics.forEach(topic -> {
            if (validCreatePartitionsTopics.put(topic.name(), topic) != null) {
                duplicateTopicNames.add(topic.name());
                return;
            }
        });
        duplicateTopicNames.forEach(topicName -> {
            K2ControllerApis.addResponse$2(topicName, Errors.INVALID_REQUEST.code(), "Found multiple entries for this topic.", responses);
            validCreatePartitionsTopics.remove(topicName);
        });
        ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(validCreatePartitionsTopics.values()).asScala().filter((Function1 & Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleCreatePartitionsRequest$5(topic)))).map((Function1 & Serializable)x$15 -> x$15.name())).toSet().foreach((Function1 & Serializable)topicName -> {
            K2ControllerApis.addResponse$2(topicName, Errors.INVALID_REQUEST.code(), "Cannot specify assignments when creating partitions on a Freight Cluster.", responses);
            return (CreatePartitionsRequestData.CreatePartitionsTopic)validCreatePartitionsTopics.remove(topicName);
        });
        ClusterAuthorizer clusterAuthorizer = new ClusterAuthorizer(this, request.context(), AclOperation.ALTER);
        HashSet authorizedTopics = new HashSet();
        validCreatePartitionsTopics.keySet().forEach(topicName -> {
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request.context(), AclOperation.ALTER, ResourceType.TOPIC, (String)topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$2(topicName, Errors.TOPIC_AUTHORIZATION_FAILED.code(), Errors.TOPIC_AUTHORIZATION_FAILED.message(), responses);
                return;
            }
            authorizedTopics.add(topicName);
        });
        if (authorizedTopics.isEmpty()) {
            this.sendResponses$2(responses, request);
            return;
        }
        this.controllerRequestHandler.getTopicMetadata(authorizedTopics, Collections.emptySet()).whenCompleteAsyncRaw((topicMetadataForPartitionCreations, throwable) -> this.maybeTryToCreatePartitionsAndSendResponse$1((java.util.Set)topicMetadataForPartitionCreations, (Throwable)throwable, authorizedTopics, validCreatePartitionsTopics, validateOnly, responses, request), this.executor);
    }

    private void confirmTopicDeletionEnabled(RequestChannel.Request request) {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.deleteTopicEnable())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "K2 DELETE_TOPICS disabled");
            if (request.header().apiVersion() < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
    }

    private HashMap<Uuid, Integer> getNonZeroTopicIdsToOccurrenceMap(DeleteTopicsRequest deleteTopicsRequest) {
        HashMap<Uuid, Integer> topicIdsToOccurrences = new HashMap<Uuid, Integer>();
        deleteTopicsRequest.topics().stream().filter(topic -> !topic.topicId().equals((Object)Uuid.ZERO_UUID)).forEach(topic -> topicIdsToOccurrences.put(topic.topicId(), Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int(topicIdsToOccurrences.getOrDefault(topic.topicId(), Predef$.MODULE$.int2Integer(0))))));
        return topicIdsToOccurrences;
    }

    private int totalRequestedPartitions(K2TopicMetadata topicMetadata) {
        return Math.max(topicMetadata.numPartitions(), topicMetadata.lastExpandedToPartitionCount());
    }

    private HashMap<String, Integer> getNonNullTopicNamesToOccurrenceMap(DeleteTopicsRequest deleteTopicsRequest) {
        HashMap<String, Integer> topicNamesToOccurrences = new HashMap<String, Integer>();
        deleteTopicsRequest.topics().stream().filter(topic -> topic.name() != null).forEach(topic -> topicNamesToOccurrences.put(topic.name(), Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int(topicNamesToOccurrences.getOrDefault(topic.name(), Predef$.MODULE$.int2Integer(0))))));
        return topicNamesToOccurrences;
    }

    private HashSet<String> authorizeAndPopulateTentativeResults(RequestContext requestContext, CreateTopicsRequest createTopicsRequest, HashMap<String, ErrorDetermination> possibleErrors, CreateTopicsResponseData.CreatableTopicResultCollection results) {
        ClusterAuthorizer clusterAuthorizer = new ClusterAuthorizer(this, requestContext, AclOperation.CREATE);
        HashSet<String> topicNamesToTryToCreate = new HashSet<String>();
        createTopicsRequest.data().topics().forEach(topic -> {
            CreateTopicsResponseData.CreatableTopicResult resultForTopicSoFar = new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(Errors.NONE.code());
            Option option = Option$.MODULE$.apply(possibleErrors.get(topic.name()));
            if (option instanceof Some) {
                ErrorDetermination determinedError = (ErrorDetermination)((Some)option).value();
                resultForTopicSoFar.setErrorCode(determinedError.errorCode()).setErrorMessage(determinedError.errorMessage());
            } else if (None$.MODULE$.equals(option)) {
                if (clusterAuthorizer.isAuthorized() || this.authHelper().authorize(requestContext, AclOperation.CREATE, ResourceType.TOPIC, topic.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                    topicNamesToTryToCreate.add(topic.name());
                } else {
                    resultForTopicSoFar.setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage("Authorization failed.");
                }
            } else {
                throw new MatchError((Object)option);
            }
            results.add((ImplicitLinkedHashCollection.Element)resultForTopicSoFar);
        });
        return topicNamesToTryToCreate;
    }

    private CreateTopicsRequestData.CreatableTopicCollection getFilteredBy(CreateTopicsRequest createTopicsRequest, HashSet<String> topicNamesToTryToCreate, boolean healthcheckTenant) {
        CreateTopicsRequestData.CreatableTopicCollection creatableTopicsFiltered = new CreateTopicsRequestData.CreatableTopicCollection(topicNamesToTryToCreate.size());
        Integer defaultNumPartitions = this.config.numPartitions();
        createTopicsRequest.data().topics().stream().filter(topic -> topicNamesToTryToCreate.contains(topic.name())).forEach(topic -> {
            CreateTopicsRequestData.CreatableTopic topicDuplicate;
            CreateTopicsRequestData.CreatableTopic creatableTopic = topicDuplicate = topic.numPartitions() == -1 ? topic.duplicate().setNumPartitions(Predef$.MODULE$.Integer2int(defaultNumPartitions)) : topic.duplicate();
            if (healthcheckTenant) {
                topicDuplicate.configs().clear();
            }
            if (!creatableTopicsFiltered.add((ImplicitLinkedHashCollection.Element)topicDuplicate)) {
                throw new IllegalStateException(new StringBuilder(93).append("Unable to create topic with name = ").append(topic.name()).append(" due to failure to add to collection (should never happen)").toString());
            }
        });
        return creatableTopicsFiltered;
    }

    private final void ErrorDetermination$lzycompute$1() {
        synchronized (this) {
            if (this.ErrorDetermination$module == null) {
                this.ErrorDetermination$module = new K2ControllerApis$ErrorDetermination$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ ErrorDetermination $anonfun$handleCreateTopicsRequest$2(K2ControllerApis $this) {
        return new ErrorDetermination($this, Errors.INVALID_REQUEST.code(), "Cannot create a topic with name __cluster_metadata.");
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$3(CreateTopicsRequestData.CreatableTopic t) {
        return t.linkName() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(t.linkName()));
    }

    public static final /* synthetic */ ErrorDetermination $anonfun$handleCreateTopicsRequest$5(K2ControllerApis $this) {
        return new ErrorDetermination($this, Errors.INVALID_REQUEST.code(), "Mirror topics are not supported.");
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$8(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Iterable)x0$1._2()).size() > 1;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ ErrorDetermination $anonfun$handleCreateTopicsRequest$9(K2ControllerApis $this) {
        return new ErrorDetermination($this, Errors.INVALID_REQUEST.code(), "Found multiple entries for this topic.");
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$10(CreateTopicsRequestData.CreatableTopic t) {
        return t.assignments() != null && !t.assignments().isEmpty();
    }

    public static final /* synthetic */ ErrorDetermination $anonfun$handleCreateTopicsRequest$12(K2ControllerApis $this) {
        return new ErrorDetermination($this, Errors.INVALID_REQUEST.code(), "Manual partition assignments are not supported.");
    }

    public static final /* synthetic */ boolean $anonfun$handleCreateTopicsRequest$13(K2ControllerApis $this, CreateTopicsRequestData.CreatableTopic t) {
        return t.replicationFactor() != -1 && t.replicationFactor() != $this.config.defaultReplicationFactor();
    }

    public static final /* synthetic */ ErrorDetermination $anonfun$handleCreateTopicsRequest$15(K2ControllerApis $this) {
        return new ErrorDetermination($this, Errors.INVALID_REQUEST.code(), new StringBuilder(87).append("Explicit replication factors that do not match the default value of ").append($this.config.defaultReplicationFactor()).append(" are not supported.").toString());
    }

    private final void sendResponse$1(CreateTopicsResponseData.CreatableTopicResultCollection createResult, Throwable throwable, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData.CreatableTopicResultCollection results$1, RequestChannel.Request request$1) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Processed CreateTopicsRequest ").append(createTopicsRequest$1).append(" via K2 topic metadata store. result: ").append(createResult).append(" throwable: ").append(throwable).toString());
        createResult.stream().forEach(creatableTopicResult -> {
            CreateTopicsResponseData.CreatableTopicResult originalResultForTopic = results$1.find(creatableTopicResult.name());
            originalResultForTopic.setErrorCode(throwable == null ? creatableTopicResult.errorCode() : Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable == null ? creatableTopicResult.errorMessage() : throwable.getMessage());
            boolean errored = creatableTopicResult.errorCode() != Errors.NONE.code();
            originalResultForTopic.setTopicId(creatableTopicResult.topicId()).setNumPartitions(errored ? -1 : creatableTopicResult.numPartitions()).setReplicationFactor(errored ? (short)-1 : (short)creatableTopicResult.replicationFactor()).setConfigs(creatableTopicResult.configs()).setTopicConfigErrorCode(errored ? Errors.NONE.code() : creatableTopicResult.topicConfigErrorCode());
        });
        CreateTopicsResponse response = new CreateTopicsResponse(new CreateTopicsResponseData().setTopics(results$1));
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Sending create topics response ").append(response).append(" for correlation id ").append(request$1.header().correlationId()).append(" to client ").append(request$1.header().clientId()).append(".").toString());
        this.requestHelper().sendResponseMaybeThrottle(request$1, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$6 -> response);
    }

    public static final /* synthetic */ boolean $anonfun$handleIncrementalAlterConfigsRequest$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Iterable)x0$1._2()).size() > 1;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ ErrorDetermination $anonfun$handleIncrementalAlterConfigsRequest$4(K2ControllerApis $this) {
        return new ErrorDetermination($this, Errors.INVALID_REQUEST.code(), "Each resource must appear at most once.");
    }

    public static final /* synthetic */ boolean $anonfun$handleIncrementalAlterConfigsRequest$5(HashMap firstErrorByTopic$2, IncrementalAlterConfigsRequestData.AlterConfigsResource resource) {
        return !firstErrorByTopic$2.containsKey(resource.resourceName());
    }

    public static final /* synthetic */ boolean $anonfun$handleIncrementalAlterConfigsRequest$7(IncrementalAlterConfigsRequestData.AlterableConfig config) {
        return config.name() == null || config.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleIncrementalAlterConfigsRequest$9(IncrementalAlterConfigsRequestData.AlterableConfig config) {
        return config.configOperation() != AlterConfigOp.OpType.DELETE.id() && config.value() == null;
    }

    private static final Collection getAlterConfigOps$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection configs) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)configs).asScala().map((Function1 & Serializable)alterableConfig -> new AlterConfigOp(new ConfigEntry(alterableConfig.name(), alterableConfig.value()), AlterConfigOp.OpType.forId((byte)alterableConfig.configOperation())))).toSet()).asJava();
    }

    private final void sendResponse$2(java.util.Map alterResults, Throwable throwable, IncrementalAlterConfigsRequest alterConfigsRequest$1, IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection resources$1, HashMap firstErrorByTopic$2, RequestChannel.Request request$2) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(91).append("Processed IncrementalAlterConfigsRequest ").append(alterConfigsRequest$1).append(" via K2 topic metadata store. result: ").append(alterResults).append(" throwable: ").append(throwable).toString());
        List results = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resources$1).asScala().map((Function1 & Serializable)resource -> {
            String topicName = resource.resourceName();
            Option option = Option$.MODULE$.apply(firstErrorByTopic$2.get(topicName));
            if (option instanceof Some) {
                ErrorDetermination errorDetermination = (ErrorDetermination)((Some)option).value();
                return new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setErrorCode(errorDetermination.errorCode()).setErrorMessage(errorDetermination.errorMessage());
            }
            if (None$.MODULE$.equals(option)) {
                ApiError alterResult = (ApiError)alterResults.get(topicName);
                return new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setErrorCode(throwable == null ? alterResult.error().code() : Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable == null ? alterResult.error().message() : throwable.getMessage());
            }
            throw new MatchError((Object)option);
        })).toList()).asJava();
        IncrementalAlterConfigsResponse response = new IncrementalAlterConfigsResponse(new IncrementalAlterConfigsResponseData());
        response.data().setResponses(results);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Sending incremental alter configs response ").append(response).append(" for correlation id ").append(request$2.header().correlationId()).append(" to client ").append(request$2.header().clientId()).append(".").toString());
        this.requestHelper().sendResponseMaybeThrottle(request$2, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$9 -> response);
    }

    public static final /* synthetic */ boolean $anonfun$handleLegacyAlterConfigsRequest$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Iterable)x0$1._2()).size() > 1;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ ErrorDetermination $anonfun$handleLegacyAlterConfigsRequest$4(K2ControllerApis $this) {
        return new ErrorDetermination($this, Errors.INVALID_REQUEST.code(), "Each resource must appear at most once.");
    }

    public static final /* synthetic */ boolean $anonfun$handleLegacyAlterConfigsRequest$5(HashMap firstErrorByTopic$3, AlterConfigsRequestData.AlterConfigsResource resource) {
        return !firstErrorByTopic$3.containsKey(resource.resourceName());
    }

    public static final /* synthetic */ boolean $anonfun$handleLegacyAlterConfigsRequest$7(AlterConfigsRequestData.AlterableConfig config) {
        return config.name() == null || config.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleLegacyAlterConfigsRequest$9(AlterConfigsRequestData.AlterableConfig config) {
        return config.value() == null;
    }

    private static final Collection getAlterConfigOps$2(AlterConfigsRequestData.AlterableConfigCollection configs) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)configs).asScala().map((Function1 & Serializable)alterableConfig -> new AlterConfigOp(new ConfigEntry(alterableConfig.name(), alterableConfig.value()), AlterConfigOp.OpType.SET))).toSet()).asJava();
    }

    private final void sendResponse$3(java.util.Map alterResults, Throwable throwable, AlterConfigsRequest alterConfigsRequest$2, AlterConfigsRequestData.AlterConfigsResourceCollection resources$2, HashMap firstErrorByTopic$3, RequestChannel.Request request$3) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Processed AlterConfigsRequest ").append(alterConfigsRequest$2).append(" via K2 topic metadata store. result: ").append(alterResults).append(" throwable: ").append(throwable).toString());
        List results = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resources$2).asScala().map((Function1 & Serializable)resource -> {
            String topicName = resource.resourceName();
            Option option = Option$.MODULE$.apply(firstErrorByTopic$3.get(topicName));
            if (option instanceof Some) {
                ErrorDetermination errorDetermination = (ErrorDetermination)((Some)option).value();
                return new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setErrorCode(errorDetermination.errorCode()).setErrorMessage(errorDetermination.errorMessage());
            }
            if (None$.MODULE$.equals(option)) {
                ApiError alterResult = (ApiError)alterResults.get(topicName);
                return new AlterConfigsResponseData.AlterConfigsResourceResponse().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setErrorCode(throwable == null ? alterResult.error().code() : Errors.forException((Throwable)throwable).code()).setErrorMessage(throwable == null ? alterResult.error().message() : throwable.getMessage());
            }
            throw new MatchError((Object)option);
        })).toList()).asJava();
        AlterConfigsResponse response = new AlterConfigsResponse(new AlterConfigsResponseData());
        response.data().setResponses(results);
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Sending alter configs response ").append(response).append(" for correlation id ").append(request$3.header().correlationId()).append(" to client ").append(request$3.header().clientId()).append(".").toString());
        this.requestHelper().sendResponseMaybeThrottle(request$3, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$12 -> response);
    }

    private static final boolean hasTopicName$1(DeleteTopicsRequestData.DeleteTopicState topic) {
        return topic.name() != null;
    }

    private static final boolean hasTopicId$1(DeleteTopicsRequestData.DeleteTopicState topic) {
        return !topic.topicId().equals((Object)Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ boolean $anonfun$handleDeleteTopicsRequest$6(K2TopicMetadata k2tm) {
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = k2tm.k2TopicLifecycleState();
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
        return !(k2TopicLifecycleState != null ? !k2TopicLifecycleState.equals(k2TopicLifecycleState2) : k2TopicLifecycleState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleDeleteTopicsRequest$8(K2TopicMetadata k2tm) {
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = k2tm.k2TopicLifecycleState();
        K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
        return !(k2TopicLifecycleState != null ? !k2TopicLifecycleState.equals(k2TopicLifecycleState2) : k2TopicLifecycleState2 != null);
    }

    private static final void addResponse$1(String name, Uuid id, ApiError error, HashSet responses$1) {
        responses$1.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private final void sendResponses$1(HashSet responses$1, RequestChannel.Request request$4) {
        DeleteTopicsResponseData.DeletableTopicResultCollection collection = new DeleteTopicsResponseData.DeletableTopicResultCollection();
        responses$1.forEach(x$1 -> collection.add((ImplicitLinkedHashCollection.Element)x$1));
        DeleteTopicsResponse responseToSend = new DeleteTopicsResponse(new DeleteTopicsResponseData().setResponses(collection));
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Sending delete topics response ").append(responseToSend).append(" for correlation id ").append(request$4.header().correlationId()).append(" to client ").append(request$4.header().clientId()).append(".").toString());
        this.requestHelper().sendResponseMaybeThrottle(request$4, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$13 -> responseToSend);
    }

    private final void maybeTryToDeleteTopicsAndSendResponse$1(java.util.Set topicMetadataForDeletions, Throwable throwable2, RequestChannel.Request request$4, DeleteTopicsRequest deleteTopicsRequest$1, HashMap nonNullTopicNamesToOccurrenceMap$1, HashMap nonZeroTopicIdsToOccurrenceMap$1) {
        scala.collection.immutable.Map topicMetadataByName = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(topicMetadataForDeletions).asScala().filter((Function1 & Serializable)k2tm -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleDeleteTopicsRequest$6(k2tm)))).map((Function1 & Serializable)k2tm -> new Tuple2((Object)k2tm.topicName(), k2tm))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map topicMetadataById = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(topicMetadataForDeletions).asScala().filter((Function1 & Serializable)k2tm -> BoxesRunTime.boxToBoolean((boolean)K2ControllerApis.$anonfun$handleDeleteTopicsRequest$8(k2tm)))).map((Function1 & Serializable)k2tm -> new Tuple2((Object)k2tm.topicId(), k2tm))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashSet responses = new HashSet();
        HashSet potentiallyAuthorizeTopicNames = new HashSet();
        HashSet potentiallyAuthorizeTopicIds = new HashSet();
        deleteTopicsRequest$1.topics().forEach(topic -> {
            if (!K2ControllerApis.hasTopicName$1(topic) && !K2ControllerApis.hasTopicId$1(topic)) {
                K2ControllerApis.addResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic) && K2ControllerApis.hasTopicId$1(topic)) {
                K2ControllerApis.addResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic) && Predef$.MODULE$.Integer2int((Integer)nonNullTopicNamesToOccurrenceMap$1.get(topic.name())) > 1) {
                K2ControllerApis.addResponse$1(topic.name(), Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicId$1(topic) && Predef$.MODULE$.Integer2int((Integer)nonZeroTopicIdsToOccurrenceMap$1.get(topic.topicId())) > 1) {
                K2ControllerApis.addResponse$1(null, topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses);
                return;
            }
            if (K2ControllerApis.hasTopicName$1(topic)) {
                if (throwable2 == null && !topicMetadataByName.contains((Object)topic.name())) {
                    K2ControllerApis.addResponse$1(topic.name(), Uuid.ZERO_UUID, new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION), responses);
                    return;
                }
                potentiallyAuthorizeTopicNames.add(topic.name());
                return;
            }
            if (throwable2 == null && !topicMetadataById.contains((Object)topic.topicId())) {
                K2ControllerApis.addResponse$1(null, topic.topicId(), new ApiError(Errors.UNKNOWN_TOPIC_ID), responses);
                return;
            }
            potentiallyAuthorizeTopicIds.add(topic.topicId());
        });
        if (throwable2 != null) {
            ApiError apiError = ApiError.fromThrowable((Throwable)throwable2);
            potentiallyAuthorizeTopicNames.forEach(topicName -> K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, apiError, responses));
            potentiallyAuthorizeTopicIds.forEach(topicId -> K2ControllerApis.addResponse$1(null, topicId, apiError, responses));
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(121).append("Received exception during processing of DeleteTopicsRequest while retrieving K2 topic metadata for topics: ").append("{").append(String.join((CharSequence)",", topicMetadataForDeletions.toString())).append("} throwable: ").append(throwable2).toString());
            this.sendResponses$1(responses, request$4);
            return;
        }
        ClusterAuthorizer clusterAuthorizer = new ClusterAuthorizer(this, request$4.context(), AclOperation.DELETE);
        HashMap authorizedTopicMetadata = new HashMap();
        potentiallyAuthorizeTopicNames.forEach(topicName -> {
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$4.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, (String)topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$4.context(), AclOperation.DELETE, ResourceType.TOPIC, (String)topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$1(topicName, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            K2TopicMetadata topicMetadata = (K2TopicMetadata)topicMetadataByName.apply(topicName);
            Uuid topicId = topicMetadata.topicId();
            if (potentiallyAuthorizeTopicIds.contains(topicId)) {
                K2ControllerApis.addResponse$1(topicName, topicId, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses);
                return;
            }
            authorizedTopicMetadata.put(topicId, Predef$.MODULE$.int2Integer(this.totalRequestedPartitions(topicMetadata)));
        });
        potentiallyAuthorizeTopicIds.forEach(topicId -> {
            K2TopicMetadata topicMetadata = (K2TopicMetadata)topicMetadataById.apply(topicId);
            String topicName = topicMetadata.topicName();
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$4.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$1(null, topicId, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            if (!(clusterAuthorizer.isAuthorized() || this.authHelper().authorize(request$4.context(), AclOperation.DELETE, ResourceType.TOPIC, topicName, this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7()))) {
                K2ControllerApis.addResponse$1(topicName, topicId, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                return;
            }
            if (!potentiallyAuthorizeTopicNames.contains(topicName)) {
                authorizedTopicMetadata.put(topicId, Predef$.MODULE$.int2Integer(this.totalRequestedPartitions(topicMetadata)));
                return;
            }
        });
        if (authorizedTopicMetadata.isEmpty()) {
            this.sendResponses$1(responses, request$4);
            return;
        }
        this.controllerRequestHandler.deleteTopics(authorizedTopicMetadata).whenCompleteAsyncRaw((deleteResult, throwable) -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(102).append("Processed DeleteTopicsRequest for authorized topics ").append(authorizedTopicMetadata).append(" via K2 topic metadata store. result: ").append(deleteResult).append(" throwable: ").append(throwable).toString());
            authorizedTopicMetadata.keySet().forEach(topicId -> {
                String topicName = ((K2TopicMetadata)topicMetadataById.apply(topicId)).topicName();
                if (deleteResult.containsKey(topicId)) {
                    ApiError apiError = throwable != null ? ApiError.fromThrowable((Throwable)throwable) : (ApiError)deleteResult.get(topicId);
                    K2ControllerApis.addResponse$1(topicName, topicId, apiError, responses);
                    return;
                }
                K2ControllerApis.addResponse$1(topicName, topicId, new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION), responses);
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Missing result for topic: ").append(topicName).append(", topicId: ").append(topicId).append(" from controller (should never happen).").toString());
            });
            this.sendResponses$1(responses, request$4);
        }, this.executor);
    }

    private static final void addResponse$2(String name, short errorCode, String errorMessage, ArrayList responses$2) {
        responses$2.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(name).setErrorCode(errorCode).setErrorMessage(errorMessage));
    }

    private final void sendResponses$2(ArrayList responses$2, RequestChannel.Request request$5) {
        CreatePartitionsResponse responseToSend = new CreatePartitionsResponse(new CreatePartitionsResponseData().setResults((List)responses$2));
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Sending create partitions response ").append(responseToSend).append(" for correlation id ").append(request$5.header().correlationId()).append(" to client ").append(request$5.header().clientId()).append(".").toString());
        this.requestHelper().sendResponseMaybeThrottle(request$5, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$14 -> responseToSend);
    }

    public static final /* synthetic */ boolean $anonfun$handleCreatePartitionsRequest$5(CreatePartitionsRequestData.CreatePartitionsTopic topic) {
        return topic.assignments() != null && !topic.assignments().isEmpty();
    }

    private final void maybeTryToCreatePartitionsAndSendResponse$1(java.util.Set topicMetadataForPartitionCreations, Throwable throwable2, HashSet authorizedTopics$1, HashMap validCreatePartitionsTopics$1, boolean validateOnly$1, ArrayList responses$2, RequestChannel.Request request$5) {
        if (throwable2 != null) {
            ApiError apiError = ApiError.fromThrowable((Throwable)throwable2);
            authorizedTopics$1.forEach(topicName -> K2ControllerApis.addResponse$2(topicName, apiError.error().code(), apiError.message(), responses$2));
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(125).append("Received exception during processing of CreatePartitionsRequest while retrieving K2 topic metadata for topics: {").append(authorizedTopics$1.toString()).append("} throwable: ").append(throwable2).toString());
            this.sendResponses$2(responses$2, request$5);
            return;
        }
        scala.collection.immutable.Map topicMetadataByName = ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(topicMetadataForPartitionCreations).asScala().map((Function1 & Serializable)k2tm -> new Tuple2((Object)k2tm.topicName(), k2tm))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        HashMap authorizedValidTopics = new HashMap();
        authorizedTopics$1.forEach(topicName -> {
            if (!topicMetadataByName.keySet().contains(topicName)) {
                K2ControllerApis.addResponse$2(topicName, Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), Errors.UNKNOWN_TOPIC_OR_PARTITION.message(), responses$2);
                return;
            }
            CreatePartitionsRequestData.CreatePartitionsTopic topic = (CreatePartitionsRequestData.CreatePartitionsTopic)validCreatePartitionsTopics$1.get(topicName);
            K2TopicMetadata topicMetadata = (K2TopicMetadata)topicMetadataByName.apply(topicName);
            int currentNumPartitions = this.totalRequestedPartitions(topicMetadata);
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState = topicMetadata.k2TopicLifecycleState();
            K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState2 = K2TopicMetadata.K2TopicLifecycleState.ONLINE;
            if (k2TopicLifecycleState == null ? k2TopicLifecycleState2 != null : !k2TopicLifecycleState.equals(k2TopicLifecycleState2)) {
                K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState3 = topicMetadata.k2TopicLifecycleState();
                K2TopicMetadata.K2TopicLifecycleState k2TopicLifecycleState4 = K2TopicMetadata.K2TopicLifecycleState.CREATING;
                if (k2TopicLifecycleState3 == null ? k2TopicLifecycleState4 != null : !k2TopicLifecycleState3.equals(k2TopicLifecycleState4)) {
                    K2ControllerApis.addResponse$2(topicName, Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), Errors.UNKNOWN_TOPIC_OR_PARTITION.message(), responses$2);
                    return;
                }
            }
            if (topic.count() <= currentNumPartitions) {
                K2ControllerApis.addResponse$2(topicName, Errors.INVALID_PARTITIONS.code(), new StringBuilder(66).append("The topic ").append((String)topicName).append(" currently has ").append(currentNumPartitions).append(" partition(s); ").append(topic.count()).append(" would not be an increase.").toString(), responses$2);
                return;
            }
            authorizedValidTopics.put(topicName, Arrays.asList(Predef$.MODULE$.int2Integer(currentNumPartitions), Predef$.MODULE$.int2Integer(topic.count())));
        });
        if (authorizedValidTopics.isEmpty()) {
            this.sendResponses$2(responses$2, request$5);
            return;
        }
        this.controllerRequestHandler.createAdditionalPartitions(authorizedValidTopics, validateOnly$1, Predef$.MODULE$.Boolean2boolean(this.config.applyCreateTopicsPolicyToCreatePartitions())).whenCompleteAsyncRaw((partitionCreationResult, throwable) -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(108).append("Processed CreatePartitionsRequest for authorized topics {").append(authorizedValidTopics.toString()).append("} via K2 topic metadata store. ").append("Result: ").append(Utils.mkString((java.util.Map)partitionCreationResult, (String)"{", (String)"}", (String)",", (String)"=")).append(" throwable: ").append(throwable).toString());
            if (throwable != null) {
                ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                authorizedValidTopics.keySet().forEach(topicName -> K2ControllerApis.addResponse$2(topicName, apiError.error().code(), apiError.message(), responses$2));
            } else {
                authorizedValidTopics.keySet().forEach(topicName -> {
                    if (partitionCreationResult.containsKey(topicName)) {
                        ApiError apiError = (ApiError)partitionCreationResult.get(topicName);
                        K2ControllerApis.addResponse$2(topicName, apiError.error().code(), apiError.message(), responses$2);
                        return;
                    }
                    K2ControllerApis.addResponse$2(topicName, Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), Errors.UNKNOWN_TOPIC_OR_PARTITION.message(), responses$2);
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Missing result for topic ").append((String)topicName).append(" from controller (should never happen).").toString());
                });
            }
            this.sendResponses$2(responses$2, request$5);
        }, this.executor);
    }

    public K2ControllerApis(RequestChannel requestChannel, int brokerId, KafkaConfig config, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, Time time, K2ControllerHandler controllerRequestHandler, Executor executor) {
        this.config = config;
        this.controllerRequestHandler = controllerRequestHandler;
        this.executor = executor;
        this.logIdent_$eq(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[K2ControllerApis-%d] "), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time);
        this.authHelper = new AuthHelper(authorizer);
    }

    private class ClusterAuthorizer {
        private final RequestContext requestContext;
        private final AclOperation operation;
        private Option<Object> hasClusterAuthorization;
        public final /* synthetic */ K2ControllerApis $outer;

        private Option<Object> hasClusterAuthorization() {
            return this.hasClusterAuthorization;
        }

        private void hasClusterAuthorization_$eq(Option<Object> x$1) {
            this.hasClusterAuthorization = x$1;
        }

        public boolean isAuthorized() {
            Option<Object> option = this.hasClusterAuthorization();
            if (option instanceof Some) {
                return BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            }
            if (None$.MODULE$.equals(option)) {
                RequestContext x$1 = this.requestContext;
                AclOperation x$2 = this.operation;
                boolean x$6 = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize$default$5();
                int x$7 = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize$default$7();
                boolean authorized = this.kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer().authHelper().authorize(x$1, x$2, ResourceType.CLUSTER, "kafka-cluster", x$6, false, x$7);
                this.hasClusterAuthorization_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)authorized)));
                return authorized;
            }
            throw new MatchError(option);
        }

        public /* synthetic */ K2ControllerApis kafka$server$K2ControllerApis$ClusterAuthorizer$$$outer() {
            return this.$outer;
        }

        public ClusterAuthorizer(K2ControllerApis $outer, RequestContext requestContext, AclOperation operation) {
            this.requestContext = requestContext;
            this.operation = operation;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.hasClusterAuthorization = None$.MODULE$;
        }
    }

    private class ErrorDetermination
    implements Product,
    Serializable {
        private final short errorCode;
        private final String errorMessage;
        public final /* synthetic */ K2ControllerApis $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public ErrorDetermination copy(short errorCode, String errorMessage) {
            return new ErrorDetermination(this.kafka$server$K2ControllerApis$ErrorDetermination$$$outer(), errorCode, errorMessage);
        }

        public short copy$default$1() {
            return this.errorCode();
        }

        public String copy$default$2() {
            return this.errorMessage();
        }

        public String productPrefix() {
            return "ErrorDetermination";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToShort((short)this.errorCode());
                }
                case 1: {
                    return this.errorMessage();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ErrorDetermination;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "errorCode";
                }
                case 1: {
                    return "errorMessage";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)this.errorCode()), (int)Statics.anyHash((Object)this.errorMessage())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ErrorDetermination && ((ErrorDetermination)x$1).kafka$server$K2ControllerApis$ErrorDetermination$$$outer() == this.kafka$server$K2ControllerApis$ErrorDetermination$$$outer())) break block3;
                    ErrorDetermination errorDetermination = (ErrorDetermination)x$1;
                    if (this.errorCode() != errorDetermination.errorCode()) break block3;
                    String string = this.errorMessage();
                    String string2 = errorDetermination.errorMessage();
                    if ((string != null ? !string.equals(string2) : string2 != null) || !errorDetermination.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ K2ControllerApis kafka$server$K2ControllerApis$ErrorDetermination$$$outer() {
            return this.$outer;
        }

        public ErrorDetermination(K2ControllerApis $outer, short errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

